"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DualListSelectorPane = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const dual_list_selector_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/DualListSelector/dual-list-selector"));
const react_styles_1 = require("@patternfly/react-styles");
const DualListSelectorTree_1 = require("./DualListSelectorTree");
const helpers_1 = require("../../../helpers");
const DualListSelectorListWrapper_1 = require("./DualListSelectorListWrapper");
const DualListSelectorContext_1 = require("./DualListSelectorContext");
const DualListSelectorList_1 = require("./DualListSelectorList");
const SearchInput_1 = require("../../../components/SearchInput");
const c_dual_list_selector__menu_MinHeight_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/c_dual_list_selector__menu_MinHeight'));
const DualListSelectorPane = (_a) => {
    var { isChosen = false, className = '', status = '', actions, searchInput, children, onOptionSelect, onOptionCheck, title = '', options = [], selectedOptions = [], isSearchable = false, searchInputAriaLabel = '', onFilterUpdate, onSearchInputChanged, onSearchInputClear, filterOption, id = (0, helpers_1.getUniqueId)('dual-list-selector-pane'), isDisabled = false, listMinHeight } = _a, props = tslib_1.__rest(_a, ["isChosen", "className", "status", "actions", "searchInput", "children", "onOptionSelect", "onOptionCheck", "title", "options", "selectedOptions", "isSearchable", "searchInputAriaLabel", "onFilterUpdate", "onSearchInputChanged", "onSearchInputClear", "filterOption", "id", "isDisabled", "listMinHeight"]);
    const [input, setInput] = (0, react_1.useState)('');
    const { isTree } = (0, react_1.useContext)(DualListSelectorContext_1.DualListSelectorContext);
    // only called when search input is dynamically built
    const onChange = (e, newValue) => {
        let filtered;
        if (isTree) {
            filtered = options
                .map((opt) => Object.assign({}, opt))
                .filter((item) => filterInput(item, newValue));
        }
        else {
            filtered = options.filter((option) => {
                if (displayOption(option)) {
                    return option;
                }
            });
        }
        onFilterUpdate(filtered, isChosen ? 'chosen' : 'available', newValue === '');
        if (onSearchInputChanged) {
            onSearchInputChanged(e, newValue);
        }
        setInput(newValue);
    };
    // only called when options are passed via options prop and isTree === true
    const filterInput = (item, input) => {
        if (filterOption) {
            return filterOption(item, input);
        }
        else {
            if (item.text.toLowerCase().includes(input.toLowerCase()) || input === '') {
                return true;
            }
        }
        if (item.children) {
            return ((item.children = item.children
                .map((opt) => Object.assign({}, opt))
                .filter((child) => filterInput(child, input))).length > 0);
        }
    };
    // only called when options are passed via options prop and isTree === false
    const displayOption = (option) => {
        if (filterOption) {
            return filterOption(option, input);
        }
        else {
            return option.toString().toLowerCase().includes(input.toLowerCase());
        }
    };
    return ((0, jsx_runtime_1.jsxs)("div", Object.assign({ className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorPane, isChosen ? dual_list_selector_1.default.modifiers.chosen : 'pf-m-available', className) }, props, { children: [title && ((0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorHeader), children: (0, jsx_runtime_1.jsx)("div", { className: `${dual_list_selector_1.default.dualListSelector}__title`, children: (0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorTitleText), children: title }) }) })), (actions || searchInput || isSearchable) && ((0, jsx_runtime_1.jsxs)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorTools), children: [(isSearchable || searchInput) && ((0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorToolsFilter), children: searchInput ? (searchInput) : ((0, jsx_runtime_1.jsx)(SearchInput_1.SearchInput, { onChange: isDisabled ? undefined : onChange, onClear: onSearchInputClear
                                ? onSearchInputClear
                                : (e) => onChange(e, ''), isDisabled: isDisabled, "aria-label": searchInputAriaLabel })) })), actions && (0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorToolsActions), children: actions })] })), status && ((0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorStatus), children: (0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(dual_list_selector_1.default.dualListSelectorStatusText), id: `${id}-status`, children: status }) })), (0, jsx_runtime_1.jsxs)(DualListSelectorContext_1.DualListSelectorPaneContext.Provider, { value: { isChosen }, children: [!isTree && ((0, jsx_runtime_1.jsx)(DualListSelectorListWrapper_1.DualListSelectorListWrapper, Object.assign({ "aria-labelledby": `${id}-status`, options: options, selectedOptions: selectedOptions, onOptionSelect: (e, index, id) => onOptionSelect(e, index, isChosen, id), displayOption: displayOption, id: `${id}-list`, isDisabled: isDisabled }, (listMinHeight && {
                        style: { [c_dual_list_selector__menu_MinHeight_1.default.name]: listMinHeight }
                    }), { children: children }))), isTree && ((0, jsx_runtime_1.jsx)(DualListSelectorListWrapper_1.DualListSelectorListWrapper, Object.assign({ "aria-labelledby": `${id}-status`, id: `${id}-list` }, (listMinHeight && {
                        style: { [c_dual_list_selector__menu_MinHeight_1.default.name]: listMinHeight }
                    }), { children: options.length > 0 ? ((0, jsx_runtime_1.jsx)(DualListSelectorList_1.DualListSelectorList, { children: (0, jsx_runtime_1.jsx)(DualListSelectorTree_1.DualListSelectorTree, { data: isSearchable
                                    ? options
                                        .map((opt) => Object.assign({}, opt))
                                        .filter((item) => filterInput(item, input))
                                    : options, onOptionCheck: onOptionCheck, id: `${id}-tree`, isDisabled: isDisabled }) })) : (children) })))] })] })));
};
exports.DualListSelectorPane = DualListSelectorPane;
exports.DualListSelectorPane.displayName = 'DualListSelectorPane';
//# sourceMappingURL=DualListSelectorPane.js.map