// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains counts of vulnerability findings from image scans that run when you
// create new Image Builder images, or build new versions of existing images. The
// vulnerability counts are grouped by severity level. The counts are aggregated
// across resources to create the final tally for the account that owns them.
type AccountAggregation struct {

	// Identifies the account that owns the aggregated resource findings.
	AccountId *string

	// Counts by severity level for medium severity and higher level findings, plus a
	// total for all of the findings.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// In addition to your infrastructure configuration, these settings provide an
// extra layer of control over your build instances. You can also specify commands
// to run on launch for all of your build instances.
//
// Image Builder does not automatically install the Systems Manager agent on
// Windows instances. If your base image includes the Systems Manager agent, then
// the AMI that you create will also include the agent. For Linux instances, if the
// base image does not already include the Systems Manager agent, Image Builder
// installs it. For Linux instances where Image Builder installs the Systems
// Manager agent, you can choose whether to keep it for the AMI that you create.
type AdditionalInstanceConfiguration struct {

	// Contains settings for the Systems Manager agent on your build instance.
	SystemsManagerAgent *SystemsManagerAgent

	// Use this property to provide commands or a command script to run when you
	// launch your build instance.
	//
	// The userDataOverride property replaces any commands that Image Builder might
	// have added to ensure that Systems Manager is installed on your Linux build
	// instance. If you override the user data, make sure that you add commands to
	// install Systems Manager, if it is not pre-installed on your base image.
	//
	// The user data is always base 64 encoded. For example, the following commands
	// are encoded as IyEvYmluL2Jhc2gKbWtkaXIgLXAgL3Zhci9iYi8KdG91Y2ggL3Zhci$ :
	//
	// #!/bin/bash
	//
	// mkdir -p /var/bb/
	//
	// touch /var
	UserDataOverride *string

	noSmithyDocumentSerde
}

// Details of an Amazon EC2 AMI.
type Ami struct {

	// The account ID of the owner of the AMI.
	AccountId *string

	// The description of the Amazon EC2 AMI. Minimum and maximum length are in
	// characters.
	Description *string

	// The AMI ID of the Amazon EC2 AMI.
	Image *string

	// The name of the Amazon EC2 AMI.
	Name *string

	// The Amazon Web Services Region of the Amazon EC2 AMI.
	Region *string

	// Image status and the reason for that status.
	State *ImageState

	noSmithyDocumentSerde
}

// Define and configure the output AMIs of the pipeline.
type AmiDistributionConfiguration struct {

	// The tags to apply to AMIs distributed to this Region.
	AmiTags map[string]string

	// The description of the AMI distribution configuration. Minimum and maximum
	// length are in characters.
	Description *string

	// The KMS key identifier used to encrypt the distributed image.
	KmsKeyId *string

	// Launch permissions can be used to configure which Amazon Web Services accounts
	// can use the AMI to launch instances.
	LaunchPermission *LaunchPermissionConfiguration

	// The name of the output AMI.
	Name *string

	// The ID of an account to which you want to distribute an image.
	TargetAccountIds []string

	noSmithyDocumentSerde
}

// A detailed view of a component.
type Component struct {

	// The Amazon Resource Name (ARN) of the component.
	Arn *string

	// Describes what change has been made in this version of the component, or what
	// makes this version different from other versions of the component.
	ChangeDescription *string

	// Component data contains the YAML document content for the component.
	Data *string

	// The date that Image Builder created the component.
	DateCreated *string

	// The description of the component.
	Description *string

	// The encryption status of the component.
	Encrypted *bool

	// The KMS key identifier used to encrypt the component.
	KmsKeyId *string

	// The name of the component.
	Name *string

	// Indicates whether component source is hidden from view in the console, and from
	// component detail results for API, CLI, or SDK operations.
	Obfuscate bool

	// The owner of the component.
	Owner *string

	// Contains parameter details for each of the parameters that the component
	// document defined for the component.
	Parameters []ComponentParameterDetail

	// The operating system platform of the component.
	Platform Platform

	// Contains the name of the publisher if this is a third-party component.
	// Otherwise, this property is empty.
	Publisher *string

	// Describes the current status of the component. This is used for components that
	// are no longer active.
	State *ComponentState

	// The operating system (OS) version supported by the component. If the OS
	// information is available, Image Builder performs a prefix match against the base
	// image OS version during image recipe creation.
	SupportedOsVersions []string

	// The tags that apply to the component.
	Tags map[string]string

	// The component type specifies whether Image Builder uses the component to build
	// the image or only to test it.
	Type ComponentType

	// The version of the component.
	Version *string

	noSmithyDocumentSerde
}

// Configuration details of the component.
type ComponentConfiguration struct {

	// The Amazon Resource Name (ARN) of the component.
	//
	// This member is required.
	ComponentArn *string

	// A group of parameter settings that Image Builder uses to configure the
	// component for a specific recipe.
	Parameters []ComponentParameter

	noSmithyDocumentSerde
}

// Contains a key/value pair that sets the named component parameter.
type ComponentParameter struct {

	// The name of the component parameter to set.
	//
	// This member is required.
	Name *string

	// Sets the value for the named component parameter.
	//
	// This member is required.
	Value []string

	noSmithyDocumentSerde
}

// Defines a parameter that is used to provide configuration details for the
// component.
type ComponentParameterDetail struct {

	// The name of this input parameter.
	//
	// This member is required.
	Name *string

	// The type of input this parameter provides. The currently supported value is
	// "string".
	//
	// This member is required.
	Type *string

	// The default value of this parameter if no input is provided.
	DefaultValue []string

	// Describes this parameter.
	Description *string

	noSmithyDocumentSerde
}

// A group of fields that describe the current status of components.
type ComponentState struct {

	// Describes how or why the component changed state.
	Reason *string

	// The current state of the component.
	Status ComponentStatus

	noSmithyDocumentSerde
}

// A high-level summary of a component.
type ComponentSummary struct {

	// The Amazon Resource Name (ARN) of the component.
	Arn *string

	// The change description for the current version of the component.
	ChangeDescription *string

	// The original creation date of the component.
	DateCreated *string

	// The description of the component.
	Description *string

	// The name of the component.
	Name *string

	// Indicates whether component source is hidden from view in the console, and from
	// component detail results for API, CLI, or SDK operations.
	Obfuscate bool

	// The owner of the component.
	Owner *string

	// The operating system platform of the component.
	Platform Platform

	// Contains the name of the publisher if this is a third-party component.
	// Otherwise, this property is empty.
	Publisher *string

	// Describes the current status of the component.
	State *ComponentState

	// The operating system (OS) version that the component supports. If the OS
	// information is available, Image Builder performs a prefix match against the base
	// image OS version during image recipe creation.
	SupportedOsVersions []string

	// The tags that apply to the component.
	Tags map[string]string

	// The component type specifies whether Image Builder uses the component to build
	// the image or only to test it.
	Type ComponentType

	// The version of the component.
	Version *string

	noSmithyDocumentSerde
}

// The defining characteristics of a specific version of an Amazon Web Services
// TOE component.
type ComponentVersion struct {

	// The Amazon Resource Name (ARN) of the component.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN), at
	// the level that applies to that object as follows:
	//
	//   - Versionless ARNs and Name ARNs do not include specific values in any of the
	//   nodes. The nodes are either left off entirely, or they are specified as
	//   wildcards, for example: x.x.x.
	//
	//   - Version ARNs have only the first three nodes: ..
	//
	//   - Build version ARNs have all four nodes, and point to a specific build for a
	//   specific version of an object.
	Arn *string

	// The date that the component was created.
	DateCreated *string

	// The description of the component.
	Description *string

	// The name of the component.
	Name *string

	// The owner of the component.
	Owner *string

	// The platform of the component.
	Platform Platform

	// he operating system (OS) version supported by the component. If the OS
	// information is available, a prefix match is performed against the base image OS
	// version during image recipe creation.
	SupportedOsVersions []string

	// The type of the component denotes whether the component is used to build the
	// image or only to test it.
	Type ComponentType

	// The semantic version of the component.
	//
	// The semantic version has four nodes: ../. You can assign values for the first
	// three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose a
	// software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base image
	// or components for your recipe. When you use a wildcard in any node, all nodes to
	// the right of the first wildcard must also be wildcards.
	Version *string

	noSmithyDocumentSerde
}

// A container encapsulates the runtime environment for an application.
type Container struct {

	// A list of URIs for containers created in the context Region.
	ImageUris []string

	// Containers and container images are Region-specific. This is the Region context
	// for the container.
	Region *string

	noSmithyDocumentSerde
}

// Container distribution settings for encryption, licensing, and sharing in a
// specific Region.
type ContainerDistributionConfiguration struct {

	// The destination repository for the container distribution configuration.
	//
	// This member is required.
	TargetRepository *TargetContainerRepository

	// Tags that are attached to the container distribution configuration.
	ContainerTags []string

	// The description of the container distribution configuration.
	Description *string

	noSmithyDocumentSerde
}

// A container recipe.
type ContainerRecipe struct {

	// The Amazon Resource Name (ARN) of the container recipe.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN), at
	// the level that applies to that object as follows:
	//
	//   - Versionless ARNs and Name ARNs do not include specific values in any of the
	//   nodes. The nodes are either left off entirely, or they are specified as
	//   wildcards, for example: x.x.x.
	//
	//   - Version ARNs have only the first three nodes: ..
	//
	//   - Build version ARNs have all four nodes, and point to a specific build for a
	//   specific version of an object.
	Arn *string

	// Build and test components that are included in the container recipe. Recipes
	// require a minimum of one build component, and can have a maximum of 20 build and
	// test components in any combination.
	Components []ComponentConfiguration

	// Specifies the type of container, such as Docker.
	ContainerType ContainerType

	// The date when this container recipe was created.
	DateCreated *string

	// The description of the container recipe.
	Description *string

	// Dockerfiles are text documents that are used to build Docker containers, and
	// ensure that they contain all of the elements required by the application running
	// inside. The template data consists of contextual variables where Image Builder
	// places build information or scripts, based on your container image recipe.
	DockerfileTemplateData *string

	// A flag that indicates if the target container is encrypted.
	Encrypted *bool

	// A group of options that can be used to configure an instance for building and
	// testing container images.
	InstanceConfiguration *InstanceConfiguration

	// Identifies which KMS key is used to encrypt the container image for
	// distribution to the target Region.
	KmsKeyId *string

	// The name of the container recipe.
	Name *string

	// The owner of the container recipe.
	Owner *string

	// The base image for the container recipe.
	ParentImage *string

	// The system platform for the container, such as Windows or Linux.
	Platform Platform

	// Tags that are attached to the container recipe.
	Tags map[string]string

	// The destination repository for the container image.
	TargetRepository *TargetContainerRepository

	// The semantic version of the container recipe.
	//
	// The semantic version has four nodes: ../. You can assign values for the first
	// three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose a
	// software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base image
	// or components for your recipe. When you use a wildcard in any node, all nodes to
	// the right of the first wildcard must also be wildcards.
	Version *string

	// The working directory for use during build and test workflows.
	WorkingDirectory *string

	noSmithyDocumentSerde
}

// A summary of a container recipe
type ContainerRecipeSummary struct {

	// The Amazon Resource Name (ARN) of the container recipe.
	Arn *string

	// Specifies the type of container, such as "Docker".
	ContainerType ContainerType

	// The date when this container recipe was created.
	DateCreated *string

	// The name of the container recipe.
	Name *string

	// The owner of the container recipe.
	Owner *string

	// The base image for the container recipe.
	ParentImage *string

	// The system platform for the container, such as Windows or Linux.
	Platform Platform

	// Tags that are attached to the container recipe.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Amazon Inspector generates a risk score for each finding. This score helps you
// to prioritize findings, to focus on the most critical findings and the most
// vulnerable resources. The score uses the Common Vulnerability Scoring System
// (CVSS) format. This format is a modification of the base CVSS score that the
// National Vulnerability Database (NVD) provides. For more information about
// severity levels, see [Severity levels for Amazon Inspector findings]in the Amazon Inspector User Guide.
//
// [Severity levels for Amazon Inspector findings]: https://docs.aws.amazon.com/inspector/latest/user/findings-understanding-severity.html
type CvssScore struct {

	// The CVSS base score.
	BaseScore *float64

	// The vector string of the CVSS score.
	ScoringVector *string

	// The source of the CVSS score.
	Source *string

	// The CVSS version that generated the score.
	Version *string

	noSmithyDocumentSerde
}

// Details about an adjustment that Amazon Inspector made to the CVSS score for a
// finding.
type CvssScoreAdjustment struct {

	// The metric that Amazon Inspector used to adjust the CVSS score.
	Metric *string

	// The reason for the CVSS score adjustment.
	Reason *string

	noSmithyDocumentSerde
}

// Details about the source of the score, and the factors that determined the
// adjustments to create the final score.
type CvssScoreDetails struct {

	// An object that contains details about an adjustment that Amazon Inspector made
	// to the CVSS score for the finding.
	Adjustments []CvssScoreAdjustment

	// The source of the finding.
	CvssSource *string

	// The CVSS score.
	Score *float64

	// The source for the CVSS score.
	ScoreSource *string

	// A vector that measures the severity of the vulnerability.
	ScoringVector *string

	// The CVSS version that generated the score.
	Version *string

	noSmithyDocumentSerde
}

// Defines the settings for a specific Region.
type Distribution struct {

	// The target Region.
	//
	// This member is required.
	Region *string

	// The specific AMI settings; for example, launch permissions or AMI tags.
	AmiDistributionConfiguration *AmiDistributionConfiguration

	// Container distribution settings for encryption, licensing, and sharing in a
	// specific Region.
	ContainerDistributionConfiguration *ContainerDistributionConfiguration

	// The Windows faster-launching configurations to use for AMI distribution.
	FastLaunchConfigurations []FastLaunchConfiguration

	// A group of launchTemplateConfiguration settings that apply to image
	// distribution for specified accounts.
	LaunchTemplateConfigurations []LaunchTemplateConfiguration

	// The License Manager Configuration to associate with the AMI in the specified
	// Region.
	LicenseConfigurationArns []string

	// Configure export settings to deliver disk images created from your image build,
	// using a file format that is compatible with your VMs in that Region.
	S3ExportConfiguration *S3ExportConfiguration

	noSmithyDocumentSerde
}

// A distribution configuration.
type DistributionConfiguration struct {

	// The maximum duration in minutes for this distribution configuration.
	//
	// This member is required.
	TimeoutMinutes *int32

	// The Amazon Resource Name (ARN) of the distribution configuration.
	Arn *string

	// The date on which this distribution configuration was created.
	DateCreated *string

	// The date on which this distribution configuration was last updated.
	DateUpdated *string

	// The description of the distribution configuration.
	Description *string

	// The distribution objects that apply Region-specific settings for the deployment
	// of the image to targeted Regions.
	Distributions []Distribution

	// The name of the distribution configuration.
	Name *string

	// The tags of the distribution configuration.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A high-level overview of a distribution configuration.
type DistributionConfigurationSummary struct {

	// The Amazon Resource Name (ARN) of the distribution configuration.
	Arn *string

	// The date on which the distribution configuration was created.
	DateCreated *string

	// The date on which the distribution configuration was updated.
	DateUpdated *string

	// The description of the distribution configuration.
	Description *string

	// The name of the distribution configuration.
	Name *string

	// A list of Regions where the container image is distributed to.
	Regions []string

	// The tags associated with the distribution configuration.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Amazon EBS-specific block device mapping specifications.
type EbsInstanceBlockDeviceSpecification struct {

	// Use to configure delete on termination of the associated device.
	DeleteOnTermination *bool

	// Use to configure device encryption.
	Encrypted *bool

	// Use to configure device IOPS.
	Iops *int32

	// Use to configure the KMS key to use when encrypting the device.
	KmsKeyId *string

	// The snapshot that defines the device contents.
	SnapshotId *string

	//  For GP3 volumes only – The throughput in MiB/s that the volume supports.
	Throughput *int32

	// Use to override the device's volume size.
	VolumeSize *int32

	// Use to override the device's volume type.
	VolumeType EbsVolumeType

	noSmithyDocumentSerde
}

// Settings that Image Builder uses to configure the ECR repository and the output
// container images that Amazon Inspector scans.
type EcrConfiguration struct {

	// Tags for Image Builder to apply to the output container image that &INS; scans.
	// Tags can help you identify and manage your scanned images.
	ContainerTags []string

	// The name of the container repository that Amazon Inspector scans to identify
	// findings for your container images. The name includes the path for the
	// repository location. If you don’t provide this information, Image Builder
	// creates a repository in your account named
	// image-builder-image-scanning-repository for vulnerability scans of your output
	// container images.
	RepositoryName *string

	noSmithyDocumentSerde
}

// Define and configure faster launching for output Windows AMIs.
type FastLaunchConfiguration struct {

	// A Boolean that represents the current state of faster launching for the Windows
	// AMI. Set to true to start using Windows faster launching, or false to stop
	// using it.
	//
	// This member is required.
	Enabled bool

	// The owner account ID for the fast-launch enabled Windows AMI.
	AccountId *string

	// The launch template that the fast-launch enabled Windows AMI uses when it
	// launches Windows instances to create pre-provisioned snapshots.
	LaunchTemplate *FastLaunchLaunchTemplateSpecification

	// The maximum number of parallel instances that are launched for creating
	// resources.
	MaxParallelLaunches *int32

	// Configuration settings for managing the number of snapshots that are created
	// from pre-provisioned instances for the Windows AMI when faster launching is
	// enabled.
	SnapshotConfiguration *FastLaunchSnapshotConfiguration

	noSmithyDocumentSerde
}

// Identifies the launch template that the associated Windows AMI uses for
// launching an instance when faster launching is enabled.
//
// You can specify either the launchTemplateName or the launchTemplateId , but not
// both.
type FastLaunchLaunchTemplateSpecification struct {

	// The ID of the launch template to use for faster launching for a Windows AMI.
	LaunchTemplateId *string

	// The name of the launch template to use for faster launching for a Windows AMI.
	LaunchTemplateName *string

	// The version of the launch template to use for faster launching for a Windows
	// AMI.
	LaunchTemplateVersion *string

	noSmithyDocumentSerde
}

// Configuration settings for creating and managing pre-provisioned snapshots for
// a fast-launch enabled Windows AMI.
type FastLaunchSnapshotConfiguration struct {

	// The number of pre-provisioned snapshots to keep on hand for a fast-launch
	// enabled Windows AMI.
	TargetResourceCount *int32

	noSmithyDocumentSerde
}

// A filter name and value pair that is used to return a more specific list of
// results from a list operation. Filters can be used to match a set of resources
// by specific criteria, such as tags, attributes, or IDs.
type Filter struct {

	// The name of the filter. Filter names are case-sensitive.
	Name *string

	// The filter values. Filter values are case-sensitive.
	Values []string

	noSmithyDocumentSerde
}

// An Image Builder image. You must specify exactly one recipe for the image –
// either a container recipe ( containerRecipe ), which creates a container image,
// or an image recipe ( imageRecipe ), which creates an AMI.
type Image struct {

	// The Amazon Resource Name (ARN) of the image.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN), at
	// the level that applies to that object as follows:
	//
	//   - Versionless ARNs and Name ARNs do not include specific values in any of the
	//   nodes. The nodes are either left off entirely, or they are specified as
	//   wildcards, for example: x.x.x.
	//
	//   - Version ARNs have only the first three nodes: ..
	//
	//   - Build version ARNs have all four nodes, and point to a specific build for a
	//   specific version of an object.
	Arn *string

	// Indicates the type of build that created this image. The build can be initiated
	// in the following ways:
	//
	//   - USER_INITIATED – A manual pipeline build request.
	//
	//   - SCHEDULED – A pipeline build initiated by a cron expression in the Image
	//   Builder pipeline, or from EventBridge.
	//
	//   - IMPORT – A VM import created the image to use as the base image for the
	//   recipe.
	BuildType BuildType

	// For container images, this is the container recipe that Image Builder used to
	// create the image. For images that distribute an AMI, this is empty.
	ContainerRecipe *ContainerRecipe

	// The date on which Image Builder created this image.
	DateCreated *string

	// The time when deprecation occurs for an image resource. This can be a past or
	// future date.
	DeprecationTime *time.Time

	// The distribution configuration that Image Builder used to create this image.
	DistributionConfiguration *DistributionConfiguration

	// Indicates whether Image Builder collects additional information about the
	// image, such as the operating system (OS) version and package list.
	EnhancedImageMetadataEnabled *bool

	// The name or Amazon Resource Name (ARN) for the IAM role you create that grants
	// Image Builder access to perform workflow actions.
	ExecutionRole *string

	// For images that distribute an AMI, this is the image recipe that Image Builder
	// used to create the image. For container images, this is empty.
	ImageRecipe *ImageRecipe

	// Contains settings for vulnerability scans.
	ImageScanningConfiguration *ImageScanningConfiguration

	// The origin of the base image that Image Builder used to build this image.
	ImageSource ImageSource

	// The image tests that ran when that Image Builder created this image.
	ImageTestsConfiguration *ImageTestsConfiguration

	// The infrastructure that Image Builder used to create this image.
	InfrastructureConfiguration *InfrastructureConfiguration

	// Identifies the last runtime instance of the lifecycle policy to take action on
	// the image.
	LifecycleExecutionId *string

	// The name of the image.
	Name *string

	// The operating system version for instances that launch from this image. For
	// example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string

	// The output resources that Image Builder produces for this image.
	OutputResources *OutputResources

	// The image operating system platform, such as Linux or Windows.
	Platform Platform

	// Contains information about the current state of scans for this image.
	ScanState *ImageScanState

	// The Amazon Resource Name (ARN) of the image pipeline that created this image.
	SourcePipelineArn *string

	// The name of the image pipeline that created this image.
	SourcePipelineName *string

	// The state of the image.
	State *ImageState

	// The tags that apply to this image.
	Tags map[string]string

	// Specifies whether this image produces an AMI or a container image.
	Type ImageType

	// The semantic version of the image.
	//
	// The semantic version has four nodes: ../. You can assign values for the first
	// three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose a
	// software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base image
	// or components for your recipe. When you use a wildcard in any node, all nodes to
	// the right of the first wildcard must also be wildcards.
	Version *string

	// Contains the build and test workflows that are associated with the image.
	Workflows []WorkflowConfiguration

	noSmithyDocumentSerde
}

// Contains vulnerability counts for a specific image.
type ImageAggregation struct {

	// The Amazon Resource Name (ARN) that identifies the image for this aggregation.
	ImageBuildVersionArn *string

	// Counts by severity level for medium severity and higher level findings, plus a
	// total for all of the findings for the specified image.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// Represents a package installed on an Image Builder image.
type ImagePackage struct {

	// The name of the package as reported to the operating system package manager.
	PackageName *string

	// The version of the package as reported to the operating system package manager.
	PackageVersion *string

	noSmithyDocumentSerde
}

// Details of an image pipeline.
type ImagePipeline struct {

	// The Amazon Resource Name (ARN) of the image pipeline.
	Arn *string

	// The Amazon Resource Name (ARN) of the container recipe that is used for this
	// pipeline.
	ContainerRecipeArn *string

	// The date on which this image pipeline was created.
	DateCreated *string

	// This is no longer supported, and does not return a value.
	DateLastRun *string

	// The next date when the pipeline is scheduled to run.
	DateNextRun *string

	// The date on which this image pipeline was last updated.
	DateUpdated *string

	// The description of the image pipeline.
	Description *string

	// The Amazon Resource Name (ARN) of the distribution configuration associated
	// with this image pipeline.
	DistributionConfigurationArn *string

	// Collects additional information about the image being created, including the
	// operating system (OS) version and package list. This information is used to
	// enhance the overall experience of using EC2 Image Builder. Enabled by default.
	EnhancedImageMetadataEnabled *bool

	// The name or Amazon Resource Name (ARN) for the IAM role you create that grants
	// Image Builder access to perform workflow actions.
	ExecutionRole *string

	// The Amazon Resource Name (ARN) of the image recipe associated with this image
	// pipeline.
	ImageRecipeArn *string

	// Contains settings for vulnerability scans.
	ImageScanningConfiguration *ImageScanningConfiguration

	// The image tests configuration of the image pipeline.
	ImageTestsConfiguration *ImageTestsConfiguration

	// The Amazon Resource Name (ARN) of the infrastructure configuration associated
	// with this image pipeline.
	InfrastructureConfigurationArn *string

	// The name of the image pipeline.
	Name *string

	// The platform of the image pipeline.
	Platform Platform

	// The schedule of the image pipeline.
	Schedule *Schedule

	// The status of the image pipeline.
	Status PipelineStatus

	// The tags of this image pipeline.
	Tags map[string]string

	// Contains the workflows that run for the image pipeline.
	Workflows []WorkflowConfiguration

	noSmithyDocumentSerde
}

// Contains vulnerability counts for a specific image pipeline.
type ImagePipelineAggregation struct {

	// The Amazon Resource Name (ARN) that identifies the image pipeline for this
	// aggregation.
	ImagePipelineArn *string

	// Counts by severity level for medium severity and higher level findings, plus a
	// total for all of the findings for the specified image pipeline.
	SeverityCounts *SeverityCounts

	noSmithyDocumentSerde
}

// An image recipe.
type ImageRecipe struct {

	// Before you create a new AMI, Image Builder launches temporary Amazon EC2
	// instances to build and test your image configuration. Instance configuration
	// adds a layer of control over those instances. You can define settings and add
	// scripts to run when an instance is launched from your AMI.
	AdditionalInstanceConfiguration *AdditionalInstanceConfiguration

	// The Amazon Resource Name (ARN) of the image recipe.
	Arn *string

	// The block device mappings to apply when creating images from this recipe.
	BlockDeviceMappings []InstanceBlockDeviceMapping

	// The components that are included in the image recipe. Recipes require a minimum
	// of one build component, and can have a maximum of 20 build and test components
	// in any combination.
	Components []ComponentConfiguration

	// The date on which this image recipe was created.
	DateCreated *string

	// The description of the image recipe.
	Description *string

	// The name of the image recipe.
	Name *string

	// The owner of the image recipe.
	Owner *string

	// The base image of the image recipe.
	ParentImage *string

	// The platform of the image recipe.
	Platform Platform

	// The tags of the image recipe.
	Tags map[string]string

	// Specifies which type of image is created by the recipe - an AMI or a container
	// image.
	Type ImageType

	// The version of the image recipe.
	Version *string

	// The working directory to be used during build and test workflows.
	WorkingDirectory *string

	noSmithyDocumentSerde
}

// A summary of an image recipe.
type ImageRecipeSummary struct {

	// The Amazon Resource Name (ARN) of the image recipe.
	Arn *string

	// The date on which this image recipe was created.
	DateCreated *string

	// The name of the image recipe.
	Name *string

	// The owner of the image recipe.
	Owner *string

	// The base image of the image recipe.
	ParentImage *string

	// The platform of the image recipe.
	Platform Platform

	// The tags of the image recipe.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains details about a vulnerability scan finding.
type ImageScanFinding struct {

	// The Amazon Web Services account ID that's associated with the finding.
	AwsAccountId *string

	// The description of the finding.
	Description *string

	// The date and time when the finding was first observed.
	FirstObservedAt *time.Time

	// Details about whether a fix is available for any of the packages that are
	// identified in the finding through a version update.
	FixAvailable *string

	// The Amazon Resource Name (ARN) of the image build version that's associated
	// with the finding.
	ImageBuildVersionArn *string

	// The Amazon Resource Name (ARN) of the image pipeline that's associated with the
	// finding.
	ImagePipelineArn *string

	// The score that Amazon Inspector assigned for the finding.
	InspectorScore *float64

	// An object that contains details of the Amazon Inspector score.
	InspectorScoreDetails *InspectorScoreDetails

	// An object that contains the details of a package vulnerability finding.
	PackageVulnerabilityDetails *PackageVulnerabilityDetails

	// An object that contains the details about how to remediate the finding.
	Remediation *Remediation

	// The severity of the finding.
	Severity *string

	// The title of the finding.
	Title *string

	// The type of the finding. Image Builder looks for findings of the type
	// PACKAGE_VULNERABILITY that apply to output images, and excludes other types.
	Type *string

	// The timestamp when the finding was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// This returns exactly one type of aggregation, based on the filter that Image
// Builder applies in its API action.
type ImageScanFindingAggregation struct {

	// Returns an object that contains severity counts based on an account ID.
	AccountAggregation *AccountAggregation

	// Returns an object that contains severity counts based on the Amazon Resource
	// Name (ARN) for a specific image.
	ImageAggregation *ImageAggregation

	// Returns an object that contains severity counts based on an image pipeline ARN.
	ImagePipelineAggregation *ImagePipelineAggregation

	// Returns an object that contains severity counts based on vulnerability ID.
	VulnerabilityIdAggregation *VulnerabilityIdAggregation

	noSmithyDocumentSerde
}

// A name value pair that Image Builder applies to streamline results from the
// vulnerability scan findings list action.
type ImageScanFindingsFilter struct {

	// The name of the image scan finding filter. Filter names are case-sensitive.
	Name *string

	// The filter values. Filter values are case-sensitive.
	Values []string

	noSmithyDocumentSerde
}

// Contains settings for Image Builder image resource and container image scans.
type ImageScanningConfiguration struct {

	// Contains Amazon ECR settings for vulnerability scans.
	EcrConfiguration *EcrConfiguration

	// A setting that indicates whether Image Builder keeps a snapshot of the
	// vulnerability scans that Amazon Inspector runs against the build instance when
	// you create a new image.
	ImageScanningEnabled *bool

	noSmithyDocumentSerde
}

// Shows the vulnerability scan status for a specific image, and the reason for
// that status.
type ImageScanState struct {

	// The reason for the scan status for the image.
	Reason *string

	// The current state of vulnerability scans for the image.
	Status ImageScanStatus

	noSmithyDocumentSerde
}

// Image status and the reason for that status.
type ImageState struct {

	// The reason for the status of the image.
	Reason *string

	// The status of the image.
	Status ImageStatus

	noSmithyDocumentSerde
}

// An image summary.
type ImageSummary struct {

	// The Amazon Resource Name (ARN) of the image.
	Arn *string

	// Indicates the type of build that created this image. The build can be initiated
	// in the following ways:
	//
	//   - USER_INITIATED – A manual pipeline build request.
	//
	//   - SCHEDULED – A pipeline build initiated by a cron expression in the Image
	//   Builder pipeline, or from EventBridge.
	//
	//   - IMPORT – A VM import created the image to use as the base image for the
	//   recipe.
	BuildType BuildType

	// The date on which Image Builder created this image.
	DateCreated *string

	// The time when deprecation occurs for an image resource. This can be a past or
	// future date.
	DeprecationTime *time.Time

	// The origin of the base image that Image Builder used to build this image.
	ImageSource ImageSource

	// Identifies the last runtime instance of the lifecycle policy to take action on
	// the image.
	LifecycleExecutionId *string

	// The name of the image.
	Name *string

	// The operating system version of the instances that launch from this image. For
	// example, Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string

	// The output resources that Image Builder produced when it created this image.
	OutputResources *OutputResources

	// The owner of the image.
	Owner *string

	// The image operating system platform, such as Linux or Windows.
	Platform Platform

	// The state of the image.
	State *ImageState

	// The tags that apply to this image.
	Tags map[string]string

	// Specifies whether this image produces an AMI or a container image.
	Type ImageType

	// The version of the image.
	Version *string

	noSmithyDocumentSerde
}

// Configure image tests for your pipeline build. Tests run after building the
// image, to verify that the AMI or container image is valid before distributing
// it.
type ImageTestsConfiguration struct {

	// Determines if tests should run after building the image. Image Builder defaults
	// to enable tests to run following the image build, before image distribution.
	ImageTestsEnabled *bool

	// The maximum time in minutes that tests are permitted to run.
	//
	// The timeoutMinutes attribute is not currently active. This value is ignored.
	TimeoutMinutes *int32

	noSmithyDocumentSerde
}

// The defining characteristics of a specific version of an Image Builder image.
type ImageVersion struct {

	// The Amazon Resource Name (ARN) of a specific version of an Image Builder image.
	//
	// Semantic versioning is included in each object's Amazon Resource Name (ARN), at
	// the level that applies to that object as follows:
	//
	//   - Versionless ARNs and Name ARNs do not include specific values in any of the
	//   nodes. The nodes are either left off entirely, or they are specified as
	//   wildcards, for example: x.x.x.
	//
	//   - Version ARNs have only the first three nodes: ..
	//
	//   - Build version ARNs have all four nodes, and point to a specific build for a
	//   specific version of an object.
	Arn *string

	// Indicates the type of build that created this image. The build can be initiated
	// in the following ways:
	//
	//   - USER_INITIATED – A manual pipeline build request.
	//
	//   - SCHEDULED – A pipeline build initiated by a cron expression in the Image
	//   Builder pipeline, or from EventBridge.
	//
	//   - IMPORT – A VM import created the image to use as the base image for the
	//   recipe.
	BuildType BuildType

	// The date on which this specific version of the Image Builder image was created.
	DateCreated *string

	// The origin of the base image that Image Builder used to build this image.
	ImageSource ImageSource

	// The name of this specific version of an Image Builder image.
	Name *string

	// The operating system version of the Amazon EC2 build instance. For example,
	// Amazon Linux 2, Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string

	// The owner of the image version.
	Owner *string

	// The operating system platform of the image version, for example "Windows" or
	// "Linux".
	Platform Platform

	// Specifies whether this image produces an AMI or a container image.
	Type ImageType

	// Details for a specific version of an Image Builder image. This version follows
	// the semantic version syntax.
	//
	// The semantic version has four nodes: ../. You can assign values for the first
	// three, and can filter on all of them.
	//
	// Assignment: For the first three nodes you can assign any positive integer
	// value, including zero, with an upper limit of 2^30-1, or 1073741823 for each
	// node. Image Builder automatically assigns the build number to the fourth node.
	//
	// Patterns: You can use any numeric pattern that adheres to the assignment
	// requirements for the nodes that you can assign. For example, you might choose a
	// software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
	//
	// Filtering: With semantic versioning, you have the flexibility to use wildcards
	// (x) to specify the most recent versions or nodes when selecting the base image
	// or components for your recipe. When you use a wildcard in any node, all nodes to
	// the right of the first wildcard must also be wildcards.
	Version *string

	noSmithyDocumentSerde
}

// Details of the infrastructure configuration.
type InfrastructureConfiguration struct {

	// The Amazon Resource Name (ARN) of the infrastructure configuration.
	Arn *string

	// The date on which the infrastructure configuration was created.
	DateCreated *string

	// The date on which the infrastructure configuration was last updated.
	DateUpdated *string

	// The description of the infrastructure configuration.
	Description *string

	// The instance metadata option settings for the infrastructure configuration.
	InstanceMetadataOptions *InstanceMetadataOptions

	// The instance profile of the infrastructure configuration.
	InstanceProfileName *string

	// The instance types of the infrastructure configuration.
	InstanceTypes []string

	// The Amazon EC2 key pair of the infrastructure configuration.
	KeyPair *string

	// The logging configuration of the infrastructure configuration.
	Logging *Logging

	// The name of the infrastructure configuration.
	Name *string

	// The tags attached to the resource created by Image Builder.
	ResourceTags map[string]string

	// The security group IDs of the infrastructure configuration.
	SecurityGroupIds []string

	// The Amazon Resource Name (ARN) for the SNS topic to which we send image build
	// event notifications.
	//
	// EC2 Image Builder is unable to send notifications to SNS topics that are
	// encrypted using keys from other accounts. The key that is used to encrypt the
	// SNS topic must reside in the account that the Image Builder service runs under.
	SnsTopicArn *string

	// The subnet ID of the infrastructure configuration.
	SubnetId *string

	// The tags of the infrastructure configuration.
	Tags map[string]string

	// The terminate instance on failure configuration of the infrastructure
	// configuration.
	TerminateInstanceOnFailure *bool

	noSmithyDocumentSerde
}

// The infrastructure used when building Amazon EC2 AMIs.
type InfrastructureConfigurationSummary struct {

	// The Amazon Resource Name (ARN) of the infrastructure configuration.
	Arn *string

	// The date on which the infrastructure configuration was created.
	DateCreated *string

	// The date on which the infrastructure configuration was last updated.
	DateUpdated *string

	// The description of the infrastructure configuration.
	Description *string

	// The instance profile of the infrastructure configuration.
	InstanceProfileName *string

	// The instance types of the infrastructure configuration.
	InstanceTypes []string

	// The name of the infrastructure configuration.
	Name *string

	// The tags attached to the image created by Image Builder.
	ResourceTags map[string]string

	// The tags of the infrastructure configuration.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Information about the factors that influenced the score that Amazon Inspector
// assigned for a finding.
type InspectorScoreDetails struct {

	// An object that contains details about an adjustment that Amazon Inspector made
	// to the CVSS score for the finding.
	AdjustedCvss *CvssScoreDetails

	noSmithyDocumentSerde
}

// Defines block device mappings for the instance used to configure your image.
type InstanceBlockDeviceMapping struct {

	// The device to which these mappings apply.
	DeviceName *string

	// Use to manage Amazon EBS-specific configuration for this mapping.
	Ebs *EbsInstanceBlockDeviceSpecification

	// Use to remove a mapping from the base image.
	NoDevice *string

	// Use to manage instance ephemeral devices.
	VirtualName *string

	noSmithyDocumentSerde
}

// Defines a custom base AMI and block device mapping configurations of an
// instance used for building and testing container images.
type InstanceConfiguration struct {

	// Defines the block devices to attach for building an instance from this Image
	// Builder AMI.
	BlockDeviceMappings []InstanceBlockDeviceMapping

	// The AMI ID to use as the base image for a container build and test instance. If
	// not specified, Image Builder will use the appropriate ECS-optimized AMI as a
	// base image.
	Image *string

	noSmithyDocumentSerde
}

// The instance metadata options that apply to the HTTP requests that pipeline
// builds use to launch EC2 build and test instances. For more information about
// instance metadata options, see [Configure the instance metadata options]in the Amazon EC2 User Guide for Linux
// instances, or [Configure the instance metadata options]in the Amazon EC2 Windows Guide for Windows instances.
//
// [Configure the instance metadata options]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html
type InstanceMetadataOptions struct {

	// Limit the number of hops that an instance metadata request can traverse to
	// reach its destination. The default is one hop. However, if HTTP tokens are
	// required, container image builds need a minimum of two hops.
	HttpPutResponseHopLimit *int32

	// Indicates whether a signed token header is required for instance metadata
	// retrieval requests. The values affect the response as follows:
	//
	//   - required – When you retrieve the IAM role credentials, version 2.0
	//   credentials are returned in all cases.
	//
	//   - optional – You can include a signed token header in your request to
	//   retrieve instance metadata, or you can leave it out. If you include it, version
	//   2.0 credentials are returned for the IAM role. Otherwise, version 1.0
	//   credentials are returned.
	//
	// The default setting is optional.
	HttpTokens *string

	noSmithyDocumentSerde
}

// Describes the configuration for a launch permission. The launch permission
// modification request is sent to the [Amazon EC2 ModifyImageAttribute]API on behalf of the user for each Region
// they have selected to distribute the AMI. To make an AMI public, set the launch
// permission authorized accounts to all . See the examples for making an AMI
// public at [Amazon EC2 ModifyImageAttribute].
//
// [Amazon EC2 ModifyImageAttribute]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html
type LaunchPermissionConfiguration struct {

	// The ARN for an Amazon Web Services Organization that you want to share your AMI
	// with. For more information, see [What is Organizations?].
	//
	// [What is Organizations?]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html
	OrganizationArns []string

	// The ARN for an Organizations organizational unit (OU) that you want to share
	// your AMI with. For more information about key concepts for Organizations, see [Organizations terminology and concepts].
	//
	// [Organizations terminology and concepts]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html
	OrganizationalUnitArns []string

	// The name of the group.
	UserGroups []string

	// The Amazon Web Services account ID.
	UserIds []string

	noSmithyDocumentSerde
}

// Identifies an Amazon EC2 launch template to use for a specific account.
type LaunchTemplateConfiguration struct {

	// Identifies the Amazon EC2 launch template to use.
	//
	// This member is required.
	LaunchTemplateId *string

	// The account ID that this configuration applies to.
	AccountId *string

	// Set the specified Amazon EC2 launch template as the default launch template for
	// the specified account.
	SetDefaultVersion bool

	noSmithyDocumentSerde
}

// Contains metadata from a runtime instance of a lifecycle policy.
type LifecycleExecution struct {

	// The timestamp when the lifecycle runtime instance completed.
	EndTime *time.Time

	// Identifies the lifecycle policy runtime instance.
	LifecycleExecutionId *string

	// The Amazon Resource Name (ARN) of the lifecycle policy that ran.
	LifecyclePolicyArn *string

	// Contains information about associated resources that are identified for action
	// by the runtime instance of the lifecycle policy.
	ResourcesImpactedSummary *LifecycleExecutionResourcesImpactedSummary

	// The timestamp when the lifecycle runtime instance started.
	StartTime *time.Time

	// Runtime state that reports if the policy action ran successfully, failed, or
	// was skipped.
	State *LifecycleExecutionState

	noSmithyDocumentSerde
}

// Contains details for a resource that the runtime instance of the lifecycle
// policy identified for action.
type LifecycleExecutionResource struct {

	// The account that owns the impacted resource.
	AccountId *string

	// The action to take for the identified resource.
	Action *LifecycleExecutionResourceAction

	// The ending timestamp from the lifecycle action that was applied to the resource.
	EndTime *time.Time

	// For an impacted container image, this identifies a list of URIs for associated
	// container images distributed to ECR repositories.
	ImageUris []string

	// The Amazon Web Services Region where the lifecycle execution resource is stored.
	Region *string

	// Identifies the impacted resource. The resource ID depends on the type of
	// resource, as follows.
	//
	//   - Image Builder image resources: Amazon Resource Name (ARN)
	//
	//   - Distributed AMIs: AMI ID
	//
	//   - Container images distributed to an ECR repository: image URI or SHA Digest
	ResourceId *string

	// A list of associated resource snapshots for the impacted resource if it’s an
	// AMI.
	Snapshots []LifecycleExecutionSnapshotResource

	// The starting timestamp from the lifecycle action that was applied to the
	// resource.
	StartTime *time.Time

	// The runtime state for the lifecycle execution.
	State *LifecycleExecutionResourceState

	noSmithyDocumentSerde
}

// The lifecycle policy action that was identified for the impacted resource.
type LifecycleExecutionResourceAction struct {

	// The name of the resource that was identified for a lifecycle policy action.
	Name LifecycleExecutionResourceActionName

	// The reason why the lifecycle policy action is taken.
	Reason *string

	noSmithyDocumentSerde
}

// Contains details for an image resource that was identified for a lifecycle
// action.
type LifecycleExecutionResourcesImpactedSummary struct {

	// Indicates whether an image resource that was identified for a lifecycle action
	// has associated resources that are also impacted.
	HasImpactedResources bool

	noSmithyDocumentSerde
}

// Contains the state of an impacted resource that the runtime instance of the
// lifecycle policy identified for action.
type LifecycleExecutionResourceState struct {

	// Messaging that clarifies the reason for the assigned status.
	Reason *string

	// The runtime status of the lifecycle action taken for the impacted resource.
	Status LifecycleExecutionResourceStatus

	noSmithyDocumentSerde
}

// Contains the state of an impacted snapshot resource that the runtime instance
// of the lifecycle policy identified for action.
type LifecycleExecutionSnapshotResource struct {

	// Identifies the impacted snapshot resource.
	SnapshotId *string

	// The runtime status of the lifecycle action taken for the snapshot.
	State *LifecycleExecutionResourceState

	noSmithyDocumentSerde
}

// The current state of the runtime instance of the lifecycle policy.
type LifecycleExecutionState struct {

	// The reason for the current status.
	Reason *string

	// The runtime status of the lifecycle execution.
	Status LifecycleExecutionStatus

	noSmithyDocumentSerde
}

// The configuration details for a lifecycle policy resource.
type LifecyclePolicy struct {

	// The Amazon Resource Name (ARN) of the lifecycle policy resource.
	Arn *string

	// The timestamp when Image Builder created the lifecycle policy resource.
	DateCreated *time.Time

	// The timestamp for the last time Image Builder ran the lifecycle policy.
	DateLastRun *time.Time

	// The timestamp when Image Builder updated the lifecycle policy resource.
	DateUpdated *time.Time

	// Optional description for the lifecycle policy.
	Description *string

	// The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses
	// to run the lifecycle policy. This is a custom role that you create.
	ExecutionRole *string

	// The name of the lifecycle policy.
	Name *string

	// The configuration details for a lifecycle policy resource.
	PolicyDetails []LifecyclePolicyDetail

	// Resource selection criteria used to run the lifecycle policy.
	ResourceSelection *LifecyclePolicyResourceSelection

	// The type of resources the lifecycle policy targets.
	ResourceType LifecyclePolicyResourceType

	// Indicates whether the lifecycle policy resource is enabled.
	Status LifecyclePolicyStatus

	// To help manage your lifecycle policy resources, you can assign your own
	// metadata to each resource in the form of tags. Each tag consists of a key and an
	// optional value, both of which you define.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The configuration details for a lifecycle policy resource.
type LifecyclePolicyDetail struct {

	// Configuration details for the policy action.
	//
	// This member is required.
	Action *LifecyclePolicyDetailAction

	// Specifies the resources that the lifecycle policy applies to.
	//
	// This member is required.
	Filter *LifecyclePolicyDetailFilter

	// Additional rules to specify resources that should be exempt from policy actions.
	ExclusionRules *LifecyclePolicyDetailExclusionRules

	noSmithyDocumentSerde
}

// Contains selection criteria for the lifecycle policy.
type LifecyclePolicyDetailAction struct {

	// Specifies the lifecycle action to take.
	//
	// This member is required.
	Type LifecyclePolicyDetailActionType

	// Specifies the resources that the lifecycle policy applies to.
	IncludeResources *LifecyclePolicyDetailActionIncludeResources

	noSmithyDocumentSerde
}

// Specifies how the lifecycle policy should apply actions to selected resources.
type LifecyclePolicyDetailActionIncludeResources struct {

	// Specifies whether the lifecycle action should apply to distributed AMIs.
	Amis bool

	// Specifies whether the lifecycle action should apply to distributed containers.
	Containers bool

	// Specifies whether the lifecycle action should apply to snapshots associated
	// with distributed AMIs.
	Snapshots bool

	noSmithyDocumentSerde
}

// Specifies resources that lifecycle policy actions should not apply to.
type LifecyclePolicyDetailExclusionRules struct {

	// Lists configuration values that apply to AMIs that Image Builder should exclude
	// from the lifecycle action.
	Amis *LifecyclePolicyDetailExclusionRulesAmis

	// Contains a list of tags that Image Builder uses to skip lifecycle actions for
	// Image Builder image resources that have them.
	TagMap map[string]string

	noSmithyDocumentSerde
}

// Defines criteria for AMIs that are excluded from lifecycle actions.
type LifecyclePolicyDetailExclusionRulesAmis struct {

	// Configures whether public AMIs are excluded from the lifecycle action.
	IsPublic bool

	// Specifies configuration details for Image Builder to exclude the most recent
	// resources from lifecycle actions.
	LastLaunched *LifecyclePolicyDetailExclusionRulesAmisLastLaunched

	// Configures Amazon Web Services Regions that are excluded from the lifecycle
	// action.
	Regions []string

	// Specifies Amazon Web Services accounts whose resources are excluded from the
	// lifecycle action.
	SharedAccounts []string

	// Lists tags that should be excluded from lifecycle actions for the AMIs that
	// have them.
	TagMap map[string]string

	noSmithyDocumentSerde
}

// Defines criteria to exclude AMIs from lifecycle actions based on the last time
// they were used to launch an instance.
type LifecyclePolicyDetailExclusionRulesAmisLastLaunched struct {

	// Defines the unit of time that the lifecycle policy uses to calculate elapsed
	// time since the last instance launched from the AMI. For example: days, weeks,
	// months, or years.
	//
	// This member is required.
	Unit LifecyclePolicyTimeUnit

	// The integer number of units for the time period. For example 6 (months).
	//
	// This member is required.
	Value *int32

	noSmithyDocumentSerde
}

// Defines filters that the lifecycle policy uses to determine impacted resource.
type LifecyclePolicyDetailFilter struct {

	// Filter resources based on either age or count .
	//
	// This member is required.
	Type LifecyclePolicyDetailFilterType

	// The number of units for the time period or for the count. For example, a value
	// of 6 might refer to six months or six AMIs.
	//
	// For count-based filters, this value represents the minimum number of resources
	// to keep on hand. If you have fewer resources than this number, the resource is
	// excluded from lifecycle actions.
	//
	// This member is required.
	Value *int32

	// For age-based filters, this is the number of resources to keep on hand after
	// the lifecycle DELETE action is applied. Impacted resources are only deleted if
	// you have more than this number of resources. If you have fewer resources than
	// this number, the impacted resource is not deleted.
	RetainAtLeast *int32

	// Defines the unit of time that the lifecycle policy uses to determine impacted
	// resources. This is required for age-based rules.
	Unit LifecyclePolicyTimeUnit

	noSmithyDocumentSerde
}

// Resource selection criteria for the lifecycle policy.
type LifecyclePolicyResourceSelection struct {

	// A list of recipes that are used as selection criteria for the output images
	// that the lifecycle policy applies to.
	Recipes []LifecyclePolicyResourceSelectionRecipe

	// A list of tags that are used as selection criteria for the Image Builder image
	// resources that the lifecycle policy applies to.
	TagMap map[string]string

	noSmithyDocumentSerde
}

// Specifies an Image Builder recipe that the lifecycle policy uses for resource
// selection.
type LifecyclePolicyResourceSelectionRecipe struct {

	// The name of an Image Builder recipe that the lifecycle policy uses for resource
	// selection.
	//
	// This member is required.
	Name *string

	// The version of the Image Builder recipe specified by the name field.
	//
	// This member is required.
	SemanticVersion *string

	noSmithyDocumentSerde
}

// Contains a summary of lifecycle policy resources.
type LifecyclePolicySummary struct {

	// The Amazon Resource Name (ARN) of the lifecycle policy summary resource.
	Arn *string

	// The timestamp when Image Builder created the lifecycle policy resource.
	DateCreated *time.Time

	// The timestamp for the last time Image Builder ran the lifecycle policy.
	DateLastRun *time.Time

	// The timestamp when Image Builder updated the lifecycle policy resource.
	DateUpdated *time.Time

	// Optional description for the lifecycle policy.
	Description *string

	// The name or Amazon Resource Name (ARN) of the IAM role that Image Builder uses
	// to run the lifecycle policy.
	ExecutionRole *string

	// The name of the lifecycle policy.
	Name *string

	// The type of resources the lifecycle policy targets.
	ResourceType LifecyclePolicyResourceType

	// The lifecycle policy resource status.
	Status LifecyclePolicyStatus

	// To help manage your lifecycle policy resources, you can assign your own
	// metadata to each resource in the form of tags. Each tag consists of a key and an
	// optional value, both of which you define.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Logging configuration defines where Image Builder uploads your logs.
type Logging struct {

	// The Amazon S3 logging configuration.
	S3Logs *S3Logs

	noSmithyDocumentSerde
}

// The resources produced by this image.
type OutputResources struct {

	// The Amazon EC2 AMIs created by this image.
	Amis []Ami

	// Container images that the pipeline has generated and stored in the output
	// repository.
	Containers []Container

	noSmithyDocumentSerde
}

// Information about package vulnerability findings.
type PackageVulnerabilityDetails struct {

	// A unique identifier for this vulnerability.
	//
	// This member is required.
	VulnerabilityId *string

	// CVSS scores for one or more vulnerabilities that Amazon Inspector identified
	// for a package.
	Cvss []CvssScore

	// Links to web pages that contain details about the vulnerabilities that Amazon
	// Inspector identified for the package.
	ReferenceUrls []string

	// Vulnerabilities that are often related to the findings for the package.
	RelatedVulnerabilities []string

	// The source of the vulnerability information.
	Source *string

	// A link to the source of the vulnerability information.
	SourceUrl *string

	// The date and time when this vulnerability was first added to the vendor's
	// database.
	VendorCreatedAt *time.Time

	// The severity that the vendor assigned to this vulnerability type.
	VendorSeverity *string

	// The date and time when the vendor last updated this vulnerability in their
	// database.
	VendorUpdatedAt *time.Time

	// The packages that this vulnerability impacts.
	VulnerablePackages []VulnerablePackage

	noSmithyDocumentSerde
}

// Information about how to remediate a finding.
type Remediation struct {

	// An object that contains information about the recommended course of action to
	// remediate the finding.
	Recommendation *RemediationRecommendation

	noSmithyDocumentSerde
}

// Details about the recommended course of action to remediate the finding.
type RemediationRecommendation struct {

	// The recommended course of action to remediate the finding.
	Text *string

	// A link to more information about the recommended remediation for this
	// vulnerability.
	Url *string

	noSmithyDocumentSerde
}

// The current state of an impacted resource.
type ResourceState struct {

	// Shows the current lifecycle policy action that was applied to an impacted
	// resource.
	Status ResourceStatus

	noSmithyDocumentSerde
}

// Additional rules to specify resources that should be exempt from ad-hoc
// lifecycle actions.
type ResourceStateUpdateExclusionRules struct {

	// Defines criteria for AMIs that are excluded from lifecycle actions.
	Amis *LifecyclePolicyDetailExclusionRulesAmis

	noSmithyDocumentSerde
}

// Specifies if the lifecycle policy should apply actions to selected resources.
type ResourceStateUpdateIncludeResources struct {

	// Specifies whether the lifecycle action should apply to distributed AMIs
	Amis bool

	// Specifies whether the lifecycle action should apply to distributed containers.
	Containers bool

	// Specifies whether the lifecycle action should apply to snapshots associated
	// with distributed AMIs.
	Snapshots bool

	noSmithyDocumentSerde
}

// Properties that configure export from your build instance to a compatible file
// format for your VM.
type S3ExportConfiguration struct {

	// Export the updated image to one of the following supported disk image formats:
	//
	//   - Virtual Hard Disk (VHD) – Compatible with Citrix Xen and Microsoft Hyper-V
	//   virtualization products.
	//
	//   - Stream-optimized ESX Virtual Machine Disk (VMDK) – Compatible with VMware
	//   ESX and VMware vSphere versions 4, 5, and 6.
	//
	//   - Raw – Raw format.
	//
	// This member is required.
	DiskImageFormat DiskImageFormat

	// The name of the role that grants VM Import/Export permission to export images
	// to your S3 bucket.
	//
	// This member is required.
	RoleName *string

	// The S3 bucket in which to store the output disk images for your VM.
	//
	// This member is required.
	S3Bucket *string

	// The Amazon S3 path for the bucket where the output disk images for your VM are
	// stored.
	S3Prefix *string

	noSmithyDocumentSerde
}

// Amazon S3 logging configuration.
type S3Logs struct {

	// The S3 bucket in which to store the logs.
	S3BucketName *string

	// The Amazon S3 path to the bucket where the logs are stored.
	S3KeyPrefix *string

	noSmithyDocumentSerde
}

// A schedule configures when and how often a pipeline will automatically create a
// new image.
type Schedule struct {

	// The condition configures when the pipeline should trigger a new image build.
	// When the pipelineExecutionStartCondition is set to
	// EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE , and you use semantic version
	// filters on the base image or components in your image recipe, EC2 Image Builder
	// will build a new image only when there are new versions of the image or
	// components in your recipe that match the semantic version filter. When it is set
	// to EXPRESSION_MATCH_ONLY , it will build a new image every time the CRON
	// expression matches the current time. For semantic version syntax, see [CreateComponent]in the
	// EC2 Image Builder API Reference.
	//
	// [CreateComponent]: https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html
	PipelineExecutionStartCondition PipelineExecutionStartCondition

	// The cron expression determines how often EC2 Image Builder evaluates your
	// pipelineExecutionStartCondition .
	//
	// For information on how to format a cron expression in Image Builder, see [Use cron expressions in EC2 Image Builder].
	//
	// [Use cron expressions in EC2 Image Builder]: https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html
	ScheduleExpression *string

	// The timezone that applies to the scheduling expression. For example, "Etc/UTC",
	// "America/Los_Angeles" in the [IANA timezone format]. If not specified this defaults to UTC.
	//
	// [IANA timezone format]: https://www.joda.org/joda-time/timezones.html
	Timezone *string

	noSmithyDocumentSerde
}

// Includes counts by severity level for medium severity and higher level
// findings, plus a total for all of the findings for the specified filter.
type SeverityCounts struct {

	// The total number of findings across all severity levels for the specified
	// filter.
	All *int64

	// The number of critical severity findings for the specified filter.
	Critical *int64

	// The number of high severity findings for the specified filter.
	High *int64

	// The number of medium severity findings for the specified filter.
	Medium *int64

	noSmithyDocumentSerde
}

// Contains settings for the Systems Manager agent on your build instance.
type SystemsManagerAgent struct {

	// Controls whether the Systems Manager agent is removed from your final build
	// image, prior to creating the new AMI. If this is set to true, then the agent is
	// removed from the final image. If it's set to false, then the agent is left in,
	// so that it is included in the new AMI. The default value is false.
	UninstallAfterBuild *bool

	noSmithyDocumentSerde
}

// The container repository where the output container image is stored.
type TargetContainerRepository struct {

	// The name of the container repository where the output container image is
	// stored. This name is prefixed by the repository location.
	//
	// This member is required.
	RepositoryName *string

	// Specifies the service in which this image was registered.
	//
	// This member is required.
	Service ContainerRepositoryService

	noSmithyDocumentSerde
}

// Includes counts of image and pipeline resource findings by vulnerability.
type VulnerabilityIdAggregation struct {

	// Counts by severity level for medium severity and higher level findings, plus a
	// total for all of the findings for the specified vulnerability.
	SeverityCounts *SeverityCounts

	// The vulnerability Id for this set of counts.
	VulnerabilityId *string

	noSmithyDocumentSerde
}

// Information about a vulnerable package that Amazon Inspector identifies in a
// finding.
type VulnerablePackage struct {

	// The architecture of the vulnerable package.
	Arch *string

	// The epoch of the vulnerable package.
	Epoch *int32

	// The file path of the vulnerable package.
	FilePath *string

	// The version of the package that contains the vulnerability fix.
	FixedInVersion *string

	// The name of the vulnerable package.
	Name *string

	// The package manager of the vulnerable package.
	PackageManager *string

	// The release of the vulnerable package.
	Release *string

	// The code to run in your environment to update packages with a fix available.
	Remediation *string

	// The source layer hash of the vulnerable package.
	SourceLayerHash *string

	// The version of the vulnerable package.
	Version *string

	noSmithyDocumentSerde
}

// Defines a process that Image Builder uses to build and test images during the
// image creation process.
type Workflow struct {

	// The Amazon Resource Name (ARN) of the workflow resource.
	Arn *string

	// Describes what change has been made in this version of the workflow, or what
	// makes this version different from other versions of the workflow.
	ChangeDescription *string

	// Contains the YAML document content for the workflow.
	Data *string

	// The timestamp when Image Builder created the workflow resource.
	DateCreated *string

	// The description of the workflow.
	Description *string

	// The KMS key identifier used to encrypt the workflow resource.
	KmsKeyId *string

	// The name of the workflow resource.
	Name *string

	// The owner of the workflow resource.
	Owner *string

	// An array of input parameters that that the image workflow uses to control
	// actions or configure settings.
	Parameters []WorkflowParameterDetail

	// Describes the current status of the workflow and the reason for that status.
	State *WorkflowState

	// The tags that apply to the workflow resource
	Tags map[string]string

	// Specifies the image creation stage that the workflow applies to. Image Builder
	// currently supports build and test workflows.
	Type WorkflowType

	// The workflow resource version. Workflow resources are immutable. To make a
	// change, you can clone a workflow or create a new version.
	Version *string

	noSmithyDocumentSerde
}

// Contains control settings and configurable inputs for a workflow resource.
type WorkflowConfiguration struct {

	// The Amazon Resource Name (ARN) of the workflow resource.
	//
	// This member is required.
	WorkflowArn *string

	// The action to take if the workflow fails.
	OnFailure OnWorkflowFailure

	// Test workflows are defined within named runtime groups called parallel groups.
	// The parallel group is the named group that contains this test workflow. Test
	// workflows within a parallel group can run at the same time. Image Builder starts
	// up to five test workflows in the group at the same time, and starts additional
	// workflows as others complete, until all workflows in the group have completed.
	// This field only applies for test workflows.
	ParallelGroup *string

	// Contains parameter values for each of the parameters that the workflow document
	// defined for the workflow resource.
	Parameters []WorkflowParameter

	noSmithyDocumentSerde
}

// Metadata that includes details and status from this runtime instance of the
// workflow.
type WorkflowExecutionMetadata struct {

	// The timestamp when this runtime instance of the workflow finished.
	EndTime *string

	// The runtime output message from the workflow, if applicable.
	Message *string

	// The name of the test group that included the test workflow resource at runtime.
	ParallelGroup *string

	// The timestamp when the runtime instance of this workflow started.
	StartTime *string

	// The current runtime status for this workflow.
	Status WorkflowExecutionStatus

	// The total number of steps in the workflow. This should equal the sum of the
	// step counts for steps that succeeded, were skipped, and failed.
	TotalStepCount int32

	// A runtime count for the number of steps in the workflow that failed.
	TotalStepsFailed int32

	// A runtime count for the number of steps in the workflow that were skipped.
	TotalStepsSkipped int32

	// A runtime count for the number of steps in the workflow that ran successfully.
	TotalStepsSucceeded int32

	// Indicates what type of workflow that Image Builder ran for this runtime
	// instance of the workflow.
	Type WorkflowType

	// The Amazon Resource Name (ARN) of the workflow resource build version that ran.
	WorkflowBuildVersionArn *string

	// Unique identifier that Image Builder assigns to keep track of runtime resources
	// each time it runs a workflow.
	WorkflowExecutionId *string

	noSmithyDocumentSerde
}

// Contains a key/value pair that sets the named workflow parameter.
type WorkflowParameter struct {

	// The name of the workflow parameter to set.
	//
	// This member is required.
	Name *string

	// Sets the value for the named workflow parameter.
	//
	// This member is required.
	Value []string

	noSmithyDocumentSerde
}

// Defines a parameter that's used to provide configuration details for the
// workflow.
type WorkflowParameterDetail struct {

	// The name of this input parameter.
	//
	// This member is required.
	Name *string

	// The type of input this parameter provides. The currently supported value is
	// "string".
	//
	// This member is required.
	Type *string

	// The default value of this parameter if no input is provided.
	DefaultValue []string

	// Describes this parameter.
	Description *string

	noSmithyDocumentSerde
}

// A group of fields that describe the current status of workflow.
type WorkflowState struct {

	// Describes how or why the workflow changed state.
	Reason *string

	// The current state of the workflow.
	Status WorkflowStatus

	noSmithyDocumentSerde
}

// Contains runtime details for an instance of a workflow that ran for the
// associated image build version.
type WorkflowStepExecution struct {

	// The name of the step action.
	Action *string

	// The Amazon Resource Name (ARN) of the image build version that ran the workflow.
	ImageBuildVersionArn *string

	// The name of the workflow step.
	Name *string

	// The timestamp when the workflow step started.
	StartTime *string

	// Uniquely identifies the workflow step that ran for the associated image build
	// version.
	StepExecutionId *string

	// The ARN of the workflow resource that ran.
	WorkflowBuildVersionArn *string

	// Uniquely identifies the runtime instance of the workflow that contains the
	// workflow step that ran for the associated image build version.
	WorkflowExecutionId *string

	noSmithyDocumentSerde
}

// Runtime details and status for the workflow step.
type WorkflowStepMetadata struct {

	// The step action name.
	Action *string

	// Description of the workflow step.
	Description *string

	// The timestamp when the workflow step finished.
	EndTime *string

	// Input parameters that Image Builder provides for the workflow step.
	Inputs *string

	// Detailed output message that the workflow step provides at runtime.
	Message *string

	// The name of the workflow step.
	Name *string

	// The file names that the workflow step created as output for this runtime
	// instance of the workflow.
	Outputs *string

	// Reports on the rollback status of the step, if applicable.
	RollbackStatus WorkflowStepExecutionRollbackStatus

	// The timestamp when the workflow step started.
	StartTime *string

	// Runtime status for the workflow step.
	Status WorkflowStepExecutionStatus

	// A unique identifier for the workflow step, assigned at runtime.
	StepExecutionId *string

	noSmithyDocumentSerde
}

// Contains metadata about the workflow resource.
type WorkflowSummary struct {

	// The Amazon Resource Name (ARN) of the workflow resource.
	Arn *string

	// The change description for the current version of the workflow resource.
	ChangeDescription *string

	// The original creation date of the workflow resource.
	DateCreated *string

	// Describes the workflow.
	Description *string

	// The name of the workflow.
	Name *string

	// The owner of the workflow resource.
	Owner *string

	// Describes the current state of the workflow resource.
	State *WorkflowState

	// Contains a list of tags that are defined for the workflow.
	Tags map[string]string

	// The image creation stage that this workflow applies to. Image Builder currently
	// supports build and test stage workflows.
	Type WorkflowType

	// The version of the workflow.
	Version *string

	noSmithyDocumentSerde
}

// Contains details about this version of the workflow.
type WorkflowVersion struct {

	// The Amazon Resource Name (ARN) of the workflow resource.
	Arn *string

	// The timestamp when Image Builder created the workflow version.
	DateCreated *string

	// Describes the workflow.
	Description *string

	// The name of the workflow.
	Name *string

	// The owner of the workflow resource.
	Owner *string

	// The image creation stage that this workflow applies to. Image Builder currently
	// supports build and test stage workflows.
	Type WorkflowType

	// The semantic version of the workflow resource. The format includes three nodes:
	// ...
	Version *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
