//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devops/armdevops"
	"net/http"
)

// PipelineTemplateDefinitionsServer is a fake server for instances of the armdevops.PipelineTemplateDefinitionsClient type.
type PipelineTemplateDefinitionsServer struct {
	// NewListPager is the fake for method PipelineTemplateDefinitionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armdevops.PipelineTemplateDefinitionsClientListOptions) (resp azfake.PagerResponder[armdevops.PipelineTemplateDefinitionsClientListResponse])
}

// NewPipelineTemplateDefinitionsServerTransport creates a new instance of PipelineTemplateDefinitionsServerTransport with the provided implementation.
// The returned PipelineTemplateDefinitionsServerTransport instance is connected to an instance of armdevops.PipelineTemplateDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPipelineTemplateDefinitionsServerTransport(srv *PipelineTemplateDefinitionsServer) *PipelineTemplateDefinitionsServerTransport {
	return &PipelineTemplateDefinitionsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armdevops.PipelineTemplateDefinitionsClientListResponse]](),
	}
}

// PipelineTemplateDefinitionsServerTransport connects instances of armdevops.PipelineTemplateDefinitionsClient to instances of PipelineTemplateDefinitionsServer.
// Don't use this type directly, use NewPipelineTemplateDefinitionsServerTransport instead.
type PipelineTemplateDefinitionsServerTransport struct {
	srv          *PipelineTemplateDefinitionsServer
	newListPager *tracker[azfake.PagerResponder[armdevops.PipelineTemplateDefinitionsClientListResponse]]
}

// Do implements the policy.Transporter interface for PipelineTemplateDefinitionsServerTransport.
func (p *PipelineTemplateDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PipelineTemplateDefinitionsClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PipelineTemplateDefinitionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		resp := p.srv.NewListPager(nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armdevops.PipelineTemplateDefinitionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
