
// input12au7_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -1.500000
 // --table_div  7.844688
 // --table_op  0.250000

struct tableinput12au7_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tableinput12au7_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tableinput12au7_neg&() const { return *(tableinput12au7_neg*)this; }
};

 static tableinput12au7_neg_imp<2048> input12au7_neg_table __rt_data = {
	0,0.801348,341.167,2048, {
	0.000000000000,0.000617075314,0.001233855485,0.001850340646,0.002466530934,
	0.003082426484,0.003698027434,0.004313333919,0.004928346075,0.005543064038,
	0.006157487944,0.006771617929,0.007385454128,0.007998996678,0.008612245713,
	0.009225201369,0.009837863782,0.010450233088,0.011062309421,0.011674092917,
	0.012285583711,0.012896781939,0.013507687735,0.014118301235,0.014728622573,
	0.015338651884,0.015948389304,0.016557834967,0.017166989008,0.017775851562,
	0.018384422763,0.018992702745,0.019600691644,0.020208389593,0.020815796728,
	0.021422913182,0.022029739090,0.022636274585,0.023242519803,0.023848474876,
	0.024454139940,0.025059515127,0.025664600573,0.026269396410,0.026873902772,
	0.027478119794,0.028082047609,0.028685686350,0.029289036151,0.029892097145,
	0.030494869466,0.031097353247,0.031699548621,0.032301455722,0.032903074682,
	0.033504405636,0.034105448715,0.034706204053,0.035306671782,0.035906852036,
	0.036506744948,0.037106350649,0.037705669273,0.038304700952,0.038903445819,
	0.039501904007,0.040100075647,0.040697960872,0.041295559814,0.041892872606,
	0.042489899380,0.043086640268,0.043683095401,0.044279264912,0.044875148933,
	0.045470747596,0.046066061033,0.046661089374,0.047255832753,0.047850291300,
	0.048444465147,0.049038354425,0.049631959267,0.050225279803,0.050818316165,
	0.051411068484,0.052003536891,0.052595721518,0.053187622495,0.053779239953,
	0.054370574024,0.054961624838,0.055552392527,0.056142877220,0.056733079049,
	0.057322998144,0.057912634637,0.058501988656,0.059091060334,0.059679849800,
	0.060268357185,0.060856582619,0.061444526232,0.062032188154,0.062619568516,
	0.063206667448,0.063793485079,0.064380021540,0.064966276960,0.065552251470,
	0.066137945198,0.066723358276,0.067308490832,0.067893342995,0.068477914896,
	0.069062206665,0.069646218429,0.070229950319,0.070813402464,0.071396574994,
	0.071979468036,0.072562081722,0.073144416178,0.073726471536,0.074308247922,
	0.074889745467,0.075470964300,0.076051904548,0.076632566340,0.077212949806,
	0.077793055074,0.078372882271,0.078952431528,0.079531702972,0.080110696731,
	0.080689412934,0.081267851709,0.081846013184,0.082423897487,0.083001504747,
	0.083578835091,0.084155888647,0.084732665543,0.085309165907,0.085885389867,
	0.086461337549,0.087037009083,0.087612404596,0.088187524214,0.088762368066,
	0.089336936278,0.089911228979,0.090485246296,0.091058988355,0.091632455284,
	0.092205647210,0.092778564260,0.093351206561,0.093923574240,0.094495667423,
	0.095067486239,0.095639030812,0.096210301271,0.096781297742,0.097352020350,
	0.097922469224,0.098492644489,0.099062546271,0.099632174698,0.100201529895,
	0.100770611988,0.101339421104,0.101907957369,0.102476220909,0.103044211849,
	0.103611930317,0.104179376437,0.104746550336,0.105313452139,0.105880081972,
	0.106446439960,0.107012526230,0.107578340907,0.108143884115,0.108709155982,
	0.109274156632,0.109838886190,0.110403344781,0.110967532531,0.111531449566,
	0.112095096009,0.112658471986,0.113221577622,0.113784413042,0.114346978371,
	0.114909273733,0.115471299253,0.116033055057,0.116594541267,0.117155758010,
	0.117716705410,0.118277383590,0.118837792676,0.119397932792,0.119957804061,
	0.120517406609,0.121076740559,0.121635806036,0.122194603163,0.122753132065,
	0.123311392865,0.123869385687,0.124427110656,0.124984567894,0.125541757526,
	0.126098679675,0.126655334465,0.127211722019,0.127767842461,0.128323695915,
	0.128879282502,0.129434602348,0.129989655575,0.130544442306,0.131098962665,
	0.131653216774,0.132207204757,0.132760926737,0.133314382835,0.133867573176,
	0.134420497882,0.134973157076,0.135525550881,0.136077679418,0.136629542812,
	0.137181141183,0.137732474655,0.138283543350,0.138834347391,0.139384886899,
	0.139935161997,0.140485172807,0.141034919452,0.141584402053,0.142133620732,
	0.142682575611,0.143231266812,0.143779694457,0.144327858668,0.144875759567,
	0.145423397275,0.145970771913,0.146517883604,0.147064732468,0.147611318628,
	0.148157642204,0.148703703319,0.149249502093,0.149795038647,0.150340313102,
	0.150885325581,0.151430076203,0.151974565091,0.152518792364,0.153062758143,
	0.153606462550,0.154149905706,0.154693087730,0.155236008744,0.155778668868,
	0.156321068223,0.156863206930,0.157405085108,0.157946702878,0.158488060361,
	0.159029157677,0.159569994945,0.160110572287,0.160650889822,0.161190947671,
	0.161730745952,0.162270284787,0.162809564295,0.163348584596,0.163887345810,
	0.164425848057,0.164964091455,0.165502076126,0.166039802188,0.166577269760,
	0.167114478963,0.167651429916,0.168188122738,0.168724557548,0.169260734466,
	0.169796653610,0.170332315101,0.170867719056,0.171402865595,0.171937754838,
	0.172472386902,0.173006761907,0.173540879971,0.174074741213,0.174608345752,
	0.175141693707,0.175674785196,0.176207620338,0.176740199251,0.177272522053,
	0.177804588863,0.178336399799,0.178867954979,0.179399254523,0.179930298547,
	0.180461087169,0.180991620509,0.181521898684,0.182051921811,0.182581690009,
	0.183111203395,0.183640462088,0.184169466204,0.184698215862,0.185226711180,
	0.185754952273,0.186282939262,0.186810672261,0.187338151390,0.187865376765,
	0.188392348504,0.188919066724,0.189445531541,0.189971743074,0.190497701439,
	0.191023406753,0.191548859133,0.192074058697,0.192599005560,0.193123699840,
	0.193648141653,0.194172331116,0.194696268346,0.195219953460,0.195743386573,
	0.196266567802,0.196789497264,0.197312175075,0.197834601352,0.198356776210,
	0.198878699766,0.199400372136,0.199921793436,0.200442963782,0.200963883290,
	0.201484552076,0.202004970256,0.202525137946,0.203045055261,0.203564722317,
	0.204084139230,0.204603306116,0.205122223090,0.205640890267,0.206159307764,
	0.206677475695,0.207195394175,0.207713063321,0.208230483247,0.208747654068,
	0.209264575900,0.209781248858,0.210297673057,0.210813848611,0.211329775636,
	0.211845454246,0.212360884557,0.212876066682,0.213391000738,0.213905686838,
	0.214420125097,0.214934315630,0.215448258551,0.215961953974,0.216475402015,
	0.216988602787,0.217501556404,0.218014262981,0.218526722632,0.219038935472,
	0.219550901614,0.220062621172,0.220574094260,0.221085320992,0.221596301483,
	0.222107035845,0.222617524193,0.223127766641,0.223637763301,0.224147514288,
	0.224657019715,0.225166279696,0.225675294344,0.226184063773,0.226692588095,
	0.227200867425,0.227708901875,0.228216691559,0.228724236589,0.229231537080,
	0.229738593143,0.230245404892,0.230751972440,0.231258295900,0.231764375384,
	0.232270211006,0.232775802877,0.233281151112,0.233786255821,0.234291117119,
	0.234795735117,0.235300109928,0.235804241664,0.236308130437,0.236811776361,
	0.237315179547,0.237818340107,0.238321258154,0.238823933800,0.239326367156,
	0.239828558335,0.240330507449,0.240832214610,0.241333679928,0.241834903518,
	0.242335885489,0.242836625953,0.243337125023,0.243837382810,0.244337399426,
	0.244837174981,0.245336709588,0.245836003357,0.246335056401,0.246833868830,
	0.247332440756,0.247830772289,0.248328863541,0.248826714623,0.249324325647,
	0.249821696722,0.250318827960,0.250815719472,0.251312371368,0.251808783760,
	0.252304956758,0.252800890473,0.253296585015,0.253792040496,0.254287257024,
	0.254782234712,0.255276973669,0.255771474005,0.256265735832,0.256759759259,
	0.257253544397,0.257747091355,0.258240400244,0.258733471174,0.259226304254,
	0.259718899596,0.260211257308,0.260703377501,0.261195260284,0.261686905767,
	0.262178314061,0.262669485273,0.263160419515,0.263651116896,0.264141577524,
	0.264631801511,0.265121788964,0.265611539994,0.266101054709,0.266590333220,
	0.267079375634,0.267568182062,0.268056752612,0.268545087394,0.269033186516,
	0.269521050087,0.270008678217,0.270496071014,0.270983228587,0.271470151045,
	0.271956838496,0.272443291049,0.272929508813,0.273415491896,0.273901240407,
	0.274386754454,0.274872034146,0.275357079590,0.275841890896,0.276326468171,
	0.276810811524,0.277294921063,0.277778796896,0.278262439130,0.278745847875,
	0.279229023238,0.279711965326,0.280194674249,0.280677150112,0.281159393025,
	0.281641403095,0.282123180430,0.282604725137,0.283086037324,0.283567117098,
	0.284047964567,0.284528579838,0.285008963018,0.285489114216,0.285969033537,
	0.286448721090,0.286928176982,0.287407401319,0.287886394208,0.288365155757,
	0.288843686073,0.289321985263,0.289800053433,0.290277890690,0.290755497141,
	0.291232872893,0.291710018052,0.292186932726,0.292663617020,0.293140071041,
	0.293616294895,0.294092288690,0.294568052531,0.295043586525,0.295518890778,
	0.295993965396,0.296468810485,0.296943426152,0.297417812503,0.297891969643,
	0.298365897679,0.298839596717,0.299313066862,0.299786308220,0.300259320897,
	0.300732105000,0.301204660633,0.301676987902,0.302149086912,0.302620957770,
	0.303092600581,0.303564015451,0.304035202483,0.304506161785,0.304976893462,
	0.305447397617,0.305917674358,0.306387723789,0.306857546014,0.307327141140,
	0.307796509271,0.308265650512,0.308734564968,0.309203252744,0.309671713945,
	0.310139948675,0.310607957040,0.311075739143,0.311543295090,0.312010624985,
	0.312477728933,0.312944607038,0.313411259404,0.313877686137,0.314343887339,
	0.314809863116,0.315275613572,0.315741138812,0.316206438938,0.316671514055,
	0.317136364268,0.317600989680,0.318065390396,0.318529566519,0.318993518152,
	0.319457245401,0.319920748368,0.320384027158,0.320847081874,0.321309912619,
	0.321772519497,0.322234902613,0.322697062068,0.323158997968,0.323620710414,
	0.324082199510,0.324543465361,0.325004508068,0.325465327735,0.325925924466,
	0.326386298363,0.326846449530,0.327306378068,0.327766084083,0.328225567675,
	0.328684828949,0.329143868006,0.329602684951,0.330061279885,0.330519652911,
	0.330977804131,0.331435733649,0.331893441567,0.332350927987,0.332808193012,
	0.333265236745,0.333722059286,0.334178660740,0.334635041208,0.335091200791,
	0.335547139594,0.336002857717,0.336458355262,0.336913632332,0.337368689029,
	0.337823525454,0.338278141709,0.338732537897,0.339186714119,0.339640670476,
	0.340094407071,0.340547924005,0.341001221379,0.341454299296,0.341907157856,
	0.342359797161,0.342812217313,0.343264418413,0.343716400562,0.344168163861,
	0.344619708413,0.345071034317,0.345522141675,0.345973030588,0.346423701157,
	0.346874153483,0.347324387667,0.347774403811,0.348224202014,0.348673782377,
	0.349123145002,0.349572289989,0.350021217438,0.350469927451,0.350918420128,
	0.351366695569,0.351814753875,0.352262595147,0.352710219484,0.353157626987,
	0.353604817756,0.354051791892,0.354498549495,0.354945090664,0.355391415501,
	0.355837524105,0.356283416576,0.356729093014,0.357174553518,0.357619798190,
	0.358064827129,0.358509640434,0.358954238205,0.359398620542,0.359842787545,
	0.360286739313,0.360730475946,0.361173997542,0.361617304203,0.362060396027,
	0.362503273113,0.362945935561,0.363388383470,0.363830616940,0.364272636069,
	0.364714440957,0.365156031702,0.365597408404,0.366038571163,0.366479520076,
	0.366920255242,0.367360776762,0.367801084732,0.368241179253,0.368681060423,
	0.369120728341,0.369560183105,0.369999424813,0.370438453565,0.370877269459,
	0.371315872594,0.371754263067,0.372192440977,0.372630406423,0.373068159503,
	0.373505700314,0.373943028956,0.374380145527,0.374817050123,0.375253742845,
	0.375690223788,0.376126493053,0.376562550735,0.376998396934,0.377434031747,
	0.377869455272,0.378304667607,0.378739668849,0.379174459096,0.379609038446,
	0.380043406996,0.380477564843,0.380911512086,0.381345248821,0.381778775146,
	0.382212091159,0.382645196956,0.383078092634,0.383510778292,0.383943254026,
	0.384375519934,0.384807576112,0.385239422657,0.385671059666,0.386102487237,
	0.386533705466,0.386964714450,0.387395514286,0.387826105071,0.388256486900,
	0.388686659872,0.389116624083,0.389546379628,0.389975926606,0.390405265111,
	0.390834395241,0.391263317092,0.391692030761,0.392120536343,0.392548833936,
	0.392976923634,0.393404805535,0.393832479734,0.394259946328,0.394687205413,
	0.395114257084,0.395541101438,0.395967738571,0.396394168577,0.396820391554,
	0.397246407598,0.397672216802,0.398097819265,0.398523215080,0.398948404344,
	0.399373387152,0.399798163600,0.400222733783,0.400647097797,0.401071255737,
	0.401495207699,0.401918953777,0.402342494067,0.402765828664,0.403188957663,
	0.403611881160,0.404034599250,0.404457112027,0.404879419586,0.405301522023,
	0.405723419433,0.406145111909,0.406566599548,0.406987882444,0.407408960691,
	0.407829834384,0.408250503619,0.408670968488,0.409091229088,0.409511285513,
	0.409931137856,0.410350786213,0.410770230678,0.411189471345,0.411608508308,
	0.412027341663,0.412445971502,0.412864397920,0.413282621011,0.413700640870,
	0.414118457590,0.414536071265,0.414953481990,0.415370689858,0.415787694962,
	0.416204497398,0.416621097258,0.417037494637,0.417453689628,0.417869682324,
	0.418285472820,0.418701061208,0.419116447583,0.419531632038,0.419946614666,
	0.420361395560,0.420775974815,0.421190352523,0.421604528777,0.422018503672,
	0.422432277299,0.422845849752,0.423259221125,0.423672391509,0.424085360999,
	0.424498129687,0.424910697666,0.425323065029,0.425735231869,0.426147198279,
	0.426558964350,0.426970530177,0.427381895851,0.427793061466,0.428204027114,
	0.428614792887,0.429025358878,0.429435725179,0.429845891883,0.430255859082,
	0.430665626868,0.431075195334,0.431484564572,0.431893734675,0.432302705733,
	0.432711477840,0.433120051087,0.433528425567,0.433936601371,0.434344578592,
	0.434752357321,0.435159937650,0.435567319670,0.435974503475,0.436381489155,
	0.436788276802,0.437194866508,0.437601258364,0.438007452462,0.438413448894,
	0.438819247750,0.439224849123,0.439630253104,0.440035459783,0.440440469253,
	0.440845281605,0.441249896929,0.441654315318,0.442058536861,0.442462561651,
	0.442866389778,0.443270021334,0.443673456408,0.444076695093,0.444479737480,
	0.444882583658,0.445285233718,0.445687687753,0.446089945851,0.446492008105,
	0.446893874604,0.447295545439,0.447697020700,0.448098300479,0.448499384866,
	0.448900273951,0.449300967824,0.449701466576,0.450101770297,0.450501879077,
	0.450901793008,0.451301512177,0.451701036677,0.452100366597,0.452499502027,
	0.452898443056,0.453297189776,0.453695742276,0.454094100646,0.454492264975,
	0.454890235354,0.455288011872,0.455685594619,0.456082983685,0.456480179159,
	0.456877181131,0.457273989690,0.457670604927,0.458067026930,0.458463255788,
	0.458859291592,0.459255134431,0.459650784393,0.460046241569,0.460441506047,
	0.460836577917,0.461231457267,0.461626144187,0.462020638766,0.462414941094,
	0.462809051258,0.463202969348,0.463596695452,0.463990229661,0.464383572061,
	0.464776722743,0.465169681795,0.465562449306,0.465955025363,0.466347410057,
	0.466739603475,0.467131605707,0.467523416839,0.467915036962,0.468306466163,
	0.468697704531,0.469088752154,0.469479609120,0.469870275518,0.470260751435,
	0.470651036961,0.471041132182,0.471431037188,0.471820752066,0.472210276905,
	0.472599611791,0.472988756813,0.473377712060,0.473766477618,0.474155053576,
	0.474543440022,0.474931637042,0.475319644726,0.475707463159,0.476095092431,
	0.476482532628,0.476869783839,0.477256846150,0.477643719649,0.478030404423,
	0.478416900561,0.478803208148,0.479189327273,0.479575258022,0.479961000483,
	0.480346554744,0.480731920890,0.481117099009,0.481502089189,0.481886891515,
	0.482271506076,0.482655932958,0.483040172248,0.483424224033,0.483808088399,
	0.484191765434,0.484575255224,0.484958557855,0.485341673415,0.485724601989,
	0.486107343666,0.486489898530,0.486872266669,0.487254448168,0.487636443115,
	0.488018251596,0.488399873697,0.488781309504,0.489162559103,0.489543622582,
	0.489924500025,0.490305191519,0.490685697151,0.491066017005,0.491446151169,
	0.491826099728,0.492205862767,0.492585440374,0.492964832633,0.493344039631,
	0.493723061454,0.494101898186,0.494480549914,0.494859016723,0.495237298700,
	0.495615395928,0.495993308495,0.496371036486,0.496748579985,0.497125939079,
	0.497503113853,0.497880104392,0.498256910781,0.498633533106,0.499009971452,
	0.499386225904,0.499762296547,0.500138183466,0.500513886747,0.500889406473,
	0.501264742732,0.501639895606,0.502014865182,0.502389651544,0.502764254776,
	0.503138674964,0.503512912193,0.503886966546,0.504260838110,0.504634526967,
	0.505008033204,0.505381356904,0.505754498152,0.506127457033,0.506500233631,
	0.506872828029,0.507245240314,0.507617470568,0.507989518877,0.508361385324,
	0.508733069994,0.509104572971,0.509475894339,0.509847034181,0.510217992583,
	0.510588769628,0.510959365400,0.511329779983,0.511700013461,0.512070065918,
	0.512439937437,0.512809628103,0.513179137998,0.513548467208,0.513917615814,
	0.514286583902,0.514655371554,0.515023978855,0.515392405887,0.515760652734,
	0.516128719480,0.516496606208,0.516864313001,0.517231839943,0.517599187116,
	0.517966354605,0.518333342492,0.518700150860,0.519066779793,0.519433229374,
	0.519799499685,0.520165590810,0.520531502832,0.520897235834,0.521262789897,
	0.521628165107,0.521993361544,0.522358379293,0.522723218435,0.523087879053,
	0.523452361231,0.523816665050,0.524180790593,0.524544737943,0.524908507183,
	0.525272098394,0.525635511660,0.525998747062,0.526361804683,0.526724684606,
	0.527087386912,0.527449911684,0.527812259004,0.528174428954,0.528536421616,
	0.528898237073,0.529259875407,0.529621336699,0.529982621031,0.530343728486,
	0.530704659145,0.531065413090,0.531425990404,0.531786391167,0.532146615462,
	0.532506663370,0.532866534973,0.533226230352,0.533585749590,0.533945092768,
	0.534304259967,0.534663251269,0.535022066755,0.535380706506,0.535739170605,
	0.536097459132,0.536455572169,0.536813509797,0.537171272097,0.537528859150,
	0.537886271038,0.538243507841,0.538600569642,0.538957456520,0.539314168557,
	0.539670705833,0.540027068430,0.540383256429,0.540739269910,0.541095108955,
	0.541450773643,0.541806264056,0.542161580275,0.542516722380,0.542871690452,
	0.543226484571,0.543581104817,0.543935551273,0.544289824017,0.544643923131,
	0.544997848694,0.545351600788,0.545705179492,0.546058584887,0.546411817053,
	0.546764876070,0.547117762019,0.547470474979,0.547823015032,0.548175382256,
	0.548527576731,0.548879598539,0.549231447759,0.549583124470,0.549934628753,
	0.550285960687,0.550637120353,0.550988107830,0.551338923198,0.551689566536,
	0.552040037924,0.552390337443,0.552740465171,0.553090421188,0.553440205573,
	0.553789818407,0.554139259768,0.554488529736,0.554837628390,0.555186555810,
	0.555535312075,0.555883897264,0.556232311457,0.556580554732,0.556928627169,
	0.557276528847,0.557624259846,0.557971820243,0.558319210118,0.558666429550,
	0.559013478619,0.559360357402,0.559707065979,0.560053604429,0.560399972830,
	0.560746171262,0.561092199802,0.561438058530,0.561783747524,0.562129266863,
	0.562474616625,0.562819796890,0.563164807735,0.563509649239,0.563854321480,
	0.564198824538,0.564543158489,0.564887323413,0.565231319387,0.565575146491,
	0.565918804802,0.566262294399,0.566605615359,0.566948767760,0.567291751682,
	0.567634567201,0.567977214397,0.568319693346,0.568662004126,0.569004146817,
	0.569346121494,0.569687928238,0.570029567124,0.570371038231,0.570712341636,
	0.571053477418,0.571394445654,0.571735246421,0.572075879798,0.572416345860,
	0.572756644687,0.573096776356,0.573436740944,0.573776538528,0.574116169185,
	0.574455632994,0.574794930031,0.575134060374,0.575473024100,0.575811821286,
	0.576150452009,0.576488916346,0.576827214374,0.577165346171,0.577503311813,
	0.577841111378,0.578178744942,0.578516212582,0.578853514375,0.579190650398,
	0.579527620728,0.579864425441,0.580201064615,0.580537538325,0.580873846649,
	0.581209989662,0.581545967443,0.581881780067,0.582217427610,0.582552910150,
	0.582888227762,0.583223380523,0.583558368510,0.583893191799,0.584227850465,
	0.584562344586,0.584896674237,0.585230839496,0.585564840437,0.585898677137,
	0.586232349672,0.586565858118,0.586899202552,0.587232383048,0.587565399684,
	0.587898252535,0.588230941677,0.588563467185,0.588895829136,0.589228027605,
	0.589560062668,0.589891934401,0.590223642880,0.590555188179,0.590886570376,
	0.591217789544,0.591548845760,0.591879739100,0.592210469638,0.592541037450,
	0.592871442612,0.593201685198,0.593531765285,0.593861682947,0.594191438260,
	0.594521031299,0.594850462139,0.595179730856,0.595508837523,0.595837782218,
	0.596166565013,0.596495185986,0.596823645209,0.597151942759,0.597480078711,
	0.597808053139,0.598135866117,0.598463517722,0.598791008027,0.599118337108,
	0.599445505038,0.599772511894,0.600099357748,0.600426042677,0.600752566754,
	0.601078930054,0.601405132652,0.601731174621,0.602057056037,0.602382776974,
	0.602708337506,0.603033737707,0.603358977652,0.603684057415,0.604008977071,
	0.604333736692,0.604658336355,0.604982776132,0.605307056097,0.605631176326,
	0.605955136891,0.606278937868,0.606602579328,0.606926061348,0.607249384000,
	0.607572547358,0.607895551497,0.608218396490,0.608541082410,0.608863609332,
	0.609185977328,0.609508186474,0.609830236842,0.610152128506,0.610473861539,
	0.610795436015,0.611116852007,0.611438109590,0.611759208835,0.612080149818,
	0.612400932610,0.612721557285,0.613042023917,0.613362332579,0.613682483344,
	0.614002476285,0.614322311475,0.614641988987,0.614961508895,0.615280871271,
	0.615600076189,0.615919123721,0.616238013941,0.616556746921,0.616875322734,
	0.617193741453,0.617512003150,0.617830107899,0.618148055773,0.618465846843,
	0.618783481183,0.619100958865,0.619418279962,0.619735444546,0.620052452690,
	0.620369304466,0.620685999948,0.621002539207,0.621318922315,0.621635149345,
	0.621951220370,0.622267135462,0.622582894692,0.622898498134,0.623213945859,
	0.623529237939,0.623844374448,0.624159355455,0.624474181035,0.624788851259,
	0.625103366198,0.625417725925,0.625731930512,0.626045980031,0.626359874553,
	0.626673614150,0.626987198895,0.627300628858,0.627613904112,0.627927024728,
	0.628239990779,0.628552802335,0.628865459468,0.629177962250,0.629490310752,
	0.629802505046,0.630114545203,0.630426431295,0.630738163394,0.631049741569,
	0.631361165894,0.631672436438,0.631983553274,0.632294516473,0.632605326106,
	0.632915982243,0.633226484957,0.633536834318,0.633847030397,0.634157073266,
	0.634466962995,0.634776699655,0.635086283318,0.635395714054,0.635704991934,
	0.636014117029,0.636323089410,0.636631909147,0.636940576311,0.637249090974,
	0.637557453205,0.637865663076,0.638173720656,0.638481626017,0.638789379229,
	0.639096980363,0.639404429489,0.639711726677,0.640018871998,0.640325865523,
	0.640632707321,0.640939397464,0.641245936020,0.641552323061,0.641858558658,
	0.642164642879,0.642470575795,0.642776357477,0.643081987994,0.643387467416,
	0.643692795814,0.643997973257,0.644302999816,0.644607875561,0.644912600560,
	0.645217174885,0.645521598605,0.645825871790,0.646129994509,0.646433966833,
	0.646737788831,0.647041460572,0.647344982127,0.647648353565,0.647951574956,
	0.648254646369,0.648557567873,0.648860339538,0.649162961435,0.649465433631,
	0.649767756197,0.650069929201,0.650371952714,0.650673826804,0.650975551540,
	0.651277126993,0.651578553230,0.651879830322,0.652180958338,0.652481937346,
	0.652782767415,0.653083448615,0.653383981015,0.653684364683,0.653984599689,
	0.654284686102,0.654584623990,0.654884413422,0.655184054467,0.655483547194,
	0.655782891671,0.656082087968,0.656381136153,0.656680036294,0.656978788461,
	0.657277392721,0.657575849145,0.657874157799,0.658172318752,0.658470332073,
	0.658768197831,0.659065916094,0.659363486930,0.659660910407,0.659958186594,
	0.660255315560,0.660552297371,0.660849132098,0.661145819807,0.661442360567,
	0.661738754446,0.662035001512,0.662331101833,0.662627055478,0.662922862514,
	0.663218523009,0.663514037031,0.663809404648,0.664104625928,0.664399700939,
	0.664694629749,0.664989412425,0.665284049035,0.665578539647,0.665872884328,
	0.666167083147,0.666461136170,0.666755043466,0.667048805102,0.667342421145,
	0.667635891663,0.667929216724,0.668222396394,0.668515430742,0.668808319835,
	0.669101063739,0.669393662523,0.669686116254,0.669978424998,0.670270588823,
	0.670562607797,0.670854481986,0.671146211458,0.671437796279,0.671729236518,
	0.672020532240,0.672311683512,0.672602690403,0.672893552978,0.673184271304,
	0.673474845450,0.673765275480,0.674055561463,0.674345703464,0.674635701552,
	0.674925555792,0.675215266250,0.675504832995,0.675794256092,0.676083535608,
	0.676372671610,0.676661664164,0.676950513336,0.677239219194,0.677527781803,
	0.677816201230,0.678104477542,0.678392610804,0.678680601084,0.678968448447,
	0.679256152959,0.679543714688,0.679831133698,0.680118410057,0.680405543830,
	0.680692535084,0.680979383884,0.681266090297,0.681552654389,0.681839076225,
	0.682125355872,0.682411493396,0.682697488862,0.682983342337,0.683269053885,
	0.683554623574,0.683840051469,0.684125337635,0.684410482138,0.684695485044,
	0.684980346419,0.685265066328,0.685549644837,0.685834082012,0.686118377917,
	0.686402532619,0.686686546183,0.686970418674,0.687254150158,0.687537740700,
	0.687821190366,0.688104499220,0.688387667329,0.688670694757,0.688953581570,
	0.689236327833,0.689518933611,0.689801398969,0.690083723972,0.690365908686,
	0.690647953176,0.690929857506,0.691211621741,0.691493245947,0.691774730188,
	0.692056074530,0.692337279036,0.692618343773,0.692899268805,0.693180054196,
	0.693460700012,0.693741206317,0.694021573176,0.694301800653,0.694581888814,
	0.694861837722,0.695141647442,0.695421318040,0.695700849579,0.695980242123,
	0.696259495739,0.696538610488,0.696817586438,0.697096423650,0.697375122191,
	0.697653682124,0.697932103513,0.698210386423,0.698488530918,0.698766537062,
	0.699044404920,0.699322134555,0.699599726032,0.699877179414,0.700154494766,
	0.700431672152,0.700708711635,0.700985613280,0.701262377151,0.701539003311,
	0.701815491825,0.702091842755,0.702368056167,0.702644132124,0.702920070689,
	0.703195871926,0.703471535900,0.703747062673,0.704022452309,0.704297704872,
	0.704572820426,0.704847799033,0.705122640759,0.705397345665,0.705671913815,
	0.705946345274,0.706220640104,0.706494798368,0.706768820130,0.707042705454,
	0.707316454402,0.707590067039,0.707863543426,0.708136883628,0.708410087707,
	0.708683155726,0.708956087749,0.709228883839,0.709501544059,0.709774068472,
	0.710046457141,0.710318710128,0.710590827497,0.710862809311,0.711134655632,
	0.711406366524,0.711677942049,0.711949382269,0.712220687249,0.712491857050,
	0.712762891735,0.713033791367,0.713304556009,0.713575185722,0.713845680571,
	0.714116040616,0.714386265922,0.714656356550,0.714926312562,0.715196134022,
	0.715465820991,0.715735373532,0.716004791708,0.716274075580,0.716543225212,
	0.716812240664,0.717081122001,0.717349869282,0.717618482572,0.717886961932,
	0.718155307424,0.718423519110,0.718691597053,0.718959541314,0.719227351956,
	0.719495029040,0.719762572628,0.720029982783,0.720297259565,0.720564403038,
	0.720831413263,0.721098290301,0.721365034215,0.721631645067,0.721898122917,
	0.722164467828,0.722430679861,0.722696759078,0.722962705541,0.723228519311,
	0.723494200450,0.723759749020,0.724025165081,0.724290448695,0.724555599924,
	0.724820618829,0.725085505472,0.725350259913,0.725614882215,0.725879372438,
	0.726143730644,0.726407956894,0.726672051250,0.726936013771,0.727199844521,
	0.727463543559,0.727727110947,0.727990546746,0.728253851017,0.728517023821,
	0.728780065219,0.729042975271,0.729305754040,0.729568401586,0.729830917969,
	0.730093303251,0.730355557492,0.730617680753,0.730879673096,0.731141534580,
	0.731403265266,0.731664865215,0.731926334488,0.732187673146,0.732448881248,
	0.732709958856,0.732970906030,0.733231722831,0.733492409319,0.733752965554,
	0.734013391597,0.734273687509,0.734533853350,0.734793889179,0.735053795058,
	0.735313571047,0.735573217206,0.735832733595,0.736092120274,0.736351377304,
	0.736610504745,0.736869502657,0.737128371100,0.737387110133,0.737645719818,
	0.737904200215,0.738162551382,0.738420773381,0.738678866270,0.738936830111,
	0.739194664962,0.739452370884,0.739709947936,0.739967396179,0.740224715672,
	0.740481906475,0.740738968647,0.740995902249,0.741252707339,0.741509383978,
	0.741765932225,0.742022352139,0.742278643781,0.742534807210,0.742790842485,
	0.743046749665,0.743302528811,0.743558179982,0.743813703236,0.744069098634,
	0.744324366234,0.744579506096,0.744834518280,0.745089402844,0.745344159847,
	0.745598789350,0.745853291411,0.746107666088,0.746361913443,0.746616033532,
	0.746870026416,0.747123892154,0.747377630804,0.747631242425,0.747884727077,
	0.748138084818,0.748391315707,0.748644419804,0.748897397166,0.749150247853,
	0.749402971924,0.749655569437,0.749908040451,0.750160385025,0.750412603217,
	0.750664695086,0.750916660691,0.751168500090,0.751420213342,0.751671800505,
	0.751923261638,0.752174596800,0.752425806049,0.752676889442,0.752927847040,
	0.753178678899,0.753429385079,0.753679965638,0.753930420634,0.754180750125,
	0.754430954170,0.754681032826,0.754930986153,0.755180814207,0.755430517048,
	0.755680094734,0.755929547322,0.756178874870,0.756428077437,0.756677155081,
	0.756926107859,0.757174935830,0.757423639051,0.757672217580,0.757920671476,
	0.758169000796,0.758417205597,0.758665285939,0.758913241877,0.759161073471,
	0.759408780778,0.759656363856,0.759903822761,0.760151157553,0.760398368288,
	0.760645455024,0.760892417818,0.761139256729,0.761385971814,0.761632563129,
	0.761879030733,0.762125374683,0.762371595037,0.762617691851,0.762863665183,
	0.763109515091,0.763355241631,0.763600844861,0.763846324838,0.764091681620,
	0.764336915264,0.764582025826,0.764827013364,0.765071877934,0.765316619595,
	0.765561238403,0.765805734415,0.766050107689,0.766294358280,0.766538486246,
	0.766782491644,0.767026374531,0.767270134964,0.767513773000,0.767757288694,
	0.768000682105,0.768243953289,0.768487102302,0.768730129202,0.768973034045,
	0.769215816887,0.769458477786,0.769701016798,0.769943433979,0.770185729387,
	0.770427903077,0.770669955106,0.770911885530,0.771153694407,0.771395381792,
	0.771636947742,0.771878392313,0.772119715562,0.772360917545,0.772601998318,
	0.772842957937,0.773083796459,0.773324513940,0.773565110435,0.773805586003,
	0.774045940697,0.774286174575,0.774526287693,0.774766280106,0.775006151871,
	0.775245903044,0.775485533680,0.775725043836,0.775964433568,0.776203702931,
	0.776442851982,0.776681880775,0.776920789368,0.777159577815,0.777398246173,
	0.777636794498,0.777875222845,0.778113531269,0.778351719827,0.778589788574,
	0.778827737565,0.779065566857,0.779303276505,0.779540866565,0.779778337091,
	0.780015688140,0.780252919767,0.780490032027,0.780727024976,0.780963898669,
	0.781200653162,0.781437288509,0.781673804767,0.781910201990,0.782146480234,
	0.782382639554,0.782618680006,0.782854601644,0.783090404523,0.783326088699,
	0.783561654227,0.783797101162,0.784032429558,0.784267639472,0.784502730958,
	0.784737704071,0.784972558865,0.785207295397,0.785441913721,0.785676413891,
	0.785910795963,0.786145059991,0.786379206030,0.786613234135,0.786847144362,
	0.787080936763,0.787314611395,0.787548168311,0.787781607568,0.788014929218,
	0.788248133317,0.788481219919,0.788714189080,0.788947040852,0.789179775292,
	0.789412392453,0.789644892390,0.789877275157,0.790109540809,0.790341689400,
	0.790573720985,0.790805635617,0.791037433351,0.791269114242,0.791500678343,
	0.791732125710,0.791963456395,0.792194670453,0.792425767939,0.792656748907,
	0.792887613410,0.793118361502,0.793348993239,0.793579508673,0.793809907859,
	0.794040190851,0.794270357703,0.794500408468,0.794730343201,0.794960161955,
	0.795189864785,0.795419451744,0.795648922885,0.795878278264,0.796107517933,
	0.796336641946,0.796565650357,0.796794543220,0.797023320588,0.797251982515,
	0.797480529054,0.797708960260,0.797937276185,0.798165476883,0.798393562408,
	0.798621532814,0.798849388153,0.799077128479,0.799304753845,0.799532264306,
	0.799759659913,0.799986940722,0.800214106784,0.800441158153,0.800668094883,
	0.800894917027,0.801121624637,0.801348217768
	}
};

double always_inline input12au7_negclip(double x) {
    double f = fabs(x);
    f = f * input12au7_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = input12au7_neg_table.data[0];
    } else if (i >= input12au7_neg_table.size-1) {
        f = input12au7_neg_table.data[input12au7_neg_table.size-1];
    } else {
    f -= i;
    f = input12au7_neg_table.data[i]*(1-f) + input12au7_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

