; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -inline -instcombine %s | FileCheck %s --check-prefixes=CHECK,CHECK-INLINE
; RUN: opt -S -instcombine %s | FileCheck %s --check-prefixes=CHECK,CHECK-NOINLINE

define i8* @widen_align_from_allocalign_callsite() {
; CHECK-LABEL: @widen_align_from_allocalign_callsite(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call align 64 i8* @my_aligned_alloc_2(i32 noundef 320, i32 allocalign noundef 64)
; CHECK-NEXT:    ret i8* [[CALL]]
;
entry:

  %call = tail call align 16 i8* @my_aligned_alloc_2(i32 noundef 320, i32 allocalign noundef 64)
  ret i8* %call
}

define i8* @widen_align_from_allocalign() {
; CHECK-LABEL: @widen_align_from_allocalign(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call align 64 i8* @my_aligned_alloc(i32 noundef 320, i32 noundef 64)
; CHECK-NEXT:    ret i8* [[CALL]]
;
entry:

  %call = tail call align 16 i8* @my_aligned_alloc(i32 noundef 320, i32 noundef 64)
  ret i8* %call
}

define i8* @dont_narrow_align_from_allocalign() {
; CHECK-LABEL: @dont_narrow_align_from_allocalign(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = tail call align 16 i8* @my_aligned_alloc(i32 noundef 320, i32 noundef 8)
; CHECK-NEXT:    ret i8* [[CALL]]
;
entry:
  %call = tail call align 16 i8* @my_aligned_alloc(i32 noundef 320, i32 noundef 8)
  ret i8* %call
}

define i8* @my_aligned_alloc_3(i32 noundef %foo, i32 allocalign %alignment) {
; CHECK-LABEL: @my_aligned_alloc_3(
; CHECK-NEXT:    [[CALL:%.*]] = tail call i8* @my_aligned_alloc_2(i32 noundef [[FOO:%.*]], i32 noundef [[ALIGNMENT:%.*]])
; CHECK-NEXT:    ret i8* [[CALL]]
;
  %call = tail call i8* @my_aligned_alloc_2(i32 noundef %foo, i32 noundef %alignment)
  ret i8* %call
}

; -inline is able to make my_aligned_alloc_3's arguments disappear and directly
; call my_aligned_alloc_2, but the latter has no allocalign so the alignment just
; disappears. This is conservatively correct but undesirable because we can't
; figure out the `align 128` on the return value once the call is directly on
; my_aligned_alloc_2. Note that this is a simplified version of what happens
; with _mm_malloc which calls posix_memalign.
define i8* @allocalign_disappears() {
; CHECK-INLINE-LABEL: @allocalign_disappears(
; CHECK-INLINE-NEXT:    [[CALL_I:%.*]] = tail call i8* @my_aligned_alloc_2(i32 noundef 42, i32 noundef 128)
; CHECK-INLINE-NEXT:    ret i8* [[CALL_I]]
;
; CHECK-NOINLINE-LABEL: @allocalign_disappears(
; CHECK-NOINLINE-NEXT:    [[CALL:%.*]] = tail call align 128 i8* @my_aligned_alloc_3(i32 42, i32 128)
; CHECK-NOINLINE-NEXT:    ret i8* [[CALL]]
;
  %call = tail call i8* @my_aligned_alloc_3(i32 42, i32 128)
  ret i8* %call
}

declare i8* @my_aligned_alloc(i32 noundef, i32 allocalign noundef)
declare i8* @my_aligned_alloc_2(i32 noundef, i32 noundef)
