/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import de.erichseifert.vectorgraphics2d.util.DataUtils;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class FormattingWriter
implements Closeable,
Flushable,
AutoCloseable {
    private final OutputStream a;
    private final String b;
    private final byte[] c;
    private long d;

    public FormattingWriter(OutputStream outputStream, String string, String string2) throws UnsupportedEncodingException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null.");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("End-of-line string cannot be empty.");
        }
        this.a = outputStream;
        this.b = string;
        this.c = string2.getBytes(string);
    }

    public FormattingWriter write(byte[] byArray) throws IOException {
        this.a.write(byArray, 0, byArray.length);
        this.d += (long)byArray.length;
        return this;
    }

    public FormattingWriter write(String object) throws IOException {
        object = ((String)object).getBytes(this.b);
        return this.write((byte[])object);
    }

    public FormattingWriter write(String string, Object ... objectArray) throws IOException {
        return this.write(String.format(null, string, objectArray));
    }

    public FormattingWriter write(Number number) throws IOException {
        return this.write(DataUtils.format(number));
    }

    public FormattingWriter writeln() throws IOException {
        return this.write(this.c);
    }

    public FormattingWriter writeln(byte[] byArray) throws IOException {
        this.write(byArray);
        return this.writeln();
    }

    public FormattingWriter writeln(String string) throws IOException {
        this.write(string);
        return this.writeln();
    }

    public FormattingWriter writeln(String string, Object ... objectArray) throws IOException {
        this.write(String.format(null, string, objectArray));
        return this.writeln();
    }

    public FormattingWriter writeln(Number number) throws IOException {
        this.write(number);
        return this.writeln();
    }

    @Override
    public void flush() throws IOException {
        this.a.flush();
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    public long tell() {
        return this.d;
    }
}

