#include <stdint.h>

/* BSC -> MSC */
const uint8_t bssmap_reset[18] = {
	0x09, 0x00, 0x03, 0x05, 0x07, 0x02, 0x42, 0xfe,
	0x02, 0x42, 0xfe, 0x06, 0x00, 0x04, 0x30, 0x04,
	0x01, 0x20,
};

/* MSC -> BSC reset ack */
const uint8_t bssmap_reset_ack[19] = {
	0x09, 0x00, 0x03, 0x07, 0x0b, 0x04, 0x43, 0x01,
	0x00, 0xfe, 0x04, 0x43, 0x5c, 0x00, 0xfe, 0x03,
	0x00, 0x01, 0x31,
};

/* MSC -> BSC paging, connection less */
const uint8_t bssmap_paging[32] = {
	0x09, 0x00, 0x03, 0x07, 0x0b, 0x04, 0x43, 0x01,
	0x00, 0xfe, 0x04, 0x43, 0x5c, 0x00, 0xfe, 0x10,
	0x00, 0x0e, 0x52, 0x08, 0x08, 0x29, 0x47, 0x10,
	0x02, 0x01, 0x31, 0x97, 0x61, 0x1a, 0x01, 0x06,
};

/* MSC -> BSC paging, UDT without PC  */
const uint8_t bssmap_udt[28] = {
	0x09, 0x00, 0x03, 0x05, 0x07, 0x02, 0x42, 0xfe,
	0x02, 0x42, 0xfe, 0x10, 0x00, 0x0e, 0x52, 0x08,
	0x08, 0x29, 0x47, 0x10, 0x02, 0x01, 0x31, 0x97,
	0x61, 0x1a, 0x01, 0x06,
};

/* BSC -> MSC connection open */
const uint8_t bssmap_cr[44] = {
	0x01, 0x01, 0x02, 0x03, 0x02, 0x02, 0x04, 0x02,
	0x42, 0xfe, 0x0f, 0x1f, 0x00, 0x1d, 0x57, 0x05,
	0x08, 0x00, 0x72, 0xf4, 0x80, 0x20, 0x12, 0xc3,
	0x50, 0x17, 0x10, 0x05, 0x24, 0x11, 0x03, 0x33,
	0x19, 0xa2, 0x08, 0x29, 0x47, 0x10, 0x02, 0x01,
	0x31, 0x97, 0x61, 0x00
};

/* MSC -> BSC connection confirm */
const uint8_t bssmap_cc[10] = {
	0x02, 0x01, 0x02, 0x03, 0x00, 0x00, 0x03, 0x02, 0x01, 0x00,
};

/* MSC -> BSC DTAP
 *
 * we fake a bit and make it BSC -> MSC... so the
 * payload does not make any sense..
 */
const uint8_t bssmap_dtap[22] = {
	0x06, 0x00, 0x00, 0x03, 0x00, 0x01, 0x0f, 0x01, 0x00, 0x0c,
	0x03, 0x05, 0x5c, 0x08, 0x11, 0x81, 0x33, 0x66, 0x02, 0x13,
	0x45, 0xf4,
};

/* MSC -> BSC clear command */
const uint8_t bssmap_clear[13] = {
	0x06, 0x00, 0x00, 0x03, 0x00, 0x01, 0x06, 0x00, 0x04, 0x20,
	0x04, 0x01, 0x09,
};

/* MSC -> BSC released */
const uint8_t bssmap_released[14] = {
	0x04, 0x00, 0x00, 0x03, 0x01, 0x02, 0x03, 0x00, 0x01, 0x0f,
	0x02, 0x23, 0x42, 0x00,
};

/* BSC -> MSC released */
const uint8_t bssmap_release_complete[7] = {
	0x05, 0x01, 0x02, 0x03, 0x00, 0x00, 0x03
};

/* message with a SCCP global title */
const uint8_t tcap_global_title[183] = {
	0x09,
	0x81, 0x03, 0x0d, 0x18, 0x0a, 0x12, 0x07, 0x00,
	0x12, 0x04, 0x53, 0x84, 0x09, 0x00, 0x17, 0x0b,
	0x12, 0x06, 0x00, 0x12, 0x04, 0x44, 0x87, 0x20,
	0x00, 0x20, 0x65, 0x9a, 0x65, 0x81, 0x97, 0x48,
	0x04, 0x26, 0x00, 0x01, 0x98, 0x49, 0x04, 0x51,
	0x01, 0x03, 0xdf, 0x6c, 0x81, 0x88, 0xa1, 0x81,
	0x85, 0x02, 0x01, 0x44, 0x02, 0x01, 0x07, 0x30,
	0x80, 0xa7, 0x80, 0xa0, 0x80, 0x04, 0x01, 0x2b,
	0x30, 0x80, 0x30, 0x12, 0x83, 0x01, 0x10, 0x84,
	0x01, 0x07, 0x85, 0x07, 0x91, 0x44, 0x57, 0x76,
	0x67, 0x16, 0x97, 0x86, 0x01, 0x20, 0x30, 0x06,
	0x82, 0x01, 0x18, 0x84, 0x01, 0x04, 0x00, 0x00,
	0x00, 0x00, 0xa3, 0x06, 0x04, 0x01, 0x42, 0x84,
	0x01, 0x05, 0xa3, 0x06, 0x04, 0x01, 0x51, 0x84,
	0x01, 0x05, 0xa3, 0x06, 0x04, 0x01, 0x31, 0x84,
	0x01, 0x05, 0xa3, 0x09, 0x04, 0x01, 0x12, 0x84,
	0x01, 0x05, 0x82, 0x01, 0x02, 0xa3, 0x09, 0x04,
	0x01, 0x11, 0x84, 0x01, 0x05, 0x81, 0x01, 0x01,
	0xa3, 0x06, 0x04, 0x01, 0x14, 0x84, 0x01, 0x00,
	0xa3, 0x0b, 0x04, 0x01, 0x41, 0x84, 0x01, 0x04,
	0x30, 0x03, 0x83, 0x01, 0x10, 0xa3, 0x0b, 0x04,
	0x01, 0x41, 0x84, 0x01, 0x04, 0x30, 0x03, 0x82,
	0x01, 0x18, 0x00, 0x00, 0x00, 0x00
};

/* SCCP LUDT message containing a RANAP RESET */
const uint8_t ludt_ranap_reset[40] = {
	0x13, 0x00, 0x0f, 0x07, 0x00, 0x0a, 0x00, 0x0d,
	0x00, 0x00, 0x00, 0x04, 0x43, 0xc4, 0x04, 0x8e,
	0x04, 0x43, 0xe9, 0x03, 0x8e, 0x11, 0x00, 0x00,
	0x09, 0x00, 0x0d, 0x00, 0x00, 0x02, 0x00, 0x04,
	0x40, 0x01, 0x42, 0x00, 0x03, 0x00, 0x01, 0x00
};

const uint8_t ludt_data300bytes[323] = {
	0x13, 0x00, 0x0f, 0x07, 0x00, 0x0a, 0x00, 0x0d,
	0x00, 0x00, 0x00, 0x04, 0x43, 0xc4, 0x04, 0x8e,
	0x04, 0x43, 0xe9, 0x03, 0x8e, 0x2c, 0x01, 0xab, /* 0x2c, 0x01 (network order) = len = 300 */
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
	0xab, 0xab, 0xab,
};
