import { Arbitrary } from './definition/Arbitrary';
/**
 * For pure functions
 *
 * @param arb Arbitrary responsible to produce the values
 */
export declare function func<TArgs extends any[], TOut>(arb: Arbitrary<TOut>): Arbitrary<(...args: TArgs) => TOut>;
/**
 * For comparison functions
 *
 * A comparison function returns:
 * - negative value whenever a < b
 * - positive value whenever a > b
 * - zero whenever a and b are equivalent
 *
 * Comparison functions are transitive: `a < b and b < c => a < c`
 *
 * They also satisfy: `a < b <=> b > a` and `a = b <=> b = a`
 */
export declare function compareFunc<T>(): Arbitrary<(a: T, b: T) => number>;
/**
 * For comparison boolean functions
 *
 * A comparison boolean function returns:
 * - true whenever a < b
 * - false otherwise (ie. a = b or a > b)
 */
export declare function compareBooleanFunc<T>(): Arbitrary<(a: T, b: T) => boolean>;
