<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

September 11, 2020

Host: Carol Payne

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Zach Lewis - Method
  * [X] Christophe Brejon
  * [X] Simran Spiller

# **OCIO Documentation Working Group Meeting Notes**

* API doc generation:
    - Michael: Wondering if I should pick up API docs work from Sean to help.
    - Doug: Let’s propose an approach and get Sean’s buy-in. Think we need to 
      look closely at Python docs approach. This will be the main entry point 
      into OCIO for many users.
    - Doug: Another challenge is that doxygen in headers is more verbose. 
      Original OCIO headers were minimalist, only documenting where really 
      needed.
    - Michael: Can some parts be omitted?
    - Doug: Could probably find a middle ground.
    - Michael: Are you wanting to go away from doxygen? Or just revise style?
    - Doug: Prefer original OCIO style, but not sure what the best approach 
      for Python docs are. Like how OIIO combines reference and explanation 
      into one thing, but requires more manual work. Think the guide portions 
      of the docs (the ultimately python docs) would be that. Python and C++ 
      would be separate. C++ would be minimal, more like OCIO v1, and 
      purpose-build Python docs.
    - Carol: Have no issue with putting most serviceable info in Python docs.
    - Doug: Sean’s goal was to come up with something easy to maintain, but 
      have not yet resolved C++/Python differences.
    - **TODO**: Open issue around python/C++ docs proposal for discussion with 
      Sean. Figure out plan and move forward.

* Check-in on other doc efforts:
    - Carol: How’s it going with current efforts?
    - Christophe update:
        - Looking at sample OCIO configurations.
        - Small description would help to know what is being downloaded. The 
          size is pretty big, so would be good to know up front what is being 
          downloaded and how large it is.
        - Can we link to up-to-date ACES 1.2 config instead?
        - Carol: Currently focusing on new ACES config, in the new repo. Will 
          have new repo for housing contributed configs.
        - Zach: Need documentation around configs and how to use them. 
          Difficult to learn now.
        - Doug: Agree. The current spi-vfx config is a good example for 
          documentation, including some theory for how to do color management, 
          and how color transforms were designed. Time consuming to write, but 
          impossible to understand config contents without that.
        - Carol: Not only is it how to build a config, but it’s also around 
          Python being the intended way to create a config, so documentation 
          can center around that. Manual edits are error prone and not ideal.
        - Zach: All references really useful, but some are sparse. Having 
          specific python implementation examples would help. Discussed Python 
          examples for GPU viewers before?
        - Michael: Yes. Have talked about Python versions of apps. Many studios 
          have internal tools that are excellent examples, but would be great 
          to get some of that into the open. I’ve written several. Might be 
          able to share or contribute one.
        - Zach: What about Jupyter notebook for code examples?
        - Carol: Would be great to have something for people to experiment, 
          once we get content done.
        - Christophe: Looking at how to list configs. Could show 
          current configs first. Would be great to show the changes between 
          versions; include changelist with config versions?
        - Carol: Why not just link to the GitHub releases? Could point to where 
          they live and their documentation.
        - Christophe: Yes, that makes sense. Think we could revise the TOC 
          levels and what is included in the sidebar. Could do some cleanup.
        - Doug: Excellent work going through docs. Want to give you more 
          ability to create issues and PRs so you can contribute efficiently 
          to capture this information.
    - Zach update:
        - Going through all of the docs, looking at areas that need more 
          content. Looking at missing tool documentation. ocioconvert seems 
          inconsistent in the interface. I’ll open an issue around that.
        - Doug: Yes agree, there is some inconsistency between tool interfaces. 
          Would be good to have issue around commandline tool UIs, and some 
          standard args to make them consistent.
        - Zach: Yes, consistency and conventions and ability to specify context 
          variables in commandline for example. Going to look at ocioperf next. 
          Wrote some docs around ociobakelut.
        - Michael: Might be worth calling out Baker and Processor.write() since 
          those also bake things too.
        - Zach: Added some content for ociolutimage. Should I include the ACES 
          config as an example?
        - Carol: I like that idea. It’s a complex example, but a good one.
        - Zach: Should I include usage info from tools themselves? Some have it 
          and some don’t.
        - Michael: Wonder if we could generate manpages to include. They can be 
          found with some linux distros.
        - Zach: Not sure if I should create issue per tool or as one unit.
        - Doug: Think if the work is submitted together can be one issue.
        - Michael: You can use GH Actions to test build in your fork, and feel 
          free to open draft PR for feedback. Not mergeable, but good for 
          input.
        - Zach: Could add some documentation on shaper LUTs.
        - Doug: CLF has log op to be more compact. Would be good to cover that. 
          ociomakeclf has csc option, and can convert LUT into CTF. Can make 
          AMF compliant LMT as well.
        - Zach: Should we reach out to studios to get census on current climate 
          of OCIO usage. Would be great to have various implementation examples.
        - Michael: Yes, agree. More examples like the spi-vfx docs would be 
          awesome.
        - Zach: Would love to share how Method uses OCIO in commercials and 
          features. Would like to provide tools or examples, etc.
