# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AutoPauseProperties(Model):
    """Spark pool auto-pausing properties.

    Auto-pausing properties of a Big Data pool powered by Apache Spark.

    :param delay_in_minutes: Number of minutes of idle time before the Big
     Data pool is automatically paused.
    :type delay_in_minutes: int
    :param enabled: Whether auto-pausing is enabled for the Big Data pool.
    :type enabled: bool
    """

    _attribute_map = {
        'delay_in_minutes': {'key': 'delayInMinutes', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AutoPauseProperties, self).__init__(**kwargs)
        self.delay_in_minutes = kwargs.get('delay_in_minutes', None)
        self.enabled = kwargs.get('enabled', None)


class AutoScaleProperties(Model):
    """Spark pool auto-scaling properties.

    Auto-scaling properties of a Big Data pool powered by Apache Spark.

    :param min_node_count: The minimum number of nodes the Big Data pool can
     support.
    :type min_node_count: int
    :param enabled: Whether automatic scaling is enabled for the Big Data
     pool.
    :type enabled: bool
    :param max_node_count: The maximum number of nodes the Big Data pool can
     support.
    :type max_node_count: int
    """

    _attribute_map = {
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AutoScaleProperties, self).__init__(**kwargs)
        self.min_node_count = kwargs.get('min_node_count', None)
        self.enabled = kwargs.get('enabled', None)
        self.max_node_count = kwargs.get('max_node_count', None)


class AvailableRpOperation(Model):
    """An operation that is available in this resource provider.

    :param display: Display properties of the operation
    :type display: ~azure.mgmt.synapse.models.AvailableRpOperationDisplayInfo
    :param is_data_action: Whether this operation is a data action
    :type is_data_action: str
    :param name: Operation name
    :type name: str
    :param service_specification: Operation service specification
    :type service_specification:
     ~azure.mgmt.synapse.models.OperationMetaServiceSpecification
    :param origin: Operation origin
    :type origin: str
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'AvailableRpOperationDisplayInfo'},
        'is_data_action': {'key': 'isDataAction', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationMetaServiceSpecification'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AvailableRpOperation, self).__init__(**kwargs)
        self.display = kwargs.get('display', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.name = kwargs.get('name', None)
        self.service_specification = kwargs.get('service_specification', None)
        self.origin = kwargs.get('origin', None)


class AvailableRpOperationDisplayInfo(Model):
    """Description of an available operation.

    :param description: Operation description
    :type description: str
    :param resource: Resource type
    :type resource: str
    :param provider: Resource provider name
    :type provider: str
    :param operation: Operation name
    :type operation: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AvailableRpOperationDisplayInfo, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.resource = kwargs.get('resource', None)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class BigDataPoolPatchInfo(Model):
    """Patch for a Big Data pool.

    Properties patch for a Big Data pool.

    :param tags: Updated tags for the Big Data pool
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(BigDataPoolPatchInfo, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)


class BigDataPoolResourceInfo(TrackedResource):
    """Big Data pool.

    A Big Data pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param provisioning_state: The state of the Big Data pool.
    :type provisioning_state: str
    :param auto_scale: Auto-scaling properties
    :type auto_scale: ~azure.mgmt.synapse.models.AutoScaleProperties
    :param creation_date: The time when the Big Data pool was created.
    :type creation_date: datetime
    :param auto_pause: Auto-pausing properties
    :type auto_pause: ~azure.mgmt.synapse.models.AutoPauseProperties
    :param spark_events_folder: The Spark events folder
    :type spark_events_folder: str
    :param node_count: The number of nodes in the Big Data pool.
    :type node_count: int
    :param library_requirements: Library version requirements
    :type library_requirements: ~azure.mgmt.synapse.models.LibraryRequirements
    :param spark_version: The Apache Spark version.
    :type spark_version: str
    :param default_spark_log_folder: The default folder where Spark logs will
     be written.
    :type default_spark_log_folder: str
    :param node_size: The level of compute power that each node in the Big
     Data pool has. Possible values include: 'None', 'Small', 'Medium', 'Large'
    :type node_size: str or ~azure.mgmt.synapse.models.NodeSize
    :param node_size_family: The kind of nodes that the Big Data pool
     provides. Possible values include: 'None', 'MemoryOptimized'
    :type node_size_family: str or ~azure.mgmt.synapse.models.NodeSizeFamily
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'node_count': {'maximum': 200, 'minimum': 3},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'auto_scale': {'key': 'properties.autoScale', 'type': 'AutoScaleProperties'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'auto_pause': {'key': 'properties.autoPause', 'type': 'AutoPauseProperties'},
        'spark_events_folder': {'key': 'properties.sparkEventsFolder', 'type': 'str'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'int'},
        'library_requirements': {'key': 'properties.libraryRequirements', 'type': 'LibraryRequirements'},
        'spark_version': {'key': 'properties.sparkVersion', 'type': 'str'},
        'default_spark_log_folder': {'key': 'properties.defaultSparkLogFolder', 'type': 'str'},
        'node_size': {'key': 'properties.nodeSize', 'type': 'str'},
        'node_size_family': {'key': 'properties.nodeSizeFamily', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BigDataPoolResourceInfo, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.auto_scale = kwargs.get('auto_scale', None)
        self.creation_date = kwargs.get('creation_date', None)
        self.auto_pause = kwargs.get('auto_pause', None)
        self.spark_events_folder = kwargs.get('spark_events_folder', None)
        self.node_count = kwargs.get('node_count', None)
        self.library_requirements = kwargs.get('library_requirements', None)
        self.spark_version = kwargs.get('spark_version', None)
        self.default_spark_log_folder = kwargs.get('default_spark_log_folder', None)
        self.node_size = kwargs.get('node_size', None)
        self.node_size_family = kwargs.get('node_size_family', None)


class CheckNameAvailabilityRequest(Model):
    """Check name availability request.

    A request about whether a workspace name is available.

    :param name: Workspace name
    :type name: str
    :param type: Type: workspace
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class CheckNameAvailabilityResponse(Model):
    """Check name availability response.

    A response saying whether the workspace name is available.

    :param message: Validation message
    :type message: str
    :param available: Whether the workspace name is available
    :type available: bool
    :param reason: Reason the workspace name is or is not available
    :type reason: str
    :param name: Workspace name
    :type name: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.available = kwargs.get('available', None)
        self.reason = kwargs.get('reason', None)
        self.name = kwargs.get('name', None)


class CloudError(Model):
    """The object that defines the structure of an Azure Synapse error response.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Property name/path in request associated with error.
    :type target: str
    :param details: Array with additional error details.
    :type details: list[~azure.mgmt.synapse.models.CloudError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'target': {'key': 'error.target', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[CloudError]'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CustomSetupBase(Model):
    """The base definition of the custom setup.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CmdkeySetup, EnvironmentVariableSetup, ComponentSetup

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'CmdkeySetup': 'CmdkeySetup', 'EnvironmentVariableSetup': 'EnvironmentVariableSetup', 'ComponentSetup': 'ComponentSetup'}
    }

    def __init__(self, **kwargs):
        super(CustomSetupBase, self).__init__(**kwargs)
        self.type = None


class CmdkeySetup(CustomSetupBase):
    """The custom setup of running cmdkey commands.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param target_name: Required. The server name of data source access.
    :type target_name: object
    :param user_name: Required. The user name of data source access.
    :type user_name: object
    :param password: Required. The password of data source access.
    :type password: ~azure.mgmt.synapse.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'target_name': {'required': True},
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'target_name': {'key': 'typeProperties.targetName', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(self, **kwargs):
        super(CmdkeySetup, self).__init__(**kwargs)
        self.target_name = kwargs.get('target_name', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.type = 'CmdkeySetup'


class ComponentSetup(CustomSetupBase):
    """The custom setup of installing 3rd party components.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param component_name: Required. The name of the 3rd party component.
    :type component_name: str
    :param license_key: The license key to activate the component.
    :type license_key: ~azure.mgmt.synapse.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'component_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'component_name': {'key': 'typeProperties.componentName', 'type': 'str'},
        'license_key': {'key': 'typeProperties.licenseKey', 'type': 'SecretBase'},
    }

    def __init__(self, **kwargs):
        super(ComponentSetup, self).__init__(**kwargs)
        self.component_name = kwargs.get('component_name', None)
        self.license_key = kwargs.get('license_key', None)
        self.type = 'ComponentSetup'


class CreateSqlPoolRestorePointDefinition(Model):
    """Contains the information necessary to perform a create Sql pool restore
    point operation.

    All required parameters must be populated in order to send to Azure.

    :param restore_point_label: Required. The restore point label to apply
    :type restore_point_label: str
    """

    _validation = {
        'restore_point_label': {'required': True},
    }

    _attribute_map = {
        'restore_point_label': {'key': 'restorePointLabel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateSqlPoolRestorePointDefinition, self).__init__(**kwargs)
        self.restore_point_label = kwargs.get('restore_point_label', None)


class DataLakeStorageAccountDetails(Model):
    """Details of the data lake storage account associated with the workspace.

    :param account_url: Account URL
    :type account_url: str
    :param filesystem: Filesystem name
    :type filesystem: str
    """

    _attribute_map = {
        'account_url': {'key': 'accountUrl', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataLakeStorageAccountDetails, self).__init__(**kwargs)
        self.account_url = kwargs.get('account_url', None)
        self.filesystem = kwargs.get('filesystem', None)


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class DataWarehouseUserActivities(ProxyResource):
    """User activities of a data warehouse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar active_queries_count: Count of running and suspended queries.
    :vartype active_queries_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'active_queries_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'active_queries_count': {'key': 'properties.activeQueriesCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DataWarehouseUserActivities, self).__init__(**kwargs)
        self.active_queries_count = None


class EntityReference(Model):
    """The entity reference.

    :param type: The type of this referenced entity. Possible values include:
     'IntegrationRuntimeReference', 'LinkedServiceReference'
    :type type: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeEntityReferenceType
    :param reference_name: The name of this referenced entity.
    :type reference_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EntityReference, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.reference_name = kwargs.get('reference_name', None)


class EnvironmentVariableSetup(CustomSetupBase):
    """The custom setup of setting environment variable.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param variable_name: Required. The name of the environment variable.
    :type variable_name: str
    :param variable_value: Required. The value of the environment variable.
    :type variable_value: str
    """

    _validation = {
        'type': {'required': True},
        'variable_name': {'required': True},
        'variable_value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'variable_value': {'key': 'typeProperties.variableValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentVariableSetup, self).__init__(**kwargs)
        self.variable_name = kwargs.get('variable_name', None)
        self.variable_value = kwargs.get('variable_value', None)
        self.type = 'EnvironmentVariableSetup'


class ErrorAdditionalInfo(Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorContract(Model):
    """Error details.

    Contains details when the response code indicates an error.

    :param error: The error details.
    :type error: ~azure.mgmt.synapse.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, **kwargs):
        super(ErrorContract, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorContractException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorContract'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorContractException, self).__init__(deserialize, response, 'ErrorContract', *args)


class ErrorDetail(Model):
    """Error details.

    :param message: Error message
    :type message: str
    :param code: Error code
    :type code: str
    :param target: Error target
    :type target: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetail, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)


class ErrorResponse(Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.synapse.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.synapse.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class GeoBackupPolicy(ProxyResource):
    """A database geo backup policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param state: Required. The state of the geo backup policy. Possible
     values include: 'Disabled', 'Enabled'
    :type state: str or ~azure.mgmt.synapse.models.GeoBackupPolicyState
    :ivar storage_type: The storage type of the geo backup policy.
    :vartype storage_type: str
    :ivar kind: Kind of geo backup policy.  This is metadata used for the
     Azure portal experience.
    :vartype kind: str
    :ivar location: Backup policy location.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'storage_type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'GeoBackupPolicyState'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GeoBackupPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.storage_type = None
        self.kind = None
        self.location = None


class GetSsisObjectMetadataRequest(Model):
    """The request payload of get SSIS object metadata.

    :param metadata_path: Metadata path.
    :type metadata_path: str
    """

    _attribute_map = {
        'metadata_path': {'key': 'metadataPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GetSsisObjectMetadataRequest, self).__init__(**kwargs)
        self.metadata_path = kwargs.get('metadata_path', None)


class IntegrationRuntime(Model):
    """Azure Synapse nested object which serves as a compute resource for
    activities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedIntegrationRuntime, SelfHostedIntegrationRuntime

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param description: Integration runtime description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Managed': 'ManagedIntegrationRuntime', 'SelfHosted': 'SelfHostedIntegrationRuntime'}
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntime, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.description = kwargs.get('description', None)
        self.type = None


class IntegrationRuntimeAuthKeys(Model):
    """The integration runtime authentication keys.

    :param auth_key1: The primary integration runtime authentication key.
    :type auth_key1: str
    :param auth_key2: The secondary integration runtime authentication key.
    :type auth_key2: str
    """

    _attribute_map = {
        'auth_key1': {'key': 'authKey1', 'type': 'str'},
        'auth_key2': {'key': 'authKey2', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeAuthKeys, self).__init__(**kwargs)
        self.auth_key1 = kwargs.get('auth_key1', None)
        self.auth_key2 = kwargs.get('auth_key2', None)


class IntegrationRuntimeComputeProperties(Model):
    """The compute resource properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param location: The location for managed integration runtime. The
     supported regions could be found on
     https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
    :type location: str
    :param node_size: The node size requirement to managed integration
     runtime.
    :type node_size: str
    :param number_of_nodes: The required number of nodes for managed
     integration runtime.
    :type number_of_nodes: int
    :param max_parallel_executions_per_node: Maximum parallel executions count
     per node for managed integration runtime.
    :type max_parallel_executions_per_node: int
    :param data_flow_properties: Data flow properties for managed integration
     runtime.
    :type data_flow_properties:
     ~azure.mgmt.synapse.models.IntegrationRuntimeDataFlowProperties
    :param v_net_properties: VNet properties for managed integration runtime.
    :type v_net_properties:
     ~azure.mgmt.synapse.models.IntegrationRuntimeVNetProperties
    """

    _validation = {
        'number_of_nodes': {'minimum': 1},
        'max_parallel_executions_per_node': {'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'location': {'key': 'location', 'type': 'str'},
        'node_size': {'key': 'nodeSize', 'type': 'str'},
        'number_of_nodes': {'key': 'numberOfNodes', 'type': 'int'},
        'max_parallel_executions_per_node': {'key': 'maxParallelExecutionsPerNode', 'type': 'int'},
        'data_flow_properties': {'key': 'dataFlowProperties', 'type': 'IntegrationRuntimeDataFlowProperties'},
        'v_net_properties': {'key': 'vNetProperties', 'type': 'IntegrationRuntimeVNetProperties'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeComputeProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.location = kwargs.get('location', None)
        self.node_size = kwargs.get('node_size', None)
        self.number_of_nodes = kwargs.get('number_of_nodes', None)
        self.max_parallel_executions_per_node = kwargs.get('max_parallel_executions_per_node', None)
        self.data_flow_properties = kwargs.get('data_flow_properties', None)
        self.v_net_properties = kwargs.get('v_net_properties', None)


class IntegrationRuntimeConnectionInfo(Model):
    """Connection information for encrypting the on-premises data source
    credentials.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar service_token: The token generated in service. Callers use this
     token to authenticate to integration runtime.
    :vartype service_token: str
    :ivar identity_cert_thumbprint: The integration runtime SSL certificate
     thumbprint. Click-Once application uses it to do server validation.
    :vartype identity_cert_thumbprint: str
    :ivar host_service_uri: The on-premises integration runtime host URL.
    :vartype host_service_uri: str
    :ivar version: The integration runtime version.
    :vartype version: str
    :ivar public_key: The public key for encrypting a credential when
     transferring the credential to the integration runtime.
    :vartype public_key: str
    :ivar is_identity_cert_exprired: Whether the identity certificate is
     expired.
    :vartype is_identity_cert_exprired: bool
    """

    _validation = {
        'service_token': {'readonly': True},
        'identity_cert_thumbprint': {'readonly': True},
        'host_service_uri': {'readonly': True},
        'version': {'readonly': True},
        'public_key': {'readonly': True},
        'is_identity_cert_exprired': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'service_token': {'key': 'serviceToken', 'type': 'str'},
        'identity_cert_thumbprint': {'key': 'identityCertThumbprint', 'type': 'str'},
        'host_service_uri': {'key': 'hostServiceUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'public_key': {'key': 'publicKey', 'type': 'str'},
        'is_identity_cert_exprired': {'key': 'isIdentityCertExprired', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeConnectionInfo, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.service_token = None
        self.identity_cert_thumbprint = None
        self.host_service_uri = None
        self.version = None
        self.public_key = None
        self.is_identity_cert_exprired = None


class IntegrationRuntimeCustomSetupScriptProperties(Model):
    """Custom setup script properties for a managed dedicated integration runtime.

    :param blob_container_uri: The URI of the Azure blob container that
     contains the custom setup script.
    :type blob_container_uri: str
    :param sas_token: The SAS token of the Azure blob container.
    :type sas_token: ~azure.mgmt.synapse.models.SecureString
    """

    _attribute_map = {
        'blob_container_uri': {'key': 'blobContainerUri', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'SecureString'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeCustomSetupScriptProperties, self).__init__(**kwargs)
        self.blob_container_uri = kwargs.get('blob_container_uri', None)
        self.sas_token = kwargs.get('sas_token', None)


class IntegrationRuntimeDataFlowProperties(Model):
    """Data flow properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param compute_type: Compute type of the cluster which will execute data
     flow job. Possible values include: 'General', 'MemoryOptimized',
     'ComputeOptimized'
    :type compute_type: str or ~azure.mgmt.synapse.models.DataFlowComputeType
    :param core_count: Core count of the cluster which will execute data flow
     job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
    :type core_count: int
    :param time_to_live: Time to live (in minutes) setting of the cluster
     which will execute data flow job.
    :type time_to_live: int
    """

    _validation = {
        'time_to_live': {'minimum': 0},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'time_to_live': {'key': 'timeToLive', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeDataFlowProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.compute_type = kwargs.get('compute_type', None)
        self.core_count = kwargs.get('core_count', None)
        self.time_to_live = kwargs.get('time_to_live', None)


class IntegrationRuntimeDataProxyProperties(Model):
    """Data proxy properties for a managed dedicated integration runtime.

    :param connect_via: The self-hosted integration runtime reference.
    :type connect_via: ~azure.mgmt.synapse.models.EntityReference
    :param staging_linked_service: The staging linked service reference.
    :type staging_linked_service: ~azure.mgmt.synapse.models.EntityReference
    :param path: The path to contain the staged data in the Blob storage.
    :type path: str
    """

    _attribute_map = {
        'connect_via': {'key': 'connectVia', 'type': 'EntityReference'},
        'staging_linked_service': {'key': 'stagingLinkedService', 'type': 'EntityReference'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeDataProxyProperties, self).__init__(**kwargs)
        self.connect_via = kwargs.get('connect_via', None)
        self.staging_linked_service = kwargs.get('staging_linked_service', None)
        self.path = kwargs.get('path', None)


class IntegrationRuntimeMonitoringData(Model):
    """Get monitoring data response.

    :param name: Integration runtime name.
    :type name: str
    :param nodes: Integration runtime node monitoring data.
    :type nodes:
     list[~azure.mgmt.synapse.models.IntegrationRuntimeNodeMonitoringData]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'nodes': {'key': 'nodes', 'type': '[IntegrationRuntimeNodeMonitoringData]'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeMonitoringData, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.nodes = kwargs.get('nodes', None)


class IntegrationRuntimeNodeIpAddress(Model):
    """The IP address of self-hosted integration runtime node.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar ip_address: The IP address of self-hosted integration runtime node.
    :vartype ip_address: str
    """

    _validation = {
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeNodeIpAddress, self).__init__(**kwargs)
        self.ip_address = None


class IntegrationRuntimeNodeMonitoringData(Model):
    """Monitoring data for integration runtime node.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar node_name: Name of the integration runtime node.
    :vartype node_name: str
    :ivar available_memory_in_mb: Available memory (MB) on the integration
     runtime node.
    :vartype available_memory_in_mb: int
    :ivar cpu_utilization: CPU percentage on the integration runtime node.
    :vartype cpu_utilization: int
    :ivar concurrent_jobs_limit: Maximum concurrent jobs on the integration
     runtime node.
    :vartype concurrent_jobs_limit: int
    :ivar concurrent_jobs_running: The number of jobs currently running on the
     integration runtime node.
    :vartype concurrent_jobs_running: int
    :ivar max_concurrent_jobs: The maximum concurrent jobs in this integration
     runtime.
    :vartype max_concurrent_jobs: int
    :ivar sent_bytes: Sent bytes on the integration runtime node.
    :vartype sent_bytes: float
    :ivar received_bytes: Received bytes on the integration runtime node.
    :vartype received_bytes: float
    """

    _validation = {
        'node_name': {'readonly': True},
        'available_memory_in_mb': {'readonly': True},
        'cpu_utilization': {'readonly': True},
        'concurrent_jobs_limit': {'readonly': True},
        'concurrent_jobs_running': {'readonly': True},
        'max_concurrent_jobs': {'readonly': True},
        'sent_bytes': {'readonly': True},
        'received_bytes': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'node_name': {'key': 'nodeName', 'type': 'str'},
        'available_memory_in_mb': {'key': 'availableMemoryInMB', 'type': 'int'},
        'cpu_utilization': {'key': 'cpuUtilization', 'type': 'int'},
        'concurrent_jobs_limit': {'key': 'concurrentJobsLimit', 'type': 'int'},
        'concurrent_jobs_running': {'key': 'concurrentJobsRunning', 'type': 'int'},
        'max_concurrent_jobs': {'key': 'maxConcurrentJobs', 'type': 'int'},
        'sent_bytes': {'key': 'sentBytes', 'type': 'float'},
        'received_bytes': {'key': 'receivedBytes', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeNodeMonitoringData, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.node_name = None
        self.available_memory_in_mb = None
        self.cpu_utilization = None
        self.concurrent_jobs_limit = None
        self.concurrent_jobs_running = None
        self.max_concurrent_jobs = None
        self.sent_bytes = None
        self.received_bytes = None


class IntegrationRuntimeRegenerateKeyParameters(Model):
    """Parameters to regenerate the authentication key.

    :param key_name: The name of the authentication key to regenerate.
     Possible values include: 'authKey1', 'authKey2'
    :type key_name: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeAuthKeyName
    """

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)


class SubResource(Model):
    """Azure Synapse nested resource, which belongs to a factory.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class IntegrationRuntimeResource(SubResource):
    """Integration runtime resource type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :param properties: Required. Integration runtime properties.
    :type properties: ~azure.mgmt.synapse.models.IntegrationRuntime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IntegrationRuntime'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class IntegrationRuntimeSsisCatalogInfo(Model):
    """Catalog information for managed dedicated integration runtime.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param catalog_server_endpoint: The catalog database server URL.
    :type catalog_server_endpoint: str
    :param catalog_admin_user_name: The administrator user name of catalog
     database.
    :type catalog_admin_user_name: str
    :param catalog_admin_password: The password of the administrator user
     account of the catalog database.
    :type catalog_admin_password: ~azure.mgmt.synapse.models.SecureString
    :param catalog_pricing_tier: The pricing tier for the catalog database.
     The valid values could be found in
     https://azure.microsoft.com/en-us/pricing/details/sql-database/. Possible
     values include: 'Basic', 'Standard', 'Premium', 'PremiumRS'
    :type catalog_pricing_tier: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeSsisCatalogPricingTier
    """

    _validation = {
        'catalog_admin_user_name': {'max_length': 128, 'min_length': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'catalog_server_endpoint': {'key': 'catalogServerEndpoint', 'type': 'str'},
        'catalog_admin_user_name': {'key': 'catalogAdminUserName', 'type': 'str'},
        'catalog_admin_password': {'key': 'catalogAdminPassword', 'type': 'SecureString'},
        'catalog_pricing_tier': {'key': 'catalogPricingTier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeSsisCatalogInfo, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.catalog_server_endpoint = kwargs.get('catalog_server_endpoint', None)
        self.catalog_admin_user_name = kwargs.get('catalog_admin_user_name', None)
        self.catalog_admin_password = kwargs.get('catalog_admin_password', None)
        self.catalog_pricing_tier = kwargs.get('catalog_pricing_tier', None)


class IntegrationRuntimeSsisProperties(Model):
    """SSIS properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param catalog_info: Catalog information for managed dedicated integration
     runtime.
    :type catalog_info:
     ~azure.mgmt.synapse.models.IntegrationRuntimeSsisCatalogInfo
    :param license_type: License type for bringing your own license scenario.
     Possible values include: 'BasePrice', 'LicenseIncluded'
    :type license_type: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeLicenseType
    :param custom_setup_script_properties: Custom setup script properties for
     a managed dedicated integration runtime.
    :type custom_setup_script_properties:
     ~azure.mgmt.synapse.models.IntegrationRuntimeCustomSetupScriptProperties
    :param data_proxy_properties: Data proxy properties for a managed
     dedicated integration runtime.
    :type data_proxy_properties:
     ~azure.mgmt.synapse.models.IntegrationRuntimeDataProxyProperties
    :param edition: The edition for the SSIS Integration Runtime. Possible
     values include: 'Standard', 'Enterprise'
    :type edition: str or ~azure.mgmt.synapse.models.IntegrationRuntimeEdition
    :param express_custom_setup_properties: Custom setup without script
     properties for a SSIS integration runtime.
    :type express_custom_setup_properties:
     list[~azure.mgmt.synapse.models.CustomSetupBase]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'catalog_info': {'key': 'catalogInfo', 'type': 'IntegrationRuntimeSsisCatalogInfo'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'custom_setup_script_properties': {'key': 'customSetupScriptProperties', 'type': 'IntegrationRuntimeCustomSetupScriptProperties'},
        'data_proxy_properties': {'key': 'dataProxyProperties', 'type': 'IntegrationRuntimeDataProxyProperties'},
        'edition': {'key': 'edition', 'type': 'str'},
        'express_custom_setup_properties': {'key': 'expressCustomSetupProperties', 'type': '[CustomSetupBase]'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeSsisProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.catalog_info = kwargs.get('catalog_info', None)
        self.license_type = kwargs.get('license_type', None)
        self.custom_setup_script_properties = kwargs.get('custom_setup_script_properties', None)
        self.data_proxy_properties = kwargs.get('data_proxy_properties', None)
        self.edition = kwargs.get('edition', None)
        self.express_custom_setup_properties = kwargs.get('express_custom_setup_properties', None)


class IntegrationRuntimeStatus(Model):
    """Integration runtime status.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedIntegrationRuntimeStatus,
    SelfHostedIntegrationRuntimeStatus

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar data_factory_name: The workspace name which the integration runtime
     belong to.
    :vartype data_factory_name: str
    :ivar state: The state of integration runtime. Possible values include:
     'Initial', 'Stopped', 'Started', 'Starting', 'Stopping',
     'NeedRegistration', 'Online', 'Limited', 'Offline', 'AccessDenied'
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'data_factory_name': {'readonly': True},
        'state': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Managed': 'ManagedIntegrationRuntimeStatus', 'SelfHosted': 'SelfHostedIntegrationRuntimeStatus'}
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeStatus, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.data_factory_name = None
        self.state = None
        self.type = None


class IntegrationRuntimeStatusResponse(Model):
    """Integration runtime status response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The integration runtime name.
    :vartype name: str
    :param properties: Required. Integration runtime properties.
    :type properties: ~azure.mgmt.synapse.models.IntegrationRuntimeStatus
    """

    _validation = {
        'name': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IntegrationRuntimeStatus'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeStatusResponse, self).__init__(**kwargs)
        self.name = None
        self.properties = kwargs.get('properties', None)


class IntegrationRuntimeVNetProperties(Model):
    """VNet properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param v_net_id: The ID of the VNet that this integration runtime will
     join.
    :type v_net_id: str
    :param subnet: The name of the subnet this integration runtime will join.
    :type subnet: str
    :param public_ips: Resource IDs of the public IP addresses that this
     integration runtime will use.
    :type public_ips: list[str]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'v_net_id': {'key': 'vNetId', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
        'public_ips': {'key': 'publicIPs', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(IntegrationRuntimeVNetProperties, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.v_net_id = kwargs.get('v_net_id', None)
        self.subnet = kwargs.get('subnet', None)
        self.public_ips = kwargs.get('public_ips', None)


class IpFirewallRuleInfo(ProxyResource):
    """IP firewall rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param end_ip_address: The end IP address of the firewall rule. Must be
     IPv4 format. Must be greater than or equal to startIpAddress
    :type end_ip_address: str
    :ivar provisioning_state: Resource provisioning state. Possible values
     include: 'Provisioning', 'Succeeded', 'Deleting', 'Failed', 'DeleteError'
    :vartype provisioning_state: str or
     ~azure.mgmt.synapse.models.ProvisioningState
    :param start_ip_address: The start IP address of the firewall rule. Must
     be IPv4 format
    :type start_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IpFirewallRuleInfo, self).__init__(**kwargs)
        self.end_ip_address = kwargs.get('end_ip_address', None)
        self.provisioning_state = None
        self.start_ip_address = kwargs.get('start_ip_address', None)


class IpFirewallRuleProperties(Model):
    """IP firewall rule properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param end_ip_address: The end IP address of the firewall rule. Must be
     IPv4 format. Must be greater than or equal to startIpAddress
    :type end_ip_address: str
    :ivar provisioning_state: Resource provisioning state. Possible values
     include: 'Provisioning', 'Succeeded', 'Deleting', 'Failed', 'DeleteError'
    :vartype provisioning_state: str or
     ~azure.mgmt.synapse.models.ProvisioningState
    :param start_ip_address: The start IP address of the firewall rule. Must
     be IPv4 format
    :type start_ip_address: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'end_ip_address': {'key': 'endIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'start_ip_address': {'key': 'startIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IpFirewallRuleProperties, self).__init__(**kwargs)
        self.end_ip_address = kwargs.get('end_ip_address', None)
        self.provisioning_state = None
        self.start_ip_address = kwargs.get('start_ip_address', None)


class LibraryRequirements(Model):
    """Spark pool library version requirements.

    Library requirements for a Big Data pool powered by Apache Spark.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar time: The last update time of the library requirements file.
    :vartype time: datetime
    :param content: The library requirements.
    :type content: str
    :param filename: The filename of the library requirements file.
    :type filename: str
    """

    _validation = {
        'time': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'content': {'key': 'content', 'type': 'str'},
        'filename': {'key': 'filename', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LibraryRequirements, self).__init__(**kwargs)
        self.time = None
        self.content = kwargs.get('content', None)
        self.filename = kwargs.get('filename', None)


class LinkedIntegrationRuntime(Model):
    """The linked integration runtime information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the linked integration runtime.
    :vartype name: str
    :ivar subscription_id: The subscription ID for which the linked
     integration runtime belong to.
    :vartype subscription_id: str
    :ivar data_factory_name: The name of the workspace for which the linked
     integration runtime belong to.
    :vartype data_factory_name: str
    :ivar data_factory_location: The location of the workspace for which the
     linked integration runtime belong to.
    :vartype data_factory_location: str
    :ivar create_time: The creating time of the linked integration runtime.
    :vartype create_time: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'data_factory_name': {'readonly': True},
        'data_factory_location': {'readonly': True},
        'create_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'data_factory_location': {'key': 'dataFactoryLocation', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(LinkedIntegrationRuntime, self).__init__(**kwargs)
        self.name = None
        self.subscription_id = None
        self.data_factory_name = None
        self.data_factory_location = None
        self.create_time = None


class LinkedIntegrationRuntimeType(Model):
    """The base definition of a linked integration runtime.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LinkedIntegrationRuntimeKeyAuthorization,
    LinkedIntegrationRuntimeRbacAuthorization

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. Constant filled by server.
    :type authorization_type: str
    """

    _validation = {
        'authorization_type': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
    }

    _subtype_map = {
        'authorization_type': {'Key': 'LinkedIntegrationRuntimeKeyAuthorization', 'RBAC': 'LinkedIntegrationRuntimeRbacAuthorization'}
    }

    def __init__(self, **kwargs):
        super(LinkedIntegrationRuntimeType, self).__init__(**kwargs)
        self.authorization_type = None


class LinkedIntegrationRuntimeKeyAuthorization(LinkedIntegrationRuntimeType):
    """The key authorization type integration runtime.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. Constant filled by server.
    :type authorization_type: str
    :param key: Required. The key used for authorization.
    :type key: ~azure.mgmt.synapse.models.SecureString
    """

    _validation = {
        'authorization_type': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'SecureString'},
    }

    def __init__(self, **kwargs):
        super(LinkedIntegrationRuntimeKeyAuthorization, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.authorization_type = 'Key'


class LinkedIntegrationRuntimeRbacAuthorization(LinkedIntegrationRuntimeType):
    """The role based access control (RBAC) authorization type integration
    runtime.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. Constant filled by server.
    :type authorization_type: str
    :param resource_id: Required. The resource identifier of the integration
     runtime to be shared.
    :type resource_id: str
    """

    _validation = {
        'authorization_type': {'required': True},
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LinkedIntegrationRuntimeRbacAuthorization, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.authorization_type = 'RBAC'


class ManagedIdentity(Model):
    """The workspace managed identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal ID of the workspace managed identity
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the workspace managed identity
    :vartype tenant_id: str
    :param type: The type of managed identity for the workspace. Possible
     values include: 'None', 'SystemAssigned'
    :type type: str or ~azure.mgmt.synapse.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
    }

    def __init__(self, **kwargs):
        super(ManagedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class ManagedIdentitySqlControlSettingsModel(ProxyResource):
    """Managed Identity Sql Control Settings.

    Sql Control Settings for workspace managed identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param grant_sql_control_to_managed_identity: Grant sql control to managed
     identity
    :type grant_sql_control_to_managed_identity:
     ~azure.mgmt.synapse.models.ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'grant_sql_control_to_managed_identity': {'key': 'properties.grantSqlControlToManagedIdentity', 'type': 'ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity'},
    }

    def __init__(self, **kwargs):
        super(ManagedIdentitySqlControlSettingsModel, self).__init__(**kwargs)
        self.grant_sql_control_to_managed_identity = kwargs.get('grant_sql_control_to_managed_identity', None)


class ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity(Model):
    """Grant sql control to managed identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param desired_state: Desired state. Possible values include: 'Enabled',
     'Disabled'
    :type desired_state: str or ~azure.mgmt.synapse.models.enum
    :ivar actual_state: Actual state. Possible values include: 'Enabling',
     'Enabled', 'Disabling', 'Disabled', 'Unknown'
    :vartype actual_state: str or ~azure.mgmt.synapse.models.enum
    """

    _validation = {
        'actual_state': {'readonly': True},
    }

    _attribute_map = {
        'desired_state': {'key': 'desiredState', 'type': 'str'},
        'actual_state': {'key': 'actualState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity, self).__init__(**kwargs)
        self.desired_state = kwargs.get('desired_state', None)
        self.actual_state = None


class ManagedIntegrationRuntime(IntegrationRuntime):
    """Managed integration runtime, including managed elastic and managed
    dedicated integration runtimes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param description: Integration runtime description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    :ivar state: Integration runtime state, only valid for managed dedicated
     integration runtime. Possible values include: 'Initial', 'Stopped',
     'Started', 'Starting', 'Stopping', 'NeedRegistration', 'Online',
     'Limited', 'Offline', 'AccessDenied'
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    :param compute_properties: The compute resource for managed integration
     runtime.
    :type compute_properties:
     ~azure.mgmt.synapse.models.IntegrationRuntimeComputeProperties
    :param ssis_properties: SSIS properties for managed integration runtime.
    :type ssis_properties:
     ~azure.mgmt.synapse.models.IntegrationRuntimeSsisProperties
    """

    _validation = {
        'type': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'compute_properties': {'key': 'typeProperties.computeProperties', 'type': 'IntegrationRuntimeComputeProperties'},
        'ssis_properties': {'key': 'typeProperties.ssisProperties', 'type': 'IntegrationRuntimeSsisProperties'},
    }

    def __init__(self, **kwargs):
        super(ManagedIntegrationRuntime, self).__init__(**kwargs)
        self.state = None
        self.compute_properties = kwargs.get('compute_properties', None)
        self.ssis_properties = kwargs.get('ssis_properties', None)
        self.type = 'Managed'


class ManagedIntegrationRuntimeError(Model):
    """Error definition for managed integration runtime.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar time: The time when the error occurred.
    :vartype time: datetime
    :ivar code: Error code.
    :vartype code: str
    :ivar parameters: Managed integration runtime error parameters.
    :vartype parameters: list[str]
    :ivar message: Error message.
    :vartype message: str
    """

    _validation = {
        'time': {'readonly': True},
        'code': {'readonly': True},
        'parameters': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedIntegrationRuntimeError, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.time = None
        self.code = None
        self.parameters = None
        self.message = None


class ManagedIntegrationRuntimeNode(Model):
    """Properties of integration runtime node.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar node_id: The managed integration runtime node id.
    :vartype node_id: str
    :ivar status: The managed integration runtime node status. Possible values
     include: 'Starting', 'Available', 'Recycling', 'Unavailable'
    :vartype status: str or
     ~azure.mgmt.synapse.models.ManagedIntegrationRuntimeNodeStatus
    :param errors: The errors that occurred on this integration runtime node.
    :type errors:
     list[~azure.mgmt.synapse.models.ManagedIntegrationRuntimeError]
    """

    _validation = {
        'node_id': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ManagedIntegrationRuntimeError]'},
    }

    def __init__(self, **kwargs):
        super(ManagedIntegrationRuntimeNode, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.node_id = None
        self.status = None
        self.errors = kwargs.get('errors', None)


class ManagedIntegrationRuntimeOperationResult(Model):
    """Properties of managed integration runtime operation result.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar type: The operation type. Could be start or stop.
    :vartype type: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: datetime
    :ivar result: The operation result.
    :vartype result: str
    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar parameters: Managed integration runtime error parameters.
    :vartype parameters: list[str]
    :ivar activity_id: The activity id for the operation request.
    :vartype activity_id: str
    """

    _validation = {
        'type': {'readonly': True},
        'start_time': {'readonly': True},
        'result': {'readonly': True},
        'error_code': {'readonly': True},
        'parameters': {'readonly': True},
        'activity_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'result': {'key': 'result', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedIntegrationRuntimeOperationResult, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.type = None
        self.start_time = None
        self.result = None
        self.error_code = None
        self.parameters = None
        self.activity_id = None


class ManagedIntegrationRuntimeStatus(IntegrationRuntimeStatus):
    """Managed integration runtime status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar data_factory_name: The workspace name which the integration runtime
     belong to.
    :vartype data_factory_name: str
    :ivar state: The state of integration runtime. Possible values include:
     'Initial', 'Stopped', 'Started', 'Starting', 'Stopping',
     'NeedRegistration', 'Online', 'Limited', 'Offline', 'AccessDenied'
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    :param type: Required. Constant filled by server.
    :type type: str
    :ivar create_time: The time at which the integration runtime was created,
     in ISO8601 format.
    :vartype create_time: datetime
    :ivar nodes: The list of nodes for managed integration runtime.
    :vartype nodes:
     list[~azure.mgmt.synapse.models.ManagedIntegrationRuntimeNode]
    :ivar other_errors: The errors that occurred on this integration runtime.
    :vartype other_errors:
     list[~azure.mgmt.synapse.models.ManagedIntegrationRuntimeError]
    :ivar last_operation: The last operation result that occurred on this
     integration runtime.
    :vartype last_operation:
     ~azure.mgmt.synapse.models.ManagedIntegrationRuntimeOperationResult
    """

    _validation = {
        'data_factory_name': {'readonly': True},
        'state': {'readonly': True},
        'type': {'required': True},
        'create_time': {'readonly': True},
        'nodes': {'readonly': True},
        'other_errors': {'readonly': True},
        'last_operation': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'create_time': {'key': 'typeProperties.createTime', 'type': 'iso-8601'},
        'nodes': {'key': 'typeProperties.nodes', 'type': '[ManagedIntegrationRuntimeNode]'},
        'other_errors': {'key': 'typeProperties.otherErrors', 'type': '[ManagedIntegrationRuntimeError]'},
        'last_operation': {'key': 'typeProperties.lastOperation', 'type': 'ManagedIntegrationRuntimeOperationResult'},
    }

    def __init__(self, **kwargs):
        super(ManagedIntegrationRuntimeStatus, self).__init__(**kwargs)
        self.create_time = None
        self.nodes = None
        self.other_errors = None
        self.last_operation = None
        self.type = 'Managed'


class MetadataSyncConfig(ProxyResource):
    """Metadata sync configuration.

    Configuration for metadata sync.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param enabled: Indicates whether the metadata sync is enabled or disabled
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(MetadataSyncConfig, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class OperationMetaLogSpecification(Model):
    """What is this?.

    :param display_name: Log display name
    :type display_name: str
    :param blob_duration: Time range the log covers
    :type blob_duration: str
    :param name: Log unique name
    :type name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaLogSpecification, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)
        self.name = kwargs.get('name', None)


class OperationMetaMetricDimensionSpecification(Model):
    """What is this?.

    :param display_name: Dimension display name
    :type display_name: str
    :param name: Dimension unique name
    :type name: str
    :param to_be_exported_for_shoebox: Whether this metric should be exported
     for Shoebox
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaMetricDimensionSpecification, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.name = kwargs.get('name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class OperationMetaMetricSpecification(Model):
    """What is this?.

    :param source_mdm_namespace: The source MDM namespace
    :type source_mdm_namespace: str
    :param display_name: Metric display name
    :type display_name: str
    :param name: Metric unique name
    :type name: str
    :param aggregation_type: Metric aggregation type
    :type aggregation_type: str
    :param display_description: Metric description
    :type display_description: str
    :param source_mdm_account: The source MDM account
    :type source_mdm_account: str
    :param enable_regional_mdm_account: Whether the regional MDM account is
     enabled
    :type enable_regional_mdm_account: bool
    :param unit: Metric units
    :type unit: str
    :param dimensions: Metric dimensions
    :type dimensions:
     list[~azure.mgmt.synapse.models.OperationMetaMetricDimensionSpecification]
    :param supports_instance_level_aggregation: Whether the metric supports
     instance-level aggregation
    :type supports_instance_level_aggregation: bool
    :param metric_filter_pattern: Metric filter
    :type metric_filter_pattern: str
    """

    _attribute_map = {
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[OperationMetaMetricDimensionSpecification]'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaMetricSpecification, self).__init__(**kwargs)
        self.source_mdm_namespace = kwargs.get('source_mdm_namespace', None)
        self.display_name = kwargs.get('display_name', None)
        self.name = kwargs.get('name', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.display_description = kwargs.get('display_description', None)
        self.source_mdm_account = kwargs.get('source_mdm_account', None)
        self.enable_regional_mdm_account = kwargs.get('enable_regional_mdm_account', None)
        self.unit = kwargs.get('unit', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.supports_instance_level_aggregation = kwargs.get('supports_instance_level_aggregation', None)
        self.metric_filter_pattern = kwargs.get('metric_filter_pattern', None)


class OperationMetaServiceSpecification(Model):
    """What is this?.

    :param metric_specifications: Service metric specifications
    :type metric_specifications:
     list[~azure.mgmt.synapse.models.OperationMetaMetricSpecification]
    :param log_specifications: Service log specifications
    :type log_specifications:
     list[~azure.mgmt.synapse.models.OperationMetaLogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetaMetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[OperationMetaLogSpecification]'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)
        self.log_specifications = kwargs.get('log_specifications', None)


class OperationResource(Model):
    """An operation.

    :param id: Operation ID
    :type id: str
    :param name: Operation name
    :type name: str
    :param status: Operation status. Possible values include: 'InProgress',
     'Succeeded', 'Failed', 'Canceled'
    :type status: str or ~azure.mgmt.synapse.models.OperationStatus
    :param properties: Operation properties
    :type properties: object
    :param error: Errors from the operation
    :type error: ~azure.mgmt.synapse.models.ErrorDetail
    :param start_time: Operation start time
    :type start_time: datetime
    :param end_time: Operation start time
    :type end_time: datetime
    :param percent_complete: Completion percentage of the operation
    :type percent_complete: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(OperationResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.properties = kwargs.get('properties', None)
        self.error = kwargs.get('error', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.percent_complete = kwargs.get('percent_complete', None)


class PrivateEndpoint(Model):
    """Private endpoint details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param private_endpoint: The private endpoint which the connection belongs
     to.
    :type private_endpoint: ~azure.mgmt.synapse.models.PrivateEndpoint
    :param private_link_service_connection_state: Connection state of the
     private endpoint connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.synapse.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint
     connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar properties: The private link resource properties.
    :vartype properties:
     ~azure.mgmt.synapse.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceProperties(Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link
     resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionState(Model):
    """Connection state details of the private endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param status: The private link service connection status. Possible values
     include: 'Approved', 'Pending', 'Rejected', 'Disconnected'
    :type status: str or ~azure.mgmt.synapse.models.enum
    :param description: The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service
     connection.
    :vartype actions_required: str
    """

    _validation = {
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = None


class QueryInterval(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar interval_start_time: The start time of the measurement interval
     (ISO8601 format).
    :vartype interval_start_time: datetime
    :ivar execution_count: The number of times the query was executed during
     this interval.
    :vartype execution_count: float
    :ivar metrics: The list of query metrics during this interval.
    :vartype metrics: list[~azure.mgmt.synapse.models.QueryMetric]
    """

    _validation = {
        'interval_start_time': {'readonly': True},
        'execution_count': {'readonly': True},
        'metrics': {'readonly': True},
    }

    _attribute_map = {
        'interval_start_time': {'key': 'intervalStartTime', 'type': 'iso-8601'},
        'execution_count': {'key': 'executionCount', 'type': 'float'},
        'metrics': {'key': 'metrics', 'type': '[QueryMetric]'},
    }

    def __init__(self, **kwargs):
        super(QueryInterval, self).__init__(**kwargs)
        self.interval_start_time = None
        self.execution_count = None
        self.metrics = None


class QueryMetric(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the metric
    :vartype name: str
    :ivar display_name: The name of the metric for display in user interface
    :vartype display_name: str
    :ivar unit: The unit of measurement. Possible values include:
     'percentage', 'KB', 'microseconds'
    :vartype unit: str or ~azure.mgmt.synapse.models.QueryMetricUnit
    :ivar value: The measured value
    :vartype value: float
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'unit': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'QueryMetricUnit'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(QueryMetric, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.unit = None
        self.value = None


class QueryStatistic(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar query_id: The id of the query
    :vartype query_id: str
    :ivar intervals: The list of query intervals.
    :vartype intervals: list[~azure.mgmt.synapse.models.QueryInterval]
    """

    _validation = {
        'query_id': {'readonly': True},
        'intervals': {'readonly': True},
    }

    _attribute_map = {
        'query_id': {'key': 'queryId', 'type': 'str'},
        'intervals': {'key': 'intervals', 'type': '[QueryInterval]'},
    }

    def __init__(self, **kwargs):
        super(QueryStatistic, self).__init__(**kwargs)
        self.query_id = None
        self.intervals = None


class ReplaceAllFirewallRulesOperationResponse(Model):
    """An existing operation for replacing the firewall rules.

    :param operation_id: The operation ID
    :type operation_id: str
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReplaceAllFirewallRulesOperationResponse, self).__init__(**kwargs)
        self.operation_id = kwargs.get('operation_id', None)


class ReplaceAllIpFirewallRulesRequest(Model):
    """Replace all IP firewall rules request.

    :param ip_firewall_rules: IP firewall rule properties
    :type ip_firewall_rules: dict[str,
     ~azure.mgmt.synapse.models.IpFirewallRuleProperties]
    """

    _attribute_map = {
        'ip_firewall_rules': {'key': 'ipFirewallRules', 'type': '{IpFirewallRuleProperties}'},
    }

    def __init__(self, **kwargs):
        super(ReplaceAllIpFirewallRulesRequest, self).__init__(**kwargs)
        self.ip_firewall_rules = kwargs.get('ip_firewall_rules', None)


class ReplicationLink(ProxyResource):
    """Represents a Sql pool replication link.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar location: Location of the workspace that contains this firewall
     rule.
    :vartype location: str
    :ivar is_termination_allowed: Legacy value indicating whether termination
     is allowed.  Currently always returns true.
    :vartype is_termination_allowed: bool
    :ivar replication_mode: Replication mode of this replication link.
    :vartype replication_mode: str
    :ivar partner_server: The name of the workspace hosting the partner Sql
     pool.
    :vartype partner_server: str
    :ivar partner_database: The name of the partner Sql pool.
    :vartype partner_database: str
    :ivar partner_location: The Azure Region of the partner Sql pool.
    :vartype partner_location: str
    :ivar role: The role of the Sql pool in the replication link. Possible
     values include: 'Primary', 'Secondary', 'NonReadableSecondary', 'Source',
     'Copy'
    :vartype role: str or ~azure.mgmt.synapse.models.ReplicationRole
    :ivar partner_role: The role of the partner Sql pool in the replication
     link. Possible values include: 'Primary', 'Secondary',
     'NonReadableSecondary', 'Source', 'Copy'
    :vartype partner_role: str or ~azure.mgmt.synapse.models.ReplicationRole
    :ivar start_time: The start time for the replication link.
    :vartype start_time: datetime
    :ivar percent_complete: The percentage of seeding complete for the
     replication link.
    :vartype percent_complete: int
    :ivar replication_state: The replication state for the replication link.
     Possible values include: 'PENDING', 'SEEDING', 'CATCH_UP', 'SUSPENDED'
    :vartype replication_state: str or
     ~azure.mgmt.synapse.models.ReplicationState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'is_termination_allowed': {'readonly': True},
        'replication_mode': {'readonly': True},
        'partner_server': {'readonly': True},
        'partner_database': {'readonly': True},
        'partner_location': {'readonly': True},
        'role': {'readonly': True},
        'partner_role': {'readonly': True},
        'start_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'replication_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'is_termination_allowed': {'key': 'properties.isTerminationAllowed', 'type': 'bool'},
        'replication_mode': {'key': 'properties.replicationMode', 'type': 'str'},
        'partner_server': {'key': 'properties.partnerServer', 'type': 'str'},
        'partner_database': {'key': 'properties.partnerDatabase', 'type': 'str'},
        'partner_location': {'key': 'properties.partnerLocation', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'ReplicationRole'},
        'partner_role': {'key': 'properties.partnerRole', 'type': 'ReplicationRole'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReplicationLink, self).__init__(**kwargs)
        self.location = None
        self.is_termination_allowed = None
        self.replication_mode = None
        self.partner_server = None
        self.partner_database = None
        self.partner_location = None
        self.role = None
        self.partner_role = None
        self.start_time = None
        self.percent_complete = None
        self.replication_state = None


class ResourceMoveDefinition(Model):
    """Contains the information necessary to perform a resource move (rename).

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The target ID for the resource
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceMoveDefinition, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class RestorePoint(ProxyResource):
    """Database restore points.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar restore_point_type: The type of restore point. Possible values
     include: 'CONTINUOUS', 'DISCRETE'
    :vartype restore_point_type: str or
     ~azure.mgmt.synapse.models.RestorePointType
    :ivar earliest_restore_date: The earliest time to which this database can
     be restored
    :vartype earliest_restore_date: datetime
    :ivar restore_point_creation_date: The time the backup was taken
    :vartype restore_point_creation_date: datetime
    :ivar restore_point_label: The label of restore point for backup request
     by user
    :vartype restore_point_label: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'restore_point_type': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'restore_point_creation_date': {'readonly': True},
        'restore_point_label': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'restore_point_type': {'key': 'properties.restorePointType', 'type': 'RestorePointType'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'restore_point_creation_date': {'key': 'properties.restorePointCreationDate', 'type': 'iso-8601'},
        'restore_point_label': {'key': 'properties.restorePointLabel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RestorePoint, self).__init__(**kwargs)
        self.location = None
        self.restore_point_type = None
        self.earliest_restore_date = None
        self.restore_point_creation_date = None
        self.restore_point_label = None


class SecretBase(Model):
    """The base definition of a secret type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecureString

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'SecureString': 'SecureString'}
    }

    def __init__(self, **kwargs):
        super(SecretBase, self).__init__(**kwargs)
        self.type = None


class SecureString(SecretBase):
    """Azure Synapse secure string definition. The string value will be masked
    with asterisks '*' during Get or List API calls.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Constant filled by server.
    :type type: str
    :param value: Required. Value of secure string.
    :type value: str
    """

    _validation = {
        'type': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecureString, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.type = 'SecureString'


class SelfHostedIntegrationRuntime(IntegrationRuntime):
    """Self-hosted integration runtime.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param description: Integration runtime description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param linked_info:
    :type linked_info: ~azure.mgmt.synapse.models.LinkedIntegrationRuntimeType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_info': {'key': 'typeProperties.linkedInfo', 'type': 'LinkedIntegrationRuntimeType'},
    }

    def __init__(self, **kwargs):
        super(SelfHostedIntegrationRuntime, self).__init__(**kwargs)
        self.linked_info = kwargs.get('linked_info', None)
        self.type = 'SelfHosted'


class SelfHostedIntegrationRuntimeNode(Model):
    """Properties of Self-hosted integration runtime node.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar node_name: Name of the integration runtime node.
    :vartype node_name: str
    :ivar machine_name: Machine name of the integration runtime node.
    :vartype machine_name: str
    :ivar host_service_uri: URI for the host machine of the integration
     runtime.
    :vartype host_service_uri: str
    :ivar status: Status of the integration runtime node. Possible values
     include: 'NeedRegistration', 'Online', 'Limited', 'Offline', 'Upgrading',
     'Initializing', 'InitializeFailed'
    :vartype status: str or
     ~azure.mgmt.synapse.models.SelfHostedIntegrationRuntimeNodeStatus
    :ivar capabilities: The integration runtime capabilities dictionary
    :vartype capabilities: dict[str, str]
    :ivar version_status: Status of the integration runtime node version.
    :vartype version_status: str
    :ivar version: Version of the integration runtime node.
    :vartype version: str
    :ivar register_time: The time at which the integration runtime node was
     registered in ISO8601 format.
    :vartype register_time: datetime
    :ivar last_connect_time: The most recent time at which the integration
     runtime was connected in ISO8601 format.
    :vartype last_connect_time: datetime
    :ivar expiry_time: The time at which the integration runtime will expire
     in ISO8601 format.
    :vartype expiry_time: datetime
    :ivar last_start_time: The time the node last started up.
    :vartype last_start_time: datetime
    :ivar last_stop_time: The integration runtime node last stop time.
    :vartype last_stop_time: datetime
    :ivar last_update_result: The result of the last integration runtime node
     update. Possible values include: 'None', 'Succeed', 'Fail'
    :vartype last_update_result: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeUpdateResult
    :ivar last_start_update_time: The last time for the integration runtime
     node update start.
    :vartype last_start_update_time: datetime
    :ivar last_end_update_time: The last time for the integration runtime node
     update end.
    :vartype last_end_update_time: datetime
    :ivar is_active_dispatcher: Indicates whether this node is the active
     dispatcher for integration runtime requests.
    :vartype is_active_dispatcher: bool
    :ivar concurrent_jobs_limit: Maximum concurrent jobs on the integration
     runtime node.
    :vartype concurrent_jobs_limit: int
    :ivar max_concurrent_jobs: The maximum concurrent jobs in this integration
     runtime.
    :vartype max_concurrent_jobs: int
    """

    _validation = {
        'node_name': {'readonly': True},
        'machine_name': {'readonly': True},
        'host_service_uri': {'readonly': True},
        'status': {'readonly': True},
        'capabilities': {'readonly': True},
        'version_status': {'readonly': True},
        'version': {'readonly': True},
        'register_time': {'readonly': True},
        'last_connect_time': {'readonly': True},
        'expiry_time': {'readonly': True},
        'last_start_time': {'readonly': True},
        'last_stop_time': {'readonly': True},
        'last_update_result': {'readonly': True},
        'last_start_update_time': {'readonly': True},
        'last_end_update_time': {'readonly': True},
        'is_active_dispatcher': {'readonly': True},
        'concurrent_jobs_limit': {'readonly': True},
        'max_concurrent_jobs': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'node_name': {'key': 'nodeName', 'type': 'str'},
        'machine_name': {'key': 'machineName', 'type': 'str'},
        'host_service_uri': {'key': 'hostServiceUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '{str}'},
        'version_status': {'key': 'versionStatus', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'register_time': {'key': 'registerTime', 'type': 'iso-8601'},
        'last_connect_time': {'key': 'lastConnectTime', 'type': 'iso-8601'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'last_start_time': {'key': 'lastStartTime', 'type': 'iso-8601'},
        'last_stop_time': {'key': 'lastStopTime', 'type': 'iso-8601'},
        'last_update_result': {'key': 'lastUpdateResult', 'type': 'str'},
        'last_start_update_time': {'key': 'lastStartUpdateTime', 'type': 'iso-8601'},
        'last_end_update_time': {'key': 'lastEndUpdateTime', 'type': 'iso-8601'},
        'is_active_dispatcher': {'key': 'isActiveDispatcher', 'type': 'bool'},
        'concurrent_jobs_limit': {'key': 'concurrentJobsLimit', 'type': 'int'},
        'max_concurrent_jobs': {'key': 'maxConcurrentJobs', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(SelfHostedIntegrationRuntimeNode, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.node_name = None
        self.machine_name = None
        self.host_service_uri = None
        self.status = None
        self.capabilities = None
        self.version_status = None
        self.version = None
        self.register_time = None
        self.last_connect_time = None
        self.expiry_time = None
        self.last_start_time = None
        self.last_stop_time = None
        self.last_update_result = None
        self.last_start_update_time = None
        self.last_end_update_time = None
        self.is_active_dispatcher = None
        self.concurrent_jobs_limit = None
        self.max_concurrent_jobs = None


class SelfHostedIntegrationRuntimeStatus(IntegrationRuntimeStatus):
    """Self-hosted integration runtime status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar data_factory_name: The workspace name which the integration runtime
     belong to.
    :vartype data_factory_name: str
    :ivar state: The state of integration runtime. Possible values include:
     'Initial', 'Stopped', 'Started', 'Starting', 'Stopping',
     'NeedRegistration', 'Online', 'Limited', 'Offline', 'AccessDenied'
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    :param type: Required. Constant filled by server.
    :type type: str
    :ivar create_time: The time at which the integration runtime was created,
     in ISO8601 format.
    :vartype create_time: datetime
    :ivar task_queue_id: The task queue id of the integration runtime.
    :vartype task_queue_id: str
    :ivar internal_channel_encryption: It is used to set the encryption mode
     for node-node communication channel (when more than 2 self-hosted
     integration runtime nodes exist). Possible values include: 'NotSet',
     'SslEncrypted', 'NotEncrypted'
    :vartype internal_channel_encryption: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeInternalChannelEncryptionMode
    :ivar version: Version of the integration runtime.
    :vartype version: str
    :param nodes: The list of nodes for this integration runtime.
    :type nodes:
     list[~azure.mgmt.synapse.models.SelfHostedIntegrationRuntimeNode]
    :ivar scheduled_update_date: The date at which the integration runtime
     will be scheduled to update, in ISO8601 format.
    :vartype scheduled_update_date: datetime
    :ivar update_delay_offset: The time in the date scheduled by service to
     update the integration runtime, e.g., PT03H is 3 hours
    :vartype update_delay_offset: str
    :ivar local_time_zone_offset: The local time zone offset in hours.
    :vartype local_time_zone_offset: str
    :ivar capabilities: Object with additional information about integration
     runtime capabilities.
    :vartype capabilities: dict[str, str]
    :ivar service_urls: The URLs for the services used in integration runtime
     backend service.
    :vartype service_urls: list[str]
    :ivar auto_update: Whether Self-hosted integration runtime auto update has
     been turned on. Possible values include: 'On', 'Off'
    :vartype auto_update: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeAutoUpdate
    :ivar version_status: Status of the integration runtime version.
    :vartype version_status: str
    :param links: The list of linked integration runtimes that are created to
     share with this integration runtime.
    :type links: list[~azure.mgmt.synapse.models.LinkedIntegrationRuntime]
    :ivar pushed_version: The version that the integration runtime is going to
     update to.
    :vartype pushed_version: str
    :ivar latest_version: The latest version on download center.
    :vartype latest_version: str
    :ivar auto_update_eta: The estimated time when the self-hosted integration
     runtime will be updated.
    :vartype auto_update_eta: datetime
    """

    _validation = {
        'data_factory_name': {'readonly': True},
        'state': {'readonly': True},
        'type': {'required': True},
        'create_time': {'readonly': True},
        'task_queue_id': {'readonly': True},
        'internal_channel_encryption': {'readonly': True},
        'version': {'readonly': True},
        'scheduled_update_date': {'readonly': True},
        'update_delay_offset': {'readonly': True},
        'local_time_zone_offset': {'readonly': True},
        'capabilities': {'readonly': True},
        'service_urls': {'readonly': True},
        'auto_update': {'readonly': True},
        'version_status': {'readonly': True},
        'pushed_version': {'readonly': True},
        'latest_version': {'readonly': True},
        'auto_update_eta': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'create_time': {'key': 'typeProperties.createTime', 'type': 'iso-8601'},
        'task_queue_id': {'key': 'typeProperties.taskQueueId', 'type': 'str'},
        'internal_channel_encryption': {'key': 'typeProperties.internalChannelEncryption', 'type': 'str'},
        'version': {'key': 'typeProperties.version', 'type': 'str'},
        'nodes': {'key': 'typeProperties.nodes', 'type': '[SelfHostedIntegrationRuntimeNode]'},
        'scheduled_update_date': {'key': 'typeProperties.scheduledUpdateDate', 'type': 'iso-8601'},
        'update_delay_offset': {'key': 'typeProperties.updateDelayOffset', 'type': 'str'},
        'local_time_zone_offset': {'key': 'typeProperties.localTimeZoneOffset', 'type': 'str'},
        'capabilities': {'key': 'typeProperties.capabilities', 'type': '{str}'},
        'service_urls': {'key': 'typeProperties.serviceUrls', 'type': '[str]'},
        'auto_update': {'key': 'typeProperties.autoUpdate', 'type': 'str'},
        'version_status': {'key': 'typeProperties.versionStatus', 'type': 'str'},
        'links': {'key': 'typeProperties.links', 'type': '[LinkedIntegrationRuntime]'},
        'pushed_version': {'key': 'typeProperties.pushedVersion', 'type': 'str'},
        'latest_version': {'key': 'typeProperties.latestVersion', 'type': 'str'},
        'auto_update_eta': {'key': 'typeProperties.autoUpdateETA', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SelfHostedIntegrationRuntimeStatus, self).__init__(**kwargs)
        self.create_time = None
        self.task_queue_id = None
        self.internal_channel_encryption = None
        self.version = None
        self.nodes = kwargs.get('nodes', None)
        self.scheduled_update_date = None
        self.update_delay_offset = None
        self.local_time_zone_offset = None
        self.capabilities = None
        self.service_urls = None
        self.auto_update = None
        self.version_status = None
        self.links = kwargs.get('links', None)
        self.pushed_version = None
        self.latest_version = None
        self.auto_update_eta = None
        self.type = 'SelfHosted'


class SensitivityLabel(ProxyResource):
    """A sensitivity label.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param label_name: The label name.
    :type label_name: str
    :param label_id: The label ID.
    :type label_id: str
    :param information_type: The information type.
    :type information_type: str
    :param information_type_id: The information type ID.
    :type information_type_id: str
    :ivar is_disabled: Is sensitivity recommendation disabled. Applicable for
     recommended sensitivity label only. Specifies whether the sensitivity
     recommendation on this column is disabled (dismissed) or not.
    :vartype is_disabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_disabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'label_name': {'key': 'properties.labelName', 'type': 'str'},
        'label_id': {'key': 'properties.labelId', 'type': 'str'},
        'information_type': {'key': 'properties.informationType', 'type': 'str'},
        'information_type_id': {'key': 'properties.informationTypeId', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SensitivityLabel, self).__init__(**kwargs)
        self.label_name = kwargs.get('label_name', None)
        self.label_id = kwargs.get('label_id', None)
        self.information_type = kwargs.get('information_type', None)
        self.information_type_id = kwargs.get('information_type_id', None)
        self.is_disabled = None


class Sku(Model):
    """Sku.

    SQL pool SKU.

    :param tier: The service tier
    :type tier: str
    :param name: The SKU name
    :type name: str
    """

    _attribute_map = {
        'tier': {'key': 'tier', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.tier = kwargs.get('tier', None)
        self.name = kwargs.get('name', None)


class SqlPool(TrackedResource):
    """SQL pool.

    A SQL Analytics pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param sku: SQL pool SKU
    :type sku: ~azure.mgmt.synapse.models.Sku
    :param max_size_bytes: Maximum size in bytes
    :type max_size_bytes: long
    :param collation: Collation mode
    :type collation: str
    :param source_database_id: Source database to create from
    :type source_database_id: str
    :param recoverable_database_id: Backup database to restore from
    :type recoverable_database_id: str
    :param provisioning_state: Resource state
    :type provisioning_state: str
    :param status: Resource status
    :type status: str
    :param restore_point_in_time: Snapshot time to restore
    :type restore_point_in_time: datetime
    :param create_mode: What is this?
    :type create_mode: str
    :param creation_date: Date the SQL pool was created
    :type creation_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPool, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.collation = kwargs.get('collation', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.status = kwargs.get('status', None)
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.creation_date = kwargs.get('creation_date', None)


class SqlPoolBlobAuditingPolicy(ProxyResource):
    """A Sql pool blob auditing policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :param state: Required. Specifies the state of the policy. If state is
     Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     Possible values include: 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.synapse.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled,
     storageEndpoint is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     auditing storage account. If state is Enabled and storageEndpoint is
     specified, storageAccountAccessKey is required.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit
     logs in the storage account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions
     to audit.
     The recommended set of action groups to use is the following combination -
     this will audit all the queries and stored procedures executed against the
     database, as well as successful and failed logins:
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
     This above combination is also the set that is configured by default when
     enabling auditing from the Azure portal.
     The supported action groups to audit are (note: choose only specific
     groups that cover your auditing needs. Using unnecessary groups could lead
     to very large quantities of audit records):
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     These are groups that cover all sql statements and stored procedures
     executed against the database, and should not be used in combination with
     other groups as this will result in duplicate audit logs.
     For more information, see [Database-Level Audit Action
     Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     For Database auditing policy, specific Actions can also be specified (note
     that Actions cannot be specified for Server auditing policy). The
     supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
     Note that <object> in the above format can refer to an object like a
     table, view, or stored procedure, or an entire database or schema. For the
     latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are
     used, respectively.
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
     For more information, see [Database-Level Audit
     Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage
     subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether
     storageAccountAccessKey value is the storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are
     sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled'
     and 'isAzureMonitorTargetEnabled' as true.
     When using REST API to configure auditing, Diagnostic Settings with
     'SQLSecurityAuditEvents' diagnostic logs category on the database should
     be also created.
     Note that for server level audit you should use the 'master' database as
     {databaseName}.
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     For more information, see [Diagnostic Settings REST
     API](https://go.microsoft.com/fwlink/?linkid=2033207)
     or [Diagnostic Settings
     PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
    :type is_azure_monitor_target_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'BlobAuditingPolicyState'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolBlobAuditingPolicy, self).__init__(**kwargs)
        self.kind = None
        self.state = kwargs.get('state', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.audit_actions_and_groups = kwargs.get('audit_actions_and_groups', None)
        self.storage_account_subscription_id = kwargs.get('storage_account_subscription_id', None)
        self.is_storage_secondary_key_in_use = kwargs.get('is_storage_secondary_key_in_use', None)
        self.is_azure_monitor_target_enabled = kwargs.get('is_azure_monitor_target_enabled', None)


class SqlPoolColumn(ProxyResource):
    """A Sql pool column resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param column_type: The column data type. Possible values include:
     'image', 'text', 'uniqueidentifier', 'date', 'time', 'datetime2',
     'datetimeoffset', 'tinyint', 'smallint', 'int', 'smalldatetime', 'real',
     'money', 'datetime', 'float', 'sql_variant', 'ntext', 'bit', 'decimal',
     'numeric', 'smallmoney', 'bigint', 'hierarchyid', 'geometry', 'geography',
     'varbinary', 'varchar', 'binary', 'char', 'timestamp', 'nvarchar',
     'nchar', 'xml', 'sysname'
    :type column_type: str or ~azure.mgmt.synapse.models.ColumnDataType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'column_type': {'key': 'properties.columnType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolColumn, self).__init__(**kwargs)
        self.column_type = kwargs.get('column_type', None)


class SqlPoolConnectionPolicy(ProxyResource):
    """A Sql pool connection policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :param security_enabled_access: The state of security access.
    :type security_enabled_access: str
    :param proxy_dns_name: The fully qualified host name of the auditing
     proxy.
    :type proxy_dns_name: str
    :param proxy_port: The port number of the auditing proxy.
    :type proxy_port: str
    :param visibility: The visibility of the auditing proxy.
    :type visibility: str
    :param use_server_default: Whether server default is enabled or disabled.
    :type use_server_default: str
    :param redirection_state: The state of proxy redirection.
    :type redirection_state: str
    :param state: The connection policy state.
    :type state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'security_enabled_access': {'key': 'properties.securityEnabledAccess', 'type': 'str'},
        'proxy_dns_name': {'key': 'properties.proxyDnsName', 'type': 'str'},
        'proxy_port': {'key': 'properties.proxyPort', 'type': 'str'},
        'visibility': {'key': 'properties.visibility', 'type': 'str'},
        'use_server_default': {'key': 'properties.useServerDefault', 'type': 'str'},
        'redirection_state': {'key': 'properties.redirectionState', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolConnectionPolicy, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.security_enabled_access = kwargs.get('security_enabled_access', None)
        self.proxy_dns_name = kwargs.get('proxy_dns_name', None)
        self.proxy_port = kwargs.get('proxy_port', None)
        self.visibility = kwargs.get('visibility', None)
        self.use_server_default = kwargs.get('use_server_default', None)
        self.redirection_state = kwargs.get('redirection_state', None)
        self.state = kwargs.get('state', None)


class SqlPoolOperation(ProxyResource):
    """A Sql pool operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar database_name: The name of the Sql pool the operation is being
     performed on.
    :vartype database_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: datetime
    :ivar state: The operation state. Possible values include: 'Pending',
     'InProgress', 'Succeeded', 'Failed', 'CancelInProgress', 'Cancelled'
    :vartype state: str or ~azure.mgmt.synapse.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the
     operation.
    :vartype estimated_completion_time: datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolOperation, self).__init__(**kwargs)
        self.database_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class SqlPoolPatchInfo(Model):
    """SQL pool patch info.

    A SQL Analytics pool patch info.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives
    :type location: str
    :param sku: SQL pool SKU
    :type sku: ~azure.mgmt.synapse.models.Sku
    :param max_size_bytes: Maximum size in bytes
    :type max_size_bytes: long
    :param collation: Collation mode
    :type collation: str
    :param source_database_id: Source database to create from
    :type source_database_id: str
    :param recoverable_database_id: Backup database to restore from
    :type recoverable_database_id: str
    :param provisioning_state: Resource state
    :type provisioning_state: str
    :param status: Resource status
    :type status: str
    :param restore_point_in_time: Snapshot time to restore
    :type restore_point_in_time: datetime
    :param create_mode: What is this?
    :type create_mode: str
    :param creation_date: Date the SQL pool was created
    :type creation_date: datetime
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolPatchInfo, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.collation = kwargs.get('collation', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.status = kwargs.get('status', None)
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.creation_date = kwargs.get('creation_date', None)


class SqlPoolSchema(ProxyResource):
    """A Sql pool schema resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolSchema, self).__init__(**kwargs)


class SqlPoolSecurityAlertPolicy(ProxyResource):
    """A Sql pool security alert policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param state: Required. Specifies the state of the policy, whether it is
     enabled or disabled or a policy has not been applied yet on the specific
     Sql pool. Possible values include: 'New', 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.synapse.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled.
     Allowed values are: Sql_Injection, Sql_Injection_Vulnerability,
     Access_Anomaly, Data_Exfiltration, Unsafe_Action
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which
     the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the
     account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all
     Threat Detection audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     Threat Detection audit storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat
     Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'SecurityAlertPolicyState'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.disabled_alerts = kwargs.get('disabled_alerts', None)
        self.email_addresses = kwargs.get('email_addresses', None)
        self.email_account_admins = kwargs.get('email_account_admins', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.creation_time = None


class SqlPoolTable(ProxyResource):
    """A Sql pool table resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolTable, self).__init__(**kwargs)


class SqlPoolUsage(Model):
    """The Sql pool usages.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the usage metric.
    :vartype name: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar display_name: The usage metric display name.
    :vartype display_name: str
    :ivar current_value: The current value of the usage metric.
    :vartype current_value: float
    :ivar limit: The current limit of the usage metric.
    :vartype limit: float
    :ivar unit: The units of the usage metric.
    :vartype unit: str
    :ivar next_reset_time: The next reset time for the usage metric (ISO8601
     format).
    :vartype next_reset_time: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'resource_name': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'next_reset_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolUsage, self).__init__(**kwargs)
        self.name = None
        self.resource_name = None
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None
        self.next_reset_time = None


class SqlPoolVulnerabilityAssessment(ProxyResource):
    """A Sql pool vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the
     scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It
     is required if server level vulnerability assessment policy doesn't set
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that
     has write access to the blob container specified in 'storageContainerPath'
     parameter. If 'storageAccountAccessKey' isn't specified,
     StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the
     storage account for vulnerability assessment scan results. If
     'StorageContainerSasKey' isn't specified, storageAccountAccessKey is
     required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings
    :type recurring_scans:
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = kwargs.get('storage_container_path', None)
        self.storage_container_sas_key = kwargs.get('storage_container_sas_key', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.recurring_scans = kwargs.get('recurring_scans', None)


class SqlPoolVulnerabilityAssessmentRuleBaseline(ProxyResource):
    """A Sql pool vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param baseline_results: Required. The rule baseline result
    :type baseline_results:
     list[~azure.mgmt.synapse.models.SqlPoolVulnerabilityAssessmentRuleBaselineItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'baseline_results': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'baseline_results': {'key': 'properties.baselineResults', 'type': '[SqlPoolVulnerabilityAssessmentRuleBaselineItem]'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessmentRuleBaseline, self).__init__(**kwargs)
        self.baseline_results = kwargs.get('baseline_results', None)


class SqlPoolVulnerabilityAssessmentRuleBaselineItem(Model):
    """Properties for an Sql pool vulnerability assessment rule baseline's result.

    All required parameters must be populated in order to send to Azure.

    :param result: Required. The rule baseline result
    :type result: list[str]
    """

    _validation = {
        'result': {'required': True},
    }

    _attribute_map = {
        'result': {'key': 'result', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessmentRuleBaselineItem, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)


class SqlPoolVulnerabilityAssessmentScansExport(ProxyResource):
    """A Sql pool Vulnerability Assessment scan export resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar exported_report_location: Location of the exported report (e.g.
     https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
    :vartype exported_report_location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'exported_report_location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'exported_report_location': {'key': 'properties.exportedReportLocation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessmentScansExport, self).__init__(**kwargs)
        self.exported_report_location = None


class SsisObjectMetadata(Model):
    """SSIS object metadata.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SsisFolder, SsisProject, SsisPackage, SsisEnvironment

    All required parameters must be populated in order to send to Azure.

    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Folder': 'SsisFolder', 'Project': 'SsisProject', 'Package': 'SsisPackage', 'Environment': 'SsisEnvironment'}
    }

    def __init__(self, **kwargs):
        super(SsisObjectMetadata, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.type = None


class SsisEnvironment(SsisObjectMetadata):
    """Ssis environment.

    All required parameters must be populated in order to send to Azure.

    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param folder_id: Folder id which contains environment.
    :type folder_id: long
    :param variables: Variable in environment
    :type variables: list[~azure.mgmt.synapse.models.SsisVariable]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_id': {'key': 'folderId', 'type': 'long'},
        'variables': {'key': 'variables', 'type': '[SsisVariable]'},
    }

    def __init__(self, **kwargs):
        super(SsisEnvironment, self).__init__(**kwargs)
        self.folder_id = kwargs.get('folder_id', None)
        self.variables = kwargs.get('variables', None)
        self.type = 'Environment'


class SsisEnvironmentReference(Model):
    """Ssis environment reference.

    :param id: Environment reference id.
    :type id: long
    :param environment_folder_name: Environment folder name.
    :type environment_folder_name: str
    :param environment_name: Environment name.
    :type environment_name: str
    :param reference_type: Reference type
    :type reference_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'environment_folder_name': {'key': 'environmentFolderName', 'type': 'str'},
        'environment_name': {'key': 'environmentName', 'type': 'str'},
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsisEnvironmentReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.environment_folder_name = kwargs.get('environment_folder_name', None)
        self.environment_name = kwargs.get('environment_name', None)
        self.reference_type = kwargs.get('reference_type', None)


class SsisFolder(SsisObjectMetadata):
    """Ssis folder.

    All required parameters must be populated in order to send to Azure.

    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsisFolder, self).__init__(**kwargs)
        self.type = 'Folder'


class SsisObjectMetadataListResponse(Model):
    """A list of SSIS object metadata.

    :param value: List of SSIS object metadata.
    :type value: list[~azure.mgmt.synapse.models.SsisObjectMetadata]
    :param next_link: The link to the next page of results, if any remaining
     results exist.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SsisObjectMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsisObjectMetadataListResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SsisObjectMetadataStatusResponse(Model):
    """The status of the operation.

    :param status: The status of the operation.
    :type status: str
    :param name: The operation name.
    :type name: str
    :param properties: The operation properties.
    :type properties: str
    :param error: The operation error message.
    :type error: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsisObjectMetadataStatusResponse, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.name = kwargs.get('name', None)
        self.properties = kwargs.get('properties', None)
        self.error = kwargs.get('error', None)


class SsisPackage(SsisObjectMetadata):
    """Ssis Package.

    All required parameters must be populated in order to send to Azure.

    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param folder_id: Folder id which contains package.
    :type folder_id: long
    :param project_version: Project version which contains package.
    :type project_version: long
    :param project_id: Project id which contains package.
    :type project_id: long
    :param parameters: Parameters in package
    :type parameters: list[~azure.mgmt.synapse.models.SsisParameter]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_id': {'key': 'folderId', 'type': 'long'},
        'project_version': {'key': 'projectVersion', 'type': 'long'},
        'project_id': {'key': 'projectId', 'type': 'long'},
        'parameters': {'key': 'parameters', 'type': '[SsisParameter]'},
    }

    def __init__(self, **kwargs):
        super(SsisPackage, self).__init__(**kwargs)
        self.folder_id = kwargs.get('folder_id', None)
        self.project_version = kwargs.get('project_version', None)
        self.project_id = kwargs.get('project_id', None)
        self.parameters = kwargs.get('parameters', None)
        self.type = 'Package'


class SsisParameter(Model):
    """Ssis parameter.

    :param id: Parameter id.
    :type id: long
    :param name: Parameter name.
    :type name: str
    :param description: Parameter description.
    :type description: str
    :param data_type: Parameter type.
    :type data_type: str
    :param required: Whether parameter is required.
    :type required: bool
    :param sensitive: Whether parameter is sensitive.
    :type sensitive: bool
    :param design_default_value: Design default value of parameter.
    :type design_default_value: str
    :param default_value: Default value of parameter.
    :type default_value: str
    :param sensitive_default_value: Default sensitive value of parameter.
    :type sensitive_default_value: str
    :param value_type: Parameter value type.
    :type value_type: str
    :param value_set: Parameter value set.
    :type value_set: bool
    :param variable: Parameter reference variable.
    :type variable: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
        'sensitive': {'key': 'sensitive', 'type': 'bool'},
        'design_default_value': {'key': 'designDefaultValue', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'sensitive_default_value': {'key': 'sensitiveDefaultValue', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'value_set': {'key': 'valueSet', 'type': 'bool'},
        'variable': {'key': 'variable', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsisParameter, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.data_type = kwargs.get('data_type', None)
        self.required = kwargs.get('required', None)
        self.sensitive = kwargs.get('sensitive', None)
        self.design_default_value = kwargs.get('design_default_value', None)
        self.default_value = kwargs.get('default_value', None)
        self.sensitive_default_value = kwargs.get('sensitive_default_value', None)
        self.value_type = kwargs.get('value_type', None)
        self.value_set = kwargs.get('value_set', None)
        self.variable = kwargs.get('variable', None)


class SsisProject(SsisObjectMetadata):
    """Ssis project.

    All required parameters must be populated in order to send to Azure.

    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param folder_id: Folder id which contains project.
    :type folder_id: long
    :param version: Project version.
    :type version: long
    :param environment_refs: Environment reference in project
    :type environment_refs:
     list[~azure.mgmt.synapse.models.SsisEnvironmentReference]
    :param parameters: Parameters in project
    :type parameters: list[~azure.mgmt.synapse.models.SsisParameter]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'folder_id': {'key': 'folderId', 'type': 'long'},
        'version': {'key': 'version', 'type': 'long'},
        'environment_refs': {'key': 'environmentRefs', 'type': '[SsisEnvironmentReference]'},
        'parameters': {'key': 'parameters', 'type': '[SsisParameter]'},
    }

    def __init__(self, **kwargs):
        super(SsisProject, self).__init__(**kwargs)
        self.folder_id = kwargs.get('folder_id', None)
        self.version = kwargs.get('version', None)
        self.environment_refs = kwargs.get('environment_refs', None)
        self.parameters = kwargs.get('parameters', None)
        self.type = 'Project'


class SsisVariable(Model):
    """Ssis variable.

    :param id: Variable id.
    :type id: long
    :param name: Variable name.
    :type name: str
    :param description: Variable description.
    :type description: str
    :param data_type: Variable type.
    :type data_type: str
    :param sensitive: Whether variable is sensitive.
    :type sensitive: bool
    :param value: Variable value.
    :type value: str
    :param sensitive_value: Variable sensitive value.
    :type sensitive_value: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'sensitive': {'key': 'sensitive', 'type': 'bool'},
        'value': {'key': 'value', 'type': 'str'},
        'sensitive_value': {'key': 'sensitiveValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SsisVariable, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.data_type = kwargs.get('data_type', None)
        self.sensitive = kwargs.get('sensitive', None)
        self.value = kwargs.get('value', None)
        self.sensitive_value = kwargs.get('sensitive_value', None)


class TopQueries(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar aggregation_function: The function that is used to aggregate each
     query's metrics. Possible values include: 'min', 'max', 'avg', 'sum'
    :vartype aggregation_function: str or
     ~azure.mgmt.synapse.models.QueryAggregationFunction
    :ivar execution_type: The execution type that is used to filter the query
     instances that are returned. Possible values include: 'any', 'regular',
     'irregular', 'aborted', 'exception'
    :vartype execution_type: str or
     ~azure.mgmt.synapse.models.QueryExecutionType
    :ivar interval_type: The duration of the interval (ISO8601 duration
     format).
    :vartype interval_type: str
    :ivar number_of_top_queries: The number of requested queries.
    :vartype number_of_top_queries: float
    :ivar observation_start_time: The start time for queries that are returned
     (ISO8601 format)
    :vartype observation_start_time: datetime
    :ivar observation_end_time: The end time for queries that are returned
     (ISO8601 format)
    :vartype observation_end_time: datetime
    :ivar observed_metric: The type of metric to use for ordering the top
     metrics. Possible values include: 'cpu', 'io', 'logio', 'duration',
     'executionCount'
    :vartype observed_metric: str or
     ~azure.mgmt.synapse.models.QueryObservedMetricType
    :ivar queries: The list of queries.
    :vartype queries: list[~azure.mgmt.synapse.models.QueryStatistic]
    """

    _validation = {
        'aggregation_function': {'readonly': True},
        'execution_type': {'readonly': True},
        'interval_type': {'readonly': True},
        'number_of_top_queries': {'readonly': True},
        'observation_start_time': {'readonly': True},
        'observation_end_time': {'readonly': True},
        'observed_metric': {'readonly': True},
        'queries': {'readonly': True},
    }

    _attribute_map = {
        'aggregation_function': {'key': 'aggregationFunction', 'type': 'QueryAggregationFunction'},
        'execution_type': {'key': 'executionType', 'type': 'QueryExecutionType'},
        'interval_type': {'key': 'intervalType', 'type': 'str'},
        'number_of_top_queries': {'key': 'numberOfTopQueries', 'type': 'float'},
        'observation_start_time': {'key': 'observationStartTime', 'type': 'iso-8601'},
        'observation_end_time': {'key': 'observationEndTime', 'type': 'iso-8601'},
        'observed_metric': {'key': 'observedMetric', 'type': 'QueryObservedMetricType'},
        'queries': {'key': 'queries', 'type': '[QueryStatistic]'},
    }

    def __init__(self, **kwargs):
        super(TopQueries, self).__init__(**kwargs)
        self.aggregation_function = None
        self.execution_type = None
        self.interval_type = None
        self.number_of_top_queries = None
        self.observation_start_time = None
        self.observation_end_time = None
        self.observed_metric = None
        self.queries = None


class TopQueriesListResult(Model):
    """Represents the response to a get top queries request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of top queries.
    :type value: list[~azure.mgmt.synapse.models.TopQueries]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopQueries]'},
    }

    def __init__(self, **kwargs):
        super(TopQueriesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class TransparentDataEncryption(ProxyResource):
    """Represents a Sql pool transparent data encryption configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param status: The status of the database transparent data encryption.
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or
     ~azure.mgmt.synapse.models.TransparentDataEncryptionStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'TransparentDataEncryptionStatus'},
    }

    def __init__(self, **kwargs):
        super(TransparentDataEncryption, self).__init__(**kwargs)
        self.location = None
        self.status = kwargs.get('status', None)


class UpdateIntegrationRuntimeNodeRequest(Model):
    """Update integration runtime node request.

    :param concurrent_jobs_limit: The number of concurrent jobs permitted to
     run on the integration runtime node. Values between 1 and
     maxConcurrentJobs(inclusive) are allowed.
    :type concurrent_jobs_limit: int
    """

    _validation = {
        'concurrent_jobs_limit': {'minimum': 1},
    }

    _attribute_map = {
        'concurrent_jobs_limit': {'key': 'concurrentJobsLimit', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(UpdateIntegrationRuntimeNodeRequest, self).__init__(**kwargs)
        self.concurrent_jobs_limit = kwargs.get('concurrent_jobs_limit', None)


class UpdateIntegrationRuntimeRequest(Model):
    """Update integration runtime request.

    :param auto_update: Enables or disables the auto-update feature of the
     self-hosted integration runtime. See
     https://go.microsoft.com/fwlink/?linkid=854189. Possible values include:
     'On', 'Off'
    :type auto_update: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeAutoUpdate
    :param update_delay_offset: The time offset (in hours) in the day, e.g.,
     PT03H is 3 hours. The integration runtime auto update will happen on that
     time.
    :type update_delay_offset: str
    """

    _attribute_map = {
        'auto_update': {'key': 'autoUpdate', 'type': 'str'},
        'update_delay_offset': {'key': 'updateDelayOffset', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpdateIntegrationRuntimeRequest, self).__init__(**kwargs)
        self.auto_update = kwargs.get('auto_update', None)
        self.update_delay_offset = kwargs.get('update_delay_offset', None)


class VirtualNetworkProfile(Model):
    """Virtual Network Profile.

    :param compute_subnet_id: Subnet ID used for computes in workspace
    :type compute_subnet_id: str
    """

    _attribute_map = {
        'compute_subnet_id': {'key': 'computeSubnetId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.compute_subnet_id = kwargs.get('compute_subnet_id', None)


class VulnerabilityAssessmentRecurringScansProperties(Model):
    """Properties of a Vulnerability Assessment recurring scans.

    :param is_enabled: Recurring scans state.
    :type is_enabled: bool
    :param email_subscription_admins: Specifies that the schedule scan
     notification will be is sent to the subscription administrators. Default
     value: True .
    :type email_subscription_admins: bool
    :param emails: Specifies an array of e-mail addresses to which the scan
     notification is sent.
    :type emails: list[str]
    """

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'email_subscription_admins': {'key': 'emailSubscriptionAdmins', 'type': 'bool'},
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentRecurringScansProperties, self).__init__(**kwargs)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.email_subscription_admins = kwargs.get('email_subscription_admins', True)
        self.emails = kwargs.get('emails', None)


class VulnerabilityAssessmentScanError(Model):
    """Properties of a vulnerability assessment scan error.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentScanError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class VulnerabilityAssessmentScanRecord(ProxyResource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar scan_id: The scan ID.
    :vartype scan_id: str
    :ivar trigger_type: The scan trigger type. Possible values include:
     'OnDemand', 'Recurring'
    :vartype trigger_type: str or
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentScanTriggerType
    :ivar state: The scan status. Possible values include: 'Passed', 'Failed',
     'FailedToRun', 'InProgress'
    :vartype state: str or
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentScanState
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: datetime
    :ivar end_time: The scan end time (UTC).
    :vartype end_time: datetime
    :ivar errors: The scan errors.
    :vartype errors:
     list[~azure.mgmt.synapse.models.VulnerabilityAssessmentScanError]
    :ivar storage_container_path: The scan results storage container path.
    :vartype storage_container_path: str
    :ivar number_of_failed_security_checks: The number of failed security
     checks.
    :vartype number_of_failed_security_checks: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scan_id': {'readonly': True},
        'trigger_type': {'readonly': True},
        'state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'readonly': True},
        'storage_container_path': {'readonly': True},
        'number_of_failed_security_checks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scan_id': {'key': 'properties.scanId', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'errors': {'key': 'properties.errors', 'type': '[VulnerabilityAssessmentScanError]'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'number_of_failed_security_checks': {'key': 'properties.numberOfFailedSecurityChecks', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentScanRecord, self).__init__(**kwargs)
        self.scan_id = None
        self.trigger_type = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.storage_container_path = None
        self.number_of_failed_security_checks = None


class Workspace(TrackedResource):
    """A workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param default_data_lake_storage: Workspace default data lake storage
     account details
    :type default_data_lake_storage:
     ~azure.mgmt.synapse.models.DataLakeStorageAccountDetails
    :param sql_administrator_login_password: SQL administrator login password
    :type sql_administrator_login_password: str
    :ivar managed_resource_group_name: Workspace managed resource group
    :vartype managed_resource_group_name: str
    :ivar provisioning_state: Resource provisioning state
    :vartype provisioning_state: str
    :param sql_administrator_login: Login for workspace SQL active directory
     administrator
    :type sql_administrator_login: str
    :param virtual_network_profile: Virtual Network profile
    :type virtual_network_profile:
     ~azure.mgmt.synapse.models.VirtualNetworkProfile
    :param connectivity_endpoints: Connectivity endpoints
    :type connectivity_endpoints: dict[str, str]
    :param managed_virtual_network: Setting this to 'default' will ensure that
     all compute for this workspace is in a virtual network managed on behalf
     of the user.
    :type managed_virtual_network: str
    :param private_endpoint_connections: Private endpoint connections to the
     workspace
    :type private_endpoint_connections:
     list[~azure.mgmt.synapse.models.PrivateEndpointConnection]
    :param identity: Identity of the workspace
    :type identity: ~azure.mgmt.synapse.models.ManagedIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_resource_group_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'default_data_lake_storage': {'key': 'properties.defaultDataLakeStorage', 'type': 'DataLakeStorageAccountDetails'},
        'sql_administrator_login_password': {'key': 'properties.sqlAdministratorLoginPassword', 'type': 'str'},
        'managed_resource_group_name': {'key': 'properties.managedResourceGroupName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sql_administrator_login': {'key': 'properties.sqlAdministratorLogin', 'type': 'str'},
        'virtual_network_profile': {'key': 'properties.virtualNetworkProfile', 'type': 'VirtualNetworkProfile'},
        'connectivity_endpoints': {'key': 'properties.connectivityEndpoints', 'type': '{str}'},
        'managed_virtual_network': {'key': 'properties.managedVirtualNetwork', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
    }

    def __init__(self, **kwargs):
        super(Workspace, self).__init__(**kwargs)
        self.default_data_lake_storage = kwargs.get('default_data_lake_storage', None)
        self.sql_administrator_login_password = kwargs.get('sql_administrator_login_password', None)
        self.managed_resource_group_name = None
        self.provisioning_state = None
        self.sql_administrator_login = kwargs.get('sql_administrator_login', None)
        self.virtual_network_profile = kwargs.get('virtual_network_profile', None)
        self.connectivity_endpoints = kwargs.get('connectivity_endpoints', None)
        self.managed_virtual_network = kwargs.get('managed_virtual_network', None)
        self.private_endpoint_connections = kwargs.get('private_endpoint_connections', None)
        self.identity = kwargs.get('identity', None)


class WorkspaceAadAdminInfo(ProxyResource):
    """Workspace active directory administrator.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tenant_id: Tenant ID of the workspace active directory
     administrator
    :type tenant_id: str
    :param login: Login of the workspace active directory administrator
    :type login: str
    :param administrator_type: Workspace active directory administrator type
    :type administrator_type: str
    :param sid: Object ID of the workspace active directory administrator
    :type sid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkspaceAadAdminInfo, self).__init__(**kwargs)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.login = kwargs.get('login', None)
        self.administrator_type = kwargs.get('administrator_type', None)
        self.sid = kwargs.get('sid', None)


class WorkspacePatchInfo(Model):
    """Workspace patch details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param identity: The identity of the workspace
    :type identity: ~azure.mgmt.synapse.models.ManagedIdentity
    :param sql_administrator_login_password: SQL administrator login password
    :type sql_administrator_login_password: str
    :ivar provisioning_state: Resource provisioning state
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'sql_administrator_login_password': {'key': 'properties.sqlAdministratorLoginPassword', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkspacePatchInfo, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.sql_administrator_login_password = kwargs.get('sql_administrator_login_password', None)
        self.provisioning_state = None
