% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/401-extractProtAAC.R
\name{extractProtAAC}
\alias{extractProtAAC}
\title{Amino Acid Composition Descriptor}
\usage{
extractProtAAC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 20 named vector
}
\description{
Amino Acid Composition Descriptor
}
\details{
This function calculates the Amino Acid Composition descriptor (Dim: 20).
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'Rcpi'))[[1]]
extractProtAAC(x)

}
\references{
M. Bhasin, G. P. S. Raghava.
Classification of Nuclear Receptors Based on
Amino Acid Composition and Dipeptide Composition.
\emph{Journal of Biological Chemistry}, 2004, 279, 23262.
}
\seealso{
See \code{\link{extractProtDC}} and \code{\link{extractProtTC}}
         for Dipeptide Composition and Tripeptide Composition descriptors.
}
