% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-map.r
\name{map_data}
\alias{map_data}
\title{Create a data frame of map data}
\usage{
map_data(map, region = ".", exact = FALSE, ...)
}
\arguments{
\item{map}{name of map provided by the \pkg{maps} package. These
include \code{\link[maps:county]{maps::county()}}, \code{\link[maps:france]{maps::france()}},
\code{\link[maps:italy]{maps::italy()}}, \code{\link[maps:nz]{maps::nz()}},
\code{\link[maps:state]{maps::state()}}, \code{\link[maps:usa]{maps::usa()}},
\code{\link[maps:world]{maps::world()}}, \code{\link[maps:world2]{maps::world2()}}.}

\item{region}{name(s) of subregion(s) to include. Defaults to \code{.} which
includes all subregions. See documentation for \code{\link[maps:map]{maps::map()}}
for more details.}

\item{exact}{should the \code{region} be treated as a regular expression
(\code{FALSE}) or as a fixed string (\code{TRUE}).}

\item{...}{all other arguments passed on to \code{\link[maps:map]{maps::map()}}}
}
\description{
Easily turn data from the \pkg{maps} package into a data frame suitable
for plotting with ggplot2.
}
\examples{
if (require("maps")) {
states <- map_data("state")
arrests <- USArrests
names(arrests) <- tolower(names(arrests))
arrests$region <- tolower(rownames(USArrests))

choro <- merge(states, arrests, sort = FALSE, by = "region")
choro <- choro[order(choro$order), ]
ggplot(choro, aes(long, lat)) +
  geom_polygon(aes(group = group, fill = assault)) +
  coord_map("albers",  lat0 = 45.5, lat1 = 29.5)
}

if (require("maps")) {
ggplot(choro, aes(long, lat)) +
  geom_polygon(aes(group = group, fill = assault / murder)) +
  coord_map("albers",  lat0 = 45.5, lat1 = 29.5)
}
}
\keyword{internal}
