% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recordedplot-methods.R
\name{architecture}
\alias{architecture}
\alias{as.architecture}
\title{Get the architecture of an object or coerce it into another}
\usage{
architecture(x, ...)

as.architecture(
  x,
  ostype = .Platform$OS.type,
  arch = R.version$arch,
  ptrsize = .Machine$sizeof.pointer,
  endian = .Platform$endian,
  ...
)
}
\arguments{
\item{x}{The object to be coerced.}

\item{...}{(optional) Additional arguments passed to the underlying method.}

\item{ostype}{A character string, e.g. \code{"unix"} and \code{"windows"}.}

\item{arch}{A character string, e.g. \code{"i386"}, \code{"i686"} and \code{"x86_64"}.}

\item{ptrsize}{The target pointer size - either \code{4L} or \code{8L}.}

\item{endian}{The target endianess - either \code{"little"} or \code{"big"}.}
}
\value{
\code{architecture()} returns a named list with
    character element \code{ostype} and \code{arch},
    integer element \code{ptrsize}, and character element \code{endian}.
    These elements take a missing values if they could not be inferred.

\code{as.architecture()} returns a coerced version of \code{x}.
    If no coercion was needed, then \code{x} itself is returned.
}
\description{
Get the architecture of an object or coerce it into another
}
