(module scheme-gui scheme/base
  
  (require mred framework scheme/class 
           mzlib/pconvert mzlib/pretty
	   (for-syntax scheme/base))
  
  (require (except-in "scheme-tests.rkt" test) "test-display.scm")
  
  (define (make-formatter printer)
    (lambda (value)
      (let* ([text* (new (text:ports-mixin
                          (text:wide-snip-mixin
                           (text:basic-mixin
                            (editor:standard-style-list-mixin
                             (editor:basic-mixin
                              text%))))))]
             [text-snip (new editor-snip% [editor text*])])
        (send text-snip use-style-background #t)
        (printer value (send text* get-value-port))
        (flush-output (send text* get-value-port))
        (send text* delete/io (- (send text* last-position) 1) (send text* last-position))
        (send text* lock #t) 
        text-snip)))
  
  (define (format-value value)
    (parameterize ([constructor-style-printing #t]
                   [pretty-print-columns 40])
      (make-formatter (lambda (v o) (pretty-print (print-convert v) o)))))
  
  #;(define (format-value value)
    (cond
      [(is-a? value snip%) value]
      [(or (pair? value) (struct? value))
       (parameterize ([constructor-style-printing #t]
                      [pretty-print-columns 40])
         (let* ([text* (new (editor:standard-style-list-mixin text%))]
                [text-snip (new editor-snip% [editor text*])])
           (pretty-print (print-convert value) (open-output-text-editor text*))
           (send text* lock #t)
           text-snip))]
      [else (format "~v" value)]))
  
  (define (test*)
    (run-tests)
    (pop-up))
  
  (define-syntax (test stx) 
    (syntax-case stx ()
      [(_)
       (syntax-property
	#'(test*)
	'test-call #t)]))

  (define (pop-up)
    (let ([test-info (namespace-variable-value 'test~object #f builder (current-namespace))])
      (parameterize ([test-format format-value])
        (and test-info
             (send test-info refine-display-class test-display%)
             (send test-info setup-display #f #f)
             (send test-info summarize-results (current-output-port))))))
  
  (provide test format-value make-formatter (all-from-out "scheme-tests.rkt"))
  
  )
