# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from TestUnit.idl.

use strict;

package Raritan::RPC::test::Unit_1_0_2;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "test.Unit:1.0.2";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::test::Unit_1_0_2::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}


sub getDisplays($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDisplays', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'test.Display');
    }
    return $_ret_;
}

sub getButtonStates($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getButtonStates', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = ($rsp->{'_ret_'}->[$i0]) ? 1 : 0;
    }
    return $_ret_;
}

sub setBuzzer($$) {
    my ($self, $isOn) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'isOn'} = ($isOn) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setBuzzer', $args);
}

sub resetAllSlaveControllers($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'resetAllSlaveControllers', $args);
}

sub triggerSlaveControllerWatchdog($$) {
    my ($self, $rs485Addr) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rs485Addr'} = 1 * $rs485Addr;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'triggerSlaveControllerWatchdog', $args);
}

Raritan::RPC::Registry::registerProxyClass('test.Unit', 1, 0, 2, 'Raritan::RPC::test::Unit_1_0_2');
1;
