// Licensed under the MIT License.
// Copyright David LeBlanc - dcl@dleblanc.net
#if defined _MSC_VER
// Inline expansion warnings
#pragma warning(disable:4710 4711)
#endif

#include "TestMain.h"
#include "TestCase.h"

/*
* Interesting numbers:
*
*  std::uint64_t
*  0, 1, 2, 0x7fffffff, 0x80000000, 0xffffffff, 0x100000000, 0x200000000, 0x7fffffffffffffff, 0x8000000000000000, 0xffffffffffffffff
*  std::uint32_t
*  0, 1, 2, 0x7fffffff, 0x80000000, 0xffffffff
*  std::int64_t
*  0, 1, 2, 0x7fffffff, 0x80000000, 0xffffffff, 0x100000000, 0x200000000, 0x7fffffffffffffff, 0x8000000000000000, 0xffffffffffffffff
*/

// For the most part, unsigned-unsigned combinations are not going to give us any problems
// Only thing to verify is that 0/0 still throws
static const TestCase< std::uint64_t, std::uint64_t, OpType::Div > uint64_uint64[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0x100000000,           0x7fffffff, true },
   { 0x200000000,           0x7fffffff, true },
   { 0x7fffffffffffffff,    0x7fffffff, true },
   { 0x8000000000000000,    0x7fffffff, true },
   { 0xffffffffffffffff,    0x7fffffff, true },
   { 0,                     0x80000000, true },
   { 1,                     0x80000000, true },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { 0x80000000,            0x80000000, true },
   { 0xffffffff,            0x80000000, true },
   { 0x100000000,           0x80000000, true },
   { 0x200000000,           0x80000000, true },
   { 0x7fffffffffffffff,    0x80000000, true },
   { 0x8000000000000000,    0x80000000, true },
   { 0xffffffffffffffff,    0x80000000, true },
   { 0,                     0xffffffff, true },
   { 1,                     0xffffffff, true },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { 0x80000000,            0xffffffff, true },
   { 0xffffffff,            0xffffffff, true },
   { 0x100000000,           0xffffffff, true },
   { 0x200000000,           0xffffffff, true },
   { 0x7fffffffffffffff,    0xffffffff, true },
   { 0x8000000000000000,    0xffffffff, true },
   { 0xffffffffffffffff,    0xffffffff, true },
   { 0,                     0x100000000, true },
   { 1,                     0x100000000, true },
   { 2,                     0x100000000, true },
   { 0x7fffffff,            0x100000000, true },
   { 0x80000000,            0x100000000, true },
   { 0xffffffff,            0x100000000, true },
   { 0x100000000,           0x100000000, true },
   { 0x200000000,           0x100000000, true },
   { 0x7fffffffffffffff,    0x100000000, true },
   { 0x8000000000000000,    0x100000000, true },
   { 0xffffffffffffffff,    0x100000000, true },
   { 0,                     0x200000000, true },
   { 1,                     0x200000000, true },
   { 2,                     0x200000000, true },
   { 0x7fffffff,            0x200000000, true },
   { 0x80000000,            0x200000000, true },
   { 0xffffffff,            0x200000000, true },
   { 0x100000000,           0x200000000, true },
   { 0x200000000,           0x200000000, true },
   { 0x7fffffffffffffff,    0x200000000, true },
   { 0x8000000000000000,    0x200000000, true },
   { 0xffffffffffffffff,    0x200000000, true },
   { 0,                     0x7fffffffffffffff, true },
   { 1,                     0x7fffffffffffffff, true },
   { 2,                     0x7fffffffffffffff, true },
   { 0x7fffffff,            0x7fffffffffffffff, true },
   { 0x80000000,            0x7fffffffffffffff, true },
   { 0xffffffff,            0x7fffffffffffffff, true },
   { 0x100000000,           0x7fffffffffffffff, true },
   { 0x200000000,           0x7fffffffffffffff, true },
   { 0x7fffffffffffffff,    0x7fffffffffffffff, true },
   { 0x8000000000000000,    0x7fffffffffffffff, true },
   { 0xffffffffffffffff,    0x7fffffffffffffff, true },
   { 0,                     0x8000000000000000, true },
   { 1,                     0x8000000000000000, true },
   { 2,                     0x8000000000000000, true },
   { 0x7fffffff,            0x8000000000000000, true },
   { 0x80000000,            0x8000000000000000, true },
   { 0xffffffff,            0x8000000000000000, true },
   { 0x100000000,           0x8000000000000000, true },
   { 0x200000000,           0x8000000000000000, true },
   { 0x7fffffffffffffff,    0x8000000000000000, true },
   { 0x8000000000000000,    0x8000000000000000, true },
   { 0xffffffffffffffff,    0x8000000000000000, true },
   { 0,                     0xffffffffffffffff, true },
   { 1,                     0xffffffffffffffff, true },
   { 2,                     0xffffffffffffffff, true },
   { 0x7fffffff,            0xffffffffffffffff, true },
   { 0x80000000,            0xffffffffffffffff, true },
   { 0xffffffff,            0xffffffffffffffff, true },
   { 0x100000000,           0xffffffffffffffff, true },
   { 0x200000000,           0xffffffffffffffff, true },
   { 0x7fffffffffffffff,    0xffffffffffffffff, true },
   { 0x8000000000000000,    0xffffffffffffffff, true },
   { 0xffffffffffffffff,    0xffffffffffffffff, true },
};

template<> TestVector< std::uint64_t, std::uint64_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint64_uint64;
    this->count = COUNTOF(uint64_uint64);
}

static const TestCase< std::uint64_t, std::uint32_t, OpType::Div > uint64_uint32[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0x100000000,           0x7fffffff, true },
   { 0x200000000,           0x7fffffff, true },
   { 0x7fffffffffffffff,    0x7fffffff, true },
   { 0x8000000000000000,    0x7fffffff, true },
   { 0xffffffffffffffff,    0x7fffffff, true },
   { 0,                     0x80000000, true },
   { 1,                     0x80000000, true },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { 0x80000000,            0x80000000, true },
   { 0xffffffff,            0x80000000, true },
   { 0x100000000,           0x80000000, true },
   { 0x200000000,           0x80000000, true },
   { 0x7fffffffffffffff,    0x80000000, true },
   { 0x8000000000000000,    0x80000000, true },
   { 0xffffffffffffffff,    0x80000000, true },
   { 0,                     0xffffffff, true },
   { 1,                     0xffffffff, true },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { 0x80000000,            0xffffffff, true },
   { 0xffffffff,            0xffffffff, true },
   { 0x100000000,           0xffffffff, true },
   { 0x200000000,           0xffffffff, true },
   { 0x7fffffffffffffff,    0xffffffff, true },
   { 0x8000000000000000,    0xffffffff, true },
   { 0xffffffffffffffff,    0xffffffff, true },
};

template<> TestVector< std::uint64_t, std::uint32_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint64_uint32;
    this->count = COUNTOF(uint64_uint32);
}

static const TestCase< std::uint64_t, std::uint16_t, OpType::Div > uint64_uint16[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
};

template<> TestVector< std::uint64_t, std::uint16_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint64_uint16;
    this->count = COUNTOF(uint64_uint16);
}

static const TestCase< std::uint64_t, std::uint8_t, OpType::Div > uint64_uint8[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
};

template<> TestVector< std::uint64_t, std::uint8_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint64_uint8;
    this->count = COUNTOF(uint64_uint8);
}

// Same problem as unsigned-signed, but anything negative should now fail
// There are corner cases in the U op SafeInt<T> path, which has to be tested
// individually
static const TestCase< std::uint64_t, std::int64_t, OpType::Div > uint64_int64[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0x100000000,           0x7fffffff, true },
   { 0x200000000,           0x7fffffff, true },
   { 0x7fffffffffffffff,    0x7fffffff, true },
   { 0x8000000000000000,    0x7fffffff, true },
   { 0xffffffffffffffff,    0x7fffffff, true },
   { 0,                     0x80000000, true },
   { 1,                     0x80000000, true },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { 0x80000000,            0x80000000, true },
   { 0xffffffff,            0x80000000, true },
   { 0x100000000,           0x80000000, true },
   { 0x200000000,           0x80000000, true },
   { 0x7fffffffffffffff,    0x80000000, true },
   { 0x8000000000000000,    0x80000000, true },
   { 0xffffffffffffffff,    0x80000000, true },
   { 0,                     0xffffffff, true },
   { 1,                     0xffffffff, true },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { 0x80000000,            0xffffffff, true },
   { 0xffffffff,            0xffffffff, true },
   { 0x100000000,           0xffffffff, true },
   { 0x200000000,           0xffffffff, true },
   { 0x7fffffffffffffff,    0xffffffff, true },
   { 0x8000000000000000,    0xffffffff, true },
   { 0xffffffffffffffff,    0xffffffff, true },
   { 0,                     0x100000000, true },
   { 1,                     0x100000000, true },
   { 2,                     0x100000000, true },
   { 0x7fffffff,            0x100000000, true },
   { 0x80000000,            0x100000000, true },
   { 0xffffffff,            0x100000000, true },
   { 0x100000000,           0x100000000, true },
   { 0x200000000,           0x100000000, true },
   { 0x7fffffffffffffff,    0x100000000, true },
   { 0x8000000000000000,    0x100000000, true },
   { 0xffffffffffffffff,    0x100000000, true },
   { 0,                     0x200000000, true },
   { 1,                     0x200000000, true },
   { 2,                     0x200000000, true },
   { 0x7fffffff,            0x200000000, true },
   { 0x80000000,            0x200000000, true },
   { 0xffffffff,            0x200000000, true },
   { 0x100000000,           0x200000000, true },
   { 0x200000000,           0x200000000, true },
   { 0x7fffffffffffffff,    0x200000000, true },
   { 0x8000000000000000,    0x200000000, true },
   { 0xffffffffffffffff,    0x200000000, true },
   { 0,                     0x7fffffffffffffff, true },
   { 1,                     0x7fffffffffffffff, true },
   { 2,                     0x7fffffffffffffff, true },
   { 0x7fffffff,            0x7fffffffffffffff, true },
   { 0x80000000,            0x7fffffffffffffff, true },
   { 0xffffffff,            0x7fffffffffffffff, true },
   { 0x100000000,           0x7fffffffffffffff, true },
   { 0x200000000,           0x7fffffffffffffff, true },
   { 0x7fffffffffffffff,    0x7fffffffffffffff, true },
   { 0x8000000000000000,    0x7fffffffffffffff, true },
   { 0xffffffffffffffff,    0x7fffffffffffffff, true },
   { 0,                     (std::int64_t)0x8000000000000000, true },
   { 1,                     (std::int64_t)0x8000000000000000, true },
   { 2,                     (std::int64_t)0x8000000000000000, true },
   { 0x7fffffff,            (std::int64_t)0x8000000000000000, true },
   { 0x80000000,            (std::int64_t)0x8000000000000000, true },
   { 0xffffffff,            (std::int64_t)0x8000000000000000, true },
   { 0x100000000,           (std::int64_t)0x8000000000000000, true },
   { 0x200000000,           (std::int64_t)0x8000000000000000, true },
   { 0x7fffffffffffffff,    (std::int64_t)0x8000000000000000, true },
   { 0x8000000000000000,    (std::int64_t)0x8000000000000000, false },
   { 0xffffffffffffffff,    (std::int64_t)0x8000000000000000, false },
   { 0,                     (std::int64_t)0xffffffffffffffff, true },
   { 1,                     (std::int64_t)0xffffffffffffffff, false },
   { 2,                     (std::int64_t)0xffffffffffffffff, false },
   { 0x7fffffff,            (std::int64_t)0xffffffffffffffff, false },
   { 0x80000000,            (std::int64_t)0xffffffffffffffff, false },
   { 0xffffffff,            (std::int64_t)0xffffffffffffffff, false },
   { 0x100000000,           (std::int64_t)0xffffffffffffffff, false },
   { 0x200000000,           (std::int64_t)0xffffffffffffffff, false },
   { 0x7fffffffffffffff,    (std::int64_t)0xffffffffffffffff, false },
   { 0x8000000000000000,    (std::int64_t)0xffffffffffffffff, false },
   { 0xffffffffffffffff,    (std::int64_t)0xffffffffffffffff, false },
};

template<> TestVector< std::uint64_t, std::int64_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint64_int64;
    this->count = COUNTOF(uint64_int64);
}

static const TestCase< std::int64_t, std::uint64_t, OpType::Div2 > int64_uint64_2[] =
{
   { 0,                     0, false },
   { 1,                     0, true },
   { 2,                     0, true },
   { 0x7fffffff,            0, true },
   { 0x80000000,            0, true },
   { 0xffffffff,            0, true },
   { 0x100000000,           0, true },
   { 0x200000000,           0, true },
   { 0x7fffffffffffffff,    0, true },
   { (std::int64_t)0x8000000000000000,  0, true },
   { (std::int64_t)0xffffffffffffffff,  0, true },
   { 0,                     1, false },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { (std::int64_t)0x8000000000000000,  1, true },
   { (std::int64_t)0xffffffffffffffff,  1, true },
   { 0,                     2, false },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { (std::int64_t)0x8000000000000000,  2, true },
   { (std::int64_t)0xffffffffffffffff,  2, true },
   { 0,                     0x7fffffff, false },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0x100000000,           0x7fffffff, true },
   { 0x200000000,           0x7fffffff, true },
   { 0x7fffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0x8000000000000000,  0x7fffffff, true },
   { (std::int64_t)0xffffffffffffffff,  0x7fffffff, true },
   { 0,                     0x80000000, false },
   { 1,                     0x80000000, true },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { 0x80000000,            0x80000000, true },
   { 0xffffffff,            0x80000000, true },
   { 0x100000000,           0x80000000, true },
   { 0x200000000,           0x80000000, true },
   { 0x7fffffffffffffff,    0x80000000, true },
   { (std::int64_t)0x8000000000000000,  0x80000000, true },
   { (std::int64_t)0xffffffffffffffff,  0x80000000, true },
   { 0,                     0xffffffff, false },
   { 1,                     0xffffffff, true },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { 0x80000000,            0xffffffff, true },
   { 0xffffffff,            0xffffffff, true },
   { 0x100000000,           0xffffffff, true },
   { 0x200000000,           0xffffffff, true },
   { 0x7fffffffffffffff,    0xffffffff, true },
   { (std::int64_t)0x8000000000000000,  0xffffffff, true },
   { (std::int64_t)0xffffffffffffffff,  0xffffffff, true },
   { 0,                     0x100000000, false },
   { 1,                     0x100000000, true },
   { 2,                     0x100000000, true },
   { 0x7fffffff,            0x100000000, true },
   { 0x80000000,            0x100000000, true },
   { 0xffffffff,            0x100000000, true },
   { 0x100000000,           0x100000000, true },
   { 0x200000000,           0x100000000, true },
   { 0x7fffffffffffffff,    0x100000000, true },
   { (std::int64_t)0x8000000000000000,  0x100000000, true },
   { (std::int64_t)0xffffffffffffffff,  0x100000000, true },
   { 0,                     0x200000000, false },
   { 1,                     0x200000000, true },
   { 2,                     0x200000000, true },
   { 0x7fffffff,            0x200000000, true },
   { 0x80000000,            0x200000000, true },
   { 0xffffffff,            0x200000000, true },
   { 0x100000000,           0x200000000, true },
   { 0x200000000,           0x200000000, true },
   { 0x7fffffffffffffff,    0x200000000, true },
   { (std::int64_t)0x8000000000000000,  0x200000000, true },
   { (std::int64_t)0xffffffffffffffff,  0x200000000, true },
   { 0,                     0x7fffffffffffffff, false },
   { 1,                     0x7fffffffffffffff, true },
   { 2,                     0x7fffffffffffffff, true },
   { 0x7fffffff,            0x7fffffffffffffff, true },
   { 0x80000000,            0x7fffffffffffffff, true },
   { 0xffffffff,            0x7fffffffffffffff, true },
   { 0x100000000,           0x7fffffffffffffff, true },
   { 0x200000000,           0x7fffffffffffffff, true },
   { 0x7fffffffffffffff,    0x7fffffffffffffff, true },
   { (std::int64_t)0x8000000000000000,  0x7fffffffffffffff, true },
   { (std::int64_t)0xffffffffffffffff,  0x7fffffffffffffff, true },
   { 0,                     0x8000000000000000, false },
   { 1,                     0x8000000000000000, false },
   { 2,                     0x8000000000000000, true },
   { 0x7fffffff,            0x8000000000000000, true },
   { 0x80000000,            0x8000000000000000, true },
   { 0xffffffff,            0x8000000000000000, true },
   { 0x100000000,           0x8000000000000000, true },
   { 0x200000000,           0x8000000000000000, true },
   { 0x7fffffffffffffff,    0x8000000000000000, true },
   { (std::int64_t)0x8000000000000000,  0x8000000000000000, true },
   { (std::int64_t)0xffffffffffffffff,  0x8000000000000000, true },
   { 0,                     0xffffffffffffffff, false },
   { 1,                     0xffffffffffffffff, false },
   { 2,                     0xffffffffffffffff, true },
   { 0x7fffffff,            0xffffffffffffffff, true },
   { 0x80000000,            0xffffffffffffffff, true },
   { 0xffffffff,            0xffffffffffffffff, true },
   { 0x100000000,           0xffffffffffffffff, true },
   { 0x200000000,           0xffffffffffffffff, true },
   { 0x7fffffffffffffff,    0xffffffffffffffff, true },
   { (std::int64_t)0x8000000000000000,  0xffffffffffffffff, true },
   { (std::int64_t)0xffffffffffffffff,  0xffffffffffffffff, false },
};

template<> TestVector< std::int64_t, std::uint64_t, OpType::Div2 >::TestVector() : current(0)
{
    this->test_cases = int64_uint64_2;
    this->count = COUNTOF(int64_uint64_2);
}

static const TestCase< std::uint64_t, std::int32_t, OpType::Div > uint64_int32[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0x100000000,           0x7fffffff, true },
   { 0x200000000,           0x7fffffff, true },
   { 0x7fffffffffffffff,    0x7fffffff, true },
   { 0x8000000000000000,    0x7fffffff, true },
   { 0xffffffffffffffff,    0x7fffffff, true },
   { 0,                     (std::int32_t)0x80000000, true },
   { 1,                     (std::int32_t)0x80000000, true },
   { 2,                     (std::int32_t)0x80000000, true },
   { 0x7fffffff,            (std::int32_t)0x80000000, true },
   { 0x80000000,            (std::int32_t)0x80000000, false },
   { 0xffffffff,            (std::int32_t)0x80000000, false },
   { 0x100000000,           (std::int32_t)0x80000000, false },
   { 0x200000000,           (std::int32_t)0x80000000, false },
   { 0x7fffffffffffffff,    (std::int32_t)0x80000000, false },
   { 0x8000000000000000,    (std::int32_t)0x80000000, false },
   { 0xffffffffffffffff,    (std::int32_t)0x80000000, false },
   { 0,                     (std::int32_t)0xffffffff, true },
   { 1,                     (std::int32_t)0xffffffff, false },
   { 2,                     (std::int32_t)0xffffffff, false },
   { 0x7fffffff,            (std::int32_t)0xffffffff, false },
   { 0x80000000,            (std::int32_t)0xffffffff, false },
   { 0xffffffff,            (std::int32_t)0xffffffff, false },
   { 0x100000000,           (std::int32_t)0xffffffff, false },
   { 0x200000000,           (std::int32_t)0xffffffff, false },
   { 0x7fffffffffffffff,    (std::int32_t)0xffffffff, false },
   { 0x8000000000000000,    (std::int32_t)0xffffffff, false },
   { 0xffffffffffffffff,    (std::int32_t)0xffffffff, false },
};

template<> TestVector< std::uint64_t, std::int32_t, OpType::Div >::TestVector() : current(0)
{
    this->test_cases = uint64_int32;
    this->count = COUNTOF(uint64_int32);
}

static const TestCase< std::int32_t, std::uint64_t, OpType::Div2 > int32_uint64_2[] =
{
   { 0,                     0, false },
   { 1,                     0, true },
   { 2,                     0, true },
   { 0x7fffffff,            0, true },
   { (std::int32_t)0x80000000,            0, true },
   { (std::int32_t)0xffffffff,            0, true },
   { 0,                     1, false },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { (std::int32_t)0x80000000,            1, true },
   { (std::int32_t)0xffffffff,            1, true },
   { 0,                     2, false },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { (std::int32_t)0x80000000,            2, true },
   { (std::int32_t)0xffffffff,            2, true },
   { 0,                     0x7fffffff, false },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { (std::int32_t)0x80000000,            0x7fffffff, true },
   { (std::int32_t)0xffffffff,            0x7fffffff, true },
   { 0,                     0x80000000, false },
   { 1,                     0x80000000, false },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { (std::int32_t)0x80000000,            0x80000000, true },
   { (std::int32_t)0xffffffff,            0x80000000, true },
   { 0,                     0xffffffff, false },
   { 1,                     0xffffffff, false },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { (std::int32_t)0x80000000,            0xffffffff, true },
   { (std::int32_t)0xffffffff,            0xffffffff, false },
   { 0,                     0x100000000, false },
   { 1,                     0x100000000, false },
   { 2,                     0x100000000, false },
   { 0x7fffffff,            0x100000000, true },
   { (std::int32_t)0x80000000,            0x100000000, true },
   { (std::int32_t)0xffffffff,            0x100000000, false },
   { 0,                     0x200000000, false },
   { 1,                     0x200000000, false },
   { 2,                     0x200000000, false },
   { 0x7fffffff,            0x200000000, true },
   { (std::int32_t)0x80000000,            0x200000000, true },
   { (std::int32_t)0xffffffff,            0x200000000, false },
   { 0,                     0x7fffffffffffffff, false },
   { 1,                     0x7fffffffffffffff, false },
   { 2,                     0x7fffffffffffffff, false },
   { 0x7fffffff,            0x7fffffffffffffff, false },
   { (std::int32_t)0x80000000,            0x7fffffffffffffff, false },
   { (std::int32_t)0xffffffff,            0x7fffffffffffffff, false },
   { 0,                     0x8000000000000000, false },
   { 1,                     0x8000000000000000, false },
   { 2,                     0x8000000000000000, false },
   { 0x7fffffff,            0x8000000000000000, false },
   { (std::int32_t)0x80000000,            0x8000000000000000, false },
   { (std::int32_t)0xffffffff,            0x8000000000000000, false },
   { 0,                     0xffffffffffffffff, false },
   { 1,                     0xffffffffffffffff, false },
   { 2,                     0xffffffffffffffff, false },
   { 0x7fffffff,            0xffffffffffffffff, false },
   { (std::int32_t)0x80000000,            0xffffffffffffffff, false },
   { (std::int32_t)0xffffffff,            0xffffffffffffffff, false },
};

template<> TestVector< std::int32_t, std::uint64_t, OpType::Div2 >::TestVector() : current(0)
{
    this->test_cases = int32_uint64_2;
    this->count = COUNTOF(int32_uint64_2);
}


static const TestCase< std::uint64_t, std::int16_t, OpType::Div > uint64_int16[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
   { 0,                     -1, true },
   { 1,                     -1, false },
   { 2,                     -1, false },
   { 0x7fffffff,            -1, false },
   { 0x80000000,            -1, false },
   { 0xffffffff,            -1, false },
   { 0x100000000,           -1, false },
   { 0x200000000,           -1, false },
   { 0x7fffffffffffffff,    -1, false },
   { 0x8000000000000000,    -1, false },
   { 0xffffffffffffffff,    -1, false },
};

template<> TestVector< std::uint64_t, std::int16_t, OpType::Div >::TestVector() : current(0)
{
    this->test_cases = uint64_int16;
    this->count = COUNTOF(uint64_int16);
}

static const TestCase< std::int16_t, std::uint64_t, OpType::Div2 > int16_uint64_2[] =
{
   { (std::int16_t)0,                     0, false },
   { (std::int16_t)1,                     0, true },
   { (std::int16_t)2,                     0, true },
   { (std::int16_t)0x7fff,                0, true },
   { (std::int16_t)0x8000,                0, true },
   { (std::int16_t)0xffff,                0, true },
   { (std::int16_t)0,                     1, false },
   { (std::int16_t)1,                     1, true },
   { (std::int16_t)2,                     1, true },
   { (std::int16_t)0x7fff,                1, true },
   { (std::int16_t)0x8000,                1, true },
   { (std::int16_t)0xffff,                1, true },
   { (std::int16_t)0,                     2, false },
   { (std::int16_t)1,                     2, true },
   { (std::int16_t)2,                     2, true },
   { (std::int16_t)0x7fff,                2, true },
   { (std::int16_t)0x8000,                2, true },
   { (std::int16_t)0xffff,                2, true },
   { (std::int16_t)0,                     0x7fffffff, false },
   { (std::int16_t)1,                     0x7fffffff, true },
   { (std::int16_t)2,                     0x7fffffff, true },
   { (std::int16_t)0x7fff,                0x7fffffff, true },
   { (std::int16_t)0x8000,                0x7fffffff, true },
   { (std::int16_t)0xffff,                0x7fffffff, true },
   { (std::int16_t)0,                     0x80000000, false },
   { (std::int16_t)1,                     0x80000000, false },
   { (std::int16_t)2,                     0x80000000, true },
   { (std::int16_t)0x7fff,                0x80000000, true },
   { (std::int16_t)0x8000,                0x80000000, true },
   { (std::int16_t)0xffff,                0x80000000, true },
   { (std::int16_t)0,                     0xffffffff, false },
   { (std::int16_t)1,                     0xffffffff, false },
   { (std::int16_t)2,                     0xffffffff, true },
   { (std::int16_t)0x7fff,                0xffffffff, true },
   { (std::int16_t)0x8000,                0xffffffff, true },
   { (std::int16_t)0xffff,                0xffffffff, false },
   { (std::int16_t)0,                     0x100000000, false },
   { (std::int16_t)1,                     0x100000000, false },
   { (std::int16_t)2,                     0x100000000, false },
   { (std::int16_t)0x7fff,                0x100000000, true },
   { (std::int16_t)0x8000,                0x100000000, true },
   { (std::int16_t)0xffff,                0x100000000, false },
   { (std::int16_t)0,                     0x200000000, false },
   { (std::int16_t)1,                     0x200000000, false },
   { (std::int16_t)2,                     0x200000000, false },
   { (std::int16_t)0x7fff,                0x200000000, true },
   { (std::int16_t)0x8000,                0x200000000, true },
   { (std::int16_t)0xffff,                0x200000000, false },
   { (std::int16_t)0,                     0x7fffffffffffffff, false },
   { (std::int16_t)1,                     0x7fffffffffffffff, false },
   { (std::int16_t)2,                     0x7fffffffffffffff, false },
   { (std::int16_t)0x7fff,                0x7fffffffffffffff, false },
   { (std::int16_t)0x8000,                0x7fffffffffffffff, false },
   { (std::int16_t)0xffff,                0x7fffffffffffffff, false },
   { (std::int16_t)0,                     0x8000000000000000, false },
   { (std::int16_t)1,                     0x8000000000000000, false },
   { (std::int16_t)2,                     0x8000000000000000, false },
   { (std::int16_t)0x7fff,                0x8000000000000000, false },
   { (std::int16_t)0x8000,                0x8000000000000000, false },
   { (std::int16_t)0xffff,                0x8000000000000000, false },
   { (std::int16_t)0,                     0xffffffffffffffff, false },
   { (std::int16_t)1,                     0xffffffffffffffff, false },
   { (std::int16_t)2,                     0xffffffffffffffff, false },
   { (std::int16_t)0x7fff,                0xffffffffffffffff, false },
   { (std::int16_t)0x8000,                0xffffffffffffffff, false },
   { (std::int16_t)0xffff,                0xffffffffffffffff, false },
};

template<> TestVector< std::int16_t, std::uint64_t, OpType::Div2 >::TestVector() : current(0)
{
    this->test_cases = int16_uint64_2;
    this->count = COUNTOF(int16_uint64_2);
}

static const TestCase< std::uint64_t, std::int8_t, OpType::Div > uint64_int8[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0x100000000,           0, false },
   { 0x200000000,           0, false },
   { 0x7fffffffffffffff,    0, false },
   { 0x8000000000000000,    0, false },
   { 0xffffffffffffffff,    0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0x100000000,           1, true },
   { 0x200000000,           1, true },
   { 0x7fffffffffffffff,    1, true },
   { 0x8000000000000000,    1, true },
   { 0xffffffffffffffff,    1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0x100000000,           2, true },
   { 0x200000000,           2, true },
   { 0x7fffffffffffffff,    2, true },
   { 0x8000000000000000,    2, true },
   { 0xffffffffffffffff,    2, true },
   { 0,                     -1, true },
   { 1,                     -1, false },
   { 2,                     -1, false },
   { 0x7fffffff,            -1, false },
   { 0x80000000,            -1, false },
   { 0xffffffff,            -1, false },
   { 0x100000000,           -1, false },
   { 0x200000000,           -1, false },
   { 0x7fffffffffffffff,    -1, false },
   { 0x8000000000000000,    -1, false },
   { 0xffffffffffffffff,    -1, false },
};

template<> TestVector< std::uint64_t, std::int8_t, OpType::Div >::TestVector() : current(0)
{
    this->test_cases = uint64_int8;
    this->count = COUNTOF(uint64_int8);
}

static const TestCase< std::int8_t, std::uint64_t, OpType::Div2 > int8_uint64_2[] =
{
   { (std::int8_t)0,                     0, false },
   { (std::int8_t)1,                     0, true },
   { (std::int8_t)2,                     0, true },
   { (std::int8_t)0x7f,                  0, true },
   { (std::int8_t)0x80,                  0, true },
   { (std::int8_t)0xff,                  0, true },
   { (std::int8_t)0,                     1, false },
   { (std::int8_t)1,                     1, true },
   { (std::int8_t)2,                     1, true },
   { (std::int8_t)0x7f,                  1, true },
   { (std::int8_t)0x80,                  1, true },
   { (std::int8_t)0xff,                  1, true },
   { (std::int8_t)0,                     2, false },
   { (std::int8_t)1,                     2, true },
   { (std::int8_t)2,                     2, true },
   { (std::int8_t)0x7f,                  2, true },
   { (std::int8_t)0x80,                  2, true },
   { (std::int8_t)0xff,                  2, true },
   { (std::int8_t)0,                     0x7fffffff, false },
   { (std::int8_t)1,                     0x7fffffff, true },
   { (std::int8_t)2,                     0x7fffffff, true },
   { (std::int8_t)0x7f,                  0x7fffffff, true },
   { (std::int8_t)0x80,                  0x7fffffff, true },
   { (std::int8_t)0xff,                  0x7fffffff, true },
   { (std::int8_t)0,                     0x80000000, false },
   { (std::int8_t)1,                     0x80000000, false },
   { (std::int8_t)2,                     0x80000000, true },
   { (std::int8_t)0x7f,                  0x80000000, true },
   { (std::int8_t)0x80,                  0x80000000, true },
   { (std::int8_t)0xff,                  0x80000000, true },
   { (std::int8_t)0,                     0xffffffff, false },
   { (std::int8_t)1,                     0xffffffff, false },
   { (std::int8_t)2,                     0xffffffff, true },
   { (std::int8_t)0x7f,                  0xffffffff, true },
   { (std::int8_t)0x80,                  0xffffffff, true },
   { (std::int8_t)0xff,                  0xffffffff, false },
   { (std::int8_t)0,                     0x100000000, false },
   { (std::int8_t)1,                     0x100000000, false },
   { (std::int8_t)2,                     0x100000000, false },
   { (std::int8_t)0x7f,                  0x100000000, true },
   { (std::int8_t)0x80,                  0x100000000, true },
   { (std::int8_t)0xff,                  0x100000000, false },
   { (std::int8_t)0,                     0x200000000, false },
   { (std::int8_t)1,                     0x200000000, false },
   { (std::int8_t)2,                     0x200000000, false },
   { (std::int8_t)0x7f,                  0x200000000, true },
   { (std::int8_t)0x80,                  0x200000000, true },
   { (std::int8_t)0xff,                  0x200000000, false },
   { (std::int8_t)0,                     0x7fffffffffffffff, false },
   { (std::int8_t)1,                     0x7fffffffffffffff, false },
   { (std::int8_t)2,                     0x7fffffffffffffff, false },
   { (std::int8_t)0x7f,                  0x7fffffffffffffff, false },
   { (std::int8_t)0x80,                  0x7fffffffffffffff, false },
   { (std::int8_t)0xff,                  0x7fffffffffffffff, false },
   { (std::int8_t)0,                     0x8000000000000000, false },
   { (std::int8_t)1,                     0x8000000000000000, false },
   { (std::int8_t)2,                     0x8000000000000000, false },
   { (std::int8_t)0x7f,                  0x8000000000000000, false },
   { (std::int8_t)0x80,                  0x8000000000000000, false },
   { (std::int8_t)0xff,                  0x8000000000000000, false },
   { (std::int8_t)0,                     0xffffffffffffffff, false },
   { (std::int8_t)1,                     0xffffffffffffffff, false },
   { (std::int8_t)2,                     0xffffffffffffffff, false },
   { (std::int8_t)0x7f,                  0xffffffffffffffff, false },
   { (std::int8_t)0x80,                  0xffffffffffffffff, false },
   { (std::int8_t)0xff,                  0xffffffffffffffff, false },
};

template<> TestVector< std::int8_t, std::uint64_t, OpType::Div2 >::TestVector() : current(0)
{
    this->test_cases = int8_uint64_2;
    this->count = COUNTOF(int8_uint64_2);
}

static const TestCase< std::int64_t, std::int64_t, OpType::Div > int64_int64[] =
{
   { (std::int64_t)0,                     0LL, false },
   { (std::int64_t)1,                     0LL, false },
   { (std::int64_t)2,                     0LL, false },
   { (std::int64_t)0x7fffffff,            0LL, false },
   { (std::int64_t)0x80000000,            0LL, false },
   { (std::int64_t)0xffffffff,            0LL, false },
   { (std::int64_t)0x100000000,           0LL, false },
   { (std::int64_t)0x200000000,           0LL, false },
   { (std::int64_t)0x7fffffffffffffff,    0LL, false },
   { (std::int64_t)0x8000000000000000,    0LL, false },
   { (std::int64_t)0xffffffffffffffff,    0LL, false },
   { (std::int64_t)0,                     1LL, true },
   { (std::int64_t)1,                     1LL, true },
   { (std::int64_t)2,                     1LL, true },
   { (std::int64_t)0x7fffffff,            1LL, true },
   { (std::int64_t)0x80000000,            1LL, true },
   { (std::int64_t)0xffffffff,            1LL, true },
   { (std::int64_t)0x100000000,           1LL, true },
   { (std::int64_t)0x200000000,           1LL, true },
   { (std::int64_t)0x7fffffffffffffff,    1LL, true },
   { (std::int64_t)0x8000000000000000,    1LL, true },
   { (std::int64_t)0xffffffffffffffff,    1LL, true },
   { (std::int64_t)0,                     2LL, true },
   { (std::int64_t)1,                     2LL, true },
   { (std::int64_t)2,                     2LL, true },
   { (std::int64_t)0x7fffffff,            2LL, true },
   { (std::int64_t)0x80000000,            2LL, true },
   { (std::int64_t)0xffffffff,            2LL, true },
   { (std::int64_t)0x100000000,           2LL, true },
   { (std::int64_t)0x200000000,           2LL, true },
   { (std::int64_t)0x7fffffffffffffff,    2LL, true },
   { (std::int64_t)0x8000000000000000,    2LL, true },
   { (std::int64_t)0xffffffffffffffff,    2LL, true },
   { (std::int64_t)0,                     0x7fffffffLL, true },
   { (std::int64_t)1,                     0x7fffffffLL, true },
   { (std::int64_t)2,                     0x7fffffffLL, true },
   { (std::int64_t)0x7fffffff,            0x7fffffffLL, true },
   { (std::int64_t)0x80000000,            0x7fffffffLL, true },
   { (std::int64_t)0xffffffff,            0x7fffffffLL, true },
   { (std::int64_t)0x100000000,           0x7fffffffLL, true },
   { (std::int64_t)0x200000000,           0x7fffffffLL, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffffLL, true },
   { (std::int64_t)0x8000000000000000,    0x7fffffffLL, true },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffffLL, true },
   { (std::int64_t)0,                     0x80000000LL, true },
   { (std::int64_t)1,                     0x80000000LL, true },
   { (std::int64_t)2,                     0x80000000LL, true },
   { (std::int64_t)0x7fffffff,            0x80000000LL, true },
   { (std::int64_t)0x80000000,            0x80000000LL, true },
   { (std::int64_t)0xffffffff,            0x80000000LL, true },
   { (std::int64_t)0x100000000,           0x80000000LL, true },
   { (std::int64_t)0x200000000,           0x80000000LL, true },
   { (std::int64_t)0x7fffffffffffffff,    0x80000000LL, true },
   { (std::int64_t)0x8000000000000000,    0x80000000LL, true },
   { (std::int64_t)0xffffffffffffffff,    0x80000000LL, true },
   { (std::int64_t)0,                     0xffffffffLL, true },
   { (std::int64_t)1,                     0xffffffffLL, true },
   { (std::int64_t)2,                     0xffffffffLL, true },
   { (std::int64_t)0x7fffffff,            0xffffffffLL, true },
   { (std::int64_t)0x80000000,            0xffffffffLL, true },
   { (std::int64_t)0xffffffff,            0xffffffffLL, true },
   { (std::int64_t)0x100000000,           0xffffffffLL, true },
   { (std::int64_t)0x200000000,           0xffffffffLL, true },
   { (std::int64_t)0x7fffffffffffffff,    0xffffffffLL, true },
   { (std::int64_t)0x8000000000000000,    0xffffffffLL, true },
   { (std::int64_t)0xffffffffffffffff,    0xffffffffLL, true },
   { (std::int64_t)0,                     0x100000000LL, true },
   { (std::int64_t)1,                     0x100000000LL, true },
   { (std::int64_t)2,                     0x100000000LL, true },
   { (std::int64_t)0x7fffffff,            0x100000000LL, true },
   { (std::int64_t)0x80000000,            0x100000000LL, true },
   { (std::int64_t)0xffffffff,            0x100000000LL, true },
   { (std::int64_t)0x100000000,           0x100000000LL, true },
   { (std::int64_t)0x200000000,           0x100000000LL, true },
   { (std::int64_t)0x7fffffffffffffff,    0x100000000LL, true },
   { (std::int64_t)0x8000000000000000,    0x100000000LL, true },
   { (std::int64_t)0xffffffffffffffff,    0x100000000LL, true },
   { (std::int64_t)0,                     0x200000000LL, true },
   { (std::int64_t)1,                     0x200000000LL, true },
   { (std::int64_t)2,                     0x200000000LL, true },
   { (std::int64_t)0x7fffffff,            0x200000000LL, true },
   { (std::int64_t)0x80000000,            0x200000000LL, true },
   { (std::int64_t)0xffffffff,            0x200000000LL, true },
   { (std::int64_t)0x100000000,           0x200000000LL, true },
   { (std::int64_t)0x200000000,           0x200000000LL, true },
   { (std::int64_t)0x7fffffffffffffff,    0x200000000LL, true },
   { (std::int64_t)0x8000000000000000,    0x200000000LL, true },
   { (std::int64_t)0xffffffffffffffff,    0x200000000LL, true },
   { (std::int64_t)0,                     0x7fffffffffffffffLL, true },
   { (std::int64_t)1,                     0x7fffffffffffffffLL, true },
   { (std::int64_t)2,                     0x7fffffffffffffffLL, true },
   { (std::int64_t)0x7fffffff,            0x7fffffffffffffffLL, true },
   { (std::int64_t)0x80000000,            0x7fffffffffffffffLL, true },
   { (std::int64_t)0xffffffff,            0x7fffffffffffffffLL, true },
   { (std::int64_t)0x100000000,           0x7fffffffffffffffLL, true },
   { (std::int64_t)0x200000000,           0x7fffffffffffffffLL, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffffffffffffLL, true },
   { (std::int64_t)0x8000000000000000,    0x7fffffffffffffffLL, true },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffffffffffffLL, true },
   { (std::int64_t)0,                     (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)1,                     (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)2,                     (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0x7fffffff,            (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0x80000000,            (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0xffffffff,            (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0x100000000,           (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0x200000000,           (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0x7fffffffffffffff,    (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0x8000000000000000,    (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0xffffffffffffffff,    (std::int64_t)0x8000000000000000, true },
   { (std::int64_t)0,                     (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)1,                     (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)2,                     (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)0x7fffffff,            (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)0x80000000,            (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)0xffffffff,            (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)0x100000000,           (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)0x200000000,           (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    (std::int64_t)0xffffffffffffffff, true },
   { (std::int64_t)0x8000000000000000,    (std::int64_t)0xffffffffffffffff, false },
   { (std::int64_t)0xffffffffffffffff,    (std::int64_t)0xffffffffffffffff, true },
};

template<> TestVector< std::int64_t, std::int64_t, OpType::Div >::TestVector() : current(0)
{
    this->test_cases = int64_int64;
    this->count = COUNTOF(int64_int64);
}

static const TestCase< std::int64_t, std::int32_t, OpType::Div > int64_int32[] =
{
   { (std::int64_t)0,                     0, false },
   { (std::int64_t)1,                     0, false },
   { (std::int64_t)2,                     0, false },
   { (std::int64_t)0x7fffffff,            0, false },
   { (std::int64_t)0x80000000,            0, false },
   { (std::int64_t)0xffffffff,            0, false },
   { (std::int64_t)0x100000000,           0, false },
   { (std::int64_t)0x200000000,           0, false },
   { (std::int64_t)0x7fffffffffffffff,    0, false },
   { (std::int64_t)0x8000000000000000,    0, false },
   { (std::int64_t)0xffffffffffffffff,    0, false },
   { (std::int64_t)0,                     1, true },
   { (std::int64_t)1,                     1, true },
   { (std::int64_t)2,                     1, true },
   { (std::int64_t)0x7fffffff,            1, true },
   { (std::int64_t)0x80000000,            1, true },
   { (std::int64_t)0xffffffff,            1, true },
   { (std::int64_t)0x100000000,           1, true },
   { (std::int64_t)0x200000000,           1, true },
   { (std::int64_t)0x7fffffffffffffff,    1, true },
   { (std::int64_t)0x8000000000000000,    1, true },
   { (std::int64_t)0xffffffffffffffff,    1, true },
   { (std::int64_t)0,                     2, true },
   { (std::int64_t)1,                     2, true },
   { (std::int64_t)2,                     2, true },
   { (std::int64_t)0x7fffffff,            2, true },
   { (std::int64_t)0x80000000,            2, true },
   { (std::int64_t)0xffffffff,            2, true },
   { (std::int64_t)0x100000000,           2, true },
   { (std::int64_t)0x200000000,           2, true },
   { (std::int64_t)0x7fffffffffffffff,    2, true },
   { (std::int64_t)0x8000000000000000,    2, true },
   { (std::int64_t)0xffffffffffffffff,    2, true },
   { (std::int64_t)0,                     0x7fffffff, true },
   { (std::int64_t)1,                     0x7fffffff, true },
   { (std::int64_t)2,                     0x7fffffff, true },
   { (std::int64_t)0x7fffffff,            0x7fffffff, true },
   { (std::int64_t)0x80000000,            0x7fffffff, true },
   { (std::int64_t)0xffffffff,            0x7fffffff, true },
   { (std::int64_t)0x100000000,           0x7fffffff, true },
   { (std::int64_t)0x200000000,           0x7fffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0x8000000000000000,    0x7fffffff, true },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0,                     (std::int32_t)0x80000000, true },
   { (std::int64_t)1,                     (std::int32_t)0x80000000, true },
   { (std::int64_t)2,                     (std::int32_t)0x80000000, true },
   { (std::int64_t)0x7fffffff,            (std::int32_t)0x80000000, true },
   { (std::int64_t)0x80000000,            (std::int32_t)0x80000000, true },
   { (std::int64_t)0xffffffff,            (std::int32_t)0x80000000, true },
   { (std::int64_t)0x100000000,           (std::int32_t)0x80000000, true },
   { (std::int64_t)0x200000000,           (std::int32_t)0x80000000, true },
   { (std::int64_t)0x7fffffffffffffff,    (std::int32_t)0x80000000, true },
   { (std::int64_t)0x8000000000000000,    (std::int32_t)0x80000000, true },
   { (std::int64_t)0xffffffffffffffff,    (std::int32_t)0x80000000, true },
   { (std::int64_t)0,                     (std::int32_t)0xffffffff, true },
   { (std::int64_t)1,                     (std::int32_t)0xffffffff, true },
   { (std::int64_t)2,                     (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x7fffffff,            (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x80000000,            (std::int32_t)0xffffffff, true },
   { (std::int64_t)0xffffffff,            (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x100000000,           (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x200000000,           (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x8000000000000000,    (std::int32_t)0xffffffff, false },
   { (std::int64_t)0xffffffffffffffff,    (std::int32_t)0xffffffff, true },
};

template<> TestVector< std::int64_t, std::int32_t, OpType::Div >::TestVector() : current(0)
{
    this->test_cases = int64_int32;
    this->count = COUNTOF(int64_int32);
}

static const TestCase< std::int64_t, std::int32_t, OpType::Div2 > int64_int32_2[] =
{
   { (std::int64_t)0,                     0, false },
   { (std::int64_t)1,                     0, false },
   { (std::int64_t)2,                     0, false },
   { (std::int64_t)0x7fffffff,            0, false },
   { (std::int64_t)0x80000000,            0, false },
   { (std::int64_t)0xffffffff,            0, false },
   { (std::int64_t)0x100000000,           0, false },
   { (std::int64_t)0x200000000,           0, false },
   { (std::int64_t)0x7fffffffffffffff,    0, false },
   { (std::int64_t)0x8000000000000000,    0, false },
   { (std::int64_t)0xffffffffffffffff,    0, false },
   { (std::int64_t)0,                     1, true },
   { (std::int64_t)1,                     1, true },
   { (std::int64_t)2,                     1, true },
   { (std::int64_t)0x7fffffff,            1, true },
   { (std::int64_t)0x80000000,            1, false },
   { (std::int64_t)0xffffffff,            1, false },
   { (std::int64_t)0x100000000,           1, false },
   { (std::int64_t)0x200000000,           1, false },
   { (std::int64_t)0x7fffffffffffffff,    1, false },
   { (std::int64_t)0x8000000000000000,    1, false },
   { (std::int64_t)0xffffffffffffffff,    1, true },
   { (std::int64_t)0,                     2, true },
   { (std::int64_t)1,                     2, true },
   { (std::int64_t)2,                     2, true },
   { (std::int64_t)0x7fffffff,            2, true },
   { (std::int64_t)0x80000000,            2, true },
   { (std::int64_t)0xffffffff,            2, true },
   { (std::int64_t)0x100000000,           2, false },
   { (std::int64_t)0x200000000,           2, false },
   { (std::int64_t)0x7fffffffffffffff,    2, false },
   { (std::int64_t)0x8000000000000000,    2, false },
   { (std::int64_t)0xffffffffffffffff,    2, true },
   { (std::int64_t)0,                     0x7fffffff, true },
   { (std::int64_t)1,                     0x7fffffff, true },
   { (std::int64_t)2,                     0x7fffffff, true },
   { (std::int64_t)0x7fffffff,            0x7fffffff, true },
   { (std::int64_t)0x80000000,            0x7fffffff, true },
   { (std::int64_t)0xffffffff,            0x7fffffff, true },
   { (std::int64_t)0x100000000,           0x7fffffff, true },
   { (std::int64_t)0x200000000,           0x7fffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffff, false },
   { (std::int64_t)0x8000000000000000,    0x7fffffff, false },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0,                     (std::int32_t)0x80000000, true },
   { (std::int64_t)1,                     (std::int32_t)0x80000000, true },
   { (std::int64_t)2,                     (std::int32_t)0x80000000, true },
   { (std::int64_t)0x7fffffff,            (std::int32_t)0x80000000, true },
   { (std::int64_t)0x80000000,            (std::int32_t)0x80000000, true },
   { (std::int64_t)0xffffffff,            (std::int32_t)0x80000000, true },
   { (std::int64_t)0x100000000,           (std::int32_t)0x80000000, true },
   { (std::int64_t)0x200000000,           (std::int32_t)0x80000000, true },
   { (std::int64_t)0x7fffffffffffffff,    (std::int32_t)0x80000000, false },
   { (std::int64_t)0x8000000000000000,    (std::int32_t)0x80000000, false },
   { (std::int64_t)0xffffffffffffffff,    (std::int32_t)0x80000000, true },
   { (std::int64_t)0,                     (std::int32_t)0xffffffff, true },
   { (std::int64_t)1,                     (std::int32_t)0xffffffff, true },
   { (std::int64_t)2,                     (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x7fffffff,            (std::int32_t)0xffffffff, true },
   { (std::int64_t)0x80000000,            (std::int32_t)0xffffffff, true },
   { (std::int64_t)0xffffffff,            (std::int32_t)0xffffffff, false },
   { (std::int64_t)0x100000000,           (std::int32_t)0xffffffff, false },
   { (std::int64_t)0x200000000,           (std::int32_t)0xffffffff, false },
   { (std::int64_t)0x7fffffffffffffff,    (std::int32_t)0xffffffff, false },
   { (std::int64_t)0x8000000000000000,    (std::int32_t)0xffffffff, false },
   { (std::int64_t)0xffffffffffffffff,    (std::int32_t)0xffffffff, true },
};

template<> TestVector< std::int64_t, std::int32_t, OpType::Div2 >::TestVector() : current(0)
{
    this->test_cases = int64_int32_2;
    this->count = COUNTOF(int64_int32_2);
}

static const TestCase< std::int64_t, std::uint64_t, OpType::Div > int64_uint64[] =
{
   { (std::int64_t)0,                     0, false },
   { (std::int64_t)1,                     0, false },
   { (std::int64_t)2,                     0, false },
   { (std::int64_t)0x7fffffff,            0, false },
   { (std::int64_t)0x80000000,            0, false },
   { (std::int64_t)0xffffffff,            0, false },
   { (std::int64_t)0x100000000,           0, false },
   { (std::int64_t)0x200000000,           0, false },
   { (std::int64_t)0x7fffffffffffffff,    0, false },
   { (std::int64_t)0x8000000000000000,    0, false },
   { (std::int64_t)0xffffffffffffffff,    0, false },
   { (std::int64_t)0,                     1, true },
   { (std::int64_t)1,                     1, true },
   { (std::int64_t)2,                     1, true },
   { (std::int64_t)0x7fffffff,            1, true },
   { (std::int64_t)0x80000000,            1, true },
   { (std::int64_t)0xffffffff,            1, true },
   { (std::int64_t)0x100000000,           1, true },
   { (std::int64_t)0x200000000,           1, true },
   { (std::int64_t)0x7fffffffffffffff,    1, true },
   { (std::int64_t)0x8000000000000000,    1, true },
   { (std::int64_t)0xffffffffffffffff,    1, true },
   { (std::int64_t)0,                     2, true },
   { (std::int64_t)1,                     2, true },
   { (std::int64_t)2,                     2, true },
   { (std::int64_t)0x7fffffff,            2, true },
   { (std::int64_t)0x80000000,            2, true },
   { (std::int64_t)0xffffffff,            2, true },
   { (std::int64_t)0x100000000,           2, true },
   { (std::int64_t)0x200000000,           2, true },
   { (std::int64_t)0x7fffffffffffffff,    2, true },
   { (std::int64_t)0x8000000000000000,    2, true },
   { (std::int64_t)0xffffffffffffffff,    2, true },
   { (std::int64_t)0,                     0x7fffffff, true },
   { (std::int64_t)1,                     0x7fffffff, true },
   { (std::int64_t)2,                     0x7fffffff, true },
   { (std::int64_t)0x7fffffff,            0x7fffffff, true },
   { (std::int64_t)0x80000000,            0x7fffffff, true },
   { (std::int64_t)0xffffffff,            0x7fffffff, true },
   { (std::int64_t)0x100000000,           0x7fffffff, true },
   { (std::int64_t)0x200000000,           0x7fffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0x8000000000000000,    0x7fffffff, true },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0,                     0x80000000, true },
   { (std::int64_t)1,                     0x80000000, true },
   { (std::int64_t)2,                     0x80000000, true },
   { (std::int64_t)0x7fffffff,            0x80000000, true },
   { (std::int64_t)0x80000000,            0x80000000, true },
   { (std::int64_t)0xffffffff,            0x80000000, true },
   { (std::int64_t)0x100000000,           0x80000000, true },
   { (std::int64_t)0x200000000,           0x80000000, true },
   { (std::int64_t)0x7fffffffffffffff,    0x80000000, true },
   { (std::int64_t)0x8000000000000000,    0x80000000, true },
   { (std::int64_t)0xffffffffffffffff,    0x80000000, true },
   { (std::int64_t)0,                     0xffffffff, true },
   { (std::int64_t)1,                     0xffffffff, true },
   { (std::int64_t)2,                     0xffffffff, true },
   { (std::int64_t)0x7fffffff,            0xffffffff, true },
   { (std::int64_t)0x80000000,            0xffffffff, true },
   { (std::int64_t)0xffffffff,            0xffffffff, true },
   { (std::int64_t)0x100000000,           0xffffffff, true },
   { (std::int64_t)0x200000000,           0xffffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0xffffffff, true },
   { (std::int64_t)0x8000000000000000,    0xffffffff, true },
   { (std::int64_t)0xffffffffffffffff,    0xffffffff, true },
   { (std::int64_t)0,                     0x100000000, true },
   { (std::int64_t)1,                     0x100000000, true },
   { (std::int64_t)2,                     0x100000000, true },
   { (std::int64_t)0x7fffffff,            0x100000000, true },
   { (std::int64_t)0x80000000,            0x100000000, true },
   { (std::int64_t)0xffffffff,            0x100000000, true },
   { (std::int64_t)0x100000000,           0x100000000, true },
   { (std::int64_t)0x200000000,           0x100000000, true },
   { (std::int64_t)0x7fffffffffffffff,    0x100000000, true },
   { (std::int64_t)0x8000000000000000,    0x100000000, true },
   { (std::int64_t)0xffffffffffffffff,    0x100000000, true },
   { (std::int64_t)0,                     0x200000000, true },
   { (std::int64_t)1,                     0x200000000, true },
   { (std::int64_t)2,                     0x200000000, true },
   { (std::int64_t)0x7fffffff,            0x200000000, true },
   { (std::int64_t)0x80000000,            0x200000000, true },
   { (std::int64_t)0xffffffff,            0x200000000, true },
   { (std::int64_t)0x100000000,           0x200000000, true },
   { (std::int64_t)0x200000000,           0x200000000, true },
   { (std::int64_t)0x7fffffffffffffff,    0x200000000, true },
   { (std::int64_t)0x8000000000000000,    0x200000000, true },
   { (std::int64_t)0xffffffffffffffff,    0x200000000, true },
   { (std::int64_t)0,                     0x7fffffffffffffff, true },
   { (std::int64_t)1,                     0x7fffffffffffffff, true },
   { (std::int64_t)2,                     0x7fffffffffffffff, true },
   { (std::int64_t)0x7fffffff,            0x7fffffffffffffff, true },
   { (std::int64_t)0x80000000,            0x7fffffffffffffff, true },
   { (std::int64_t)0xffffffff,            0x7fffffffffffffff, true },
   { (std::int64_t)0x100000000,           0x7fffffffffffffff, true },
   { (std::int64_t)0x200000000,           0x7fffffffffffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffffffffffff, true },
   { (std::int64_t)0x8000000000000000,    0x7fffffffffffffff, true },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffffffffffff, true },
   { (std::int64_t)0,                     0x8000000000000000, true },
   { (std::int64_t)1,                     0x8000000000000000, true },
   { (std::int64_t)2,                     0x8000000000000000, true },
   { (std::int64_t)0x7fffffff,            0x8000000000000000, true },
   { (std::int64_t)0x80000000,            0x8000000000000000, true },
   { (std::int64_t)0xffffffff,            0x8000000000000000, true },
   { (std::int64_t)0x100000000,           0x8000000000000000, true },
   { (std::int64_t)0x200000000,           0x8000000000000000, true },
   { (std::int64_t)0x7fffffffffffffff,    0x8000000000000000, true },
   { (std::int64_t)0x8000000000000000,    0x8000000000000000, true },
   { (std::int64_t)0xffffffffffffffff,    0x8000000000000000, true },
   { (std::int64_t)0,                     0xffffffffffffffff, true },
   { (std::int64_t)1,                     0xffffffffffffffff, true },
   { (std::int64_t)2,                     0xffffffffffffffff, true },
   { (std::int64_t)0x7fffffff,            0xffffffffffffffff, true },
   { (std::int64_t)0x80000000,            0xffffffffffffffff, true },
   { (std::int64_t)0xffffffff,            0xffffffffffffffff, true },
   { (std::int64_t)0x100000000,           0xffffffffffffffff, true },
   { (std::int64_t)0x200000000,           0xffffffffffffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0xffffffffffffffff, true },
   { (std::int64_t)0x8000000000000000,    0xffffffffffffffff, true },
   { (std::int64_t)0xffffffffffffffff,    0xffffffffffffffff, true },
};

template<> TestVector< std::int64_t, std::uint64_t, OpType::Div >::TestVector() : current(0)
{
    this->test_cases = int64_uint64;
    this->count = COUNTOF(int64_uint64);
}

static const TestCase< std::uint64_t, std::int64_t, OpType::Div2 > uint64_int64_2[] =
{
   {0,                  0,                  false },
   {0,                  1,                  false },
   {0,                  2,                  false },
   {0,                  0x7fffffff,         false },
   {0,                  0x80000000,         false },
   {0,                  0xffffffff,         false },
   {0,                  0x100000000,        false },
   {0,                  0x200000000,        false },
   {0,                  0x7fffffffffffffff, false },
   {0,                  (std::int64_t)0x8000000000000000, false },
   {0,                  (std::int64_t)0xffffffffffffffff, false },
   {1,                  0,                  true },
   {1,                  1,                  true },
   {1,                  2,                  true },
   {1,                  0x7fffffff,         true },
   {1,                  0x80000000,         true },
   {1,                  0xffffffff,         true },
   {1,                  0x100000000,        true },
   {1,                  0x200000000,        true },
   {1,                  0x7fffffffffffffff, true },
   {1,                  (std::int64_t)0x8000000000000000, false },
   {1,                  (std::int64_t)0xffffffffffffffff, false },
   {2,                  0,                  true },
   {2,                  1,                  true },
   {2,                  2,                  true },
   {2,                  0x7fffffff,         true },
   {2,                  0x80000000,         true },
   {2,                  0xffffffff,         true },
   {2,                  0x100000000,        true },
   {2,                  0x200000000,        true },
   {2,                  0x7fffffffffffffff, true },
   {2,                  (std::int64_t)0x8000000000000000, false },
   {2,                  (std::int64_t)0xffffffffffffffff, true },
   {0x7fffffff,         0,                  true },
   {0x7fffffff,         1,                  true },
   {0x7fffffff,         2,                  true },
   {0x7fffffff,         0x7fffffff,         true },
   {0x7fffffff,         0x80000000,         true },
   {0x7fffffff,         0xffffffff,         true },
   {0x7fffffff,         0x100000000,        true },
   {0x7fffffff,         0x200000000,        true },
   {0x7fffffff,         0x7fffffffffffffff, true },
   {0x7fffffff,         (std::int64_t)0x8000000000000000, false },
   {0x7fffffff,         (std::int64_t)0xffffffffffffffff, true },
   {0x80000000,         0,                  true },
   {0x80000000,         1,                  true },
   {0x80000000,         2,                  true },
   {0x80000000,         0x7fffffff,         true },
   {0x80000000,         0x80000000,         true },
   {0x80000000,         0xffffffff,         true },
   {0x80000000,         0x100000000,        true },
   {0x80000000,         0x200000000,        true },
   {0x80000000,         0x7fffffffffffffff, true },
   {0x80000000,         (std::int64_t)0x8000000000000000, false },
   {0x80000000,         (std::int64_t)0xffffffffffffffff, true },
   {0xffffffff,         0,                  true },
   {0xffffffff,         1,                  true },
   {0xffffffff,         2,                  true },
   {0xffffffff,         0x7fffffff,         true },
   {0xffffffff,         0x80000000,         true },
   {0xffffffff,         0xffffffff,         true },
   {0xffffffff,         0x100000000,        true },
   {0xffffffff,         0x200000000,        true },
   {0xffffffff,         0x7fffffffffffffff, true },
   {0xffffffff,         (std::int64_t)0x8000000000000000, false },
   {0xffffffff,         (std::int64_t)0xffffffffffffffff, true },
   {0x100000000,        0,                  true },
   {0x100000000,        1,                  true },
   {0x100000000,        2,                  true },
   {0x100000000,        0x7fffffff,         true },
   {0x100000000,        0x80000000,         true },
   {0x100000000,        0xffffffff,         true },
   {0x100000000,        0x100000000,        true },
   {0x100000000,        0x200000000,        true },
   {0x100000000,        0x7fffffffffffffff, true },
   {0x100000000,        (std::int64_t)0x8000000000000000, false },
   {0x100000000,        (std::int64_t)0xffffffffffffffff, true },
   {0x200000000,        0,                  true },
   {0x200000000,        1,                  true },
   {0x200000000,        2,                  true },
   {0x200000000,        0x7fffffff,         true },
   {0x200000000,        0x80000000,         true },
   {0x200000000,        0xffffffff,         true },
   {0x200000000,        0x100000000,        true },
   {0x200000000,        0x200000000,        true },
   {0x200000000,        0x7fffffffffffffff, true },
   {0x200000000,        (std::int64_t)0x8000000000000000, false },
   {0x200000000,        (std::int64_t)0xffffffffffffffff, true },
   {0x7fffffffffffffff, 0,                  true },
   {0x7fffffffffffffff, 1,                  true },
   {0x7fffffffffffffff, 2,                  true },
   {0x7fffffffffffffff, 0x7fffffff,         true },
   {0x7fffffffffffffff, 0x80000000,         true },
   {0x7fffffffffffffff, 0xffffffff,         true },
   {0x7fffffffffffffff, 0x100000000,        true },
   {0x7fffffffffffffff, 0x200000000,        true },
   {0x7fffffffffffffff, 0x7fffffffffffffff, true },
   {0x7fffffffffffffff, (std::int64_t)0x8000000000000000, false },
   {0x7fffffffffffffff, (std::int64_t)0xffffffffffffffff, true },
   {0x8000000000000000, 0,                  true },
   {0x8000000000000000, 1,                  true },
   {0x8000000000000000, 2,                  true },
   {0x8000000000000000, 0x7fffffff,         true },
   {0x8000000000000000, 0x80000000,         true },
   {0x8000000000000000, 0xffffffff,         true },
   {0x8000000000000000, 0x100000000,        true },
   {0x8000000000000000, 0x200000000,        true },
   {0x8000000000000000, 0x7fffffffffffffff, true },
   {0x8000000000000000, (std::int64_t)0x8000000000000000, false },
   {0x8000000000000000, (std::int64_t)0xffffffffffffffff, true },
   {0xffffffffffffffff, 0,                  true },
   {0xffffffffffffffff, 1,                  true },
   {0xffffffffffffffff, 2,                  true },
   {0xffffffffffffffff, 0x7fffffff,         true },
   {0xffffffffffffffff, 0x80000000,         true },
   {0xffffffffffffffff, 0xffffffff,         true },
   {0xffffffffffffffff, 0x100000000,        true },
   {0xffffffffffffffff, 0x200000000,        true },
   {0xffffffffffffffff, 0x7fffffffffffffff, true },
   {0xffffffffffffffff, (std::int64_t)0x8000000000000000, true },
   {0xffffffffffffffff, (std::int64_t)0xffffffffffffffff, true },
};

template<> TestVector< std::uint64_t, std::int64_t, OpType::Div2 >::TestVector() : current(0)
{
    this->test_cases = uint64_int64_2;
    this->count = COUNTOF(uint64_int64_2);
}

static const TestCase< std::int64_t, std::uint32_t, OpType::Div > int64_uint32[] =
{
   { (std::int64_t)0,                     0, false },
   { (std::int64_t)1,                     0, false },
   { (std::int64_t)2,                     0, false },
   { (std::int64_t)0x7fffffff,            0, false },
   { (std::int64_t)0x80000000,            0, false },
   { (std::int64_t)0xffffffff,            0, false },
   { (std::int64_t)0x100000000,           0, false },
   { (std::int64_t)0x200000000,           0, false },
   { (std::int64_t)0x7fffffffffffffff,    0, false },
   { (std::int64_t)0x8000000000000000,    0, false },
   { (std::int64_t)0xffffffffffffffff,    0, false },
   { (std::int64_t)0,                     1, true },
   { (std::int64_t)1,                     1, true },
   { (std::int64_t)2,                     1, true },
   { (std::int64_t)0x7fffffff,            1, true },
   { (std::int64_t)0x80000000,            1, true },
   { (std::int64_t)0xffffffff,            1, true },
   { (std::int64_t)0x100000000,           1, true },
   { (std::int64_t)0x200000000,           1, true },
   { (std::int64_t)0x7fffffffffffffff,    1, true },
   { (std::int64_t)0x8000000000000000,    1, true },
   { (std::int64_t)0xffffffffffffffff,    1, true },
   { (std::int64_t)0,                     2, true },
   { (std::int64_t)1,                     2, true },
   { (std::int64_t)2,                     2, true },
   { (std::int64_t)0x7fffffff,            2, true },
   { (std::int64_t)0x80000000,            2, true },
   { (std::int64_t)0xffffffff,            2, true },
   { (std::int64_t)0x100000000,           2, true },
   { (std::int64_t)0x200000000,           2, true },
   { (std::int64_t)0x7fffffffffffffff,    2, true },
   { (std::int64_t)0x8000000000000000,    2, true },
   { (std::int64_t)0xffffffffffffffff,    2, true },
   { (std::int64_t)0,                     0x7fffffff, true },
   { (std::int64_t)1,                     0x7fffffff, true },
   { (std::int64_t)2,                     0x7fffffff, true },
   { (std::int64_t)0x7fffffff,            0x7fffffff, true },
   { (std::int64_t)0x80000000,            0x7fffffff, true },
   { (std::int64_t)0xffffffff,            0x7fffffff, true },
   { (std::int64_t)0x100000000,           0x7fffffff, true },
   { (std::int64_t)0x200000000,           0x7fffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0x8000000000000000,    0x7fffffff, true },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0,                     0x80000000, true },
   { (std::int64_t)1,                     0x80000000, true },
   { (std::int64_t)2,                     0x80000000, true },
   { (std::int64_t)0x7fffffff,            0x80000000, true },
   { (std::int64_t)0x80000000,            0x80000000, true },
   { (std::int64_t)0xffffffff,            0x80000000, true },
   { (std::int64_t)0x100000000,           0x80000000, true },
   { (std::int64_t)0x200000000,           0x80000000, true },
   { (std::int64_t)0x7fffffffffffffff,    0x80000000, true },
   { (std::int64_t)0x8000000000000000,    0x80000000, true },
   { (std::int64_t)0xffffffffffffffff,    0x80000000, true },
   { (std::int64_t)0,                     0xffffffff, true },
   { (std::int64_t)1,                     0xffffffff, true },
   { (std::int64_t)2,                     0xffffffff, true },
   { (std::int64_t)0x7fffffff,            0xffffffff, true },
   { (std::int64_t)0x80000000,            0xffffffff, true },
   { (std::int64_t)0xffffffff,            0xffffffff, true },
   { (std::int64_t)0x100000000,           0xffffffff, true },
   { (std::int64_t)0x200000000,           0xffffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0xffffffff, true },
   { (std::int64_t)0x8000000000000000,    0xffffffff, true },
   { (std::int64_t)0xffffffffffffffff,    0xffffffff, true },
};

template<> TestVector< std::int64_t, std::uint32_t, OpType::Div >::TestVector() : current(0)
{
    this->test_cases = int64_uint32;
    this->count = COUNTOF(int64_uint32);
}

static const TestCase< std::int64_t, std::uint32_t, OpType::Div2 > int64_uint32_2[] =
{
   { (std::int64_t)0,                     0, false },
   { (std::int64_t)1,                     0, false },
   { (std::int64_t)2,                     0, false },
   { (std::int64_t)0x7fffffff,            0, false },
   { (std::int64_t)0x80000000,            0, false },
   { (std::int64_t)0xffffffff,            0, false },
   { (std::int64_t)0x100000000,           0, false },
   { (std::int64_t)0x200000000,           0, false },
   { (std::int64_t)0x7fffffffffffffff,    0, false },
   { (std::int64_t)0x8000000000000000,    0, false },
   { (std::int64_t)0xffffffffffffffff,    0, false },
   { (std::int64_t)0,                     1, true },
   { (std::int64_t)1,                     1, true },
   { (std::int64_t)2,                     1, true },
   { (std::int64_t)0x7fffffff,            1, true },
   { (std::int64_t)0x80000000,            1, true },
   { (std::int64_t)0xffffffff,            1, true },
   { (std::int64_t)0x100000000,           1, false },
   { (std::int64_t)0x200000000,           1, false },
   { (std::int64_t)0x7fffffffffffffff,    1, false },
   { (std::int64_t)0x8000000000000000,    1, false },
   { (std::int64_t)0xffffffffffffffff,    1, false },
   { (std::int64_t)0,                     2, true },
   { (std::int64_t)1,                     2, true },
   { (std::int64_t)2,                     2, true },
   { (std::int64_t)0x7fffffff,            2, true },
   { (std::int64_t)0x80000000,            2, true },
   { (std::int64_t)0xffffffff,            2, true },
   { (std::int64_t)0x100000000,           2, true },
   { (std::int64_t)0x200000000,           2, false },
   { (std::int64_t)0x7fffffffffffffff,    2, false },
   { (std::int64_t)0x8000000000000000,    2, false },
   { (std::int64_t)0xffffffffffffffff,    2, true },
   { (std::int64_t)0,                     0x7fffffff, true },
   { (std::int64_t)1,                     0x7fffffff, true },
   { (std::int64_t)2,                     0x7fffffff, true },
   { (std::int64_t)0x7fffffff,            0x7fffffff, true },
   { (std::int64_t)0x80000000,            0x7fffffff, true },
   { (std::int64_t)0xffffffff,            0x7fffffff, true },
   { (std::int64_t)0x100000000,           0x7fffffff, true },
   { (std::int64_t)0x200000000,           0x7fffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0x7fffffff, false },
   { (std::int64_t)0x8000000000000000,    0x7fffffff, false },
   { (std::int64_t)0xffffffffffffffff,    0x7fffffff, true },
   { (std::int64_t)0,                     0x80000000, true },
   { (std::int64_t)1,                     0x80000000, true },
   { (std::int64_t)2,                     0x80000000, true },
   { (std::int64_t)0x7fffffff,            0x80000000, true },
   { (std::int64_t)0x80000000,            0x80000000, true },
   { (std::int64_t)0xffffffff,            0x80000000, true },
   { (std::int64_t)0x100000000,           0x80000000, true },
   { (std::int64_t)0x200000000,           0x80000000, true },
   { (std::int64_t)0x7fffffffffffffff,    0x80000000, true },
   { (std::int64_t)0x8000000000000000,    0x80000000, false },
   { (std::int64_t)0xffffffffffffffff,    0x80000000, true },
   { (std::int64_t)0,                     0xffffffff, true },
   { (std::int64_t)1,                     0xffffffff, true },
   { (std::int64_t)2,                     0xffffffff, true },
   { (std::int64_t)0x7fffffff,            0xffffffff, true },
   { (std::int64_t)0x80000000,            0xffffffff, true },
   { (std::int64_t)0xffffffff,            0xffffffff, true },
   { (std::int64_t)0x100000000,           0xffffffff, true },
   { (std::int64_t)0x200000000,           0xffffffff, true },
   { (std::int64_t)0x7fffffffffffffff,    0xffffffff, true },
   { (std::int64_t)0x8000000000000000,    0xffffffff, false },
   { (std::int64_t)0xffffffffffffffff,    0xffffffff, true },
};

template<> TestVector< std::int64_t, std::uint32_t, OpType::Div2 >::TestVector() : current(0)
{
    this->test_cases = int64_uint32_2;
    this->count = COUNTOF(int64_uint32_2);
}

static const TestCase< std::uint32_t, std::uint64_t, OpType::Div > uint32_uint64[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0,                     0x80000000, true },
   { 1,                     0x80000000, true },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { 0x80000000,            0x80000000, true },
   { 0xffffffff,            0x80000000, true },
   { 0,                     0xffffffff, true },
   { 1,                     0xffffffff, true },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { 0x80000000,            0xffffffff, true },
   { 0xffffffff,            0xffffffff, true },
   { 0,                     0x100000000, true },
   { 1,                     0x100000000, true },
   { 2,                     0x100000000, true },
   { 0x7fffffff,            0x100000000, true },
   { 0x80000000,            0x100000000, true },
   { 0xffffffff,            0x100000000, true },
   { 0,                     0x200000000, true },
   { 1,                     0x200000000, true },
   { 2,                     0x200000000, true },
   { 0x7fffffff,            0x200000000, true },
   { 0x80000000,            0x200000000, true },
   { 0xffffffff,            0x200000000, true },
   { 0,                     0x7fffffffffffffff, true },
   { 1,                     0x7fffffffffffffff, true },
   { 2,                     0x7fffffffffffffff, true },
   { 0x7fffffff,            0x7fffffffffffffff, true },
   { 0x80000000,            0x7fffffffffffffff, true },
   { 0xffffffff,            0x7fffffffffffffff, true },
   { 0,                     0x8000000000000000, true },
   { 1,                     0x8000000000000000, true },
   { 2,                     0x8000000000000000, true },
   { 0x7fffffff,            0x8000000000000000, true },
   { 0x80000000,            0x8000000000000000, true },
   { 0xffffffff,            0x8000000000000000, true },
   { 0,                     0xffffffffffffffff, true },
   { 1,                     0xffffffffffffffff, true },
   { 2,                     0xffffffffffffffff, true },
   { 0x7fffffff,            0xffffffffffffffff, true },
   { 0x80000000,            0xffffffffffffffff, true },
   { 0xffffffff,            0xffffffffffffffff, true },
};

template<> TestVector< std::uint32_t, std::uint64_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint32_uint64;
    this->count = COUNTOF(uint32_uint64);
}

static const TestCase< std::uint32_t, std::uint32_t, OpType::Div > uint32_uint32[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0,                     0x80000000, true },
   { 1,                     0x80000000, true },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { 0x80000000,            0x80000000, true },
   { 0xffffffff,            0x80000000, true },
   { 0,                     0xffffffff, true },
   { 1,                     0xffffffff, true },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { 0x80000000,            0xffffffff, true },
   { 0xffffffff,            0xffffffff, true },
};

template<> TestVector< std::uint32_t, std::uint32_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint32_uint32;
    this->count = COUNTOF(uint32_uint32);
}

static const TestCase< std::uint32_t, std::int64_t, OpType::Div > uint32_int64[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0,                     0x80000000, true },
   { 1,                     0x80000000, true },
   { 2,                     0x80000000, true },
   { 0x7fffffff,            0x80000000, true },
   { 0x80000000,            0x80000000, true },
   { 0xffffffff,            0x80000000, true },
   { 0,                     0xffffffff, true },
   { 1,                     0xffffffff, true },
   { 2,                     0xffffffff, true },
   { 0x7fffffff,            0xffffffff, true },
   { 0x80000000,            0xffffffff, true },
   { 0xffffffff,            0xffffffff, true },
   { 0,                     0x100000000, true },
   { 1,                     0x100000000, true },
   { 2,                     0x100000000, true },
   { 0x7fffffff,            0x100000000, true },
   { 0x80000000,            0x100000000, true },
   { 0xffffffff,            0x100000000, true },
   { 0,                     0x200000000, true },
   { 1,                     0x200000000, true },
   { 2,                     0x200000000, true },
   { 0x7fffffff,            0x200000000, true },
   { 0x80000000,            0x200000000, true },
   { 0xffffffff,            0x200000000, true },
   { 0,                     0x7fffffffffffffff, true },
   { 1,                     0x7fffffffffffffff, true },
   { 2,                     0x7fffffffffffffff, true },
   { 0x7fffffff,            0x7fffffffffffffff, true },
   { 0x80000000,            0x7fffffffffffffff, true },
   { 0xffffffff,            0x7fffffffffffffff, true },
   { 0,                     (std::int64_t)0x8000000000000000, true },
   { 1,                     (std::int64_t)0x8000000000000000, true },
   { 2,                     (std::int64_t)0x8000000000000000, true },
   { 0x7fffffff,            (std::int64_t)0x8000000000000000, true },
   { 0x80000000,            (std::int64_t)0x8000000000000000, true },
   { 0xffffffff,            (std::int64_t)0x8000000000000000, true },
   { 0,                     (std::int64_t)0xffffffffffffffff, true },
   { 1,                     (std::int64_t)0xffffffffffffffff, false },
   { 2,                     (std::int64_t)0xffffffffffffffff, false },
   { 0x7fffffff,            (std::int64_t)0xffffffffffffffff, false },
   { 0x80000000,            (std::int64_t)0xffffffffffffffff, false },
   { 0xffffffff,            (std::int64_t)0xffffffffffffffff, false },
};

template<> TestVector< std::uint32_t, std::int64_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint32_int64;
    this->count = COUNTOF(uint32_int64);
}

static const TestCase< std::uint32_t, std::int32_t, OpType::Div > uint32_int32[] =
{
   { 0,                     0, false },
   { 1,                     0, false },
   { 2,                     0, false },
   { 0x7fffffff,            0, false },
   { 0x80000000,            0, false },
   { 0xffffffff,            0, false },
   { 0,                     1, true },
   { 1,                     1, true },
   { 2,                     1, true },
   { 0x7fffffff,            1, true },
   { 0x80000000,            1, true },
   { 0xffffffff,            1, true },
   { 0,                     2, true },
   { 1,                     2, true },
   { 2,                     2, true },
   { 0x7fffffff,            2, true },
   { 0x80000000,            2, true },
   { 0xffffffff,            2, true },
   { 0,                     0x7fffffff, true },
   { 1,                     0x7fffffff, true },
   { 2,                     0x7fffffff, true },
   { 0x7fffffff,            0x7fffffff, true },
   { 0x80000000,            0x7fffffff, true },
   { 0xffffffff,            0x7fffffff, true },
   { 0,                     (std::int32_t)0x80000000, true },
   { 1,                     (std::int32_t)0x80000000, true },
   { 2,                     (std::int32_t)0x80000000, true },
   { 0x7fffffff,            (std::int32_t)0x80000000, true },
   { 0x80000000,            (std::int32_t)0x80000000, false },
   { 0xffffffff,            (std::int32_t)0x80000000, false },
   { 0,                     (std::int32_t)0xffffffff, true },
   { 1,                     (std::int32_t)0xffffffff, false },
   { 2,                     (std::int32_t)0xffffffff, false },
   { 0x7fffffff,            (std::int32_t)0xffffffff, false },
   { 0x80000000,            (std::int32_t)0xffffffff, false },
   { 0xffffffff,            (std::int32_t)0xffffffff, false },
};

template<> TestVector< std::uint32_t, std::int32_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = uint32_int32;
    this->count = COUNTOF(uint32_int32);
}

static const TestCase< std::int32_t, std::uint64_t, OpType::Div > int32_uint64[] =
{
   { (std::int32_t)0,                     0, false },
   { (std::int32_t)1,                     0, false },
   { (std::int32_t)2,                     0, false },
   { (std::int32_t)0x7fffffff,            0, false },
   { (std::int32_t)0x80000000,            0, false },
   { (std::int32_t)0xffffffff,            0, false },
   { (std::int32_t)0,                     1, true },
   { (std::int32_t)1,                     1, true },
   { (std::int32_t)2,                     1, true },
   { (std::int32_t)0x7fffffff,            1, true },
   { (std::int32_t)0x80000000,            1, true },
   { (std::int32_t)0xffffffff,            1, true },
   { (std::int32_t)0,                     2, true },
   { (std::int32_t)1,                     2, true },
   { (std::int32_t)2,                     2, true },
   { (std::int32_t)0x7fffffff,            2, true },
   { (std::int32_t)0x80000000,            2, true },
   { (std::int32_t)0xffffffff,            2, true },
   { (std::int32_t)0,                     0x7fffffff, true },
   { (std::int32_t)1,                     0x7fffffff, true },
   { (std::int32_t)2,                     0x7fffffff, true },
   { (std::int32_t)0x7fffffff,            0x7fffffff, true },
   { (std::int32_t)0x80000000,            0x7fffffff, true },
   { (std::int32_t)0xffffffff,            0x7fffffff, true },
   { (std::int32_t)0,                     0x80000000, true },
   { (std::int32_t)1,                     0x80000000, true },
   { (std::int32_t)2,                     0x80000000, true },
   { (std::int32_t)0x7fffffff,            0x80000000, true },
   { (std::int32_t)0x80000000,            0x80000000, true },
   { (std::int32_t)0xffffffff,            0x80000000, true },
   { (std::int32_t)0,                     0xffffffff, true },
   { (std::int32_t)1,                     0xffffffff, true },
   { (std::int32_t)2,                     0xffffffff, true },
   { (std::int32_t)0x7fffffff,            0xffffffff, true },
   { (std::int32_t)0x80000000,            0xffffffff, true },
   { (std::int32_t)0xffffffff,            0xffffffff, true },
   { (std::int32_t)0,                     0x100000000, true },
   { (std::int32_t)1,                     0x100000000, true },
   { (std::int32_t)2,                     0x100000000, true },
   { (std::int32_t)0x7fffffff,            0x100000000, true },
   { (std::int32_t)0x80000000,            0x100000000, true },
   { (std::int32_t)0xffffffff,            0x100000000, true },
   { (std::int32_t)0,                     0x200000000, true },
   { (std::int32_t)1,                     0x200000000, true },
   { (std::int32_t)2,                     0x200000000, true },
   { (std::int32_t)0x7fffffff,            0x200000000, true },
   { (std::int32_t)0x80000000,            0x200000000, true },
   { (std::int32_t)0xffffffff,            0x200000000, true },
   { (std::int32_t)0,                     0x7fffffffffffffff, true },
   { (std::int32_t)1,                     0x7fffffffffffffff, true },
   { (std::int32_t)2,                     0x7fffffffffffffff, true },
   { (std::int32_t)0x7fffffff,            0x7fffffffffffffff, true },
   { (std::int32_t)0x80000000,            0x7fffffffffffffff, true },
   { (std::int32_t)0xffffffff,            0x7fffffffffffffff, true },
   { (std::int32_t)0,                     0x8000000000000000, true },
   { (std::int32_t)1,                     0x8000000000000000, true },
   { (std::int32_t)2,                     0x8000000000000000, true },
   { (std::int32_t)0x7fffffff,            0x8000000000000000, true },
   { (std::int32_t)0x80000000,            0x8000000000000000, true },
   { (std::int32_t)0xffffffff,            0x8000000000000000, true },
   { (std::int32_t)0,                     0xffffffffffffffff, true },
   { (std::int32_t)1,                     0xffffffffffffffff, true },
   { (std::int32_t)2,                     0xffffffffffffffff, true },
   { (std::int32_t)0x7fffffff,            0xffffffffffffffff, true },
   { (std::int32_t)0x80000000,            0xffffffffffffffff, true },
   { (std::int32_t)0xffffffff,            0xffffffffffffffff, true },
};

template<> TestVector< std::int32_t, std::uint64_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = int32_uint64;
    this->count = COUNTOF(int32_uint64);
}

static const TestCase< std::int32_t, std::uint32_t, OpType::Div > int32_uint32[] =
{
   { (std::int32_t)0,                     0, false },
   { (std::int32_t)1,                     0, false },
   { (std::int32_t)2,                     0, false },
   { (std::int32_t)0x7fffffff,            0, false },
   { (std::int32_t)0x80000000,            0, false },
   { (std::int32_t)0xffffffff,            0, false },
   { (std::int32_t)0,                     1, true },
   { (std::int32_t)1,                     1, true },
   { (std::int32_t)2,                     1, true },
   { (std::int32_t)0x7fffffff,            1, true },
   { (std::int32_t)0x80000000,            1, true },
   { (std::int32_t)0xffffffff,            1, true },
   { (std::int32_t)0,                     2, true },
   { (std::int32_t)1,                     2, true },
   { (std::int32_t)2,                     2, true },
   { (std::int32_t)0x7fffffff,            2, true },
   { (std::int32_t)0x80000000,            2, true },
   { (std::int32_t)0xffffffff,            2, true },
   { (std::int32_t)0,                     0x7fffffff, true },
   { (std::int32_t)1,                     0x7fffffff, true },
   { (std::int32_t)2,                     0x7fffffff, true },
   { (std::int32_t)0x7fffffff,            0x7fffffff, true },
   { (std::int32_t)0x80000000,            0x7fffffff, true },
   { (std::int32_t)0xffffffff,            0x7fffffff, true },
   { (std::int32_t)0,                     0x80000000, true },
   { (std::int32_t)1,                     0x80000000, true },
   { (std::int32_t)2,                     0x80000000, true },
   { (std::int32_t)0x7fffffff,            0x80000000, true },
   { (std::int32_t)0x80000000,            0x80000000, true },
   { (std::int32_t)0xffffffff,            0x80000000, true },
   { (std::int32_t)0,                     0xffffffff, true },
   { (std::int32_t)1,                     0xffffffff, true },
   { (std::int32_t)2,                     0xffffffff, true },
   { (std::int32_t)0x7fffffff,            0xffffffff, true },
   { (std::int32_t)0x80000000,            0xffffffff, true },
   { (std::int32_t)0xffffffff,            0xffffffff, true },
};

template<> TestVector< std::int32_t, std::uint32_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = int32_uint32;
    this->count = COUNTOF(int32_uint32);
}

static const TestCase< std::int32_t, std::int64_t, OpType::Div > int32_int64[] =
{
   { (std::int32_t)0,                     0, false },
   { (std::int32_t)1,                     0, false },
   { (std::int32_t)2,                     0, false },
   { (std::int32_t)0x7fffffff,            0, false },
   { (std::int32_t)0x80000000,            0, false },
   { (std::int32_t)0xffffffff,            0, false },
   { (std::int32_t)0,                     1, true },
   { (std::int32_t)1,                     1, true },
   { (std::int32_t)2,                     1, true },
   { (std::int32_t)0x7fffffff,            1, true },
   { (std::int32_t)0x80000000,            1, true },
   { (std::int32_t)0xffffffff,            1, true },
   { (std::int32_t)0,                     2, true },
   { (std::int32_t)1,                     2, true },
   { (std::int32_t)2,                     2, true },
   { (std::int32_t)0x7fffffff,            2, true },
   { (std::int32_t)0x80000000,            2, true },
   { (std::int32_t)0xffffffff,            2, true },
   { (std::int32_t)0,                     0x7fffffff, true },
   { (std::int32_t)1,                     0x7fffffff, true },
   { (std::int32_t)2,                     0x7fffffff, true },
   { (std::int32_t)0x7fffffff,            0x7fffffff, true },
   { (std::int32_t)0x80000000,            0x7fffffff, true },
   { (std::int32_t)0xffffffff,            0x7fffffff, true },
   { (std::int32_t)0,                     0x80000000, true },
   { (std::int32_t)1,                     0x80000000, true },
   { (std::int32_t)2,                     0x80000000, true },
   { (std::int32_t)0x7fffffff,            0x80000000, true },
   { (std::int32_t)0x80000000,            0x80000000, true },
   { (std::int32_t)0xffffffff,            0x80000000, true },
   { (std::int32_t)0,                     0xffffffff, true },
   { (std::int32_t)1,                     0xffffffff, true },
   { (std::int32_t)2,                     0xffffffff, true },
   { (std::int32_t)0x7fffffff,            0xffffffff, true },
   { (std::int32_t)0x80000000,            0xffffffff, true },
   { (std::int32_t)0xffffffff,            0xffffffff, true },
   { (std::int32_t)0,                     0x100000000, true },
   { (std::int32_t)1,                     0x100000000, true },
   { (std::int32_t)2,                     0x100000000, true },
   { (std::int32_t)0x7fffffff,            0x100000000, true },
   { (std::int32_t)0x80000000,            0x100000000, true },
   { (std::int32_t)0xffffffff,            0x100000000, true },
   { (std::int32_t)0,                     0x200000000, true },
   { (std::int32_t)1,                     0x200000000, true },
   { (std::int32_t)2,                     0x200000000, true },
   { (std::int32_t)0x7fffffff,            0x200000000, true },
   { (std::int32_t)0x80000000,            0x200000000, true },
   { (std::int32_t)0xffffffff,            0x200000000, true },
   { (std::int32_t)0,                     0x7fffffffffffffffLL, true },
   { (std::int32_t)1,                     0x7fffffffffffffffLL, true },
   { (std::int32_t)2,                     0x7fffffffffffffffLL, true },
   { (std::int32_t)0x7fffffff,            0x7fffffffffffffffLL, true },
   { (std::int32_t)0x80000000,            0x7fffffffffffffffLL, true },
   { (std::int32_t)0xffffffff,            0x7fffffffffffffffLL, true },
   { (std::int32_t)0,                     (std::int64_t)0x8000000000000000, true },
   { (std::int32_t)1,                     (std::int64_t)0x8000000000000000, true },
   { (std::int32_t)2,                     (std::int64_t)0x8000000000000000, true },
   { (std::int32_t)0x7fffffff,            (std::int64_t)0x8000000000000000, true },
   { (std::int32_t)0x80000000,            (std::int64_t)0x8000000000000000, true },
   { (std::int32_t)0xffffffff,            (std::int64_t)0x8000000000000000, true },
   { (std::int32_t)0,                     (std::int64_t)0xffffffffffffffff, true },
   { (std::int32_t)1,                     (std::int64_t)0xffffffffffffffff, true },
   { (std::int32_t)2,                     (std::int64_t)0xffffffffffffffff, true },
   { (std::int32_t)0x7fffffff,            (std::int64_t)0xffffffffffffffff, true },
   { (std::int32_t)0x80000000,            (std::int64_t)0xffffffffffffffff, false },
   { (std::int32_t)0xffffffff,            (std::int64_t)0xffffffffffffffff, true },
};

template<> TestVector< std::int32_t, std::int64_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = int32_int64;
    this->count = COUNTOF(int32_int64);
}

static const TestCase< std::int32_t, std::int32_t, OpType::Div > int32_int32[] =
{
   { (std::int32_t)0,                     0, false },
   { (std::int32_t)1,                     0, false },
   { (std::int32_t)2,                     0, false },
   { (std::int32_t)0x7fffffff,            0, false },
   { (std::int32_t)0x80000000,            0, false },
   { (std::int32_t)0xffffffff,            0, false },
   { (std::int32_t)0,                     1, true },
   { (std::int32_t)1,                     1, true },
   { (std::int32_t)2,                     1, true },
   { (std::int32_t)0x7fffffff,            1, true },
   { (std::int32_t)0x80000000,            1, true },
   { (std::int32_t)0xffffffff,            1, true },
   { (std::int32_t)0,                     2, true },
   { (std::int32_t)1,                     2, true },
   { (std::int32_t)2,                     2, true },
   { (std::int32_t)0x7fffffff,            2, true },
   { (std::int32_t)0x80000000,            2, true },
   { (std::int32_t)0xffffffff,            2, true },
   { (std::int32_t)0,                     0x7fffffff, true },
   { (std::int32_t)1,                     0x7fffffff, true },
   { (std::int32_t)2,                     0x7fffffff, true },
   { (std::int32_t)0x7fffffff,            0x7fffffff, true },
   { (std::int32_t)0x80000000,            0x7fffffff, true },
   { (std::int32_t)0xffffffff,            0x7fffffff, true },
   { (std::int32_t)0,                     (std::int32_t)0x80000000, true },
   { (std::int32_t)1,                     (std::int32_t)0x80000000, true },
   { (std::int32_t)2,                     (std::int32_t)0x80000000, true },
   { (std::int32_t)0x7fffffff,            (std::int32_t)0x80000000, true },
   { (std::int32_t)0x80000000,            (std::int32_t)0x80000000, true },
   { (std::int32_t)0xffffffff,            (std::int32_t)0x80000000, true },
   { (std::int32_t)0,                     (std::int32_t)0xffffffff, true },
   { (std::int32_t)1,                     (std::int32_t)0xffffffff, true },
   { (std::int32_t)2,                     (std::int32_t)0xffffffff, true },
   { (std::int32_t)0x7fffffff,            (std::int32_t)0xffffffff, true },
   { (std::int32_t)0x80000000,            (std::int32_t)0xffffffff, false },
   { (std::int32_t)0xffffffff,            (std::int32_t)0xffffffff, true },
};

template<> TestVector< std::int32_t, std::int32_t, OpType::Div>::TestVector() : current(0)
{
    this->test_cases = int32_int32;
    this->count = COUNTOF(int32_int32);
}
