#! /bin/sh
### BEGIN INIT INFO
# Provides:          tango-starter
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Should-Start:      tango-db $network
# Should-Stop:       tango-db $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start the tango control system starter daemon
# Description:       Provide a tango control system to start and stop other
#                    tango control system devices.
### END INIT INFO

# Author: Picca Frédéric-Emmanuel <picca@synchrotron-soleil.fr>

PATH=/sbin:/usr/sbin:/bin:/usr/bin:/usr/lib/tango
DESC="Tango Control System - starter"
NAME=tango-starter
NAME_REAL=Starter
CONFFILE=/etc/tangorc
CANON_HOST=`grep "^ *TANGO_HOST" $CONFFILE | awk -F ":" '{print $1}' | awk -F "=" '{print $2}' | awk -F "." '{print $1}'`
DAEMON=/usr/lib/tango/$NAME_REAL
DAEMON_ARGS=`hostname`
DAEMON_USER=tango
DAEMON_GROUP=tango
PIDFILE=/var/run/$NAME.pid
TAC_DEVICE=sys/access_control/1

# Exit if the package is not installed
[ -x "$DAEMON" ] || exit 0

# Read configuration variable file if it is present
[ -r /etc/default/$NAME ] && . /etc/default/$NAME

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh
# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started

	# first check for a running tango-database and
	if [ $CANON_HOST != "localhost" ]
	then
		tango_admin --ping-network 40 || return 2
	fi
	tango_admin --ping-database 6 || return 2
	# check if tac is enabled
	tango_admin --tac-enabled || tango_admin --ping-device $TAC_DEVICE 3 || return 2
	# register the tango-starter if necessary
	tango_admin --check-device tango/admin/`hostname` || tango_admin --add-server Starter/`hostname` Starter tango/admin/`hostname` || return 2

	start-stop-daemon --start --quiet --chuid $DAEMON_USER:$DAEMON_GROUP --background \
	    --make-pidfile --pidfile $PIDFILE --exec $DAEMON --test > /dev/null \
	    || return 1
	start-stop-daemon --start --quiet --chuid $DAEMON_USER:$DAEMON_GROUP --background \
	    --make-pidfile --pidfile $PIDFILE --exec $DAEMON -- $DAEMON_ARGS \
	    || return 2
	# Add code here, if necessary, that waits for the process to be ready
	# to handle requests from services started subsequently which depend
	# on this one.  As a last resort, sleep for some time.
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
	start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --pidfile $PIDFILE --name $NAME_REAL
	RETVAL="$?"
	[ "$RETVAL" = 2 ] && return 2
	# Wait for children to finish too if this is a daemon that forks
	# and if the daemon is only ever run from this initscript.
	# If the above conditions are not satisfied then add some other code
	# that waits for the process to drop all resources that could be
	# needed by services started subsequently.  A last resort is to
	# sleep for some time.
	start-stop-daemon --stop --quiet --oknodo --retry=0/30/KILL/5 --exec $DAEMON
	[ "$?" = 2 ] && return 2
	# Many daemons don't delete their pidfiles when they exit.
	rm -f $PIDFILE
	return "$RETVAL"
}

#
# Function that sends a SIGHUP to the daemon/service
#
do_reload() {
	#
	# If the daemon can reload its configuration without
	# restarting (for example, when it is sent a SIGHUP),
	# then implement that here.
	#
	start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE --name $NAME
	return 0
}

case "$1" in
  start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  status)
       status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
       ;;
  #reload|force-reload)
	#
	# If do_reload() is not implemented then leave this commented out
	# and leave 'force-reload' as an alias for 'restart'.
	#
	#log_daemon_msg "Reloading $DESC" "$NAME"
	#do_reload
	#log_end_msg $?
	#;;
  restart|force-reload)
	#
	# If the "reload" option is implemented then remove the
	# 'force-reload' alias
	#
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  *)
	#echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $SCRIPTNAME {start|stop|status|restart|force-reload}" >&2
	exit 3
	;;
esac

:
