// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 4>, 1280> hypergeometric_2F0_large_z = {{
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.7944300763794837863460239247756117518755e+39) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.7730673696923861041007502200748676573927e+39) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-9.0921796163704784864586001035922757860434e+36) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-5.7638639558423021936076204730400653646627e+37) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.0425668948456725779986744143950020594293e+38) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-9.8504333314274807865259455186489732827178e+39) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.4317368570137309382413386848406749038718e+40) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.8192277482336332563218506313647249188109e+41) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-7.2262207783433648552660655669784444778209e+39) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-4.5823620266905623948427865564377976340992e+39) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.3285081625635161726173588864732669962497e+37) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.5533109844542845227235204230680068350628e+38) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-5.4933821858393544687729628915099482836408e+38) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.6375615381809845746841440789953368282710e+40) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.8323652301886246427403013713127575555042e+40) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-4.8599944877342186748694654929258339958728e+41) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.8716978456093984398247623098672838823461e+38) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.8168553736072875147259753961126621437100e+38) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.9448265778352749829816029551298098882993e+35) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.4847146086157560464156291487747892920351e+36) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6315870204477602208645777083521336902579e+37) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.2436111965988218614495735796017739361760e+39) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.8044606729604574740717011259735818412287e+39) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.2682658308710359732773552496604116676232e+40) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7779632599418474050700511881908321699146e+53) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.3853954363684136777885413229799885732859e+53) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.1427189695334251294303519092977806427252e+51) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.1871666272488808307551639477643342883521e+52) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.1488184952583330173035404189141350897413e+52) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.9286882519546404160671646687237689098231e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.7945052699602559354115005719941362196964e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.4811495582550017278736154506667571551805e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.1982744321389187998871443348077272968197e+53) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.1762821545761406086040706083394741717379e+53) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.4791366084937352554024682129405527691489e+51) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5801724721174097905965843957915856464825e+52) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(9.0165295115447242524512829162873989566707e+52) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(4.1909959406283534190598721361715085027485e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(6.0723241720148004855805985369382781491154e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(7.5637964629723774119403803425479416656861e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.7543483215727200797688436041581248148557e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(6.1584488195782620144388101946504927848031e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.9474867942990096882391841691520441140900e+52) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.0848076844765709021638805141841326903347e+53) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.0778284895581670226335058428052281204770e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.0077250112799095873804094299108763597159e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(7.2554097144075584193678437985617685500917e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.0353295386686156149241387243537547000249e+56) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.2487137102826533651051972394309303242305e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.8837667617236074095158342975156836975675e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.7729825828683682178908917773677014504330e+52) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.9509198224645316365146835447026840845431e+53) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.3804256784058872917111378376923021496732e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.4133592953438279378661020893617283935641e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.2919198329325201382372525431060519002833e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.1571175015314116526126215645190219486129e+57) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(6.9427463966631748846751917555949092534524e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.3831591609428628438113451635366227618720e+55) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.0967027866960631846866368889525310491820e+53) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.2037879933563499406600100625563635554703e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.6990744768226374999592012702870174966964e+54) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.5759076526542959063672933569133129140843e+56) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.1807823149628708989519276257780758012910e+56) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.4505797918085757831821382970855010880519e+57) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-3.3309357090999233381454577973254786538826e+37) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.1697222179121536550876160452237554269154e+37) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.5314589551775304257634979267477551583855e+35) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.6628431355487991531451183573792218594938e+35) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5091452925131940492475300395004423380456e+36) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(9.7253728252366646279087800497090806688028e+37) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.3857905896014345301439700168830431367652e+38) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.5438681755211611981253325902772790066482e+39) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-7.7149844410092196809591260253926500792087e+37) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-5.0138881752515785070899729374113784540291e+37) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-3.4027427793632579567269504284009889277520e+35) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.7864834952549811206314753899671992683216e+36) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(5.9399368456342062034142346698956543086563e+36) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.3641331432749951987415449152931731613311e+38) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3736219691786304542295747182602620277199e+38) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.7841799906294971126164280560725413187546e+39) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.6534494409138193443820385553328129651784e+36) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0707300271651899313255004197853950836026e+36) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.9116002366331199736209529284476583813478e+33) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.9962631635376706244210161225832137062785e+34) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.6514260090961688587015661958928167201777e+35) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-6.4549045324236602441528772823345230715998e+36) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-9.1956335144399005248695640648649509121990e+36) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.0201704393418938842599459964486807538872e+38) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.3408977613031159350037068178324573465115e+50) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.4507274413396491546008841318530206902040e+50) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.1596842829876358328975398681004669926013e+48) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.9914600498967849116930352079421061574635e+49) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-6.5379433353850317208196870139514403160853e+49) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.5089159087750246573603270111540598781445e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.5684802951077884611059056375714701173490e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.9189612748780138563370935207530312677992e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.1299540513851609987429405106706153521853e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.3004549347190491756015724390563051650713e+50) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.5680602006190094131469180336115584854109e+48) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.2198666544589847734517958701305594880496e+49) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.3853066634107254585880102614286255392743e+50) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-5.3153316736206234118512553541920992135723e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-7.5600090133874513541574007716876200031570e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-8.3018849920725625425880253257364704609925e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.2363583498512172918123376019567078618993e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.9875004657417082254220555048792415867301e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.9944554445527013880915838677603644300026e+49) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.6398567525700403015398684368605214645476e+50) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.5229373659870425392868118324897613629154e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-5.8408734365159081612258993745684218329446e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-8.3071749300022889297725645694331557426015e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-9.1201924940874949721348573030495069610910e+53) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.5692240768766136157037366769942140944129e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0137930059515421979390475366229696229494e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.3386513173148901690838122820408791370926e+49) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-5.8918532200435877827329353851478944086715e+50) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.9338491568129609409252317787964017131531e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-7.4165164590398721933052125246967039638945e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.0548092476419742221564431186378374372907e+53) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.1580157591240071912050840934731193065950e+54) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.2117628769767164635435449598126652780686e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.3050040478459286775227397335947658261926e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.3153629385259050678493933497011287842448e+50) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.0932305966104630976156351507499388978863e+51) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.0151650943180623255252058543058422829623e+52) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.8921427290997948362649031759752171786808e+53) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-5.5354361211165644529887322611494145344616e+53) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-6.0760802063371475064670229772639520041760e+54) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-6.5865584582227521305783512615085407354186e+35) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-4.4406990087495107407779578809590515674592e+35) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-4.7735166788682115369844873518528275096569e+33) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.7428121052173865756879624127714053925067e+33) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.6636683950864195684129964828605488773820e+33) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-6.2248314377655098328262801595865792706468e+35) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-9.2167480370511168506203101192739575747646e+35) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.1760730040263214552863844899463008765783e+37) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-1.1317033088988217026478399269802775931765e+36) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-7.5505629006725191447454745984685927967167e+35) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-6.9933853792210631902573884096415257674304e+33) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2409965736083039648828598436164144218265e+34) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-7.2422593919386055800153693238911968490084e+34) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.5410050316860093794953093748798054120779e+36) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.5748094161331313611353180983297579702751e+36) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.6187685771551539289085951237470499017247e+37) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.0952137666917809149348767672690301863971e+34) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.2599808633099135077735966115821026525315e+33) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.1522564768266357140522302130214641114604e+31) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.8080118260934768078806006012369164701757e+32) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.1835265481240978766342349423380623739349e+33) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.8285330817972507929670783979590086332136e+34) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.3552050517273086584509241197182703218406e+34) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.2451433804002121675866350222749312319451e+35) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(7.7969667253489323058171391424973687689695e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.1548430417103186825481441514748187237668e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.2149329459101288574640916194160307255551e+45) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.4500133141803905819926952699117831225359e+46) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.0640106991050245295600401550401332065628e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.3705071285629840717244522493933780688009e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(4.7059410479198413146410234062202137599831e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.5561959448572414521252607955982266126756e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.6069366800814759386877797870627389271384e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0623831981208485281558465180735554472074e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.6847550907653934594608279314655560727696e+45) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.1216785239478304629203275250702042233912e+46) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.1962661602509897548479297855277622206206e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.9562152445636512176293478919219677195574e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.7122293415312490855117334040256618281818e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.4024532398405392167645860857772904984316e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.6128012847286252187784222953332417247178e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0662044748670429045382868063375483424270e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.7098330638968597409075639703636291018960e+46) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.1829636451738985624917765227937469283353e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.2148074985399947778208585242430758718311e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(7.0118693448571828393801494050155225658094e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.7895609988460201026584818679235555450781e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.4750363676646433741398343589267459834102e+50) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.0290336053329417236816220755716154414964e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.3413640633176622784906723272880019048798e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.0956861625650286375834691787861204356450e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(9.0410699112941922415618417658828518035745e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.7876953885234439734150195437688986873481e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(8.8252023059416037977812298625731528957554e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.2321184681559829841276841207879575977432e+50) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.1925043640790779942281621990871591345942e+51) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.9766732520785881543927834870896112493844e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(6.5952023500108583897762904901874175581894e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.3847414022972643340451521767100514425659e+47) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.4599437321741553139226272441659704700759e+48) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.3750181574483971566791521617840917762890e+49) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(4.3517318372561328474721486609057576578047e+50) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(6.0754578499934815908176902471600393388993e+50) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.8791891307421201491909248334259697029356e+51) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-3.1635572546299921614123427332716875507229e+34) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.1987073457003082930082766065412998598336e+34) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-3.2419361949077677859736421337247422567316e+32) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5474666366715472459977834386440603110614e+33) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.4866533516539474577393587971308120380397e+33) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.1683603580041594629093368755058545408252e+35) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.5478775595877884246976580511557826900951e+35) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.0600292010706878632730987377513294554882e+36) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.6266835869490694126951873967259691234730e+34) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.7982077372455471468539347851591101463502e+34) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.2218097192774429583840697852037789898127e+32) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.0650704228458106410973567010220063474223e+33) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.8609010301402716599434440160311356389880e+33) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.2579202602354006080557825248064070930683e+34) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(8.4638368907075066219136333501569570031022e+34) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.7070180888716891615518556925523747747724e+35) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.5490607770739629851415728560778434487165e+31) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.8019180830682029533261647258075514330262e+31) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.4689563362220495942129096103906311537475e+29) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.3785769135189233750690839761679637854235e+30) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-9.8771307597857671023278946657603004022098e+30) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.6467912822169801240431012771832845554284e+32) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.6353913931579911554504378451641516442710e+32) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.1452227346868241124592450886472107742459e+33) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.1766701136665453125933989511296079303329e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.9604470007478789251250438880723988178607e+44) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.5036001456786411904456596280728403529386e+42) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-6.1791046144252028277470288276147222030945e+43) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.7902150193745968422415648756720144041923e+44) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-4.6811804342815792571963333468356367341252e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-6.4159409098451514977456704954717050601973e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-5.4762422731358695242129944506943109743175e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.3603450656104767716191919410256214822177e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.5968010766646048215309658624008203472842e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.7053608937496705304528616116299537140827e+43) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.2414871402192202612507049397576064116211e+44) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.5966568916484494801975020546000112672983e+44) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-9.4034521618674019753781172156648062270797e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.2888041366967307209117272535478473785362e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.0999557094265864601921778612086998878907e+47) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.1670910002278258337348463479318221432307e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.4659849879943853266872204825105310667117e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.5645371319456963293475017450911009504725e+44) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.1455071026328103786235145497133028621062e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.3180566289487905710399093609944527336946e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-8.6712272930524200208294725803467509751033e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.1884024593189795604626443546702581557265e+47) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.0140199726734990138263654482291415781906e+48) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.7017095024379726049702448832276834054830e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.8276322106322151783837659341554253036516e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.9503620074470960474173009157535188288543e+44) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.4287881286802822129479694422844541578309e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-4.1385383809934615168938928705503439380502e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.0814967470089799892140570485350049862719e+47) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.4821992146785544044358256116427070244869e+47) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.2646762102932666063459428039185509168351e+48) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.2459475249990316447677804885004824203032e+47) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(8.4282000038953912773099898137593902458442e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.9899689666820269650117752347123413845177e+44) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-6.6106487711452238227734052442237102588061e+45) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.9145941554433993778042302085626236504611e+46) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-5.0018320132974441639296520270445227509956e+47) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-6.8548749342402400249038888722142764924823e+47) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-5.8479426962465524083551679476474232443256e+48) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2217219096736457429983550836314722788767e+33) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.5542993657098276799964339049257337140494e+33) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.4019360685444486634869823519341688608612e+31) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.0910428158892267051098836515511956499571e+32) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.6668135302606619719485650581791959339787e+32) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.2505407614468967555643042045062555117758e+34) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.6380909246329094726207011646008202187461e+34) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.0285681566995428825129539783193279277598e+35) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-8.3231454714222552611014441088608950463570e+32) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-5.7645118820676275299116000816554045319866e+32) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-7.8195004817961387398840868749594976869227e+30) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.8431354845324072882014646167984656818172e+31) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.8678779781582332309679044135730513930987e+32) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6146892674945648867501414695898713954321e+33) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3649227096012894244973605458861001955030e+33) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.8369953493425443810145621639535311111020e+34) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.1453184933351676743821643952406650046642e+29) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.6612158829381322684203455921651825051423e+29) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.3393622193634141587972646949854708232581e+27) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.5843130664898398550001472966083052063145e+28) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(9.8583275111874572927363196064801484476238e+28) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.1904617196088319502610607842422014319647e+30) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.9546101196808623936649912114988653029926e+30) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.2596044028312437444796136950847452070333e+31) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.8377897879814031560708597390741657127677e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.2722459703711024254099586625158109705708e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.7754995060293631608080213716534676676887e+40) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.1454720657577577630176799033837258829338e+41) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.1175770378826032261310756478678385436975e+41) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.7292175577461848117289341597579211547445e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.0536345653458651599942577090250809558627e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.8125482249595234133560124584104542761738e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.5847539613705090585016355947618650221350e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.4815733625358979562591976960892497544127e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.4623881024764474133702617845100182952443e+40) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.2379513036749817087265116955031561351249e+41) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.0906022283857386098481545908683035238372e+41) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.3144532237128775215778495490618522959158e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.7684716525515554518655178763994361202844e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.3306087655947651492289901602019655343944e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.0020997614569669159026599952274441416473e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.0781161483170899620983293843856009449485e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.8973945774863114522473217333708817036449e+41) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.8835718933052303940511745500762540177635e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(5.1253158202963135377567401711268712135336e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.1056379156759863178464287610273839353607e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.4874732597523211914071232407078081309305e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.1189110074223353735302216303126540846975e+45) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7078146968801151103179699946104664385047e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5666136104515619841354531090140784279969e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.5782306524212954506483113867162759110919e+41) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.3274699913970187716712215537434391064925e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.3330898856278029138842315858683552952622e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.3661215962558941415118780074481436018189e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.8379089249002753465003168733764108931668e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.3824841043798617699076527469616545055255e+45) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.6007257063891303767763747312249426494681e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.1080116413249631273996157832779918943118e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.5440066288544387039234943584381312961351e+42) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.0080866177343494439556068634320171994456e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.7427290592779792973777806170382541119235e+43) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.9146734339110621246745899655950440781810e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(7.9570937443342606591127224333383576345685e+44) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.9844114659540541956193116797423225727048e+45) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-6.7752519073092225915220152934445232481965e+31) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-4.6474867991074104823874442450721803007189e+31) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-4.9965475911854945090944610618611797273443e+29) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.8262823487494373836168821618124730308519e+31) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.9511202732539026003552328746067448203914e+31) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.1115184727014241304864398312554460674656e+33) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.4539420803920407295838450222599471307736e+33) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.0659537133897584113616618221872686436635e+33) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.7922301811965784710736890158327674473973e+30) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.3882715319811333875585508369369519008048e+30) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.0690107958271785641977795218072866246422e+29) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.0221828054308531898764359726344151814955e+31) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.4881480944719340690149110031796090974705e+31) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.8583189045313247844035399107282161801073e+32) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.0324428508422177853091667779712275615663e+32) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.0785380532977244448363867112595365670784e+33) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.0001067248375988452325255503273325476919e+28) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.1212319923526775936804884911796470013599e+27) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.3898050968609219065822064145221697967161e+26) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.5539003694088929070729106517851103261250e+26) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.1883922033946409765798347925669800723522e+27) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.2252430279150883205120999584756019313897e+28) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9507281327996366875824968642048570485864e+28) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.0060262236663365091670654510286098105674e+29) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.9742572159182293036063658540259021863915e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.1069090650360965615519664749970248857403e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.8412504336938283263465627649073616850253e+37) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.2005533219785311875569110494673682844087e+38) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-5.6262120092721789219510658106204695159945e+38) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.0024356375447763895280971818338229692358e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.3239389073608260202549265680548878610089e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-8.7824688066375973523404178545910261745310e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.6357403898356896582556797000996731534870e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.9921853927903720442649336545684127191198e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.2767234067735766811833496031496614966972e+37) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.1765027607189353727364861522899737829652e+38) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.0677601035764148510581621368794756940474e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.9021777386874047694400452108024936514172e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.5122165491429627859126708190904908138826e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.6663687204165751022512796242161035120769e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.2918176806211813133985757044447070224710e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.0400297369532071560614075328613044109566e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.5372105095894375348997009254339416687530e+38) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.1965185925752348355232611922028721873144e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-8.1708397760216415076857503135050336899949e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.4549589146318969499732662388523442447924e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.9214979164562647904150991098492062217203e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.2742294393299242572959048728972343899972e+42) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.2497196139539145256303942722918120399305e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.7185228087864575048576065943169311037145e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.7725724869639695024816187735459876096694e+38) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.9118402943141846251299130022501988073569e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-9.9991642996090497828872477252039560676007e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.7804473957268922174596836509081077968219e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.3513469762252913536574469179898148011272e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.5592444782120390975717477632104442963827e+42) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.1173636133943056497044876920419912543941e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.4997357858114052570688154781843356156041e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.7302061639940716378518900432850083174390e+39) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.5828951925159579061065237078534753606961e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-4.0456503360994864314144637148101722976399e+40) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-7.2015870377080535823648168265012958603224e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-9.5105336157273506013647690172250252799956e+41) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-6.3057005142889420918837347661044898061302e+42) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(6.0571653638073611245146527069871580588586e+30) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.3498056961360712733928872874561623909153e+30) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(9.1030877859224428145386359113692694396593e+28) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.1412318944436927157837095289125396180774e+30) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6805578897740223558004172262953674577937e+30) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.7086899515045358792695107733002251216028e+31) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(4.7825267386736334740913647277851821913515e+31) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.7029563173018934394042108663865151804829e+32) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.3929244189538388418869983398379007289140e+30) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.7140761312943196037279370484517569762545e+30) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.4557223748369250828617249900056404201674e+28) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(5.2639273592532152574367424970157710262880e+29) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.2321425501802077404978950600183641679651e+30) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.6882501077727538436937162975574195706943e+31) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.1751827618827444828606483364710916890392e+31) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.2224722325495330084318882883894243083803e+32) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.6468933088282811632467481722182515183909e+26) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.1978017840733623004288866921097675248345e+26) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.9298188277560373831292725303998205526548e+24) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.1528362630918148267401407821975859321316e+25) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.6572935824268507958567641173531448997996e+25) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.6005773920372592665382550320925355855597e+26) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(4.6445254021219706104616777950284171179637e+26) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.6504395152569688672380394846441077357188e+27) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.9942609538233828958200080617954486949895e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.6201782756111548964650805494917415943584e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.6223693199168728280249597671019442907475e+34) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.3867376492101504628385018954485788635651e+35) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.0535997197316245239681748667801235641179e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.5495458453247442866452582557229757662971e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.0089472312175219785781903590463514498751e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.1748344822663688088882579734742418105013e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.1830460076325370066076427163816694330641e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(6.6563767210457274357226949132190264793532e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.5850108552725037604140739067410046589717e+35) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(8.0792352636337468033708437209486167195781e+35) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.9403532553045324564739219684200985979575e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.8532916672846481507317296730297952695547e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.6991740102286014298512774628489658866846e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.1631072280533075334816361026323588434309e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(6.3382455198045099076297493075093436841664e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.5940635301562289942866141786549079721253e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.0931477228083982155396965289456218360461e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(5.6044205871831739286043728819254248492014e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.3457663703754053847919128607011186752176e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.9780683342097467566589043177349826336517e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5643840202148379391796970433981841671681e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.4991663619529690542260611369569626251844e+39) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(7.6758749703583767064798966239388613545283e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.5635706758077680245414322006982242619408e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.3237486870077025787203282540899052801525e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.7904438620841374807205203519821313904363e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.6305354942717768499245523947273428632325e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.3965324800046335757478254660253918438589e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.1068728465298296631991802584289397038000e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.8162684714803001051777008012951145913308e+39) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.8861239058133918823827065056701597272666e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.0918268306612067980211675661125190184566e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.9748055661511475259539048808171556048002e+36) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.5614764045721230559025602996512997301767e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.1500162102017780101395286814755769830568e+37) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(9.0365847049705421482654450759628768895638e+38) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.1714766354891102456777923631898013935697e+39) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.8473333882615089981941911908277116553532e+39) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-1.6270639090735494145783153246217962023588e+29) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.2002299352280508024147352575658529960349e+29) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-3.4647378717871950825238448328647260574271e+27) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.7552056259538362296930835536842044510069e+28) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.1235264585995965826990503784745244915922e+28) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(7.1353324641146761356686129156275462417997e+29) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.0485064219025633752560890959127704261553e+29) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.5600831276807502985677848898580273600052e+30) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-8.2744404757604639046005678942152151278610e+28) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-6.0992718567877554299415747120453228691857e+28) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.7426546928315699595534609987039395885004e+27) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.4831703666868368690895751180611622035398e+28) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.2912605146720960483343085322495943017465e+28) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.8186229157937494967565072451046315453810e+29) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(4.8406600986849865783720543540231129162152e+29) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.4335832525121417359427417131352831559641e+30) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.0315067848807668158633519817168772351148e+24) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.4442540769504319810653298223238988347036e+24) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.4028880231736588186455050365120189718635e+22) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(5.7356263142053450961573801905704572974114e+23) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.0756311310072830069121517903470686274902e+24) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.7367988267495755764118750067910289461212e+24) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(7.9474611712424654113220691771674224527580e+24) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.1849817913357986632391034372597779117104e+25) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.7133622416001813663633276471054223795305e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(6.4630174602953802707705720379049477726448e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.0109134632090966268443044773279284398668e+32) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-9.0872400869226196611539088076860618674005e+32) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.0502831679459479126946970047824934687660e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.4890051241511977961682111371811107566099e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.1676857360942932356171250337607377219613e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.6330777425112526556234975971331309256115e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.5528974448301172872030793252454122023692e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.1518202481381577514259173918484032062191e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.5829439522467384419077194659793399219495e+32) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.6222030123510327264235868860325312258530e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.6598518495899018862004364037886706928887e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-4.4423394851998640990659263268363336290855e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-5.6535665865849872436036316160716022011172e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9144207976415614527321457171180816035130e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.6801406773112060299055059069428751591520e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.1796029414786002384447009306057531435302e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.2317395251792230920879700576240064065517e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.0162973617314316152491159935112168252042e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.2924904826203433414105892970711514936042e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.7813916197524876981755691427044388142393e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.5396155694459399866527115550049383122144e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.8242291172605195093223206525689968497818e+36) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.1602649755665806951263095086447569892593e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(8.6054528712936270491699406129408380017547e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6747736321645306267039734281451145624691e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.2187199306728403282544791804049256208308e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.7490575474988085240290991481398310807286e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.3351852556458227091855008799541308744894e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-4.2443609828470705933186154436439313188986e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.1873860903528533265092429846416119526491e+36) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.0576872668497834857399901090121000059439e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.0094024888871416788944378096185232925373e+35) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(9.3496121618762859258515754079073589527064e+33) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.2758228673590684287340933133814219913045e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-9.6439239384491570946211498348980678972472e+34) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.1696767238965451764732766564115066141335e+36) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.4884951640704041224346524807148343636183e+36) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-7.6699468783752472703476771762855637898811e+36) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6593135006709408569370530089822621910599e+27) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.0106736511581816998294406049912432725686e+27) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.7580032167999291189078553597193590909848e+25) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.6631572112536448714133246973883747545409e+26) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(9.7747607134625987640276221181525762635095e+26) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(9.5049659362034756316692664421552463192638e+27) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.1843562232224308291748380331043692417318e+28) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.2941006088268142465460122838964625493512e+28) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.5535840307198120196876267713794168066810e+27) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.1742506541307843418123237806595622947999e+27) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.5098769170253117040628311897663783988757e+25) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.8021068239895052111234839331975880179883e+26) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(5.8687955855724706030019402665969288728154e+26) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.6937990422574641375406398918970036144386e+27) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(7.0932781500472057438857301586802970236763e+27) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.1666724380682070661678559319629146930874e+28) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.7130793204194969069821110727389271219704e+23) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.1162631843925529683639171509532776750605e+23) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.1413074919530765587424752528029683886369e+22) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.2586650343859701839114005648555500912019e+23) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.4993205758461610184050587298454166476091e+23) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.0704975957778648431404742498698129009002e+24) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5415171082718919309141465452509428918302e+24) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.0282378501519299142995248176306777322149e+25) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.5819125910126941036023273075298026585791e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.2006658801406238771695689839245936327603e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.8801379276714827002206559278266393299783e+29) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.9591637326723862559997414572279726002432e+30) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.1523912053429506309309621997721026174305e+30) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(4.1609019780667392585204676190270616680946e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.1982297595181200200355712748588241571832e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.3625098185594550108743705506732072078736e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.7292251507404732935608713370718517999918e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.0714354941815228674540130732336039155201e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.4174092826409912048868690877739447738073e+29) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.3856728974727290527279116957047805158077e+30) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.1754466865010624175735520512497634468858e+30) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(7.1890970083908333058300447439417829576829e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(8.9812500782119784099227377005519807643113e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.0815004902765342385951137252124790849531e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.5306822147227939124960328314313166141789e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.1617000317258113399806615538241531359841e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.7172625456438295183902720678764223711229e+30) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.9083547698152960318997629325270815484420e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.0438194887341859619268903152853870927694e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(4.0497128687635440812125312002885354183913e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.0590611274995565076937453261202247192864e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.2985127818630801444566855390614693067599e+33) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.8151795005244191776474194742145757442397e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.3776102068435682494549586586069320200458e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.5936189075907712889877231568803569855086e+30) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.2641205373477065408457053314282093003372e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.7976152932585360060665731298791184480307e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(4.8044045759610424525413623492751394365154e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(6.0018298097708282719569774821488434499049e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.7267831469241124535747518694121366734954e+33) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.8899957780715437903397650843332668907626e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.4699954583127315571958901926196919623069e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.8141613229997499712043566826783322678098e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.3701051267978700550446224877585436330975e+31) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.5615439804783582868767563653348318003536e+32) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.5633121065475164675374209029428605596175e+33) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.9528961274873842027196503706070716467494e+33) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(8.8711234736097317376377093998150619431061e+33) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-3.1488904330697100337152450792090541677746e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.4385432313787829799066552855777006457030e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.2450757425938982379522431689564193336773e+24) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.0398592811655467980452716442262338193907e+24) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.1923106399177305091366058144941200281709e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(9.6358168235332761564265663519526600326671e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.1793217230610492139466721992648325521760e+26) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.6649875132498029391006585419499867355326e+26) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.0262069099984149908108299935645408229857e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.5688323712710690048612789632620699546193e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-7.9900408366359981479621301746419062579918e+23) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.9495650107316824229688593653318715532477e+24) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.7928665613439582454796445512290164314729e+24) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.2894218569070669189998861553704560671665e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(7.6966777661080970644376699469115883460995e+25) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.0422585034160841153340541049007124512582e+26) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.7596720736010676668109885803359092401205e+22) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.1147020679263477638302197326719375468822e+22) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-9.2687856270722502304616557733915643891018e+20) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.0800643583836321619528053697972832841806e+22) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.0946820836746113239195916972773416944068e+22) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.6114101106531479361895077607580458955114e+23) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.9635792576391884038487649767704893845979e+23) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(7.5519883198140713824292493142916223437458e+23) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.9934791794814564302423802266410836052748e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.3249052348212051773913912834294819763514e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.2344010492111638955422338018697810377003e+27) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.4033328914279689091745208275598395501765e+27) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-8.7670255480060190151668806752284164299893e+27) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-7.2512371129712534240638858947117053817118e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-8.8926500551461593901374225193355818397832e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.5628625464456083642968207388719945330844e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.9928259065937378793875188118831169121223e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.8776429256142642146591706042770176433776e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.0583354640814233207536339274731486658589e+27) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-7.3564412483101582662672436609139911979025e+27) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.4645863339482879939046438717976753202122e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.2111867120897210480286578272771980744035e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.4853358435668773273990920783704252995998e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-5.9505553494195380488934565989011723140276e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.5091197586799399941206508641084719482834e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.9485873566044876886215107297470680709229e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.0336171410694878459504206435397709228472e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.7153050251976416071974433717448636610039e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-7.3955575219468157126209228271764136589532e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-6.1132979771541282735146774283373228115865e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-7.4967409658472124550440596602026675326594e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.0026179661170928475049171334464286611097e+30) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.9426990022247691908822057405479105525485e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.2852944670469416774224665588632592900906e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.2121401646502784236622523628656522560550e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.3593550112365221720017436114838634920192e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-8.6774475181193208582453095568782448626468e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-7.1726319814657188095907501585170938189805e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-8.7957710751322890863446007153414251672126e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.5228288548777013894219083095013904435760e+30) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.8365173708532898793437917467820499890286e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(6.8621944344869012174772497680505960646173e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.6381377041568341095628102048853313912584e+28) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.3131508761833617084053759877009108479542e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.6136037917206433071099494774407677283748e+29) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.1597601865860069867505806324036715997836e+30) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.6484416856810404652222588149477885489505e+30) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.0605756402757138827450711296173334497180e+31) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.9317582812347190539065322473857323740102e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.3246595819964655340146029288677545404762e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.5635758563832126533520511111970308126402e+22) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.3197185743130725809373946883633721426410e+22) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.1739686988946807682522018621344121911867e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(7.8682016435849752319704602414637041721048e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.4569063663644932056977607509177116210705e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3063729912556120063364931430726699916340e+24) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.0323464511414961328041307652147548105300e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.6113143710859133279995963292867551992444e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.0821285690080434082503966894956106145057e+22) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.4249732927025518690295784595732551832084e+22) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(8.2173803408723141716589793867596658989965e+22) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.5027786015702022867943278257692770019069e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(6.6133779758908850048896751215659732049446e+23) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.3111119612854154240617460631942812270508e+24) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.3879265083858767818322959695463904217030e+21) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0967078075613591759298199933367312602248e+21) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.0320911911064375752866440189275028286285e+19) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.9819047958434383622690210845501702316718e+20) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.3354997387008007357916702768729420924884e+20) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(4.8052662461298714874814184446497819955284e+21) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.7639376818873294523670876779402153795955e+21) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.9895987669239670210536463919032238882034e+22) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.9148464283208196047915007617439891144048e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.7006823346771084174386233695567158293690e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.2601738571679852126577988764732408745364e+24) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.0335969387061081786329808293940184792747e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.9331358910264066472207328032633454214497e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.3197304484274784429184101707826298967788e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.5887471414363332400949050991552791345752e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.6113607062696835364570539932190712916466e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.5233461309759619500154340845962475854543e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.5683189655974048330023559031006096980513e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.2478000135670776514027009960922489884589e+24) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.6668973556112505428091278846732836312146e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.1174293835875986624651798562345266560774e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.1279241958944952186316001815707713546822e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.5616524123867397544046336798807672525582e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.0468792309897120184894771318457456212582e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.2694633865326936915788435625375811736288e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.3928178549024439463711051137938902036491e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.3508983982448335728745161498695817459372e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.5096043877887654920432970470209217458937e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.4042193237442887148978717362439257691705e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(9.5808797625490945604547809762742662861842e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.1533284939416956186163721882725570414034e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.0721865788466361764007826462655299018597e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.9500065409797228510339158454777351710529e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.9336063788164357257230384901684315480953e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.7254335197944367698220507650950944292875e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(8.7106230509565917508304938774200421353217e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.6287729129209144726679061890593649294527e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.1112536743330953130058934007131951478247e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.3377017610265158498044509884925600923605e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.7230677447049159718901377531152374498028e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.3717185699102696816514121139781517075428e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0900238788906717679105607176407907889328e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.5490156086093658320822109394209241142641e+25) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.4212337434076835153138195903543986679353e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.5269358719046530423969801133223654393283e+26) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.0877262417434595245743627249847404180186e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7168463956901676918493585012671870278598e+27) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.3121228475321600773569194852797383581586e+28) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.2519343963149092653316351353886244976984e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.8279638805760204712974197152830834697856e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.6156988213159579012585722040368492254093e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(5.5396917542728127060147099625155578215633e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(9.6792069603219370934991532110178100899747e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.3731572642714900143656874809505099457154e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(6.3413969193651503053245677383008086302126e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.9582421329586225301944415541293842594602e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-1.6588094961986865256995422467765718795571e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.3464090322305957409298678214423178670333e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.1888981762436125621122731724231187689600e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.1073772704526942957865449632194637731210e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.1751127074696654665906237206181646747703e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.9808313101640591809533128296853073848214e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(4.6979440236774611087419989511781213666425e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.4502871454565150592893305798514427973989e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-3.1303633281422159257387923143534130832242e+19) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.5366304937145939742669056733029618276953e+19) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.1899362288918920024521437428170763329723e+18) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(8.9519119089459644644040793059294421282263e+18) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.5569099368798099915987768792507667215447e+19) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(8.5345131921586754346622347875843519750824e+19) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.0061336957915224465103406484784089507780e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.0852881792391240877375361807988413020926e+20) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.2227296554724123362296262178730121626962e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(9.9434077540470169941320033385766304953595e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(9.0080312837703075446051376173482036425840e+21) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.5388587429907186828902831400068676176010e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-4.4605345623965611513320053827583268503647e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-2.5134142680084279456399050317034131096155e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.9701837361949227314595349903708200152491e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-9.2477796621454854866294657070262636436051e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.8973933903801382932864696144497646251777e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.5429601473626577977196549478023755898708e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.3974896840252743516663255715383744884025e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.9461025421523350259404041769660670490112e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-6.9325596150149164134773847223734871597096e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.9057839078504033753958645119153263561852e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-4.6155346891060165349394475511293823185052e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.4369504152052936669416196399843163868378e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(7.5521098905482138276849833140708051150499e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(6.1410616344200341576443167357729301660136e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.5582581278167853074987561716650107871553e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.5782045703701251715364272518267009618624e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.7721707510819973080098707029268650582751e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.5611658919826659747291893632147188569215e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.8447892351381519135586947593780554165671e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-5.7420178037218618902664934600750720965004e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.6519233989608107996462769034770481120348e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.0353506701466422800583079363829999181312e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.3672675044610037777006650984967311741609e+22) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.8088494544041907029395905913980160649320e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.1772595622313274729071626222670615832382e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.7892228434546088779443019550801208588127e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.1142708904944310748832189970329525993852e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-6.5806512933811967707306276469393425678316e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.2059159036613663551527553010839256834893e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.7936937938332228418096117701278767797050e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.6226718534714701966053056840427067032722e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.6256139697582569242149257327161350697053e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-8.1241361267388565611568273332565838865895e+23) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-4.5737669149497883889480402710308329711964e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-5.4045588410422545028742914191376190283470e+24) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.6819199986559887185966306332424262109437e+25) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.4731374016149821010724780834620346344016e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.2240205615559212206312559347492710412841e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.4196251606223781498093075818783480235792e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.1751838862125596790074300350653311039174e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.8595762392131321980061544826092030021805e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.1514406261935234409358542453291502412106e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.6518743656977157933182392269937227662884e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.9559424855381540016010038257479027911961e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.1422775455558851742128951104151168855740e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(9.4906535697394921764420953729927207641768e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.1000115289312027761880704573533504500323e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.2517612284832729751404163243440414810858e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(5.3416948159091433764180787112046179669724e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.4531527796911684692498814469035512833242e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.8426069695677727918433526219683096554930e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(7.7480343932880214580515886391012789737312e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.6226041131528247121181473594269963273184e+17) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.8370798168955998355235372421598643056836e+17) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.3906662299440382536804337007201072654989e+16) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.4319818662344102462718255972564583622770e+17) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.3460958927400312850205562328770822230489e+17) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.0696849301175242755998915462936175487426e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.2387242832623695096917286391045675220860e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.3628947437618277760474880619897628487897e+18) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6501051632080631390629439687235882178316e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.2052309715731049110630433301792675519228e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6094399288755644999858715873892678800133e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.5401007072760854094089961188453891112953e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.0793599439274504399191478763365203183400e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.0198153079357468171416597947805895676764e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.8231208131565726831997681632831783263278e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.5982517619185406417625074101520378230380e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.9564888585962796435359244503551364667745e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2922559821276523169795192051799749048579e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.8948265666049556370032316069512420739700e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(9.7795792459682934162093232486353055218073e+19) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.6139101781108428156039385572172360851653e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(7.5048058713990542844411148569766275944941e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(8.7056699790813702623008295149739041426525e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.3892295255523917489549748341064578684811e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.3908630439014564658424539782125281744190e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.1573013490432886815509937723794132245257e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.3682032469711308835709158703478132373705e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.4539937697219761617054904749043800651339e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(5.6992017640844001501461685078037858317083e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6490712978800024045921907676460397378963e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.0728454325634087321556450757343923119289e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(8.4313511414397762094827087444252994994063e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.5737236651595579073340491436217090854419e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.3094489302460440287320710319424010231001e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.5479814611816903123037444145198828784762e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.9097942886510531744737686504014647556316e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.4511953756148317954865088115778891491001e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.9984930542190929629489537241948380184034e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.4781528228764074318712393677160293900179e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.5432413503292076417432309727146895241827e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.6797078047204123182316999027139466582073e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.0616829072879540338128074314412768663002e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.6179237419349786217519455139165834717586e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(9.1681402186405433136228110881924436760583e+20) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.5126088716110871980895762984925231524942e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(7.0287623710180428481100107538119571903082e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(8.1529516959463603128421324961378882638723e+21) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.2366668537253908790402359789142437571604e+22) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-8.3950643098299036380027366966592369862932e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-7.1395738337784420623448222632056726486422e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.0855043843035408842783766422632380052224e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.7587385519975648813921816405266000445787e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.2610186310462780110718857537116027617262e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.6192446444304716073971996829404540993323e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.8422560657778436935890582361577620623397e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.4327329240237971770817735640870158722392e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-6.8055799832373216826936391525712780607928e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-5.7876077400404970707699904633988771660073e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-8.7955873365342228022214238539664259633179e+15) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.2431916520427572827771085260742802785645e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.4643914849795608431440313154476875099206e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.3161676493093956697946331542977335085021e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.4974031780628228538359029851550292555635e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.6024420322119035611719374405295077899019e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-5.0969854519875211169762836902421187939330e+15) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-4.3320661331625301002183454542159723586379e+15) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-6.5319652476705432508559359631641854463453e+14) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.7709513901492505248369039501436570386872e+15) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.7304789904024174822510459351781664914232e+15) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.0326285606670852760521940256178814240277e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.1743547331473622244784757693145668688762e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.8181494221631712394560849275749414734337e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(6.0361338619432021665188687091383154350252e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.1396626416174965360770692107515482537522e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.9434216877808095585562687672190588468725e+16) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.7710243466657371772184323546046573866855e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.7455892885538690995156855491362844541911e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.0538762603048903211413130892087245084776e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.2000669991142893184080390143695857792732e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-2.9035125273920868153126384532931045516863e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.6534442097990722282833907123519568329663e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.3681362430943508617196149631280322741283e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.1385051527509400391694192052490772918123e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.5428611227721532030417851397296937941043e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.9419552678060762842606999076117327219736e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.5128861446816119292065888675619213767405e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.7227289506611362798743771950700463811404e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-4.1677576807353734637721820899240986360943e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6715060244145930582589797263716142954653e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.2745950387193511973176110936618571893145e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.5123869562652584627513849213123942482140e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-7.8856729049743316095530455149654162367230e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.2222601324767611288455002341126776166813e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-4.6890472372796807238241582207602671738948e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-5.3392498583564295787335774114154732625417e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.2914284106694188802975745333384138012247e+19) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.9838008286088499662494991331004000458450e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.5404803998862683745002029178365464259683e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.9227296072062945481113790914456586968047e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-8.8111420366534085364605165061455302693934e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.3656869878884604975871761753695090163500e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-5.2390931640212347763516195280374631277217e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-5.9655483277052983061539753608756635243749e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.4428848015749613084706319904412973861277e+19) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(6.3758919265254021162191328763111594784110e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.4284320478619017743230374834616712942586e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.3787215757868274141891198607884910784782e+17) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.8879245279248394933644179905282426184491e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.9259352430348771751637563028331518165970e+18) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.1221849668867970024396631374044917685262e+19) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.2777607981127912927523218047001660364691e+19) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.0901034445889691334476350018333181450130e+19) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.2390821858508944816416383407894531795500e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.6897900611324703670949333210953944111104e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.3493228475399627255849577719167264375168e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.6223084445698130115169186808628256939880e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.3553564399859528163573590630232293777073e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(7.4007776970092804019764395241342802533246e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(8.2666831158502575716602842840966195911231e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.7551585986041523702742506059790909302105e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.5740360336952292129147692969235496131606e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.1108488137772237439752017105915686686448e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.1942910985977240041128625198700733756771e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.3706556252622622672403499254709003427492e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.9898586520023247282948968216755321126109e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.2512000347514220683637359621017815441496e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(6.9824913880177877111199491649782335808566e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.4823529767007330029456270478233105939615e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.4920043824233397049065038310418567480684e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.9084024184569710906184197886289257943643e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.7434760596654928697321836056429032181412e+12) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.7821256216141537478552119535563463437900e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.5843993571849300733996045184932229042773e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(8.0950245145261847889853823479098035229297e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.0396903154449358329869308165170072433538e+13) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.9159621282296165603933558493996812315705e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.4485742479791382595983538128561767384375e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.2621171118081197871472856693569059335683e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5475953857277676554413464238477124103124e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(5.0548031514822102862758724963647773085422e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.3610440547294291402143806070516318861337e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.3319133616586059680787084793421511167526e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.6066030895083680235470616467326276492418e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.5592272208536982378229307704225130250179e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.9898946926972073257269046710194393699120e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.7337329719679495898727229920266772569499e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.4988207639873009720828715886397413768004e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.9539504737820938059818771294551745122428e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.0126182472913232614177514807619766648302e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.2074647601044186645785169015383073854999e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.5852500737586081805485619508895983247871e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(7.6458843947045096627973237570256503694543e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.3614522499879556348437063444308118908393e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.6710547484142801667912997960255962655996e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(9.4208581546559380947279774909010541730865e+14) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.8816042555038431958235402993806104205079e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.7395655748224593246745951691283650358704e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(8.6742815373055909578191964087552719620034e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(9.6956472954859984591963577298831619969823e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.0672583829032354452845395417609503371562e+16) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.9076542702274528899158999498020554082219e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.1469007325984361609245936383950617867023e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.0379994679468289532966039414328860791019e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.0741003282843743520987227110945964341024e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.0197960553694334932609481175521991993062e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(9.5612436126796052126667354052579562085342e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.0687013862007096615716325110218415044885e+16) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.2785893212406096645932730982680563013713e+16) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.1492696587181447590975785816600202897980e+16) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0012463042294906691548437108821399736982e+16) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.0185252956106406241261164844587332327825e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.0452078035155671414780856661182238745359e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(5.8891460921695750157973518253496010249480e+15) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.8641923632902706017131832416068174122369e+16) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.0836471378051622070528394662036103426052e+16) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.4420126285208922460543532667024671302065e+16) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-1.9218857327248133188852376257022436377955e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.7120783911486842888125232299866735047147e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-4.4652796599534063070391674953842613295532e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(8.5932648226155511971704895247201918330353e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.1726197437727813088171629495808725885065e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.0456408604463267289172688577844024395552e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.3399387199150459431632868409608572567956e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.2563394101336932385601117942664476427540e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-1.6783188474236008609966339050409015151521e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.4950779233471079203769863723368222051875e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-3.8985043393742758218548427965336933487144e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.5149752582405675204268505034150002854610e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.0254308665721227228514275347144137729085e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.6630123632186137860481219200160811545114e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.9203051597817624262373779150449950378364e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.4699065048449276924977738231771393284687e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-3.2997863705396401542040555906357150573724e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.9388086568816580335605836118290042534151e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-7.6383901939070495779040431087995271005232e+10) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.5104426053255209523516001002567511311438e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.0595600539306800960973788548650895689798e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.3383154152671440263057056661126671079890e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(5.8531071620423661186316468687390893853250e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.0951575452334229445184294010872848221064e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.6732863943072685939496867621282043651445e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.2748763134418083763371990805137319166086e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.6329166735538364253069976746577187054536e+11) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.5250965534635524838136415076909155550159e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.0861746789095893185348885904329867877845e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-5.4541422581467136107762726806160252809979e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-5.9845869010819254869634538582615436899113e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.1250870628959336151263442352150234998153e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.8236668632927345529168456018882402996529e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.3004221195332576742441593052270619047942e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.1334137279018194063168666772657189919147e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.0054692588868600665282245542469999222497e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.7431508695053668141295790749301629104216e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-7.1708781094625288378434638364104295399815e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-7.8682009624712340628772782694759416648038e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.4791022233113220352323613413715531432410e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.1265094605453137155941915323885695020770e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0042700392817483782146451116558933041680e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.6453545783749754010911421192616661388577e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-4.7019632864170653166194731462829145387114e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-6.4306772976270686003378703078959537035870e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.6804566904226040519765504443348923387844e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.8438145168469853032068764784367813255342e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.4654243105477808770088106727205960526014e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.2238059393943634488519452429048400256109e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.0910045822764415214634022243636676822701e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.8736760297666757456048782580086086431178e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-5.1098929473894408543189882020856469514396e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-6.9885034303274511722718354465892980789808e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.8261690943392581556008329530251895870279e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-2.0036861509477818161578843196811574657198e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.7658350984531633435559557594530204982523e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.1585376440572048958428236450044415187510e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.9242564099634851690298605856801785118619e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.0667563860402204722677006922732488025041e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-9.0337131353967370487422823381803592608901e+12) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-1.2353940049920507983032513314526998853638e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.2275465505391782162845633266935608917892e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.5412242469533652266782675236312836938715e+13) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-6.6548104165869229103347940718181910345439e+13) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(7.9066212661586098661806977035223662878447e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(7.2084501409143788462881583739116056820590e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.4608907195394708419251922172023447147045e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.1403227481774943509214116294774464788159e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(5.3097671682786286607074855881767203367050e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.1397425490611387803679398627198476849960e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.2270564157138424491508083042316838671948e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.0276493984075761260526791468398527232708e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(7.1277595383120472309065313425128876201098e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(6.4982962869713714033462117786264971689085e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.2181416811402989448916126459521217580831e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(3.7360542521413136419436832236759846440144e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.7911626163246140860101640852070455045246e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.0283370701807348098977645736886629241380e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.1071082068766683993031795034653744862583e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.8293558190447572630711567878677691766351e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.0789708965236718902444989171175240663808e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.8950842081755869841740665594441087352291e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(6.4553830292773974760920163497207657348926e+08) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.1052102888928818784727642147860895759957e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.4166870372871260758350320943148777120582e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.0368945580692145142838570796275268947728e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.2691695360016316297851152292862820674922e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.3981959508729308504909542526590364773060e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.8739546876221533320325315195078486819807e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(9.0076222265780557948290736740045063953252e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.1007999798732577247510015522567048163458e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.8801018100013329185868584229065813580309e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.2703711731111162864655604023086750326098e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.3528590999320830299414741728310108468911e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.4571485635451864941411628408351557215206e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.4146691228338923168364710001652482044722e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.2362353006888818966972794554149710583551e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.1277542169340501695375461082250802628143e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.8815134135224628738754794020438276767308e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.1175480215423348880964665459595271823991e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.8600262596245456599304749326492041925988e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.6956463603581879054272676392792908455076e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.8263431422887192924854500512282780006526e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.0262846825435270477704244292321769064285e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.4835232648059678357271467528606053876578e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.2655068679437005170888660219850439152554e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.7935313074780013685145958980002177413786e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.2332967539017502369025727051703322615498e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.5843968997313991870914934159730561565150e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.4169564018118778511764076391747137051076e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.6802281576037077590505881136095998149437e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.0971587247717441062719286248380220998246e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.6582174855678533153387293835989144177102e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.4248574128684926417991151260580514985681e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.3413341242966266479286061544986302356567e+09) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.3204649225485968925883095288399708414812e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.6963628330446435863628019004618056869553e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.6583224856762366902878184511123866769865e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.9401815438368668219689134740036328422454e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.5277314056951366863962459797932923240429e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.2317231509592487162228109714755419185314e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.8601442356552372742754545954967847745426e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.3274742671506710776020433336526613205911e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.1063948211534593101635000327246082122488e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.7058421186490366009829380417806770905701e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(5.8342721733141727544987241053090754416764e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(6.2836801945226919604001502621095396598582e+10) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.0409184326111715725563156084092175423594e+11) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.9773642635631058910183704706903300109142e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.7779799647739456276962321545728170148797e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.2410444147428115420485267885685178843821e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.8293188068636552884015355654846809070397e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.2046877973035957427847487321834558980145e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.9103717281474809369250601713966479655333e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(4.1330215808605158296283331892520915150085e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(6.0242621482495476765392135431537684535319e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.7632250712887907390445771580424742468222e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.5781640084037039625150632766281350203762e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.1516756925327535701100808706965658851526e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.6987882817791239145617039305797409826611e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.0473321764874075343075679390470630303717e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.6310801803385542440242358828258245582242e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.8378096658543577361319407308905563208875e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(5.5937973098476370606110574867753258712667e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-1.1469090529959748722763243807179399763598e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-1.0699969909808962271611844605864570719232e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-4.7736738929055901053741899567191527443206e+06) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.1125726814275272124782478193898364695459e+06) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(8.5694545577756893212232504091745585314925e+06) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.5186876648206209974247769995626317520557e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.6050448698777906595811841522367469061721e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.3384466144652254556398095463325756199568e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.8236480587518765857682964686733715940673e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.6357593590673400036240677295989090707101e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.1847673411142415959270743317535176362131e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.6622798305459602910964512613940930691155e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.0061848177862902672321196725949021528931e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.5718278826836041837508270186289444110446e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.7764463435305405316323445299919531292634e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-5.5160243818330145539415868034615921513450e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.3606292174252872978953069841105294975474e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.1369739877764999795779952763733922490745e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.4098490489435815109260914173960570348824e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-1.9804951327754478306988633314223789066658e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.3901514197148706397835212952541580388040e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-4.2550431913774940350054131837097339293909e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-4.4987639627407205403721023397974548742963e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-6.5707285313610983441684317245049419441535e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.7588159779664486474529286201823592609406e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.3753890997970075992141274048598770050584e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.4148396855342953479899006289622273655520e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.4038443561396586084523448272136377210778e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-4.1075134234874720836449084019754533772883e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-7.3104318776090146719412572955895100609068e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-7.7289826123477617456902507938877941983917e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.1287031169357490860496274360319313292770e+08) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(6.0683246588821724854638248984579773253163e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.6642746178615261130338322227315011201197e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.5445229672398803880351756046214535505221e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.5877282622056354321449573466011832244764e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-4.3293736748954610120190269977536454159504e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-7.7051114291091414654858547414385184929808e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-8.1462425152713197271211662724952710240694e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.1896223882295735436750837372982658247869e+08) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.6761279475740102145534921813497989038999e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(8.0982960215581727138203955522309544515873e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.6370626127472265566062976088181220091651e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-5.1381994000916418084616075302526818667849e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-6.2000083255699682767672496536966175374243e+07) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-1.1032670104940655625237169410075062879009e+08) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-1.1664157063255511202731287188177089449876e+08) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-1.7032137854528280268054426078327641767977e+08) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.0337084183646363663619116794175701104508e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(9.8703956011814159461709300560439475646923e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.7691074241287532245487234286657543536059e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.4627451791416590607848391263903168463267e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(8.4518615273317149719798635883411322411440e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.2385335874575221013896854028226443902860e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.2851223534302738520990937393442821168321e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.6521828305353761569969708945305499059319e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.8537684532868485872763880858689420488838e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(9.4088647035218209491870060111199172703245e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.4990697075634894273274978342700217148753e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(7.1163148985974397066119352012766949983069e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(8.0594230982208245118163348572623908006030e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.1809892071475042945682649322931357174782e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.2254100837339583267713872269735753128828e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.5753885192205435924745895323270152010853e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(5.6281801152290051343668467800094093456131e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(5.3737844199203321636787436727834832428385e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.1385353593318060128048268262769548986313e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(4.0843492052499313296796504968314348027469e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(4.6249096494819471606006010115132165427809e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(6.7742289337582351399193526152392799688506e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(7.0287691734399266743958537353997861885091e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(9.0340697508365000305628986243013101020694e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(8.6253699895636451582776955082870837948628e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(8.2384538777214306730608642687649703639785e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(4.8349435238809207330160515504605470149535e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.0526465571492564273347875709581442787988e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(6.8612625767504894859969184767048769324482e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.0079882125583223397230489698381478494427e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.0461339860036421691867966491176766830051e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.3468015630184067268958385409798918230795e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(9.7259193440422531461163047909106258576140e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(9.2895551679920899323456975551919004296941e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(5.4511789670274624814161620276484546132600e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(6.8304619471759342671439264167937508581696e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(7.7427846139111823622474230834631173103766e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.1374103037986191226168355547298605481843e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.1804464440393059972144856059964035388532e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(1.5196561093119344225663931293259824306663e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.4082868716131810629858357524716444553192e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.3450707372069568396606410948593279819363e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(7.8904633290919803534678412474528963471698e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(9.9123965198234082608820367751335800310386e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.1235536181750857170849562183603809195631e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.6501648414404320756159872242516822860026e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.7125724647390536916739204459370071731428e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.2044512127604276750608361260322376473653e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.4597321711201008988291558804428760254268e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.3942038256167169244573514341745124056615e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(8.1784591745095481772651752061520369352365e+04) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.0276515865390743969823381803729844818918e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.1648183987474972050288682390295491586585e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(1.7107405332548913588945008884545373462061e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(1.7754363723199178206663129131470668653492e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.2853486758288011638662676205946411300829e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(1.8642073528724968437085411201493446997635e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(1.7804982068143920510802984352814043456092e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(1.0442611401101398620967180121219680666300e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(1.3140460589904266435657326350509334356165e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(1.4893781409954470189543604462332343496556e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.1871692073451287792025790322780233465583e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.2698603544683426245428246349755685429272e+05) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(2.9215938283817103738008461521428321683302e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-3.3293322367526707239449024200439453125000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-3.2533260141016216948628425598144531250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.4873921990330563858151435852050781250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.8275053333540563471615314483642578125000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(3.0091022522962884977459907531738281250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.6427773398309363983571529388427734375000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.7106717090378515422344207763671875000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.2074527242133626714348793029785156250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-3.2533254514061263762414455413818359375000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-3.1790492119494592770934104919433593750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-2.4305488724814495071768760681152343750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.7633758883326663635671138763427734375000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.9408394665172090753912925720214843750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(3.5600914290247601456940174102783203125000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(3.6264404495269991457462310791015625000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(4.1119141956715611740946769714355468750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(-2.4873914170259376987814903259277343750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(-2.4305485290975775569677352905273437500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(-1.8577284560573752969503402709960937500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(2.1171319467708235606551170349121093750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(2.2529431073775049299001693725585937500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(2.7268506471469299867749214172363281250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(2.7776269110525026917457580566406250000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(3.1491552752524148672819137573242187500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(2.8275059469984262250363826751708984375000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.7633769627747824415564537048339843750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.1171330655034398660063743591308593750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.3672231900304905138909816741943359375000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.5204425652831560000777244567871093750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.0550953644097899086773395538330078125000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.1123801074200309813022613525390625000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.5315308134228689596056938171386718750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.0091022812915616668760776519775390625000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(2.9408400002174312248826026916503906250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.2529438313940772786736488342285156250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-2.5204420386246056295931339263916015625000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-2.6835368417954305186867713928222656250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.2526495463374885730445384979248046875000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-3.3136264552338980138301849365234375000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-3.7597926256788196042180061340332031250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.6427770302363205701112747192382812500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.5600917386193759739398956298828125000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.7268512663361616432666778564453125000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.0550944356259424239397048950195312500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.2526492367428727447986602783203125000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-3.9420087072660680860280990600585937500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-4.0158693139534443616867065429687500000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-4.5563051056140102446079254150390625000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(3.7106713936571031808853149414062500000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(3.6264407649077475070953369140625000000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(2.7776275418139994144439697265625000000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.1123791612777858972549438476562500000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.3136261398531496524810791015625000000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-4.0158693139534443616867065429687500000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-4.0911103298515081405639648437500000000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-4.6416465333290398120880126953125000000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.2380790710449218750000000000000000000000e+01), SC_(4.2074517973227193579077720642089843750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-2.1871383666992187500000000000000000000000e+01), SC_(4.1119139971712138503789901733398437500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-1.6737960815429687500000000000000000000000e+01), SC_(3.1491555650194641202688217163085937500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(1.8883415222167968750000000000000000000000e+01), SC_(-3.5315292600396787747740745544433593750000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.0100509643554687500000000000000000000000e+01), SC_(-3.7597917567787226289510726928710937500000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4347511291503906250000000000000000000000e+01), SC_(-4.5563044864247785881161689758300781250000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.4802551269531250000000000000000000000000e+01), SC_(-4.6416459025675430893898010253906250000000e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(2.8132064819335937500000000000000000000000e+01), SC_(-5.2660864245600532740354537963867187500000e+02) }
   }};
//#undef SC_
