.\" dpkg manual page - dpkg-gencontrol(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006, 2012-2013, 2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gencontrol 1 %RELEASE_DATE% %VERSION% "dpkg suite"
.nh
.SH 名前
dpkg\-gencontrol \- Debian 制御ファイルの生成
.
.SH 書式
\fBdpkg\-gencontrol\fP [\fIoption\fP...]
.
.SH 説明
\fBdpkg\-gencontrol\fP は展開された Debian ソースツリーから情報を読み取り、バイナリパッケージの control ファイル
(デフォルトでは debian/tmp/DEBIAN/control) を生成する。生成の過程で、関連するフィールドの単純化も行う。
.sp
Thus \fBPre\-Depends\fP, \fBDepends\fP, \fBRecommends\fP and \fBSuggests\fP are
simplified in this order by removing dependencies which are known to be true
according to the stronger dependencies already parsed. It will also remove
any self\-dependency (in fact it will remove any dependency which evaluates
to true given the current version of the package as installed). Logically it
keeps the intersection of multiple dependencies on the same package. The
order of dependencies is preserved as best as possible: if any dependency
must be discarded due to another dependency appearing further in the field,
the superseding dependency will take the place of the discarded one.
.sp
The other relation fields (\fBEnhances\fP, \fBConflicts\fP, \fBBreaks\fP, \fBReplaces\fP
and \fBProvides\fP)  are also simplified individually by computing the union of
the various dependencies when a package is listed multiple times in the
field.
.sp
\fBdpkg\-gencontrol\fP は \fBdebian/files\fP へのバイナリパッケージのエントリ追加も行う。
.
.SH オプション
.TP 
\fB\-v\fP\fIversion\fP
生成されるバイナリパッケージのバージョン番号を設定する。
.TP 
\fB\-V\fP\fIname\fP\fB=\fP\fIvalue\fP
変数を設定する。出力時の置換に関する詳細は、\fBdeb\-substvars\fP(5) を参照のこと。
.TP 
\fB\-T\fP\fIsubstvars\-file\fP
Read substitution variables in \fIsubstvars\-file\fP; the default is
\fBdebian/substvars\fP.  This option can be used multiple times to read
substitution variables from multiple files (since dpkg 1.15.6).
.TP 
\fB\-D\fP\fIfield\fP\fB=\fP\fIvalue\fP
出力制御ファイルのフィールドを上書きもしくは追加する。
.TP 
\fB\-U\fP\fIfield\fP
出力制御ファイルのフィールドを削除する。
.TP 
\fB\-c\fP\fIcontrol\-file\fP
情報の読み取り元となる主なソース制御ファイルを指定する。デフォルトは \fBdebian/control\fP。
.TP 
\fB\-l\fP\fIchangelog\-file\fP
情報の読み取り元となる changelog ファイルを指定する。デフォルトは \fBdebian/changelog\fP。
.TP 
\fB\-f\fP\fIfiles\-list\-file\fP
\fBdebian/files\fP の代わりにこのファイルに記載されたファイルのリストを読み書きする。
.TP 
\fB\-F\fP\fIchangelog\-format\fP
changelog ファイルのフォーマットを指定する。指定可能なフォーマットについての情報は、\fBdpkg\-parsechangelog\fP(1)
を参照のこと。
.TP 
\fB\-p\fP\fIpackage\fP
バイナリパッケージ \fIpackage\fP
の情報を生成する。ソース制御ファイルに単一のバイナリパッケージだけが記載されていた場合、このオプションは省略してもよい。それ以外の場合は、どのバイナリパッケージの情報を生成するかを選択する上で、このオプションが不可欠である。
.TP 
\fB\-n\fP\fIfilename\fP
通常の package_version_arch.deb というファイル名ではなく、パッケージのファイル名を \fIfilename\fP とする。
.TP 
\fB\-is\fP, \fB\-ip\fP, \fB\-isp\fP
These options are ignored for compatibility with older versions of the dpkg
build scripts but are now deprecated. Previously they were used to tell
\fBdpkg\-gencontrol\fP to include the Section and Priority fields in the control
file. This is now the default behaviour. If you want to get the old
behaviour you can use the \fB\-U\fP option to delete the fields from the control
file.
.TP 
\fB\-P\fP\fIpackage\-build\-dir\fP
\fBdpkg\-source\fP に対して、パッケージを \fBdebian/tmp\fP ではなく \fIpackage\-build\-dir\fP
内でビルドするように設定する。この値は \fBInstalled\-Size\fP 変数や制御ファイルフィールドの値のデフォルト値を (\fBdu\fP を用いて)
算出する際に用いられる他、出力ファイルのデフォルトの場所としても用いられる。
.TP 
\fB\-O\fP[\fIfilename\fP]
Print the control file to standard output (or \fIfilename\fP if specified,
since dpkg 1.17.2), rather than to \fBdebian/tmp/DEBIAN/control\fP (or
\fIpackage\-build\-dir\fP\fB/DEBIAN/control\fP if \fB\-P\fP was used).
.TP 
\fB\-?\fP, \fB\-\-help\fP
利用方法を表示して終了する。
.TP 
\fB\-\-version\fP
バージョン情報を表示して終了する。
.
.SH ファイル
.TP 
\fBdebian/control\fP
主たるソース制御情報ファイルであり、生成可能なソースパッケージおよびバイナリパッケージに関するバージョン非依存の情報を提供する。
.TP 
\fBdebian/files\fP
アップロードの準備の一部をなす、生成されたファイルのリスト。\fBdpkg\-gencontrol\fP
は、制御ファイルを生成したバイナリパッケージのファイル名を追加する。
.SH 関連項目
.ad l
\fBdeb\-substvars\fP(5), \fBdeb\-src\-control\fP(5), \fBdeb\-changelog\fP(5),
\fBdeb\-control\fP(5).
.SH 翻訳者
高橋 基信 <monyo@monyo.com>.
喜瀬 浩 <kise@fuyuneko.jp>.
関戸 幸一 <sekido@mbox.kyoto-inet.or.jp>.
鍋谷 栄展 <nabe@debian.or.jp>.
倉澤 望 <nabetaro@debian.or.jp>.
石川 睦 <ishikawa@linux.or.jp>.
鵜飼 文敏 <ukai@debian.or.jp>.
中野 武雄 <nakano@apm.seikei.ac.jp>.
.SH 翻訳校正
Debian JP Documentation ML <debian-doc@debian.or.jp>.
