// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v3.21.12
// source: internal/proto/s2a/s2a.proto

package s2a_go_proto

import (
	common_go_proto "github.com/google/s2a-go/internal/proto/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AuthenticationMechanism struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Optional) Application may specify an identity associated to an
	// authentication mechanism. Otherwise, S2A assumes that the authentication
	// mechanism is associated with the default identity. If the default identity
	// cannot be determined, session setup fails.
	Identity *common_go_proto.Identity `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	// Types that are assignable to MechanismOneof:
	//
	//	*AuthenticationMechanism_Token
	MechanismOneof isAuthenticationMechanism_MechanismOneof `protobuf_oneof:"mechanism_oneof"`
}

func (x *AuthenticationMechanism) Reset() {
	*x = AuthenticationMechanism{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticationMechanism) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticationMechanism) ProtoMessage() {}

func (x *AuthenticationMechanism) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticationMechanism.ProtoReflect.Descriptor instead.
func (*AuthenticationMechanism) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{0}
}

func (x *AuthenticationMechanism) GetIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.Identity
	}
	return nil
}

func (m *AuthenticationMechanism) GetMechanismOneof() isAuthenticationMechanism_MechanismOneof {
	if m != nil {
		return m.MechanismOneof
	}
	return nil
}

func (x *AuthenticationMechanism) GetToken() string {
	if x, ok := x.GetMechanismOneof().(*AuthenticationMechanism_Token); ok {
		return x.Token
	}
	return ""
}

type isAuthenticationMechanism_MechanismOneof interface {
	isAuthenticationMechanism_MechanismOneof()
}

type AuthenticationMechanism_Token struct {
	// A token that the application uses to authenticate itself to the S2A.
	Token string `protobuf:"bytes,2,opt,name=token,proto3,oneof"`
}

func (*AuthenticationMechanism_Token) isAuthenticationMechanism_MechanismOneof() {}

type ClientSessionStartReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application protocols supported by the client, e.g., "grpc".
	ApplicationProtocols []string `protobuf:"bytes,1,rep,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	// (Optional) The minimum TLS version number that the S2A's handshaker module
	// will use to set up the session. If this field is not provided, S2A will use
	// the minimum version it supports.
	MinTlsVersion common_go_proto.TLSVersion `protobuf:"varint,2,opt,name=min_tls_version,json=minTlsVersion,proto3,enum=s2a.proto.TLSVersion" json:"min_tls_version,omitempty"`
	// (Optional) The maximum TLS version number that the S2A's handshaker module
	// will use to set up the session. If this field is not provided, S2A will use
	// the maximum version it supports.
	MaxTlsVersion common_go_proto.TLSVersion `protobuf:"varint,3,opt,name=max_tls_version,json=maxTlsVersion,proto3,enum=s2a.proto.TLSVersion" json:"max_tls_version,omitempty"`
	// The TLS ciphersuites that the client is willing to support.
	TlsCiphersuites []common_go_proto.Ciphersuite `protobuf:"varint,4,rep,packed,name=tls_ciphersuites,json=tlsCiphersuites,proto3,enum=s2a.proto.Ciphersuite" json:"tls_ciphersuites,omitempty"`
	// (Optional) Describes which server identities are acceptable by the client.
	// If target identities are provided and none of them matches the peer
	// identity of the server, session setup fails.
	TargetIdentities []*common_go_proto.Identity `protobuf:"bytes,5,rep,name=target_identities,json=targetIdentities,proto3" json:"target_identities,omitempty"`
	// (Optional) Application may specify a local identity. Otherwise, S2A chooses
	// the default local identity. If the default identity cannot be determined,
	// session setup fails.
	LocalIdentity *common_go_proto.Identity `protobuf:"bytes,6,opt,name=local_identity,json=localIdentity,proto3" json:"local_identity,omitempty"`
	// The target name that is used by S2A to configure SNI in the TLS handshake.
	// It is also used to perform server authorization check if avaiable. This
	// check is intended to verify that the peer authenticated identity is
	// authorized to run a service with the target name.
	// This field MUST only contain the host portion of the server address. It
	// MUST not contain the scheme or the port number. For example, if the server
	// address is dns://www.example.com:443, the value of this field should be
	// set to www.example.com.
	TargetName string `protobuf:"bytes,7,opt,name=target_name,json=targetName,proto3" json:"target_name,omitempty"`
}

func (x *ClientSessionStartReq) Reset() {
	*x = ClientSessionStartReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClientSessionStartReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientSessionStartReq) ProtoMessage() {}

func (x *ClientSessionStartReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientSessionStartReq.ProtoReflect.Descriptor instead.
func (*ClientSessionStartReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{1}
}

func (x *ClientSessionStartReq) GetApplicationProtocols() []string {
	if x != nil {
		return x.ApplicationProtocols
	}
	return nil
}

func (x *ClientSessionStartReq) GetMinTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MinTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *ClientSessionStartReq) GetMaxTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MaxTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *ClientSessionStartReq) GetTlsCiphersuites() []common_go_proto.Ciphersuite {
	if x != nil {
		return x.TlsCiphersuites
	}
	return nil
}

func (x *ClientSessionStartReq) GetTargetIdentities() []*common_go_proto.Identity {
	if x != nil {
		return x.TargetIdentities
	}
	return nil
}

func (x *ClientSessionStartReq) GetLocalIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.LocalIdentity
	}
	return nil
}

func (x *ClientSessionStartReq) GetTargetName() string {
	if x != nil {
		return x.TargetName
	}
	return ""
}

type ServerSessionStartReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application protocols supported by the server, e.g., "grpc".
	ApplicationProtocols []string `protobuf:"bytes,1,rep,name=application_protocols,json=applicationProtocols,proto3" json:"application_protocols,omitempty"`
	// (Optional) The minimum TLS version number that the S2A's handshaker module
	// will use to set up the session. If this field is not provided, S2A will use
	// the minimum version it supports.
	MinTlsVersion common_go_proto.TLSVersion `protobuf:"varint,2,opt,name=min_tls_version,json=minTlsVersion,proto3,enum=s2a.proto.TLSVersion" json:"min_tls_version,omitempty"`
	// (Optional) The maximum TLS version number that the S2A's handshaker module
	// will use to set up the session. If this field is not provided, S2A will use
	// the maximum version it supports.
	MaxTlsVersion common_go_proto.TLSVersion `protobuf:"varint,3,opt,name=max_tls_version,json=maxTlsVersion,proto3,enum=s2a.proto.TLSVersion" json:"max_tls_version,omitempty"`
	// The TLS ciphersuites that the server is willing to support.
	TlsCiphersuites []common_go_proto.Ciphersuite `protobuf:"varint,4,rep,packed,name=tls_ciphersuites,json=tlsCiphersuites,proto3,enum=s2a.proto.Ciphersuite" json:"tls_ciphersuites,omitempty"`
	// (Optional) A list of local identities supported by the server, if
	// specified. Otherwise, S2A chooses the default local identity. If the
	// default identity cannot be determined, session setup fails.
	LocalIdentities []*common_go_proto.Identity `protobuf:"bytes,5,rep,name=local_identities,json=localIdentities,proto3" json:"local_identities,omitempty"`
	// The byte representation of the first handshake message received from the
	// client peer. It is possible that this first message is split into multiple
	// chunks. In this case, the first chunk is sent using this field and the
	// following chunks are sent using the in_bytes field of SessionNextReq
	// Specifically, if the client peer is using S2A, this field contains the
	// bytes in the out_frames field of SessionResp message that the client peer
	// received from its S2A after initiating the handshake.
	InBytes []byte `protobuf:"bytes,6,opt,name=in_bytes,json=inBytes,proto3" json:"in_bytes,omitempty"`
}

func (x *ServerSessionStartReq) Reset() {
	*x = ServerSessionStartReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerSessionStartReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerSessionStartReq) ProtoMessage() {}

func (x *ServerSessionStartReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerSessionStartReq.ProtoReflect.Descriptor instead.
func (*ServerSessionStartReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{2}
}

func (x *ServerSessionStartReq) GetApplicationProtocols() []string {
	if x != nil {
		return x.ApplicationProtocols
	}
	return nil
}

func (x *ServerSessionStartReq) GetMinTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MinTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *ServerSessionStartReq) GetMaxTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.MaxTlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *ServerSessionStartReq) GetTlsCiphersuites() []common_go_proto.Ciphersuite {
	if x != nil {
		return x.TlsCiphersuites
	}
	return nil
}

func (x *ServerSessionStartReq) GetLocalIdentities() []*common_go_proto.Identity {
	if x != nil {
		return x.LocalIdentities
	}
	return nil
}

func (x *ServerSessionStartReq) GetInBytes() []byte {
	if x != nil {
		return x.InBytes
	}
	return nil
}

type SessionNextReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The byte representation of session setup, i.e., handshake messages.
	// Specifically:
	//   - All handshake messages sent from the server to the client.
	//   - All, except for the first, handshake messages sent from the client to
	//     the server. Note that the first message is communicated to S2A using the
	//     in_bytes field of ServerSessionStartReq.
	//
	// If the peer is using S2A, this field contains the bytes in the out_frames
	// field of SessionResp message that the peer received from its S2A.
	InBytes []byte `protobuf:"bytes,1,opt,name=in_bytes,json=inBytes,proto3" json:"in_bytes,omitempty"`
}

func (x *SessionNextReq) Reset() {
	*x = SessionNextReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionNextReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionNextReq) ProtoMessage() {}

func (x *SessionNextReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionNextReq.ProtoReflect.Descriptor instead.
func (*SessionNextReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{3}
}

func (x *SessionNextReq) GetInBytes() []byte {
	if x != nil {
		return x.InBytes
	}
	return nil
}

type ResumptionTicketReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The byte representation of a NewSessionTicket message received from the
	// server.
	InBytes [][]byte `protobuf:"bytes,1,rep,name=in_bytes,json=inBytes,proto3" json:"in_bytes,omitempty"`
	// A connection identifier that was created and sent by S2A at the end of a
	// handshake.
	ConnectionId uint64 `protobuf:"varint,2,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// The local identity that was used by S2A during session setup and included
	// in |SessionResult|.
	LocalIdentity *common_go_proto.Identity `protobuf:"bytes,3,opt,name=local_identity,json=localIdentity,proto3" json:"local_identity,omitempty"`
}

func (x *ResumptionTicketReq) Reset() {
	*x = ResumptionTicketReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumptionTicketReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumptionTicketReq) ProtoMessage() {}

func (x *ResumptionTicketReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumptionTicketReq.ProtoReflect.Descriptor instead.
func (*ResumptionTicketReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{4}
}

func (x *ResumptionTicketReq) GetInBytes() [][]byte {
	if x != nil {
		return x.InBytes
	}
	return nil
}

func (x *ResumptionTicketReq) GetConnectionId() uint64 {
	if x != nil {
		return x.ConnectionId
	}
	return 0
}

func (x *ResumptionTicketReq) GetLocalIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.LocalIdentity
	}
	return nil
}

type SessionReq struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ReqOneof:
	//
	//	*SessionReq_ClientStart
	//	*SessionReq_ServerStart
	//	*SessionReq_Next
	//	*SessionReq_ResumptionTicket
	ReqOneof isSessionReq_ReqOneof `protobuf_oneof:"req_oneof"`
	// (Optional) The authentication mechanisms that the client wishes to use to
	// authenticate to the S2A, ordered by preference. The S2A will always use the
	// first authentication mechanism that appears in the list and is supported by
	// the S2A.
	AuthMechanisms []*AuthenticationMechanism `protobuf:"bytes,5,rep,name=auth_mechanisms,json=authMechanisms,proto3" json:"auth_mechanisms,omitempty"`
}

func (x *SessionReq) Reset() {
	*x = SessionReq{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionReq) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionReq) ProtoMessage() {}

func (x *SessionReq) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionReq.ProtoReflect.Descriptor instead.
func (*SessionReq) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{5}
}

func (m *SessionReq) GetReqOneof() isSessionReq_ReqOneof {
	if m != nil {
		return m.ReqOneof
	}
	return nil
}

func (x *SessionReq) GetClientStart() *ClientSessionStartReq {
	if x, ok := x.GetReqOneof().(*SessionReq_ClientStart); ok {
		return x.ClientStart
	}
	return nil
}

func (x *SessionReq) GetServerStart() *ServerSessionStartReq {
	if x, ok := x.GetReqOneof().(*SessionReq_ServerStart); ok {
		return x.ServerStart
	}
	return nil
}

func (x *SessionReq) GetNext() *SessionNextReq {
	if x, ok := x.GetReqOneof().(*SessionReq_Next); ok {
		return x.Next
	}
	return nil
}

func (x *SessionReq) GetResumptionTicket() *ResumptionTicketReq {
	if x, ok := x.GetReqOneof().(*SessionReq_ResumptionTicket); ok {
		return x.ResumptionTicket
	}
	return nil
}

func (x *SessionReq) GetAuthMechanisms() []*AuthenticationMechanism {
	if x != nil {
		return x.AuthMechanisms
	}
	return nil
}

type isSessionReq_ReqOneof interface {
	isSessionReq_ReqOneof()
}

type SessionReq_ClientStart struct {
	// The client session setup request message.
	ClientStart *ClientSessionStartReq `protobuf:"bytes,1,opt,name=client_start,json=clientStart,proto3,oneof"`
}

type SessionReq_ServerStart struct {
	// The server session setup request message.
	ServerStart *ServerSessionStartReq `protobuf:"bytes,2,opt,name=server_start,json=serverStart,proto3,oneof"`
}

type SessionReq_Next struct {
	// The next session setup message request message.
	Next *SessionNextReq `protobuf:"bytes,3,opt,name=next,proto3,oneof"`
}

type SessionReq_ResumptionTicket struct {
	// The resumption ticket that is received from the server. This message is
	// only accepted by S2A if it is running as a client and if it is received
	// after session setup is complete. If S2A is running as a server and it
	// receives this message, the session is terminated.
	ResumptionTicket *ResumptionTicketReq `protobuf:"bytes,4,opt,name=resumption_ticket,json=resumptionTicket,proto3,oneof"`
}

func (*SessionReq_ClientStart) isSessionReq_ReqOneof() {}

func (*SessionReq_ServerStart) isSessionReq_ReqOneof() {}

func (*SessionReq_Next) isSessionReq_ReqOneof() {}

func (*SessionReq_ResumptionTicket) isSessionReq_ReqOneof() {}

type SessionState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TLS version number that the S2A's handshaker module used to set up the
	// session.
	TlsVersion common_go_proto.TLSVersion `protobuf:"varint,1,opt,name=tls_version,json=tlsVersion,proto3,enum=s2a.proto.TLSVersion" json:"tls_version,omitempty"`
	// The TLS ciphersuite negotiated by the S2A's handshaker module.
	TlsCiphersuite common_go_proto.Ciphersuite `protobuf:"varint,2,opt,name=tls_ciphersuite,json=tlsCiphersuite,proto3,enum=s2a.proto.Ciphersuite" json:"tls_ciphersuite,omitempty"`
	// The sequence number of the next, incoming, TLS record.
	InSequence uint64 `protobuf:"varint,3,opt,name=in_sequence,json=inSequence,proto3" json:"in_sequence,omitempty"`
	// The sequence number of the next, outgoing, TLS record.
	OutSequence uint64 `protobuf:"varint,4,opt,name=out_sequence,json=outSequence,proto3" json:"out_sequence,omitempty"`
	// The key for the inbound direction.
	InKey []byte `protobuf:"bytes,5,opt,name=in_key,json=inKey,proto3" json:"in_key,omitempty"`
	// The key for the outbound direction.
	OutKey []byte `protobuf:"bytes,6,opt,name=out_key,json=outKey,proto3" json:"out_key,omitempty"`
	// The constant part of the record nonce for the outbound direction.
	InFixedNonce []byte `protobuf:"bytes,7,opt,name=in_fixed_nonce,json=inFixedNonce,proto3" json:"in_fixed_nonce,omitempty"`
	// The constant part of the record nonce for the inbound direction.
	OutFixedNonce []byte `protobuf:"bytes,8,opt,name=out_fixed_nonce,json=outFixedNonce,proto3" json:"out_fixed_nonce,omitempty"`
	// A connection identifier that can be provided to S2A to perform operations
	// related to this connection. This identifier will be stored by the record
	// protocol, and included in the |ResumptionTicketReq| message that is later
	// sent back to S2A. This field is set only for client-side connections.
	ConnectionId uint64 `protobuf:"varint,9,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// Set to true if a cached session was reused to do an abbreviated handshake.
	IsHandshakeResumed bool `protobuf:"varint,10,opt,name=is_handshake_resumed,json=isHandshakeResumed,proto3" json:"is_handshake_resumed,omitempty"`
}

func (x *SessionState) Reset() {
	*x = SessionState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionState) ProtoMessage() {}

func (x *SessionState) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionState.ProtoReflect.Descriptor instead.
func (*SessionState) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{6}
}

func (x *SessionState) GetTlsVersion() common_go_proto.TLSVersion {
	if x != nil {
		return x.TlsVersion
	}
	return common_go_proto.TLSVersion(0)
}

func (x *SessionState) GetTlsCiphersuite() common_go_proto.Ciphersuite {
	if x != nil {
		return x.TlsCiphersuite
	}
	return common_go_proto.Ciphersuite(0)
}

func (x *SessionState) GetInSequence() uint64 {
	if x != nil {
		return x.InSequence
	}
	return 0
}

func (x *SessionState) GetOutSequence() uint64 {
	if x != nil {
		return x.OutSequence
	}
	return 0
}

func (x *SessionState) GetInKey() []byte {
	if x != nil {
		return x.InKey
	}
	return nil
}

func (x *SessionState) GetOutKey() []byte {
	if x != nil {
		return x.OutKey
	}
	return nil
}

func (x *SessionState) GetInFixedNonce() []byte {
	if x != nil {
		return x.InFixedNonce
	}
	return nil
}

func (x *SessionState) GetOutFixedNonce() []byte {
	if x != nil {
		return x.OutFixedNonce
	}
	return nil
}

func (x *SessionState) GetConnectionId() uint64 {
	if x != nil {
		return x.ConnectionId
	}
	return 0
}

func (x *SessionState) GetIsHandshakeResumed() bool {
	if x != nil {
		return x.IsHandshakeResumed
	}
	return false
}

type SessionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application protocol negotiated for this session.
	ApplicationProtocol string `protobuf:"bytes,1,opt,name=application_protocol,json=applicationProtocol,proto3" json:"application_protocol,omitempty"`
	// The session state at the end. This state contains all cryptographic
	// material required to initialize the record protocol object.
	State *SessionState `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	// The authenticated identity of the peer.
	PeerIdentity *common_go_proto.Identity `protobuf:"bytes,4,opt,name=peer_identity,json=peerIdentity,proto3" json:"peer_identity,omitempty"`
	// The local identity used during session setup. This could be:
	//   - The local identity that the client specifies in ClientSessionStartReq.
	//   - One of the local identities that the server specifies in
	//     ServerSessionStartReq.
	//   - If neither client or server specifies local identities, the S2A picks the
	//     default one. In this case, this field will contain that identity.
	LocalIdentity *common_go_proto.Identity `protobuf:"bytes,5,opt,name=local_identity,json=localIdentity,proto3" json:"local_identity,omitempty"`
	// The SHA256 hash of the local certificate used in the handshake.
	LocalCertFingerprint []byte `protobuf:"bytes,6,opt,name=local_cert_fingerprint,json=localCertFingerprint,proto3" json:"local_cert_fingerprint,omitempty"`
	// The SHA256 hash of the peer certificate used in the handshake.
	PeerCertFingerprint []byte `protobuf:"bytes,7,opt,name=peer_cert_fingerprint,json=peerCertFingerprint,proto3" json:"peer_cert_fingerprint,omitempty"`
}

func (x *SessionResult) Reset() {
	*x = SessionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionResult) ProtoMessage() {}

func (x *SessionResult) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionResult.ProtoReflect.Descriptor instead.
func (*SessionResult) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{7}
}

func (x *SessionResult) GetApplicationProtocol() string {
	if x != nil {
		return x.ApplicationProtocol
	}
	return ""
}

func (x *SessionResult) GetState() *SessionState {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *SessionResult) GetPeerIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.PeerIdentity
	}
	return nil
}

func (x *SessionResult) GetLocalIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.LocalIdentity
	}
	return nil
}

func (x *SessionResult) GetLocalCertFingerprint() []byte {
	if x != nil {
		return x.LocalCertFingerprint
	}
	return nil
}

func (x *SessionResult) GetPeerCertFingerprint() []byte {
	if x != nil {
		return x.PeerCertFingerprint
	}
	return nil
}

type SessionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status code that is specific to the application and the implementation
	// of S2A, e.g., gRPC status code.
	Code uint32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// The status details.
	Details string `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *SessionStatus) Reset() {
	*x = SessionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionStatus) ProtoMessage() {}

func (x *SessionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionStatus.ProtoReflect.Descriptor instead.
func (*SessionStatus) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{8}
}

func (x *SessionStatus) GetCode() uint32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *SessionStatus) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

type SessionResp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The local identity used during session setup. This could be:
	//   - The local identity that the client specifies in ClientSessionStartReq.
	//   - One of the local identities that the server specifies in
	//     ServerSessionStartReq.
	//   - If neither client or server specifies local identities, the S2A picks the
	//     default one. In this case, this field will contain that identity.
	//
	// If the SessionResult is populated, then this must coincide with the local
	// identity specified in the SessionResult; otherwise, the handshake must
	// fail.
	LocalIdentity *common_go_proto.Identity `protobuf:"bytes,1,opt,name=local_identity,json=localIdentity,proto3" json:"local_identity,omitempty"`
	// The byte representation of the frames that should be sent to the peer. May
	// be empty if nothing needs to be sent to the peer or if in_bytes in the
	// SessionReq is incomplete. All bytes in a non-empty out_frames must be sent
	// to the peer even if the session setup status is not OK as these frames may
	// contain appropriate alerts.
	OutFrames []byte `protobuf:"bytes,2,opt,name=out_frames,json=outFrames,proto3" json:"out_frames,omitempty"`
	// Number of bytes in the in_bytes field that are consumed by S2A. It is
	// possible that part of in_bytes is unrelated to the session setup process.
	BytesConsumed uint32 `protobuf:"varint,3,opt,name=bytes_consumed,json=bytesConsumed,proto3" json:"bytes_consumed,omitempty"`
	// This is set if the session is successfully set up. out_frames may
	// still be set to frames that needs to be forwarded to the peer.
	Result *SessionResult `protobuf:"bytes,4,opt,name=result,proto3" json:"result,omitempty"`
	// Status of session setup at the current stage.
	Status *SessionStatus `protobuf:"bytes,5,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *SessionResp) Reset() {
	*x = SessionResp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_internal_proto_s2a_s2a_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SessionResp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionResp) ProtoMessage() {}

func (x *SessionResp) ProtoReflect() protoreflect.Message {
	mi := &file_internal_proto_s2a_s2a_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionResp.ProtoReflect.Descriptor instead.
func (*SessionResp) Descriptor() ([]byte, []int) {
	return file_internal_proto_s2a_s2a_proto_rawDescGZIP(), []int{9}
}

func (x *SessionResp) GetLocalIdentity() *common_go_proto.Identity {
	if x != nil {
		return x.LocalIdentity
	}
	return nil
}

func (x *SessionResp) GetOutFrames() []byte {
	if x != nil {
		return x.OutFrames
	}
	return nil
}

func (x *SessionResp) GetBytesConsumed() uint32 {
	if x != nil {
		return x.BytesConsumed
	}
	return 0
}

func (x *SessionResp) GetResult() *SessionResult {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *SessionResp) GetStatus() *SessionStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

var File_internal_proto_s2a_s2a_proto protoreflect.FileDescriptor

var file_internal_proto_s2a_s2a_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x73, 0x32, 0x61, 0x2f, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x09,
	0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x75, 0x0a,
	0x17, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x12, 0x2f, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x16, 0x0a, 0x05, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x42, 0x11, 0x0a, 0x0f, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x5f, 0x6f,
	0x6e, 0x65, 0x6f, 0x66, 0x22, 0xac, 0x03, 0x0a, 0x15, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x12, 0x33,
	0x0a, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x73, 0x12, 0x3d, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x73,
	0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x54, 0x6c, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x73, 0x32,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x54, 0x6c, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x41, 0x0a, 0x10, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73,
	0x75, 0x69, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x73, 0x32,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x52, 0x0f, 0x74, 0x6c, 0x73, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0xe8, 0x02, 0x0a, 0x15, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x12, 0x33, 0x0a,
	0x15, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x73, 0x12, 0x3d, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x73, 0x32,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x6d, 0x69, 0x6e, 0x54, 0x6c, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x3d, 0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x54, 0x6c, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x41, 0x0a, 0x10, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69,
	0x74, 0x65, 0x52, 0x0f, 0x74, 0x6c, 0x73, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69,
	0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x69, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x2b,
	0x0a, 0x0e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71,
	0x12, 0x19, 0x0a, 0x08, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x07, 0x69, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x91, 0x01, 0x0a, 0x13,
	0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x07, 0x69, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x32,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22,
	0xf4, 0x02, 0x0a, 0x0a, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x12, 0x45,
	0x0a, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x45, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73, 0x32,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52,
	0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x2f, 0x0a, 0x04,
	0x6e, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x73, 0x32, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x65,
	0x78, 0x74, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x04, 0x6e, 0x65, 0x78, 0x74, 0x12, 0x4d, 0x0a,
	0x11, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x65, 0x71, 0x48, 0x00, 0x52, 0x10, 0x72, 0x65, 0x73, 0x75,
	0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x4b, 0x0a, 0x0f,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x4d,
	0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x65, 0x71,
	0x5f, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x22, 0xa0, 0x03, 0x0a, 0x0c, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x0b, 0x74, 0x6c, 0x73, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x73,
	0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x6c, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x3f, 0x0a, 0x0f, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69, 0x74, 0x65,
	0x52, 0x0e, 0x74, 0x6c, 0x73, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x73, 0x75, 0x69, 0x74, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x69, 0x6e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x69, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x69, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x6f,
	0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x75,
	0x74, 0x4b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x69, 0x6e,
	0x46, 0x69, 0x78, 0x65, 0x64, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6f, 0x75,
	0x74, 0x5f, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x46, 0x69, 0x78, 0x65, 0x64, 0x4e, 0x6f, 0x6e,
	0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x69, 0x73, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x73, 0x68, 0x61, 0x6b, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x69, 0x73, 0x48, 0x61, 0x6e, 0x64, 0x73, 0x68, 0x61,
	0x6b, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x22, 0xd1, 0x02, 0x0a, 0x0d, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x31, 0x0a, 0x14, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x2d,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x38, 0x0a,
	0x0d, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x3a, 0x0a, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x46, 0x69,
	0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x65, 0x65,
	0x72, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x13, 0x70, 0x65, 0x65, 0x72, 0x43, 0x65,
	0x72, 0x74, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x3d, 0x0a,
	0x0d, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xf3, 0x01, 0x0a,
	0x0b, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x12, 0x3a, 0x0a, 0x0e,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x5f,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x6f, 0x75,
	0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x12, 0x30,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x30, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x18, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x32, 0x51, 0x0a, 0x0a, 0x53, 0x32, 0x41, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x43, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x55, 0x70, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x15, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x1a, 0x16, 0x2e, 0x73, 0x32, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x22,
	0x00, 0x28, 0x01, 0x30, 0x01, 0x42, 0x33, 0x5a, 0x31, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x32, 0x61, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x73, 0x32,
	0x61, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_internal_proto_s2a_s2a_proto_rawDescOnce sync.Once
	file_internal_proto_s2a_s2a_proto_rawDescData = file_internal_proto_s2a_s2a_proto_rawDesc
)

func file_internal_proto_s2a_s2a_proto_rawDescGZIP() []byte {
	file_internal_proto_s2a_s2a_proto_rawDescOnce.Do(func() {
		file_internal_proto_s2a_s2a_proto_rawDescData = protoimpl.X.CompressGZIP(file_internal_proto_s2a_s2a_proto_rawDescData)
	})
	return file_internal_proto_s2a_s2a_proto_rawDescData
}

var file_internal_proto_s2a_s2a_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_internal_proto_s2a_s2a_proto_goTypes = []interface{}{
	(*AuthenticationMechanism)(nil),  // 0: s2a.proto.AuthenticationMechanism
	(*ClientSessionStartReq)(nil),    // 1: s2a.proto.ClientSessionStartReq
	(*ServerSessionStartReq)(nil),    // 2: s2a.proto.ServerSessionStartReq
	(*SessionNextReq)(nil),           // 3: s2a.proto.SessionNextReq
	(*ResumptionTicketReq)(nil),      // 4: s2a.proto.ResumptionTicketReq
	(*SessionReq)(nil),               // 5: s2a.proto.SessionReq
	(*SessionState)(nil),             // 6: s2a.proto.SessionState
	(*SessionResult)(nil),            // 7: s2a.proto.SessionResult
	(*SessionStatus)(nil),            // 8: s2a.proto.SessionStatus
	(*SessionResp)(nil),              // 9: s2a.proto.SessionResp
	(*common_go_proto.Identity)(nil), // 10: s2a.proto.Identity
	(common_go_proto.TLSVersion)(0),  // 11: s2a.proto.TLSVersion
	(common_go_proto.Ciphersuite)(0), // 12: s2a.proto.Ciphersuite
}
var file_internal_proto_s2a_s2a_proto_depIdxs = []int32{
	10, // 0: s2a.proto.AuthenticationMechanism.identity:type_name -> s2a.proto.Identity
	11, // 1: s2a.proto.ClientSessionStartReq.min_tls_version:type_name -> s2a.proto.TLSVersion
	11, // 2: s2a.proto.ClientSessionStartReq.max_tls_version:type_name -> s2a.proto.TLSVersion
	12, // 3: s2a.proto.ClientSessionStartReq.tls_ciphersuites:type_name -> s2a.proto.Ciphersuite
	10, // 4: s2a.proto.ClientSessionStartReq.target_identities:type_name -> s2a.proto.Identity
	10, // 5: s2a.proto.ClientSessionStartReq.local_identity:type_name -> s2a.proto.Identity
	11, // 6: s2a.proto.ServerSessionStartReq.min_tls_version:type_name -> s2a.proto.TLSVersion
	11, // 7: s2a.proto.ServerSessionStartReq.max_tls_version:type_name -> s2a.proto.TLSVersion
	12, // 8: s2a.proto.ServerSessionStartReq.tls_ciphersuites:type_name -> s2a.proto.Ciphersuite
	10, // 9: s2a.proto.ServerSessionStartReq.local_identities:type_name -> s2a.proto.Identity
	10, // 10: s2a.proto.ResumptionTicketReq.local_identity:type_name -> s2a.proto.Identity
	1,  // 11: s2a.proto.SessionReq.client_start:type_name -> s2a.proto.ClientSessionStartReq
	2,  // 12: s2a.proto.SessionReq.server_start:type_name -> s2a.proto.ServerSessionStartReq
	3,  // 13: s2a.proto.SessionReq.next:type_name -> s2a.proto.SessionNextReq
	4,  // 14: s2a.proto.SessionReq.resumption_ticket:type_name -> s2a.proto.ResumptionTicketReq
	0,  // 15: s2a.proto.SessionReq.auth_mechanisms:type_name -> s2a.proto.AuthenticationMechanism
	11, // 16: s2a.proto.SessionState.tls_version:type_name -> s2a.proto.TLSVersion
	12, // 17: s2a.proto.SessionState.tls_ciphersuite:type_name -> s2a.proto.Ciphersuite
	6,  // 18: s2a.proto.SessionResult.state:type_name -> s2a.proto.SessionState
	10, // 19: s2a.proto.SessionResult.peer_identity:type_name -> s2a.proto.Identity
	10, // 20: s2a.proto.SessionResult.local_identity:type_name -> s2a.proto.Identity
	10, // 21: s2a.proto.SessionResp.local_identity:type_name -> s2a.proto.Identity
	7,  // 22: s2a.proto.SessionResp.result:type_name -> s2a.proto.SessionResult
	8,  // 23: s2a.proto.SessionResp.status:type_name -> s2a.proto.SessionStatus
	5,  // 24: s2a.proto.S2AService.SetUpSession:input_type -> s2a.proto.SessionReq
	9,  // 25: s2a.proto.S2AService.SetUpSession:output_type -> s2a.proto.SessionResp
	25, // [25:26] is the sub-list for method output_type
	24, // [24:25] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_internal_proto_s2a_s2a_proto_init() }
func file_internal_proto_s2a_s2a_proto_init() {
	if File_internal_proto_s2a_s2a_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_internal_proto_s2a_s2a_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticationMechanism); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClientSessionStartReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerSessionStartReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionNextReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumptionTicketReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionReq); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_internal_proto_s2a_s2a_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SessionResp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_internal_proto_s2a_s2a_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AuthenticationMechanism_Token)(nil),
	}
	file_internal_proto_s2a_s2a_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*SessionReq_ClientStart)(nil),
		(*SessionReq_ServerStart)(nil),
		(*SessionReq_Next)(nil),
		(*SessionReq_ResumptionTicket)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_internal_proto_s2a_s2a_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_internal_proto_s2a_s2a_proto_goTypes,
		DependencyIndexes: file_internal_proto_s2a_s2a_proto_depIdxs,
		MessageInfos:      file_internal_proto_s2a_s2a_proto_msgTypes,
	}.Build()
	File_internal_proto_s2a_s2a_proto = out.File
	file_internal_proto_s2a_s2a_proto_rawDesc = nil
	file_internal_proto_s2a_s2a_proto_goTypes = nil
	file_internal_proto_s2a_s2a_proto_depIdxs = nil
}
