// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
use shared::minwindef::{DWORD, UINT};
ENUM!{enum D3D10_SB_TOKENIZED_PROGRAM_TYPE {
    D3D10_SB_PIXEL_SHADER = 0,
    D3D10_SB_VERTEX_SHADER = 1,
    D3D10_SB_GEOMETRY_SHADER = 2,
    D3D11_SB_HULL_SHADER = 3,
    D3D11_SB_DOMAIN_SHADER = 4,
    D3D11_SB_COMPUTE_SHADER = 5,
    D3D11_SB_RESERVED0 = 0xFFF0,
}}
pub const D3D10_SB_TOKENIZED_PROGRAM_TYPE_MASK: DWORD = 0xffff0000;
pub const D3D10_SB_TOKENIZED_PROGRAM_TYPE_SHIFT: DWORD = 16;
#[inline]
pub fn DECODE_D3D10_SB_TOKENIZED_PROGRAM_TYPE(VerTok: DWORD) -> DWORD {
    (((VerTok & D3D10_SB_TOKENIZED_PROGRAM_TYPE_MASK) >> D3D10_SB_TOKENIZED_PROGRAM_TYPE_SHIFT)
        as D3D10_SB_TOKENIZED_PROGRAM_TYPE)
}
pub const D3D10_SB_TOKENIZED_PROGRAM_MAJOR_VERSION_MASK: DWORD = 0x000000f0;
pub const D3D10_SB_TOKENIZED_PROGRAM_MAJOR_VERSION_SHIFT: DWORD = 4;
pub const D3D10_SB_TOKENIZED_PROGRAM_MINOR_VERSION_MASK: DWORD = 0x0000000f;
#[inline]
pub fn DECODE_D3D10_SB_TOKENIZED_PROGRAM_MAJOR_VERSION(VerTok: DWORD) -> DWORD {
    ((VerTok & D3D10_SB_TOKENIZED_PROGRAM_MAJOR_VERSION_MASK)
        >> D3D10_SB_TOKENIZED_PROGRAM_MAJOR_VERSION_SHIFT)
}
#[inline]
pub fn DECODE_D3D10_SB_TOKENIZED_PROGRAM_MINOR_VERSION(VerTok: DWORD) -> DWORD {
    (VerTok & D3D10_SB_TOKENIZED_PROGRAM_MINOR_VERSION_MASK)
}
#[inline]
pub fn ENCODE_D3D10_SB_TOKENIZED_PROGRAM_VERSION_TOKEN(
    ProgType: DWORD,
    MajorVer: DWORD,
    MinorVer: DWORD,
) -> DWORD {
    ((ProgType << D3D10_SB_TOKENIZED_PROGRAM_TYPE_SHIFT) & D3D10_SB_TOKENIZED_PROGRAM_TYPE_MASK)
        | ((MajorVer << D3D10_SB_TOKENIZED_PROGRAM_MAJOR_VERSION_SHIFT)
        & D3D10_SB_TOKENIZED_PROGRAM_MAJOR_VERSION_MASK)
        | (MinorVer & D3D10_SB_TOKENIZED_PROGRAM_MINOR_VERSION_MASK)
}
#[inline]
pub fn DECODE_D3D10_SB_TOKENIZED_PROGRAM_LENGTH(LenTok: DWORD) -> DWORD {
    LenTok
}
#[inline]
pub fn ENCODE_D3D10_SB_TOKENIZED_PROGRAM_LENGTH(Length: DWORD) -> DWORD {
    Length
}
pub const MAX_D3D10_SB_TOKENIZED_PROGRAM_LENGTH: DWORD = 0xffffffff;
ENUM!{enum D3D10_SB_OPCODE_TYPE {
    D3D10_SB_OPCODE_ADD = 0,
    D3D10_SB_OPCODE_AND = 1,
    D3D10_SB_OPCODE_BREAK = 2,
    D3D10_SB_OPCODE_BREAKC = 3,
    D3D10_SB_OPCODE_CALL = 4,
    D3D10_SB_OPCODE_CALLC = 5,
    D3D10_SB_OPCODE_CASE = 6,
    D3D10_SB_OPCODE_CONTINUE = 7,
    D3D10_SB_OPCODE_CONTINUEC = 8,
    D3D10_SB_OPCODE_CUT = 9,
    D3D10_SB_OPCODE_DEFAULT = 10,
    D3D10_SB_OPCODE_DERIV_RTX = 11,
    D3D10_SB_OPCODE_DERIV_RTY = 12,
    D3D10_SB_OPCODE_DISCARD = 13,
    D3D10_SB_OPCODE_DIV = 14,
    D3D10_SB_OPCODE_DP2 = 15,
    D3D10_SB_OPCODE_DP3 = 16,
    D3D10_SB_OPCODE_DP4 = 17,
    D3D10_SB_OPCODE_ELSE = 18,
    D3D10_SB_OPCODE_EMIT = 19,
    D3D10_SB_OPCODE_EMITTHENCUT = 20,
    D3D10_SB_OPCODE_ENDIF = 21,
    D3D10_SB_OPCODE_ENDLOOP = 22,
    D3D10_SB_OPCODE_ENDSWITCH = 23,
    D3D10_SB_OPCODE_EQ = 24,
    D3D10_SB_OPCODE_EXP = 25,
    D3D10_SB_OPCODE_FRC = 26,
    D3D10_SB_OPCODE_FTOI = 27,
    D3D10_SB_OPCODE_FTOU = 28,
    D3D10_SB_OPCODE_GE = 29,
    D3D10_SB_OPCODE_IADD = 30,
    D3D10_SB_OPCODE_IF = 31,
    D3D10_SB_OPCODE_IEQ = 32,
    D3D10_SB_OPCODE_IGE = 33,
    D3D10_SB_OPCODE_ILT = 34,
    D3D10_SB_OPCODE_IMAD = 35,
    D3D10_SB_OPCODE_IMAX = 36,
    D3D10_SB_OPCODE_IMIN = 37,
    D3D10_SB_OPCODE_IMUL = 38,
    D3D10_SB_OPCODE_INE = 39,
    D3D10_SB_OPCODE_INEG = 40,
    D3D10_SB_OPCODE_ISHL = 41,
    D3D10_SB_OPCODE_ISHR = 42,
    D3D10_SB_OPCODE_ITOF = 43,
    D3D10_SB_OPCODE_LABEL = 44,
    D3D10_SB_OPCODE_LD = 45,
    D3D10_SB_OPCODE_LD_MS = 46,
    D3D10_SB_OPCODE_LOG = 47,
    D3D10_SB_OPCODE_LOOP = 48,
    D3D10_SB_OPCODE_LT = 49,
    D3D10_SB_OPCODE_MAD = 50,
    D3D10_SB_OPCODE_MIN = 51,
    D3D10_SB_OPCODE_MAX = 52,
    D3D10_SB_OPCODE_CUSTOMDATA = 53,
    D3D10_SB_OPCODE_MOV = 54,
    D3D10_SB_OPCODE_MOVC = 55,
    D3D10_SB_OPCODE_MUL = 56,
    D3D10_SB_OPCODE_NE = 57,
    D3D10_SB_OPCODE_NOP = 58,
    D3D10_SB_OPCODE_NOT = 59,
    D3D10_SB_OPCODE_OR = 60,
    D3D10_SB_OPCODE_RESINFO = 61,
    D3D10_SB_OPCODE_RET = 62,
    D3D10_SB_OPCODE_RETC = 63,
    D3D10_SB_OPCODE_ROUND_NE = 64,
    D3D10_SB_OPCODE_ROUND_NI = 65,
    D3D10_SB_OPCODE_ROUND_PI = 66,
    D3D10_SB_OPCODE_ROUND_Z = 67,
    D3D10_SB_OPCODE_RSQ = 68,
    D3D10_SB_OPCODE_SAMPLE = 69,
    D3D10_SB_OPCODE_SAMPLE_C = 70,
    D3D10_SB_OPCODE_SAMPLE_C_LZ = 71,
    D3D10_SB_OPCODE_SAMPLE_L = 72,
    D3D10_SB_OPCODE_SAMPLE_D = 73,
    D3D10_SB_OPCODE_SAMPLE_B = 74,
    D3D10_SB_OPCODE_SQRT = 75,
    D3D10_SB_OPCODE_SWITCH = 76,
    D3D10_SB_OPCODE_SINCOS = 77,
    D3D10_SB_OPCODE_UDIV = 78,
    D3D10_SB_OPCODE_ULT = 79,
    D3D10_SB_OPCODE_UGE = 80,
    D3D10_SB_OPCODE_UMUL = 81,
    D3D10_SB_OPCODE_UMAD = 82,
    D3D10_SB_OPCODE_UMAX = 83,
    D3D10_SB_OPCODE_UMIN = 84,
    D3D10_SB_OPCODE_USHR = 85,
    D3D10_SB_OPCODE_UTOF = 86,
    D3D10_SB_OPCODE_XOR = 87,
    D3D10_SB_OPCODE_DCL_RESOURCE = 88,
    D3D10_SB_OPCODE_DCL_CONSTANT_BUFFER = 89,
    D3D10_SB_OPCODE_DCL_SAMPLER = 90,
    D3D10_SB_OPCODE_DCL_INDEX_RANGE = 91,
    D3D10_SB_OPCODE_DCL_GS_OUTPUT_PRIMITIVE_TOPOLOGY = 92,
    D3D10_SB_OPCODE_DCL_GS_INPUT_PRIMITIVE = 93,
    D3D10_SB_OPCODE_DCL_MAX_OUTPUT_VERTEX_COUNT = 94,
    D3D10_SB_OPCODE_DCL_INPUT = 95,
    D3D10_SB_OPCODE_DCL_INPUT_SGV = 96,
    D3D10_SB_OPCODE_DCL_INPUT_SIV = 97,
    D3D10_SB_OPCODE_DCL_INPUT_PS = 98,
    D3D10_SB_OPCODE_DCL_INPUT_PS_SGV = 99,
    D3D10_SB_OPCODE_DCL_INPUT_PS_SIV = 100,
    D3D10_SB_OPCODE_DCL_OUTPUT = 101,
    D3D10_SB_OPCODE_DCL_OUTPUT_SGV = 102,
    D3D10_SB_OPCODE_DCL_OUTPUT_SIV = 103,
    D3D10_SB_OPCODE_DCL_TEMPS = 104,
    D3D10_SB_OPCODE_DCL_INDEXABLE_TEMP = 105,
    D3D10_SB_OPCODE_DCL_GLOBAL_FLAGS = 106,
    D3D10_SB_OPCODE_RESERVED0 = 107,
    D3D10_1_SB_OPCODE_LOD = 108,
    D3D10_1_SB_OPCODE_GATHER4 = 109,
    D3D10_1_SB_OPCODE_SAMPLE_POS = 110,
    D3D10_1_SB_OPCODE_SAMPLE_INFO = 111,
    D3D10_1_SB_OPCODE_RESERVED1 = 112,
    D3D11_SB_OPCODE_HS_DECLS = 113,
    D3D11_SB_OPCODE_HS_CONTROL_POINT_PHASE = 114,
    D3D11_SB_OPCODE_HS_FORK_PHASE = 115,
    D3D11_SB_OPCODE_HS_JOIN_PHASE = 116,
    D3D11_SB_OPCODE_EMIT_STREAM = 117,
    D3D11_SB_OPCODE_CUT_STREAM = 118,
    D3D11_SB_OPCODE_EMITTHENCUT_STREAM = 119,
    D3D11_SB_OPCODE_INTERFACE_CALL = 120,
    D3D11_SB_OPCODE_BUFINFO = 121,
    D3D11_SB_OPCODE_DERIV_RTX_COARSE = 122,
    D3D11_SB_OPCODE_DERIV_RTX_FINE = 123,
    D3D11_SB_OPCODE_DERIV_RTY_COARSE = 124,
    D3D11_SB_OPCODE_DERIV_RTY_FINE = 125,
    D3D11_SB_OPCODE_GATHER4_C = 126,
    D3D11_SB_OPCODE_GATHER4_PO = 127,
    D3D11_SB_OPCODE_GATHER4_PO_C = 128,
    D3D11_SB_OPCODE_RCP = 129,
    D3D11_SB_OPCODE_F32TOF16 = 130,
    D3D11_SB_OPCODE_F16TOF32 = 131,
    D3D11_SB_OPCODE_UADDC = 132,
    D3D11_SB_OPCODE_USUBB = 133,
    D3D11_SB_OPCODE_COUNTBITS = 134,
    D3D11_SB_OPCODE_FIRSTBIT_HI = 135,
    D3D11_SB_OPCODE_FIRSTBIT_LO = 136,
    D3D11_SB_OPCODE_FIRSTBIT_SHI = 137,
    D3D11_SB_OPCODE_UBFE = 138,
    D3D11_SB_OPCODE_IBFE = 139,
    D3D11_SB_OPCODE_BFI = 140,
    D3D11_SB_OPCODE_BFREV = 141,
    D3D11_SB_OPCODE_SWAPC = 142,
    D3D11_SB_OPCODE_DCL_STREAM = 143,
    D3D11_SB_OPCODE_DCL_FUNCTION_BODY = 144,
    D3D11_SB_OPCODE_DCL_FUNCTION_TABLE = 145,
    D3D11_SB_OPCODE_DCL_INTERFACE = 146,
    D3D11_SB_OPCODE_DCL_INPUT_CONTROL_POINT_COUNT = 147,
    D3D11_SB_OPCODE_DCL_OUTPUT_CONTROL_POINT_COUNT = 148,
    D3D11_SB_OPCODE_DCL_TESS_DOMAIN = 149,
    D3D11_SB_OPCODE_DCL_TESS_PARTITIONING = 150,
    D3D11_SB_OPCODE_DCL_TESS_OUTPUT_PRIMITIVE = 151,
    D3D11_SB_OPCODE_DCL_HS_MAX_TESSFACTOR = 152,
    D3D11_SB_OPCODE_DCL_HS_FORK_PHASE_INSTANCE_COUNT = 153,
    D3D11_SB_OPCODE_DCL_HS_JOIN_PHASE_INSTANCE_COUNT = 154,
    D3D11_SB_OPCODE_DCL_THREAD_GROUP = 155,
    D3D11_SB_OPCODE_DCL_UNORDERED_ACCESS_VIEW_TYPED = 156,
    D3D11_SB_OPCODE_DCL_UNORDERED_ACCESS_VIEW_RAW = 157,
    D3D11_SB_OPCODE_DCL_UNORDERED_ACCESS_VIEW_STRUCTURED = 158,
    D3D11_SB_OPCODE_DCL_THREAD_GROUP_SHARED_MEMORY_RAW = 159,
    D3D11_SB_OPCODE_DCL_THREAD_GROUP_SHARED_MEMORY_STRUCTURED = 160,
    D3D11_SB_OPCODE_DCL_RESOURCE_RAW = 161,
    D3D11_SB_OPCODE_DCL_RESOURCE_STRUCTURED = 162,
    D3D11_SB_OPCODE_LD_UAV_TYPED = 163,
    D3D11_SB_OPCODE_STORE_UAV_TYPED = 164,
    D3D11_SB_OPCODE_LD_RAW = 165,
    D3D11_SB_OPCODE_STORE_RAW = 166,
    D3D11_SB_OPCODE_LD_STRUCTURED = 167,
    D3D11_SB_OPCODE_STORE_STRUCTURED = 168,
    D3D11_SB_OPCODE_ATOMIC_AND = 169,
    D3D11_SB_OPCODE_ATOMIC_OR = 170,
    D3D11_SB_OPCODE_ATOMIC_XOR = 171,
    D3D11_SB_OPCODE_ATOMIC_CMP_STORE = 172,
    D3D11_SB_OPCODE_ATOMIC_IADD = 173,
    D3D11_SB_OPCODE_ATOMIC_IMAX = 174,
    D3D11_SB_OPCODE_ATOMIC_IMIN = 175,
    D3D11_SB_OPCODE_ATOMIC_UMAX = 176,
    D3D11_SB_OPCODE_ATOMIC_UMIN = 177,
    D3D11_SB_OPCODE_IMM_ATOMIC_ALLOC = 178,
    D3D11_SB_OPCODE_IMM_ATOMIC_CONSUME = 179,
    D3D11_SB_OPCODE_IMM_ATOMIC_IADD = 180,
    D3D11_SB_OPCODE_IMM_ATOMIC_AND = 181,
    D3D11_SB_OPCODE_IMM_ATOMIC_OR = 182,
    D3D11_SB_OPCODE_IMM_ATOMIC_XOR = 183,
    D3D11_SB_OPCODE_IMM_ATOMIC_EXCH = 184,
    D3D11_SB_OPCODE_IMM_ATOMIC_CMP_EXCH = 185,
    D3D11_SB_OPCODE_IMM_ATOMIC_IMAX = 186,
    D3D11_SB_OPCODE_IMM_ATOMIC_IMIN = 187,
    D3D11_SB_OPCODE_IMM_ATOMIC_UMAX = 188,
    D3D11_SB_OPCODE_IMM_ATOMIC_UMIN = 189,
    D3D11_SB_OPCODE_SYNC = 190,
    D3D11_SB_OPCODE_DADD = 191,
    D3D11_SB_OPCODE_DMAX = 192,
    D3D11_SB_OPCODE_DMIN = 193,
    D3D11_SB_OPCODE_DMUL = 194,
    D3D11_SB_OPCODE_DEQ = 195,
    D3D11_SB_OPCODE_DGE = 196,
    D3D11_SB_OPCODE_DLT = 197,
    D3D11_SB_OPCODE_DNE = 198,
    D3D11_SB_OPCODE_DMOV = 199,
    D3D11_SB_OPCODE_DMOVC = 200,
    D3D11_SB_OPCODE_DTOF = 201,
    D3D11_SB_OPCODE_FTOD = 202,
    D3D11_SB_OPCODE_EVAL_SNAPPED = 203,
    D3D11_SB_OPCODE_EVAL_SAMPLE_INDEX = 204,
    D3D11_SB_OPCODE_EVAL_CENTROID = 205,
    D3D11_SB_OPCODE_DCL_GS_INSTANCE_COUNT = 206,
    D3D11_SB_OPCODE_ABORT = 207,
    D3D11_SB_OPCODE_DEBUG_BREAK = 208,
    D3D11_SB_OPCODE_RESERVED0 = 209,
    D3D11_1_SB_OPCODE_DDIV = 210,
    D3D11_1_SB_OPCODE_DFMA = 211,
    D3D11_1_SB_OPCODE_DRCP = 212,
    D3D11_1_SB_OPCODE_MSAD = 213,
    D3D11_1_SB_OPCODE_DTOI = 214,
    D3D11_1_SB_OPCODE_DTOU = 215,
    D3D11_1_SB_OPCODE_ITOD = 216,
    D3D11_1_SB_OPCODE_UTOD = 217,
    D3D11_1_SB_OPCODE_RESERVED0 = 218,
    D3DWDDM1_3_SB_OPCODE_GATHER4_FEEDBACK = 219,
    D3DWDDM1_3_SB_OPCODE_GATHER4_C_FEEDBACK = 220,
    D3DWDDM1_3_SB_OPCODE_GATHER4_PO_FEEDBACK = 221,
    D3DWDDM1_3_SB_OPCODE_GATHER4_PO_C_FEEDBACK = 222,
    D3DWDDM1_3_SB_OPCODE_LD_FEEDBACK = 223,
    D3DWDDM1_3_SB_OPCODE_LD_MS_FEEDBACK = 224,
    D3DWDDM1_3_SB_OPCODE_LD_UAV_TYPED_FEEDBACK = 225,
    D3DWDDM1_3_SB_OPCODE_LD_RAW_FEEDBACK = 226,
    D3DWDDM1_3_SB_OPCODE_LD_STRUCTURED_FEEDBACK = 227,
    D3DWDDM1_3_SB_OPCODE_SAMPLE_L_FEEDBACK = 228,
    D3DWDDM1_3_SB_OPCODE_SAMPLE_C_LZ_FEEDBACK = 229,
    D3DWDDM1_3_SB_OPCODE_SAMPLE_CLAMP_FEEDBACK = 230,
    D3DWDDM1_3_SB_OPCODE_SAMPLE_B_CLAMP_FEEDBACK = 231,
    D3DWDDM1_3_SB_OPCODE_SAMPLE_D_CLAMP_FEEDBACK = 232,
    D3DWDDM1_3_SB_OPCODE_SAMPLE_C_CLAMP_FEEDBACK = 233,
    D3DWDDM1_3_SB_OPCODE_CHECK_ACCESS_FULLY_MAPPED = 234,
    D3DWDDM1_3_SB_OPCODE_RESERVED0 = 235,
    D3D10_SB_NUM_OPCODES = 236,
}}
pub const D3D10_SB_OPCODE_TYPE_MASK: DWORD = 0x00007ff;
#[inline]
pub fn DECODE_D3D10_SB_OPCODE_TYPE(OpcodeToken0: DWORD) -> D3D10_SB_OPCODE_TYPE {
    (OpcodeToken0 & D3D10_SB_OPCODE_TYPE_MASK) as D3D10_SB_OPCODE_TYPE
}
#[inline]
pub fn ENCODE_D3D10_SB_OPCODE_TYPE(OpcodeName: D3D10_SB_OPCODE_TYPE) -> DWORD {
    OpcodeName & D3D10_SB_OPCODE_TYPE_MASK
}
pub const D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH_MASK: DWORD = 0x7f000000;
pub const D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH_SHIFT: DWORD = 24;
#[inline]
pub fn DECODE_D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH(OpcodeToken0: DWORD) -> DWORD {
    (OpcodeToken0 & D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH_MASK)
        >> D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH_SHIFT
}
#[inline]
pub fn ENCODE_D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH(Length: DWORD) -> DWORD {
    (Length << D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH_SHIFT)
        & D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH_MASK
}
pub const MAX_D3D10_SB_TOKENIZED_INSTRUCTION_LENGTH: DWORD = 127;
pub const D3D10_SB_INSTRUCTION_SATURATE_MASK: DWORD = 0x00002000;
#[inline]
pub fn DECODE_IS_D3D10_SB_INSTRUCTION_SATURATE_ENABLED(OpcodeToken0: DWORD) -> DWORD {
    OpcodeToken0 & D3D10_SB_INSTRUCTION_SATURATE_MASK
}
#[inline]
pub fn ENCODE_D3D10_SB_INSTRUCTION_SATURATE(bSat: DWORD) -> DWORD {
    if bSat != 0 {
        D3D10_SB_INSTRUCTION_SATURATE_MASK
    } else {
        0
    }
}
ENUM!{enum D3D10_SB_INSTRUCTION_TEST_BOOLEAN {
    D3D10_SB_INSTRUCTION_TEST_ZERO = 0,
    D3D10_SB_INSTRUCTION_TEST_NONZERO = 1,
}}
pub const D3D10_SB_INSTRUCTION_TEST_BOOLEAN_MASK: DWORD = 0x00040000;
pub const D3D10_SB_INSTRUCTION_TEST_BOOLEAN_SHIFT: DWORD = 18;
#[inline]
pub fn DECODE_D3D10_SB_INSTRUCTION_TEST_BOOLEAN(
    OpcodeToken0: DWORD,
) -> D3D10_SB_INSTRUCTION_TEST_BOOLEAN {
    ((OpcodeToken0 & D3D10_SB_INSTRUCTION_TEST_BOOLEAN_MASK)
        >> D3D10_SB_INSTRUCTION_TEST_BOOLEAN_SHIFT) as D3D10_SB_INSTRUCTION_TEST_BOOLEAN
}
#[inline]
pub fn ENCODE_D3D10_SB_INSTRUCTION_TEST_BOOLEAN(
    Boolean: D3D10_SB_INSTRUCTION_TEST_BOOLEAN,
) -> DWORD {
    (Boolean << D3D10_SB_INSTRUCTION_TEST_BOOLEAN_SHIFT) & D3D10_SB_INSTRUCTION_TEST_BOOLEAN_MASK
}
pub const D3D11_SB_INSTRUCTION_PRECISE_VALUES_MASK: DWORD = 0x00780000;
pub const D3D11_SB_INSTRUCTION_PRECISE_VALUES_SHIFT: DWORD = 19;
#[inline]
pub fn DECODE_D3D11_SB_INSTRUCTION_PRECISE_VALUES(OpcodeToken0: DWORD) -> DWORD {
    (OpcodeToken0 & D3D11_SB_INSTRUCTION_PRECISE_VALUES_MASK)
        >> D3D11_SB_INSTRUCTION_PRECISE_VALUES_SHIFT
}
#[inline]
pub fn ENCODE_D3D11_SB_INSTRUCTION_PRECISE_VALUES(ComponentMask: DWORD) -> DWORD {
    (ComponentMask << D3D11_SB_INSTRUCTION_PRECISE_VALUES_SHIFT)
        & D3D11_SB_INSTRUCTION_PRECISE_VALUES_MASK
}
ENUM!{enum D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE {
    D3D10_SB_RESINFO_INSTRUCTION_RETURN_FLOAT = 0,
    D3D10_SB_RESINFO_INSTRUCTION_RETURN_RCPFLOAT = 1,
    D3D10_SB_RESINFO_INSTRUCTION_RETURN_UINT = 2,
}}
pub const D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE_MASK: DWORD = 0x00001800;
pub const D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE(
    OpcodeToken0: DWORD,
) -> D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE {
    ((OpcodeToken0 & D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE_MASK)
        >> D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE_SHIFT)
        as D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE
}
#[inline]
pub fn ENCODE_D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE(
    ReturnType: D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE,
) -> DWORD {
    (ReturnType << D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE_SHIFT)
        & D3D10_SB_RESINFO_INSTRUCTION_RETURN_TYPE_MASK
}
pub const D3D11_SB_SYNC_THREADS_IN_GROUP: DWORD = 0x00000800;
pub const D3D11_SB_SYNC_THREAD_GROUP_SHARED_MEMORY: DWORD = 0x00001000;
pub const D3D11_SB_SYNC_UNORDERED_ACCESS_VIEW_MEMORY_GROUP: DWORD = 0x00002000;
pub const D3D11_SB_SYNC_UNORDERED_ACCESS_VIEW_MEMORY_GLOBAL: DWORD = 0x00004000;
pub const D3D11_SB_SYNC_FLAGS_MASK: DWORD = 0x00007800;
#[inline]
pub fn DECODE_D3D11_SB_SYNC_FLAGS(OperandToken0: DWORD) -> DWORD {
    OperandToken0 & D3D11_SB_SYNC_FLAGS_MASK
}
#[inline]
pub fn ENCODE_D3D11_SB_SYNC_FLAGS(Flags: DWORD) -> DWORD {
    Flags & D3D11_SB_SYNC_FLAGS_MASK
}
pub const D3D10_SB_OPCODE_EXTENDED_MASK: DWORD = 0x80000000;
pub const D3D10_SB_OPCODE_EXTENDED_SHIFT: DWORD = 31;
#[inline]
pub fn DECODE_IS_D3D10_SB_OPCODE_EXTENDED(OpcodeToken0: DWORD) -> DWORD {
    (OpcodeToken0 & D3D10_SB_OPCODE_EXTENDED_MASK) >> D3D10_SB_OPCODE_EXTENDED_SHIFT
}
#[inline]
pub fn ENCODE_D3D10_SB_OPCODE_EXTENDED(bExtended: DWORD) -> DWORD {
    if bExtended != 0 {
        D3D10_SB_OPCODE_EXTENDED_MASK
    } else {
        0
    }
}
ENUM!{enum D3D10_SB_EXTENDED_OPCODE_TYPE {
    D3D10_SB_EXTENDED_OPCODE_EMPTY = 0,
    D3D10_SB_EXTENDED_OPCODE_SAMPLE_CONTROLS = 1,
    D3D11_SB_EXTENDED_OPCODE_RESOURCE_DIM = 2,
    D3D11_SB_EXTENDED_OPCODE_RESOURCE_RETURN_TYPE = 3,
}}
pub const D3D11_SB_MAX_SIMULTANEOUS_EXTENDED_OPCODES: DWORD = 3;
pub const D3D10_SB_EXTENDED_OPCODE_TYPE_MASK: DWORD = 0x0000003f;
#[inline]
pub fn DECODE_D3D10_SB_EXTENDED_OPCODE_TYPE(OpcodeToken1: DWORD) -> D3D10_SB_EXTENDED_OPCODE_TYPE {
    (OpcodeToken1 & D3D10_SB_EXTENDED_OPCODE_TYPE_MASK) as D3D10_SB_EXTENDED_OPCODE_TYPE
}
#[inline]
pub fn ENCODE_D3D10_SB_EXTENDED_OPCODE_TYPE(
    ExtOpcodeType: D3D10_SB_EXTENDED_OPCODE_TYPE,
) -> DWORD {
    ExtOpcodeType & D3D10_SB_EXTENDED_OPCODE_TYPE_MASK
}
ENUM!{enum D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_COORD {
    D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_U = 0,
    D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_V = 1,
    D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_W = 2,
}}
pub const D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_COORD_MASK: DWORD = 3;
#[inline]
pub fn D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_SHIFT(Coord: DWORD) -> DWORD {
    9 + 4 * (Coord & D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_COORD_MASK)
}
#[inline]
pub fn D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_MASK(Coord: DWORD) -> DWORD {
    0x0000000f << D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_SHIFT(Coord)
}
#[inline]
pub fn DECODE_IMMEDIATE_D3D10_SB_ADDRESS_OFFSET(
    Coord: DWORD,
    OpcodeToken1: DWORD,
) -> DWORD {
    (OpcodeToken1 & D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_MASK(Coord))
        >> D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_SHIFT(Coord)
}
#[inline]
pub fn ENCODE_IMMEDIATE_D3D10_SB_ADDRESS_OFFSET(
    Coord: DWORD,
    ImmediateOffset: DWORD,
) -> DWORD {
    (ImmediateOffset << D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_SHIFT(Coord))
        & D3D10_SB_IMMEDIATE_ADDRESS_OFFSET_MASK(Coord)
}
pub const D3D11_SB_EXTENDED_RESOURCE_DIMENSION_MASK: DWORD = 0x000007C0;
pub const D3D11_SB_EXTENDED_RESOURCE_DIMENSION_SHIFT: DWORD = 6;
#[inline]
pub fn DECODE_D3D11_SB_EXTENDED_RESOURCE_DIMENSION(
    OpcodeTokenN: DWORD,
) -> D3D10_SB_RESOURCE_DIMENSION {
    ((OpcodeTokenN & D3D11_SB_EXTENDED_RESOURCE_DIMENSION_MASK)
        >> D3D11_SB_EXTENDED_RESOURCE_DIMENSION_SHIFT) as D3D10_SB_RESOURCE_DIMENSION
}
#[inline]
pub fn ENCODE_D3D11_SB_EXTENDED_RESOURCE_DIMENSION(
    ResourceDim: D3D10_SB_RESOURCE_DIMENSION,
) -> DWORD {
    (ResourceDim << D3D11_SB_EXTENDED_RESOURCE_DIMENSION_SHIFT)
        & D3D11_SB_EXTENDED_RESOURCE_DIMENSION_MASK
}
pub const D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE_MASK: DWORD = 0x007FF800;
pub const D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE(OpcodeTokenN: DWORD) -> DWORD {
    (OpcodeTokenN & D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE_MASK)
        >> D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE_SHIFT
}
#[inline]
pub fn ENCODE_D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE(Stride: DWORD) -> DWORD {
    (Stride << D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE_SHIFT)
        & D3D11_SB_EXTENDED_RESOURCE_DIMENSION_STRUCTURE_STRIDE_MASK
}
pub const D3D10_SB_RESOURCE_RETURN_TYPE_MASK: DWORD = 0x0000000f;
pub const D3D10_SB_RESOURCE_RETURN_TYPE_NUMBITS: DWORD = 0x00000004;
pub const D3D11_SB_EXTENDED_RESOURCE_RETURN_TYPE_SHIFT: DWORD = 6;
#[inline]
pub fn DECODE_D3D11_SB_EXTENDED_RESOURCE_RETURN_TYPE(
    OpcodeTokenN: DWORD,
    Component: DWORD,
) -> DWORD {
    ((OpcodeTokenN >> (Component * D3D10_SB_RESOURCE_RETURN_TYPE_NUMBITS
        + D3D11_SB_EXTENDED_RESOURCE_RETURN_TYPE_SHIFT))
        & D3D10_SB_RESOURCE_RETURN_TYPE_MASK) as D3D10_SB_RESOURCE_RETURN_TYPE
}
#[inline]
pub fn ENCODE_D3D11_SB_EXTENDED_RESOURCE_RETURN_TYPE(
    ReturnType: DWORD,
    Component: DWORD,
) -> DWORD {
    (ReturnType & D3D10_SB_RESOURCE_RETURN_TYPE_MASK)
        << (Component * D3D10_SB_RESOURCE_RETURN_TYPE_NUMBITS
        + D3D11_SB_EXTENDED_RESOURCE_RETURN_TYPE_SHIFT)
}
ENUM!{enum D3D10_SB_CUSTOMDATA_CLASS {
    D3D10_SB_CUSTOMDATA_COMMENT = 0,
    D3D10_SB_CUSTOMDATA_DEBUGINFO = 1,
    D3D10_SB_CUSTOMDATA_OPAQUE = 2,
    D3D10_SB_CUSTOMDATA_DCL_IMMEDIATE_CONSTANT_BUFFER = 3,
    D3D11_SB_CUSTOMDATA_SHADER_MESSAGE = 4,
    D3D11_SB_CUSTOMDATA_SHADER_CLIP_PLANE_CONSTANT_MAPPINGS_FOR_DX9 = 5,
}}
pub const D3D10_SB_CUSTOMDATA_CLASS_MASK: DWORD = 0xfffff800;
pub const D3D10_SB_CUSTOMDATA_CLASS_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_CUSTOMDATA_CLASS(CustomDataDescTok: DWORD) -> D3D10_SB_CUSTOMDATA_CLASS {
    ((CustomDataDescTok & D3D10_SB_CUSTOMDATA_CLASS_MASK) >> D3D10_SB_CUSTOMDATA_CLASS_SHIFT)
        as D3D10_SB_CUSTOMDATA_CLASS
}
#[inline]
pub fn ENCODE_D3D10_SB_CUSTOMDATA_CLASS(CustomDataClass: D3D10_SB_CUSTOMDATA_CLASS) -> DWORD {
    ENCODE_D3D10_SB_OPCODE_TYPE(D3D10_SB_OPCODE_CUSTOMDATA)
        | ((CustomDataClass << D3D10_SB_CUSTOMDATA_CLASS_SHIFT) & D3D10_SB_CUSTOMDATA_CLASS_MASK)
}
ENUM!{enum D3D10_SB_OPERAND_NUM_COMPONENTS {
    D3D10_SB_OPERAND_0_COMPONENT = 0,
    D3D10_SB_OPERAND_1_COMPONENT = 1,
    D3D10_SB_OPERAND_4_COMPONENT = 2,
    D3D10_SB_OPERAND_N_COMPONENT = 3,
}}
pub const D3D10_SB_OPERAND_NUM_COMPONENTS_MASK: DWORD = 0x00000003;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_NUM_COMPONENTS(OperandToken0: DWORD) -> DWORD {
    (OperandToken0 & D3D10_SB_OPERAND_NUM_COMPONENTS_MASK) as D3D10_SB_OPERAND_NUM_COMPONENTS
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_NUM_COMPONENTS(NumComp: DWORD) -> DWORD {
    NumComp & D3D10_SB_OPERAND_NUM_COMPONENTS_MASK
}
ENUM!{enum D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE {
    D3D10_SB_OPERAND_4_COMPONENT_MASK_MODE = 0,
    D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE_MODE = 1,
    D3D10_SB_OPERAND_4_COMPONENT_SELECT_1_MODE = 2,
}}
pub const D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE_MASK: DWORD = 0x0000000c;
pub const D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE_SHIFT: DWORD = 2;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE(
    OperandToken0: DWORD,
) -> D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE {
    ((OperandToken0 & D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE_MASK)
        >> D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE_SHIFT)
        as D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE(
    SelectionMode: D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE,
) -> DWORD {
    (SelectionMode << D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE_SHIFT)
        & D3D10_SB_OPERAND_4_COMPONENT_SELECTION_MODE_MASK
}
ENUM!{enum D3D10_SB_4_COMPONENT_NAME {
    D3D10_SB_4_COMPONENT_X = 0,
    D3D10_SB_4_COMPONENT_Y = 1,
    D3D10_SB_4_COMPONENT_Z = 2,
    D3D10_SB_4_COMPONENT_W = 3,
    D3D10_SB_4_COMPONENT_R = 0,
    D3D10_SB_4_COMPONENT_G = 1,
    D3D10_SB_4_COMPONENT_B = 2,
    D3D10_SB_4_COMPONENT_A = 3,
}}
pub const D3D10_SB_4_COMPONENT_NAME_MASK: DWORD = 3;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_MASK: DWORD = 0x000000f0;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_SHIFT: DWORD = 4;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_X: DWORD = 0x00000010;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_Y: DWORD = 0x00000020;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_Z: DWORD = 0x00000040;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_W: DWORD = 0x00000080;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_R: DWORD = D3D10_SB_OPERAND_4_COMPONENT_MASK_X;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_G: DWORD = D3D10_SB_OPERAND_4_COMPONENT_MASK_Y;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_B: DWORD = D3D10_SB_OPERAND_4_COMPONENT_MASK_Z;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_A: DWORD = D3D10_SB_OPERAND_4_COMPONENT_MASK_W;
pub const D3D10_SB_OPERAND_4_COMPONENT_MASK_ALL: DWORD = D3D10_SB_OPERAND_4_COMPONENT_MASK_MASK;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_4_COMPONENT_MASK(OperandToken0: DWORD) -> DWORD {
    OperandToken0 & D3D10_SB_OPERAND_4_COMPONENT_MASK_MASK
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_4_COMPONENT_MASK(ComponentMask: DWORD) -> DWORD {
    ComponentMask & D3D10_SB_OPERAND_4_COMPONENT_MASK_MASK
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_MASK(ComponentName: DWORD) -> DWORD {
    (1 << (D3D10_SB_OPERAND_4_COMPONENT_MASK_SHIFT + ComponentName))
        & D3D10_SB_OPERAND_4_COMPONENT_MASK_MASK
}
pub const D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE_MASK: DWORD = 0x00000ff0;
pub const D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE_SHIFT: DWORD = 4;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE(OperandToken0: DWORD) -> DWORD {
    OperandToken0 & D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE_MASK
}
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE_SOURCE(
    OperandToken0: DWORD,
    DestComp: DWORD,
) -> D3D10_SB_4_COMPONENT_NAME {
    ((OperandToken0 >> (D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE_SHIFT + 2
        * (DestComp & D3D10_SB_4_COMPONENT_NAME_MASK)))
        & D3D10_SB_4_COMPONENT_NAME_MASK) as D3D10_SB_4_COMPONENT_NAME
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE(
    XSrc: DWORD,
    YSrc: DWORD,
    ZSrc: DWORD,
    WSrc: DWORD,
) -> DWORD {
    ((XSrc & D3D10_SB_4_COMPONENT_NAME_MASK)
        | ((YSrc & D3D10_SB_4_COMPONENT_NAME_MASK) << 2)
        | ((ZSrc & D3D10_SB_4_COMPONENT_NAME_MASK) << 4)
        | ((WSrc & D3D10_SB_4_COMPONENT_NAME_MASK) << 6))
        << D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE_SHIFT
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_NOSWIZZLE() -> DWORD {
    ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE(
        D3D10_SB_4_COMPONENT_X,
        D3D10_SB_4_COMPONENT_Y,
        D3D10_SB_4_COMPONENT_Z,
        D3D10_SB_4_COMPONENT_W,
    )
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATEX() -> DWORD {
    ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE(
        D3D10_SB_4_COMPONENT_X,
        D3D10_SB_4_COMPONENT_X,
        D3D10_SB_4_COMPONENT_X,
        D3D10_SB_4_COMPONENT_X,
    )
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATEY() -> DWORD {
    ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE(
        D3D10_SB_4_COMPONENT_Y,
        D3D10_SB_4_COMPONENT_Y,
        D3D10_SB_4_COMPONENT_Y,
        D3D10_SB_4_COMPONENT_Y,
    )
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATEZ() -> DWORD {
    ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE(
        D3D10_SB_4_COMPONENT_Z,
        D3D10_SB_4_COMPONENT_Z,
        D3D10_SB_4_COMPONENT_Z,
        D3D10_SB_4_COMPONENT_Z,
    )
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATEW() -> DWORD {
    ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SWIZZLE(
        D3D10_SB_4_COMPONENT_W,
        D3D10_SB_4_COMPONENT_W,
        D3D10_SB_4_COMPONENT_W,
        D3D10_SB_4_COMPONENT_W,
    )
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATERED() -> DWORD {
    D3D10_SB_OPERAND_4_COMPONENT_REPLICATEX()
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATEGREEN() -> DWORD {
    D3D10_SB_OPERAND_4_COMPONENT_REPLICATEY()
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATEBLUE() -> DWORD {
    D3D10_SB_OPERAND_4_COMPONENT_REPLICATEZ()
}
#[inline]
pub fn D3D10_SB_OPERAND_4_COMPONENT_REPLICATEALPHA() -> DWORD {
    D3D10_SB_OPERAND_4_COMPONENT_REPLICATEW()
}
pub const D3D10_SB_OPERAND_4_COMPONENT_SELECT_1_MASK: DWORD = 0x00000030;
pub const D3D10_SB_OPERAND_4_COMPONENT_SELECT_1_SHIFT: DWORD = 4;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_4_COMPONENT_SELECT_1(
    OperandToken0: DWORD,
) -> D3D10_SB_4_COMPONENT_NAME {
    ((OperandToken0 & D3D10_SB_OPERAND_4_COMPONENT_SELECT_1_MASK)
        >> D3D10_SB_OPERAND_4_COMPONENT_SELECT_1_SHIFT) as D3D10_SB_4_COMPONENT_NAME
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_4_COMPONENT_SELECT_1(
    SelectedComp: D3D10_SB_4_COMPONENT_NAME,
) -> DWORD {
    (SelectedComp << D3D10_SB_OPERAND_4_COMPONENT_SELECT_1_SHIFT)
        & D3D10_SB_OPERAND_4_COMPONENT_SELECT_1_MASK
}
ENUM!{enum D3D10_SB_OPERAND_TYPE {
    D3D10_SB_OPERAND_TYPE_TEMP = 0,
    D3D10_SB_OPERAND_TYPE_INPUT = 1,
    D3D10_SB_OPERAND_TYPE_OUTPUT = 2,
    D3D10_SB_OPERAND_TYPE_INDEXABLE_TEMP = 3,
    D3D10_SB_OPERAND_TYPE_IMMEDIATE32 = 4,
    D3D10_SB_OPERAND_TYPE_IMMEDIATE64 = 5,
    D3D10_SB_OPERAND_TYPE_SAMPLER = 6,
    D3D10_SB_OPERAND_TYPE_RESOURCE = 7,
    D3D10_SB_OPERAND_TYPE_CONSTANT_BUFFER= 8,
    D3D10_SB_OPERAND_TYPE_IMMEDIATE_CONSTANT_BUFFER= 9,
    D3D10_SB_OPERAND_TYPE_LABEL = 10,
    D3D10_SB_OPERAND_TYPE_INPUT_PRIMITIVEID = 11,
    D3D10_SB_OPERAND_TYPE_OUTPUT_DEPTH = 12,
    D3D10_SB_OPERAND_TYPE_NULL = 13,
    D3D10_SB_OPERAND_TYPE_RASTERIZER = 14,
    D3D10_SB_OPERAND_TYPE_OUTPUT_COVERAGE_MASK = 15,
    D3D11_SB_OPERAND_TYPE_STREAM = 16,
    D3D11_SB_OPERAND_TYPE_FUNCTION_BODY  = 17,
    D3D11_SB_OPERAND_TYPE_FUNCTION_TABLE = 18,
    D3D11_SB_OPERAND_TYPE_INTERFACE = 19,
    D3D11_SB_OPERAND_TYPE_FUNCTION_INPUT = 20,
    D3D11_SB_OPERAND_TYPE_FUNCTION_OUTPUT = 21,
    D3D11_SB_OPERAND_TYPE_OUTPUT_CONTROL_POINT_ID = 22,
    D3D11_SB_OPERAND_TYPE_INPUT_FORK_INSTANCE_ID = 23,
    D3D11_SB_OPERAND_TYPE_INPUT_JOIN_INSTANCE_ID = 24,
    D3D11_SB_OPERAND_TYPE_INPUT_CONTROL_POINT = 25,
    D3D11_SB_OPERAND_TYPE_OUTPUT_CONTROL_POINT = 26,
    D3D11_SB_OPERAND_TYPE_INPUT_PATCH_CONSTANT = 27,
    D3D11_SB_OPERAND_TYPE_INPUT_DOMAIN_POINT = 28,
    D3D11_SB_OPERAND_TYPE_THIS_POINTER = 29,
    D3D11_SB_OPERAND_TYPE_UNORDERED_ACCESS_VIEW = 30,
    D3D11_SB_OPERAND_TYPE_THREAD_GROUP_SHARED_MEMORY = 31,
    D3D11_SB_OPERAND_TYPE_INPUT_THREAD_ID = 32,
    D3D11_SB_OPERAND_TYPE_INPUT_THREAD_GROUP_ID = 33,
    D3D11_SB_OPERAND_TYPE_INPUT_THREAD_ID_IN_GROUP = 34,
    D3D11_SB_OPERAND_TYPE_INPUT_COVERAGE_MASK = 35,
    D3D11_SB_OPERAND_TYPE_INPUT_THREAD_ID_IN_GROUP_FLATTENED = 36,
    D3D11_SB_OPERAND_TYPE_INPUT_GS_INSTANCE_ID = 37,
    D3D11_SB_OPERAND_TYPE_OUTPUT_DEPTH_GREATER_EQUAL = 38,
    D3D11_SB_OPERAND_TYPE_OUTPUT_DEPTH_LESS_EQUAL = 39,
    D3D11_SB_OPERAND_TYPE_CYCLE_COUNTER = 40,
}}
pub const D3D10_SB_OPERAND_TYPE_MASK: DWORD = 0x000ff000;
pub const D3D10_SB_OPERAND_TYPE_SHIFT: DWORD = 12;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_TYPE(OperandToken0: DWORD) -> D3D10_SB_OPERAND_TYPE {
    ((OperandToken0 & D3D10_SB_OPERAND_TYPE_MASK) >> D3D10_SB_OPERAND_TYPE_SHIFT)
        as D3D10_SB_OPERAND_TYPE
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_TYPE(OperandType: D3D10_SB_OPERAND_TYPE) -> DWORD {
    (OperandType << D3D10_SB_OPERAND_TYPE_SHIFT) & D3D10_SB_OPERAND_TYPE_MASK
}
ENUM!{enum D3D10_SB_OPERAND_INDEX_DIMENSION {
    D3D10_SB_OPERAND_INDEX_0D = 0,
    D3D10_SB_OPERAND_INDEX_1D = 1,
    D3D10_SB_OPERAND_INDEX_2D = 2,
    D3D10_SB_OPERAND_INDEX_3D = 3,
}}
pub const D3D10_SB_OPERAND_INDEX_DIMENSION_MASK: DWORD = 0x00300000;
pub const D3D10_SB_OPERAND_INDEX_DIMENSION_SHIFT: DWORD = 20;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_INDEX_DIMENSION(
    OperandToken0: DWORD,
) -> D3D10_SB_OPERAND_INDEX_DIMENSION {
    ((OperandToken0 & D3D10_SB_OPERAND_INDEX_DIMENSION_MASK)
        >> D3D10_SB_OPERAND_INDEX_DIMENSION_SHIFT) as D3D10_SB_OPERAND_INDEX_DIMENSION
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_INDEX_DIMENSION(
    OperandIndexDim: D3D10_SB_OPERAND_INDEX_DIMENSION,
) -> DWORD {
    (OperandIndexDim << D3D10_SB_OPERAND_INDEX_DIMENSION_SHIFT)
        & D3D10_SB_OPERAND_INDEX_DIMENSION_MASK
}
ENUM!{enum D3D10_SB_OPERAND_INDEX_REPRESENTATION {
    D3D10_SB_OPERAND_INDEX_IMMEDIATE32 = 0,
    D3D10_SB_OPERAND_INDEX_IMMEDIATE64 = 1,
    D3D10_SB_OPERAND_INDEX_RELATIVE = 2,
    D3D10_SB_OPERAND_INDEX_IMMEDIATE32_PLUS_RELATIVE = 3,
    D3D10_SB_OPERAND_INDEX_IMMEDIATE64_PLUS_RELATIVE = 4,
}}
#[inline]
pub fn D3D10_SB_OPERAND_INDEX_REPRESENTATION_SHIFT(Dim: DWORD) -> DWORD {
    22 + 3 * (Dim & 3)
}
#[inline]
pub fn D3D10_SB_OPERAND_INDEX_REPRESENTATION_MASK(Dim: DWORD) -> DWORD {
    0x3 << D3D10_SB_OPERAND_INDEX_REPRESENTATION_SHIFT(Dim)
}
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_INDEX_REPRESENTATION(
    Dim: DWORD,
    OperandToken0: DWORD,
) -> D3D10_SB_OPERAND_INDEX_REPRESENTATION {
    ((OperandToken0 & D3D10_SB_OPERAND_INDEX_REPRESENTATION_MASK(Dim))
        >> D3D10_SB_OPERAND_INDEX_REPRESENTATION_SHIFT(Dim))
        as D3D10_SB_OPERAND_INDEX_REPRESENTATION
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_INDEX_REPRESENTATION(
    Dim: DWORD,
    IndexRepresentation: D3D10_SB_OPERAND_INDEX_REPRESENTATION,
) -> DWORD {
    (IndexRepresentation << D3D10_SB_OPERAND_INDEX_REPRESENTATION_SHIFT(Dim))
        & D3D10_SB_OPERAND_INDEX_REPRESENTATION_MASK(Dim)
}
pub const D3D10_SB_OPERAND_EXTENDED_MASK: DWORD = 0x80000000;
pub const D3D10_SB_OPERAND_EXTENDED_SHIFT: DWORD = 31;
#[inline]
pub fn DECODE_IS_D3D10_SB_OPERAND_EXTENDED(OperandToken0: DWORD) -> DWORD {
    (OperandToken0 & D3D10_SB_OPERAND_EXTENDED_MASK) >> D3D10_SB_OPERAND_EXTENDED_SHIFT
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_EXTENDED(bExtended: DWORD) -> DWORD {
    if bExtended != 0 {
        D3D10_SB_OPERAND_EXTENDED_MASK
    } else {
        0
    }
}
ENUM!{enum D3D10_SB_EXTENDED_OPERAND_TYPE {
    D3D10_SB_EXTENDED_OPERAND_EMPTY = 0,
    D3D10_SB_EXTENDED_OPERAND_MODIFIER = 1,
}}
pub const D3D10_SB_EXTENDED_OPERAND_TYPE_MASK: DWORD = 0x0000003f;
#[inline]
pub fn DECODE_D3D10_SB_EXTENDED_OPERAND_TYPE(
    OperandToken1: DWORD,
) -> D3D10_SB_EXTENDED_OPERAND_TYPE {
    (OperandToken1 & D3D10_SB_EXTENDED_OPERAND_TYPE_MASK) as D3D10_SB_EXTENDED_OPERAND_TYPE
}
#[inline]
pub fn ENCODE_D3D10_SB_EXTENDED_OPERAND_TYPE(
    ExtOperandType: D3D10_SB_EXTENDED_OPERAND_TYPE,
) -> DWORD {
    ExtOperandType & D3D10_SB_EXTENDED_OPERAND_TYPE_MASK
}
ENUM!{enum D3D10_SB_OPERAND_MODIFIER {
    D3D10_SB_OPERAND_MODIFIER_NONE = 0,
    D3D10_SB_OPERAND_MODIFIER_NEG = 1,
    D3D10_SB_OPERAND_MODIFIER_ABS = 2,
    D3D10_SB_OPERAND_MODIFIER_ABSNEG = 3,
}}
pub const D3D10_SB_OPERAND_MODIFIER_MASK: DWORD = 0x00003fc0;
pub const D3D10_SB_OPERAND_MODIFIER_SHIFT: DWORD = 6;
#[inline]
pub fn DECODE_D3D10_SB_OPERAND_MODIFIER(OperandToken1: DWORD) -> D3D10_SB_OPERAND_MODIFIER {
    ((OperandToken1 & D3D10_SB_OPERAND_MODIFIER_MASK) >> D3D10_SB_OPERAND_MODIFIER_SHIFT)
        as D3D10_SB_OPERAND_MODIFIER
}
#[inline]
pub fn ENCODE_D3D10_SB_EXTENDED_OPERAND_MODIFIER(SourceMod: D3D10_SB_OPERAND_MODIFIER) -> DWORD {
    ((SourceMod << D3D10_SB_OPERAND_MODIFIER_SHIFT) & D3D10_SB_OPERAND_MODIFIER_MASK)
        | ENCODE_D3D10_SB_EXTENDED_OPERAND_TYPE(D3D10_SB_EXTENDED_OPERAND_MODIFIER)
        | ENCODE_D3D10_SB_OPERAND_DOUBLE_EXTENDED(0)
}
ENUM!{enum D3D11_SB_OPERAND_MIN_PRECISION {
    D3D11_SB_OPERAND_MIN_PRECISION_DEFAULT = 0,
    D3D11_SB_OPERAND_MIN_PRECISION_FLOAT_16 = 1,
    D3D11_SB_OPERAND_MIN_PRECISION_FLOAT_2_8 = 2,
    D3D11_SB_OPERAND_MIN_PRECISION_SINT_16 = 4,
    D3D11_SB_OPERAND_MIN_PRECISION_UINT_16 = 5,
}}
pub const D3D11_SB_OPERAND_MIN_PRECISION_MASK: DWORD = 0x0001C000;
pub const D3D11_SB_OPERAND_MIN_PRECISION_SHIFT: DWORD = 14;
#[inline]
pub fn DECODE_D3D11_SB_OPERAND_MIN_PRECISION(
    OperandToken1: DWORD,
) -> D3D11_SB_OPERAND_MIN_PRECISION {
    ((OperandToken1 & D3D11_SB_OPERAND_MIN_PRECISION_MASK) >> D3D11_SB_OPERAND_MIN_PRECISION_SHIFT)
        as D3D11_SB_OPERAND_MIN_PRECISION
}
#[inline]
pub fn ENCODE_D3D11_SB_OPERAND_MIN_PRECISION(
    MinPrecision: D3D11_SB_OPERAND_MIN_PRECISION,
) -> DWORD {
    (MinPrecision << D3D11_SB_OPERAND_MIN_PRECISION_SHIFT) & D3D11_SB_OPERAND_MIN_PRECISION_MASK
}
pub const D3D10_SB_OPERAND_DOUBLE_EXTENDED_MASK: DWORD = 0x80000000;
pub const D3D10_SB_OPERAND_DOUBLE_EXTENDED_SHIFT: DWORD = 31;
#[inline]
pub fn DECODE_IS_D3D10_SB_OPERAND_DOUBLE_EXTENDED(OperandToken1: DWORD) -> DWORD {
    (OperandToken1 & D3D10_SB_OPERAND_DOUBLE_EXTENDED_MASK)
        >> D3D10_SB_OPERAND_DOUBLE_EXTENDED_SHIFT
}
#[inline]
pub fn ENCODE_D3D10_SB_OPERAND_DOUBLE_EXTENDED(bExtended: DWORD) -> DWORD {
    if bExtended != 0 {
        D3D10_SB_OPERAND_DOUBLE_EXTENDED_MASK
    } else {
        0
    }
}
pub const D3D10_SB_NAME_MASK: DWORD = 0x0000ffff;
#[inline]
pub fn DECODE_D3D10_SB_NAME(NameToken: DWORD) -> D3D10_SB_NAME {
    (NameToken & D3D10_SB_NAME_MASK) as D3D10_SB_NAME
}
#[inline]
pub fn ENCODE_D3D10_SB_NAME(Name: D3D10_SB_NAME) -> DWORD {
    Name & D3D10_SB_NAME_MASK
}
pub const D3D10_SB_GLOBAL_FLAG_REFACTORING_ALLOWED: DWORD = (1 << 11);
pub const D3D11_SB_GLOBAL_FLAG_ENABLE_DOUBLE_PRECISION_FLOAT_OPS: DWORD = (1 << 12);
pub const D3D11_SB_GLOBAL_FLAG_FORCE_EARLY_DEPTH_STENCIL: DWORD = (1 << 13);
pub const D3D11_SB_GLOBAL_FLAG_ENABLE_RAW_AND_STRUCTURED_BUFFERS: DWORD = (1 << 14);
pub const D3D11_1_SB_GLOBAL_FLAG_SKIP_OPTIMIZATION: DWORD = (1 << 15);
pub const D3D11_1_SB_GLOBAL_FLAG_ENABLE_MINIMUM_PRECISION: DWORD = (1 << 16);
pub const D3D11_1_SB_GLOBAL_FLAG_ENABLE_DOUBLE_EXTENSIONS: DWORD = (1 << 17);
pub const D3D11_1_SB_GLOBAL_FLAG_ENABLE_SHADER_EXTENSIONS: DWORD = (1 << 18);
pub const D3D10_SB_GLOBAL_FLAGS_MASK: DWORD = 0x00fff800;
#[inline]
pub fn DECODE_D3D10_SB_GLOBAL_FLAGS(OpcodeToken0: DWORD) -> DWORD {
    OpcodeToken0 & D3D10_SB_GLOBAL_FLAGS_MASK
}
#[inline]
pub fn ENCODE_D3D10_SB_GLOBAL_FLAGS(Flags: DWORD) -> DWORD {
    Flags & D3D10_SB_GLOBAL_FLAGS_MASK
}
pub const D3D10_SB_RESOURCE_DIMENSION_MASK: DWORD = 0x0000F800;
pub const D3D10_SB_RESOURCE_DIMENSION_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_RESOURCE_DIMENSION(OpcodeToken0: DWORD) -> D3D10_SB_RESOURCE_DIMENSION {
    ((OpcodeToken0 & D3D10_SB_RESOURCE_DIMENSION_MASK) >> D3D10_SB_RESOURCE_DIMENSION_SHIFT)
        as D3D10_SB_RESOURCE_DIMENSION
}
#[inline]
pub fn ENCODE_D3D10_SB_RESOURCE_DIMENSION(ResourceDim: D3D10_SB_RESOURCE_DIMENSION) -> DWORD {
    (ResourceDim << D3D10_SB_RESOURCE_DIMENSION_SHIFT) & D3D10_SB_RESOURCE_DIMENSION_MASK
}
pub const D3D10_SB_RESOURCE_SAMPLE_COUNT_MASK: DWORD = 0x07F0000;
pub const D3D10_SB_RESOURCE_SAMPLE_COUNT_SHIFT: DWORD = 16;
#[inline]
pub fn DECODE_D3D10_SB_RESOURCE_SAMPLE_COUNT(OpcodeToken0: DWORD) -> UINT {
    ((OpcodeToken0 & D3D10_SB_RESOURCE_SAMPLE_COUNT_MASK) >> D3D10_SB_RESOURCE_SAMPLE_COUNT_SHIFT)
        as UINT
}
#[inline]
pub fn ENCODE_D3D10_SB_RESOURCE_SAMPLE_COUNT(SampleCount: DWORD) -> DWORD {
    (if SampleCount > 127 { 127 } else { SampleCount } << D3D10_SB_RESOURCE_SAMPLE_COUNT_SHIFT)
        & D3D10_SB_RESOURCE_SAMPLE_COUNT_MASK
}
#[inline]
pub fn DECODE_D3D10_SB_RESOURCE_RETURN_TYPE(
    ResourceReturnTypeToken: D3D10_SB_RESOURCE_RETURN_TYPE,
    Component: DWORD,
) -> D3D10_SB_RESOURCE_RETURN_TYPE {
    ((ResourceReturnTypeToken >> (Component * D3D10_SB_RESOURCE_RETURN_TYPE_NUMBITS))
        & D3D10_SB_RESOURCE_RETURN_TYPE_MASK) as D3D10_SB_RESOURCE_RETURN_TYPE
}
#[inline]
pub fn ENCODE_D3D10_SB_RESOURCE_RETURN_TYPE(
    ReturnType: DWORD,
    Component: DWORD,
) -> D3D10_SB_RESOURCE_RETURN_TYPE {
    (ReturnType & D3D10_SB_RESOURCE_RETURN_TYPE_MASK)
        << (Component * D3D10_SB_RESOURCE_RETURN_TYPE_NUMBITS)
}
ENUM!{enum D3D10_SB_SAMPLER_MODE {
    D3D10_SB_SAMPLER_MODE_DEFAULT = 0,
    D3D10_SB_SAMPLER_MODE_COMPARISON = 1,
    D3D10_SB_SAMPLER_MODE_MONO = 2,
}}
pub const D3D10_SB_SAMPLER_MODE_MASK: DWORD = 0x00007800;
pub const D3D10_SB_SAMPLER_MODE_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_SAMPLER_MODE(OpcodeToken0: DWORD) -> D3D10_SB_SAMPLER_MODE {
    ((OpcodeToken0 & D3D10_SB_SAMPLER_MODE_MASK) >> D3D10_SB_SAMPLER_MODE_SHIFT)
        as D3D10_SB_SAMPLER_MODE
}
#[inline]
pub fn ENCODE_D3D10_SB_SAMPLER_MODE(SamplerMode: D3D10_SB_SAMPLER_MODE) -> DWORD {
    (SamplerMode << D3D10_SB_SAMPLER_MODE_SHIFT) & D3D10_SB_SAMPLER_MODE_MASK
}
pub const D3D10_SB_INPUT_INTERPOLATION_MODE_MASK: DWORD = 0x00007800;
pub const D3D10_SB_INPUT_INTERPOLATION_MODE_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_INPUT_INTERPOLATION_MODE(
    OpcodeToken0: DWORD,
) -> D3D10_SB_INTERPOLATION_MODE {
    ((OpcodeToken0 & D3D10_SB_INPUT_INTERPOLATION_MODE_MASK)
        >> D3D10_SB_INPUT_INTERPOLATION_MODE_SHIFT) as D3D10_SB_INTERPOLATION_MODE
}
#[inline]
pub fn ENCODE_D3D10_SB_INPUT_INTERPOLATION_MODE(
    InterpolationMode: D3D10_SB_INTERPOLATION_MODE,
) -> DWORD {
    (InterpolationMode << D3D10_SB_INPUT_INTERPOLATION_MODE_SHIFT)
        & D3D10_SB_INPUT_INTERPOLATION_MODE_MASK
}
ENUM!{enum D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN {
    D3D10_SB_CONSTANT_BUFFER_IMMEDIATE_INDEXED = 0,
    D3D10_SB_CONSTANT_BUFFER_DYNAMIC_INDEXED = 1,
}}
pub const D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN_MASK: DWORD = 0x00000800;
pub const D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN(
    OpcodeToken0: DWORD,
) -> D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN {
    ((OpcodeToken0 & D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN_MASK)
        >> D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN_SHIFT)
        as D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN
}
#[inline]
pub fn ENCODE_D3D10_SB_D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN(
    AccessPattern: D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN,
) -> DWORD {
    (AccessPattern << D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN_SHIFT)
        & D3D10_SB_CONSTANT_BUFFER_ACCESS_PATTERN_MASK
}
ENUM!{enum D3D11_SB_SHADER_MESSAGE_ID {
    D3D11_SB_SHADER_MESSAGE_ID_MESSAGE = 0x00200102,
    D3D11_SB_SHADER_MESSAGE_ID_ERROR = 0x00200103,
}}
ENUM!{enum D3D11_SB_SHADER_MESSAGE_FORMAT {
    D3D11_SB_SHADER_MESSAGE_FORMAT_ANSI_TEXT = 0,
    D3D11_SB_SHADER_MESSAGE_FORMAT_ANSI_PRINTF = 1,
}}
pub const D3D10_SB_GS_INPUT_PRIMITIVE_MASK: DWORD = 0x0001f800;
pub const D3D10_SB_GS_INPUT_PRIMITIVE_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_GS_INPUT_PRIMITIVE(OpcodeToken0: DWORD) -> D3D10_SB_PRIMITIVE {
    ((OpcodeToken0 & D3D10_SB_GS_INPUT_PRIMITIVE_MASK) >> D3D10_SB_GS_INPUT_PRIMITIVE_SHIFT)
        as D3D10_SB_PRIMITIVE
}
#[inline]
pub fn ENCODE_D3D10_SB_GS_INPUT_PRIMITIVE(Prim: D3D10_SB_PRIMITIVE) -> DWORD {
    (Prim << D3D10_SB_GS_INPUT_PRIMITIVE_SHIFT) & D3D10_SB_GS_INPUT_PRIMITIVE_MASK
}
pub const D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY_MASK: DWORD = 0x0001f800;
pub const D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY(
    OpcodeToken0: DWORD,
) -> D3D10_SB_PRIMITIVE_TOPOLOGY {
    ((OpcodeToken0 & D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY_MASK)
        >> D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY_SHIFT) as D3D10_SB_PRIMITIVE_TOPOLOGY
}
#[inline]
pub fn ENCODE_D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY(
    PrimTopology: D3D10_SB_PRIMITIVE_TOPOLOGY,
) -> DWORD {
    (PrimTopology << D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY_SHIFT)
        & D3D10_SB_GS_OUTPUT_PRIMITIVE_TOPOLOGY_MASK
}
pub const D3D11_SB_INPUT_CONTROL_POINT_COUNT_MASK: DWORD = 0x0001f800;
pub const D3D11_SB_INPUT_CONTROL_POINT_COUNT_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D11_SB_INPUT_CONTROL_POINT_COUNT(OpcodeToken0: DWORD) -> UINT {
    ((OpcodeToken0 & D3D11_SB_INPUT_CONTROL_POINT_COUNT_MASK)
        >> D3D11_SB_INPUT_CONTROL_POINT_COUNT_SHIFT) as UINT
}
#[inline]
pub fn ENCODE_D3D11_SB_INPUT_CONTROL_POINT_COUNT(Count: DWORD) -> DWORD {
    (Count << D3D11_SB_INPUT_CONTROL_POINT_COUNT_SHIFT) & D3D11_SB_INPUT_CONTROL_POINT_COUNT_MASK
}
pub const D3D11_SB_OUTPUT_CONTROL_POINT_COUNT_MASK: DWORD = 0x0001f800;
pub const D3D11_SB_OUTPUT_CONTROL_POINT_COUNT_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D11_SB_OUTPUT_CONTROL_POINT_COUNT(OpcodeToken0: DWORD) -> UINT {
    ((OpcodeToken0 & D3D11_SB_OUTPUT_CONTROL_POINT_COUNT_MASK)
        >> D3D11_SB_OUTPUT_CONTROL_POINT_COUNT_SHIFT) as UINT
}
#[inline]
pub fn ENCODE_D3D11_SB_OUTPUT_CONTROL_POINT_COUNT(Count: DWORD) -> DWORD {
    (Count << D3D11_SB_OUTPUT_CONTROL_POINT_COUNT_SHIFT) & D3D11_SB_OUTPUT_CONTROL_POINT_COUNT_MASK
}
ENUM!{enum D3D11_SB_TESSELLATOR_DOMAIN {
    D3D11_SB_TESSELLATOR_DOMAIN_UNDEFINED = 0,
    D3D11_SB_TESSELLATOR_DOMAIN_ISOLINE = 1,
    D3D11_SB_TESSELLATOR_DOMAIN_TRI = 2,
    D3D11_SB_TESSELLATOR_DOMAIN_QUAD = 3,
}}
pub const D3D11_SB_TESS_DOMAIN_MASK: DWORD = 0x00001800;
pub const D3D11_SB_TESS_DOMAIN_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D11_SB_TESS_DOMAIN(OpcodeToken0: DWORD) -> D3D11_SB_TESSELLATOR_DOMAIN {
    ((OpcodeToken0 & D3D11_SB_TESS_DOMAIN_MASK) >> D3D11_SB_TESS_DOMAIN_SHIFT)
        as D3D11_SB_TESSELLATOR_DOMAIN
}
#[inline]
pub fn ENCODE_D3D11_SB_TESS_DOMAIN(Domain: D3D11_SB_TESSELLATOR_DOMAIN) -> DWORD {
    (Domain << D3D11_SB_TESS_DOMAIN_SHIFT) & D3D11_SB_TESS_DOMAIN_MASK
}
ENUM!{enum D3D11_SB_TESSELLATOR_PARTITIONING {
    D3D11_SB_TESSELLATOR_PARTITIONING_UNDEFINED = 0,
    D3D11_SB_TESSELLATOR_PARTITIONING_INTEGER = 1,
    D3D11_SB_TESSELLATOR_PARTITIONING_POW2 = 2,
    D3D11_SB_TESSELLATOR_PARTITIONING_FRACTIONAL_ODD  = 3,
    D3D11_SB_TESSELLATOR_PARTITIONING_FRACTIONAL_EVEN = 4,
}}
pub const D3D11_SB_TESS_PARTITIONING_MASK: DWORD = 0x00003800;
pub const D3D11_SB_TESS_PARTITIONING_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D11_SB_TESS_PARTITIONING(
    OpcodeToken0: DWORD,
) -> D3D11_SB_TESSELLATOR_PARTITIONING {
    ((OpcodeToken0 & D3D11_SB_TESS_PARTITIONING_MASK) >> D3D11_SB_TESS_PARTITIONING_SHIFT)
        as D3D11_SB_TESSELLATOR_PARTITIONING
}
#[inline]
pub fn ENCODE_D3D11_SB_TESS_PARTITIONING(
    Partitioning: D3D11_SB_TESSELLATOR_PARTITIONING,
) -> DWORD {
    (Partitioning << D3D11_SB_TESS_PARTITIONING_SHIFT) & D3D11_SB_TESS_PARTITIONING_MASK
}
ENUM!{enum D3D11_SB_TESSELLATOR_OUTPUT_PRIMITIVE {
    D3D11_SB_TESSELLATOR_OUTPUT_UNDEFINED = 0,
    D3D11_SB_TESSELLATOR_OUTPUT_POINT = 1,
    D3D11_SB_TESSELLATOR_OUTPUT_LINE = 2,
    D3D11_SB_TESSELLATOR_OUTPUT_TRIANGLE_CW = 3,
    D3D11_SB_TESSELLATOR_OUTPUT_TRIANGLE_CCW = 4,
}}
pub const D3D11_SB_TESS_OUTPUT_PRIMITIVE_MASK: DWORD = 0x00003800;
pub const D3D11_SB_TESS_OUTPUT_PRIMITIVE_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D11_SB_TESS_OUTPUT_PRIMITIVE(
    OpcodeToken0: DWORD,
) -> D3D11_SB_TESSELLATOR_OUTPUT_PRIMITIVE {
    ((OpcodeToken0 & D3D11_SB_TESS_OUTPUT_PRIMITIVE_MASK) >> D3D11_SB_TESS_OUTPUT_PRIMITIVE_SHIFT)
        as D3D11_SB_TESSELLATOR_OUTPUT_PRIMITIVE
}
#[inline]
pub fn ENCODE_D3D11_SB_TESS_OUTPUT_PRIMITIVE(
    OutputPrimitive: D3D11_SB_TESSELLATOR_OUTPUT_PRIMITIVE,
) -> DWORD {
    (OutputPrimitive << D3D11_SB_TESS_OUTPUT_PRIMITIVE_SHIFT) & D3D11_SB_TESS_OUTPUT_PRIMITIVE_MASK
}
ENUM!{enum D3D10_SB_INTERPOLATION_MODE {
    D3D10_SB_INTERPOLATION_UNDEFINED = 0,
    D3D10_SB_INTERPOLATION_CONSTANT = 1,
    D3D10_SB_INTERPOLATION_LINEAR = 2,
    D3D10_SB_INTERPOLATION_LINEAR_CENTROID = 3,
    D3D10_SB_INTERPOLATION_LINEAR_NOPERSPECTIVE = 4,
    D3D10_SB_INTERPOLATION_LINEAR_NOPERSPECTIVE_CENTROID = 5,
    D3D10_SB_INTERPOLATION_LINEAR_SAMPLE = 6,
    D3D10_SB_INTERPOLATION_LINEAR_NOPERSPECTIVE_SAMPLE = 7,
}}
ENUM!{enum D3D10_SB_PRIMITIVE_TOPOLOGY {
    D3D10_SB_PRIMITIVE_TOPOLOGY_UNDEFINED = 0,
    D3D10_SB_PRIMITIVE_TOPOLOGY_POINTLIST = 1,
    D3D10_SB_PRIMITIVE_TOPOLOGY_LINELIST = 2,
    D3D10_SB_PRIMITIVE_TOPOLOGY_LINESTRIP = 3,
    D3D10_SB_PRIMITIVE_TOPOLOGY_TRIANGLELIST = 4,
    D3D10_SB_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP = 5,
    D3D10_SB_PRIMITIVE_TOPOLOGY_LINELIST_ADJ = 10,
    D3D10_SB_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ = 11,
    D3D10_SB_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ = 12,
    D3D10_SB_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ = 13,
}}
ENUM!{enum D3D10_SB_PRIMITIVE {
    D3D10_SB_PRIMITIVE_UNDEFINED = 0,
    D3D10_SB_PRIMITIVE_POINT = 1,
    D3D10_SB_PRIMITIVE_LINE = 2,
    D3D10_SB_PRIMITIVE_TRIANGLE = 3,
    D3D10_SB_PRIMITIVE_LINE_ADJ = 6,
    D3D10_SB_PRIMITIVE_TRIANGLE_ADJ = 7,
    D3D11_SB_PRIMITIVE_1_CONTROL_POINT_PATCH = 8,
    D3D11_SB_PRIMITIVE_2_CONTROL_POINT_PATCH = 9,
    D3D11_SB_PRIMITIVE_3_CONTROL_POINT_PATCH = 10,
    D3D11_SB_PRIMITIVE_4_CONTROL_POINT_PATCH = 11,
    D3D11_SB_PRIMITIVE_5_CONTROL_POINT_PATCH = 12,
    D3D11_SB_PRIMITIVE_6_CONTROL_POINT_PATCH = 13,
    D3D11_SB_PRIMITIVE_7_CONTROL_POINT_PATCH = 14,
    D3D11_SB_PRIMITIVE_8_CONTROL_POINT_PATCH = 15,
    D3D11_SB_PRIMITIVE_9_CONTROL_POINT_PATCH = 16,
    D3D11_SB_PRIMITIVE_10_CONTROL_POINT_PATCH = 17,
    D3D11_SB_PRIMITIVE_11_CONTROL_POINT_PATCH = 18,
    D3D11_SB_PRIMITIVE_12_CONTROL_POINT_PATCH = 19,
    D3D11_SB_PRIMITIVE_13_CONTROL_POINT_PATCH = 20,
    D3D11_SB_PRIMITIVE_14_CONTROL_POINT_PATCH = 21,
    D3D11_SB_PRIMITIVE_15_CONTROL_POINT_PATCH = 22,
    D3D11_SB_PRIMITIVE_16_CONTROL_POINT_PATCH = 23,
    D3D11_SB_PRIMITIVE_17_CONTROL_POINT_PATCH = 24,
    D3D11_SB_PRIMITIVE_18_CONTROL_POINT_PATCH = 25,
    D3D11_SB_PRIMITIVE_19_CONTROL_POINT_PATCH = 26,
    D3D11_SB_PRIMITIVE_20_CONTROL_POINT_PATCH = 27,
    D3D11_SB_PRIMITIVE_21_CONTROL_POINT_PATCH = 28,
    D3D11_SB_PRIMITIVE_22_CONTROL_POINT_PATCH = 29,
    D3D11_SB_PRIMITIVE_23_CONTROL_POINT_PATCH = 30,
    D3D11_SB_PRIMITIVE_24_CONTROL_POINT_PATCH = 31,
    D3D11_SB_PRIMITIVE_25_CONTROL_POINT_PATCH = 32,
    D3D11_SB_PRIMITIVE_26_CONTROL_POINT_PATCH = 33,
    D3D11_SB_PRIMITIVE_27_CONTROL_POINT_PATCH = 34,
    D3D11_SB_PRIMITIVE_28_CONTROL_POINT_PATCH = 35,
    D3D11_SB_PRIMITIVE_29_CONTROL_POINT_PATCH = 36,
    D3D11_SB_PRIMITIVE_30_CONTROL_POINT_PATCH = 37,
    D3D11_SB_PRIMITIVE_31_CONTROL_POINT_PATCH = 38,
    D3D11_SB_PRIMITIVE_32_CONTROL_POINT_PATCH = 39,
}}
ENUM!{enum D3D10_SB_COMPONENT_MASK {
    D3D10_SB_COMPONENT_MASK_X = 1,
    D3D10_SB_COMPONENT_MASK_Y = 2,
    D3D10_SB_COMPONENT_MASK_Z = 4,
    D3D10_SB_COMPONENT_MASK_W = 8,
    D3D10_SB_COMPONENT_MASK_R = 1,
    D3D10_SB_COMPONENT_MASK_G = 2,
    D3D10_SB_COMPONENT_MASK_B = 4,
    D3D10_SB_COMPONENT_MASK_A = 8,
    D3D10_SB_COMPONENT_MASK_ALL = 15,
}}
ENUM!{enum D3D10_SB_NAME {
    D3D10_SB_NAME_UNDEFINED = 0,
    D3D10_SB_NAME_POSITION = 1,
    D3D10_SB_NAME_CLIP_DISTANCE = 2,
    D3D10_SB_NAME_CULL_DISTANCE = 3,
    D3D10_SB_NAME_RENDER_TARGET_ARRAY_INDEX = 4,
    D3D10_SB_NAME_VIEWPORT_ARRAY_INDEX = 5,
    D3D10_SB_NAME_VERTEX_ID = 6,
    D3D10_SB_NAME_PRIMITIVE_ID = 7,
    D3D10_SB_NAME_INSTANCE_ID = 8,
    D3D10_SB_NAME_IS_FRONT_FACE = 9,
    D3D10_SB_NAME_SAMPLE_INDEX = 10,
    D3D11_SB_NAME_FINAL_QUAD_U_EQ_0_EDGE_TESSFACTOR = 11,
    D3D11_SB_NAME_FINAL_QUAD_V_EQ_0_EDGE_TESSFACTOR = 12,
    D3D11_SB_NAME_FINAL_QUAD_U_EQ_1_EDGE_TESSFACTOR = 13,
    D3D11_SB_NAME_FINAL_QUAD_V_EQ_1_EDGE_TESSFACTOR = 14,
    D3D11_SB_NAME_FINAL_QUAD_U_INSIDE_TESSFACTOR = 15,
    D3D11_SB_NAME_FINAL_QUAD_V_INSIDE_TESSFACTOR = 16,
    D3D11_SB_NAME_FINAL_TRI_U_EQ_0_EDGE_TESSFACTOR = 17,
    D3D11_SB_NAME_FINAL_TRI_V_EQ_0_EDGE_TESSFACTOR = 18,
    D3D11_SB_NAME_FINAL_TRI_W_EQ_0_EDGE_TESSFACTOR = 19,
    D3D11_SB_NAME_FINAL_TRI_INSIDE_TESSFACTOR = 20,
    D3D11_SB_NAME_FINAL_LINE_DETAIL_TESSFACTOR = 21,
    D3D11_SB_NAME_FINAL_LINE_DENSITY_TESSFACTOR = 22,
}}
ENUM!{enum D3D10_SB_RESOURCE_DIMENSION {
    D3D10_SB_RESOURCE_DIMENSION_UNKNOWN = 0,
    D3D10_SB_RESOURCE_DIMENSION_BUFFER = 1,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURE1D = 2,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURE2D = 3,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURE2DMS = 4,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURE3D = 5,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURECUBE = 6,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURE1DARRAY = 7,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURE2DARRAY = 8,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURE2DMSARRAY = 9,
    D3D10_SB_RESOURCE_DIMENSION_TEXTURECUBEARRAY = 10,
    D3D11_SB_RESOURCE_DIMENSION_RAW_BUFFER = 11,
    D3D11_SB_RESOURCE_DIMENSION_STRUCTURED_BUFFER = 12,
}}
ENUM!{enum D3D10_SB_RESOURCE_RETURN_TYPE {
    D3D10_SB_RETURN_TYPE_UNORM = 1,
    D3D10_SB_RETURN_TYPE_SNORM = 2,
    D3D10_SB_RETURN_TYPE_SINT = 3,
    D3D10_SB_RETURN_TYPE_UINT = 4,
    D3D10_SB_RETURN_TYPE_FLOAT = 5,
    D3D10_SB_RETURN_TYPE_MIXED = 6,
    D3D11_SB_RETURN_TYPE_DOUBLE = 7,
    D3D11_SB_RETURN_TYPE_CONTINUED = 8,
    D3D11_SB_RETURN_TYPE_UNUSED = 9,
}}
ENUM!{enum D3D10_SB_REGISTER_COMPONENT_TYPE {
    D3D10_SB_REGISTER_COMPONENT_UNKNOWN = 0,
    D3D10_SB_REGISTER_COMPONENT_UINT32 = 1,
    D3D10_SB_REGISTER_COMPONENT_SINT32 = 2,
    D3D10_SB_REGISTER_COMPONENT_FLOAT32 = 3,
}}
ENUM!{enum D3D10_SB_INSTRUCTION_RETURN_TYPE {
    D3D10_SB_INSTRUCTION_RETURN_FLOAT = 0,
    D3D10_SB_INSTRUCTION_RETURN_UINT = 1,
}}
pub const D3D10_SB_INSTRUCTION_RETURN_TYPE_MASK: DWORD = 0x00001800;
pub const D3D10_SB_INSTRUCTION_RETURN_TYPE_SHIFT: DWORD = 11;
#[inline]
pub fn DECODE_D3D10_SB_INSTRUCTION_RETURN_TYPE(
    OpcodeToken0: DWORD,
) -> D3D10_SB_INSTRUCTION_RETURN_TYPE {
    ((OpcodeToken0 & D3D10_SB_INSTRUCTION_RETURN_TYPE_MASK)
        >> D3D10_SB_INSTRUCTION_RETURN_TYPE_SHIFT) as D3D10_SB_INSTRUCTION_RETURN_TYPE
}
#[inline]
pub fn ENCODE_D3D10_SB_INSTRUCTION_RETURN_TYPE(
    ReturnType: D3D10_SB_INSTRUCTION_RETURN_TYPE,
) -> DWORD {
    (ReturnType << D3D10_SB_INSTRUCTION_RETURN_TYPE_SHIFT) & D3D10_SB_INSTRUCTION_RETURN_TYPE_MASK
}
pub const D3D11_SB_INTERFACE_INDEXED_BIT_MASK: DWORD = 0x00000800;
pub const D3D11_SB_INTERFACE_INDEXED_BIT_SHIFT: DWORD = 11;
pub const D3D11_SB_INTERFACE_TABLE_LENGTH_MASK: DWORD = 0x0000ffff;
pub const D3D11_SB_INTERFACE_TABLE_LENGTH_SHIFT: DWORD = 0;
pub const D3D11_SB_INTERFACE_ARRAY_LENGTH_MASK: DWORD = 0xffff0000;
pub const D3D11_SB_INTERFACE_ARRAY_LENGTH_SHIFT: DWORD = 16;
#[inline]
pub fn DECODE_D3D11_SB_INTERFACE_INDEXED_BIT(OpcodeToken0: DWORD) -> DWORD {
    if (OpcodeToken0 & D3D11_SB_INTERFACE_INDEXED_BIT_MASK) >> D3D11_SB_INTERFACE_INDEXED_BIT_SHIFT
        != 0 { 1 } else { 0 }
}
#[inline]
pub fn ENCODE_D3D11_SB_INTERFACE_INDEXED_BIT(IndexedBit: DWORD) -> DWORD {
    (IndexedBit << D3D11_SB_INTERFACE_INDEXED_BIT_SHIFT) & D3D11_SB_INTERFACE_INDEXED_BIT_MASK
}
#[inline]
pub fn DECODE_D3D11_SB_INTERFACE_TABLE_LENGTH(OpcodeToken0: DWORD) -> UINT {
    ((OpcodeToken0 & D3D11_SB_INTERFACE_TABLE_LENGTH_MASK)
        >> D3D11_SB_INTERFACE_TABLE_LENGTH_SHIFT) as UINT
}
#[inline]
pub fn ENCODE_D3D11_SB_INTERFACE_TABLE_LENGTH(TableLength: DWORD) -> DWORD {
    (TableLength << D3D11_SB_INTERFACE_TABLE_LENGTH_SHIFT) & D3D11_SB_INTERFACE_TABLE_LENGTH_MASK
}
#[inline]
pub fn DECODE_D3D11_SB_INTERFACE_ARRAY_LENGTH(OpcodeToken0: DWORD) -> UINT {
    ((OpcodeToken0 & D3D11_SB_INTERFACE_ARRAY_LENGTH_MASK)
        >> D3D11_SB_INTERFACE_ARRAY_LENGTH_SHIFT) as UINT
}
#[inline]
pub fn ENCODE_D3D11_SB_INTERFACE_ARRAY_LENGTH(ArrayLength: DWORD) -> DWORD {
    (ArrayLength << D3D11_SB_INTERFACE_ARRAY_LENGTH_SHIFT) & D3D11_SB_INTERFACE_ARRAY_LENGTH_MASK
}
pub const D3D11_SB_GLOBALLY_COHERENT_ACCESS: DWORD = 0x00010000;
pub const D3D11_SB_ACCESS_COHERENCY_MASK: DWORD = 0x00010000;
#[inline]
pub fn DECODE_D3D11_SB_ACCESS_COHERENCY_FLAGS(OperandToken0: DWORD) -> DWORD {
    OperandToken0 & D3D11_SB_ACCESS_COHERENCY_MASK
}
#[inline]
pub fn ENCODE_D3D11_SB_ACCESS_COHERENCY_FLAGS(Flags: DWORD) -> DWORD {
    Flags & D3D11_SB_ACCESS_COHERENCY_MASK
}
pub const D3D11_SB_UAV_HAS_ORDER_PRESERVING_COUNTER: DWORD = 0x00800000;
pub const D3D11_SB_UAV_FLAGS_MASK: DWORD = 0x00800000;
#[inline]
pub fn DECODE_D3D11_SB_UAV_FLAGS(OperandToken0: DWORD) -> DWORD {
    OperandToken0 & D3D11_SB_UAV_FLAGS_MASK
}
#[inline]
pub fn ENCODE_D3D11_SB_UAV_FLAGS(Flags: DWORD) -> DWORD {
    Flags & D3D11_SB_UAV_FLAGS_MASK
}
