/* gkr-keyring.c generated by valac 0.28.0, the Vala compiler
 * generated from gkr-keyring.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <libsecret/secret.h>
#include <gcr/gcr-base.h>
#include <glib/gi18n-lib.h>
#include "config.h"

#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_KEYRING_DELETER (seahorse_gkr_keyring_deleter_get_type ())
#define SEAHORSE_GKR_KEYRING_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleter))
#define SEAHORSE_GKR_KEYRING_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleterClass))
#define SEAHORSE_GKR_IS_KEYRING_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_KEYRING_DELETER))
#define SEAHORSE_GKR_IS_KEYRING_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_KEYRING_DELETER))
#define SEAHORSE_GKR_KEYRING_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleterClass))

typedef struct _SeahorseGkrKeyringDeleter SeahorseGkrKeyringDeleter;
typedef struct _SeahorseGkrKeyringDeleterClass SeahorseGkrKeyringDeleterClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _SeahorseGkrKeyringLockData SeahorseGkrKeyringLockData;
typedef struct _SeahorseGkrKeyringUnlockData SeahorseGkrKeyringUnlockData;
typedef struct _SeahorseGkrKeyringLoadData SeahorseGkrKeyringLoadData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
typedef struct _SeahorseGkrKeyringDeleterPrivate SeahorseGkrKeyringDeleterPrivate;
typedef struct _SeahorseGkrKeyringDeleterDeleteData SeahorseGkrKeyringDeleterDeleteData;

struct _SeahorseGkrKeyringPrivate {
	GHashTable* _items;
	GtkActionGroup* _actions;
};

struct _SeahorseGkrKeyringLockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrKeyring* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GList* objects;
	GDBusProxy* _tmp0_;
	SecretService* service;
	SecretService* _tmp1_;
	SecretService* _tmp2_;
	GList* locked;
	GCancellable* _tmp3_;
	GList* _tmp4_;
	guint _tmp5_;
	GError * _inner_error_;
};

struct _SeahorseGkrKeyringUnlockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrKeyring* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GList* objects;
	GDBusProxy* _tmp0_;
	SecretService* service;
	SecretService* _tmp1_;
	SecretService* _tmp2_;
	GList* unlocked;
	GCancellable* _tmp3_;
	GList* _tmp4_;
	guint _tmp5_;
	GError * _inner_error_;
};

struct _SeahorseGkrKeyringLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrKeyring* self;
	GCancellable* cancellable;
	gboolean result;
};

struct _Block5Data {
	int _ref_count_;
	SeahorseGkrKeyring* self;
	GtkWindow* parent;
	SecretService* service;
};

struct _Block6Data {
	int _ref_count_;
	SeahorseGkrKeyring* self;
	GtkWindow* parent;
	SecretService* service;
};

struct _SeahorseGkrKeyringDeleter {
	SeahorseDeleter parent_instance;
	SeahorseGkrKeyringDeleterPrivate * priv;
};

struct _SeahorseGkrKeyringDeleterClass {
	SeahorseDeleterClass parent_class;
};

struct _SeahorseGkrKeyringDeleterPrivate {
	SeahorseGkrKeyring* _keyring;
	GList* _objects;
};

struct _SeahorseGkrKeyringDeleterDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrKeyringDeleter* self;
	GCancellable* cancellable;
	gboolean result;
	SeahorseGkrKeyring* _tmp0_;
	GCancellable* _tmp1_;
	GError * _inner_error_;
};


static gpointer seahorse_gkr_keyring_parent_class = NULL;
static GcrCollectionIface* seahorse_gkr_keyring_gcr_collection_parent_iface = NULL;
static SeahorsePlaceIface* seahorse_gkr_keyring_seahorse_place_parent_iface = NULL;
static SeahorseDeletableIface* seahorse_gkr_keyring_seahorse_deletable_parent_iface = NULL;
static SeahorseLockableIface* seahorse_gkr_keyring_seahorse_lockable_parent_iface = NULL;
static SeahorseViewableIface* seahorse_gkr_keyring_seahorse_viewable_parent_iface = NULL;
static gpointer seahorse_gkr_keyring_deleter_parent_class = NULL;

#define SEAHORSE_GKR_KEYRING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyringPrivate))
enum  {
	SEAHORSE_GKR_KEYRING_DUMMY_PROPERTY,
	SEAHORSE_GKR_KEYRING_DESCRIPTION,
	SEAHORSE_GKR_KEYRING_URI,
	SEAHORSE_GKR_KEYRING_ICON,
	SEAHORSE_GKR_KEYRING_ACTIONS,
	SEAHORSE_GKR_KEYRING_IS_DEFAULT,
	SEAHORSE_GKR_KEYRING_LOCKABLE,
	SEAHORSE_GKR_KEYRING_UNLOCKABLE,
	SEAHORSE_GKR_KEYRING_DELETABLE
};
static void seahorse_gkr_keyring_on_keyring_default (GtkAction* action, SeahorseGkrKeyring* self);
static void _seahorse_gkr_keyring_on_keyring_default_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_gkr_keyring_on_keyring_password (GtkAction* action, SeahorseGkrKeyring* self);
static void _seahorse_gkr_keyring_on_keyring_password_gtk_action_callback (GtkAction* action, gpointer self);
static guint seahorse_gkr_keyring_real_get_length (GcrCollection* base);
static GList* seahorse_gkr_keyring_real_get_objects (GcrCollection* base);
static gboolean seahorse_gkr_keyring_real_contains (GcrCollection* base, GObject* obj);
static GtkWindow* seahorse_gkr_keyring_real_create_viewer (SeahorseViewable* base, GtkWindow* parent);
static SeahorseDeleter* seahorse_gkr_keyring_real_create_deleter (SeahorseDeletable* base);
SeahorseGkrKeyringDeleter* seahorse_gkr_keyring_deleter_new (SeahorseGkrKeyring* keyring);
SeahorseGkrKeyringDeleter* seahorse_gkr_keyring_deleter_construct (GType object_type, SeahorseGkrKeyring* keyring);
GType seahorse_gkr_keyring_deleter_get_type (void) G_GNUC_CONST;
static void seahorse_gkr_keyring_real_lock_data_free (gpointer _data);
static void seahorse_gkr_keyring_real_lock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_gkr_keyring_real_lock_co (SeahorseGkrKeyringLockData* _data_);
static void seahorse_gkr_keyring_lock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_gkr_keyring_refresh_collection (SeahorseGkrKeyring* self);
static void seahorse_gkr_keyring_real_unlock_data_free (gpointer _data);
static void seahorse_gkr_keyring_real_unlock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_gkr_keyring_real_unlock_co (SeahorseGkrKeyringUnlockData* _data_);
static void seahorse_gkr_keyring_unlock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void seahorse_gkr_keyring_real_load_data_free (gpointer _data);
static void seahorse_gkr_keyring_real_load (SeahorsePlace* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_gkr_keyring_real_load_co (SeahorseGkrKeyringLoadData* _data_);
static void _g_free0_ (gpointer var);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda4_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda18_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res);
static void ___lambda19_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res);
static void ____lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static GtkActionGroup* seahorse_gkr_keyring_create_actions (SeahorseGkrKeyring* self);
static GObject * seahorse_gkr_keyring_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_keyring___lambda33_ (SeahorseGkrKeyring* self, GParamSpec* pspec);
static void __seahorse_gkr_keyring___lambda33__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _seahorse_gkr_keyring___lambda34_ (SeahorseGkrKeyring* self, GParamSpec* pspec);
static void __seahorse_gkr_keyring___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void seahorse_gkr_keyring_finalize (GObject* obj);
static void _vala_seahorse_gkr_keyring_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define SEAHORSE_GKR_KEYRING_DELETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleterPrivate))
enum  {
	SEAHORSE_GKR_KEYRING_DELETER_DUMMY_PROPERTY
};
static GtkDialog* seahorse_gkr_keyring_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent);
static GList* seahorse_gkr_keyring_deleter_real_get_objects (SeahorseDeleter* base);
static gboolean seahorse_gkr_keyring_deleter_real_add_object (SeahorseDeleter* base, GObject* obj);
static void seahorse_gkr_keyring_deleter_real_delete_data_free (gpointer _data);
static void seahorse_gkr_keyring_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_gkr_keyring_deleter_real_delete_co (SeahorseGkrKeyringDeleterDeleteData* _data_);
static void seahorse_gkr_keyring_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void seahorse_gkr_keyring_deleter_finalize (GObject* obj);

static const GtkActionEntry SEAHORSE_GKR_KEYRING_KEYRING_ACTIONS[2] = {{"keyring-default", NULL, "_Set as default", NULL, "Applications usually store new passwords in the default keyring.", (GCallback) _seahorse_gkr_keyring_on_keyring_default_gtk_action_callback}, {"keyring-password", NULL, "Change _Password", NULL, "Change the unlock password of the password storage keyring", (GCallback) _seahorse_gkr_keyring_on_keyring_password_gtk_action_callback}};

static void _seahorse_gkr_keyring_on_keyring_default_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_gkr_keyring_on_keyring_default (action, (SeahorseGkrKeyring*) self);
}


static void _seahorse_gkr_keyring_on_keyring_password_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_gkr_keyring_on_keyring_password (action, (SeahorseGkrKeyring*) self);
}


static guint seahorse_gkr_keyring_real_get_length (GcrCollection* base) {
	SeahorseGkrKeyring * self;
	guint result = 0U;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_hash_table_size (_tmp0_);
	result = _tmp1_;
	return result;
}


static GList* seahorse_gkr_keyring_real_get_objects (GcrCollection* base) {
	SeahorseGkrKeyring * self;
	GList* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean seahorse_gkr_keyring_real_contains (GcrCollection* base, GObject* obj) {
	SeahorseGkrKeyring * self;
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = obj;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_GKR_TYPE_ITEM)) {
		GHashTable* _tmp1_ = NULL;
		GObject* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		_tmp1_ = self->priv->_items;
		_tmp2_ = obj;
		_tmp3_ = g_dbus_proxy_get_object_path ((GDBusProxy*) G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
		_tmp4_ = g_hash_table_lookup (_tmp1_, _tmp3_);
		result = ((SeahorseGkrItem*) _tmp4_) != NULL;
		return result;
	}
	result = FALSE;
	return result;
}


static GtkWindow* seahorse_gkr_keyring_real_create_viewer (SeahorseViewable* base, GtkWindow* parent) {
	SeahorseGkrKeyring * self;
	GtkWindow* result = NULL;
	GtkWindow* _tmp0_ = NULL;
	SeahorseGkrKeyringProperties* _tmp1_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = parent;
	_tmp1_ = seahorse_gkr_keyring_properties_new (self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (GtkWindow*) _tmp1_;
	return result;
}


static SeahorseDeleter* seahorse_gkr_keyring_real_create_deleter (SeahorseDeletable* base) {
	SeahorseGkrKeyring * self;
	SeahorseDeleter* result = NULL;
	SeahorseGkrKeyringDeleter* _tmp0_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = seahorse_gkr_keyring_deleter_new (self);
	result = (SeahorseDeleter*) _tmp0_;
	return result;
}


static void seahorse_gkr_keyring_real_lock_data_free (gpointer _data) {
	SeahorseGkrKeyringLockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringLockData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void seahorse_gkr_keyring_real_lock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringLockData* _data_;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	GTlsInteraction* _tmp1_ = NULL;
	GTlsInteraction* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringLockData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_keyring_real_lock);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_keyring_real_lock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = interaction;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	seahorse_gkr_keyring_real_lock_co (_data_);
}


static gboolean seahorse_gkr_keyring_real_lock_finish (SeahorseLockable* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrKeyringLockData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_gkr_keyring_lock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrKeyringLockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_keyring_real_lock_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean seahorse_gkr_keyring_real_lock_co (SeahorseGkrKeyringLockData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->objects = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _g_object_ref0 ((GDBusProxy*) _data_->self);
	_data_->objects = g_list_prepend (_data_->objects, _data_->_tmp0_);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = secret_collection_get_service ((SecretCollection*) _data_->self);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->service = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->cancellable;
	_data_->_tmp4_ = NULL;
	_data_->_state_ = 1;
	secret_service_lock (_data_->service, _data_->objects, _data_->_tmp3_, seahorse_gkr_keyring_lock_ready, _data_);
	return FALSE;
	_state_1:
	secret_service_lock_finish (_data_->service, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error_);
	__g_list_free__g_object_unref0_0 (_data_->locked);
	_data_->locked = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		__g_list_free__g_object_unref0_0 (_data_->locked);
		_g_object_unref0 (_data_->service);
		__g_list_free__g_object_unref0_0 (_data_->objects);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	seahorse_gkr_keyring_refresh_collection (_data_->self);
	_data_->_tmp5_ = 0U;
	_data_->_tmp5_ = g_list_length (_data_->locked);
	_data_->result = _data_->_tmp5_ > ((guint) 0);
	__g_list_free__g_object_unref0_0 (_data_->locked);
	_g_object_unref0 (_data_->service);
	__g_list_free__g_object_unref0_0 (_data_->objects);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	__g_list_free__g_object_unref0_0 (_data_->locked);
	_g_object_unref0 (_data_->service);
	__g_list_free__g_object_unref0_0 (_data_->objects);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void seahorse_gkr_keyring_real_unlock_data_free (gpointer _data) {
	SeahorseGkrKeyringUnlockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringUnlockData, _data_);
}


static void seahorse_gkr_keyring_real_unlock (SeahorseLockable* base, GTlsInteraction* interaction, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringUnlockData* _data_;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	GTlsInteraction* _tmp1_ = NULL;
	GTlsInteraction* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringUnlockData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_keyring_real_unlock);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_keyring_real_unlock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = interaction;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	seahorse_gkr_keyring_real_unlock_co (_data_);
}


static gboolean seahorse_gkr_keyring_real_unlock_finish (SeahorseLockable* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrKeyringUnlockData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_gkr_keyring_unlock_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrKeyringUnlockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_keyring_real_unlock_co (_data_);
}


static gboolean seahorse_gkr_keyring_real_unlock_co (SeahorseGkrKeyringUnlockData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->objects = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _g_object_ref0 ((GDBusProxy*) _data_->self);
	_data_->objects = g_list_prepend (_data_->objects, _data_->_tmp0_);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = secret_collection_get_service ((SecretCollection*) _data_->self);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->service = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->cancellable;
	_data_->_tmp4_ = NULL;
	_data_->_state_ = 1;
	secret_service_unlock (_data_->service, _data_->objects, _data_->_tmp3_, seahorse_gkr_keyring_unlock_ready, _data_);
	return FALSE;
	_state_1:
	secret_service_unlock_finish (_data_->service, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error_);
	__g_list_free__g_object_unref0_0 (_data_->unlocked);
	_data_->unlocked = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		__g_list_free__g_object_unref0_0 (_data_->unlocked);
		_g_object_unref0 (_data_->service);
		__g_list_free__g_object_unref0_0 (_data_->objects);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	seahorse_gkr_keyring_refresh_collection (_data_->self);
	_data_->_tmp5_ = 0U;
	_data_->_tmp5_ = g_list_length (_data_->unlocked);
	_data_->result = _data_->_tmp5_ > ((guint) 0);
	__g_list_free__g_object_unref0_0 (_data_->unlocked);
	_g_object_unref0 (_data_->service);
	__g_list_free__g_object_unref0_0 (_data_->objects);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	__g_list_free__g_object_unref0_0 (_data_->unlocked);
	_g_object_unref0 (_data_->service);
	__g_list_free__g_object_unref0_0 (_data_->objects);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void seahorse_gkr_keyring_real_load_data_free (gpointer _data) {
	SeahorseGkrKeyringLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringLoadData, _data_);
}


static void seahorse_gkr_keyring_real_load (SeahorsePlace* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrKeyring * self;
	SeahorseGkrKeyringLoadData* _data_;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringLoadData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_keyring_real_load);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_keyring_real_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_gkr_keyring_real_load_co (_data_);
}


static gboolean seahorse_gkr_keyring_real_load_finish (SeahorsePlace* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrKeyringLoadData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean seahorse_gkr_keyring_real_load_co (SeahorseGkrKeyringLoadData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	seahorse_gkr_keyring_refresh_collection (_data_->self);
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void seahorse_gkr_keyring_refresh_collection (SeahorseGkrKeyring* self) {
	GHashTable* seen = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* items = NULL;
	gboolean _tmp3_ = FALSE;
	GList* _tmp5_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp23_ = NULL;
	gchar* object_path = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	seen = _tmp2_;
	items = NULL;
	_tmp3_ = secret_collection_get_locked ((SecretCollection*) self);
	if (!_tmp3_) {
		GList* _tmp4_ = NULL;
		_tmp4_ = secret_collection_get_items ((SecretCollection*) self);
		__g_list_free__g_object_unref0_0 (items);
		items = _tmp4_;
	}
	_tmp5_ = items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp5_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			SecretItem* _tmp6_ = NULL;
			SecretItem* item = NULL;
			_tmp6_ = _g_object_ref0 ((SecretItem*) item_it->data);
			item = _tmp6_;
			{
				gchar* object_path = NULL;
				SecretItem* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				GHashTable* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				GHashTable* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gconstpointer _tmp15_ = NULL;
				_tmp7_ = item;
				_tmp8_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				object_path = _tmp9_;
				_tmp10_ = seen;
				_tmp11_ = object_path;
				_tmp12_ = g_strdup (_tmp11_);
				g_hash_table_add (_tmp10_, _tmp12_);
				_tmp13_ = self->priv->_items;
				_tmp14_ = object_path;
				_tmp15_ = g_hash_table_lookup (_tmp13_, _tmp14_);
				if (((SeahorseGkrItem*) _tmp15_) == NULL) {
					SecretItem* _tmp16_ = NULL;
					GHashTable* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					SecretItem* _tmp20_ = NULL;
					SeahorseGkrItem* _tmp21_ = NULL;
					SecretItem* _tmp22_ = NULL;
					_tmp16_ = item;
					g_object_set ((GObject*) _tmp16_, "place", self, NULL);
					_tmp17_ = self->priv->_items;
					_tmp18_ = object_path;
					_tmp19_ = g_strdup (_tmp18_);
					_tmp20_ = item;
					_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
					g_hash_table_insert (_tmp17_, _tmp19_, _tmp21_);
					_tmp22_ = item;
					gcr_collection_emit_added ((GcrCollection*) self, (GObject*) _tmp22_);
				}
				_g_free0 (object_path);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp23_ = self->priv->_items;
	g_hash_table_iter_init (&iter, _tmp23_);
	while (TRUE) {
		gconstpointer _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		gchar* _tmp26_ = NULL;
		GHashTable* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gconstpointer _tmp29_ = NULL;
		_tmp25_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp24_), (gpointer*) NULL);
		_g_free0 (object_path);
		_tmp26_ = g_strdup (_tmp24_);
		object_path = _tmp26_;
		if (!_tmp25_) {
			break;
		}
		_tmp27_ = seen;
		_tmp28_ = object_path;
		_tmp29_ = g_hash_table_lookup (_tmp27_, _tmp28_);
		if (((const gchar*) _tmp29_) == NULL) {
			SeahorseGkrItem* item = NULL;
			GHashTable* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gconstpointer _tmp32_ = NULL;
			SeahorseGkrItem* _tmp33_ = NULL;
			SeahorseGkrItem* _tmp34_ = NULL;
			SeahorseGkrItem* _tmp35_ = NULL;
			_tmp30_ = self->priv->_items;
			_tmp31_ = object_path;
			_tmp32_ = g_hash_table_lookup (_tmp30_, _tmp31_);
			_tmp33_ = _g_object_ref0 ((SeahorseGkrItem*) _tmp32_);
			item = _tmp33_;
			_tmp34_ = item;
			g_object_set ((GObject*) _tmp34_, "place", NULL, NULL);
			g_hash_table_iter_remove (&iter);
			_tmp35_ = item;
			gcr_collection_emit_removed ((GcrCollection*) self, (GObject*) _tmp35_);
			_g_object_unref0 (item);
		}
	}
	_g_free0 (object_path);
	__g_list_free__g_object_unref0_0 (items);
	_g_hash_table_unref0 (seen);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SeahorseGkrKeyring* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->service);
		_g_object_unref0 (_data5_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda4_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	SeahorseGkrKeyring* self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		GAsyncResult* _tmp0_ = NULL;
		SeahorseGkrBackend* _tmp1_ = NULL;
		SeahorseGkrBackend* _tmp2_ = NULL;
		_tmp0_ = res;
		secret_service_set_alias_finish (_data5_->service, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp1_ = seahorse_gkr_backend_instance ();
		_tmp2_ = _tmp1_;
		seahorse_gkr_backend_refresh (_tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't set default keyring");
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		seahorse_util_show_error ((GtkWidget*) _data5_->parent, _tmp3_, _tmp5_);
		_g_error_free0 (err);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda4_ (self, source_object, res);
	block5_data_unref (self);
}


static void seahorse_gkr_keyring_on_keyring_default (GtkAction* action, SeahorseGkrKeyring* self) {
	Block5Data* _data5_;
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	SecretService* _tmp2_ = NULL;
	SecretService* _tmp3_ = NULL;
	SecretService* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = action;
	_tmp1_ = seahorse_action_get_window (_tmp0_);
	_data5_->parent = _tmp1_;
	_tmp2_ = secret_collection_get_service ((SecretCollection*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data5_->service = _tmp4_;
	secret_service_set_alias (_data5_->service, "default", (SecretCollection*) self, NULL, ___lambda4__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SeahorseGkrKeyring* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->service);
		_g_object_unref0 (_data6_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void ___lambda19_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res) {
	SeahorseGkrKeyring* self;
	SeahorseGkrBackend* _tmp6_ = NULL;
	SeahorseGkrBackend* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		GAsyncResult* _tmp0_ = NULL;
		GVariant* _tmp1_ = NULL;
		GVariant* _tmp2_ = NULL;
		_tmp0_ = res;
		_tmp1_ = secret_service_prompt_at_dbus_path_finish (_data6_->service, _tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		_g_variant_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't change keyring password");
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		seahorse_util_show_error ((GtkWidget*) _data6_->parent, _tmp3_, _tmp5_);
		_g_error_free0 (err);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = seahorse_gkr_backend_instance ();
	_tmp7_ = _tmp6_;
	seahorse_gkr_backend_refresh (_tmp7_);
	_g_object_unref0 (_tmp7_);
}


static void ____lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda19_ (self, source_object, res);
	block6_data_unref (self);
}


static void __lambda18_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res) {
	SeahorseGkrKeyring* self;
	GError * _inner_error_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		GVariant* retval = NULL;
		GDBusConnection* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GVariant* _tmp2_ = NULL;
		gchar* prompt_path = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp0_ = g_dbus_proxy_get_connection ((GDBusProxy*) _data6_->service);
		_tmp1_ = res;
		_tmp2_ = g_dbus_connection_call_finish (_tmp0_, _tmp1_, &_inner_error_);
		retval = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		g_variant_get (retval, "(o)", &prompt_path, NULL);
		_tmp3_ = prompt_path;
		secret_service_prompt_at_dbus_path (_data6_->service, _tmp3_, NULL, NULL, ____lambda19__gasync_ready_callback, block6_data_ref (_data6_));
		_g_free0 (prompt_path);
		_g_variant_unref0 (retval);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _ ("Couldn't change keyring password");
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		seahorse_util_show_error ((GtkWidget*) _data6_->parent, _tmp4_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda18_ (self, source_object, res);
	block6_data_unref (self);
}


static void seahorse_gkr_keyring_on_keyring_password (GtkAction* action, SeahorseGkrKeyring* self) {
	Block6Data* _data6_;
	GtkAction* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	SecretService* _tmp2_ = NULL;
	SecretService* _tmp3_ = NULL;
	SecretService* _tmp4_ = NULL;
	GDBusConnection* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	GVariantType* _tmp11_ = NULL;
	GVariantType* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = action;
	_tmp1_ = seahorse_action_get_window (_tmp0_);
	_data6_->parent = _tmp1_;
	_tmp2_ = secret_collection_get_service ((SecretCollection*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data6_->service = _tmp4_;
	_tmp5_ = g_dbus_proxy_get_connection ((GDBusProxy*) _data6_->service);
	_tmp6_ = g_dbus_proxy_get_name ((GDBusProxy*) _data6_->service);
	_tmp7_ = g_dbus_proxy_get_object_path ((GDBusProxy*) _data6_->service);
	_tmp8_ = g_dbus_proxy_get_object_path ((GDBusProxy*) self);
	_tmp9_ = g_variant_new ("(o)", _tmp8_, NULL);
	g_variant_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_type_new ("(o)");
	_tmp12_ = _tmp11_;
	g_dbus_connection_call (_tmp5_, _tmp6_, _tmp7_, "org.gnome.keyring.InternalUnsupportedGuiltRiddenInterface", "ChangeWithPrompt", _tmp10_, _tmp12_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, ___lambda18__gasync_ready_callback, block6_data_ref (_data6_));
	_g_variant_type_free0 (_tmp12_);
	_g_variant_unref0 (_tmp10_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static GtkActionGroup* seahorse_gkr_keyring_create_actions (SeahorseGkrKeyring* self) {
	GtkActionGroup* result = NULL;
	GtkActionGroup* actions = NULL;
	GtkActionGroup* _tmp0_ = NULL;
	GtkAction* action = NULL;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_action_group_new ("KeyringActions");
	actions = _tmp0_;
	gtk_action_group_set_translation_domain (actions, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (actions, SEAHORSE_GKR_KEYRING_KEYRING_ACTIONS, G_N_ELEMENTS (SEAHORSE_GKR_KEYRING_KEYRING_ACTIONS), self);
	_tmp1_ = gtk_action_group_get_action (actions, "keyring-default");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	g_object_bind_property_with_closures ((GObject*) self, "is-default", (GObject*) action, "sensitive", G_BINDING_INVERT_BOOLEAN | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	result = actions;
	_g_object_unref0 (action);
	return result;
}


SeahorseGkrKeyring* seahorse_gkr_keyring_construct (GType object_type) {
	SeahorseGkrKeyring * self = NULL;
	self = (SeahorseGkrKeyring*) g_object_new (object_type, NULL);
	return self;
}


SeahorseGkrKeyring* seahorse_gkr_keyring_new (void) {
	return seahorse_gkr_keyring_construct (SEAHORSE_GKR_TYPE_KEYRING);
}


static gchar* seahorse_gkr_keyring_real_get_description (SeahorsePlace* base) {
	gchar* result;
	SeahorseGkrKeyring* self;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = seahorse_gkr_backend_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = seahorse_gkr_backend_has_alias (_tmp1_, "login", self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = _ ("A keyring that is automatically unlocked on login");
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = _ ("A keyring used to store passwords");
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}


static gchar* seahorse_gkr_keyring_real_get_uri (SeahorsePlace* base) {
	gchar* result;
	SeahorseGkrKeyring* self;
	gchar* object_path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = g_dbus_proxy_get_object_path ((GDBusProxy*) G_TYPE_CHECK_INSTANCE_CAST (self, secret_collection_get_type (), SecretCollection));
	_tmp1_ = g_strdup (_tmp0_);
	object_path = _tmp1_;
	_tmp2_ = g_strdup_printf ("secret-service://%s", object_path);
	result = _tmp2_;
	_g_free0 (object_path);
	return result;
}


static GIcon* seahorse_gkr_keyring_real_get_icon (SeahorsePlace* base) {
	GIcon* result;
	SeahorseGkrKeyring* self;
	GThemedIcon* _tmp0_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("folder");
	result = (GIcon*) _tmp0_;
	return result;
}


static GtkActionGroup* seahorse_gkr_keyring_real_get_actions (SeahorsePlace* base) {
	GtkActionGroup* result;
	SeahorseGkrKeyring* self;
	GtkActionGroup* _tmp0_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GtkActionGroup* _tmp3_ = NULL;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = self->priv->_actions;
	if (_tmp0_ == NULL) {
		GtkActionGroup* _tmp1_ = NULL;
		_tmp1_ = seahorse_gkr_keyring_create_actions (self);
		_g_object_unref0 (self->priv->_actions);
		self->priv->_actions = _tmp1_;
	}
	_tmp2_ = self->priv->_actions;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


gboolean seahorse_gkr_keyring_get_is_default (SeahorseGkrKeyring* self) {
	gboolean result;
	SeahorseGkrBackend* _tmp0_ = NULL;
	SeahorseGkrBackend* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = seahorse_gkr_backend_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = seahorse_gkr_backend_has_alias (_tmp1_, "default", self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static gboolean seahorse_gkr_keyring_real_get_lockable (SeahorseLockable* base) {
	gboolean result;
	SeahorseGkrKeyring* self;
	gboolean _tmp0_ = FALSE;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = secret_collection_get_locked ((SecretCollection*) self);
	result = !_tmp0_;
	return result;
}


static gboolean seahorse_gkr_keyring_real_get_unlockable (SeahorseLockable* base) {
	gboolean result;
	SeahorseGkrKeyring* self;
	gboolean _tmp0_ = FALSE;
	self = (SeahorseGkrKeyring*) base;
	_tmp0_ = secret_collection_get_locked ((SecretCollection*) self);
	result = _tmp0_;
	return result;
}


static gboolean seahorse_gkr_keyring_real_get_deletable (SeahorseDeletable* base) {
	gboolean result;
	SeahorseGkrKeyring* self;
	self = (SeahorseGkrKeyring*) base;
	result = TRUE;
	return result;
}


static void _seahorse_gkr_keyring___lambda33_ (SeahorseGkrKeyring* self, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	GParamSpec* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (pspec != NULL);
	_tmp1_ = pspec;
	_tmp2_ = _tmp1_->name;
	if (g_strcmp0 (_tmp2_, "items") == 0) {
		_tmp0_ = TRUE;
	} else {
		GParamSpec* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = pspec;
		_tmp4_ = _tmp3_->name;
		_tmp0_ = g_strcmp0 (_tmp4_, "locked") == 0;
	}
	if (_tmp0_) {
		seahorse_gkr_keyring_refresh_collection (self);
	}
}


static void __seahorse_gkr_keyring___lambda33__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_seahorse_gkr_keyring___lambda33_ ((SeahorseGkrKeyring*) self, pspec);
}


static void _seahorse_gkr_keyring___lambda34_ (SeahorseGkrKeyring* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	g_object_notify ((GObject*) self, "is-default");
	g_object_notify ((GObject*) self, "description");
}


static void __seahorse_gkr_keyring___lambda34__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_seahorse_gkr_keyring___lambda34_ ((SeahorseGkrKeyring*) self, pspec);
}


static GObject * seahorse_gkr_keyring_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrKeyring * self;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	SeahorseGkrBackend* _tmp3_ = NULL;
	SeahorseGkrBackend* _tmp4_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_keyring_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_items);
	self->priv->_items = _tmp2_;
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) __seahorse_gkr_keyring___lambda33__g_object_notify, self, 0);
	_tmp3_ = seahorse_gkr_backend_instance ();
	_tmp4_ = _tmp3_;
	g_signal_connect_object ((GObject*) _tmp4_, "notify", (GCallback) __seahorse_gkr_keyring___lambda34__g_object_notify, self, 0);
	_g_object_unref0 (_tmp4_);
	return obj;
}


static void seahorse_gkr_keyring_class_init (SeahorseGkrKeyringClass * klass) {
	seahorse_gkr_keyring_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseGkrKeyringPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_keyring_get_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_keyring_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_keyring_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_ACTIONS, g_param_spec_object ("actions", "actions", "actions", gtk_action_group_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_IS_DEFAULT, g_param_spec_boolean ("is-default", "is-default", "is-default", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_LOCKABLE, g_param_spec_boolean ("lockable", "lockable", "lockable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_UNLOCKABLE, g_param_spec_boolean ("unlockable", "unlockable", "unlockable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_KEYRING_DELETABLE, g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void seahorse_gkr_keyring_gcr_collection_interface_init (GcrCollectionIface * iface) {
	seahorse_gkr_keyring_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_length = (guint (*)(GcrCollection*)) seahorse_gkr_keyring_real_get_length;
	iface->get_objects = (GList* (*)(GcrCollection*)) seahorse_gkr_keyring_real_get_objects;
	iface->contains = (gboolean (*)(GcrCollection*, GObject*)) seahorse_gkr_keyring_real_contains;
}


static void seahorse_gkr_keyring_seahorse_place_interface_init (SeahorsePlaceIface * iface) {
	seahorse_gkr_keyring_seahorse_place_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (gboolean (*)(SeahorsePlace*, GCancellable*, GError**)) seahorse_gkr_keyring_real_load;
	iface->load_finish = seahorse_gkr_keyring_real_load_finish;
	iface->get_description = seahorse_gkr_keyring_real_get_description;
	iface->get_uri = seahorse_gkr_keyring_real_get_uri;
	iface->get_icon = seahorse_gkr_keyring_real_get_icon;
	iface->get_actions = seahorse_gkr_keyring_real_get_actions;
	iface->get_label = (gchar* (*) (SeahorsePlace *)) secret_collection_get_label;
}


static void seahorse_gkr_keyring_seahorse_deletable_interface_init (SeahorseDeletableIface * iface) {
	seahorse_gkr_keyring_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_deleter = (SeahorseDeleter* (*)(SeahorseDeletable*)) seahorse_gkr_keyring_real_create_deleter;
	iface->get_deletable = seahorse_gkr_keyring_real_get_deletable;
}


static void seahorse_gkr_keyring_seahorse_lockable_interface_init (SeahorseLockableIface * iface) {
	seahorse_gkr_keyring_seahorse_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->lock = (gboolean (*)(SeahorseLockable*, GTlsInteraction*, GCancellable*, GError**)) seahorse_gkr_keyring_real_lock;
	iface->lock_finish = seahorse_gkr_keyring_real_lock_finish;
	iface->unlock = (gboolean (*)(SeahorseLockable*, GTlsInteraction*, GCancellable*, GError**)) seahorse_gkr_keyring_real_unlock;
	iface->unlock_finish = seahorse_gkr_keyring_real_unlock_finish;
	iface->get_lockable = seahorse_gkr_keyring_real_get_lockable;
	iface->get_unlockable = seahorse_gkr_keyring_real_get_unlockable;
}


static void seahorse_gkr_keyring_seahorse_viewable_interface_init (SeahorseViewableIface * iface) {
	seahorse_gkr_keyring_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_viewer = (GtkWindow* (*)(SeahorseViewable*, GtkWindow*)) seahorse_gkr_keyring_real_create_viewer;
}


static void seahorse_gkr_keyring_instance_init (SeahorseGkrKeyring * self) {
	self->priv = SEAHORSE_GKR_KEYRING_GET_PRIVATE (self);
}


static void seahorse_gkr_keyring_finalize (GObject* obj) {
	SeahorseGkrKeyring * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	_g_hash_table_unref0 (self->priv->_items);
	_g_object_unref0 (self->priv->_actions);
	G_OBJECT_CLASS (seahorse_gkr_keyring_parent_class)->finalize (obj);
}


GType seahorse_gkr_keyring_get_type (void) {
	static volatile gsize seahorse_gkr_keyring_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_keyring_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrKeyringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_keyring_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrKeyring), 0, (GInstanceInitFunc) seahorse_gkr_keyring_instance_init, NULL };
		static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_place_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_place_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_lockable_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_gkr_keyring_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_gkr_keyring_type_id;
		seahorse_gkr_keyring_type_id = g_type_register_static (secret_collection_get_type (), "SeahorseGkrKeyring", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_gkr_keyring_type_id, gcr_collection_get_type (), &gcr_collection_info);
		g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_PLACE, &seahorse_place_info);
		g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
		g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_LOCKABLE, &seahorse_lockable_info);
		g_type_add_interface_static (seahorse_gkr_keyring_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
		g_once_init_leave (&seahorse_gkr_keyring_type_id__volatile, seahorse_gkr_keyring_type_id);
	}
	return seahorse_gkr_keyring_type_id__volatile;
}


static void _vala_seahorse_gkr_keyring_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrKeyring * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	switch (property_id) {
		case SEAHORSE_GKR_KEYRING_DESCRIPTION:
		g_value_take_string (value, seahorse_place_get_description ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_URI:
		g_value_take_string (value, seahorse_place_get_uri ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_ICON:
		g_value_take_object (value, seahorse_place_get_icon ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_ACTIONS:
		g_value_take_object (value, seahorse_place_get_actions ((SeahorsePlace*) self));
		break;
		case SEAHORSE_GKR_KEYRING_IS_DEFAULT:
		g_value_set_boolean (value, seahorse_gkr_keyring_get_is_default (self));
		break;
		case SEAHORSE_GKR_KEYRING_LOCKABLE:
		g_value_set_boolean (value, seahorse_lockable_get_lockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_GKR_KEYRING_UNLOCKABLE:
		g_value_set_boolean (value, seahorse_lockable_get_unlockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_GKR_KEYRING_DELETABLE:
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GtkDialog* seahorse_gkr_keyring_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent) {
	SeahorseGkrKeyringDeleter * self;
	GtkDialog* result = NULL;
	SeahorseDeleteDialog* dialog = NULL;
	GtkWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SeahorseGkrKeyring* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	SeahorseDeleteDialog* _tmp6_ = NULL;
	SeahorseDeleteDialog* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	self = (SeahorseGkrKeyringDeleter*) base;
	_tmp0_ = parent;
	_tmp1_ = _ ("Are you sure you want to delete the password keyring '%s'?");
	_tmp2_ = self->priv->_keyring;
	_tmp3_ = seahorse_place_get_label ((SeahorsePlace*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (_tmp0_, _tmp1_, _tmp5_, NULL);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	dialog = _tmp7_;
	_tmp8_ = _ ("I understand that all items will be permanently deleted.");
	seahorse_delete_dialog_set_check_label (dialog, _tmp8_);
	seahorse_delete_dialog_set_check_require (dialog, TRUE);
	result = (GtkDialog*) dialog;
	return result;
}


SeahorseGkrKeyringDeleter* seahorse_gkr_keyring_deleter_construct (GType object_type, SeahorseGkrKeyring* keyring) {
	SeahorseGkrKeyringDeleter * self = NULL;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (keyring != NULL, NULL);
	self = (SeahorseGkrKeyringDeleter*) seahorse_deleter_construct (object_type);
	_tmp0_ = keyring;
	_tmp1_ = seahorse_deleter_add_object ((SeahorseDeleter*) self, (GObject*) _tmp0_);
	if (!_tmp1_) {
		g_assert_not_reached ();
	}
	return self;
}


SeahorseGkrKeyringDeleter* seahorse_gkr_keyring_deleter_new (SeahorseGkrKeyring* keyring) {
	return seahorse_gkr_keyring_deleter_construct (SEAHORSE_GKR_TYPE_KEYRING_DELETER, keyring);
}


static GList* seahorse_gkr_keyring_deleter_real_get_objects (SeahorseDeleter* base) {
	SeahorseGkrKeyringDeleter * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
	self = (SeahorseGkrKeyringDeleter*) base;
	_tmp0_ = self->priv->_objects;
	result = _tmp0_;
	return result;
}


static gboolean seahorse_gkr_keyring_deleter_real_add_object (SeahorseDeleter* base, GObject* obj) {
	SeahorseGkrKeyringDeleter * self;
	gboolean result = FALSE;
	SeahorseGkrKeyring* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	self = (SeahorseGkrKeyringDeleter*) base;
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = self->priv->_keyring;
	if (_tmp0_ != NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = obj;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, SEAHORSE_GKR_TYPE_KEYRING)) {
		GObject* _tmp2_ = NULL;
		SeahorseGkrKeyring* _tmp3_ = NULL;
		GObject* _tmp4_ = NULL;
		GObject* _tmp5_ = NULL;
		_tmp2_ = obj;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring));
		_g_object_unref0 (self->priv->_keyring);
		self->priv->_keyring = _tmp3_;
		_tmp4_ = obj;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		self->priv->_objects = g_list_append (self->priv->_objects, _tmp5_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void seahorse_gkr_keyring_deleter_real_delete_data_free (gpointer _data) {
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrKeyringDeleterDeleteData, _data_);
}


static void seahorse_gkr_keyring_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrKeyringDeleter * self;
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	SeahorseGkrKeyringDeleter* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	self = (SeahorseGkrKeyringDeleter*) base;
	_data_ = g_slice_new0 (SeahorseGkrKeyringDeleterDeleteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_keyring_deleter_real_delete);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_keyring_deleter_real_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_gkr_keyring_deleter_real_delete_co (_data_);
}


static gboolean seahorse_gkr_keyring_deleter_real_delete_finish (SeahorseDeleter* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_gkr_keyring_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrKeyringDeleterDeleteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_keyring_deleter_real_delete_co (_data_);
}


static gboolean seahorse_gkr_keyring_deleter_real_delete_co (SeahorseGkrKeyringDeleterDeleteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_keyring;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 1;
	secret_collection_delete ((SecretCollection*) _data_->_tmp0_, _data_->_tmp1_, seahorse_gkr_keyring_deleter_delete_ready, _data_);
	return FALSE;
	_state_1:
	secret_collection_delete_finish ((SecretCollection*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void seahorse_gkr_keyring_deleter_class_init (SeahorseGkrKeyringDeleterClass * klass) {
	seahorse_gkr_keyring_deleter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseGkrKeyringDeleterPrivate));
	((SeahorseDeleterClass *) klass)->create_confirm = seahorse_gkr_keyring_deleter_real_create_confirm;
	((SeahorseDeleterClass *) klass)->get_objects = seahorse_gkr_keyring_deleter_real_get_objects;
	((SeahorseDeleterClass *) klass)->add_object = seahorse_gkr_keyring_deleter_real_add_object;
	((SeahorseDeleterClass *) klass)->delete = seahorse_gkr_keyring_deleter_real_delete;
	((SeahorseDeleterClass *) klass)->delete_finish = seahorse_gkr_keyring_deleter_real_delete_finish;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_keyring_deleter_finalize;
}


static void seahorse_gkr_keyring_deleter_instance_init (SeahorseGkrKeyringDeleter * self) {
	self->priv = SEAHORSE_GKR_KEYRING_DELETER_GET_PRIVATE (self);
}


static void seahorse_gkr_keyring_deleter_finalize (GObject* obj) {
	SeahorseGkrKeyringDeleter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_KEYRING_DELETER, SeahorseGkrKeyringDeleter);
	_g_object_unref0 (self->priv->_keyring);
	__g_list_free__g_object_unref0_0 (self->priv->_objects);
	G_OBJECT_CLASS (seahorse_gkr_keyring_deleter_parent_class)->finalize (obj);
}


GType seahorse_gkr_keyring_deleter_get_type (void) {
	static volatile gsize seahorse_gkr_keyring_deleter_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_keyring_deleter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrKeyringDeleterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_keyring_deleter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrKeyringDeleter), 0, (GInstanceInitFunc) seahorse_gkr_keyring_deleter_instance_init, NULL };
		GType seahorse_gkr_keyring_deleter_type_id;
		seahorse_gkr_keyring_deleter_type_id = g_type_register_static (SEAHORSE_TYPE_DELETER, "SeahorseGkrKeyringDeleter", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_keyring_deleter_type_id__volatile, seahorse_gkr_keyring_deleter_type_id);
	}
	return seahorse_gkr_keyring_deleter_type_id__volatile;
}



