/* VideoTable.c generated by valac 0.40.4, the Vala compiler
 * generated from VideoTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <sqlite3.h>
#include <gee.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_RATING (rating_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecVideoRow ParamSpecVideoRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
typedef struct _VideoTablePrivate VideoTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _VideoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	time_t time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	time_t time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _ParamSpecVideoRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _VideoTable {
	DatabaseTable parent_instance;
	VideoTablePrivate * priv;
};

struct _VideoTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer video_row_parent_class = NULL;
static gpointer video_table_parent_class = NULL;
static VideoTable* video_table_instance;
static VideoTable* video_table_instance = NULL;
extern sqlite3* database_table_db;

GType video_id_get_type (void) G_GNUC_CONST;
VideoID* video_id_dup (const VideoID* self);
void video_id_free (VideoID* self);
#define VIDEO_ID_INVALID ((gint64) -1)
void video_id_init (VideoID *self,
                    gint64 id);
gboolean video_id_is_invalid (VideoID *self);
gboolean video_id_is_valid (VideoID *self);
guint video_id_hash (VideoID* a);
guint int64_hash (gint64* n);
gboolean video_id_equal (void* a,
                         void* b);
gchar* video_id_upgrade_video_id_to_source_id (VideoID* video_id);
#define VIDEO_TYPENAME "video"
gpointer video_row_ref (gpointer instance);
void video_row_unref (gpointer instance);
GParamSpec* param_spec_video_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_video_row (GValue* value,
                          gpointer v_object);
void value_take_video_row (GValue* value,
                           gpointer v_object);
gpointer value_get_video_row (const GValue* value);
GType video_row_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType rating_get_type (void) G_GNUC_CONST;
VideoRow* video_row_new (void);
VideoRow* video_row_construct (GType object_type);
static void video_row_finalize (VideoRow * obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_database_table (GValue* value,
                               gpointer v_object);
void value_take_database_table (GValue* value,
                                gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType video_table_get_type (void) G_GNUC_CONST;
static VideoTable* video_table_new (void);
static VideoTable* video_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_fatal (const gchar* op,
                           gint res);
void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VideoTable* video_table_get_instance (void);
GQuark database_error_quark (void);
void video_table_add (VideoTable* self,
                      VideoRow* video_row,
                      VideoID* result,
                      GError** error);
gulong now_sec (void);
#define EVENT_ID_INVALID ((gint64) -1)
void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
void event_id_init (EventID *self,
                    gint64 id);
gboolean video_table_drop_event (VideoTable* self,
                                 EventID* event_id);
VideoRow* video_table_get_row (VideoTable* self,
                               VideoID* video_id);
Rating rating_unserialize (gint value);
GeeArrayList* video_table_get_all (VideoTable* self);
void video_table_set_filepath (VideoTable* self,
                               VideoID* video_id,
                               const gchar* filepath,
                               GError** error);
void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
void video_table_set_title (VideoTable* self,
                            VideoID* video_id,
                            const gchar* new_title,
                            GError** error);
void video_table_set_comment (VideoTable* self,
                              VideoID* video_id,
                              const gchar* new_comment,
                              GError** error);
void video_table_set_exposure_time (VideoTable* self,
                                    VideoID* video_id,
                                    time_t time,
                                    GError** error);
void database_table_update_int64_by_id_2 (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint64 value,
                                          GError** error);
void video_table_set_rating (VideoTable* self,
                             VideoID* video_id,
                             Rating rating,
                             GError** error);
gint rating_serialize (Rating self);
void video_table_set_flags (VideoTable* self,
                            VideoID* video_id,
                            guint64 flags,
                            GError** error);
void video_table_update_backlinks (VideoTable* self,
                                   VideoID* video_id,
                                   const gchar* backlinks,
                                   GError** error);
void video_table_update_is_interpretable (VideoTable* self,
                                          VideoID* video_id,
                                          gboolean is_interpretable,
                                          GError** error);
void database_table_update_int_by_id_2 (DatabaseTable* self,
                                        gint64 id,
                                        const gchar* column,
                                        gint value,
                                        GError** error);
gboolean video_table_set_event (VideoTable* self,
                                VideoID* video_id,
                                EventID* event_id);
gboolean database_table_update_int64_by_id (DatabaseTable* self,
                                            gint64 id,
                                            const gchar* column,
                                            gint64 value);
void video_table_remove_by_file (VideoTable* self,
                                 GFile* file,
                                 GError** error);
void video_table_remove (VideoTable* self,
                         VideoID* videoID,
                         GError** error);
gboolean video_table_is_video_stored (VideoTable* self,
                                      GFile* file);
void video_table_get_id (VideoTable* self,
                         GFile* file,
                         VideoID* result);
GeeArrayList* video_table_get_videos (VideoTable* self,
                                      GError** error);
static sqlite3_stmt* video_table_get_duplicate_stmt (VideoTable* self,
                                              GFile* file,
                                              const gchar* md5);
gboolean video_table_has_duplicate (VideoTable* self,
                                    GFile* file,
                                    const gchar* md5);
VideoID* video_table_get_duplicate_ids (VideoTable* self,
                                        GFile* file,
                                        const gchar* md5,
                                        int* result_length1);
static void _vala_array_add3 (VideoID* * array,
                       int* length,
                       int* size,
                       const VideoID* value);
GeeArrayList* video_table_get_event_source_ids (VideoTable* self,
                                                EventID* event_id);
void video_table_set_timestamp (VideoTable* self,
                                VideoID* video_id,
                                time_t timestamp,
                                GError** error);
static void video_table_finalize (DatabaseTable * obj);


void
video_id_init (VideoID *self,
               gint64 id)
{
#line 12 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	memset (self, 0, sizeof (VideoID));
#line 13 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	(*self).id = id;
#line 348 "VideoTable.c"
}


gboolean
video_id_is_invalid (VideoID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp0_ == VIDEO_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 363 "VideoTable.c"
}


gboolean
video_id_is_valid (VideoID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 21 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp0_ != VIDEO_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 378 "VideoTable.c"
}


guint
video_id_hash (VideoID* a)
{
	guint result = 0U;
	gint64 _tmp0_;
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = (*a).id;
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = int64_hash (&_tmp0_);
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 393 "VideoTable.c"
}


gboolean
video_id_equal (void* a,
                void* b)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
	gint64 _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = (*((VideoID*) a)).id;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = (*((VideoID*) b)).id;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp0_ == _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 412 "VideoTable.c"
}


gchar*
video_id_upgrade_video_id_to_source_id (VideoID* video_id)
{
	gchar* result = NULL;
	VideoID _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
#line 32 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (video_id != NULL, NULL);
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = g_strdup_printf ("%s-%016" G_GINT64_MODIFIER "x", VIDEO_TYPENAME, _tmp1_);
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 435 "VideoTable.c"
}


VideoID*
video_id_dup (const VideoID* self)
{
	VideoID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	dup = g_new0 (VideoID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	memcpy (dup, self, sizeof (VideoID));
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return dup;
#line 449 "VideoTable.c"
}


void
video_id_free (VideoID* self)
{
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_free (self);
#line 458 "VideoTable.c"
}


GType
video_id_get_type (void)
{
	static volatile gsize video_id_type_id__volatile = 0;
	if (g_once_init_enter (&video_id_type_id__volatile)) {
		GType video_id_type_id;
		video_id_type_id = g_boxed_type_register_static ("VideoID", (GBoxedCopyFunc) video_id_dup, (GBoxedFreeFunc) video_id_free);
		g_once_init_leave (&video_id_type_id__volatile, video_id_type_id);
	}
	return video_id_type_id__volatile;
}


VideoRow*
video_row_construct (GType object_type)
{
	VideoRow* self = NULL;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = (VideoRow*) g_type_create_instance (object_type);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return self;
#line 483 "VideoTable.c"
}


VideoRow*
video_row_new (void)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return video_row_construct (TYPE_VIDEO_ROW);
#line 492 "VideoTable.c"
}


static void
value_video_row_init (GValue* value)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	value->data[0].v_pointer = NULL;
#line 501 "VideoTable.c"
}


static void
value_video_row_free_value (GValue* value)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (value->data[0].v_pointer) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_unref (value->data[0].v_pointer);
#line 512 "VideoTable.c"
	}
}


static void
value_video_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (src_value->data[0].v_pointer) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		dest_value->data[0].v_pointer = video_row_ref (src_value->data[0].v_pointer);
#line 525 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 529 "VideoTable.c"
	}
}


static gpointer
value_video_row_peek_pointer (const GValue* value)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return value->data[0].v_pointer;
#line 539 "VideoTable.c"
}


static gchar*
value_video_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (collect_values[0].v_pointer) {
#line 551 "VideoTable.c"
		VideoRow * object;
		object = collect_values[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 558 "VideoTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 562 "VideoTable.c"
		}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = video_row_ref (object);
#line 566 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = NULL;
#line 570 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return NULL;
#line 574 "VideoTable.c"
}


static gchar*
value_video_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	VideoRow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (!object_p) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 590 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (!value->data[0].v_pointer) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*object_p = NULL;
#line 596 "VideoTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*object_p = value->data[0].v_pointer;
#line 600 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*object_p = video_row_ref (value->data[0].v_pointer);
#line 604 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return NULL;
#line 608 "VideoTable.c"
}


GParamSpec*
param_spec_video_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecVideoRow* spec;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_ROW), NULL);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return G_PARAM_SPEC (spec);
#line 628 "VideoTable.c"
}


gpointer
value_get_video_row (const GValue* value)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW), NULL);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return value->data[0].v_pointer;
#line 639 "VideoTable.c"
}


void
value_set_video_row (GValue* value,
                     gpointer v_object)
{
	VideoRow * old;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	old = value->data[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (v_object) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = v_object;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_ref (value->data[0].v_pointer);
#line 662 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = NULL;
#line 666 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (old) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_unref (old);
#line 672 "VideoTable.c"
	}
}


void
value_take_video_row (GValue* value,
                      gpointer v_object)
{
	VideoRow * old;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	old = value->data[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (v_object) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = v_object;
#line 694 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = NULL;
#line 698 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (old) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_unref (old);
#line 704 "VideoTable.c"
	}
}


static void
video_row_class_init (VideoRowClass * klass)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_row_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	((VideoRowClass *) klass)->finalize = video_row_finalize;
#line 716 "VideoTable.c"
}


static void
video_row_instance_init (VideoRow * self)
{
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self->ref_count = 1;
#line 725 "VideoTable.c"
}


static void
video_row_finalize (VideoRow * obj)
{
	VideoRow * self;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_ROW, VideoRow);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_signal_handlers_destroy (self);
#line 39 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->filepath);
#line 49 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->md5);
#line 52 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->title);
#line 53 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->backlinks);
#line 56 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->comment);
#line 747 "VideoTable.c"
}


GType
video_row_get_type (void)
{
	static volatile gsize video_row_type_id__volatile = 0;
	if (g_once_init_enter (&video_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_row_init, value_video_row_free_value, value_video_row_copy_value, value_video_row_peek_pointer, "p", value_video_row_collect_value, "p", value_video_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoRow), 0, (GInstanceInitFunc) video_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_row_type_id;
		video_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_row_type_id__volatile, video_row_type_id);
	}
	return video_row_type_id__volatile;
}


gpointer
video_row_ref (gpointer instance)
{
	VideoRow * self;
	self = instance;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return instance;
#line 776 "VideoTable.c"
}


void
video_row_unref (gpointer instance)
{
	VideoRow * self;
	self = instance;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		VIDEO_ROW_GET_CLASS (self)->finalize (self);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 791 "VideoTable.c"
	}
}


static VideoTable*
video_table_construct (GType object_type)
{
	VideoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* stmt2 = NULL;
	gint res2 = 0;
	sqlite3* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_;
	gint _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint _tmp12_;
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = (VideoTable*) database_table_construct (object_type);
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS VideoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "clip_duration REAL, " "is_interpretable INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "md5 TEXT, " "time_created INTEGER, " "rating INTEGER DEFAULT 0, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "flags INTEGER DEFAULT 0, " "comment TEXT " ")", -1, &_tmp1_, NULL);
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 85 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 85 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 87 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 87 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp4_);
#line 88 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = res;
#line 88 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp5_ != SQLITE_DONE) {
#line 840 "VideoTable.c"
		gint _tmp6_;
#line 89 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp6_ = res;
#line 89 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_fatal ("VideoTable constructor", _tmp6_);
#line 846 "VideoTable.c"
	}
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = database_table_db;
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = sqlite3_prepare_v2 (_tmp7_, "CREATE INDEX IF NOT EXISTS VideoEventIDIndex ON VideoTable (event_id)", -1, &_tmp8_, NULL);
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt2 = _tmp8_;
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res2 = _tmp9_;
#line 95 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = res2;
#line 95 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res2 == Sqlite.OK");
#line 97 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = stmt2;
#line 97 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res2 = sqlite3_step (_tmp11_);
#line 98 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = res2;
#line 98 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 870 "VideoTable.c"
		gint _tmp13_;
#line 99 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp13_ = res2;
#line 99 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_fatal ("VideoTable constructor", _tmp13_);
#line 876 "VideoTable.c"
	}
#line 101 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "VideoTable");
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return self;
#line 886 "VideoTable.c"
}


static VideoTable*
video_table_new (void)
{
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return video_table_construct (TYPE_VIDEO_TABLE);
#line 895 "VideoTable.c"
}


static gpointer
_database_table_ref0 (gpointer self)
{
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 904 "VideoTable.c"
}


VideoTable*
video_table_get_instance (void)
{
	VideoTable* result = NULL;
	VideoTable* _tmp0_;
	VideoTable* _tmp2_;
	VideoTable* _tmp3_;
#line 105 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = video_table_instance;
#line 105 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp0_ == NULL) {
#line 919 "VideoTable.c"
		VideoTable* _tmp1_;
#line 106 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp1_ = video_table_new ();
#line 106 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_database_table_unref0 (video_table_instance);
#line 106 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_table_instance = _tmp1_;
#line 927 "VideoTable.c"
	}
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = video_table_instance;
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp3_;
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 937 "VideoTable.c"
}


void
video_table_add (VideoTable* self,
                 VideoRow* video_row,
                 VideoID* result,
                 GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gulong time_created = 0UL;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	gint _tmp8_;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	sqlite3_stmt* _tmp15_;
	gdouble _tmp16_;
	gint _tmp17_;
	gint _tmp18_ = 0;
	gboolean _tmp19_;
	sqlite3_stmt* _tmp20_;
	gint _tmp21_;
	sqlite3_stmt* _tmp22_;
	gint64 _tmp23_;
	gint _tmp24_;
	sqlite3_stmt* _tmp25_;
	time_t _tmp26_;
	gint _tmp27_;
	sqlite3_stmt* _tmp28_;
	time_t _tmp29_;
	gint _tmp30_;
	sqlite3_stmt* _tmp31_;
	ImportID _tmp32_;
	gint64 _tmp33_;
	gint _tmp34_;
	sqlite3_stmt* _tmp35_;
	gint _tmp36_;
	sqlite3_stmt* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GDestroyNotify _tmp40_;
	gint _tmp41_;
	sqlite3_stmt* _tmp42_;
	gulong _tmp43_;
	gint _tmp44_;
	sqlite3_stmt* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	GDestroyNotify _tmp48_;
	gint _tmp49_;
	sqlite3_stmt* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	GDestroyNotify _tmp53_;
	gint _tmp54_;
	sqlite3_stmt* _tmp55_;
	gint _tmp56_;
	sqlite3* _tmp59_;
	gulong _tmp60_;
	VideoID _tmp61_;
	GError * _inner_error_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 113 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_ROW (video_row));
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO VideoTable (filename, width, height, clip_duration, is_int" \
"erpretable, " "filesize, timestamp, exposure_time, import_id, event_id, md5, time_cre" \
"ated, title, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 120 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 120 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 122 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	time_created = now_sec ();
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = video_row->filepath;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = g_free;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 125 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = res;
#line 125 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = stmt;
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = video_row->width;
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int (_tmp9_, 2, _tmp10_);
#line 127 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = res;
#line 127 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = stmt;
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = video_row->height;
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int (_tmp12_, 3, _tmp13_);
#line 129 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_ = res;
#line 129 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp14_ == SQLITE_OK, "res == Sqlite.OK");
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp15_ = stmt;
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp16_ = video_row->clip_duration;
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_double (_tmp15_, 4, _tmp16_);
#line 131 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp17_ = res;
#line 131 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp19_ = video_row->is_interpretable;
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp19_) {
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp18_ = 1;
#line 1081 "VideoTable.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp18_ = 0;
#line 1085 "VideoTable.c"
	}
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp20_ = stmt;
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int (_tmp20_, 5, _tmp18_);
#line 133 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp21_ = res;
#line 133 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp21_ == SQLITE_OK, "res == Sqlite.OK");
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp22_ = stmt;
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp23_ = video_row->filesize;
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp22_, 6, _tmp23_);
#line 135 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp24_ = res;
#line 135 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp24_ == SQLITE_OK, "res == Sqlite.OK");
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp25_ = stmt;
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp26_ = video_row->timestamp;
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp25_, 7, (gint64) _tmp26_);
#line 137 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp27_ = res;
#line 137 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp28_ = stmt;
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp29_ = video_row->exposure_time;
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp28_, 8, (gint64) _tmp29_);
#line 139 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp30_ = res;
#line 139 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp30_ == SQLITE_OK, "res == Sqlite.OK");
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp31_ = stmt;
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp32_ = video_row->import_id;
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp33_ = _tmp32_.id;
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp31_, 9, _tmp33_);
#line 141 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp34_ = res;
#line 141 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp34_ == SQLITE_OK, "res == Sqlite.OK");
#line 142 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp35_ = stmt;
#line 142 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp35_, 10, EVENT_ID_INVALID);
#line 143 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp36_ = res;
#line 143 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp36_ == SQLITE_OK, "res == Sqlite.OK");
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp37_ = stmt;
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp38_ = video_row->md5;
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp39_ = g_strdup (_tmp38_);
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp40_ = g_free;
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_text (_tmp37_, 11, _tmp39_, -1, _tmp40_);
#line 145 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp41_ = res;
#line 145 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp41_ == SQLITE_OK, "res == Sqlite.OK");
#line 146 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp42_ = stmt;
#line 146 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp43_ = time_created;
#line 146 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp42_, 12, (gint64) _tmp43_);
#line 147 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp44_ = res;
#line 147 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp44_ == SQLITE_OK, "res == Sqlite.OK");
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp45_ = stmt;
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp46_ = video_row->title;
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp47_ = g_strdup (_tmp46_);
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp48_ = g_free;
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_text (_tmp45_, 13, _tmp47_, -1, _tmp48_);
#line 149 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp49_ = res;
#line 149 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp49_ == SQLITE_OK, "res == Sqlite.OK");
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp50_ = stmt;
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp51_ = video_row->comment;
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp52_ = g_strdup (_tmp51_);
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp53_ = g_free;
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_text (_tmp50_, 14, _tmp52_, -1, _tmp53_);
#line 151 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp54_ = res;
#line 151 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp54_ == SQLITE_OK, "res == Sqlite.OK");
#line 153 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp55_ = stmt;
#line 153 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp55_);
#line 154 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp56_ = res;
#line 154 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp56_ != SQLITE_DONE) {
#line 1205 "VideoTable.c"
		gint _tmp57_;
#line 155 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp57_ = res;
#line 155 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_tmp57_ != SQLITE_CONSTRAINT) {
#line 1211 "VideoTable.c"
			gint _tmp58_;
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp58_ = res;
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			database_table_throw_error ("VideoTable.add", _tmp58_, &_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					return;
#line 1227 "VideoTable.c"
				} else {
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					g_clear_error (&_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					return;
#line 1237 "VideoTable.c"
				}
			}
		}
	}
#line 160 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp59_ = database_table_db;
#line 160 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_id_init (&video_row->video_id, sqlite3_last_insert_rowid (_tmp59_));
#line 161 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	event_id_init (&video_row->event_id, EVENT_ID_INVALID);
#line 162 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp60_ = time_created;
#line 162 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_row->time_created = (time_t) _tmp60_;
#line 163 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_row->flags = (guint64) 0;
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp61_ = video_row->video_id;
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	*result = _tmp61_;
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return;
#line 1262 "VideoTable.c"
}


gboolean
video_table_drop_event (VideoTable* self,
                        EventID* event_id)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	EventID _tmp7_;
	gint64 _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_;
	gint _tmp11_;
#line 168 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 168 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE VideoTable SET event_id = ? WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 171 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 171 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 173 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 173 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, EVENT_ID_INVALID);
#line 174 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = res;
#line 174 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp5_ == SQLITE_OK, "res == Sqlite.OK");
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = stmt;
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = *event_id;
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = _tmp7_.id;
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp6_, 2, _tmp8_);
#line 176 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = res;
#line 176 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 178 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = stmt;
#line 178 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp10_);
#line 179 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = res;
#line 179 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp11_ != SQLITE_DONE) {
#line 1331 "VideoTable.c"
		gint _tmp12_;
#line 180 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp12_ = res;
#line 180 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_fatal ("VideoTable.drop_event", _tmp12_);
#line 182 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		result = FALSE;
#line 182 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 182 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return result;
#line 1343 "VideoTable.c"
	}
#line 185 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = TRUE;
#line 185 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 185 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 1351 "VideoTable.c"
}


VideoRow*
video_table_get_row (VideoTable* self,
                     VideoID* video_id)
{
	VideoRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	VideoID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	VideoRow* row = NULL;
	VideoRow* _tmp9_;
	VideoRow* _tmp10_;
	VideoID _tmp11_;
	VideoRow* _tmp12_;
	sqlite3_stmt* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	VideoRow* _tmp16_;
	sqlite3_stmt* _tmp17_;
	VideoRow* _tmp18_;
	sqlite3_stmt* _tmp19_;
	VideoRow* _tmp20_;
	sqlite3_stmt* _tmp21_;
	VideoRow* _tmp22_;
	sqlite3_stmt* _tmp23_;
	VideoRow* _tmp24_;
	sqlite3_stmt* _tmp25_;
	VideoRow* _tmp26_;
	sqlite3_stmt* _tmp27_;
	VideoRow* _tmp28_;
	sqlite3_stmt* _tmp29_;
	VideoRow* _tmp30_;
	sqlite3_stmt* _tmp31_;
	VideoRow* _tmp32_;
	sqlite3_stmt* _tmp33_;
	VideoRow* _tmp34_;
	sqlite3_stmt* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	VideoRow* _tmp38_;
	sqlite3_stmt* _tmp39_;
	VideoRow* _tmp40_;
	sqlite3_stmt* _tmp41_;
	VideoRow* _tmp42_;
	sqlite3_stmt* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	VideoRow* _tmp46_;
	sqlite3_stmt* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	VideoRow* _tmp50_;
	sqlite3_stmt* _tmp51_;
	VideoRow* _tmp52_;
	sqlite3_stmt* _tmp53_;
	VideoRow* _tmp54_;
	sqlite3_stmt* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
#line 188 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 188 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (video_id != NULL, NULL);
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filename, width, height, clip_duration, is_interpretable, files" \
"ize, timestamp, " "exposure_time, import_id, event_id, md5, time_created, rating, title, " \
"backlinks, " "time_reimported, flags, comment FROM VideoTable WHERE id=?", -1, &_tmp1_, NULL);
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 195 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 195 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = *video_id;
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 198 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = res;
#line 198 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 200 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = stmt;
#line 200 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (sqlite3_step (_tmp8_) != SQLITE_ROW) {
#line 201 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		result = NULL;
#line 201 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 201 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return result;
#line 1461 "VideoTable.c"
	}
#line 203 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = video_row_new ();
#line 203 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	row = _tmp9_;
#line 204 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = row;
#line 204 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = *video_id;
#line 204 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_->video_id = _tmp11_;
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = row;
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = stmt;
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_ = sqlite3_column_text (_tmp13_, 0);
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp12_->filepath);
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_->filepath = _tmp15_;
#line 206 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp16_ = row;
#line 206 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp17_ = stmt;
#line 206 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp16_->width = sqlite3_column_int (_tmp17_, 1);
#line 207 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp18_ = row;
#line 207 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp19_ = stmt;
#line 207 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp18_->height = sqlite3_column_int (_tmp19_, 2);
#line 208 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp20_ = row;
#line 208 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp21_ = stmt;
#line 208 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp20_->clip_duration = sqlite3_column_double (_tmp21_, 3);
#line 209 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp22_ = row;
#line 209 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp23_ = stmt;
#line 209 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp22_->is_interpretable = sqlite3_column_int (_tmp23_, 4) == 1;
#line 210 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp24_ = row;
#line 210 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp25_ = stmt;
#line 210 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp24_->filesize = sqlite3_column_int64 (_tmp25_, 5);
#line 211 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp26_ = row;
#line 211 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp27_ = stmt;
#line 211 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp26_->timestamp = (time_t) sqlite3_column_int64 (_tmp27_, 6);
#line 212 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp28_ = row;
#line 212 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp29_ = stmt;
#line 212 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp28_->exposure_time = (time_t) sqlite3_column_int64 (_tmp29_, 7);
#line 213 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp30_ = row;
#line 213 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp31_ = stmt;
#line 213 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp30_->import_id.id = sqlite3_column_int64 (_tmp31_, 8);
#line 214 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp32_ = row;
#line 214 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp33_ = stmt;
#line 214 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp32_->event_id.id = sqlite3_column_int64 (_tmp33_, 9);
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp34_ = row;
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp35_ = stmt;
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp36_ = sqlite3_column_text (_tmp35_, 10);
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp37_ = g_strdup (_tmp36_);
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp34_->md5);
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp34_->md5 = _tmp37_;
#line 216 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp38_ = row;
#line 216 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp39_ = stmt;
#line 216 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp38_->time_created = (time_t) sqlite3_column_int64 (_tmp39_, 11);
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp40_ = row;
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp41_ = stmt;
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp40_->rating = rating_unserialize (sqlite3_column_int (_tmp41_, 12));
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp42_ = row;
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp43_ = stmt;
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp44_ = sqlite3_column_text (_tmp43_, 13);
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp42_->title);
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp42_->title = _tmp45_;
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp46_ = row;
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp47_ = stmt;
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp48_ = sqlite3_column_text (_tmp47_, 14);
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp49_ = g_strdup (_tmp48_);
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp46_->backlinks);
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp46_->backlinks = _tmp49_;
#line 220 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp50_ = row;
#line 220 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp51_ = stmt;
#line 220 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp50_->time_reimported = (time_t) sqlite3_column_int64 (_tmp51_, 15);
#line 221 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp52_ = row;
#line 221 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp53_ = stmt;
#line 221 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp52_->flags = (guint64) sqlite3_column_int64 (_tmp53_, 16);
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp54_ = row;
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp55_ = stmt;
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp56_ = sqlite3_column_text (_tmp55_, 17);
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp57_ = g_strdup (_tmp56_);
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp54_->comment);
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp54_->comment = _tmp57_;
#line 224 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = row;
#line 224 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 224 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 1617 "VideoTable.c"
}


GeeArrayList*
video_table_get_all (VideoTable* self)
{
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp4_;
#line 227 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, filename, width, height, clip_duration, is_interpretable, f" \
"ilesize, " "timestamp, exposure_time, import_id, event_id, md5, time_created, rati" \
"ng, title, " "backlinks, time_reimported, flags, comment FROM VideoTable", -1, &_tmp1_, NULL);
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 234 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 236 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_VIDEO_ROW, (GBoxedCopyFunc) video_row_ref, (GDestroyNotify) video_row_unref, NULL, NULL, NULL);
#line 236 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	all = _tmp4_;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	while (TRUE) {
#line 1655 "VideoTable.c"
		sqlite3_stmt* _tmp5_;
		gint _tmp6_;
		VideoRow* row = NULL;
		VideoRow* _tmp7_;
		VideoRow* _tmp8_;
		sqlite3_stmt* _tmp9_;
		VideoRow* _tmp10_;
		sqlite3_stmt* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		VideoRow* _tmp14_;
		sqlite3_stmt* _tmp15_;
		VideoRow* _tmp16_;
		sqlite3_stmt* _tmp17_;
		VideoRow* _tmp18_;
		sqlite3_stmt* _tmp19_;
		VideoRow* _tmp20_;
		sqlite3_stmt* _tmp21_;
		VideoRow* _tmp22_;
		sqlite3_stmt* _tmp23_;
		VideoRow* _tmp24_;
		sqlite3_stmt* _tmp25_;
		VideoRow* _tmp26_;
		sqlite3_stmt* _tmp27_;
		VideoRow* _tmp28_;
		sqlite3_stmt* _tmp29_;
		VideoRow* _tmp30_;
		sqlite3_stmt* _tmp31_;
		VideoRow* _tmp32_;
		sqlite3_stmt* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		VideoRow* _tmp36_;
		sqlite3_stmt* _tmp37_;
		VideoRow* _tmp38_;
		sqlite3_stmt* _tmp39_;
		VideoRow* _tmp40_;
		sqlite3_stmt* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		VideoRow* _tmp44_;
		sqlite3_stmt* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		VideoRow* _tmp48_;
		sqlite3_stmt* _tmp49_;
		VideoRow* _tmp50_;
		sqlite3_stmt* _tmp51_;
		VideoRow* _tmp52_;
		sqlite3_stmt* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		GeeArrayList* _tmp56_;
		VideoRow* _tmp57_;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp5_ = stmt;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = sqlite3_step (_tmp5_);
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp6_ = res;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (!(_tmp6_ == SQLITE_ROW)) {
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			break;
#line 1720 "VideoTable.c"
		}
#line 239 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp7_ = video_row_new ();
#line 239 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		row = _tmp7_;
#line 240 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp8_ = row;
#line 240 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp9_ = stmt;
#line 240 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp8_->video_id.id = sqlite3_column_int64 (_tmp9_, 0);
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp10_ = row;
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp11_ = stmt;
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp12_ = sqlite3_column_text (_tmp11_, 1);
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp10_->filepath);
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp10_->filepath = _tmp13_;
#line 242 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp14_ = row;
#line 242 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp15_ = stmt;
#line 242 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp14_->width = sqlite3_column_int (_tmp15_, 2);
#line 243 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp16_ = row;
#line 243 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp17_ = stmt;
#line 243 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp16_->height = sqlite3_column_int (_tmp17_, 3);
#line 244 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp18_ = row;
#line 244 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp19_ = stmt;
#line 244 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp18_->clip_duration = sqlite3_column_double (_tmp19_, 4);
#line 245 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp20_ = row;
#line 245 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp21_ = stmt;
#line 245 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp20_->is_interpretable = sqlite3_column_int (_tmp21_, 5) == 1;
#line 246 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp22_ = row;
#line 246 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp23_ = stmt;
#line 246 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp22_->filesize = sqlite3_column_int64 (_tmp23_, 6);
#line 247 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp24_ = row;
#line 247 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp25_ = stmt;
#line 247 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp24_->timestamp = (time_t) sqlite3_column_int64 (_tmp25_, 7);
#line 248 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp26_ = row;
#line 248 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp27_ = stmt;
#line 248 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp26_->exposure_time = (time_t) sqlite3_column_int64 (_tmp27_, 8);
#line 249 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp28_ = row;
#line 249 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp29_ = stmt;
#line 249 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp28_->import_id.id = sqlite3_column_int64 (_tmp29_, 9);
#line 250 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp30_ = row;
#line 250 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp31_ = stmt;
#line 250 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp30_->event_id.id = sqlite3_column_int64 (_tmp31_, 10);
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp32_ = row;
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp33_ = stmt;
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp34_ = sqlite3_column_text (_tmp33_, 11);
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp35_ = g_strdup (_tmp34_);
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp32_->md5);
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp32_->md5 = _tmp35_;
#line 252 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp36_ = row;
#line 252 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp37_ = stmt;
#line 252 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp36_->time_created = (time_t) sqlite3_column_int64 (_tmp37_, 12);
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp38_ = row;
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp39_ = stmt;
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp38_->rating = rating_unserialize (sqlite3_column_int (_tmp39_, 13));
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp40_ = row;
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp41_ = stmt;
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp42_ = sqlite3_column_text (_tmp41_, 14);
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp43_ = g_strdup (_tmp42_);
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp40_->title);
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp40_->title = _tmp43_;
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp44_ = row;
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp45_ = stmt;
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp46_ = sqlite3_column_text (_tmp45_, 15);
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp47_ = g_strdup (_tmp46_);
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp44_->backlinks);
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp44_->backlinks = _tmp47_;
#line 256 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp48_ = row;
#line 256 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp49_ = stmt;
#line 256 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp48_->time_reimported = (time_t) sqlite3_column_int64 (_tmp49_, 16);
#line 257 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp50_ = row;
#line 257 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp51_ = stmt;
#line 257 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp50_->flags = (guint64) sqlite3_column_int64 (_tmp51_, 17);
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp52_ = row;
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp53_ = stmt;
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp54_ = sqlite3_column_text (_tmp53_, 18);
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp55_ = g_strdup (_tmp54_);
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp52_->comment);
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp52_->comment = _tmp55_;
#line 260 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp56_ = all;
#line 260 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp57_ = row;
#line 260 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp57_);
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_video_row_unref0 (row);
#line 1878 "VideoTable.c"
	}
#line 263 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = all;
#line 263 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 263 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 1886 "VideoTable.c"
}


void
video_table_set_filepath (VideoTable* self,
                          VideoID* video_id,
                          const gchar* filepath,
                          GError** error)
{
	VideoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 266 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 266 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (filepath != NULL);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "filename", filepath, &_inner_error_);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 1919 "VideoTable.c"
		} else {
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 1927 "VideoTable.c"
		}
	}
}


void
video_table_set_title (VideoTable* self,
                       VideoID* video_id,
                       const gchar* new_title,
                       GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 270 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 270 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (new_title != NULL) {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = new_title;
#line 1951 "VideoTable.c"
	} else {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = "";
#line 1955 "VideoTable.c"
	}
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = *video_id;
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "title", _tmp0_, &_inner_error_);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 1971 "VideoTable.c"
		} else {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 1979 "VideoTable.c"
		}
	}
}


void
video_table_set_comment (VideoTable* self,
                         VideoID* video_id,
                         const gchar* new_comment,
                         GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 274 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (new_comment != NULL) {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = new_comment;
#line 2003 "VideoTable.c"
	} else {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = "";
#line 2007 "VideoTable.c"
	}
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = *video_id;
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "comment", _tmp0_, &_inner_error_);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2023 "VideoTable.c"
		} else {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2031 "VideoTable.c"
		}
	}
}


void
video_table_set_exposure_time (VideoTable* self,
                               VideoID* video_id,
                               time_t time,
                               GError** error)
{
	VideoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 278 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "exposure_time", (gint64) time, &_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2064 "VideoTable.c"
		} else {
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2072 "VideoTable.c"
		}
	}
}


void
video_table_set_rating (VideoTable* self,
                        VideoID* video_id,
                        Rating rating,
                        GError** error)
{
	VideoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 282 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "rating", (gint64) rating_serialize (rating), &_inner_error_);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2105 "VideoTable.c"
		} else {
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2113 "VideoTable.c"
		}
	}
}


void
video_table_set_flags (VideoTable* self,
                       VideoID* video_id,
                       guint64 flags,
                       GError** error)
{
	VideoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 286 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 286 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "flags", (gint64) flags, &_inner_error_);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2146 "VideoTable.c"
		} else {
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2154 "VideoTable.c"
		}
	}
}


void
video_table_update_backlinks (VideoTable* self,
                              VideoID* video_id,
                              const gchar* backlinks,
                              GError** error)
{
	const gchar* _tmp0_ = NULL;
	VideoID _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 290 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 290 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (backlinks != NULL) {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = backlinks;
#line 2178 "VideoTable.c"
	} else {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = "";
#line 2182 "VideoTable.c"
	}
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = *video_id;
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "backlinks", _tmp0_, &_inner_error_);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2198 "VideoTable.c"
		} else {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2206 "VideoTable.c"
		}
	}
}


void
video_table_update_is_interpretable (VideoTable* self,
                                     VideoID* video_id,
                                     gboolean is_interpretable,
                                     GError** error)
{
	gint _tmp0_ = 0;
	VideoID _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 294 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 294 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (is_interpretable) {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = 1;
#line 2230 "VideoTable.c"
	} else {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = 0;
#line 2234 "VideoTable.c"
	}
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = *video_id;
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "is_interpretable", _tmp0_, &_inner_error_);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2250 "VideoTable.c"
		} else {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2258 "VideoTable.c"
		}
	}
}


gboolean
video_table_set_event (VideoTable* self,
                       VideoID* video_id,
                       EventID* event_id)
{
	gboolean result = FALSE;
	VideoID _tmp0_;
	gint64 _tmp1_;
	EventID _tmp2_;
	gint64 _tmp3_;
#line 298 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 298 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (video_id != NULL, FALSE);
#line 298 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = *event_id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "event_id", _tmp3_);
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2292 "VideoTable.c"
}


void
video_table_remove_by_file (VideoTable* self,
                            GFile* file,
                            GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
#line 302 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 302 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM VideoTable WHERE filename=?", -1, &_tmp1_, NULL);
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 305 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 305 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = g_file_get_path (file);
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = g_free;
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp5_, -1, _tmp6_);
#line 308 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = res;
#line 308 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 310 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = stmt;
#line 310 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp8_);
#line 311 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = res;
#line 311 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp9_ != SQLITE_DONE) {
#line 2352 "VideoTable.c"
		gint _tmp10_;
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp10_ = res;
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_throw_error ("VideoTable.remove_by_file", _tmp10_, &_inner_error_);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2368 "VideoTable.c"
			} else {
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_clear_error (&_inner_error_);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2378 "VideoTable.c"
			}
		}
	}
#line 302 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 2384 "VideoTable.c"
}


void
video_table_remove (VideoTable* self,
                    VideoID* videoID,
                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	VideoID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
#line 315 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 315 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (videoID != NULL);
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM VideoTable WHERE id=?", -1, &_tmp1_, NULL);
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 318 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 318 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = *videoID;
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 321 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = res;
#line 321 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 323 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = stmt;
#line 323 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp8_);
#line 324 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = res;
#line 324 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp9_ != SQLITE_DONE) {
#line 2444 "VideoTable.c"
		gint _tmp10_;
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp10_ = res;
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_throw_error ("VideoTable.remove", _tmp10_, &_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2460 "VideoTable.c"
			} else {
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_clear_error (&_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2470 "VideoTable.c"
			}
		}
	}
#line 315 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 2476 "VideoTable.c"
}


gboolean
video_table_is_video_stored (VideoTable* self,
                             GFile* file)
{
	gboolean result = FALSE;
	VideoID _tmp0_ = {0};
#line 328 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 328 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_table_get_id (self, file, &_tmp0_);
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = video_id_is_valid (&_tmp0_);
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2496 "VideoTable.c"
}


void
video_table_get_id (VideoTable* self,
                    GFile* file,
                    VideoID* result)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	VideoID _tmp9_ = {0};
	gint _tmp10_;
#line 332 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 332 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT ID FROM VideoTable WHERE filename=?", -1, &_tmp1_, NULL);
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 335 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 335 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = g_file_get_path (file);
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = g_free;
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp5_, -1, _tmp6_);
#line 338 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = res;
#line 338 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 340 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = stmt;
#line 340 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp8_);
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = res;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp10_ == SQLITE_ROW) {
#line 2556 "VideoTable.c"
		sqlite3_stmt* _tmp11_;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp11_ = stmt;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_id_init (&_tmp9_, sqlite3_column_int64 (_tmp11_, 0));
#line 2562 "VideoTable.c"
	} else {
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_id_init (&_tmp9_, VIDEO_ID_INVALID);
#line 2566 "VideoTable.c"
	}
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	*result = _tmp9_;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return;
#line 2574 "VideoTable.c"
}


GeeArrayList*
video_table_get_videos (VideoTable* self,
                        GError** error)
{
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* video_ids = NULL;
	GeeArrayList* _tmp4_;
	GError * _inner_error_ = NULL;
#line 345 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM VideoTable", -1, &_tmp1_, NULL);
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 348 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 348 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 350 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_VIDEO_ID, (GBoxedCopyFunc) video_id_dup, (GDestroyNotify) video_id_free, NULL, NULL, NULL);
#line 350 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_ids = _tmp4_;
#line 2612 "VideoTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp5_ = TRUE;
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		while (TRUE) {
#line 2619 "VideoTable.c"
			sqlite3_stmt* _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp10_;
			sqlite3_stmt* _tmp11_;
			VideoID _tmp12_ = {0};
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (!_tmp5_) {
#line 2627 "VideoTable.c"
			}
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp5_ = FALSE;
#line 352 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp6_ = stmt;
#line 352 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			res = sqlite3_step (_tmp6_);
#line 353 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp7_ = res;
#line 353 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_tmp7_ == SQLITE_DONE) {
#line 354 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				break;
#line 2641 "VideoTable.c"
			} else {
				gint _tmp8_;
#line 355 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_tmp8_ = res;
#line 355 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				if (_tmp8_ != SQLITE_ROW) {
#line 2648 "VideoTable.c"
					gint _tmp9_;
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_tmp9_ = res;
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					database_table_throw_error ("VideoTable.get_videos", _tmp9_, &_inner_error_);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							g_propagate_error (error, _inner_error_);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_g_object_unref0 (video_ids);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_sqlite3_finalize0 (stmt);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							return NULL;
#line 2666 "VideoTable.c"
						} else {
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_g_object_unref0 (video_ids);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_sqlite3_finalize0 (stmt);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							g_clear_error (&_inner_error_);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							return NULL;
#line 2678 "VideoTable.c"
						}
					}
				}
			}
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp10_ = video_ids;
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp11_ = stmt;
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			video_id_init (&_tmp12_, sqlite3_column_int64 (_tmp11_, 0));
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp12_);
#line 2691 "VideoTable.c"
		}
	}
#line 362 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = video_ids;
#line 362 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 362 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2700 "VideoTable.c"
}


static sqlite3_stmt*
video_table_get_duplicate_stmt (VideoTable* self,
                                GFile* file,
                                const gchar* md5)
{
	sqlite3_stmt* result = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* sql = NULL;
	gchar* _tmp1_;
	gboolean first = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp9_;
	const gchar* _tmp10_;
	sqlite3_stmt* _tmp11_ = NULL;
	gint _tmp12_;
	gint _tmp13_;
	gint col = 0;
#line 365 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 365 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (file != NULL) {
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = TRUE;
#line 2730 "VideoTable.c"
	} else {
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = md5 != NULL;
#line 2734 "VideoTable.c"
	}
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp0_, "file != null || md5 != null");
#line 368 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = g_strdup ("SELECT id FROM VideoTable WHERE");
#line 368 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	sql = _tmp1_;
#line 369 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	first = TRUE;
#line 371 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (file != NULL) {
#line 2746 "VideoTable.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp2_ = sql;
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp3_ = g_strconcat (_tmp2_, " filename=?", NULL);
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (sql);
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		sql = _tmp3_;
#line 373 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		first = FALSE;
#line 2759 "VideoTable.c"
	}
#line 376 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (md5 != NULL) {
#line 2763 "VideoTable.c"
		gboolean _tmp4_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
#line 377 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp4_ = first;
#line 377 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (!_tmp4_) {
#line 2771 "VideoTable.c"
			const gchar* _tmp5_;
			gchar* _tmp6_;
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp5_ = sql;
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp6_ = g_strconcat (_tmp5_, " OR ", NULL);
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_g_free0 (sql);
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			sql = _tmp6_;
#line 2782 "VideoTable.c"
		}
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp7_ = sql;
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp8_ = g_strconcat (_tmp7_, " md5=?", NULL);
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (sql);
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		sql = _tmp8_;
#line 2792 "VideoTable.c"
	}
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = database_table_db;
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = sql;
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = sqlite3_prepare_v2 (_tmp9_, _tmp10_, -1, &_tmp11_, NULL);
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp11_;
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp12_;
#line 385 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = res;
#line 385 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 387 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	col = 1;
#line 389 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (file != NULL) {
#line 2814 "VideoTable.c"
		sqlite3_stmt* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
		GDestroyNotify _tmp17_;
		gint _tmp18_;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp14_ = stmt;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp15_ = col;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		col = _tmp15_ + 1;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp16_ = g_file_get_path (file);
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp17_ = g_free;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = sqlite3_bind_text (_tmp14_, _tmp15_, _tmp16_, -1, _tmp17_);
#line 391 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp18_ = res;
#line 391 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_vala_assert (_tmp18_ == SQLITE_OK, "res == Sqlite.OK");
#line 2836 "VideoTable.c"
	}
#line 394 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (md5 != NULL) {
#line 2840 "VideoTable.c"
		sqlite3_stmt* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_;
		GDestroyNotify _tmp22_;
		gint _tmp23_;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp19_ = stmt;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp20_ = col;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		col = _tmp20_ + 1;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp21_ = g_strdup (md5);
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp22_ = g_free;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = sqlite3_bind_text (_tmp19_, _tmp20_, _tmp21_, -1, _tmp22_);
#line 396 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp23_ = res;
#line 396 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_vala_assert (_tmp23_ == SQLITE_OK, "res == Sqlite.OK");
#line 2862 "VideoTable.c"
	}
#line 399 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = stmt;
#line 399 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (sql);
#line 399 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2870 "VideoTable.c"
}


gboolean
video_table_has_duplicate (VideoTable* self,
                           GFile* file,
                           const gchar* md5)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gint _tmp2_;
#line 402 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 402 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 403 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = video_table_get_duplicate_stmt (self, file, md5);
#line 403 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp0_;
#line 404 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = stmt;
#line 404 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp1_);
#line 406 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = res;
#line 406 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp2_ == SQLITE_DONE) {
#line 408 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		result = FALSE;
#line 408 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 408 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return result;
#line 2907 "VideoTable.c"
	} else {
		gint _tmp3_;
#line 409 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp3_ = res;
#line 409 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_tmp3_ == SQLITE_ROW) {
#line 411 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			result = TRUE;
#line 411 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 411 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return result;
#line 2920 "VideoTable.c"
		} else {
			gint _tmp4_;
#line 413 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp4_ = res;
#line 413 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			database_table_fatal ("VideoTable.has_duplicate", _tmp4_);
#line 2927 "VideoTable.c"
		}
	}
#line 416 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = FALSE;
#line 416 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 416 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2936 "VideoTable.c"
}


static void
_vala_array_add3 (VideoID* * array,
                  int* length,
                  int* size,
                  const VideoID* value)
{
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if ((*length) == (*size)) {
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*array = g_renew (VideoID, *array, *size);
#line 2952 "VideoTable.c"
	}
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	(*array)[(*length)++] = *value;
#line 2956 "VideoTable.c"
}


VideoID*
video_table_get_duplicate_ids (VideoTable* self,
                               GFile* file,
                               const gchar* md5,
                               int* result_length1)
{
	VideoID* result = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	VideoID* ids = NULL;
	VideoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gint res = 0;
	sqlite3_stmt* _tmp2_;
	VideoID* _tmp8_;
	gint _tmp8__length1;
#line 419 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 419 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 420 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = video_table_get_duplicate_stmt (self, file, md5);
#line 420 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp0_;
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = g_new0 (VideoID, 0);
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	ids = _tmp1_;
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	ids_length1 = 0;
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_ids_size_ = ids_length1;
#line 424 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = stmt;
#line 424 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_step (_tmp2_);
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	while (TRUE) {
#line 2999 "VideoTable.c"
		gint _tmp3_;
		VideoID* _tmp4_;
		gint _tmp4__length1;
		sqlite3_stmt* _tmp5_;
		VideoID _tmp6_ = {0};
		sqlite3_stmt* _tmp7_;
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp3_ = res;
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (!(_tmp3_ == SQLITE_ROW)) {
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			break;
#line 3012 "VideoTable.c"
		}
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp4_ = ids;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp4__length1 = ids_length1;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp5_ = stmt;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_id_init (&_tmp6_, sqlite3_column_int64 (_tmp5_, 0));
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_vala_array_add3 (&ids, &ids_length1, &_ids_size_, &_tmp6_);
#line 427 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp7_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = sqlite3_step (_tmp7_);
#line 3028 "VideoTable.c"
	}
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = ids;
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8__length1 = ids_length1;
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (result_length1) {
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*result_length1 = _tmp8__length1;
#line 3038 "VideoTable.c"
	}
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp8_;
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 3046 "VideoTable.c"
}


GeeArrayList*
video_table_get_event_source_ids (VideoTable* self,
                                  EventID* event_id)
{
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	EventID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp8_;
#line 433 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 433 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM VideoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 436 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 436 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = *event_id;
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 439 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = res;
#line 439 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 441 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 441 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_result_ = _tmp8_;
#line 3101 "VideoTable.c"
	{
		gboolean _tmp9_ = FALSE;
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp9_ = TRUE;
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		while (TRUE) {
#line 3108 "VideoTable.c"
			sqlite3_stmt* _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp14_;
			sqlite3_stmt* _tmp15_;
			VideoID _tmp16_ = {0};
			gchar* _tmp17_;
			gchar* _tmp18_;
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (!_tmp9_) {
#line 3118 "VideoTable.c"
			}
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp9_ = FALSE;
#line 443 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp10_ = stmt;
#line 443 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			res = sqlite3_step (_tmp10_);
#line 444 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp11_ = res;
#line 444 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_tmp11_ == SQLITE_DONE) {
#line 445 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				break;
#line 3132 "VideoTable.c"
			} else {
				gint _tmp12_;
#line 446 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_tmp12_ = res;
#line 446 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				if (_tmp12_ != SQLITE_ROW) {
#line 3139 "VideoTable.c"
					gint _tmp13_;
#line 447 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_tmp13_ = res;
#line 447 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					database_table_fatal ("get_event_source_ids", _tmp13_);
#line 449 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					break;
#line 3147 "VideoTable.c"
				}
			}
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp14_ = _result_;
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp15_ = stmt;
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			video_id_init (&_tmp16_, sqlite3_column_int64 (_tmp15_, 0));
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp17_ = video_id_upgrade_video_id_to_source_id (&_tmp16_);
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp18_ = _tmp17_;
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp18_);
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_g_free0 (_tmp18_);
#line 3164 "VideoTable.c"
		}
	}
#line 455 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _result_;
#line 455 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 455 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 3173 "VideoTable.c"
}


void
video_table_set_timestamp (VideoTable* self,
                           VideoID* video_id,
                           time_t timestamp,
                           GError** error)
{
	VideoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 458 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 458 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "timestamp", (gint64) timestamp, &_inner_error_);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 3204 "VideoTable.c"
		} else {
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 3212 "VideoTable.c"
		}
	}
}


static void
video_table_class_init (VideoTableClass * klass)
{
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_table_parent_class = g_type_class_peek_parent (klass);
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	((DatabaseTableClass *) klass)->finalize = video_table_finalize;
#line 3225 "VideoTable.c"
}


static void
video_table_instance_init (VideoTable * self)
{
}


static void
video_table_finalize (DatabaseTable * obj)
{
	VideoTable * self;
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_TABLE, VideoTable);
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	DATABASE_TABLE_CLASS (video_table_parent_class)->finalize (obj);
#line 3243 "VideoTable.c"
}


GType
video_table_get_type (void)
{
	static volatile gsize video_table_type_id__volatile = 0;
	if (g_once_init_enter (&video_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoTable), 0, (GInstanceInitFunc) video_table_instance_init, NULL };
		GType video_table_type_id;
		video_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "VideoTable", &g_define_type_info, 0);
		g_once_init_leave (&video_table_type_id__volatile, video_table_type_id);
	}
	return video_table_type_id__volatile;
}



