/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.broadinstitute.sting.utils.pileup.MergingPileupElementIterator;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElementTracker;

class PerSamplePileupElementTracker<PE extends PileupElement>
extends PileupElementTracker<PE> {
    private final Map<String, PileupElementTracker<PE>> pileup = new HashMap<String, PileupElementTracker<PE>>();
    private int size = 0;

    public Collection<String> getSamples() {
        return this.pileup.keySet();
    }

    public PileupElementTracker<PE> getElements(String sample) {
        return this.pileup.get(sample);
    }

    public PileupElementTracker<PE> getElements(Collection<String> selectSampleNames) {
        PerSamplePileupElementTracker<PE> result = new PerSamplePileupElementTracker<PE>();
        for (String sample : selectSampleNames) {
            result.addElements(sample, this.pileup.get(sample));
        }
        return result;
    }

    public void addElements(String sample, PileupElementTracker<PE> elements) {
        this.pileup.put(sample, elements);
        this.size += elements.size();
    }

    @Override
    public Iterator<PE> iterator() {
        return new MergingPileupElementIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }
}

