//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Type/Unit.h
//! @brief     Defines class Unit
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_TYPE_UNIT_H
#define BORNAGAIN_GUI_SUPPORT_TYPE_UNIT_H

class QString;

//! Defines units, mainly to be able to convert between units.
//!
//! E.g. internal unit is nanometer, displayed unit is angstrom.
//! Units which do not support conversion do not have to be
//! part of the enum, since the relevant code parts support defining a
//! unit via enum or via string
enum class Unit {
    unitless,
    nanometer,
    nanometer2,
    nanometerMinus2,
    angstrom,
    angstrom2,
    angstromMinus2,
    degree,
    radiant,
    other //!< The unit has no enum value defined in here (e.g. when defined as an explicit string)
};

//! Convert the given value d from unit "from" to unit "to"
//! Throws an exception if no conversion possible.
double convert(double d, Unit from, Unit to);

//! Returns the string for the given unit
QString unitAsString(const Unit& unit);

#endif // BORNAGAIN_GUI_SUPPORT_TYPE_UNIT_H
