/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MAINBOARD_GOOGLE_RAURU_GPIO_H__
#define __MAINBOARD_GOOGLE_RAURU_GPIO_H__

#include <soc/gpio.h>

#define GPIO_BEEP_ON_OD		GPIO(PERIPHERAL_EN1)
#define GPIO_EN_SPKR		GPIO(PERIPHERAL_EN0)
#define GPIO_SD_CD_AP_ODL	GPIO(EINT11)
#define GPIO_GSC_AP_INT_ODL	GPIO(EINT18)
#define GPIO_EC_AP_INT_ODL	GPIO(EINT19)
#define GPIO_XHCI_INIT_DONE	GPIO(EINT28)
#define GPIO_AP_EC_WARM_RST_REQ GPIO(EINT29)
#define GPIO_FP_RST_1V8_S3_L	GPIO(EINT26)
#define GPIO_AP_FP_FW_UP_STRAP	GPIO(EINT27)
#define GPIO_EN_PWR_FP		GPIO(PERIPHERAL_EN3)
#define GPIO_BL_PWM_1V8		GPIO(DISP_PWM)

#define GPIO_AP_EDP_BKLTEN	GPIO(PERIPHERAL_EN4)
#define GPIO_EN_PP3300_EDP_X	GPIO(PERIPHERAL_EN2)
#define GPIO_EDP_HPD_1V8	GPIO(EINT13)

#define GPIO_I2SI4_BCK		GPIO(I2SIN1_BCK)
#define GPIO_I2SI4_LRCK		GPIO(I2SIN1_LRCK)
#define GPIO_I2SO4_D0		GPIO(I2SOUT1_DO)

#define GPIO_I2SI6_MCK		GPIO(I2SIN0_MCK)
#define GPIO_I2SI6_BCK		GPIO(I2SIN0_BCK)
#define GPIO_I2SI6_LRCK		GPIO(I2SIN0_LRCK)
#define GPIO_I2SO6_D0		GPIO(I2SOUT0_DO)

void setup_chromeos_gpios(void);

#endif
