#ifndef INC_ATOMTYPE_H
#define INC_ATOMTYPE_H
#include "ParameterTypes.h"
/// Hold parameters for a unique atom type
class AtomType {
  public:
    AtomType() : mass_(0.0), oidx_(-1) {}
    AtomType(double r, double d, int o) : lj_(r, d), mass_(0.0), oidx_(o) {} // TODO deprecate
    /// Mass only
    AtomType(double m) : mass_(m), oidx_(-1) {}
    /// Radius, well depth, mass
    AtomType(double r, double d, double m) : lj_(r, d), mass_(m), oidx_(-1) {}
    /// \return default LJ parameters
    LJparmType const& LJ() const { return lj_; }
    /// \return Atom mass in amu
    double Mass()          const { return mass_;   }
    /// \return Original atom type index. Useful when checking for off-diagonal NB parameters.
    int OriginalIdx()      const { return oidx_; }
    /// \return true if LJ params are less than incoming
    bool operator<(AtomType const& rhs) const { return lj_ < rhs.lj_; }
    /// \return true if LJ params are the same
    bool operator==(AtomType const& rhs) const { return lj_ == rhs.lj_; }
    /// Used to modify LJ params
    LJparmType& SetLJ() { return lj_; }
    /// \return data size
    static size_t DataSize() { return (3*sizeof(double)) + sizeof(int); }
  private:
    LJparmType lj_; ///< Default Lennard-Jones parameters (always valid for self).
    double mass_;   ///< Mass in amu
    int oidx_; ///< Original atom type index. TODO deprecate
};
#endif
