dnl # This is the file that makes people every now and then come up
dnl # to me and ask:
dnl #
dnl # What window manager (or even: window system) are you running?
dnl #
dnl # Oh.. just a heavily adapted vanilla twm with Xwindows.
dnl #
dnl # ... hmm not anymore..
dnl #   but it still looks funky even without ctwm..
dnl #
dnl # Usage:
dnl #	"iconify" button: left = iconify, middle = vanish, right = close
dnl #	"menu"    button: left = occ.all, middle = menu,   right = autoraise
dnl #	"resize"  button: left = resize,  middle = z-menu, right = fullzoom
dnl #
dnl # Enjoy ctwm!  -LynX (http://my.pages.de/)
dnl #
# .twmrc is automatically generated from .ctwmrc with 'm4 .ctwmrc >.twmrc'

ifdef(`TWM_TYPE', `
PixmapDirectory		"/usr/include/X11/pixmaps/"
')
dnl # IconDirectory		"/usr/X11/lib/ctwm/icons/"

RestartPreviousState
NoDefaults
NoGrabServer
TitleFont "-*-times-*-i-*-*-*-180-*-*-*-*-*-*"
IconFont "-*-times-*-i-*-*-*-180-*-*-*-*-*-*"
MenuFont "-*-times-*-i-*-*-*-180-*-*-*-*-*-*"
ResizeFont "-*-times-*-i-*-*-*-180-*-*-*-*-*-*"
DecorateTransients
SqueezeTitle
AutoRelativeResize
DefaultFunction f.nop
DontMoveOff
WarpCursor
WindowRing { "XTerm" }
UsePPosition "non-zero"
#XorValue 1
dnl #IconManagerGeometry "150x150-1+0"
dnl #IconManagerDontShow { "xclock" "xbiff" "xload" "xeyes" }

ifdef(`TWM_TYPE', `
Function "move-or-raise" { f.movepush f.deltastop f.raise }
',`
Function "move-or-raise" { f.move f.deltastop f.raise }
')

ifdef(`TWM_TYPE', `
 LeftTitleButton "iconify.xbm" {
	Button1 : f.iconify
	Button2 : f.vanish
	Button3 : f.delete
 }
 RightTitleButton "menu.xbm" {
	Button1 : f.occupyall
	Button2 : f.menu "win"
	Button3 : f.autoraise
 } 
 RightTitleButton "zoom.xbm" {
	Button1 : f.resize
	Button2 : f.menu "zoom"
 	Button3 : f.fullzoom
 }
',`
 LeftTitleButton "iconify.xbm" = f.iconify
 LeftTitleButton "menu.xbm" = f.menu "win"
#RightTitleButton "kill.xbm" = f.destroy
 RightTitleButton "zoom.xbm" = f.menu "zoom"
 RightTitleButton "autoraise.xbm" = f.autoraise
 RightTitleButton "resize.xbm" = f.resize
')

Button1 =	: r	: f.menu "shells"
Button2 =	: r	: f.menu "control"
Button3 =	: r	: f.menu "menu"

dnl Button1 = s	: r	: f.iconify
dnl Button2 = s	: r	: f.showiconmgr
dnl Button3 = s	: r	: f.hideiconmgr
dnl 
dnl Button1 = c|m	: r	: f.focus
dnl Button2 = c|m	: r	: f.unfocus
dnl Button3 = c|m	: r	: f.destroy

Button1 = 	: t	: f.function "move-or-raise"
Button1 =	: i|m	: f.iconify
Button1 =	: f	: f.resize
Button2 =	: t|i|f	: f.move
Button2 = s	: t|i|f	: f.forcemove
Button3 =	: t|i|f	: f.lower

dnl Button1 = m	: w	: f.fullzoom
dnl Button2 = m	: w	: f.zoom
dnl Button3 = m	: w|i	: f.resize

ifdef(`TWM_TYPE', `
"Left"	=	: r|t|i	: f.leftworkspace
"Right"	=	: r|t|i	: f.rightworkspace

"F1"	=	: all	: f.gotoworkspace "WORK"
"F2"	=	: all	: f.gotoworkspace "SURF"
"F3"	=	: all	: f.gotoworkspace "CHAT"
"F4"	=	: all	: f.gotoworkspace "VIEW"
')
"F7"	=	: all	: f.warpring "prev"
"F8"	=	: all	: f.warpring "next"
"F9"	=	: all	: f.warpring "prev"
"F10"	=	: all	: f.warpring "next"
"F12"	=	: all	: f.warpto "IRC"	# hey! an IRC key!	;-)

menu "shells" {
""		f.menu "tools"
"xterm"		!"xterm &"
"netscape"	!"netscape -ncols 150 &" # -geometry 630x500
"mosaic"	!"xmosaic &"
"xman"		!"xman -fn symbol14 -bothshown -g -0+35 &"
"xcalc"		!"xcalc -g 140x230 &"
"xarchie"	!"xarchie &"
"irc"		!"xterm -g 80x14+0+0 -n IRC -T IRC -e irc &"
}

menu "tools" {
"xlock"		!"xlock &"
"xload"		!"xload -g 90x90 &"
"xfontsel"	!"xfontsel &"
"bitmap"	!"bitmap &"
"xclipboard"	!"xclipboard &"
"xmagnify"	!"xmag &"
"xgopher"	!"xgopher &"
"xclock"	!"xclock -g 90x90-3+3 &"
"xeyes"		!"xeyes -g 80x80+3-111 -outline red &"
"xconsole"	!"xconsole -daemon -exitOnFail"
}

menu "root" {
"grey23"	!"xsetroot -solid grey23 &"
"olive"	 	!"xsetroot -solid DarkOliveGreen &"
"seagreen" 	!"xsetroot -solid SeaGreen &"
"black"		!"xsetroot -solid black &"
"ico-col &"	!"ico -r -faces -colors red orange yellow green blue violet -sleep 3 &"
"ico-bw &"	!"ico -r -faces -colors grey20 grey25 grey30 grey35 grey40 grey45 -sleep 1 &"
}

dnl ## distractions.. relaxment..  :)  i never use them..
menu "art" {
"flame"		!"xlock -nolock -mode flame &"
"rock"		!"xlock -nolock -mode rock &"
"hyper"		!"xlock -nolock -mode hyper &"
"grav"		!"xlock -nolock -mode grav &"
"bounce"	!"xlock -nolock -mode bounce &"
"sphere"	!"xlock -nolock -mode sphere &"
"kaleid"	!"xlock -nolock -mode kaleid &"
"galaxy"	!"xlock -nolock -mode galaxy &"
"blot"		!"xlock -nolock -mode blot &"
"rotor"		!"xlock -nolock -mode rotor &"
"hop"		!"xlock -nolock -mode hop &"
"qix"		!"xlock -nolock -mode qix &"
"maze"		!"xlock -nolock -mode maze &"
"worm"		!"xlock -nolock -mode worm &"
"swarm"		!"xlock -nolock -mode swarm &"
}

menu "control" {
"root"		f.menu "root"
dnl# "CONTROL"	f.title
"quit"		f.quit
"rehash"	f.twmrc
"restart"	f.restart
"refresh"	f.refresh
"version"	f.version
ifdef(`TWM_TYPE', `
"animate"	f.startanimation
"deanimate"	f.stopanimation
')
}

menu "menu" {
"Artwork"	f.menu "art"
"Basic"		f.menu "basic"
"Window"	f.menu "win"
"Zoom"		f.menu "zoom"
}

menu "basic" {
ifdef(`TWM_TYPE', `
"vanish"	f.vanish
"occupy all"	f.occupyall
')
"autoraise"	f.autoraise
"(de)iconify"	f.iconify
"resize"	f.resize
"raise"		f.raise
"lower"		f.lower
"move"		f.move
}

menu "zoom" {
"vertical"	f.zoom
"to the left"	f.leftzoom
"to the right"	f.rightzoom
"to the bottom"	f.bottomzoom
"horizontal"	f.horizoom
"full zoom"	f.fullzoom
}

menu "win" {
"close"		f.delete
"destroy"	f.destroy
"info"		f.identify
"refresh"	f.winrefresh
"focus"		f.focus
"unfocus"	f.unfocus
"cutfile"	f.cutfile
"save"		f.saveyourself
}

Monochrome {
TitleBackground "black"
TitleForeground "white"
BorderColor "white"
}

dnl # ctwm stuff, the workspaces
dnl #
ifdef(`TWM_TYPE', `
UseThreeDMenus
UseThreeDIconManagers
#UseThreeDBorders
BeNiceToColormap
NoIconManagers
RandomPlacement "unmapped"

AnimationSpeed 33
Icons {
	"IRC"		"xpm:ball%.xpm"
#	"IRC"		"xpm:xirc.xpm"
#	"XTerm"		"xpm:xterm.xpm"
	"XBiff"		"xpm:nt%.xpm"
	"Emacs"		"xpm:gnu-emacs%.xpm"
	"Ghostview"	"xpm:ghostview.xpm"
	"Mosaic"	"xpm:xmosaic.xpm"
	"Archie"	"xpm:xarchie.xpm"
	"FTP"		"xpm:xftp.xpm"
	"XMan"		"xpm:xman.xpm"
}

OpaqueMove
OpaqueMoveThreshold 15
OpaqueResize
OpaqueResizeThreshold 8

ShowWorkSpaceManager
WorkSpaceManagerGeometry        "700x70+250+0" 4
StartInMapState
MapWindowDefaultWorkSpace { "#983" "#000" "#794" }
MapWindowCurrentWorkSpace { "#b52" "#000" "#b52" }
WorkSpaces {
"WORK"	{ "#122" "#983"	"#122" "#983" "xpm:bg/af.xpm"}
"SURF"	{ "#122" "#983"	"#122" "#794" "xpm:bg/o020.xpm"}
"CHAT"	{ "#122" "#983" "#000" "#983" "xpm:bg/bx.xpm"}
"VIEW"	{ "#122" "#983"	"#794" "#122" "xpm:bg/ay.xpm"}
}

#AutoOccupy
OccupyAll { "IRC" "XBiff" "XExit" "XConsole" }
Occupy {
WorkSpace "SURF" { "Netscape" }
WorkSpace "VIEW" { "Mosaic" "Gopher" "Archie" "XPaint" "XV" }
}

Color {
# MenuShadowColor "#983"
TitleBackground "#ca7" { "XTerm" "#983" "IRC" "#b52" "*.uol" "#794" }
',`
UnknownIcon "icon.xbm"

Color {
TitleBackground "#794"
IconBorderColor "#b95"
')
DefaultForeground "#ca7"
DefaultBackground "#122"
#DefaultBackground "#983"
#TitleForeground "#ca7"
TitleForeground "#000"
IconForeground "#762"
IconBackground "#ca7"
MenuForeground "#000"
MenuBackground "#794"
MenuTitleBackground "#762"
MenuTitleForeground "#ca7"
BorderColor "#f77"
}

NoTitle {
"XClock" "XEyes" "XBiff" "XLoad" "XConsole" "XExit" "xpostit" "xman"
"WorkSpaceManager"
}

dnl # i love ctwm's delayed global autoraise
AutoRaise ifdef(`TWM_TYPE', `
RaiseDelay 15000
', `{
"XTerm" "Xman" "XConsole" "XLoad" "Xmris" "XMosaic" "Mosaic" "xv" "Xarchie"
"Xrwho" "Zircon" "Ghostview" "Netscape" "XRisk" "Audiotool" "XWho"
}')
