# debpartial_mirror_ui - User Interface for partial debian mirror package tool
# (c) 2006 Otavio Salvador <otavio@debian.org>
# (c) 2006 Marco Presi <zufus@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gnome
import gtk.glade
import gobject

from BackendBrowser import BackendBrowser
from ConfigEditor import ConfigEditor

#for debuggin purpose


from debpartial_mirror import Backend
from debpartial_mirror import Config
from debpartial_mirror import Download

from BackendBrowser import BackendBrowser

from Callbacks import *

name               = "gdebpartial-mirror"
version            = "0.0.1"
app_glade_file     = "debpartial_mirror_ui/interface/ui.glade"
backend_glade_file = "debpartial_mirror_ui/interface/backend_ui.glade"
cnf_file           = "/etc/debpartial-mirror.conf"


class GDebPartialMirror:
    """ A class that represent the main interface """
    def __init__ (self, conffile):
        self.app = gnome.program_init (name, version)
        self.cnf = Config.Config (cnf_file)

        gtk.glade.set_custom_handler (self.get_custom_handler)
        self.xml = gtk.glade.XML (app_glade_file)

        self.debug_mode = True
        auto_signals = {"on_new_activate": (on_new_activate, self),
                        "on_open_activate": (on_open_activate, self),
                        "on_save_activate": (on_save_activate, self),
                        "on_clean_all_activate": (on_clean_all_activate, self),
                        "on_quit_activate": on_quit_activate,
                        "on_backend_treeview_event":  (on_backend_treeview_event, self),
                        "on_pop_up_update_activate":  (on_pop_up_update_activate, self),
                        "on_pop_up_upgrade_activate": (on_pop_up_upgrade_activate,self),
                        "on_b_update_clicked":        (on_b_update_clicked, self),
                        "on_backend_selection_change": (self.on_backend_selection_change)}
    
        
#        self.create_backends_treeview ()
        
        self.xml.signal_autoconnect (auto_signals)

        #self.b.connect ('backend_changed', self.c.update_property_editor)

    def get_custom_handler(self, glade, function_name, widget_name,
                           str1, str2, int1, int2):
        """
        Generic handler for creating custom widgets, used to
        enable custom widgets.
        
        The custom widgets have a creation function specified in design time.
        Those creation functions are always called with str1,str2,int1,int2 as
        arguments, that are values specified in design time.
        
        This handler assumes that we have a method for every custom widget
        creation function specified in glade.
        
        If a custom widget has create_foo as creation function, then the
        method named create_foo is called with str1,str2,int1,int2 as arguments.
        """
        handler = getattr(self, function_name)
        return handler(str1, str2, int1, int2)
    
    def create_backend_browser (self, str1, str2, int1, int2):
        self.b = BackendBrowser (self.cnf)
        return self.b
    
    def create_configuration_editor (self, str1, str2, int1, int2):
        self.c = ConfigEditor (self.cnf) 
        return self.c

    def on_backend_selection_change (self, backend, b_name):
        """ When a backend is selected, we show its properties in the property
        treeview."""
        self.c.update_property_editor (b_name)
