/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

/// @author Tiago Quintino
/// @author Baudouin Raoult
/// @author Manuel Fuentes

#ifndef eckit_NilContent_h
#define eckit_NilContent_h

#include "eckit/value/Content.h"


namespace eckit {

//----------------------------------------------------------------------------------------------------------------------

class NilContent : public Content {
protected:

// -- Constructors

    NilContent();
    NilContent(Stream&);

// -- Destructors

    virtual ~NilContent();

// -- Overridden Methods

    // From Content

    virtual int compare(const Content& other) const;

    virtual void value(bool& n)        const { Content::value(n); }
    virtual void value(long long& n)   const { Content::value(n); }
    virtual void value(double& n)      const { Content::value(n); }
    virtual void value(std::string& n) const { Content::value(n); }
    virtual void value(Date& n)        const { Content::value(n); }
    virtual void value(Time& n)        const { Content::value(n); }
    virtual void value(DateTime& n)    const { Content::value(n); }
    virtual void value(ValueList& n)   const;
    virtual void value(ValueMap& n)    const { Content::value(n); }

    virtual int  compareBool(const BoolContent&)            const {return -1; }
    virtual int  compareNumber(const NumberContent&)        const {return -1; }
    virtual int  compareDouble(const DoubleContent&)        const {return -1; }
    virtual int  compareString(const StringContent&)        const {return -1; }
    virtual int  compareNil(const NilContent&)              const;
    virtual int  compareList(const ListContent&)            const {return 1; }
    virtual int  compareMap(const MapContent&)              const {return 1; }
    virtual int  compareDate(const DateContent&)            const {return 1; }
    virtual int  compareTime(const TimeContent&)            const {return 1; }
    virtual int  compareDateTime(const DateTimeContent&)    const {return 1; }
    virtual int  compareOrderedMap(const OrderedMapContent&) const { return 1; }

    virtual Content* add(const Content&) const;
    virtual Content* sub(const Content&) const;
    virtual Content* mul(const Content&) const;
    virtual Content* div(const Content&) const;
    virtual Content* mod(const Content&) const;

    virtual Content* addNil(const NilContent&)  const;
    virtual Content* subNil(const NilContent&)  const;
    virtual Content* mulNil(const NilContent&)  const;
    virtual Content* divNil(const NilContent&)  const;

    virtual bool     isNil()     const  { return true; }
    virtual std::string   typeName()  const  { return "Nil"; }
    virtual void     print(std::ostream&) const;
    virtual void   json(JSON&)     const;
    virtual Content* clone() const;
    virtual void    dump(std::ostream& out, size_t depth, bool indent=true) const;

    virtual bool contains(const Value&) const;

    // From Streamable

    virtual void     encode(Stream&)              const;
    virtual const    ReanimatorBase& reanimator() const { return reanimator_; }

    virtual void hash(Hash&) const;

private:

// -- No copy allowed

    NilContent(const NilContent&);
    NilContent& operator=(const NilContent&);

// -- Class Members

    static  ClassSpec               classSpec_;
    static  Reanimator<NilContent>  reanimator_;

// -- Friends

    friend class Reanimator<NilContent>;
    friend class Value;
};


//----------------------------------------------------------------------------------------------------------------------

} // namespace eckit

#endif
