package org.eclipse.webdav.internal.kernel.utils;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

public final class URLDecoder {
// Not intended to be called.
private URLDecoder() {

	super();
}
/**
 * Decodes a urlencoded string.
 *
 * @see java.net.URLEncoder
 */
public static String decode(String input) {

	StringBuffer buffer = new StringBuffer(input.length());

	char c;
	for (int i = 0; i < input.length(); i++) {
		c = input.charAt(i);
		switch (c) {
			case '%' : {
				String hexString = input.substring(i + 1, i + 3);
				buffer.append((char) Integer.parseInt(hexString, 16));
				i += 2;
				break;
			}
			default :
				buffer.append(c);
		} // end-switch
	} // end-for
	
	return buffer.toString();
}
}
