#!/bin/sh

TEST="test-bda test-conv test-expr test-if test-switch test-hello-world test-ext"
TEST2="test.c \
	test3.c \
	test4.c \
	test5.c \
	test6.c \
	test7.c \
	test8.c \
	test9.c \
	test10.c \
	test11.c \
	test12.c \
	test13.c \
	test14.c \
	test15.c \
	test16.c \
	test17.c \
	test18.c \
	test19.c \
	test20.c \
	test21.c \
	\
	chip_intel_80386_inline.c \
	test-hello-world.c \
	test-i386-add.c \
	test-i386.c \
	test-i386-noinline.c"

for test in ${TEST} ; do
	echo "${test}"

	# Check for warnings.
	gcc -Wall -c ${test}.c
	rm -f ${test}.o

	# Generate assembler code using gcc.
	gcc -S -m32 -falign-functions=15 ${test}.c
	mv ${test}.s ${test}.s.gcc

	# Generate assembler code using faucc with different args.
	(
		echo "-b i386 -falign-functions=15"
		echo "-b i286 -falign-functions=15"
		echo "-b i286 -falign-functions=15 -fsegment_enable"
	) \
	| while read args ; do
		echo "${test} (${args})..."

		# Generate assembler code using faucc.
		../faucc -S ${args} ${test}.c 2>&1 \
		| grep -v 'Fixing declaration of '

		# Call assembler to check syntax.
		gcc -c ${test}.s
		rm -f ${test}.o

		# Save generated file for later inspection.
		mv ${test}.s ${test}.s."${args}"
	done

	echo ""
done

cd bios
	for file in *.i ; do
		file=`basename ${file} .i`
		echo "${file}..."

		# Generate assembler code using faucc.
		../../faucc -S -b i286 -fsegment_enable ${file}.i 2>&1 \
		| grep -v 'Fixing declaration of '

		# Call assembler to check syntax.
		../../faucc -c -b i286 ${file}.s
	done
cd ..
