/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class IteratorsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAddAllToList() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAddAllToList();
}

public void testAddAllToSet() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAddAllToSet();
}

public void testAddAllWithEmptyIterator() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAddAllWithEmptyIterator();
}

public void testAdvance_basic() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAdvance_basic();
}

public void testAdvance_illegalArgument() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAdvance_illegalArgument();
}

public void testAdvance_pastEnd() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAdvance_pastEnd();
}

public void testAll() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAll();
}

public void testAny() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAny();
}

public void testAsEnumerationEmpty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAsEnumerationEmpty();
}

public void testAsEnumerationSingleton() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAsEnumerationSingleton();
}

public void testAsEnumerationTypical() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testAsEnumerationTypical();
}

public void testConcatContainingNull() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testConcatContainingNull();
}

public void testConcatVarArgsContainingNull() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testConcatVarArgsContainingNull();
}

public void testConsumingIterator() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testConsumingIterator();
}

public void testCycleNoSuchElementException() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleNoSuchElementException();
}

public void testCycleOfEmpty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleOfEmpty();
}

public void testCycleOfOne() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleOfOne();
}

public void testCycleOfOneWithRemove() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleOfOneWithRemove();
}

public void testCycleOfTwo() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleOfTwo();
}

public void testCycleOfTwoWithRemove() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleOfTwoWithRemove();
}

public void testCycleRemoveAfterHasNext() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleRemoveAfterHasNext();
}

public void testCycleRemoveAfterHasNextExtraPicky() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleRemoveAfterHasNextExtraPicky();
}

public void testCycleRemoveSameElementTwice() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleRemoveSameElementTwice();
}

public void testCycleRemoveWithoutNext() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleRemoveWithoutNext();
}

public void testCycleWhenRemoveIsNotSupported() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testCycleWhenRemoveIsNotSupported();
}

public void testElementsEqual() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testElementsEqual();
}

public void testEmptyIterator() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testEmptyIterator();
}

public void testEmptyListIterator() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testEmptyListIterator();
}

public void testEmptyModifiableIterator() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testEmptyModifiableIterator();
}

public void testFilterMatchAll() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFilterMatchAll();
}

public void testFilterNoMatch() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFilterNoMatch();
}

public void testFilterNothing() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFilterNothing();
}

public void testFilterSimple() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFilterSimple();
}

public void testFind_firstElement() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_firstElement();
}

public void testFind_lastElement() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_lastElement();
}

public void testFind_matchAlways() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_matchAlways();
}

public void testFind_notPresent() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_notPresent();
}

public void testFind_withDefault_first() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_withDefault_first();
}

public void testFind_withDefault_last() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_withDefault_last();
}

public void testFind_withDefault_matchAlways() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_withDefault_matchAlways();
}

public void testFind_withDefault_notPresent() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_withDefault_notPresent();
}

public void testFind_withDefault_notPresent_nullReturn() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFind_withDefault_notPresent_nullReturn();
}

public void testForArrayEmpty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testForArrayEmpty();
}

public void testForArrayLength0() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testForArrayLength0();
}

public void testForArrayOffset() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testForArrayOffset();
}

public void testForArrayTypical() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testForArrayTypical();
}

public void testForEnumerationEmpty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testForEnumerationEmpty();
}

public void testForEnumerationSingleton() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testForEnumerationSingleton();
}

public void testForEnumerationTypical() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testForEnumerationTypical();
}

public void testFrequency() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testFrequency();
}

public void testGetLast_basic() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetLast_basic();
}

public void testGetLast_exception() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetLast_exception();
}

public void testGetLast_withDefault_empty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetLast_withDefault_empty();
}

public void testGetLast_withDefault_empty_null() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetLast_withDefault_empty_null();
}

public void testGetLast_withDefault_singleton() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetLast_withDefault_singleton();
}

public void testGetLast_withDefault_two() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetLast_withDefault_two();
}

public void testGetNext_withDefault_empty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetNext_withDefault_empty();
}

public void testGetNext_withDefault_empty_null() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetNext_withDefault_empty_null();
}

public void testGetNext_withDefault_singleton() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetNext_withDefault_singleton();
}

public void testGetNext_withDefault_two() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetNext_withDefault_two();
}

public void testGetOnlyElement_noDefault_empty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_noDefault_empty();
}

public void testGetOnlyElement_noDefault_fiveElements() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_noDefault_fiveElements();
}

public void testGetOnlyElement_noDefault_moreThanFiveElements() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_noDefault_moreThanFiveElements();
}

public void testGetOnlyElement_noDefault_moreThanOneLessThanFiveElements() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_noDefault_moreThanOneLessThanFiveElements();
}

public void testGetOnlyElement_noDefault_valid() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_noDefault_valid();
}

public void testGetOnlyElement_withDefault_empty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_withDefault_empty();
}

public void testGetOnlyElement_withDefault_empty_null() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_withDefault_empty_null();
}

public void testGetOnlyElement_withDefault_singleton() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_withDefault_singleton();
}

public void testGetOnlyElement_withDefault_two() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGetOnlyElement_withDefault_two();
}

public void testGet_atSize() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_atSize();
}

public void testGet_basic() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_basic();
}

public void testGet_empty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_empty();
}

public void testGet_negativeIndex() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_negativeIndex();
}

public void testGet_pastEnd() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_pastEnd();
}

public void testGet_withDefault_atSize() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_withDefault_atSize();
}

public void testGet_withDefault_basic() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_withDefault_basic();
}

public void testGet_withDefault_negativeIndex() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_withDefault_negativeIndex();
}

public void testGet_withDefault_pastEnd() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testGet_withDefault_pastEnd();
}

public void testIndexOf_consumedData() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testIndexOf_consumedData();
}

public void testIndexOf_consumedDataNoMatch() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testIndexOf_consumedDataNoMatch();
}

public void testIndexOf_consumedDataWithDuplicates() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testIndexOf_consumedDataWithDuplicates();
}

public void testLimit() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testLimit();
}

public void testLimitRemove() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testLimitRemove();
}

public void testNullFriendlyTransform() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testNullFriendlyTransform();
}

public void testPaddedPartitionRandomAccess() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPaddedPartitionRandomAccess();
}

public void testPaddedPartition_badSize() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPaddedPartition_badSize();
}

public void testPaddedPartition_empty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPaddedPartition_empty();
}

public void testPaddedPartition_singleton1() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPaddedPartition_singleton1();
}

public void testPaddedPartition_singleton2() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPaddedPartition_singleton2();
}

public void testPaddedPartition_view() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPaddedPartition_view();
}

public void testPartition_badSize() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPartition_badSize();
}

public void testPartition_empty() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPartition_empty();
}

public void testPartition_singleton1() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPartition_singleton1();
}

public void testPartition_singleton2() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPartition_singleton2();
}

public void testPartition_view() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPartition_view();
}

public void testPeekingIteratorShortCircuit() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPeekingIteratorShortCircuit();
}

public void testPoorlyBehavedTransform() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testPoorlyBehavedTransform();
}

public void testRemoveAll() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testRemoveAll();
}

public void testRemoveIf() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testRemoveIf();
}

public void testRetainAll() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testRetainAll();
}

public void testSize0() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testSize0();
}

public void testSize1() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testSize1();
}

public void testSize_partiallyConsumed() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testSize_partiallyConsumed();
}

public void testToString() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testToString();
}

public void testToStringEmptyIterator() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testToStringEmptyIterator();
}

public void testToStringWithNull() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testToStringWithNull();
}

public void testTransform() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testTransform();
}

public void testTransformRemove() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testTransformRemove();
}

public void testTryFind_alwaysFalse_isPresent() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testTryFind_alwaysFalse_isPresent();
}

public void testTryFind_alwaysFalse_orDefault() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testTryFind_alwaysFalse_orDefault();
}

public void testTryFind_alwaysTrue() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testTryFind_alwaysTrue();
}

public void testTryFind_firstElement() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testTryFind_firstElement();
}

public void testTryFind_lastElement() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testTryFind_lastElement();
}

public void testUnmodifiableIteratorShortCircuit() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.testUnmodifiableIteratorShortCircuit();
}

public void test_contains_nonnull_no() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.test_contains_nonnull_no();
}

public void test_contains_nonnull_yes() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.test_contains_nonnull_yes();
}

public void test_contains_null_no() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.test_contains_null_no();
}

public void test_contains_null_yes() throws Exception {
  com.google.common.collect.IteratorsTest testCase = new com.google.common.collect.IteratorsTest();
  testCase.test_contains_null_yes();
}
}
