<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from http://php.net/manual/en/class.arrayaccess.php )
 *
 * Interface to provide accessing objects as arrays.
 *
 */
interface ArrayAccess {
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/arrayaccess.offsetexists.php )
   *
   * Whether or not an offset exists.
   *
   * This method is executed when using isset() or empty() on objects
   * implementing ArrayAccess.
   *
   * When using empty() ArrayAccess::offsetGet() will be called and checked
   * if empty only if ArrayAccess::offsetExists() returns TRUE.
   *
   * @index      mixed   An offset to check for.
   *
   * @return     mixed   Returns TRUE on success or FALSE on failure.
   *
   *                     The return value will be casted to boolean if
   *                     non-boolean was returned.
   */
  public function offsetExists($index);
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/arrayaccess.offsetget.php )
   *
   * Returns the value at specified offset.
   *
   * This method is executed when checking if offset is empty().
   *
   * @index      mixed   The offset to retrieve.
   *
   * @return     mixed   Can return all value types.
   */
  public function offsetGet($index);
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/arrayaccess.offsetset.php )
   *
   * Assigns a value to the specified offset.
   *
   * @index      mixed   The offset to assign the value to.
   * @newvalue   mixed   The value to set.
   *
   * @return     mixed   No value is returned.
   */
  public function offsetSet($index, $newvalue);
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://php.net/manual/en/arrayaccess.offsetunset.php )
   *
   * Unsets an offset.
   *
   * This method will not be called when type-casting to (unset)
   *
   * @index      mixed   The offset to unset.
   *
   * @return     mixed   No value is returned.
   */
  public function offsetUnset($index);
}
