/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.JarUtil;
import jarinstaller.gui.FileUtil;
import jarinstaller.gui.IReport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class SilentInstall
implements IReport {
    private static final String CHARSET = "ISO-8859-2";
    public static final String INSTALLDIR = "ENYK_PATH";
    public static final String DESTINATIONDIR = "DESTINATIONDIR";
    public static final String USERDIR = "DESTINATIONDATADIR";
    public static final String KRDIR = "KRDIR";
    public static final String MAINPROGRAM = "MAINPROGRAM";
    public static final String CONST_USER_HOME = "USER_HOME";
    public static final String USER_SUB_DIR = "abevjava";
    public static final String USER_SUB_KR_DIR = "eKuldes";
    private Hashtable params;
    private SimpleDateFormat sdf = new SimpleDateFormat("[yyyy.MM.dd] [kk:mm:ss]");
    public static final String LOGFILENAME = "abevjava_silent_install.log";
    private String LOGFILE;
    private Vector resultfiles;
    private Vector resultdirs;
    OutputStreamWriter osw;
    boolean result = false;
    boolean scMenu;
    boolean scDesktop;

    public SilentInstall(Hashtable params, boolean scMenu, boolean scDesktop) {
        this.params = params;
        this.scMenu = scMenu;
        this.scDesktop = scDesktop;
        this.init();
    }

    private void init() {
        this.setLogFile();
        this.initDataStore();
        try {
            this.osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.LOGFILE)), CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void setLogFile() {
        String path = (String)this.params.get(CONST_USER_HOME);
        String opsys = ((String)this.params.get("OS_NAME")).toLowerCase();
        if (opsys.indexOf("win") != -1) {
            path = (String)this.params.get("WINDOWS_TMP");
        }
        this.LOGFILE = new File(path, LOGFILENAME).getAbsolutePath();
    }

    public void close() {
        try {
            this.osw.flush();
            this.osw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void exec() {
        if (!this.existInstallDir()) {
            if (!this.setDefaultInstallDir()) {
                this.writeLog("Hiba", "Az alap\u00e9rtelmezett telep\u00edt\u00e9si k\u00f6nyvt\u00e1rat nem siker\u00fclt meghat\u00e1rozni.");
                return;
            }
            if (!this.existInstallDir()) {
                this.writeLog("Hiba", "A telep\u00edt\u00e9si k\u00f6nyvt\u00e1r nincs defini\u00e1lva (abevjavapath.cfg)");
                return;
            }
        }
        Vector messages = (Vector)this.params.get("main_logic_messages");
        for (int i = 0; i < messages.size(); ++i) {
            String msg = (String)messages.elementAt(i);
            this.writeLog("Figyelmeztet\u00e9s", msg);
        }
        if (!this.install()) {
            return;
        }
        if (!this.toDo()) {
            return;
        }
        this.result = true;
    }

    private boolean existInstallDir() {
        String st = (String)this.params.get(INSTALLDIR);
        this.writeLog(INSTALLDIR, st);
        if (st == null || st.length() == 0) {
            return false;
        }
        return this.createDir(st);
    }

    private boolean setDefaultInstallDir() {
        String st = (String)this.params.get("APPLICATIONDIR");
        if (st == null || st.length() == 0) {
            return false;
        }
        String path = new File(st, USER_SUB_DIR).getAbsolutePath();
        this.params.put(INSTALLDIR, path);
        this.params.put(DESTINATIONDIR, path);
        return true;
    }

    private boolean setUserDir() {
        String dir = (String)this.params.get(USERDIR);
        this.writeLog(USERDIR, dir);
        if (dir == null || dir.length() == 0) {
            dir = this.params.get(CONST_USER_HOME) + File.separator + USER_SUB_DIR;
            this.params.put(USERDIR, dir);
        }
        return this.createDir(dir);
    }

    private boolean setKrDir() {
        String dir = (String)this.params.get(KRDIR);
        this.writeLog(KRDIR, dir);
        if (dir == null || dir.length() == 0) {
            dir = this.params.get(USERDIR) + File.separator + USER_SUB_KR_DIR;
            this.params.put(KRDIR, dir);
        }
        return this.createDir(dir);
    }

    private boolean createDir(String file) {
        File dir = new File(file);
        if (dir.exists()) {
            return true;
        }
        if (dir.mkdirs()) {
            return true;
        }
        this.writeLog("Hiba", "Hiba a k\u00f6nyvt\u00e1r l\u00e9trehoz\u00e1sa sor\u00e1n:" + file);
        return false;
    }

    private void setShortCuts() {
        boolean canCreateDesktop = this.getBooleanParam("CANCREATEDESKTOPSHORTCUT");
        boolean canCreateMenu = this.getBooleanParam("CANCREATEMENUSHORTCUT");
        this.params.put("ISCREATEDESKTOPSHORTCUT", canCreateDesktop && this.scDesktop ? Boolean.TRUE : Boolean.FALSE);
        this.params.put("ISCREATEMENUSHORTCUT", canCreateMenu && this.scMenu ? Boolean.TRUE : Boolean.FALSE);
    }

    private boolean getBooleanParam(String key) {
        if (!this.params.containsKey(key)) {
            return false;
        }
        return (Boolean)this.params.get(key);
    }

    private boolean isMain() {
        String mainprogram = (String)this.params.get(MAINPROGRAM);
        return mainprogram == null || mainprogram.length() == 0 || mainprogram.equalsIgnoreCase("true");
    }

    private boolean install() {
        try {
            this.writeLog("", "\u00c1llom\u00e1nyok telep\u00edt\u00e9se");
            URI sourcefile = (URI)this.params.get("parameter.option.sourcefile");
            JarUtil ju = new JarUtil(sourcefile);
            ju.setReport(this);
            ju.setParams(this.params);
            ju.run();
            return true;
        }
        catch (Exception e) {
            this.writeLog("Hiba", e.getMessage());
            return false;
        }
    }

    private boolean toDo() {
        try {
            this.writeLog("", "Be\u00e1ll\u00edt\u00e1sok");
            Vector files = null;
            Vector dirs = null;
            if (this.params.containsKey("files")) {
                files = (Vector)this.params.get("files");
            }
            if (this.params.containsKey("directories")) {
                dirs = (Vector)this.params.get("directories");
            }
            String destDir = (String)this.params.get(DESTINATIONDIR);
            FileUtil fu = new FileUtil();
            fu.setDestdir(destDir);
            fu.setFiles(files);
            fu.setDirs(dirs);
            fu.setReport(this);
            fu.setResultfiles(this.resultfiles);
            fu.setResultdirs(this.resultdirs);
            fu.setParams(this.params);
            fu.setUsertodo(false);
            fu.run();
            return true;
        }
        catch (Exception e) {
            this.writeLog("Hiba", e.getMessage());
            return false;
        }
    }

    private boolean userTodo() {
        try {
            this.writeLog("", "Felhaszn\u00e1l\u00f3i be\u00e1ll\u00edt\u00e1sok");
            Vector files = null;
            Vector dirs = null;
            if (this.params.containsKey("userfiles")) {
                files = (Vector)this.params.get("userfiles");
            }
            if (this.params.containsKey("userdirectories")) {
                dirs = (Vector)this.params.get("userdirectories");
            }
            String destDir = (String)this.params.get(DESTINATIONDIR);
            FileUtil fu = new FileUtil();
            fu.setDestdir(destDir);
            fu.setFiles(files);
            fu.setDirs(dirs);
            fu.setReport(this);
            fu.setResultfiles(this.resultfiles);
            fu.setResultdirs(this.resultdirs);
            fu.setParams(this.params);
            fu.setUsertodo(true);
            fu.run();
            return true;
        }
        catch (Exception e) {
            this.writeLog("Hiba", e.getMessage());
            return false;
        }
    }

    private void writeLog(String key, String msg) {
        String message = key.length() == 0 ? this.sdf.format(new Date()) + " " + msg : this.sdf.format(new Date()) + " " + key + ":" + msg;
        try {
            this.osw.write(message + "\n");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void initDataStore() {
        if (this.params.containsKey("parameter.option.install.filelist")) {
            this.resultfiles = (Vector)this.params.get("parameter.option.install.filelist");
        } else {
            this.resultfiles = new Vector();
            this.params.put("parameter.option.install.filelist", this.resultfiles);
        }
        if (this.params.containsKey("parameter.option.install.dirlist")) {
            this.resultdirs = (Vector)this.params.get("parameter.option.install.dirlist");
        } else {
            this.resultdirs = new Vector();
            this.params.put("parameter.option.install.dirlist", this.resultdirs);
        }
    }

    public void inFormStart(String msg, String info, long size) {
    }

    public void inFormEnd(String msg, String info, long size) {
    }

    public void setResult(boolean result, String msg, Hashtable data) {
        try {
            if (result) {
                this.writeLog("", "Sikeresen lefutott");
            } else {
                this.writeLog("Hiba", msg);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

