/*
 *		Copyright (C) 2013-2015, 2019 by the Konclude Developer Team.
 *
 *		This file is part of the reasoning system Konclude.
 *		For details and support, see <http://konclude.com/>.
 *
 *		Konclude is free software: you can redistribute it and/or modify
 *		it under the terms of version 3 of the GNU Lesser General Public
 *		License (LGPLv3) as published by the Free Software Foundation.
 *
 *		Konclude is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *		GNU (Lesser) General Public License for more details.
 *
 *		You should have received a copy of the GNU (Lesser) General Public
 *		License along with Konclude. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef KONCLUDE_REASONER_ONTOLOGY_CONTOLOGY_H
#define KONCLUDE_REASONER_ONTOLOGY_CONTOLOGY_H

// Libraries includes


// Namespace includes
#include "OntologySettings.h"
#include "CTerminology.h"
#include "COntologyStructureSummary.h"
#include "CABox.h"
#include "CTBox.h"
#include "CRBox.h"

// Other includes
#include "Reasoner/Taxonomy/CTaxonomy.h"

// Logger includes
#include "Logger/CLogger.h"


namespace Konclude {

	namespace Reasoner {

		using namespace Taxonomy;

		namespace Ontology {

			/*! 
			 *
			 *		\class		COntology
			 *		\author		Andreas Steigmiller
			 *		\version	0.1
			 *		\brief		TODO
			 *
			 */
			class COntology : public CTerminology {
				// public methods
				public:
					//! Constructor
					COntology();

					//! Destructor
					virtual ~COntology();

				
					virtual CTaxonomy *getConceptTaxonomy() = 0;
					virtual bool hasConceptTaxonomy() = 0;

					virtual COntologyStructureSummary *getStructureSummary() = 0;

					virtual QString getOntologyName();
					virtual COntology *setOntologyName(const QString &name);

					virtual qint64 getOntologyID() const;
					virtual COntology *setOntologyID(qint64 id);


				// protected methods
				protected:

				// protected variables
				protected:

				// private methods
				private:

				// private variables
				private:

			};

		}; // end namespace Ontology

	}; // end namespace Reasoner

}; // end namespace Konclude

#endif // KONCLUDE_REASONER_ONTOLOGY_CONTOLOGY_H
