/*
 * Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.spring.tests.references;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("ultimate/testData/spring/core/references/completion/handler")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class SpringReferenceCompletionHandlerTestGenerated extends AbstractSpringReferenceCompletionHandlerTest {
    public void testAllFilesPresentInHandler() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("ultimate/testData/spring/core/references/completion/handler"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("packageReferenceEnter.kt")
    public void testPackageReferenceEnter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/references/completion/handler/packageReferenceEnter.kt");
        doTest(fileName);
    }

    @TestMetadata("packageReferenceTab.kt")
    public void testPackageReferenceTab() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/references/completion/handler/packageReferenceTab.kt");
        doTest(fileName);
    }

    @TestMetadata("qualifierReferenceEnter.kt")
    public void testQualifierReferenceEnter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/references/completion/handler/qualifierReferenceEnter.kt");
        doTest(fileName);
    }

    @TestMetadata("qualifierReferenceTab.kt")
    public void testQualifierReferenceTab() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/references/completion/handler/qualifierReferenceTab.kt");
        doTest(fileName);
    }

    @TestMetadata("scopeReference.kt")
    public void testScopeReference() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/references/completion/handler/scopeReference.kt");
        doTest(fileName);
    }

    @TestMetadata("springBeanReferenceEnter.kt")
    public void testSpringBeanReferenceEnter() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/references/completion/handler/springBeanReferenceEnter.kt");
        doTest(fileName);
    }

    @TestMetadata("springBeanReferenceTab.kt")
    public void testSpringBeanReferenceTab() throws Exception {
        String fileName = KotlinTestUtils.navigationMetadata("ultimate/testData/spring/core/references/completion/handler/springBeanReferenceTab.kt");
        doTest(fileName);
    }
}
