# - Try to find GNU TLS
# Once done this will define
#
#  GNUTLS_FOUND - system has GNUTLS
#  GNUTLS_INCLUDE_DIR - the GNUTLS include directory
#  GNUTLS_LIBRARIES - the libraries needed to use GNUTLS

# Copyright (c) 2009, Gregory Haynes <greg@greghaynes.net>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


IF (GNUTLS_INCLUDE_DIR AND GNUTLS_LIBRARIES)
   # in cache already
   SET(GNUTLS_FIND_QUIETLY TRUE)
ELSE (GNUTLS_INCLUDE_DIR AND GNUTLS_LIBRARIES)
   SET(GNUTLS_FIND_QUIETLY FALSE)
ENDIF (GNUTLS_INCLUDE_DIR AND GNUTLS_LIBRARIES)

IF (NOT WIN32)
   # use pkg-config to get the directories and then use these values
   # in the FIND_PATH() and FIND_LIBRARY() calls
   FIND_PACKAGE(PkgConfig)
   PKG_CHECK_MODULES(PC_GNUTLS gnutls) 
   #MESSAGE(STATUS "DEBUG: GNUTLS include directory = ${GNUTLS_INCLUDE_DIRS}")
   #MESSAGE(STATUS "DEBUG: GNUTLS link directory = ${GNUTLS_LIBRARY_DIRS}")
   #MESSAGE(STATUS "DEBUG: GNUTLS CFlags = ${GNUTLS_CFLAGS}")
   SET(GNUTLS_DEFINITIONS ${PC_GNUTLS_CFLAGS_OTHER})
ENDIF (NOT WIN32)

FIND_PATH(GNUTLS_INCLUDE_DIR gnutls.h
   PATHS
   ${PC_GNUTLS_INCLUDEDIR}
   ${PC_GNUTLS_INCLUDE_DIRS}
   PATH_SUFFIXES gnutls/
   )

FIND_LIBRARY(_GNUTLSLibs NAMES gnutls
   PATHS
   ${PC_GNUTLS_LIBDIR}
   ${PC_GNUTLS_LIBRARY_DIRS}
   )

SET( GNUTLS_LIBRARIES ${_GNUTLSLibs} )

IF (GNUTLS_INCLUDE_DIR AND GNUTLS_LIBRARIES)
   SET(GNUTLS_FOUND TRUE)
ELSE (GNUTLS_INCLUDE_DIR AND GNUTLS_LIBRARIES)
   SET(GNUTLS_FOUND FALSE)
ENDIF (GNUTLS_INCLUDE_DIR AND GNUTLS_LIBRARIES)

IF (GNUTLS_FOUND)
   IF (NOT GNUTLS_FIND_QUIETLY)
      MESSAGE(STATUS "Found GNUTLS libraries: ${GNUTLS_LIBRARIES}")
      MESSAGE(STATUS "Found GNUTLS includes : ${GNUTLS_INCLUDE_DIR}")
   ENDIF (NOT GNUTLS_FIND_QUIETLY)
ELSE (GNUTLS_FOUND)
    IF (GNUTLS_FIND_REQUIRED)
      MESSAGE(STATUS "Could NOT find GNUTLS")
    ENDIF(GNUTLS_FIND_REQUIRED)
ENDIF (GNUTLS_FOUND)

MARK_AS_ADVANCED(GNUTLS_INCLUDE_DIR _GNUTLSLibs)
