
# log2src integration

The [Extracting Data](https://docs.lnav.org/en/latest/data.html)
functionality in lnav parsed log message bodies based on various
conventions, such as a key/value pair separated by an equal sign.
That approach can work if the data is nicely structured, but is
not totally reliable.  As an alternative, if the logging source
code is available, we can leverage log2src to find the
corresponding log statement for a log message.  We can then
fairly accurately extract the values and pair them up with the
appropriate variables.  This functionality can be exposed to the
user in two ways:

* Directly in lnav by replacing the "Discovered fields for ..."
  section in the message details overlay (shown by pressing `p`).
  In addition, we can now show the source code of the log
  statement.
* Through a Debug Adapter that allows the user to treat the log
  as a trace of the execution of the program.  For example, in
  VS Code, the user can set breakpoints on log statements and
  examine variable values at different points in time.

The following sections will go into details on demos for these
two approaches.

## Standalone Demo

This demo covers modifying only lnav to show the results of
log2src's magic.  It's mostly retreading existing ground, so
it should be more tractable than trying to get the debugger
stuff working first.

Steps:
1. Open log file generated by the program under development
1. Add source directories to lnav (using a command?)
1. Press `p` to reveal the message details overlay
1. Note that lnav is showing the source code of the log statement
   for the focused log message and printed out the values of
   the variables.

Implementation tasks:

- [ ] Make sure log2src's API is usable
- [ ] Rename lnav's prqlc-c crate since all Rust code will now be
      exposed through this crate
- [ ] Add FFI interface for log2src's API to the crate
- [ ] Add an lnav command to add source directories
  - [ ] Make the source directories part of the session
- [ ] Check if a log message is recognized by log2src in the
      message details overlay and use those results if so.
- [ ] Show the source code of the log message and surrounding bits
- [ ] Modify the `all_logs` table to use log2src instead of the
      current extraction code.


## Debugger Demo

This demo is probably the more useful one since it allows
people to stay in their editor.

Steps:
1. Open log file generated by the program under development
1. Add source directories to lnav
1. Set a breakpoint on a logging statement
1. Attach the debugger to lnav
1. Click "Run" to have lnav move the focused line to a breakpoint
1. Show that the editor has moved to the source code
   containing the breakpoint and the variables passed to
   the log statement are shown.
