/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.builder;

import com.claritysys.jvm.classfile.ClassFile;
import com.claritysys.jvm.disassembler.Disassembler;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

public class ArrayClassLoader
extends ClassLoader {
    private final Map byteCache = new HashMap();
    private static final boolean ALWAYS_DISASSEMBLE = "true".equals(System.getProperty("csg-storm-show-impl"));

    public ArrayClassLoader() {
    }

    public ArrayClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> c;
        byte[] bytes = (byte[])this.byteCache.get(name);
        if (bytes == null) {
            throw new ClassNotFoundException(name);
        }
        if (ALWAYS_DISASSEMBLE) {
            this.disassemble(name);
        }
        try {
            c = super.defineClass(name, bytes, 0, bytes.length);
        }
        catch (Throwable e) {
            this.disassemble(name);
            throw new ClassNotFoundException("Error loading class '" + name + "', file disassembled to user.dir");
        }
        return c;
    }

    public void disassemble(String className) {
        try {
            String path = System.getProperty("user.dir");
            File tempDir = new File(path);
            File file = new File(tempDir, className + ".jasm");
            byte[] bytes = (byte[])this.byteCache.get(className);
            File cfile = new File(tempDir, className + ".class");
            FileOutputStream fos = new FileOutputStream(cfile);
            fos.write(bytes);
            fos.close();
            ClassFile classFile = ClassFile.fromArray(bytes);
            Disassembler disassembler = new Disassembler(classFile, file.getAbsolutePath());
            disassembler.disassemble();
        }
        catch (Exception e) {
            System.out.println("Attemped to disassemble " + className + ", but" + "exception " + e + " occurred.");
        }
    }

    public void addCachedType(ClassFile cf) {
        byte[] bytes = cf.writeToArray();
        this.byteCache.put(cf.getClassName(), bytes);
    }

    public void addCachedType(String className, byte[] cfImage) {
        this.byteCache.put(className, cfImage);
    }
}

