Contributing to mkdocs-macros
=============================

If you want to help, you've come to the right place.

## Adding an issue?

If, after having consulted the existing [issues](https://github.com/fralau/mkdocs_macros_plugin/issues), 
you want to add **a new issue** (for a **bug** or an **enhancement request**), 
or comment on an existing one, you are welcome!

All issues are carefully reviewed and often get a quick answer.

## Software issue, usage problem, not sure?

There has been no need, so far, to regulate issues on this project.

But if you don't know if what you are requesting is:

- a bug correction,
- a new feature,
- a hint on how to use mkdocs-macros,

or you have **an idea that is meaningful to you, and you wish to start a discussion**,

just use the [project's Discussions space, on GitHub](https://github.com/fralau/mkdocs_macros_plugin/discussions), and enter a **new idea** 💡. 

!!! Tip "Your ideas 💡 are valuable: tell about them!"



## Want to contribute code?

Contributions of [PRs (Pull Requests)](https://github.com/fralau/mkdocs_macros_plugin/pulls) are welcome!

More information on how to make pull requests can be found on [GitHub's docs](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests).

!!! Note "Important rule: Open an issue first!"

    **But** there is a rule: **[Always open an issue first](https://github.com/fralau/mkdocs_macros_plugin/issues)**, and get a feedback.

    It's in everybody's interest to have a little discussion first:
    
    - Perhaps the issue has already been fixed? 
    - There is a different way to do things?
    - There is a pitfall to watch for? 
    - Perhaps your good idea could even be made better? 🙂

If you submit a PR on github without referring to existing issue,
you will likely be asked to open one, before anything else happens.

If you have several PRs on the same issue, continue to refer to that
issue.

## Want to correct or contribute documentation?

!!! Tip "Code is docs, and docs is code"
    There is no substantial difference between code and documentation:
    
    - Code is for machines.
    - Documentation is for humans.
    - Sometimes the division between the two is not even clear.

Apply the same principles for documentation as [for code](#want-to-contribute-code).