# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class BillingType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Configures whether billing will be only on the cluster or each workspace will be billed by its
    proportional use. This does not change the overall billing, only how it will be distributed.
    Default value is 'Cluster'
    """

    CLUSTER = "Cluster"
    WORKSPACES = "Workspaces"

class ClusterEntityStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the cluster.
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETING = "Deleting"
    PROVISIONING_ACCOUNT = "ProvisioningAccount"
    UPDATING = "Updating"

class ClusterSkuNameEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the SKU.
    """

    CAPACITY_RESERVATION = "CapacityReservation"

class DataIngestionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of data ingestion for this workspace.
    """

    #: Ingestion enabled following daily cap quota reset, or subscription enablement.
    RESPECT_QUOTA = "RespectQuota"
    #: Ingestion started following service setting change.
    FORCE_ON = "ForceOn"
    #: Ingestion stopped following service setting change.
    FORCE_OFF = "ForceOff"
    #: Reached daily cap quota, ingestion stopped.
    OVER_QUOTA = "OverQuota"
    #: Ingestion stopped following suspended subscription.
    SUBSCRIPTION_SUSPENDED = "SubscriptionSuspended"
    #: 80% of daily cap quota reached.
    APPROACHING_QUOTA = "ApproachingQuota"

class DataSourceKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the DataSource.
    """

    WINDOWS_EVENT = "WindowsEvent"
    WINDOWS_PERFORMANCE_COUNTER = "WindowsPerformanceCounter"
    IIS_LOGS = "IISLogs"
    LINUX_SYSLOG = "LinuxSyslog"
    LINUX_SYSLOG_COLLECTION = "LinuxSyslogCollection"
    LINUX_PERFORMANCE_OBJECT = "LinuxPerformanceObject"
    LINUX_PERFORMANCE_COLLECTION = "LinuxPerformanceCollection"
    CUSTOM_LOG = "CustomLog"
    CUSTOM_LOG_COLLECTION = "CustomLogCollection"
    AZURE_AUDIT_LOG = "AzureAuditLog"
    AZURE_ACTIVITY_LOG = "AzureActivityLog"
    GENERIC_DATA_SOURCE = "GenericDataSource"
    CHANGE_TRACKING_CUSTOM_PATH = "ChangeTrackingCustomPath"
    CHANGE_TRACKING_PATH = "ChangeTrackingPath"
    CHANGE_TRACKING_SERVICES = "ChangeTrackingServices"
    CHANGE_TRACKING_DATA_TYPE_CONFIGURATION = "ChangeTrackingDataTypeConfiguration"
    CHANGE_TRACKING_DEFAULT_REGISTRY = "ChangeTrackingDefaultRegistry"
    CHANGE_TRACKING_REGISTRY = "ChangeTrackingRegistry"
    CHANGE_TRACKING_LINUX_PATH = "ChangeTrackingLinuxPath"
    LINUX_CHANGE_TRACKING_PATH = "LinuxChangeTrackingPath"
    CHANGE_TRACKING_CONTENT_LOCATION = "ChangeTrackingContentLocation"
    WINDOWS_TELEMETRY = "WindowsTelemetry"
    OFFICE365 = "Office365"
    SECURITY_WINDOWS_BASELINE_CONFIGURATION = "SecurityWindowsBaselineConfiguration"
    SECURITY_CENTER_SECURITY_WINDOWS_BASELINE_CONFIGURATION = "SecurityCenterSecurityWindowsBaselineConfiguration"
    SECURITY_EVENT_COLLECTION_CONFIGURATION = "SecurityEventCollectionConfiguration"
    SECURITY_INSIGHTS_SECURITY_EVENT_COLLECTION_CONFIGURATION = "SecurityInsightsSecurityEventCollectionConfiguration"
    IMPORT_COMPUTER_GROUP = "ImportComputerGroup"
    NETWORK_MONITORING = "NetworkMonitoring"
    ITSM = "Itsm"
    DNS_ANALYTICS = "DnsAnalytics"
    APPLICATION_INSIGHTS = "ApplicationInsights"
    SQL_DATA_CLASSIFICATION = "SqlDataClassification"

class DataSourceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Linked storage accounts type.
    """

    CUSTOM_LOGS = "CustomLogs"
    AZURE_WATSON = "AzureWatson"
    QUERY = "Query"
    ALERTS = "Alerts"

class IdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of managed service identity.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    NONE = "None"

class LinkedServiceEntityStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the linked service.
    """

    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    PROVISIONING_ACCOUNT = "ProvisioningAccount"
    UPDATING = "Updating"

class PublicNetworkAccessType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The network access type for operating on the Log Analytics Workspace. By default it is Enabled
    """

    #: Enables connectivity to Log Analytics through public DNS.
    ENABLED = "Enabled"
    #: Disables public connectivity to Log Analytics through public DNS.
    DISABLED = "Disabled"

class PurgeState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the operation represented by the requested Id.
    """

    PENDING = "pending"
    COMPLETED = "completed"

class SearchSortEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The sort order of the search.
    """

    ASC = "asc"
    DESC = "desc"

class SkuNameEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the Service Tier.
    """

    FREE = "Free"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    PER_NODE = "PerNode"
    PER_GB2018 = "PerGB2018"
    STANDALONE = "Standalone"
    CAPACITY_RESERVATION = "CapacityReservation"

class StorageInsightState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the storage insight connection to the workspace
    """

    OK = "OK"
    ERROR = "ERROR"

class Type(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the destination resource
    """

    STORAGE_ACCOUNT = "StorageAccount"
    EVENT_HUB = "EventHub"

class WorkspaceEntityStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the workspace.
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETING = "Deleting"
    PROVISIONING_ACCOUNT = "ProvisioningAccount"
    UPDATING = "Updating"

class WorkspaceSkuNameEnum(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the SKU.
    """

    FREE = "Free"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    PER_NODE = "PerNode"
    PER_GB2018 = "PerGB2018"
    STANDALONE = "Standalone"
    CAPACITY_RESERVATION = "CapacityReservation"
    LA_CLUSTER = "LACluster"
