# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING

from azure.core import AsyncPipelineClient
from azure.core.rest import AsyncHttpResponse, HttpRequest

from .. import models
from .._serialization import Deserializer, Serializer
from ._configuration import GeolocationClientConfiguration
from .operations import GeolocationOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class GeolocationClient:  # pylint: disable=client-accepts-api-version-keyword
    """Azure Maps Geolocation REST APIs.

    :ivar geolocation: GeolocationOperations operations
    :vartype geolocation: azure.maps.geolocation.aio.operations.GeolocationOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param client_id: Specifies which account is intended for usage in conjunction with the Azure
     AD security model.  It represents a unique ID for the Azure Maps account and can be retrieved
     from the Azure Maps management  plane Account API. To use Azure AD security in Azure Maps see
     the following `articles <https://aka.ms/amauthdetails>`_ for guidance. Default value is None.
    :type client_id: str
    :keyword endpoint: Service URL. Default value is "https://atlas.microsoft.com".
    :paramtype endpoint: str
    :keyword api_version: Api Version. Default value is "1.0". Note that overriding this default
     value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        client_id: Optional[str] = None,
        *,
        endpoint: str = "https://atlas.microsoft.com",
        **kwargs: Any
    ) -> None:
        self._config = GeolocationClientConfiguration(credential=credential, client_id=client_id, **kwargs)
        self._client = AsyncPipelineClient(base_url=endpoint, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.geolocation = GeolocationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )


    def send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client.send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "GeolocationClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
