# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AdvancedCustomProperties(_serialization.Model):
    """Informatica Serverless advanced custom properties.

    :ivar key: advanced custom properties key.
    :vartype key: str
    :ivar value: advanced custom properties value.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: advanced custom properties key.
        :paramtype key: str
        :keyword value: advanced custom properties value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class ApplicationConfigs(_serialization.Model):
    """Application configs.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the application config. Required.
    :vartype type: str
    :ivar name: Name of the application config. Required.
    :vartype name: str
    :ivar value: Value of the application config. Required.
    :vartype value: str
    :ivar platform: Platform type of the application config. Required.
    :vartype platform: str
    :ivar customized: Customized value of the application config. Required.
    :vartype customized: str
    :ivar default_value: Default value of the application config. Required.
    :vartype default_value: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
        "value": {"required": True},
        "platform": {"required": True},
        "customized": {"required": True},
        "default_value": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "customized": {"key": "customized", "type": "str"},
        "default_value": {"key": "defaultValue", "type": "str"},
    }

    def __init__(
        self, *, type: str, name: str, value: str, platform: str, customized: str, default_value: str, **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the application config. Required.
        :paramtype type: str
        :keyword name: Name of the application config. Required.
        :paramtype name: str
        :keyword value: Value of the application config. Required.
        :paramtype value: str
        :keyword platform: Platform type of the application config. Required.
        :paramtype platform: str
        :keyword customized: Customized value of the application config. Required.
        :paramtype customized: str
        :keyword default_value: Default value of the application config. Required.
        :paramtype default_value: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name
        self.value = value
        self.platform = platform
        self.customized = customized
        self.default_value = default_value


class ApplicationTypeMetadata(_serialization.Model):
    """Informatica Serverless Runtime Application type Metadata.

    :ivar name: Application type name.
    :vartype name: str
    :ivar value: Application type value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Application type name.
        :paramtype name: str
        :keyword value: Application type value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class CdiConfigProps(_serialization.Model):
    """Informatica CDI Configuration Properties.

    All required parameters must be populated in order to send to server.

    :ivar engine_name: EngineName of the application config. Required.
    :vartype engine_name: str
    :ivar engine_version: EngineVersion of the application config. Required.
    :vartype engine_version: str
    :ivar application_configs: ApplicationConfigs of the CDI or CDIE. Required.
    :vartype application_configs:
     list[~azure.mgmt.informaticadatamanagement.models.ApplicationConfigs]
    """

    _validation = {
        "engine_name": {"required": True},
        "engine_version": {"required": True},
        "application_configs": {"required": True},
    }

    _attribute_map = {
        "engine_name": {"key": "engineName", "type": "str"},
        "engine_version": {"key": "engineVersion", "type": "str"},
        "application_configs": {"key": "applicationConfigs", "type": "[ApplicationConfigs]"},
    }

    def __init__(
        self,
        *,
        engine_name: str,
        engine_version: str,
        application_configs: List["_models.ApplicationConfigs"],
        **kwargs: Any
    ) -> None:
        """
        :keyword engine_name: EngineName of the application config. Required.
        :paramtype engine_name: str
        :keyword engine_version: EngineVersion of the application config. Required.
        :paramtype engine_version: str
        :keyword application_configs: ApplicationConfigs of the CDI or CDIE. Required.
        :paramtype application_configs:
         list[~azure.mgmt.informaticadatamanagement.models.ApplicationConfigs]
        """
        super().__init__(**kwargs)
        self.engine_name = engine_name
        self.engine_version = engine_version
        self.application_configs = application_configs


class CheckDependenciesResponse(_serialization.Model):
    """Model for the check dependencies API for an informatica serverless runtime resource.

    All required parameters must be populated in order to send to server.

    :ivar count: Count of dependencies. Required.
    :vartype count: int
    :ivar id: id of resource. Required.
    :vartype id: str
    :ivar references: List of dependencies. Required.
    :vartype references:
     list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeDependency]
    """

    _validation = {
        "count": {"required": True},
        "id": {"required": True},
        "references": {"required": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "id": {"key": "id", "type": "str"},
        "references": {"key": "references", "type": "[ServerlessRuntimeDependency]"},
    }

    def __init__(
        self,
        *,
        count: int,
        id: str,  # pylint: disable=redefined-builtin
        references: List["_models.ServerlessRuntimeDependency"],
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Count of dependencies. Required.
        :paramtype count: int
        :keyword id: id of resource. Required.
        :paramtype id: str
        :keyword references: List of dependencies. Required.
        :paramtype references:
         list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeDependency]
        """
        super().__init__(**kwargs)
        self.count = count
        self.id = id
        self.references = references


class CompanyDetails(_serialization.Model):
    """Company Details.

    :ivar company_name: company Name.
    :vartype company_name: str
    :ivar office_address: Office Address.
    :vartype office_address: str
    :ivar country: Country name.
    :vartype country: str
    :ivar domain: Domain name.
    :vartype domain: str
    :ivar business: Business phone number.
    :vartype business: str
    :ivar number_of_employees: Number Of Employees.
    :vartype number_of_employees: int
    """

    _attribute_map = {
        "company_name": {"key": "companyName", "type": "str"},
        "office_address": {"key": "officeAddress", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "business": {"key": "business", "type": "str"},
        "number_of_employees": {"key": "numberOfEmployees", "type": "int"},
    }

    def __init__(
        self,
        *,
        company_name: Optional[str] = None,
        office_address: Optional[str] = None,
        country: Optional[str] = None,
        domain: Optional[str] = None,
        business: Optional[str] = None,
        number_of_employees: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword company_name: company Name.
        :paramtype company_name: str
        :keyword office_address: Office Address.
        :paramtype office_address: str
        :keyword country: Country name.
        :paramtype country: str
        :keyword domain: Domain name.
        :paramtype domain: str
        :keyword business: Business phone number.
        :paramtype business: str
        :keyword number_of_employees: Number Of Employees.
        :paramtype number_of_employees: int
        """
        super().__init__(**kwargs)
        self.company_name = company_name
        self.office_address = office_address
        self.country = country
        self.domain = domain
        self.business = business
        self.number_of_employees = number_of_employees


class CompanyDetailsUpdate(_serialization.Model):
    """Company details of Informatica Organization resource.

    :ivar company_name: company Name.
    :vartype company_name: str
    :ivar office_address: Office Address.
    :vartype office_address: str
    :ivar country: Country name.
    :vartype country: str
    :ivar domain: Domain name.
    :vartype domain: str
    :ivar business: Business phone number.
    :vartype business: str
    :ivar number_of_employees: Number Of Employees.
    :vartype number_of_employees: int
    """

    _attribute_map = {
        "company_name": {"key": "companyName", "type": "str"},
        "office_address": {"key": "officeAddress", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "business": {"key": "business", "type": "str"},
        "number_of_employees": {"key": "numberOfEmployees", "type": "int"},
    }

    def __init__(
        self,
        *,
        company_name: Optional[str] = None,
        office_address: Optional[str] = None,
        country: Optional[str] = None,
        domain: Optional[str] = None,
        business: Optional[str] = None,
        number_of_employees: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword company_name: company Name.
        :paramtype company_name: str
        :keyword office_address: Office Address.
        :paramtype office_address: str
        :keyword country: Country name.
        :paramtype country: str
        :keyword domain: Domain name.
        :paramtype domain: str
        :keyword business: Business phone number.
        :paramtype business: str
        :keyword number_of_employees: Number Of Employees.
        :paramtype number_of_employees: int
        """
        super().__init__(**kwargs)
        self.company_name = company_name
        self.office_address = office_address
        self.country = country
        self.domain = domain
        self.business = business
        self.number_of_employees = number_of_employees


class ComputeUnitsMetadata(_serialization.Model):
    """Informatica Serverless Runtime Application type Metadata.

    :ivar name: ComputeUnit name.
    :vartype name: str
    :ivar value: ComputeUnit value.
    :vartype value: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword name: ComputeUnit name.
        :paramtype name: str
        :keyword value: ComputeUnit value.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.informaticadatamanagement.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.informaticadatamanagement.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.informaticadatamanagement.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.informaticadatamanagement.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class InfaRuntimeResourceFetchMetaData(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Informatica runtime resource metadata as received via the informatica fetch all runtime
    environments API.

    All required parameters must be populated in order to send to server.

    :ivar name: Environment name. Required.
    :vartype name: str
    :ivar created_time: Created time. Required.
    :vartype created_time: str
    :ivar updated_time: Updated Time. Required.
    :vartype updated_time: str
    :ivar created_by: Created by. Required.
    :vartype created_by: str
    :ivar updated_by: Last Updated by. Required.
    :vartype updated_by: str
    :ivar id: Informatica serverless runtime id. Required.
    :vartype id: str
    :ivar type: Environment Type. Required. "SERVERLESS"
    :vartype type: str or ~azure.mgmt.informaticadatamanagement.models.RuntimeType
    :ivar status: Status of the environment. Required.
    :vartype status: str
    :ivar status_localized: Display message for the given status. Required.
    :vartype status_localized: str
    :ivar status_message: status message. Required.
    :vartype status_message: str
    :ivar serverless_config_properties: Serverless Config Properties. Required.
    :vartype serverless_config_properties:
     ~azure.mgmt.informaticadatamanagement.models.InfaServerlessFetchConfigProperties
    :ivar description: Description of the runtime resource.
    :vartype description: str
    """

    _validation = {
        "name": {"required": True},
        "created_time": {"required": True},
        "updated_time": {"required": True},
        "created_by": {"required": True},
        "updated_by": {"required": True},
        "id": {"required": True},
        "type": {"required": True},
        "status": {"required": True},
        "status_localized": {"required": True},
        "status_message": {"required": True},
        "serverless_config_properties": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "created_time": {"key": "createdTime", "type": "str"},
        "updated_time": {"key": "updatedTime", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "updated_by": {"key": "updatedBy", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "status_localized": {"key": "statusLocalized", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "serverless_config_properties": {
            "key": "serverlessConfigProperties",
            "type": "InfaServerlessFetchConfigProperties",
        },
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        created_time: str,
        updated_time: str,
        created_by: str,
        updated_by: str,
        id: str,  # pylint: disable=redefined-builtin
        type: Union[str, "_models.RuntimeType"],
        status: str,
        status_localized: str,
        status_message: str,
        serverless_config_properties: "_models.InfaServerlessFetchConfigProperties",
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Environment name. Required.
        :paramtype name: str
        :keyword created_time: Created time. Required.
        :paramtype created_time: str
        :keyword updated_time: Updated Time. Required.
        :paramtype updated_time: str
        :keyword created_by: Created by. Required.
        :paramtype created_by: str
        :keyword updated_by: Last Updated by. Required.
        :paramtype updated_by: str
        :keyword id: Informatica serverless runtime id. Required.
        :paramtype id: str
        :keyword type: Environment Type. Required. "SERVERLESS"
        :paramtype type: str or ~azure.mgmt.informaticadatamanagement.models.RuntimeType
        :keyword status: Status of the environment. Required.
        :paramtype status: str
        :keyword status_localized: Display message for the given status. Required.
        :paramtype status_localized: str
        :keyword status_message: status message. Required.
        :paramtype status_message: str
        :keyword serverless_config_properties: Serverless Config Properties. Required.
        :paramtype serverless_config_properties:
         ~azure.mgmt.informaticadatamanagement.models.InfaServerlessFetchConfigProperties
        :keyword description: Description of the runtime resource.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.created_time = created_time
        self.updated_time = updated_time
        self.created_by = created_by
        self.updated_by = updated_by
        self.id = id
        self.type = type
        self.status = status
        self.status_localized = status_localized
        self.status_message = status_message
        self.serverless_config_properties = serverless_config_properties
        self.description = description


class InfaServerlessFetchConfigProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """InfaServerlessFetchConfigProperties for the fetch all serverless API as received from
    informatica API response.

    :ivar subnet: subnet name.
    :vartype subnet: str
    :ivar application_type: applicationType name.
    :vartype application_type: str
    :ivar resource_group_name: Resource group name.
    :vartype resource_group_name: str
    :ivar advanced_custom_properties: Advanced custom properties.
    :vartype advanced_custom_properties: str
    :ivar supplementary_file_location: Supplementary File location.
    :vartype supplementary_file_location: str
    :ivar platform: Serverless Account Platform.
    :vartype platform: str
    :ivar tags: Tags for the resource.
    :vartype tags: str
    :ivar vnet: virtual network.
    :vartype vnet: str
    :ivar execution_timeout: Execution timeout.
    :vartype execution_timeout: str
    :ivar compute_units: Compute Units.
    :vartype compute_units: str
    :ivar tenant_id: Tenant ID.
    :vartype tenant_id: str
    :ivar subscription_id: subscription ID.
    :vartype subscription_id: str
    :ivar region: region name for the runtime environment.
    :vartype region: str
    :ivar serverless_arm_resource_id: Serverless Arm Resource ID.
    :vartype serverless_arm_resource_id: str
    """

    _attribute_map = {
        "subnet": {"key": "subnet", "type": "str"},
        "application_type": {"key": "applicationType", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "advanced_custom_properties": {"key": "advancedCustomProperties", "type": "str"},
        "supplementary_file_location": {"key": "supplementaryFileLocation", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "tags": {"key": "tags", "type": "str"},
        "vnet": {"key": "vnet", "type": "str"},
        "execution_timeout": {"key": "executionTimeout", "type": "str"},
        "compute_units": {"key": "computeUnits", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "serverless_arm_resource_id": {"key": "serverlessArmResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        subnet: Optional[str] = None,
        application_type: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        advanced_custom_properties: Optional[str] = None,
        supplementary_file_location: Optional[str] = None,
        platform: Optional[str] = None,
        tags: Optional[str] = None,
        vnet: Optional[str] = None,
        execution_timeout: Optional[str] = None,
        compute_units: Optional[str] = None,
        tenant_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        region: Optional[str] = None,
        serverless_arm_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subnet: subnet name.
        :paramtype subnet: str
        :keyword application_type: applicationType name.
        :paramtype application_type: str
        :keyword resource_group_name: Resource group name.
        :paramtype resource_group_name: str
        :keyword advanced_custom_properties: Advanced custom properties.
        :paramtype advanced_custom_properties: str
        :keyword supplementary_file_location: Supplementary File location.
        :paramtype supplementary_file_location: str
        :keyword platform: Serverless Account Platform.
        :paramtype platform: str
        :keyword tags: Tags for the resource.
        :paramtype tags: str
        :keyword vnet: virtual network.
        :paramtype vnet: str
        :keyword execution_timeout: Execution timeout.
        :paramtype execution_timeout: str
        :keyword compute_units: Compute Units.
        :paramtype compute_units: str
        :keyword tenant_id: Tenant ID.
        :paramtype tenant_id: str
        :keyword subscription_id: subscription ID.
        :paramtype subscription_id: str
        :keyword region: region name for the runtime environment.
        :paramtype region: str
        :keyword serverless_arm_resource_id: Serverless Arm Resource ID.
        :paramtype serverless_arm_resource_id: str
        """
        super().__init__(**kwargs)
        self.subnet = subnet
        self.application_type = application_type
        self.resource_group_name = resource_group_name
        self.advanced_custom_properties = advanced_custom_properties
        self.supplementary_file_location = supplementary_file_location
        self.platform = platform
        self.tags = tags
        self.vnet = vnet
        self.execution_timeout = execution_timeout
        self.compute_units = compute_units
        self.tenant_id = tenant_id
        self.subscription_id = subscription_id
        self.region = region
        self.serverless_arm_resource_id = serverless_arm_resource_id


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class InformaticaOrganizationResource(TrackedResource):
    """An Organization Resource by Informatica.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.informaticadatamanagement.models.OrganizationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "OrganizationProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OrganizationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.informaticadatamanagement.models.OrganizationProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class InformaticaOrganizationResourceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """The response of a InformaticaOrganizationResource list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The InformaticaOrganizationResource items on this page. Required.
    :vartype value:
     list[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InformaticaOrganizationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.InformaticaOrganizationResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The InformaticaOrganizationResource items on this page. Required.
        :paramtype value:
         list[~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InformaticaOrganizationResourceUpdate(_serialization.Model):
    """The template for adding optional properties.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Patchable PropertieInformaticaOrganizationPropertiesUpdates of the
     Organization observability resource.
    :vartype properties:
     ~azure.mgmt.informaticadatamanagement.models.OrganizationPropertiesCustomUpdate
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "OrganizationPropertiesCustomUpdate"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OrganizationPropertiesCustomUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Patchable PropertieInformaticaOrganizationPropertiesUpdates of the
         Organization observability resource.
        :paramtype properties:
         ~azure.mgmt.informaticadatamanagement.models.OrganizationPropertiesCustomUpdate
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class InformaticaProperties(_serialization.Model):
    """Properties of the Informatica organization.

    :ivar organization_id: Organization id.
    :vartype organization_id: str
    :ivar organization_name: Organization name.
    :vartype organization_name: str
    :ivar informatica_region: Informatica organization region.
    :vartype informatica_region: str
    :ivar single_sign_on_url: Single sing on URL for informatica organization.
    :vartype single_sign_on_url: str
    """

    _attribute_map = {
        "organization_id": {"key": "organizationId", "type": "str"},
        "organization_name": {"key": "organizationName", "type": "str"},
        "informatica_region": {"key": "informaticaRegion", "type": "str"},
        "single_sign_on_url": {"key": "singleSignOnUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization_id: Optional[str] = None,
        organization_name: Optional[str] = None,
        informatica_region: Optional[str] = None,
        single_sign_on_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organization_id: Organization id.
        :paramtype organization_id: str
        :keyword organization_name: Organization name.
        :paramtype organization_name: str
        :keyword informatica_region: Informatica organization region.
        :paramtype informatica_region: str
        :keyword single_sign_on_url: Single sing on URL for informatica organization.
        :paramtype single_sign_on_url: str
        """
        super().__init__(**kwargs)
        self.organization_id = organization_id
        self.organization_name = organization_name
        self.informatica_region = informatica_region
        self.single_sign_on_url = single_sign_on_url


class InformaticaServerlessRuntimeProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Serverless Runtime properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or
     ~azure.mgmt.informaticadatamanagement.models.ProvisioningState
    :ivar description: description of the serverless runtime.
    :vartype description: str
    :ivar platform: Platform type of the Serverless Runtime. "AZURE"
    :vartype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
    :ivar application_type: Application type of the Serverless Runtime environment. Known values
     are: "CDI" and "CDIE".
    :vartype application_type: str or ~azure.mgmt.informaticadatamanagement.models.ApplicationType
    :ivar compute_units: Compute units of the serverless runtime.
    :vartype compute_units: str
    :ivar execution_timeout: Serverless Execution timeout.
    :vartype execution_timeout: str
    :ivar serverless_account_location: Serverless account creation location. Required.
    :vartype serverless_account_location: str
    :ivar serverless_runtime_network_profile: Informatica Serverless Network profile properties.
    :vartype serverless_runtime_network_profile:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeNetworkProfile
    :ivar advanced_custom_properties: String KV pairs indicating Advanced custom properties.
    :vartype advanced_custom_properties:
     list[~azure.mgmt.informaticadatamanagement.models.AdvancedCustomProperties]
    :ivar supplementary_file_location: Supplementary file location.
    :vartype supplementary_file_location: str
    :ivar serverless_runtime_config: Serverless config properties.
    :vartype serverless_runtime_config:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigProperties
    :ivar serverless_runtime_tags: Serverless Runtime Tags.
    :vartype serverless_runtime_tags:
     list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeTag]
    :ivar serverless_runtime_user_context_properties: Serverless runtime user context properties.
    :vartype serverless_runtime_user_context_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeUserContextProperties
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "serverless_account_location": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "application_type": {"key": "applicationType", "type": "str"},
        "compute_units": {"key": "computeUnits", "type": "str"},
        "execution_timeout": {"key": "executionTimeout", "type": "str"},
        "serverless_account_location": {"key": "serverlessAccountLocation", "type": "str"},
        "serverless_runtime_network_profile": {
            "key": "serverlessRuntimeNetworkProfile",
            "type": "ServerlessRuntimeNetworkProfile",
        },
        "advanced_custom_properties": {"key": "advancedCustomProperties", "type": "[AdvancedCustomProperties]"},
        "supplementary_file_location": {"key": "supplementaryFileLocation", "type": "str"},
        "serverless_runtime_config": {"key": "serverlessRuntimeConfig", "type": "ServerlessRuntimeConfigProperties"},
        "serverless_runtime_tags": {"key": "serverlessRuntimeTags", "type": "[ServerlessRuntimeTag]"},
        "serverless_runtime_user_context_properties": {
            "key": "serverlessRuntimeUserContextProperties",
            "type": "ServerlessRuntimeUserContextProperties",
        },
    }

    def __init__(
        self,
        *,
        serverless_account_location: str,
        description: Optional[str] = None,
        platform: Optional[Union[str, "_models.PlatformType"]] = None,
        application_type: Optional[Union[str, "_models.ApplicationType"]] = None,
        compute_units: Optional[str] = None,
        execution_timeout: Optional[str] = None,
        serverless_runtime_network_profile: Optional["_models.ServerlessRuntimeNetworkProfile"] = None,
        advanced_custom_properties: Optional[List["_models.AdvancedCustomProperties"]] = None,
        supplementary_file_location: Optional[str] = None,
        serverless_runtime_config: Optional["_models.ServerlessRuntimeConfigProperties"] = None,
        serverless_runtime_tags: Optional[List["_models.ServerlessRuntimeTag"]] = None,
        serverless_runtime_user_context_properties: Optional["_models.ServerlessRuntimeUserContextProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: description of the serverless runtime.
        :paramtype description: str
        :keyword platform: Platform type of the Serverless Runtime. "AZURE"
        :paramtype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
        :keyword application_type: Application type of the Serverless Runtime environment. Known values
         are: "CDI" and "CDIE".
        :paramtype application_type: str or
         ~azure.mgmt.informaticadatamanagement.models.ApplicationType
        :keyword compute_units: Compute units of the serverless runtime.
        :paramtype compute_units: str
        :keyword execution_timeout: Serverless Execution timeout.
        :paramtype execution_timeout: str
        :keyword serverless_account_location: Serverless account creation location. Required.
        :paramtype serverless_account_location: str
        :keyword serverless_runtime_network_profile: Informatica Serverless Network profile properties.
        :paramtype serverless_runtime_network_profile:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeNetworkProfile
        :keyword advanced_custom_properties: String KV pairs indicating Advanced custom properties.
        :paramtype advanced_custom_properties:
         list[~azure.mgmt.informaticadatamanagement.models.AdvancedCustomProperties]
        :keyword supplementary_file_location: Supplementary file location.
        :paramtype supplementary_file_location: str
        :keyword serverless_runtime_config: Serverless config properties.
        :paramtype serverless_runtime_config:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigProperties
        :keyword serverless_runtime_tags: Serverless Runtime Tags.
        :paramtype serverless_runtime_tags:
         list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeTag]
        :keyword serverless_runtime_user_context_properties: Serverless runtime user context
         properties.
        :paramtype serverless_runtime_user_context_properties:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeUserContextProperties
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.description = description
        self.platform = platform
        self.application_type = application_type
        self.compute_units = compute_units
        self.execution_timeout = execution_timeout
        self.serverless_account_location = serverless_account_location
        self.serverless_runtime_network_profile = serverless_runtime_network_profile
        self.advanced_custom_properties = advanced_custom_properties
        self.supplementary_file_location = supplementary_file_location
        self.serverless_runtime_config = serverless_runtime_config
        self.serverless_runtime_tags = serverless_runtime_tags
        self.serverless_runtime_user_context_properties = serverless_runtime_user_context_properties


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    """


class InformaticaServerlessRuntimeResource(ProxyResource):
    """A Serverless Runtime environment  resource by Informatica.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.informaticadatamanagement.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "InformaticaServerlessRuntimeProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.InformaticaServerlessRuntimeProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class InformaticaServerlessRuntimeResourceList(_serialization.Model):
    """A list of serverless runtime resources as fetched using the informatica APIs.

    All required parameters must be populated in order to send to server.

    :ivar informatica_runtime_resources: List of runtime resources for the fetch all API. Required.
    :vartype informatica_runtime_resources:
     list[~azure.mgmt.informaticadatamanagement.models.InfaRuntimeResourceFetchMetaData]
    """

    _validation = {
        "informatica_runtime_resources": {"required": True},
    }

    _attribute_map = {
        "informatica_runtime_resources": {
            "key": "informaticaRuntimeResources",
            "type": "[InfaRuntimeResourceFetchMetaData]",
        },
    }

    def __init__(
        self, *, informatica_runtime_resources: List["_models.InfaRuntimeResourceFetchMetaData"], **kwargs: Any
    ) -> None:
        """
        :keyword informatica_runtime_resources: List of runtime resources for the fetch all API.
         Required.
        :paramtype informatica_runtime_resources:
         list[~azure.mgmt.informaticadatamanagement.models.InfaRuntimeResourceFetchMetaData]
        """
        super().__init__(**kwargs)
        self.informatica_runtime_resources = informatica_runtime_resources


class InformaticaServerlessRuntimeResourceListResult(_serialization.Model):  # pylint: disable=name-too-long
    """The response of a InformaticaServerlessRuntimeResource list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The InformaticaServerlessRuntimeResource items on this page. Required.
    :vartype value:
     list[~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InformaticaServerlessRuntimeResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.InformaticaServerlessRuntimeResource"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The InformaticaServerlessRuntimeResource items on this page. Required.
        :paramtype value:
         list[~azure.mgmt.informaticadatamanagement.models.InformaticaServerlessRuntimeResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class InformaticaServerlessRuntimeResourceUpdate(_serialization.Model):  # pylint: disable=name-too-long
    """The template for adding optional properties.

    :ivar properties: Patchable PropertieInformaticaOrganizationPropertiesUpdates of the
     Organization observability resource.
    :vartype properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimePropertiesCustomUpdate
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ServerlessRuntimePropertiesCustomUpdate"},
    }

    def __init__(
        self, *, properties: Optional["_models.ServerlessRuntimePropertiesCustomUpdate"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Patchable PropertieInformaticaOrganizationPropertiesUpdates of the
         Organization observability resource.
        :paramtype properties:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimePropertiesCustomUpdate
        """
        super().__init__(**kwargs)
        self.properties = properties


class LinkOrganization(_serialization.Model):
    """Link Organization.

    :ivar token: Link organization token.
    :vartype token: str
    """

    _attribute_map = {
        "token": {"key": "token", "type": "str"},
    }

    def __init__(self, *, token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword token: Link organization token.
        :paramtype token: str
        """
        super().__init__(**kwargs)
        self.token = token


class MarketplaceDetails(_serialization.Model):
    """Marketplace details.

    All required parameters must be populated in order to send to server.

    :ivar marketplace_subscription_id: Marketplace Subscription Id.
    :vartype marketplace_subscription_id: str
    :ivar offer_details: Marketplace offer details. Required.
    :vartype offer_details: ~azure.mgmt.informaticadatamanagement.models.OfferDetails
    """

    _validation = {
        "offer_details": {"required": True},
    }

    _attribute_map = {
        "marketplace_subscription_id": {"key": "marketplaceSubscriptionId", "type": "str"},
        "offer_details": {"key": "offerDetails", "type": "OfferDetails"},
    }

    def __init__(
        self, *, offer_details: "_models.OfferDetails", marketplace_subscription_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword marketplace_subscription_id: Marketplace Subscription Id.
        :paramtype marketplace_subscription_id: str
        :keyword offer_details: Marketplace offer details. Required.
        :paramtype offer_details: ~azure.mgmt.informaticadatamanagement.models.OfferDetails
        """
        super().__init__(**kwargs)
        self.marketplace_subscription_id = marketplace_subscription_id
        self.offer_details = offer_details


class MarketplaceDetailsUpdate(_serialization.Model):
    """Marketplace details.

    :ivar marketplace_subscription_id: Marketplace Subscription Id.
    :vartype marketplace_subscription_id: str
    :ivar offer_details: Marketplace offer details.
    :vartype offer_details: ~azure.mgmt.informaticadatamanagement.models.OfferDetailsUpdate
    """

    _attribute_map = {
        "marketplace_subscription_id": {"key": "marketplaceSubscriptionId", "type": "str"},
        "offer_details": {"key": "offerDetails", "type": "OfferDetailsUpdate"},
    }

    def __init__(
        self,
        *,
        marketplace_subscription_id: Optional[str] = None,
        offer_details: Optional["_models.OfferDetailsUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword marketplace_subscription_id: Marketplace Subscription Id.
        :paramtype marketplace_subscription_id: str
        :keyword offer_details: Marketplace offer details.
        :paramtype offer_details: ~azure.mgmt.informaticadatamanagement.models.OfferDetailsUpdate
        """
        super().__init__(**kwargs)
        self.marketplace_subscription_id = marketplace_subscription_id
        self.offer_details = offer_details


class NetworkInterfaceConfiguration(_serialization.Model):
    """Informatica Serverless Runtime Network Interface configurations.

    All required parameters must be populated in order to send to server.

    :ivar vnet_id: Virtual network resource id. Required.
    :vartype vnet_id: str
    :ivar subnet_id: Virtual network subnet resource id. Required.
    :vartype subnet_id: str
    :ivar vnet_resource_guid: Virtual network resource guid.
    :vartype vnet_resource_guid: str
    """

    _validation = {
        "vnet_id": {"required": True},
        "subnet_id": {"required": True},
    }

    _attribute_map = {
        "vnet_id": {"key": "vnetId", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "vnet_resource_guid": {"key": "vnetResourceGuid", "type": "str"},
    }

    def __init__(
        self, *, vnet_id: str, subnet_id: str, vnet_resource_guid: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword vnet_id: Virtual network resource id. Required.
        :paramtype vnet_id: str
        :keyword subnet_id: Virtual network subnet resource id. Required.
        :paramtype subnet_id: str
        :keyword vnet_resource_guid: Virtual network resource guid.
        :paramtype vnet_resource_guid: str
        """
        super().__init__(**kwargs)
        self.vnet_id = vnet_id
        self.subnet_id = subnet_id
        self.vnet_resource_guid = vnet_resource_guid


class NetworkInterfaceConfigurationUpdate(_serialization.Model):
    """The template for adding optional properties.

    :ivar vnet_id: Virtual network resource id.
    :vartype vnet_id: str
    :ivar subnet_id: Virtual network subnet resource id.
    :vartype subnet_id: str
    :ivar vnet_resource_guid: Virtual network resource guid.
    :vartype vnet_resource_guid: str
    """

    _attribute_map = {
        "vnet_id": {"key": "vnetId", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "vnet_resource_guid": {"key": "vnetResourceGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        vnet_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vnet_resource_guid: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vnet_id: Virtual network resource id.
        :paramtype vnet_id: str
        :keyword subnet_id: Virtual network subnet resource id.
        :paramtype subnet_id: str
        :keyword vnet_resource_guid: Virtual network resource guid.
        :paramtype vnet_resource_guid: str
        """
        super().__init__(**kwargs)
        self.vnet_id = vnet_id
        self.subnet_id = subnet_id
        self.vnet_resource_guid = vnet_resource_guid


class OfferDetails(_serialization.Model):
    """Details of the product offering.

    All required parameters must be populated in order to send to server.

    :ivar publisher_id: Id of the product publisher. Required.
    :vartype publisher_id: str
    :ivar offer_id: Id of the product offering. Required.
    :vartype offer_id: str
    :ivar plan_id: Id of the product offer plan. Required.
    :vartype plan_id: str
    :ivar plan_name: Name of the product offer plan. Required.
    :vartype plan_name: str
    :ivar term_unit: Offer plan term unit.
    :vartype term_unit: str
    :ivar term_id: Offer plan term id. Required.
    :vartype term_id: str
    """

    _validation = {
        "publisher_id": {"required": True, "max_length": 250},
        "offer_id": {"required": True, "max_length": 250},
        "plan_id": {"required": True, "max_length": 250},
        "plan_name": {"required": True, "max_length": 250},
        "term_unit": {"max_length": 50},
        "term_id": {"required": True, "max_length": 250},
    }

    _attribute_map = {
        "publisher_id": {"key": "publisherId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "plan_name": {"key": "planName", "type": "str"},
        "term_unit": {"key": "termUnit", "type": "str"},
        "term_id": {"key": "termId", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_id: str,
        offer_id: str,
        plan_id: str,
        plan_name: str,
        term_id: str,
        term_unit: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_id: Id of the product publisher. Required.
        :paramtype publisher_id: str
        :keyword offer_id: Id of the product offering. Required.
        :paramtype offer_id: str
        :keyword plan_id: Id of the product offer plan. Required.
        :paramtype plan_id: str
        :keyword plan_name: Name of the product offer plan. Required.
        :paramtype plan_name: str
        :keyword term_unit: Offer plan term unit.
        :paramtype term_unit: str
        :keyword term_id: Offer plan term id. Required.
        :paramtype term_id: str
        """
        super().__init__(**kwargs)
        self.publisher_id = publisher_id
        self.offer_id = offer_id
        self.plan_id = plan_id
        self.plan_name = plan_name
        self.term_unit = term_unit
        self.term_id = term_id


class OfferDetailsUpdate(_serialization.Model):
    """Details of the product offering.

    :ivar publisher_id: Id of the product publisher.
    :vartype publisher_id: str
    :ivar offer_id: Id of the product offering.
    :vartype offer_id: str
    :ivar plan_id: Id of the product offer plan.
    :vartype plan_id: str
    :ivar plan_name: Name of the product offer plan.
    :vartype plan_name: str
    :ivar term_unit: Offer plan term unit.
    :vartype term_unit: str
    :ivar term_id: Offer plan term id.
    :vartype term_id: str
    """

    _validation = {
        "publisher_id": {"max_length": 250},
        "offer_id": {"max_length": 250},
        "plan_id": {"max_length": 250},
        "plan_name": {"max_length": 250},
        "term_unit": {"max_length": 50},
        "term_id": {"max_length": 250},
    }

    _attribute_map = {
        "publisher_id": {"key": "publisherId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "plan_name": {"key": "planName", "type": "str"},
        "term_unit": {"key": "termUnit", "type": "str"},
        "term_id": {"key": "termId", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        plan_name: Optional[str] = None,
        term_unit: Optional[str] = None,
        term_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_id: Id of the product publisher.
        :paramtype publisher_id: str
        :keyword offer_id: Id of the product offering.
        :paramtype offer_id: str
        :keyword plan_id: Id of the product offer plan.
        :paramtype plan_id: str
        :keyword plan_name: Name of the product offer plan.
        :paramtype plan_name: str
        :keyword term_unit: Offer plan term unit.
        :paramtype term_unit: str
        :keyword term_id: Offer plan term id.
        :paramtype term_id: str
        """
        super().__init__(**kwargs)
        self.publisher_id = publisher_id
        self.offer_id = offer_id
        self.plan_id = plan_id
        self.plan_name = plan_name
        self.term_unit = term_unit
        self.term_id = term_id


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.informaticadatamanagement.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.informaticadatamanagement.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.informaticadatamanagement.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.informaticadatamanagement.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.informaticadatamanagement.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OrganizationProperties(_serialization.Model):
    """Properties specific to the Informatica DataManagement Organization resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or
     ~azure.mgmt.informaticadatamanagement.models.ProvisioningState
    :ivar informatica_properties: Informatica Organization properties.
    :vartype informatica_properties:
     ~azure.mgmt.informaticadatamanagement.models.InformaticaProperties
    :ivar marketplace_details: Marketplace details.
    :vartype marketplace_details: ~azure.mgmt.informaticadatamanagement.models.MarketplaceDetails
    :ivar user_details: User details.
    :vartype user_details: ~azure.mgmt.informaticadatamanagement.models.UserDetails
    :ivar company_details: Company details.
    :vartype company_details: ~azure.mgmt.informaticadatamanagement.models.CompanyDetails
    :ivar link_organization: Link Organization.
    :vartype link_organization: ~azure.mgmt.informaticadatamanagement.models.LinkOrganization
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "informatica_properties": {"key": "informaticaProperties", "type": "InformaticaProperties"},
        "marketplace_details": {"key": "marketplaceDetails", "type": "MarketplaceDetails"},
        "user_details": {"key": "userDetails", "type": "UserDetails"},
        "company_details": {"key": "companyDetails", "type": "CompanyDetails"},
        "link_organization": {"key": "linkOrganization", "type": "LinkOrganization"},
    }

    def __init__(
        self,
        *,
        informatica_properties: Optional["_models.InformaticaProperties"] = None,
        marketplace_details: Optional["_models.MarketplaceDetails"] = None,
        user_details: Optional["_models.UserDetails"] = None,
        company_details: Optional["_models.CompanyDetails"] = None,
        link_organization: Optional["_models.LinkOrganization"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword informatica_properties: Informatica Organization properties.
        :paramtype informatica_properties:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaProperties
        :keyword marketplace_details: Marketplace details.
        :paramtype marketplace_details: ~azure.mgmt.informaticadatamanagement.models.MarketplaceDetails
        :keyword user_details: User details.
        :paramtype user_details: ~azure.mgmt.informaticadatamanagement.models.UserDetails
        :keyword company_details: Company details.
        :paramtype company_details: ~azure.mgmt.informaticadatamanagement.models.CompanyDetails
        :keyword link_organization: Link Organization.
        :paramtype link_organization: ~azure.mgmt.informaticadatamanagement.models.LinkOrganization
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.informatica_properties = informatica_properties
        self.marketplace_details = marketplace_details
        self.user_details = user_details
        self.company_details = company_details
        self.link_organization = link_organization


class OrganizationPropertiesCustomUpdate(_serialization.Model):
    """Patchable Properties of the Informatica Organization resource.

    :ivar informatica_organization_properties: Informatica Organization properties.
    :vartype informatica_organization_properties:
     ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResourceUpdate
    :ivar marketplace_details: Marketplace details.
    :vartype marketplace_details:
     ~azure.mgmt.informaticadatamanagement.models.MarketplaceDetailsUpdate
    :ivar user_details: User details.
    :vartype user_details: ~azure.mgmt.informaticadatamanagement.models.UserDetailsUpdate
    :ivar company_details: Company Details.
    :vartype company_details: ~azure.mgmt.informaticadatamanagement.models.CompanyDetailsUpdate
    :ivar existing_resource_id: Existing Resource Id.
    :vartype existing_resource_id: str
    """

    _attribute_map = {
        "informatica_organization_properties": {
            "key": "informaticaOrganizationProperties",
            "type": "InformaticaOrganizationResourceUpdate",
        },
        "marketplace_details": {"key": "marketplaceDetails", "type": "MarketplaceDetailsUpdate"},
        "user_details": {"key": "userDetails", "type": "UserDetailsUpdate"},
        "company_details": {"key": "companyDetails", "type": "CompanyDetailsUpdate"},
        "existing_resource_id": {"key": "existingResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        informatica_organization_properties: Optional["_models.InformaticaOrganizationResourceUpdate"] = None,
        marketplace_details: Optional["_models.MarketplaceDetailsUpdate"] = None,
        user_details: Optional["_models.UserDetailsUpdate"] = None,
        company_details: Optional["_models.CompanyDetailsUpdate"] = None,
        existing_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword informatica_organization_properties: Informatica Organization properties.
        :paramtype informatica_organization_properties:
         ~azure.mgmt.informaticadatamanagement.models.InformaticaOrganizationResourceUpdate
        :keyword marketplace_details: Marketplace details.
        :paramtype marketplace_details:
         ~azure.mgmt.informaticadatamanagement.models.MarketplaceDetailsUpdate
        :keyword user_details: User details.
        :paramtype user_details: ~azure.mgmt.informaticadatamanagement.models.UserDetailsUpdate
        :keyword company_details: Company Details.
        :paramtype company_details: ~azure.mgmt.informaticadatamanagement.models.CompanyDetailsUpdate
        :keyword existing_resource_id: Existing Resource Id.
        :paramtype existing_resource_id: str
        """
        super().__init__(**kwargs)
        self.informatica_organization_properties = informatica_organization_properties
        self.marketplace_details = marketplace_details
        self.user_details = user_details
        self.company_details = company_details
        self.existing_resource_id = existing_resource_id


class RegionsMetadata(_serialization.Model):
    """Informatica Serverless Runtime Regions Metadata.

    :ivar id: Region Id.
    :vartype id: str
    :ivar name: Region name.
    :vartype name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Region Id.
        :paramtype id: str
        :keyword name: Region name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name


class ServerlessConfigProperties(_serialization.Model):
    """Metadata Serverless Config Properties.

    :ivar platform: Platform types. "AZURE"
    :vartype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
    :ivar application_types: List of application types supported by informatica.
    :vartype application_types:
     list[~azure.mgmt.informaticadatamanagement.models.ApplicationTypeMetadata]
    :ivar compute_units: The list of compute units with possible array of values.
    :vartype compute_units: list[~azure.mgmt.informaticadatamanagement.models.ComputeUnitsMetadata]
    :ivar execution_timeout: Serverless Runtime execution timeout.
    :vartype execution_timeout: str
    :ivar regions: List of supported serverless informatica regions.
    :vartype regions: list[~azure.mgmt.informaticadatamanagement.models.RegionsMetadata]
    """

    _attribute_map = {
        "platform": {"key": "platform", "type": "str"},
        "application_types": {"key": "applicationTypes", "type": "[ApplicationTypeMetadata]"},
        "compute_units": {"key": "computeUnits", "type": "[ComputeUnitsMetadata]"},
        "execution_timeout": {"key": "executionTimeout", "type": "str"},
        "regions": {"key": "regions", "type": "[RegionsMetadata]"},
    }

    def __init__(
        self,
        *,
        platform: Optional[Union[str, "_models.PlatformType"]] = None,
        application_types: Optional[List["_models.ApplicationTypeMetadata"]] = None,
        compute_units: Optional[List["_models.ComputeUnitsMetadata"]] = None,
        execution_timeout: Optional[str] = None,
        regions: Optional[List["_models.RegionsMetadata"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform: Platform types. "AZURE"
        :paramtype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
        :keyword application_types: List of application types supported by informatica.
        :paramtype application_types:
         list[~azure.mgmt.informaticadatamanagement.models.ApplicationTypeMetadata]
        :keyword compute_units: The list of compute units with possible array of values.
        :paramtype compute_units:
         list[~azure.mgmt.informaticadatamanagement.models.ComputeUnitsMetadata]
        :keyword execution_timeout: Serverless Runtime execution timeout.
        :paramtype execution_timeout: str
        :keyword regions: List of supported serverless informatica regions.
        :paramtype regions: list[~azure.mgmt.informaticadatamanagement.models.RegionsMetadata]
        """
        super().__init__(**kwargs)
        self.platform = platform
        self.application_types = application_types
        self.compute_units = compute_units
        self.execution_timeout = execution_timeout
        self.regions = regions


class ServerlessMetadataResponse(_serialization.Model):
    """Serverless Runtime environment Metadata response.

    :ivar type: type of the runtime environment. "SERVERLESS"
    :vartype type: str or ~azure.mgmt.informaticadatamanagement.models.RuntimeType
    :ivar serverless_config_properties: serverless config properties.
    :vartype serverless_config_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessConfigProperties
    :ivar serverless_runtime_config_properties: serverless runtime config properties.
    :vartype serverless_runtime_config_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigProperties
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "serverless_config_properties": {"key": "serverlessConfigProperties", "type": "ServerlessConfigProperties"},
        "serverless_runtime_config_properties": {
            "key": "serverlessRuntimeConfigProperties",
            "type": "ServerlessRuntimeConfigProperties",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RuntimeType"]] = None,
        serverless_config_properties: Optional["_models.ServerlessConfigProperties"] = None,
        serverless_runtime_config_properties: Optional["_models.ServerlessRuntimeConfigProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: type of the runtime environment. "SERVERLESS"
        :paramtype type: str or ~azure.mgmt.informaticadatamanagement.models.RuntimeType
        :keyword serverless_config_properties: serverless config properties.
        :paramtype serverless_config_properties:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessConfigProperties
        :keyword serverless_runtime_config_properties: serverless runtime config properties.
        :paramtype serverless_runtime_config_properties:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigProperties
        """
        super().__init__(**kwargs)
        self.type = type
        self.serverless_config_properties = serverless_config_properties
        self.serverless_runtime_config_properties = serverless_runtime_config_properties


class ServerlessRuntimeConfigProperties(_serialization.Model):
    """Serverless Runtime config properties.

    :ivar cdi_config_props: The List of Informatica Serverless Runtime CDI Config Properties.
    :vartype cdi_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    :ivar cdie_config_props: The List of Informatica Serverless Runtime CDIE Config Properties.
    :vartype cdie_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    """

    _attribute_map = {
        "cdi_config_props": {"key": "cdiConfigProps", "type": "[CdiConfigProps]"},
        "cdie_config_props": {"key": "cdieConfigProps", "type": "[CdiConfigProps]"},
    }

    def __init__(
        self,
        *,
        cdi_config_props: Optional[List["_models.CdiConfigProps"]] = None,
        cdie_config_props: Optional[List["_models.CdiConfigProps"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cdi_config_props: The List of Informatica Serverless Runtime CDI Config Properties.
        :paramtype cdi_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
        :keyword cdie_config_props: The List of Informatica Serverless Runtime CDIE Config Properties.
        :paramtype cdie_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
        """
        super().__init__(**kwargs)
        self.cdi_config_props = cdi_config_props
        self.cdie_config_props = cdie_config_props


class ServerlessRuntimeConfigPropertiesUpdate(_serialization.Model):
    """The template for adding optional properties.

    :ivar cdi_config_props: The List of Informatica Serverless Runtime CDI Config Properties.
    :vartype cdi_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    :ivar cdie_config_props: The List of Informatica Serverless Runtime CDIE Config Properties.
    :vartype cdie_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
    """

    _attribute_map = {
        "cdi_config_props": {"key": "cdiConfigProps", "type": "[CdiConfigProps]"},
        "cdie_config_props": {"key": "cdieConfigProps", "type": "[CdiConfigProps]"},
    }

    def __init__(
        self,
        *,
        cdi_config_props: Optional[List["_models.CdiConfigProps"]] = None,
        cdie_config_props: Optional[List["_models.CdiConfigProps"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cdi_config_props: The List of Informatica Serverless Runtime CDI Config Properties.
        :paramtype cdi_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
        :keyword cdie_config_props: The List of Informatica Serverless Runtime CDIE Config Properties.
        :paramtype cdie_config_props: list[~azure.mgmt.informaticadatamanagement.models.CdiConfigProps]
        """
        super().__init__(**kwargs)
        self.cdi_config_props = cdi_config_props
        self.cdie_config_props = cdie_config_props


class ServerlessRuntimeDependency(_serialization.Model):
    """Dependency reference for a serverless runtime resource.

    All required parameters must be populated in order to send to server.

    :ivar id: Dependency ID. Required.
    :vartype id: str
    :ivar app_context_id: Application context ID. Required.
    :vartype app_context_id: str
    :ivar path: Dependency path. Required.
    :vartype path: str
    :ivar document_type: document type. Required.
    :vartype document_type: str
    :ivar description: description of Dependency. Required.
    :vartype description: str
    :ivar last_updated_time: Last Update Time. Required.
    :vartype last_updated_time: str
    """

    _validation = {
        "id": {"required": True},
        "app_context_id": {"required": True},
        "path": {"required": True},
        "document_type": {"required": True},
        "description": {"required": True},
        "last_updated_time": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "app_context_id": {"key": "appContextId", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "document_type": {"key": "documentType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        app_context_id: str,
        path: str,
        document_type: str,
        description: str,
        last_updated_time: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Dependency ID. Required.
        :paramtype id: str
        :keyword app_context_id: Application context ID. Required.
        :paramtype app_context_id: str
        :keyword path: Dependency path. Required.
        :paramtype path: str
        :keyword document_type: document type. Required.
        :paramtype document_type: str
        :keyword description: description of Dependency. Required.
        :paramtype description: str
        :keyword last_updated_time: Last Update Time. Required.
        :paramtype last_updated_time: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.app_context_id = app_context_id
        self.path = path
        self.document_type = document_type
        self.description = description
        self.last_updated_time = last_updated_time


class ServerlessRuntimeNetworkProfile(_serialization.Model):
    """Informatica Serverless Runtime Network Profile.

    All required parameters must be populated in order to send to server.

    :ivar network_interface_configuration: Network Interface Configuration Profile. Required.
    :vartype network_interface_configuration:
     ~azure.mgmt.informaticadatamanagement.models.NetworkInterfaceConfiguration
    """

    _validation = {
        "network_interface_configuration": {"required": True},
    }

    _attribute_map = {
        "network_interface_configuration": {
            "key": "networkInterfaceConfiguration",
            "type": "NetworkInterfaceConfiguration",
        },
    }

    def __init__(
        self, *, network_interface_configuration: "_models.NetworkInterfaceConfiguration", **kwargs: Any
    ) -> None:
        """
        :keyword network_interface_configuration: Network Interface Configuration Profile. Required.
        :paramtype network_interface_configuration:
         ~azure.mgmt.informaticadatamanagement.models.NetworkInterfaceConfiguration
        """
        super().__init__(**kwargs)
        self.network_interface_configuration = network_interface_configuration


class ServerlessRuntimeNetworkProfileUpdate(_serialization.Model):
    """Informatica Serverless Network profile properties update.

    :ivar network_interface_configuration: Network Interface Configuration Profile Update.
    :vartype network_interface_configuration:
     ~azure.mgmt.informaticadatamanagement.models.NetworkInterfaceConfigurationUpdate
    """

    _attribute_map = {
        "network_interface_configuration": {
            "key": "networkInterfaceConfiguration",
            "type": "NetworkInterfaceConfigurationUpdate",
        },
    }

    def __init__(
        self,
        *,
        network_interface_configuration: Optional["_models.NetworkInterfaceConfigurationUpdate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interface_configuration: Network Interface Configuration Profile Update.
        :paramtype network_interface_configuration:
         ~azure.mgmt.informaticadatamanagement.models.NetworkInterfaceConfigurationUpdate
        """
        super().__init__(**kwargs)
        self.network_interface_configuration = network_interface_configuration


class ServerlessRuntimePropertiesCustomUpdate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Patchable Properties of the Informatica Serverless Runtime resource.

    :ivar description: description of the serverless runtime.
    :vartype description: str
    :ivar platform: Platform type of the Serverless Runtime. "AZURE"
    :vartype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
    :ivar application_type: Application type of the Serverless Runtime environment. Known values
     are: "CDI" and "CDIE".
    :vartype application_type: str or ~azure.mgmt.informaticadatamanagement.models.ApplicationType
    :ivar compute_units: Compute units of the serverless runtime.
    :vartype compute_units: str
    :ivar execution_timeout: Serverless Execution timeout.
    :vartype execution_timeout: str
    :ivar serverless_account_location: Serverless account creation location.
    :vartype serverless_account_location: str
    :ivar serverless_runtime_network_profile: Informatica Serverless Network profile properties.
    :vartype serverless_runtime_network_profile:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeNetworkProfileUpdate
    :ivar advanced_custom_properties: String KV pairs indicating Advanced custom properties.
    :vartype advanced_custom_properties:
     list[~azure.mgmt.informaticadatamanagement.models.AdvancedCustomProperties]
    :ivar supplementary_file_location: Supplementary file location.
    :vartype supplementary_file_location: str
    :ivar serverless_runtime_config: Serverless config properties.
    :vartype serverless_runtime_config:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigPropertiesUpdate
    :ivar serverless_runtime_tags: Serverless Runtime Tags.
    :vartype serverless_runtime_tags:
     list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeTag]
    :ivar serverless_runtime_user_context_properties: Serverless runtime user context properties.
    :vartype serverless_runtime_user_context_properties:
     ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeUserContextPropertiesUpdate
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "application_type": {"key": "applicationType", "type": "str"},
        "compute_units": {"key": "computeUnits", "type": "str"},
        "execution_timeout": {"key": "executionTimeout", "type": "str"},
        "serverless_account_location": {"key": "serverlessAccountLocation", "type": "str"},
        "serverless_runtime_network_profile": {
            "key": "serverlessRuntimeNetworkProfile",
            "type": "ServerlessRuntimeNetworkProfileUpdate",
        },
        "advanced_custom_properties": {"key": "advancedCustomProperties", "type": "[AdvancedCustomProperties]"},
        "supplementary_file_location": {"key": "supplementaryFileLocation", "type": "str"},
        "serverless_runtime_config": {
            "key": "serverlessRuntimeConfig",
            "type": "ServerlessRuntimeConfigPropertiesUpdate",
        },
        "serverless_runtime_tags": {"key": "serverlessRuntimeTags", "type": "[ServerlessRuntimeTag]"},
        "serverless_runtime_user_context_properties": {
            "key": "serverlessRuntimeUserContextProperties",
            "type": "ServerlessRuntimeUserContextPropertiesUpdate",
        },
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        platform: Optional[Union[str, "_models.PlatformType"]] = None,
        application_type: Optional[Union[str, "_models.ApplicationType"]] = None,
        compute_units: Optional[str] = None,
        execution_timeout: Optional[str] = None,
        serverless_account_location: Optional[str] = None,
        serverless_runtime_network_profile: Optional["_models.ServerlessRuntimeNetworkProfileUpdate"] = None,
        advanced_custom_properties: Optional[List["_models.AdvancedCustomProperties"]] = None,
        supplementary_file_location: Optional[str] = None,
        serverless_runtime_config: Optional["_models.ServerlessRuntimeConfigPropertiesUpdate"] = None,
        serverless_runtime_tags: Optional[List["_models.ServerlessRuntimeTag"]] = None,
        serverless_runtime_user_context_properties: Optional[
            "_models.ServerlessRuntimeUserContextPropertiesUpdate"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: description of the serverless runtime.
        :paramtype description: str
        :keyword platform: Platform type of the Serverless Runtime. "AZURE"
        :paramtype platform: str or ~azure.mgmt.informaticadatamanagement.models.PlatformType
        :keyword application_type: Application type of the Serverless Runtime environment. Known values
         are: "CDI" and "CDIE".
        :paramtype application_type: str or
         ~azure.mgmt.informaticadatamanagement.models.ApplicationType
        :keyword compute_units: Compute units of the serverless runtime.
        :paramtype compute_units: str
        :keyword execution_timeout: Serverless Execution timeout.
        :paramtype execution_timeout: str
        :keyword serverless_account_location: Serverless account creation location.
        :paramtype serverless_account_location: str
        :keyword serverless_runtime_network_profile: Informatica Serverless Network profile properties.
        :paramtype serverless_runtime_network_profile:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeNetworkProfileUpdate
        :keyword advanced_custom_properties: String KV pairs indicating Advanced custom properties.
        :paramtype advanced_custom_properties:
         list[~azure.mgmt.informaticadatamanagement.models.AdvancedCustomProperties]
        :keyword supplementary_file_location: Supplementary file location.
        :paramtype supplementary_file_location: str
        :keyword serverless_runtime_config: Serverless config properties.
        :paramtype serverless_runtime_config:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeConfigPropertiesUpdate
        :keyword serverless_runtime_tags: Serverless Runtime Tags.
        :paramtype serverless_runtime_tags:
         list[~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeTag]
        :keyword serverless_runtime_user_context_properties: Serverless runtime user context
         properties.
        :paramtype serverless_runtime_user_context_properties:
         ~azure.mgmt.informaticadatamanagement.models.ServerlessRuntimeUserContextPropertiesUpdate
        """
        super().__init__(**kwargs)
        self.description = description
        self.platform = platform
        self.application_type = application_type
        self.compute_units = compute_units
        self.execution_timeout = execution_timeout
        self.serverless_account_location = serverless_account_location
        self.serverless_runtime_network_profile = serverless_runtime_network_profile
        self.advanced_custom_properties = advanced_custom_properties
        self.supplementary_file_location = supplementary_file_location
        self.serverless_runtime_config = serverless_runtime_config
        self.serverless_runtime_tags = serverless_runtime_tags
        self.serverless_runtime_user_context_properties = serverless_runtime_user_context_properties


class ServerlessRuntimeTag(_serialization.Model):
    """Serverless Runtime Tags.

    :ivar name: The name (also known as the key) of the tag.
    :vartype name: str
    :ivar value: The value of the tag.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name (also known as the key) of the tag.
        :paramtype name: str
        :keyword value: The value of the tag.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ServerlessRuntimeUserContextProperties(_serialization.Model):
    """Informatica Serverless Runtime User context properties.

    All required parameters must be populated in order to send to server.

    :ivar user_context_token: User context token for OBO flow. Required.
    :vartype user_context_token: str
    """

    _validation = {
        "user_context_token": {"required": True},
    }

    _attribute_map = {
        "user_context_token": {"key": "userContextToken", "type": "str"},
    }

    def __init__(self, *, user_context_token: str, **kwargs: Any) -> None:
        """
        :keyword user_context_token: User context token for OBO flow. Required.
        :paramtype user_context_token: str
        """
        super().__init__(**kwargs)
        self.user_context_token = user_context_token


class ServerlessRuntimeUserContextPropertiesUpdate(_serialization.Model):  # pylint: disable=name-too-long
    """The template for adding optional properties.

    :ivar user_context_token: User context token for OBO flow.
    :vartype user_context_token: str
    """

    _attribute_map = {
        "user_context_token": {"key": "userContextToken", "type": "str"},
    }

    def __init__(self, *, user_context_token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword user_context_token: User context token for OBO flow.
        :paramtype user_context_token: str
        """
        super().__init__(**kwargs)
        self.user_context_token = user_context_token


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.informaticadatamanagement.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.informaticadatamanagement.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.informaticadatamanagement.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.informaticadatamanagement.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserDetails(_serialization.Model):
    """User Info of Informatica Organization resource.

    :ivar first_name: User first name.
    :vartype first_name: str
    :ivar last_name: User last name.
    :vartype last_name: str
    :ivar email_address: User email address.
    :vartype email_address: str
    :ivar upn: UPN of user.
    :vartype upn: str
    :ivar phone_number: Phone number of the user used by for contacting them if needed.
    :vartype phone_number: str
    """

    _validation = {
        "first_name": {"max_length": 50},
        "last_name": {"max_length": 50},
        "email_address": {"pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
        "phone_number": {"max_length": 40},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: User first name.
        :paramtype first_name: str
        :keyword last_name: User last name.
        :paramtype last_name: str
        :keyword email_address: User email address.
        :paramtype email_address: str
        :keyword upn: UPN of user.
        :paramtype upn: str
        :keyword phone_number: Phone number of the user used by for contacting them if needed.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.upn = upn
        self.phone_number = phone_number


class UserDetailsUpdate(_serialization.Model):
    """User Info of Informatica Organization resource.

    :ivar first_name: User first name.
    :vartype first_name: str
    :ivar last_name: User last name.
    :vartype last_name: str
    :ivar email_address: User email address.
    :vartype email_address: str
    :ivar upn: UPN of user.
    :vartype upn: str
    :ivar phone_number: Phone number of the user used by for contacting them if needed.
    :vartype phone_number: str
    """

    _validation = {
        "first_name": {"max_length": 50},
        "last_name": {"max_length": 50},
        "email_address": {"pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
        "phone_number": {"max_length": 40},
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        upn: Optional[str] = None,
        phone_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: User first name.
        :paramtype first_name: str
        :keyword last_name: User last name.
        :paramtype last_name: str
        :keyword email_address: User email address.
        :paramtype email_address: str
        :keyword upn: UPN of user.
        :paramtype upn: str
        :keyword phone_number: Phone number of the user used by for contacting them if needed.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.upn = upn
        self.phone_number = phone_number
