% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_cor.R
\name{geom_cor}
\alias{geom_cor}
\title{Add correlation and p-value to a \link{ggplot2} plot}
\usage{
geom_cor(
  mapping = NULL,
  data = NULL,
  method = "spearman",
  xpos = NULL,
  ypos = NULL,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{method}{Method to calculate the correlation. Values are
passed to \code{\link[=cor.test]{cor.test()}}. (Spearman, Pearson, Kendall).}

\item{xpos}{Locate text at that position on the x axis.}

\item{ypos}{Locate text at that position on the y axis.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
\code{geom_cor} will add the correlatin, method and p-value to the plot
automatically guessing the position if nothing else specidfied.
family font, size and colour can be used to change the format.
}
\details{
It was integrated after reading this tutorial to extend
ggplot2 \href{https://cran.r-project.org/web/packages/ggplot2/vignettes/extending-ggplot2.html}{layers}
}
\examples{
data(humanGender)
library(SummarizedExperiment)
library(ggplot2)
ggplot(as.data.frame(assay(humanGender)[1:1000,]),
       aes(x = NA20502, y = NA20504)) +
  geom_point() +
  ylim(0,1.1e5) +
  geom_cor(method = "kendall", ypos = 1e5) 
}
\seealso{
\code{\link[ggplot2:layer]{ggplot2::layer()}}
}
