## TFSA-2022-148: Overflow in `ImageProjectiveTransformV2`

### CVE Number
CVE-2022-41886

### Impact
When [`tf.raw_ops.ImageProjectiveTransformV2`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/image/image_ops.cc) is given a large output shape, it overflows.
```python
import tensorflow as tf

interpolation = "BILINEAR"
fill_mode = "REFLECT"
images = tf.constant(0.184634328, shape=[2,5,8,3], dtype=tf.float32)
transforms = tf.constant(0.378575385, shape=[2,8], dtype=tf.float32)
output_shape = tf.constant([1879048192,1879048192], shape=[2], dtype=tf.int32)
tf.raw_ops.ImageProjectiveTransformV2(images=images, transforms=transforms, output_shape=output_shape, interpolation=interpolation, fill_mode=fill_mode)
```

### Patches
We have patched the issue in GitHub commit [8faa6ea692985dbe6ce10e1a3168e0bd60a723ba](https://github.com/tensorflow/tensorflow/commit/8faa6ea692985dbe6ce10e1a3168e0bd60a723ba).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Neophytos Christou from the Secure Systems Lab (SSL) at Brown University.
