.TH HITEX 1 "11 November 2021" "Version 1.0"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP
.el .ds OX TeX
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if t .ds AX \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(TX
.if n .ds AX AmSTeX
.if t .ds AY \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(LX
.if n .ds AY AmSLaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
hitex \- HINT output from TeX
.SH SYNOPSIS
.B hitex
.RI [ options ]
.RI [ \fB&\fPformat ]
.RI [ file | \fB\e\fPcommands ]
.\"=====================================================================
.SH DESCRIPTION
Run the Hi\*(TX typesetter on
.IR file ,
usually creating
.IR file.hnt .
If the file argument has no extension, ".tex" will be appended to it. 
Instead of a file name, a set of Hi\*(TX commands can be given, the first
of which must start with a backslash.
With a 
.BI & format
argument Hi\*(TX uses a different set of precompiled commands,
contained in
.IR format\fB.fmt\fP ;
it is usually better to use the
.B -fmt
.I format
option instead.
.PP
Hi\*(TX is a version of \*(TX that creates HINT files. The HINT file
format is designed for on-screen reading of documents. Using a HINT
viewer (see
.BR  https://hint.userweb.mwn.de )
to display a HINT file its content will dynamically adapt to the
available display area.
.PP
The typical use of Hi\*(TX is with pre generated formats.
The
.B hitex
command uses the equivalent of the plain \*(TX format, and the
.B hilatex
command uses the equivalent of the \*(LX format.
To generate formats, use the
.B -ini
switch.
.PP
Hi\*(TX's handling of its command-line arguments is similar to that of
of the other \*(TX programs in the
.I web2c
implementation.
.PP
Hi\*(TX incorporates the e-\*(TX
extensions (see 
.BR etex (1))
if used with the 
.B -etex
switch.
.PP
Hi\*(TX incorporates the extensions needed for \*(LX
(see 
.BR latex (1))
if used with the 
.B -ltx
switch.
.\"=====================================================================
.SH OPTIONS
This version of Hi\*(TX understands the following command line options.
.TP
.BI -cnf-line \ string
Parse
.I string
as a
.I texmf.cnf
configuration line.  See the Kpathsea manual.
.TP
.B -compress
Enable the use of compression for the HINT file. Compressed files are
smaller but require decompression when viewing. Use only for large
files if the file size matters.
.TP
.B -empty-page
When writing books, often empty pages are inserted - for example to
begin chapters on a right hand side page. These empty pages are
a nuisance for on-screen reading where there are no left or right
hand side pages. This option keeps empty pages in the output.
.TP
.B -no-empty-page
This option tries to eliminate empty pages in the output. It is set as a default.
.TP
.B -etex
Enable the e-\*(TX extensions.  This option is only effective in
combination with
.BR -ini .
See
.BR etex (1).
.TP
.B -file-line-error
Print error messages in the form
.I file:line:error
which is similar to the way many compilers format them.
.TP
.B -no-file-line-error
Disable printing error messages in the
.I file:line:error
style.
.TP
.BI -fmt \ format
Use
.I format
as the name of the format to be used, instead of the name by which
Hi\*(TX was called or a
.I %&
line.
.TP
.B -help
Print help message and exit.
.TP
.BI -hint-debug \ bitmask
Sets HINT file debugging flags according to the 
.IR bitmask .
See the
.B -hint-debug-help
option for details.
.TP
.B -hint-debug-help
Print an explanation of the HINT debugging flags and exit.
.TP
.B -hyphenate-first-word
\*(TX will usually not attempt to insert hyphenation points into the first 
word of a paragraph. If a HINT file must be displayed on a very small device
such hyphenation points might prove necessary. This option is set by default
and enables the generation of these hyphenation points.
.TP
.B -no-hyphenate-first-word
Disable the automatic insertion of hyphenation points in the first word
of a paragraph. Needed only if complete compatibility with \*(TX is required.
.TP
.B -ini
Start in
.I INI
mode, which is used to dump formats.  The
.I INI
mode can be used for typesetting, but no format is preloaded, and
basic initializations like setting catcodes may be required.
.TP
.BI -interaction \ mode
Sets the interaction mode.  The mode can be either
.IR batchmode ,
.IR nonstopmode ,
.IR scrollmode ,
and
.IR errorstopmode .
The meaning of these modes is the same as that of the corresponding
\ecommands.
.TP
.BI -jobname \ name
Use
.I name
for the job name, instead of deriving it from the name of the input file.
.TP
.BI -kpathsea-debug \ bitmask
Sets path searching debugging flags according to the bitmask.  See the
.I Kpathsea
manual for details.
.TP
.B -ltx
Enable the \*(LX extensions.  This option is only effective in
combination with
.BR -ini .
See
.BR latex (1).
.TP
.BI -mfmode \ mode
Use
.I mode
as the \*(MF 
.I mode
when generating missing fonts. See 
.BR mf (1)
for details.
.TP
.BI -mktex \ fmt
Enable
.RI mktex fmt ,
where
.I fmt
must be either
.IR tex ,
.IR tfm ,
.IR fmt ,
or
.IR pk .
.TP
.BI -no-mktex \ fmt
Disable
.RI mktex fmt ,
where
.I fmt
must be either
.IR tex ,
.IR tfm ,
.IR fmt ,
or
.IR pk .
.TP
.BI -output-directory \ directory
Write output files in
.I directory
instead of the current directory.  Look up input files in
.I directory
first, then along the normal search path.
.TP
.B -parse-first-line
If the first line of the main input file begins with
.I %&
parse it to look for a dump name.
.TP
.B -no-parse-first-line
Disable parsing of the first line of the main input file.
.TP
.BI -progname \ name
Pretend to be program
.IR name .
This affects both the format used and the search paths.
.TP
.BI -resolution \ number
When using \*(MF to generate missing pk fonts, use a resolution of 
.I number
DPI.  See 
.BR mf (1)
for details.
.TP
.B -version
Print version information and exit.
.\"=====================================================================
.SH ENVIRONMENT
See the Kpathsea library documentation (e.g., the `Path specifications'
node) for precise details of how the environment variables are used.
The
.B kpsewhich
utility can be used to query the values of the variables.
.PP
One caveat: In most Hi\*(TX formats, you cannot use ~ in a file name you
give directly to Hi\*(TX, because ~ is an active character in \*(TX,
and hence is expanded, not taken as part of the file name. Other
programs, such as \*(MF, do not have this problem.
.PP
.TP
.B TEXMFOUTPUT
Normally, Hi\*(TX puts its output files in the current directory.  If
any output file cannot be opened there, it tries to open it in the
directory specified in the environment variable TEXMFOUTPUT.
There is no default value for that variable.  For example, if you say
.I hitex paper
and the current directory is not writable and TEXMFOUTPUT has
the value
.IR /tmp ,
Hi\*(TX attempts to create
.I /tmp/paper.log
(and
.IR /tmp/paper.hnt ,
if any output is produced.)  TEXMFOUTPUT is also checked for input
files, as \*(TX often generates files that need to be subsequently
read; for input, no suffixes (such as ``.tex'') are added by default,
the input name is simply checked as given.
.TP
.B TEXINPUTS
Search path for
.I \einput
and
.I \eopenin
files.
This normally starts with ``.'', so
that user files are found before system files.  An empty path
component will be replaced with the paths defined in the
.I texmf.cnf
file.  For example, set TEXINPUTS to ".:/home/user/tex:" to prepend the
current directory and ``/home/user/tex'' to the standard search path.
.TP
.B TEXFORMATS
Search path for format files.
.TP
.B TFMFONTS
Search path for font metric
.RI ( .tfm )
files.
.TP
.B SOURCE_DATE_EPOCH
If set, its value, taken to be in epoch-seconds, will be used for the
creation date and as the reference moment for the time related 
primitives of \*(LX. This is useful for making reproducible builds.
.TP
.B FORCE_SOURCE_DATE
If set to the value "1", the time-related \*(TX primitives
.RI ( \eyear ,
.IR \emonth ,
.IR \eday ,
.IR \etime )
are also initialized from the value of SOURCE_DATE_EPOCH.  This is not
recommended if there is any viable alternative.
.PP
Many, many more environment variables may be consulted related to path
searching.  See the Kpathsea manual.
.\"=====================================================================
.SH FILES
The location of the files mentioned below varies from system to
system.  Use the
.B kpsewhich
utility to find their locations.
.TP
.I *.tfm
Metric files for Hi\*(TX's fonts.
.TP
.I *.fmt
Predigested Hi\*(TX format files.
.TP
.I *.pk *.pfb
Font files used by Hi\*(TX.
.\"=====================================================================
.SH NOTES
This manual page is not meant to be exhaustive.  The complete
documentation for Hi\*(TX can be found in the 
.IR "Hi\*(TX user manual"
Further information can be found in the  manual of the
.I "Kpathsea library" 
and in
.I "HINT: The file format"
which is available as a book or in electronic form from the 
HINT project home page at 
.BR https://hint.userweb.mwn.de .
.\"=====================================================================
.SH BUGS
This version of Hi\*(TX fails to handle correctly glues and kerns with a 
width that depends on \ehsize or \evsize. Similarly, when
the layout of table entries or mathematical formulas depends on \ehsize 
or \evsize their output might be distorted. 
.\"=====================================================================
.SH AVAILABILITY
Hi\*(TX should compile on a large variety of machine architectures
and operating systems.
Hi\*(TX is part of the \*(TX Live distribution.
.PP
The Hi\*(TX home page is at 
.BR https://hint.userweb.mwn.de .
There you find additional software, most importantly viewers for HINT files,
and further information.
.\"=====================================================================
.SH "SEE ALSO"
.BR histretch (1),
.BR hishrink (1),
.BR latex (1),
.BR tex (1),
.BR kpsewhich (1),
.\"=====================================================================
.SH AUTHORS
The primary author of Hi\*(TX is Martin Ruckert,
with e\*(TX extensions by Peter Breitenlohner,
\*(LX extensions by Thierry Laronde, and
the kpathsearch library by Karl Berry.
.PP
\*(TX was designed by Donald E. Knuth,
who implemented it using his \*(WB system for Pascal programs.
.PP
Many, many more contributed to the typesetting system now known as \*(TX;
far too many to name all of them here.
.\" vim: syntax=nroff
