/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};


static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

#define VALA_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD, ValaMethodPrivate))
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);


/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}


ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp19_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaParameter* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				ValaScope* _tmp14_;
				ValaScope* _tmp15_;
				ValaParameter* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = param;
				_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				vala_scope_remove (_tmp15_, _tmp18_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp19_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp19_);
}


gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaParameter* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}


static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaLocalVariable* _tmp42_;
	ValaLocalVariable* _tmp43_;
	ValaList* _tmp46_;
	ValaList* _tmp59_;
	ValaBlock* _tmp72_;
	ValaBlock* _tmp73_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			_tmp4_ = _p_index;
			_p_index = _tmp4_ + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = _p_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			p = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp11_ = vala_method_get_base_interface_type (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_method_get_base_interface_type (self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _param_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _param_index = 0;
		_tmp19_ = self->priv->parameters;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_param_list = _tmp20_;
		_tmp21_ = _param_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_param_size = _tmp23_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaParameter* param = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			_tmp24_ = _param_index;
			_param_index = _tmp24_ + 1;
			_tmp25_ = _param_index;
			_tmp26_ = _param_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _param_list;
			_tmp28_ = _param_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp31_;
		gint _error_type_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _error_type_index = 0;
		_tmp31_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp31_;
		_tmp32_ = _error_type_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_error_type_size = _tmp34_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_;
			ValaDataType* _tmp41_;
			_tmp35_ = _error_type_index;
			_error_type_index = _tmp35_ + 1;
			_tmp36_ = _error_type_index;
			_tmp37_ = _error_type_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _error_type_list;
			_tmp39_ = _error_type_index;
			_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
			error_type = (ValaDataType*) _tmp40_;
			_tmp41_ = error_type;
			vala_code_node_accept ((ValaCodeNode*) _tmp41_, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp42_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp43_ = _tmp42_;
	if (_tmp43_ != NULL) {
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		_tmp44_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp45_ = _tmp44_;
		vala_code_node_accept ((ValaCodeNode*) _tmp45_, visitor);
	}
	_tmp46_ = self->priv->preconditions;
	if (_tmp46_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp47_;
			ValaList* _tmp48_;
			gint _precondition_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _precondition_index = 0;
			_tmp47_ = self->priv->preconditions;
			_tmp48_ = _vala_iterable_ref0 (_tmp47_);
			_precondition_list = _tmp48_;
			_tmp49_ = _precondition_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_precondition_size = _tmp51_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp55_;
				gint _tmp56_;
				gpointer _tmp57_;
				ValaExpression* _tmp58_;
				_tmp52_ = _precondition_index;
				_precondition_index = _tmp52_ + 1;
				_tmp53_ = _precondition_index;
				_tmp54_ = _precondition_size;
				if (!(_tmp53_ < _tmp54_)) {
					break;
				}
				_tmp55_ = _precondition_list;
				_tmp56_ = _precondition_index;
				_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
				precondition = (ValaExpression*) _tmp57_;
				_tmp58_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp59_ = self->priv->postconditions;
	if (_tmp59_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp60_;
			ValaList* _tmp61_;
			gint _postcondition_size = 0;
			ValaList* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gint _postcondition_index = 0;
			_tmp60_ = self->priv->postconditions;
			_tmp61_ = _vala_iterable_ref0 (_tmp60_);
			_postcondition_list = _tmp61_;
			_tmp62_ = _postcondition_list;
			_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			_postcondition_size = _tmp64_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp68_;
				gint _tmp69_;
				gpointer _tmp70_;
				ValaExpression* _tmp71_;
				_tmp65_ = _postcondition_index;
				_postcondition_index = _tmp65_ + 1;
				_tmp66_ = _postcondition_index;
				_tmp67_ = _postcondition_size;
				if (!(_tmp66_ < _tmp67_)) {
					break;
				}
				_tmp68_ = _postcondition_list;
				_tmp69_ = _postcondition_index;
				_tmp70_ = vala_list_get (_tmp68_, _tmp69_);
				postcondition = (ValaExpression*) _tmp70_;
				_tmp71_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp71_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp73_ = _tmp72_;
	if (_tmp73_ != NULL) {
		ValaBlock* _tmp74_;
		ValaBlock* _tmp75_;
		_tmp74_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp75_ = _tmp74_;
		vala_code_node_accept ((ValaCodeNode*) _tmp75_, visitor);
	}
}


/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	ValaList* method_type_args = NULL;
	ValaList* _tmp46_;
	ValaList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp50_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	ValaObjectType* _tmp70_;
	ValaList* _tmp71_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp84_;
	ValaIterator* _tmp85_;
	gint param_index = 0;
	ValaIterator* _tmp132_;
	gboolean _tmp161_;
	gboolean _tmp162_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp21_;
				ValaGenericType* _tmp22_;
				ValaGenericType* _tmp23_;
				ValaObjectType* _tmp24_;
				ValaGenericType* _tmp25_;
				_tmp15_ = _type_parameter_index;
				_type_parameter_index = _tmp15_ + 1;
				_tmp16_ = _type_parameter_index;
				_tmp17_ = _type_parameter_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _type_parameter_list;
				_tmp19_ = _type_parameter_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				type_parameter = (ValaTypeParameter*) _tmp20_;
				_tmp21_ = type_parameter;
				_tmp22_ = vala_generic_type_new (_tmp21_);
				type_arg = _tmp22_;
				_tmp23_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp23_, TRUE);
				_tmp24_ = object_type;
				_tmp25_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp24_, (ValaDataType*) _tmp25_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp26_ = vala_method_get_type_parameters (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_method_get_type_parameters (base_method);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp29_ < _tmp33_;
	_vala_iterable_unref0 (_tmp31_);
	_vala_iterable_unref0 (_tmp27_);
	if (_tmp34_) {
		gchar* _tmp35_;
		_tmp35_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp35_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		ValaList* _tmp40_;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gboolean _tmp44_;
		_tmp36_ = vala_method_get_type_parameters (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_method_get_type_parameters (base_method);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = _tmp39_ > _tmp43_;
		_vala_iterable_unref0 (_tmp41_);
		_vala_iterable_unref0 (_tmp37_);
		if (_tmp44_) {
			gchar* _tmp45_;
			_tmp45_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp45_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	_tmp46_ = vala_method_get_type_parameters (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = _tmp49_ > 0;
	_vala_iterable_unref0 (_tmp47_);
	if (_tmp50_) {
		GEqualFunc _tmp51_;
		ValaArrayList* _tmp52_;
		_tmp51_ = g_direct_equal;
		_tmp52_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp51_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp52_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp53_;
			gint _type_parameter_size = 0;
			ValaList* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gint _type_parameter_index = 0;
			_tmp53_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp53_;
			_tmp54_ = _type_parameter_list;
			_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
			_tmp56_ = _tmp55_;
			_type_parameter_size = _tmp56_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp60_;
				gint _tmp61_;
				gpointer _tmp62_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp63_;
				ValaGenericType* _tmp64_;
				ValaGenericType* _tmp65_;
				ValaList* _tmp66_;
				ValaGenericType* _tmp67_;
				_tmp57_ = _type_parameter_index;
				_type_parameter_index = _tmp57_ + 1;
				_tmp58_ = _type_parameter_index;
				_tmp59_ = _type_parameter_size;
				if (!(_tmp58_ < _tmp59_)) {
					break;
				}
				_tmp60_ = _type_parameter_list;
				_tmp61_ = _type_parameter_index;
				_tmp62_ = vala_list_get (_tmp60_, _tmp61_);
				type_parameter = (ValaTypeParameter*) _tmp62_;
				_tmp63_ = type_parameter;
				_tmp64_ = vala_generic_type_new (_tmp63_);
				type_arg = _tmp64_;
				_tmp65_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp65_, TRUE);
				_tmp66_ = method_type_args;
				_tmp67_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp66_, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp68_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp69_ = _tmp68_;
	_tmp70_ = object_type;
	_tmp71_ = method_type_args;
	_tmp72_ = vala_data_type_get_actual_type (_tmp69_, (ValaDataType*) _tmp70_, _tmp71_, (ValaCodeNode*) self);
	actual_base_type = _tmp72_;
	_tmp73_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = actual_base_type;
	if (!vala_data_type_equals (_tmp74_, _tmp75_)) {
		ValaDataType* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		_tmp76_ = actual_base_type;
		_tmp77_ = vala_data_type_to_prototype_string (_tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_data_type_to_prototype_string (_tmp80_, NULL);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp78_, _tmp82_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp83_;
		_g_free0 (_tmp82_);
		_g_free0 (_tmp78_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp84_ = self->priv->parameters;
	_tmp85_ = vala_iterable_iterator ((ValaIterable*) _tmp84_);
	method_params_it = _tmp85_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp86_;
		ValaList* _tmp87_;
		gint _base_param_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _base_param_index = 0;
		_tmp86_ = base_method->priv->parameters;
		_tmp87_ = _vala_iterable_ref0 (_tmp86_);
		_base_param_list = _tmp87_;
		_tmp88_ = _base_param_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_base_param_size = _tmp90_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp94_;
			gint _tmp95_;
			gpointer _tmp96_;
			ValaIterator* _tmp97_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp99_;
			gpointer _tmp100_;
			ValaParameter* _tmp101_;
			gboolean _tmp102_;
			gboolean _tmp103_;
			ValaParameter* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			ValaParameter* _tmp108_;
			gboolean _tmp109_;
			gboolean _tmp110_;
			gint _tmp131_;
			_tmp91_ = _base_param_index;
			_base_param_index = _tmp91_ + 1;
			_tmp92_ = _base_param_index;
			_tmp93_ = _base_param_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _base_param_list;
			_tmp95_ = _base_param_index;
			_tmp96_ = vala_list_get (_tmp94_, _tmp95_);
			base_param = (ValaParameter*) _tmp96_;
			_tmp97_ = method_params_it;
			if (!vala_iterator_next (_tmp97_)) {
				gchar* _tmp98_;
				_tmp98_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp98_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp99_ = method_params_it;
			_tmp100_ = vala_iterator_get (_tmp99_);
			param = (ValaParameter*) _tmp100_;
			_tmp101_ = base_param;
			_tmp102_ = vala_parameter_get_ellipsis (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = param;
			_tmp105_ = vala_parameter_get_ellipsis (_tmp104_);
			_tmp106_ = _tmp105_;
			if (_tmp103_ != _tmp106_) {
				gchar* _tmp107_;
				_tmp107_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp107_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp108_ = base_param;
			_tmp109_ = vala_parameter_get_ellipsis (_tmp108_);
			_tmp110_ = _tmp109_;
			if (!_tmp110_) {
				ValaParameter* _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameterDirection _tmp113_;
				ValaParameter* _tmp114_;
				ValaParameterDirection _tmp115_;
				ValaParameterDirection _tmp116_;
				ValaParameter* _tmp119_;
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				ValaObjectType* _tmp122_;
				ValaList* _tmp123_;
				ValaDataType* _tmp124_;
				ValaDataType* _tmp125_;
				ValaParameter* _tmp126_;
				ValaDataType* _tmp127_;
				ValaDataType* _tmp128_;
				_tmp111_ = base_param;
				_tmp112_ = vala_parameter_get_direction (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = param;
				_tmp115_ = vala_parameter_get_direction (_tmp114_);
				_tmp116_ = _tmp115_;
				if (_tmp113_ != _tmp116_) {
					gint _tmp117_;
					gchar* _tmp118_;
					_tmp117_ = param_index;
					_tmp118_ = g_strdup_printf ("incompatible direction of parameter %d", _tmp117_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp118_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp119_ = base_param;
				_tmp120_ = vala_variable_get_variable_type ((ValaVariable*) _tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = object_type;
				_tmp123_ = method_type_args;
				_tmp124_ = vala_data_type_get_actual_type (_tmp121_, (ValaDataType*) _tmp122_, _tmp123_, (ValaCodeNode*) self);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp124_;
				_tmp125_ = actual_base_type;
				_tmp126_ = param;
				_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
				_tmp128_ = _tmp127_;
				if (!vala_data_type_equals (_tmp125_, _tmp128_)) {
					gint _tmp129_;
					gchar* _tmp130_;
					_tmp129_ = param_index;
					_tmp130_ = g_strdup_printf ("incompatible type of parameter %d", _tmp129_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp130_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp131_ = param_index;
			param_index = _tmp131_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp132_ = method_params_it;
	if (vala_iterator_next (_tmp132_)) {
		gchar* _tmp133_;
		_tmp133_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp133_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	{
		ValaList* _method_error_type_list = NULL;
		ValaList* _tmp134_;
		gint _method_error_type_size = 0;
		ValaList* _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gint _method_error_type_index = 0;
		_tmp134_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_method_error_type_list = _tmp134_;
		_tmp135_ = _method_error_type_list;
		_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
		_tmp137_ = _tmp136_;
		_method_error_type_size = _tmp137_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp138_;
			gint _tmp139_;
			gint _tmp140_;
			ValaDataType* method_error_type = NULL;
			ValaList* _tmp141_;
			gint _tmp142_;
			gpointer _tmp143_;
			gboolean match = FALSE;
			gboolean _tmp156_;
			_tmp138_ = _method_error_type_index;
			_method_error_type_index = _tmp138_ + 1;
			_tmp139_ = _method_error_type_index;
			_tmp140_ = _method_error_type_size;
			if (!(_tmp139_ < _tmp140_)) {
				break;
			}
			_tmp141_ = _method_error_type_list;
			_tmp142_ = _method_error_type_index;
			_tmp143_ = vala_list_get (_tmp141_, _tmp142_);
			method_error_type = (ValaDataType*) _tmp143_;
			match = FALSE;
			{
				ValaList* _base_method_error_type_list = NULL;
				ValaList* _tmp144_;
				gint _base_method_error_type_size = 0;
				ValaList* _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				gint _base_method_error_type_index = 0;
				_tmp144_ = vala_code_node_get_error_types ((ValaCodeNode*) base_method);
				_base_method_error_type_list = _tmp144_;
				_tmp145_ = _base_method_error_type_list;
				_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
				_tmp147_ = _tmp146_;
				_base_method_error_type_size = _tmp147_;
				_base_method_error_type_index = -1;
				while (TRUE) {
					gint _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					ValaDataType* base_method_error_type = NULL;
					ValaList* _tmp151_;
					gint _tmp152_;
					gpointer _tmp153_;
					ValaDataType* _tmp154_;
					ValaDataType* _tmp155_;
					_tmp148_ = _base_method_error_type_index;
					_base_method_error_type_index = _tmp148_ + 1;
					_tmp149_ = _base_method_error_type_index;
					_tmp150_ = _base_method_error_type_size;
					if (!(_tmp149_ < _tmp150_)) {
						break;
					}
					_tmp151_ = _base_method_error_type_list;
					_tmp152_ = _base_method_error_type_index;
					_tmp153_ = vala_list_get (_tmp151_, _tmp152_);
					base_method_error_type = (ValaDataType*) _tmp153_;
					_tmp154_ = method_error_type;
					_tmp155_ = base_method_error_type;
					if (vala_data_type_compatible (_tmp154_, _tmp155_)) {
						match = TRUE;
						_vala_code_node_unref0 (base_method_error_type);
						break;
					}
					_vala_code_node_unref0 (base_method_error_type);
				}
				_vala_iterable_unref0 (_base_method_error_type_list);
			}
			_tmp156_ = match;
			if (!_tmp156_) {
				ValaDataType* _tmp157_;
				gchar* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				_tmp157_ = method_error_type;
				_tmp158_ = vala_code_node_to_string ((ValaCodeNode*) _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = g_strdup_printf ("incompatible error type `%s'", _tmp159_);
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp160_;
				_g_free0 (_tmp159_);
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	_tmp161_ = base_method->priv->_coroutine;
	_tmp162_ = self->priv->_coroutine;
	if (_tmp161_ != _tmp162_) {
		gchar* _tmp163_;
		_tmp163_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp163_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	gint result = 0;
	ValaList* _tmp0_;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaTypeParameter* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp6_ = _parameter_index;
			_parameter_index = _tmp6_ + 1;
			_tmp7_ = _parameter_index;
			_tmp8_ = _parameter_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _parameter_list;
			_tmp10_ = _parameter_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			parameter = (ValaTypeParameter*) _tmp11_;
			_tmp12_ = parameter;
			_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp14_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp15_ = i;
			i = _tmp15_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* error_types = NULL;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				ValaList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaDataType* _tmp14_;
				gboolean _tmp15_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = error_types;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = error_types;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				_tmp14_ = (ValaDataType*) _tmp13_;
				_tmp15_ = _tmp14_ == old_type;
				_vala_code_node_unref0 (_tmp14_);
				if (_tmp15_) {
					ValaList* _tmp16_;
					gint _tmp17_;
					_tmp16_ = error_types;
					_tmp17_ = i;
					vala_list_set (_tmp16_, _tmp17_, new_type);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


static void
vala_method_find_base_methods (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->base_methods_valid;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
		if (!G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_CREATION_METHOD)) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
			_tmp7_ = self->priv->_is_virtual;
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_is_abstract;
				_tmp6_ = _tmp8_;
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp9_;
				_tmp9_ = self->priv->_overrides;
				_tmp5_ = _tmp9_;
			}
			if (_tmp5_) {
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTERFACE)) {
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_virtual;
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp16_;
				_tmp16_ = self->priv->_is_abstract;
				_tmp14_ = _tmp16_;
			}
			if (_tmp14_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp36_;
	ValaClass* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_METHOD)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp36_ = vala_class_get_base_class (cl);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaClass* _tmp38_;
		ValaClass* _tmp39_;
		_tmp38_ = vala_class_get_base_class (cl);
		_tmp39_ = _tmp38_;
		vala_method_find_base_class_method (self, _tmp39_);
	}
	_vala_code_node_unref0 (sym);
}


static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _type_index;
			_type_index = _tmp4_ + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = _type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type = (ValaDataType*) _tmp9_;
			_tmp10_ = type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_INTERFACE)) {
				gboolean _tmp13_ = FALSE;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaTypeSymbol* _tmp25_;
				ValaScope* _tmp26_;
				ValaScope* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaSymbol* _tmp31_;
				ValaSymbol* _tmp38_;
				_tmp14_ = vala_method_get_base_interface_type (self);
				_tmp15_ = _tmp14_;
				if (_tmp15_ != NULL) {
					ValaDataType* _tmp16_;
					ValaDataType* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					ValaDataType* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					ValaTypeSymbol* _tmp22_;
					_tmp16_ = vala_method_get_base_interface_type (self);
					_tmp17_ = _tmp16_;
					_tmp18_ = vala_data_type_get_data_type (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = type;
					_tmp21_ = vala_data_type_get_data_type (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp13_ = _tmp19_ != _tmp22_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp23_ = type;
				_tmp24_ = vala_data_type_get_data_type (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_scope_lookup (_tmp27_, _tmp29_);
				sym = _tmp30_;
				_tmp31_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_SIGNAL)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp32_;
					ValaSignal* _tmp33_;
					ValaSignal* _tmp34_;
					ValaMethod* _tmp35_;
					ValaMethod* _tmp36_;
					ValaSymbol* _tmp37_;
					_tmp32_ = sym;
					_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp33_;
					_tmp34_ = sig;
					_tmp35_ = vala_signal_get_default_handler (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp36_);
					_vala_code_node_unref0 (sym);
					sym = _tmp37_;
					_vala_code_node_unref0 (sig);
				}
				_tmp38_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_METHOD)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp39_;
					ValaMethod* _tmp40_;
					gboolean _tmp41_ = FALSE;
					ValaMethod* _tmp42_;
					gboolean _tmp43_;
					_tmp39_ = sym;
					_tmp40_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp40_;
					_tmp42_ = base_method;
					_tmp43_ = _tmp42_->priv->_is_abstract;
					if (_tmp43_) {
						_tmp41_ = TRUE;
					} else {
						ValaMethod* _tmp44_;
						gboolean _tmp45_;
						_tmp44_ = base_method;
						_tmp45_ = _tmp44_->priv->_is_virtual;
						_tmp41_ = _tmp45_;
					}
					if (_tmp41_) {
						ValaDataType* _tmp46_;
						ValaDataType* _tmp47_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp67_;
						gchar* _tmp68_ = NULL;
						gboolean _tmp69_;
						ValaMethod* _tmp82_;
						_tmp46_ = vala_method_get_base_interface_type (self);
						_tmp47_ = _tmp46_;
						if (_tmp47_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							gboolean _tmp66_;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp48_;
								gint _m_size = 0;
								ValaList* _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
								gint _m_index = 0;
								_tmp48_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp48_;
								_tmp49_ = _m_list;
								_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
								_tmp51_ = _tmp50_;
								_m_size = _tmp51_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp52_;
									gint _tmp53_;
									gint _tmp54_;
									ValaMethod* m = NULL;
									ValaList* _tmp55_;
									gint _tmp56_;
									gpointer _tmp57_;
									gboolean _tmp58_ = FALSE;
									ValaMethod* _tmp59_;
									ValaDataType* _tmp60_;
									ValaDataType* _tmp61_;
									_tmp52_ = _m_index;
									_m_index = _tmp52_ + 1;
									_tmp53_ = _m_index;
									_tmp54_ = _m_size;
									if (!(_tmp53_ < _tmp54_)) {
										break;
									}
									_tmp55_ = _m_list;
									_tmp56_ = _m_index;
									_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
									m = (ValaMethod*) _tmp57_;
									_tmp59_ = m;
									_tmp60_ = vala_method_get_base_interface_type (_tmp59_);
									_tmp61_ = _tmp60_;
									if (_tmp61_ != NULL) {
										ValaMethod* _tmp62_;
										ValaMethod* _tmp63_;
										ValaMethod* _tmp64_;
										ValaMethod* _tmp65_;
										_tmp62_ = base_method;
										_tmp63_ = m;
										_tmp64_ = vala_method_get_base_interface_method (_tmp63_);
										_tmp65_ = _tmp64_;
										_tmp58_ = _tmp62_ == _tmp65_;
									} else {
										_tmp58_ = FALSE;
									}
									if (_tmp58_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							_tmp66_ = has_explicit_implementation;
							if (_tmp66_) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp67_ = base_method;
						_tmp69_ = vala_method_compatible (self, _tmp67_, &_tmp68_);
						_g_free0 (invalid_match);
						invalid_match = _tmp68_;
						if (!_tmp69_) {
							ValaMethodType* base_method_type = NULL;
							ValaMethod* _tmp70_;
							ValaMethodType* _tmp71_;
							ValaSourceReference* _tmp72_;
							ValaSourceReference* _tmp73_;
							gchar* _tmp74_;
							gchar* _tmp75_;
							ValaMethodType* _tmp76_;
							gchar* _tmp77_;
							gchar* _tmp78_;
							const gchar* _tmp79_;
							gchar* _tmp80_;
							gchar* _tmp81_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp70_ = base_method;
							_tmp71_ = vala_method_type_new (_tmp70_);
							base_method_type = _tmp71_;
							_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp73_ = _tmp72_;
							_tmp74_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp75_ = _tmp74_;
							_tmp76_ = base_method_type;
							_tmp77_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp76_, NULL);
							_tmp78_ = _tmp77_;
							_tmp79_ = invalid_match;
							_tmp80_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp75_, _tmp78_, _tmp79_);
							_tmp81_ = _tmp80_;
							vala_report_error (_tmp73_, _tmp81_);
							_g_free0 (_tmp81_);
							_g_free0 (_tmp78_);
							_g_free0 (_tmp75_);
							_vala_code_node_unref0 (base_method_type);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp82_ = base_method;
						self->priv->_base_interface_method = _tmp82_;
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_method);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp83_ = vala_method_get_base_interface_type (self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaSourceReference* _tmp85_;
		ValaSourceReference* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp88_);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp86_, _tmp90_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp5_;
	gboolean _tmp6_;
	ValaAttribute* _tmp10_;
	ValaAttribute* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp15_ = FALSE;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean _tmp33_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaSourceFile* _tmp120_;
	ValaSourceFile* _tmp121_;
	ValaSourceFile* _tmp122_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp123_;
	ValaSemanticAnalyzer* _tmp124_;
	ValaSymbol* _tmp125_;
	ValaSymbol* _tmp126_;
	ValaSymbol* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaSourceReference* _tmp129_;
	ValaSemanticAnalyzer* _tmp136_;
	ValaSemanticAnalyzer* _tmp137_;
	ValaDataType* _tmp138_;
	ValaDataType* _tmp139_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp140_;
	ValaAttribute* _tmp141_;
	ValaDataType* _tmp148_;
	ValaDataType* _tmp149_;
	gboolean _tmp152_ = FALSE;
	gboolean _tmp153_ = FALSE;
	gboolean _tmp154_ = FALSE;
	ValaList* _tmp155_;
	gint _tmp156_;
	gint _tmp157_;
	gboolean optional_param = FALSE;
	ValaLocalVariable* _tmp230_;
	ValaLocalVariable* _tmp231_;
	ValaList* _tmp234_;
	ValaList* _tmp247_;
	ValaBlock* _tmp260_;
	ValaBlock* _tmp261_;
	ValaSemanticAnalyzer* _tmp264_;
	ValaSemanticAnalyzer* _tmp265_;
	ValaStruct* _tmp266_;
	ValaStruct* _tmp267_;
	gboolean _tmp303_ = FALSE;
	gboolean _tmp304_ = FALSE;
	ValaDataType* _tmp305_;
	ValaDataType* _tmp306_;
	ValaSemanticAnalyzer* _tmp354_;
	ValaSemanticAnalyzer* _tmp355_;
	ValaSourceFile* _tmp356_;
	ValaSemanticAnalyzer* _tmp357_;
	ValaSemanticAnalyzer* _tmp358_;
	ValaSymbol* _tmp359_;
	gboolean _tmp360_ = FALSE;
	gboolean _tmp361_ = FALSE;
	gboolean _tmp362_ = FALSE;
	gboolean _tmp363_;
	gboolean _tmp364_;
	ValaSemanticAnalyzer* _tmp380_;
	ValaSemanticAnalyzer* _tmp381_;
	ValaDataType* _tmp382_;
	ValaDataType* _tmp383_;
	ValaBlock* _tmp438_;
	ValaBlock* _tmp439_;
	gboolean _tmp480_ = FALSE;
	gboolean _tmp481_ = FALSE;
	gboolean _tmp482_ = FALSE;
	gboolean _tmp483_ = FALSE;
	gboolean _tmp484_ = FALSE;
	ValaAttribute* _tmp545_;
	ValaAttribute* _tmp546_;
	gboolean _tmp547_;
	gboolean _tmp548_;
	gboolean _tmp549_;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_vala_code_node_unref0 (_tmp5_);
	if (_tmp6_) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_vala_code_node_unref0 (_tmp11_);
	if (_tmp12_) {
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		_tmp13_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		vala_collection_clear ((ValaCollection*) _tmp14_);
		_vala_iterable_unref0 (_tmp14_);
	}
	_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp17_ = _tmp16_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_CLASS)) {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_;
		_tmp19_ = self->priv->_is_abstract;
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp20_;
			_tmp20_ = self->priv->_is_virtual;
			_tmp18_ = _tmp20_;
		}
		_tmp15_ = _tmp18_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaClass* _tmp23_;
		gboolean _tmp24_ = FALSE;
		ValaClass* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		_tmp21_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp23_;
		_tmp25_ = cl;
		_tmp26_ = vala_class_get_is_compact (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_) {
			ValaClass* _tmp28_;
			ValaClass* _tmp29_;
			ValaClass* _tmp30_;
			_tmp28_ = cl;
			_tmp29_ = vala_class_get_base_class (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp24_ = _tmp30_ != NULL;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaSourceReference* _tmp31_;
			ValaSourceReference* _tmp32_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp32_ = _tmp31_;
			vala_report_error (_tmp32_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp33_ = self->priv->_is_abstract;
	if (_tmp33_) {
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp38_;
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, VALA_TYPE_INTERFACE)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_CLASS)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_INTERFACE);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, VALA_TYPE_CLASS)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, VALA_TYPE_CLASS)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_INTERFACE);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		gboolean _tmp80_;
		_tmp80_ = self->priv->_is_abstract;
		if (_tmp80_) {
			_tmp79_ = TRUE;
		} else {
			gboolean _tmp81_;
			_tmp81_ = self->priv->_is_virtual;
			_tmp79_ = _tmp81_;
		}
		if (_tmp79_) {
			gboolean _tmp82_;
			gboolean _tmp83_;
			_tmp82_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp83_ = _tmp82_;
			_tmp78_ = _tmp83_;
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			gboolean _tmp84_;
			gboolean _tmp85_;
			_tmp84_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp85_ = _tmp84_;
			_tmp77_ = !_tmp85_;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			ValaSymbol* _tmp86_;
			ValaSymbol* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			_tmp86_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_symbol_get_external (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp76_ = !_tmp89_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp90_;
			ValaSourceReference* _tmp91_;
			_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp91_ = _tmp90_;
			vala_report_error (_tmp91_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_;
			gboolean _tmp94_;
			_tmp93_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp94_ = _tmp93_;
			if (_tmp94_) {
				ValaBlock* _tmp95_;
				ValaBlock* _tmp96_;
				_tmp95_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp96_ = _tmp95_;
				_tmp92_ = _tmp96_ != NULL;
			} else {
				_tmp92_ = FALSE;
			}
			if (_tmp92_) {
				ValaSourceReference* _tmp97_;
				ValaSourceReference* _tmp98_;
				_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp98_ = _tmp97_;
				vala_report_error (_tmp98_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_;
				_tmp102_ = self->priv->_is_abstract;
				if (!_tmp102_) {
					gboolean _tmp103_;
					gboolean _tmp104_;
					_tmp103_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp104_ = _tmp103_;
					_tmp101_ = !_tmp104_;
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaSourceFileType _tmp105_;
					ValaSourceFileType _tmp106_;
					_tmp105_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp106_ = _tmp105_;
					_tmp100_ = _tmp106_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaBlock* _tmp107_;
					ValaBlock* _tmp108_;
					_tmp107_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp108_ = _tmp107_;
					_tmp99_ = _tmp108_ == NULL;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp110_ = _tmp109_;
					vala_report_error (_tmp110_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp113_ = self->priv->_coroutine;
	if (_tmp113_) {
		gboolean _tmp114_;
		gboolean _tmp115_;
		_tmp114_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		_tmp112_ = !_tmp115_;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		_tmp111_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		ValaSourceReference* _tmp116_;
		ValaSourceReference* _tmp117_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp117_ = _tmp116_;
		vala_report_error (_tmp117_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_semantic_analyzer_get_current_source_file (_tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = _vala_source_file_ref0 (_tmp121_);
	old_source_file = _tmp122_;
	_tmp123_ = vala_code_context_get_analyzer (context);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_semantic_analyzer_get_current_symbol (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = _vala_code_node_ref0 (_tmp126_);
	old_symbol = _tmp127_;
	_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp129_ = _tmp128_;
	if (_tmp129_ != NULL) {
		ValaSemanticAnalyzer* _tmp130_;
		ValaSemanticAnalyzer* _tmp131_;
		ValaSourceReference* _tmp132_;
		ValaSourceReference* _tmp133_;
		ValaSourceFile* _tmp134_;
		ValaSourceFile* _tmp135_;
		_tmp130_ = vala_code_context_get_analyzer (context);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_source_reference_get_file (_tmp133_);
		_tmp135_ = _tmp134_;
		vala_semantic_analyzer_set_current_source_file (_tmp131_, _tmp135_);
	}
	_tmp136_ = vala_code_context_get_analyzer (context);
	_tmp137_ = _tmp136_;
	vala_semantic_analyzer_set_current_symbol (_tmp137_, (ValaSymbol*) self);
	_tmp138_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp139_ = _tmp138_;
	vala_code_node_check ((ValaCodeNode*) _tmp139_, context);
	_tmp140_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	init_attr = _tmp140_;
	_tmp141_ = init_attr;
	if (_tmp141_ != NULL) {
		ValaSourceReference* _tmp142_;
		ValaSourceReference* _tmp143_;
		ValaSourceFile* _tmp144_;
		ValaSourceFile* _tmp145_;
		ValaCodeContext* _tmp146_;
		ValaCodeContext* _tmp147_;
		_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_source_reference_get_file (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_source_file_get_context (_tmp145_);
		_tmp147_ = _tmp146_;
		vala_code_context_set_module_init_method (_tmp147_, self);
	}
	_tmp148_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp149_ = _tmp148_;
	if (_tmp149_ != NULL) {
		ValaDataType* _tmp150_;
		ValaDataType* _tmp151_;
		_tmp150_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp151_ = _tmp150_;
		vala_code_node_check ((ValaCodeNode*) _tmp151_, context);
	}
	_tmp155_ = self->priv->parameters;
	_tmp156_ = vala_collection_get_size ((ValaCollection*) _tmp155_);
	_tmp157_ = _tmp156_;
	if (_tmp157_ == 1) {
		ValaList* _tmp158_;
		gpointer _tmp159_;
		ValaParameter* _tmp160_;
		gboolean _tmp161_;
		gboolean _tmp162_;
		_tmp158_ = self->priv->parameters;
		_tmp159_ = vala_list_get (_tmp158_, 0);
		_tmp160_ = (ValaParameter*) _tmp159_;
		_tmp161_ = vala_parameter_get_ellipsis (_tmp160_);
		_tmp162_ = _tmp161_;
		_tmp154_ = _tmp162_;
		_vala_code_node_unref0 (_tmp160_);
	} else {
		_tmp154_ = FALSE;
	}
	if (_tmp154_) {
		ValaBlock* _tmp163_;
		ValaBlock* _tmp164_;
		_tmp163_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp164_ = _tmp163_;
		_tmp153_ = _tmp164_ != NULL;
	} else {
		_tmp153_ = FALSE;
	}
	if (_tmp153_) {
		ValaMemberBinding _tmp165_;
		_tmp165_ = self->priv->_binding;
		_tmp152_ = _tmp165_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp152_ = FALSE;
	}
	if (_tmp152_) {
		ValaList* _tmp166_;
		gpointer _tmp167_;
		ValaParameter* _tmp168_;
		ValaSourceReference* _tmp169_;
		ValaSourceReference* _tmp170_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp166_ = self->priv->parameters;
		_tmp167_ = vala_list_get (_tmp166_, 0);
		_tmp168_ = (ValaParameter*) _tmp167_;
		_tmp169_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp168_);
		_tmp170_ = _tmp169_;
		vala_report_error (_tmp170_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp168_);
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp171_;
		ValaList* _tmp172_;
		gint _param_size = 0;
		ValaList* _tmp173_;
		gint _tmp174_;
		gint _tmp175_;
		gint _param_index = 0;
		_tmp171_ = self->priv->parameters;
		_tmp172_ = _vala_iterable_ref0 (_tmp171_);
		_param_list = _tmp172_;
		_tmp173_ = _param_list;
		_tmp174_ = vala_collection_get_size ((ValaCollection*) _tmp173_);
		_tmp175_ = _tmp174_;
		_param_size = _tmp175_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp176_;
			gint _tmp177_;
			gint _tmp178_;
			ValaParameter* param = NULL;
			ValaList* _tmp179_;
			gint _tmp180_;
			gpointer _tmp181_;
			ValaParameter* _tmp182_;
			gboolean _tmp183_ = FALSE;
			gboolean _tmp184_;
			gboolean _tmp191_;
			gboolean _tmp192_ = FALSE;
			gboolean _tmp193_ = FALSE;
			gboolean _tmp194_;
			_tmp176_ = _param_index;
			_param_index = _tmp176_ + 1;
			_tmp177_ = _param_index;
			_tmp178_ = _param_size;
			if (!(_tmp177_ < _tmp178_)) {
				break;
			}
			_tmp179_ = _param_list;
			_tmp180_ = _param_index;
			_tmp181_ = vala_list_get (_tmp179_, _tmp180_);
			param = (ValaParameter*) _tmp181_;
			_tmp182_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp182_, context);
			_tmp184_ = self->priv->_coroutine;
			if (_tmp184_) {
				ValaParameter* _tmp185_;
				ValaParameterDirection _tmp186_;
				ValaParameterDirection _tmp187_;
				_tmp185_ = param;
				_tmp186_ = vala_parameter_get_direction (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp183_ = _tmp187_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp183_ = FALSE;
			}
			if (_tmp183_) {
				ValaParameter* _tmp188_;
				ValaSourceReference* _tmp189_;
				ValaSourceReference* _tmp190_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp188_ = param;
				_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp188_);
				_tmp190_ = _tmp189_;
				vala_report_error (_tmp190_, "Reference parameters are not supported for async methods");
			}
			_tmp191_ = self->priv->_coroutine;
			if (_tmp191_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp194_ = optional_param;
			if (_tmp194_) {
				ValaParameter* _tmp195_;
				ValaExpression* _tmp196_;
				ValaExpression* _tmp197_;
				_tmp195_ = param;
				_tmp196_ = vala_variable_get_initializer ((ValaVariable*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp193_ = _tmp197_ == NULL;
			} else {
				_tmp193_ = FALSE;
			}
			if (_tmp193_) {
				ValaParameter* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				_tmp198_ = param;
				_tmp199_ = vala_parameter_get_ellipsis (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp192_ = !_tmp200_;
			} else {
				_tmp192_ = FALSE;
			}
			if (_tmp192_) {
				ValaParameter* _tmp201_;
				ValaSourceReference* _tmp202_;
				ValaSourceReference* _tmp203_;
				_tmp201_ = param;
				_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp201_);
				_tmp203_ = _tmp202_;
				vala_report_warning (_tmp203_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp204_;
				ValaExpression* _tmp205_;
				ValaExpression* _tmp206_;
				_tmp204_ = param;
				_tmp205_ = vala_variable_get_initializer ((ValaVariable*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (_tmp206_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp207_;
		gint _error_type_size = 0;
		ValaList* _tmp208_;
		gint _tmp209_;
		gint _tmp210_;
		gint _error_type_index = 0;
		_tmp207_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp207_;
		_tmp208_ = _error_type_list;
		_tmp209_ = vala_collection_get_size ((ValaCollection*) _tmp208_);
		_tmp210_ = _tmp209_;
		_error_type_size = _tmp210_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp211_;
			gint _tmp212_;
			gint _tmp213_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp214_;
			gint _tmp215_;
			gpointer _tmp216_;
			ValaDataType* _tmp217_;
			ValaSemanticAnalyzer* _tmp218_;
			ValaSemanticAnalyzer* _tmp219_;
			ValaDataType* _tmp220_;
			_tmp211_ = _error_type_index;
			_error_type_index = _tmp211_ + 1;
			_tmp212_ = _error_type_index;
			_tmp213_ = _error_type_size;
			if (!(_tmp212_ < _tmp213_)) {
				break;
			}
			_tmp214_ = _error_type_list;
			_tmp215_ = _error_type_index;
			_tmp216_ = vala_list_get (_tmp214_, _tmp215_);
			error_type = (ValaDataType*) _tmp216_;
			_tmp217_ = error_type;
			vala_code_node_check ((ValaCodeNode*) _tmp217_, context);
			_tmp218_ = vala_code_context_get_analyzer (context);
			_tmp219_ = _tmp218_;
			_tmp220_ = error_type;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp219_, (ValaSymbol*) self, _tmp220_)) {
				ValaSourceReference* _tmp221_;
				ValaSourceReference* _tmp222_;
				ValaDataType* _tmp223_;
				gchar* _tmp224_;
				gchar* _tmp225_;
				gchar* _tmp226_;
				gchar* _tmp227_;
				gchar* _tmp228_;
				gchar* _tmp229_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp221_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp222_ = _tmp221_;
				_tmp223_ = error_type;
				_tmp224_ = vala_code_node_to_string ((ValaCodeNode*) _tmp223_);
				_tmp225_ = _tmp224_;
				_tmp226_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp227_ = _tmp226_;
				_tmp228_ = g_strdup_printf ("error type `%s` is less accessible than method `%s`", _tmp225_, _tmp227_);
				_tmp229_ = _tmp228_;
				vala_report_error (_tmp222_, _tmp229_);
				_g_free0 (_tmp229_);
				_g_free0 (_tmp227_);
				_g_free0 (_tmp225_);
				result = FALSE;
				_vala_code_node_unref0 (error_type);
				_vala_iterable_unref0 (_error_type_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp230_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp231_ = _tmp230_;
	if (_tmp231_ != NULL) {
		ValaLocalVariable* _tmp232_;
		ValaLocalVariable* _tmp233_;
		_tmp232_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp233_ = _tmp232_;
		vala_code_node_check ((ValaCodeNode*) _tmp233_, context);
	}
	_tmp234_ = self->priv->preconditions;
	if (_tmp234_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp235_;
			ValaList* _tmp236_;
			gint _precondition_size = 0;
			ValaList* _tmp237_;
			gint _tmp238_;
			gint _tmp239_;
			gint _precondition_index = 0;
			_tmp235_ = self->priv->preconditions;
			_tmp236_ = _vala_iterable_ref0 (_tmp235_);
			_precondition_list = _tmp236_;
			_tmp237_ = _precondition_list;
			_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
			_tmp239_ = _tmp238_;
			_precondition_size = _tmp239_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp240_;
				gint _tmp241_;
				gint _tmp242_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp243_;
				gint _tmp244_;
				gpointer _tmp245_;
				ValaExpression* _tmp246_;
				_tmp240_ = _precondition_index;
				_precondition_index = _tmp240_ + 1;
				_tmp241_ = _precondition_index;
				_tmp242_ = _precondition_size;
				if (!(_tmp241_ < _tmp242_)) {
					break;
				}
				_tmp243_ = _precondition_list;
				_tmp244_ = _precondition_index;
				_tmp245_ = vala_list_get (_tmp243_, _tmp244_);
				precondition = (ValaExpression*) _tmp245_;
				_tmp246_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp247_ = self->priv->postconditions;
	if (_tmp247_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp248_;
			ValaList* _tmp249_;
			gint _postcondition_size = 0;
			ValaList* _tmp250_;
			gint _tmp251_;
			gint _tmp252_;
			gint _postcondition_index = 0;
			_tmp248_ = self->priv->postconditions;
			_tmp249_ = _vala_iterable_ref0 (_tmp248_);
			_postcondition_list = _tmp249_;
			_tmp250_ = _postcondition_list;
			_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
			_tmp252_ = _tmp251_;
			_postcondition_size = _tmp252_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp253_;
				gint _tmp254_;
				gint _tmp255_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp256_;
				gint _tmp257_;
				gpointer _tmp258_;
				ValaExpression* _tmp259_;
				_tmp253_ = _postcondition_index;
				_postcondition_index = _tmp253_ + 1;
				_tmp254_ = _postcondition_index;
				_tmp255_ = _postcondition_size;
				if (!(_tmp254_ < _tmp255_)) {
					break;
				}
				_tmp256_ = _postcondition_list;
				_tmp257_ = _postcondition_index;
				_tmp258_ = vala_list_get (_tmp256_, _tmp257_);
				postcondition = (ValaExpression*) _tmp258_;
				_tmp259_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp259_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp260_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp261_ = _tmp260_;
	if (_tmp261_ != NULL) {
		ValaBlock* _tmp262_;
		ValaBlock* _tmp263_;
		_tmp262_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp263_ = _tmp262_;
		vala_code_node_check ((ValaCodeNode*) _tmp263_, context);
	}
	_tmp264_ = vala_code_context_get_analyzer (context);
	_tmp265_ = _tmp264_;
	_tmp266_ = vala_semantic_analyzer_get_current_struct (_tmp265_);
	_tmp267_ = _tmp266_;
	if (_tmp267_ != NULL) {
		gboolean _tmp268_ = FALSE;
		gboolean _tmp269_ = FALSE;
		gboolean _tmp270_;
		_tmp270_ = self->priv->_is_abstract;
		if (_tmp270_) {
			_tmp269_ = TRUE;
		} else {
			gboolean _tmp271_;
			_tmp271_ = self->priv->_is_virtual;
			_tmp269_ = _tmp271_;
		}
		if (_tmp269_) {
			_tmp268_ = TRUE;
		} else {
			gboolean _tmp272_;
			_tmp272_ = self->priv->_overrides;
			_tmp268_ = _tmp272_;
		}
		if (_tmp268_) {
			ValaSourceReference* _tmp273_;
			ValaSourceReference* _tmp274_;
			gchar* _tmp275_;
			gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp276_ = _tmp275_;
			_tmp277_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp276_);
			_tmp278_ = _tmp277_;
			vala_report_error (_tmp274_, _tmp278_);
			_g_free0 (_tmp278_);
			_g_free0 (_tmp276_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp279_ = FALSE;
		gboolean _tmp280_;
		_tmp280_ = self->priv->_overrides;
		if (_tmp280_) {
			ValaMethod* _tmp281_;
			ValaMethod* _tmp282_;
			_tmp281_ = vala_method_get_base_method (self);
			_tmp282_ = _tmp281_;
			_tmp279_ = _tmp282_ == NULL;
		} else {
			_tmp279_ = FALSE;
		}
		if (_tmp279_) {
			ValaSourceReference* _tmp283_;
			ValaSourceReference* _tmp284_;
			gchar* _tmp285_;
			gchar* _tmp286_;
			gchar* _tmp287_;
			gchar* _tmp288_;
			_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp284_ = _tmp283_;
			_tmp285_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp286_ = _tmp285_;
			_tmp287_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp286_);
			_tmp288_ = _tmp287_;
			vala_report_error (_tmp284_, _tmp288_);
			_g_free0 (_tmp288_);
			_g_free0 (_tmp286_);
		} else {
			gboolean _tmp289_ = FALSE;
			gboolean _tmp290_ = FALSE;
			gboolean _tmp291_ = FALSE;
			gboolean _tmp292_;
			_tmp292_ = self->priv->_is_abstract;
			if (_tmp292_) {
				_tmp291_ = TRUE;
			} else {
				gboolean _tmp293_;
				_tmp293_ = self->priv->_is_virtual;
				_tmp291_ = _tmp293_;
			}
			if (_tmp291_) {
				_tmp290_ = TRUE;
			} else {
				gboolean _tmp294_;
				_tmp294_ = self->priv->_overrides;
				_tmp290_ = _tmp294_;
			}
			if (_tmp290_) {
				ValaSymbolAccessibility _tmp295_;
				ValaSymbolAccessibility _tmp296_;
				_tmp295_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp296_ = _tmp295_;
				_tmp289_ = _tmp296_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp289_ = FALSE;
			}
			if (_tmp289_) {
				ValaSourceReference* _tmp297_;
				ValaSourceReference* _tmp298_;
				gchar* _tmp299_;
				gchar* _tmp300_;
				gchar* _tmp301_;
				gchar* _tmp302_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp298_ = _tmp297_;
				_tmp299_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp300_ = _tmp299_;
				_tmp301_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp300_);
				_tmp302_ = _tmp301_;
				vala_report_error (_tmp298_, _tmp302_);
				_g_free0 (_tmp302_);
				_g_free0 (_tmp300_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp305_ = vala_method_get_base_interface_type (self);
	_tmp306_ = _tmp305_;
	if (_tmp306_ != NULL) {
		ValaMethod* _tmp307_;
		ValaMethod* _tmp308_;
		_tmp307_ = vala_method_get_base_interface_method (self);
		_tmp308_ = _tmp307_;
		_tmp304_ = _tmp308_ != NULL;
	} else {
		_tmp304_ = FALSE;
	}
	if (_tmp304_) {
		ValaSymbol* _tmp309_;
		ValaSymbol* _tmp310_;
		_tmp309_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp310_ = _tmp309_;
		_tmp303_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp310_, VALA_TYPE_CLASS);
	} else {
		_tmp303_ = FALSE;
	}
	if (_tmp303_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp311_;
		ValaSymbol* _tmp312_;
		ValaClass* _tmp313_;
		_tmp311_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp312_ = _tmp311_;
		_tmp313_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp312_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp313_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp314_;
			ValaList* _tmp315_;
			gint _m_size = 0;
			ValaList* _tmp316_;
			gint _tmp317_;
			gint _tmp318_;
			gint _m_index = 0;
			_tmp314_ = cl;
			_tmp315_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp314_);
			_m_list = _tmp315_;
			_tmp316_ = _m_list;
			_tmp317_ = vala_collection_get_size ((ValaCollection*) _tmp316_);
			_tmp318_ = _tmp317_;
			_m_size = _tmp318_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp319_;
				gint _tmp320_;
				gint _tmp321_;
				ValaMethod* m = NULL;
				ValaList* _tmp322_;
				gint _tmp323_;
				gpointer _tmp324_;
				gboolean _tmp325_ = FALSE;
				ValaMethod* _tmp326_;
				_tmp319_ = _m_index;
				_m_index = _tmp319_ + 1;
				_tmp320_ = _m_index;
				_tmp321_ = _m_size;
				if (!(_tmp320_ < _tmp321_)) {
					break;
				}
				_tmp322_ = _m_list;
				_tmp323_ = _m_index;
				_tmp324_ = vala_list_get (_tmp322_, _tmp323_);
				m = (ValaMethod*) _tmp324_;
				_tmp326_ = m;
				if (_tmp326_ != self) {
					ValaMethod* _tmp327_;
					ValaMethod* _tmp328_;
					ValaMethod* _tmp329_;
					ValaMethod* _tmp330_;
					ValaMethod* _tmp331_;
					_tmp327_ = m;
					_tmp328_ = vala_method_get_base_interface_method (_tmp327_);
					_tmp329_ = _tmp328_;
					_tmp330_ = vala_method_get_base_interface_method (self);
					_tmp331_ = _tmp330_;
					_tmp325_ = _tmp329_ == _tmp331_;
				} else {
					_tmp325_ = FALSE;
				}
				if (_tmp325_) {
					ValaMethod* _tmp332_;
					ValaMethod* _tmp333_;
					ValaSourceReference* _tmp334_;
					ValaSourceReference* _tmp335_;
					ValaClass* _tmp336_;
					gchar* _tmp337_;
					gchar* _tmp338_;
					ValaMethod* _tmp339_;
					ValaMethod* _tmp340_;
					gchar* _tmp341_;
					gchar* _tmp342_;
					gchar* _tmp343_;
					gchar* _tmp344_;
					ValaMethod* _tmp345_;
					ValaSourceReference* _tmp346_;
					ValaSourceReference* _tmp347_;
					ValaMethod* _tmp348_;
					ValaMethod* _tmp349_;
					gchar* _tmp350_;
					gchar* _tmp351_;
					gchar* _tmp352_;
					gchar* _tmp353_;
					_tmp332_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp332_, TRUE);
					_tmp333_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp333_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp334_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp335_ = _tmp334_;
					_tmp336_ = cl;
					_tmp337_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp336_);
					_tmp338_ = _tmp337_;
					_tmp339_ = vala_method_get_base_interface_method (self);
					_tmp340_ = _tmp339_;
					_tmp341_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp340_);
					_tmp342_ = _tmp341_;
					_tmp343_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp338_, _tmp342_);
					_tmp344_ = _tmp343_;
					vala_report_error (_tmp335_, _tmp344_);
					_g_free0 (_tmp344_);
					_g_free0 (_tmp342_);
					_g_free0 (_tmp338_);
					_tmp345_ = m;
					_tmp346_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp345_);
					_tmp347_ = _tmp346_;
					_tmp348_ = vala_method_get_base_interface_method (self);
					_tmp349_ = _tmp348_;
					_tmp350_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp349_);
					_tmp351_ = _tmp350_;
					_tmp352_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp351_);
					_tmp353_ = _tmp352_;
					vala_report_notice (_tmp347_, _tmp353_);
					_g_free0 (_tmp353_);
					_g_free0 (_tmp351_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp354_ = vala_code_context_get_analyzer (context);
	_tmp355_ = _tmp354_;
	_tmp356_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp355_, _tmp356_);
	_tmp357_ = vala_code_context_get_analyzer (context);
	_tmp358_ = _tmp357_;
	_tmp359_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp358_, _tmp359_);
	_tmp363_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp364_ = _tmp363_;
	if (!_tmp364_) {
		gboolean _tmp365_;
		_tmp365_ = self->priv->_overrides;
		_tmp362_ = !_tmp365_;
	} else {
		_tmp362_ = FALSE;
	}
	if (_tmp362_) {
		gboolean _tmp366_;
		gboolean _tmp367_;
		_tmp366_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp367_ = _tmp366_;
		_tmp361_ = !_tmp367_;
	} else {
		_tmp361_ = FALSE;
	}
	if (_tmp361_) {
		ValaSymbol* _tmp368_;
		ValaSymbol* _tmp369_;
		_tmp368_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp369_ = _tmp368_;
		_tmp360_ = _tmp369_ != NULL;
		_vala_code_node_unref0 (_tmp369_);
	} else {
		_tmp360_ = FALSE;
	}
	if (_tmp360_) {
		ValaSourceReference* _tmp370_;
		ValaSourceReference* _tmp371_;
		gchar* _tmp372_;
		gchar* _tmp373_;
		ValaSymbol* _tmp374_;
		ValaSymbol* _tmp375_;
		gchar* _tmp376_;
		gchar* _tmp377_;
		gchar* _tmp378_;
		gchar* _tmp379_;
		_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp371_ = _tmp370_;
		_tmp372_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp373_ = _tmp372_;
		_tmp374_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_symbol_get_full_name (_tmp375_);
		_tmp377_ = _tmp376_;
		_tmp378_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp373_, _tmp377_);
		_tmp379_ = _tmp378_;
		vala_report_warning (_tmp371_, _tmp379_);
		_g_free0 (_tmp379_);
		_g_free0 (_tmp377_);
		_vala_code_node_unref0 (_tmp375_);
		_g_free0 (_tmp373_);
	}
	_tmp380_ = vala_code_context_get_analyzer (context);
	_tmp381_ = _tmp380_;
	_tmp382_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp383_ = _tmp382_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp381_, (ValaSymbol*) self, _tmp383_)) {
		ValaSourceReference* _tmp384_;
		ValaSourceReference* _tmp385_;
		ValaDataType* _tmp386_;
		ValaDataType* _tmp387_;
		gchar* _tmp388_;
		gchar* _tmp389_;
		gchar* _tmp390_;
		gchar* _tmp391_;
		gchar* _tmp392_;
		gchar* _tmp393_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp384_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp385_ = _tmp384_;
		_tmp386_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp387_ = _tmp386_;
		_tmp388_ = vala_code_node_to_string ((ValaCodeNode*) _tmp387_);
		_tmp389_ = _tmp388_;
		_tmp390_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp391_ = _tmp390_;
		_tmp392_ = g_strdup_printf ("return type `%s` is less accessible than method `%s`", _tmp389_, _tmp391_);
		_tmp393_ = _tmp392_;
		vala_report_error (_tmp385_, _tmp393_);
		_g_free0 (_tmp393_);
		_g_free0 (_tmp391_);
		_g_free0 (_tmp389_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp394_;
		gint _precondition_size = 0;
		ValaList* _tmp395_;
		gint _tmp396_;
		gint _tmp397_;
		gint _precondition_index = 0;
		_tmp394_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp394_;
		_tmp395_ = _precondition_list;
		_tmp396_ = vala_collection_get_size ((ValaCollection*) _tmp395_);
		_tmp397_ = _tmp396_;
		_precondition_size = _tmp397_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp398_;
			gint _tmp399_;
			gint _tmp400_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp401_;
			gint _tmp402_;
			gpointer _tmp403_;
			ValaExpression* _tmp404_;
			gboolean _tmp405_;
			gboolean _tmp406_;
			ValaExpression* _tmp407_;
			ValaDataType* _tmp408_;
			ValaDataType* _tmp409_;
			ValaSemanticAnalyzer* _tmp410_;
			ValaSemanticAnalyzer* _tmp411_;
			ValaDataType* _tmp412_;
			_tmp398_ = _precondition_index;
			_precondition_index = _tmp398_ + 1;
			_tmp399_ = _precondition_index;
			_tmp400_ = _precondition_size;
			if (!(_tmp399_ < _tmp400_)) {
				break;
			}
			_tmp401_ = _precondition_list;
			_tmp402_ = _precondition_index;
			_tmp403_ = vala_list_get (_tmp401_, _tmp402_);
			precondition = (ValaExpression*) _tmp403_;
			_tmp404_ = precondition;
			_tmp405_ = vala_code_node_get_error ((ValaCodeNode*) _tmp404_);
			_tmp406_ = _tmp405_;
			if (_tmp406_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp407_ = precondition;
			_tmp408_ = vala_expression_get_value_type (_tmp407_);
			_tmp409_ = _tmp408_;
			_tmp410_ = vala_code_context_get_analyzer (context);
			_tmp411_ = _tmp410_;
			_tmp412_ = _tmp411_->bool_type;
			if (!vala_data_type_compatible (_tmp409_, _tmp412_)) {
				ValaExpression* _tmp413_;
				ValaSourceReference* _tmp414_;
				ValaSourceReference* _tmp415_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp413_ = precondition;
				_tmp414_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp413_);
				_tmp415_ = _tmp414_;
				vala_report_error (_tmp415_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp416_;
		gint _postcondition_size = 0;
		ValaList* _tmp417_;
		gint _tmp418_;
		gint _tmp419_;
		gint _postcondition_index = 0;
		_tmp416_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp416_;
		_tmp417_ = _postcondition_list;
		_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
		_tmp419_ = _tmp418_;
		_postcondition_size = _tmp419_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp420_;
			gint _tmp421_;
			gint _tmp422_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp423_;
			gint _tmp424_;
			gpointer _tmp425_;
			ValaExpression* _tmp426_;
			gboolean _tmp427_;
			gboolean _tmp428_;
			ValaExpression* _tmp429_;
			ValaDataType* _tmp430_;
			ValaDataType* _tmp431_;
			ValaSemanticAnalyzer* _tmp432_;
			ValaSemanticAnalyzer* _tmp433_;
			ValaDataType* _tmp434_;
			_tmp420_ = _postcondition_index;
			_postcondition_index = _tmp420_ + 1;
			_tmp421_ = _postcondition_index;
			_tmp422_ = _postcondition_size;
			if (!(_tmp421_ < _tmp422_)) {
				break;
			}
			_tmp423_ = _postcondition_list;
			_tmp424_ = _postcondition_index;
			_tmp425_ = vala_list_get (_tmp423_, _tmp424_);
			postcondition = (ValaExpression*) _tmp425_;
			_tmp426_ = postcondition;
			_tmp427_ = vala_code_node_get_error ((ValaCodeNode*) _tmp426_);
			_tmp428_ = _tmp427_;
			if (_tmp428_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp429_ = postcondition;
			_tmp430_ = vala_expression_get_value_type (_tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = vala_code_context_get_analyzer (context);
			_tmp433_ = _tmp432_;
			_tmp434_ = _tmp433_->bool_type;
			if (!vala_data_type_compatible (_tmp431_, _tmp434_)) {
				ValaExpression* _tmp435_;
				ValaSourceReference* _tmp436_;
				ValaSourceReference* _tmp437_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp435_ = postcondition;
				_tmp436_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp435_);
				_tmp437_ = _tmp436_;
				vala_report_error (_tmp437_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp438_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp439_ = _tmp438_;
	if (_tmp439_ != NULL) {
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp440_;
			ValaBlock* _tmp441_;
			ValaList* _tmp442_;
			gint _body_error_type_size = 0;
			ValaList* _tmp443_;
			gint _tmp444_;
			gint _tmp445_;
			gint _body_error_type_index = 0;
			_tmp440_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp441_ = _tmp440_;
			_tmp442_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp441_);
			_body_error_type_list = _tmp442_;
			_tmp443_ = _body_error_type_list;
			_tmp444_ = vala_collection_get_size ((ValaCollection*) _tmp443_);
			_tmp445_ = _tmp444_;
			_body_error_type_size = _tmp445_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp446_;
				gint _tmp447_;
				gint _tmp448_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp449_;
				gint _tmp450_;
				gpointer _tmp451_;
				gboolean can_propagate_error = FALSE;
				gboolean _tmp464_ = FALSE;
				ValaDataType* _tmp465_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp469_ = FALSE;
				gboolean _tmp470_;
				_tmp446_ = _body_error_type_index;
				_body_error_type_index = _tmp446_ + 1;
				_tmp447_ = _body_error_type_index;
				_tmp448_ = _body_error_type_size;
				if (!(_tmp447_ < _tmp448_)) {
					break;
				}
				_tmp449_ = _body_error_type_list;
				_tmp450_ = _body_error_type_index;
				_tmp451_ = vala_list_get (_tmp449_, _tmp450_);
				body_error_type = (ValaDataType*) _tmp451_;
				can_propagate_error = FALSE;
				{
					ValaList* _method_error_type_list = NULL;
					ValaList* _tmp452_;
					gint _method_error_type_size = 0;
					ValaList* _tmp453_;
					gint _tmp454_;
					gint _tmp455_;
					gint _method_error_type_index = 0;
					_tmp452_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
					_method_error_type_list = _tmp452_;
					_tmp453_ = _method_error_type_list;
					_tmp454_ = vala_collection_get_size ((ValaCollection*) _tmp453_);
					_tmp455_ = _tmp454_;
					_method_error_type_size = _tmp455_;
					_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp456_;
						gint _tmp457_;
						gint _tmp458_;
						ValaDataType* method_error_type = NULL;
						ValaList* _tmp459_;
						gint _tmp460_;
						gpointer _tmp461_;
						ValaDataType* _tmp462_;
						ValaDataType* _tmp463_;
						_tmp456_ = _method_error_type_index;
						_method_error_type_index = _tmp456_ + 1;
						_tmp457_ = _method_error_type_index;
						_tmp458_ = _method_error_type_size;
						if (!(_tmp457_ < _tmp458_)) {
							break;
						}
						_tmp459_ = _method_error_type_list;
						_tmp460_ = _method_error_type_index;
						_tmp461_ = vala_list_get (_tmp459_, _tmp460_);
						method_error_type = (ValaDataType*) _tmp461_;
						_tmp462_ = body_error_type;
						_tmp463_ = method_error_type;
						if (vala_data_type_compatible (_tmp462_, _tmp463_)) {
							can_propagate_error = TRUE;
						}
						_vala_code_node_unref0 (method_error_type);
					}
					_vala_iterable_unref0 (_method_error_type_list);
				}
				_tmp465_ = body_error_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp465_, VALA_TYPE_ERROR_TYPE)) {
					ValaDataType* _tmp466_;
					gboolean _tmp467_;
					gboolean _tmp468_;
					_tmp466_ = body_error_type;
					_tmp467_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp466_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp468_ = _tmp467_;
					_tmp464_ = _tmp468_;
				} else {
					_tmp464_ = FALSE;
				}
				is_dynamic_error = _tmp464_;
				_tmp470_ = can_propagate_error;
				if (!_tmp470_) {
					gboolean _tmp471_;
					_tmp471_ = is_dynamic_error;
					_tmp469_ = !_tmp471_;
				} else {
					_tmp469_ = FALSE;
				}
				if (_tmp469_) {
					ValaDataType* _tmp472_;
					ValaSourceReference* _tmp473_;
					ValaSourceReference* _tmp474_;
					ValaDataType* _tmp475_;
					gchar* _tmp476_;
					gchar* _tmp477_;
					gchar* _tmp478_;
					gchar* _tmp479_;
					_tmp472_ = body_error_type;
					_tmp473_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp472_);
					_tmp474_ = _tmp473_;
					_tmp475_ = body_error_type;
					_tmp476_ = vala_code_node_to_string ((ValaCodeNode*) _tmp475_);
					_tmp477_ = _tmp476_;
					_tmp478_ = g_strdup_printf ("unhandled error `%s'", _tmp477_);
					_tmp479_ = _tmp478_;
					vala_report_warning (_tmp474_, _tmp479_);
					_g_free0 (_tmp479_);
					_g_free0 (_tmp477_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_CREATION_METHOD)) {
		ValaMemberBinding _tmp485_;
		_tmp485_ = self->priv->_binding;
		_tmp484_ = _tmp485_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp484_ = FALSE;
	}
	if (_tmp484_) {
		gboolean _tmp486_;
		_tmp486_ = self->priv->_overrides;
		_tmp483_ = !_tmp486_;
	} else {
		_tmp483_ = FALSE;
	}
	if (_tmp483_) {
		ValaSymbolAccessibility _tmp487_;
		ValaSymbolAccessibility _tmp488_;
		_tmp487_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp488_ = _tmp487_;
		_tmp482_ = _tmp488_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp482_ = FALSE;
	}
	if (_tmp482_) {
		ValaSymbol* _tmp489_;
		ValaSymbol* _tmp490_;
		_tmp489_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp490_ = _tmp489_;
		_tmp481_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp490_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
	} else {
		_tmp481_ = FALSE;
	}
	if (_tmp481_) {
		ValaSymbol* _tmp491_;
		ValaSymbol* _tmp492_;
		ValaAttribute* _tmp493_;
		ValaAttribute* _tmp494_;
		_tmp491_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp492_, "DBus");
		_tmp494_ = _tmp493_;
		_tmp480_ = _tmp494_ != NULL;
		_vala_code_node_unref0 (_tmp494_);
	} else {
		_tmp480_ = FALSE;
	}
	if (_tmp480_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp495_;
		gboolean _tmp496_ = FALSE;
		ValaAttribute* _tmp497_;
		_tmp495_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		dbus_attr = _tmp495_;
		_tmp497_ = dbus_attr;
		if (_tmp497_ == NULL) {
			_tmp496_ = TRUE;
		} else {
			ValaAttribute* _tmp498_;
			_tmp498_ = dbus_attr;
			_tmp496_ = vala_attribute_get_bool (_tmp498_, "visible", TRUE);
		}
		if (_tmp496_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			gboolean _tmp518_ = FALSE;
			gboolean _tmp519_;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			{
				ValaList* _error_type_list = NULL;
				ValaList* _tmp499_;
				gint _error_type_size = 0;
				ValaList* _tmp500_;
				gint _tmp501_;
				gint _tmp502_;
				gint _error_type_index = 0;
				_tmp499_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
				_error_type_list = _tmp499_;
				_tmp500_ = _error_type_list;
				_tmp501_ = vala_collection_get_size ((ValaCollection*) _tmp500_);
				_tmp502_ = _tmp501_;
				_error_type_size = _tmp502_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp503_;
					gint _tmp504_;
					gint _tmp505_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp506_;
					gint _tmp507_;
					gpointer _tmp508_;
					ValaDataType* _tmp509_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp510_;
					ValaErrorDomain* _tmp511_;
					ValaErrorDomain* _tmp512_;
					ValaErrorDomain* _tmp513_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp514_;
					gchar* _tmp515_;
					const gchar* _tmp516_;
					_tmp503_ = _error_type_index;
					_error_type_index = _tmp503_ + 1;
					_tmp504_ = _error_type_index;
					_tmp505_ = _error_type_size;
					if (!(_tmp504_ < _tmp505_)) {
						break;
					}
					_tmp506_ = _error_type_list;
					_tmp507_ = _error_type_index;
					_tmp508_ = vala_list_get (_tmp506_, _tmp507_);
					error_type = (ValaDataType*) _tmp508_;
					_tmp509_ = error_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp509_, VALA_TYPE_ERROR_TYPE)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp510_ = error_type;
					_tmp511_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp510_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp512_ = _tmp511_;
					error_domain = _tmp512_;
					_tmp513_ = error_domain;
					if (_tmp513_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp514_ = error_domain;
					_tmp515_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp514_);
					full_error_domain = _tmp515_;
					_tmp516_ = full_error_domain;
					if (g_strcmp0 (_tmp516_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp517_;
						_tmp517_ = full_error_domain;
						if (g_strcmp0 (_tmp517_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_tmp519_ = throws_gerror;
			if (!_tmp519_) {
				gboolean _tmp520_ = FALSE;
				gboolean _tmp521_;
				_tmp521_ = throws_gioerror;
				if (_tmp521_) {
					gboolean _tmp522_;
					_tmp522_ = throws_gdbuserror;
					_tmp520_ = _tmp522_;
				} else {
					_tmp520_ = FALSE;
				}
				_tmp518_ = !_tmp520_;
			} else {
				_tmp518_ = FALSE;
			}
			if (_tmp518_) {
				ValaSourceReference* _tmp523_;
				ValaSourceReference* _tmp524_;
				_tmp523_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp524_ = _tmp523_;
				vala_report_warning (_tmp524_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp525_;
		ValaMethod* _tmp526_;
		gboolean _tmp535_;
		gboolean _tmp536_;
		gboolean _tmp539_;
		gboolean _tmp542_;
		_tmp525_ = vala_code_context_get_entry_point (context);
		_tmp526_ = _tmp525_;
		if (_tmp526_ != NULL) {
			ValaSourceReference* _tmp527_;
			ValaSourceReference* _tmp528_;
			ValaMethod* _tmp529_;
			ValaMethod* _tmp530_;
			gchar* _tmp531_;
			gchar* _tmp532_;
			gchar* _tmp533_;
			gchar* _tmp534_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp527_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp528_ = _tmp527_;
			_tmp529_ = vala_code_context_get_entry_point (context);
			_tmp530_ = _tmp529_;
			_tmp531_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp530_);
			_tmp532_ = _tmp531_;
			_tmp533_ = g_strdup_printf ("program already has an entry point `%s'", _tmp532_);
			_tmp534_ = _tmp533_;
			vala_report_error (_tmp528_, _tmp534_);
			_g_free0 (_tmp534_);
			_g_free0 (_tmp532_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp535_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp536_ = _tmp535_;
		if (_tmp536_) {
			ValaSourceReference* _tmp537_;
			ValaSourceReference* _tmp538_;
			_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp538_ = _tmp537_;
			vala_report_error (_tmp538_, "\"main\" method cannot throw errors");
		}
		_tmp539_ = self->priv->_is_inline;
		if (_tmp539_) {
			ValaSourceReference* _tmp540_;
			ValaSourceReference* _tmp541_;
			_tmp540_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp541_ = _tmp540_;
			vala_report_error (_tmp541_, "\"main\" method cannot be inline");
		}
		_tmp542_ = self->priv->_coroutine;
		if (_tmp542_) {
			ValaSourceReference* _tmp543_;
			ValaSourceReference* _tmp544_;
			_tmp543_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp544_ = _tmp543_;
			vala_report_error (_tmp544_, "\"main\" method cannot be async");
		}
	}
	_tmp545_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	_tmp546_ = _tmp545_;
	_tmp547_ = _tmp546_ != NULL;
	_vala_code_node_unref0 (_tmp546_);
	if (_tmp547_) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp548_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp549_ = _tmp548_;
	result = !_tmp549_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_VOID_TYPE)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_ARRAY_TYPE)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}


gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint result = 0;
	gint n = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaParameter* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			gint _tmp18_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp12_ = param;
			_tmp13_ = vala_variable_get_initializer ((ValaVariable*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				_tmp11_ = TRUE;
			} else {
				ValaParameter* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = param;
				_tmp16_ = vala_parameter_get_ellipsis (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = _tmp17_;
			}
			if (_tmp11_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp18_ = n;
			n = _tmp18_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}


ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp38_;
	ValaMethod* _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				ValaParameter* param = NULL;
				ValaList* _tmp19_;
				gint _tmp20_;
				gpointer _tmp21_;
				ValaMethod* _tmp22_;
				ValaParameter* _tmp23_;
				ValaParameter* _tmp24_;
				ValaParameter* _tmp25_;
				_tmp16_ = _param_index;
				_param_index = _tmp16_ + 1;
				_tmp17_ = _param_index;
				_tmp18_ = _param_size;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = _param_list;
				_tmp20_ = _param_index;
				_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
				param = (ValaParameter*) _tmp21_;
				_tmp22_ = self->priv->end_method;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_copy (_tmp23_);
				_tmp25_ = _tmp24_;
				vala_callable_add_parameter ((ValaCallable*) _tmp22_, _tmp25_);
				_vala_code_node_unref0 (_tmp25_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp26_;
			gint _param_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _param_index = 0;
			_tmp26_ = vala_method_get_type_parameters (self);
			_param_list = _tmp26_;
			_tmp27_ = _param_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_param_size = _tmp29_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp33_;
				gint _tmp34_;
				gpointer _tmp35_;
				ValaMethod* _tmp36_;
				ValaTypeParameter* _tmp37_;
				_tmp30_ = _param_index;
				_param_index = _tmp30_ + 1;
				_tmp31_ = _param_index;
				_tmp32_ = _param_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _param_list;
				_tmp34_ = _param_index;
				_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
				param = (ValaTypeParameter*) _tmp35_;
				_tmp36_ = self->priv->end_method;
				_tmp37_ = param;
				vala_method_add_type_parameter (_tmp36_, _tmp37_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp38_ = self->priv->end_method;
	_tmp39_ = _vala_code_node_ref0 (_tmp38_);
	result = _tmp39_;
	return result;
}


ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}


ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp32_;
	ValaScope* _tmp33_;
	ValaScope* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaDelegate* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaDelegateType* _tmp38_;
	ValaDelegateType* _tmp39_;
	ValaDelegateType* _tmp40_;
	ValaDelegateType* _tmp41_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp42_;
	ValaParameter* _tmp43_;
	ValaParameter* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaNullLiteral* _tmp47_;
	ValaNullLiteral* _tmp48_;
	ValaParameter* _tmp49_;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	ValaDelegateType* _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaParameter* _tmp55_;
	ValaParameter* _tmp56_;
	ValaArrayList* _tmp57_;
	ValaParameter* _tmp58_;
	ValaParameter* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaParameter* param = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp16_ = _param_index;
			_param_index = _tmp16_ + 1;
			_tmp17_ = _param_index;
			_tmp18_ = _param_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _param_list;
			_tmp20_ = _param_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			_tmp23_ = vala_parameter_get_ellipsis (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_) {
				ValaParameter* _tmp25_;
				ValaParameter* _tmp26_;
				_tmp25_ = param;
				_tmp26_ = _vala_code_node_ref0 (_tmp25_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp26_;
			} else {
				ValaParameter* _tmp27_;
				ValaParameterDirection _tmp28_;
				ValaParameterDirection _tmp29_;
				_tmp27_ = param;
				_tmp28_ = vala_parameter_get_direction (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp30_;
					ValaParameter* _tmp31_;
					_tmp30_ = params;
					_tmp31_ = param;
					vala_collection_add ((ValaCollection*) _tmp30_, _tmp31_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp32_ = glib_ns;
	_tmp33_ = vala_symbol_get_scope (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_scope_lookup (_tmp34_, "AsyncReadyCallback");
	_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp37_ = vala_delegate_type_new (_tmp36_);
	_tmp38_ = _tmp37_;
	_vala_code_node_unref0 (_tmp36_);
	callback_type = _tmp38_;
	_tmp39_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp39_, TRUE);
	_tmp40_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp40_, TRUE);
	_tmp41_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp41_, TRUE);
	_tmp42_ = callback_type;
	_tmp43_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp42_, NULL);
	callback_param = _tmp43_;
	_tmp44_ = callback_param;
	_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_null_literal_new (_tmp46_);
	_tmp48_ = _tmp47_;
	vala_variable_set_initializer ((ValaVariable*) _tmp44_, (ValaExpression*) _tmp48_);
	_vala_code_node_unref0 (_tmp48_);
	_tmp49_ = callback_param;
	_tmp50_ = vala_variable_get_initializer ((ValaVariable*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = callback_type;
	_tmp53_ = vala_data_type_copy ((ValaDataType*) _tmp52_);
	_tmp54_ = _tmp53_;
	vala_expression_set_target_type (_tmp51_, _tmp54_);
	_vala_code_node_unref0 (_tmp54_);
	_tmp55_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp55_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp56_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp56_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp57_ = params;
	_tmp58_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp57_, _tmp58_);
	_tmp59_ = ellipsis;
	if (_tmp59_ != NULL) {
		ValaArrayList* _tmp60_;
		ValaParameter* _tmp61_;
		_tmp60_ = params;
		_tmp61_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp60_, _tmp61_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", 0.1, NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaParameter* param = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaParameter* _tmp34_;
			ValaParameterDirection _tmp35_;
			ValaParameterDirection _tmp36_;
			_tmp28_ = _param_index;
			_param_index = _tmp28_ + 1;
			_tmp29_ = _param_index;
			_tmp30_ = _param_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _param_list;
			_tmp32_ = _param_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			param = (ValaParameter*) _tmp33_;
			_tmp34_ = param;
			_tmp35_ = vala_parameter_get_direction (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp37_;
				ValaParameter* _tmp38_;
				_tmp37_ = params;
				_tmp38_ = param;
				vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}


void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp9_;
				gint _tmp10_;
				gpointer _tmp11_;
				ValaLocalVariable* _tmp12_;
				_tmp6_ = _local_index;
				_local_index = _tmp6_ + 1;
				_tmp7_ = _local_index;
				_tmp8_ = _local_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _local_list;
				_tmp10_ = _local_index;
				_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
				local = (ValaLocalVariable*) _tmp11_;
				_tmp12_ = local;
				vala_collection_add (variables, _tmp12_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}


static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	gboolean _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_closure;
	if (_tmp0_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}


gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaParameter* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->parameters;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->parameters;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaParameter*) _tmp8_;
				_tmp10_ = vala_parameter_get_format_arg (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp12_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean result = FALSE;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ValaMethod* _tmp7_;
	ValaMethod* _tmp8_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaMethod* _tmp15_;
	ValaMethod* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ > 0;
	_vala_iterable_unref0 (_tmp1_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = vala_method_get_base_method (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		_tmp9_ = vala_method_get_base_method (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != self;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMethod* _tmp11_;
		ValaMethod* _tmp12_;
		_tmp11_ = vala_method_get_base_method (self);
		_tmp12_ = _tmp11_;
		_tmp5_ = vala_method_has_error_type_parameter (_tmp12_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	_tmp15_ = vala_method_get_base_interface_method (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		_tmp17_ = vala_method_get_base_interface_method (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_ != self;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		_tmp19_ = vala_method_get_base_interface_method (self);
		_tmp20_ = _tmp19_;
		_tmp13_ = vala_method_has_error_type_parameter (_tmp20_);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VOID_TYPE);
	return result;
}


ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_overrides;
	result = _tmp0_;
	return result;
}


void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_inline;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}


gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}


void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}


gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}


ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}


ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}


ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}


void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_entry_point;
	result = _tmp0_;
	return result;
}


static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}


ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}


void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}


gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}


gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}


gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}


void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}


ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}


void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}


gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_closure;
	result = _tmp0_;
	return result;
}


void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}


gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_coroutine;
	result = _tmp0_;
	return result;
}


void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}


gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_async_callback;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}


static void
vala_method_class_init (ValaMethodClass * klass)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}


static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable *, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable *)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}


static void
vala_method_instance_init (ValaMethod * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}



